  
  ss110410
  sys=ss(ssA,ssB,ssC,ssD);
  
  fmin = -2; fmax = 1;
  magmin = -150; magmax = 50;
  freqVec = logspace(fmin,fmax,5000);
  
  [mag phs] = sub_mybode(sys(2,:),freqVec);
  
  figure(201);
  subplot(5,1,[1 2 3])
  semilogx(freqVec,mag,'LineWidth',2)
  legend('Mathematica Output')
  grid on
  ylim([magmin magmax])
  xlim([10^(fmin) 10^(fmax)])
  title('System Bode Plot','FontSize',16,'FontWeight','bold')
  ylabel('Magnitude (dB)','FontSize',14,'FontWeight','bold')
  set(gca,'FontSize',14)
  
  subplot(5,1,[4 5])
  semilogx(freqVec,phs,'LineWidth',2)
  grid on
  ylim([-180 180])
  xlim([10^(fmin) 10^(fmax)])
  ylabel('Phase (deg)','FontSize',14,'FontWeight','bold')
  xlabel('Frequency (Hz)','FontSize',14,'FontWeight','bold')
  set(gca,'FontSize',14)
  set(gca,'YTick',-180:90:180)
  
  