(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55246,       1200]
NotebookOptionsPosition[     53095,       1120]
NotebookOutlinePosition[     53472,       1137]
CellTagsIndexPosition[     53429,       1134]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\

Seismic Noise Spectrum Densities in Kamioka\
\>", "Subtitle",
 CellChangeTimes->{{3.512093439716625*^9, 3.51209345927906*^9}, {
  3.5127287106780157`*^9, 3.5127287127996197`*^9}, {3.5127289577176514`*^9, 
  3.5127289821628942`*^9}}],

Cell[CellGroupData[{

Cell["Description", "Section",
 CellChangeTimes->{{3.512728995032917*^9, 3.512728999166924*^9}}],

Cell[CellGroupData[{

Cell["About This File", "Subsection",
 CellChangeTimes->{{3.512729199736476*^9, 3.512729230998931*^9}}],

Cell[TextData[{
 "This ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code converts raw seismic noise data (raw_data_kamioka*.dat: measured in \
July 2007)\nto spectrum densities of the ground displacement in Kamioka, with \
interpolation at high frequencies.\n"
}], "Text",
 CellChangeTimes->{{3.512729223573318*^9, 3.512729416686057*^9}, {
  3.5187607942393503`*^9, 3.5187608029441657`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version History", "Subsection",
 CellChangeTimes->{{3.5109077795259247`*^9, 3.510907781974065*^9}}],

Cell["\<\
04/26/10 - First release.
\
\>", "Text",
 CellChangeTimes->{{3.510907788475436*^9, 3.510907825669564*^9}, {
   3.5109981953783193`*^9, 3.5109981973127227`*^9}, 3.5111293590005293`*^9, {
   3.511301582319485*^9, 3.5113015951115074`*^9}, {3.5127252375215144`*^9, 
   3.512725238395116*^9}, {3.512725273198777*^9, 3.5127252867084007`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spectrum Densities", "Section",
 CellChangeTimes->{{3.5127297041009617`*^9, 3.512729713211378*^9}}],

Cell[CellGroupData[{

Cell["Prelimilaries", "Subsection",
 CellChangeTimes->{{3.5127297702918787`*^9, 3.5127297737082844`*^9}}],

Cell[CellGroupData[{

Cell["Spell Check OFF", "Subsubsection",
 CellChangeTimes->{{3.512729759106659*^9, 3.5127297649410686`*^9}}],

Cell["\<\
Disable spell-checking. There are so many variables with similar names that \
it' s useless.\
\>", "Text",
 CellChangeTimes->{{3.5109082158268795`*^9, 3.5109082167409315`*^9}, 
   3.512712667838005*^9, 3.51272978832111*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"General", "::", "spell"}], ",", 
    RowBox[{"General", "::", "spell1"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5106245299962707`*^9, 3.510624543927095*^9}, {
   3.5106247451362486`*^9, 3.5106247454950495`*^9}, {3.5106377976799808`*^9, 
   3.5106377985379825`*^9}, 3.510958382947708*^9, 3.512712667838005*^9, 
   3.51272978832111*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Kernel Directory", "Subsubsection",
 CellChangeTimes->{{3.5101923522344785`*^9, 3.510192358162489*^9}}],

Cell["\<\
Set the current working directory to the directory where this notebook exists.
Imported data and packages should be placed in this directory, or the parent \
directory.\
\>", "Text",
 CellChangeTimes->{{3.5109084715615067`*^9, 3.510908486584366*^9}, {
   3.510908577266553*^9, 3.510908645640464*^9}, {3.5112989682869253`*^9, 
   3.5112990157796416`*^9}, {3.5113016406323876`*^9, 3.5113016472467995`*^9}, 
   3.5114313091697197`*^9, 3.5114315039128633`*^9, {3.512725476732334*^9, 
   3.5127254897115574`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.510192369066908*^9, 3.510958384320511*^9, 
  3.5114313091697197`*^9, 3.5114315039128633`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frequency List (for Interpolation)", "Subsection",
 CellChangeTimes->{{3.505457309098371*^9, 3.5054573134988823`*^9}, {
  3.505457392369238*^9, 3.505457393435096*^9}, {3.507903438769166*^9, 
  3.507903442019352*^9}, {3.5079450761978855`*^9, 3.5079450876015053`*^9}, {
  3.507945118302359*^9, 3.507945140813199*^9}, {3.5109227629829597`*^9, 
  3.510922763595995*^9}, {3.5120936157317343`*^9, 3.5120936216909447`*^9}, {
  3.512093761482791*^9, 3.5120937636823945`*^9}, {3.512728914344575*^9, 
  3.5127289162683783`*^9}, {3.5127290598822308`*^9, 3.512729061426633*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fmin", "=", 
    RowBox[{"2.14", " ", 
     SuperscriptBox["10", "1"], " ", "hertz"}]}], ";", 
   RowBox[{"(*", 
    RowBox[{"minimum", " ", "frequency"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"fmax", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", "2"], "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"maximum", " ", "freqnency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ngrid", "=", "41"}], ";", 
  RowBox[{"(*", 
   RowBox[{"number", " ", "of", " ", "grids"}], "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"freq", "=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"imin", ",", "imax", ",", "dgrid"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"imin", "=", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "fmin"}], "]"}]}], ";", 
      RowBox[{"imax", "=", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "fmax"}], "]"}]}], ";", 
      RowBox[{"dgrid", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"imax", "-", "imin"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"ngrid", "-", "1"}], ")"}]}]}], ";", "\n", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"10", "^", "i"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "imin", ",", "imax", ",", "dgrid"}], "}"}]}], 
       "]"}]}]}], "]"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{"Frequency", " ", "list"}], "*)"}], 
  "\[IndentingNewLine]"}]}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.5120872283608956`*^9, 3.512087235146908*^9}, {
   3.512093253795499*^9, 3.512093255620702*^9}, {3.512093511679552*^9, 
   3.512093512287953*^9}, {3.512093560492038*^9, 3.5120936380085735`*^9}, {
   3.5120939025538387`*^9, 3.512093904971843*^9}, {3.512094569127409*^9, 
   3.51209456972021*^9}, {3.512094612401885*^9, 3.5120946462539444`*^9}, {
   3.5127287966809673`*^9, 3.5127288376934395`*^9}, {3.512729069788248*^9, 
   3.5127290719566517`*^9}, {3.5127291570860014`*^9, 3.512729171734427*^9}, {
   3.5127294537673225`*^9, 3.512729465498543*^9}, {3.5127295031882095`*^9, 
   3.5127295040618105`*^9}, 3.512729858053232*^9, {3.512730263217144*^9, 
   3.512730264917547*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spectrum Density", "Subsection",
 CellChangeTimes->{{3.512092844999179*^9, 3.5120928462783813`*^9}, {
   3.512093773198411*^9, 3.512093801840061*^9}, 3.512094003766816*^9, 
   3.512730121880896*^9}],

Cell[CellGroupData[{

Cell["Import Data", "Subsubsection",
 CellChangeTimes->{{3.509349587233741*^9, 3.5093496116789837`*^9}, {
  3.5093529089867835`*^9, 3.5093529109211864`*^9}, {3.5094146927165117`*^9, 
  3.5094147104225426`*^9}, {3.5094147542742195`*^9, 3.5094147769098597`*^9}, {
  3.512093806083269*^9, 3.512093808282873*^9}, {3.51209385197855*^9, 
  3.512093854614954*^9}, {3.5127295167914333`*^9, 3.512729525340248*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaQ", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<raw_data_kamioka1.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}],
    ";"}], 
  RowBox[{"(*", "normal", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaN", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<raw_data_kamioka2.txt\>\"", ",", "\"\<Table\>\""}], "]"}]}],
    ";"}], 
  RowBox[{"(*", "noisy", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5093498746858473`*^9, 3.5093500179224997`*^9}, {
   3.509350109577461*^9, 3.509350124132286*^9}, {3.5093501986068172`*^9, 
   3.5093502024912243`*^9}, {3.509350465841688*^9, 3.509350466200488*^9}, {
   3.5094147303749776`*^9, 3.509414745335404*^9}, {3.510189685001316*^9, 
   3.5101897112717624`*^9}, 3.5101923934965506`*^9, {3.5120930272519007`*^9, 
   3.5120930275795016`*^9}, {3.5120937319519386`*^9, 3.512093732139139*^9}, {
   3.512093822042097*^9, 3.512093822229297*^9}, {3.5120942699344835`*^9, 
   3.5120943374982023`*^9}, {3.512728931993206*^9, 3.5127289401052203`*^9}, {
   3.5127295375238695`*^9, 3.512729562905114*^9}, {3.512729945834587*^9, 
   3.512729946333788*^9}, {3.512730131131712*^9, 3.512730131459313*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conversion", "Subsubsection",
 CellChangeTimes->{{3.512729529567856*^9, 3.512729531268258*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"kamiokaQ", "[", 
      RowBox[{"[", 
       RowBox[{"n", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"0.00005", 
      RowBox[{
       RowBox[{"kamiokaQ", "[", 
        RowBox[{"[", 
         RowBox[{"n", ",", "2"}], "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"kamiokaQ", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}]}], ")"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Length", "[", "kamiokaQ", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"kamiokaN", "[", 
      RowBox[{"[", 
       RowBox[{"n", ",", "2"}], "]"}], "]"}], "=", 
     RowBox[{"0.00005", 
      RowBox[{
       RowBox[{"kamiokaN", "[", 
        RowBox[{"[", 
         RowBox[{"n", ",", "2"}], "]"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"kamiokaN", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}]}], ")"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Length", "[", "kamiokaN", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5127295426094785`*^9, 3.5127295441850815`*^9}, {
  3.512729575634736*^9, 3.5127295877247577`*^9}, {3.5127299486425915`*^9, 
  3.5127299782826433`*^9}, {3.5127302027202377`*^9, 3.5127302031414385`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolation at High Frequencies", "Subsubsection",
 CellChangeTimes->{{3.5120939645327473`*^9, 3.5120939676215525`*^9}, {
  3.512729615789207*^9, 3.5127296206408157`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaH", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"freq", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"1.5", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "8"}]], 
         SuperscriptBox[
          RowBox[{"freq", "[", 
           RowBox[{"[", "n", "]"}], "]"}], 
          RowBox[{"-", "2"}]]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5120936871174603`*^9, 3.512093729346734*^9}, {
  3.512093975671167*^9, 3.5120939845319824`*^9}, {3.512094698295636*^9, 
  3.5120947413673115`*^9}, {3.5120948397098846`*^9, 3.512094857213115*^9}, {
  3.512729610765998*^9, 3.5127296275204277`*^9}, {3.51272985081482*^9, 
  3.5127298515480213`*^9}, {3.5127299263969526`*^9, 3.512729935148568*^9}, {
  3.5127300025874863`*^9, 3.5127300057698917`*^9}, {3.5127300440991592`*^9, 
  3.5127300551907787`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise Data List", "Subsubsection",
 CellChangeTimes->{{3.5120938401381288`*^9, 3.5120938474857416`*^9}, {
   3.512093944595912*^9, 3.5120939591819377`*^9}, 3.512093999960409*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kamiokaQ", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"kamiokaDQ", ",", "kamiokaH"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaN", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"kamiokaDN", ",", "kamiokaH"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.509351006897241*^9, 3.5093510709353533`*^9}, 
   3.509351170728729*^9, 3.509414781543068*^9, {3.5094151209060636`*^9, 
   3.50941513599129*^9}, {3.512093265448719*^9, 3.512093267585923*^9}, {
   3.5120936803158484`*^9, 3.5120937090822983`*^9}, 3.512093987807988*^9, {
   3.5120940204120455`*^9, 3.512094044701288*^9}, {3.5120943496038237`*^9, 
   3.512094365687452*^9}, {3.5120947480285234`*^9, 3.5120947508365283`*^9}, {
   3.512729649376066*^9, 3.5127296604520855`*^9}, {3.512729899986106*^9, 
   3.5127299007973075`*^9}, {3.5127299383153734`*^9, 3.512729939173375*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Subsubsection",
 CellChangeTimes->{{3.5120940523921013`*^9, 3.5120940567133093`*^9}, {
  3.5120942572984614`*^9, 3.5120942591704645`*^9}, {3.5120944511600018`*^9, 
  3.5120944520648036`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "file", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"file", "=", 
       RowBox[{"OpenWrite", "[", "\"\<kamiokaQ.txt\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", "\[IndentingNewLine]", 
       RowBox[{"file", ",", "\[IndentingNewLine]", 
        RowBox[{"ExportString", "[", 
         RowBox[{"kamiokaQ", ",", "\"\<Table\>\""}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5120931380276957`*^9, 3.5120932074634175`*^9}, {
   3.5120944398499823`*^9, 3.512094444951191*^9}, {3.512094493982077*^9, 
   3.5120944961036806`*^9}, {3.512729825246375*^9, 3.5127298255739756`*^9}, 
   3.5127302268534803`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "file", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"file", "=", 
       RowBox[{"OpenWrite", "[", "\"\<kamiokaN.txt\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", "\[IndentingNewLine]", 
       RowBox[{"file", ",", "\[IndentingNewLine]", 
        RowBox[{"ExportString", "[", 
         RowBox[{"kamiokaN", ",", "\"\<Table\>\""}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5120931380276957`*^9, 3.5120932074634175`*^9}, {
   3.5120944398499823`*^9, 3.512094462516822*^9}, {3.5120945029832926`*^9, 
   3.5120945060720987`*^9}, {3.5127298268999777`*^9, 3.512729827305578*^9}, 
   3.512730223764675*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check", "Subsubsection",
 CellChangeTimes->{{3.5120947942202044`*^9, 3.5120947948598056`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kamiokaQ", ",", "kamiokaN"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512094796310608*^9, 3.512094818712248*^9}, {
  3.512730071258807*^9, 3.5127300983092546`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlXk81HsfxY19HTP2JeQ2M1lnhjIb+n2z35AiKXXtpHKTbEVK1pKlRalU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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVknk41PsfxY19GcPYl7jJMJYZBpnN8v2QkKVcRTctsiZpJ5VSiLLfSlQq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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{-6.1570434710973405`, -27.225556007820384`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-27.631021115928547`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "12"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-23.025850929940457`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-25.14611446614055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-24.495526899999398`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-24.10466059131239, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.82435862615823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.605669425193398`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.426328496537582`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.274312289238956`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.14238474619641, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-27.631021115928547`, 
       FormBox["\"\"", TraditionalForm]}, {-23.025850929940457`, 
       FormBox["\"\"", TraditionalForm]}, {-18.420680743952367`, 
       FormBox["\"\"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-25.14611446614055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-24.495526899999398`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-24.10466059131239, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.82435862615823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.605669425193398`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.426328496537582`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.274312289238956`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-23.14238474619641, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {0, 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {-6.214608098422191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\"\"", TraditionalForm]}, {0, 
       FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\"\"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\"\"", TraditionalForm]}, {-6.214608098422191, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{-6.1570434710973405`, 
   4.605170185988092}, {-27.225556007820384`, -9.591249438598238}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{-6.907755278982137, 
      FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}, {2.302585092994046, 
      FormBox["10", TraditionalForm]}, {4.605170185988092, 
      FormBox["100", TraditionalForm]}, {-6.214608098422191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.809142990314028, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.521460917862246, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.298317366548036, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.115995809754082, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.961845129926823, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.8283137373023015`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.710530701645918, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.659260036932778, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659905, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.3566749439387323, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.0943445622221, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.248495242049359, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.382026634673881, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.499809670330265, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, {{-27.631021115928547`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "12"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-23.025850929940457`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-18.420680743952367`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-13.815510557964274`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-25.14611446614055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-24.495526899999398`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-24.10466059131239, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-23.82435862615823, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-23.605669425193398`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-23.426328496537582`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-23.274312289238956`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-23.14238474619641, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-20.540944280152456`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.890356714011308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.499490405324295`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.219188440170136`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.000499239205308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.821158310549492`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.669142103250866`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.537214560208316`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.935774094164366`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.285186528023216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.894320219336205`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.614018254182046`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.395329053217216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.215988124561399`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.063971917262773`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.932044374220226`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.330603908176274`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.680016342035124`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.289150033348113`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.008848068193954`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.790158867229126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.610817938573309, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.458801731274683, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.326874188232134, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{{3.512094809851432*^9, 3.512094861565523*^9}, {
   3.512729836540795*^9, 3.5127298633572416`*^9}, 3.512729906335317*^9, {
   3.5127299957546744`*^9, 3.5127300116043024`*^9}, {3.5127300493095684`*^9, 
   3.512730057671183*^9}, 3.512730099588457*^9, 3.512730269581955*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{839, 572},
WindowMargins->{{59, Automatic}, {Automatic, 34}},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (2008\:5e7412\:670810\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 243, 6, 77, "Subtitle"],
Cell[CellGroupData[{
Cell[835, 32, 96, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[956, 37, 103, 1, 36, "Subsection"],
Cell[1062, 40, 401, 9, 65, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1500, 54, 105, 1, 36, "Subsection"],
Cell[1608, 57, 346, 7, 47, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2003, 70, 105, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[2133, 75, 105, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[2263, 80, 108, 1, 27, "Subsubsection"],
Cell[2374, 83, 233, 5, 29, "Text"],
Cell[2610, 90, 437, 10, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3084, 105, 113, 1, 27, "Subsubsection"],
Cell[3200, 108, 518, 9, 47, "Text"],
Cell[3721, 119, 279, 7, 52, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4049, 132, 572, 7, 36, "Subsection"],
Cell[4624, 141, 3628, 74, 172, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[8289, 220, 204, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[8518, 227, 405, 5, 27, "Subsubsection"],
Cell[8926, 234, 1231, 24, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10194, 263, 101, 1, 27, "Subsubsection"],
Cell[10298, 266, 1578, 47, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11913, 318, 179, 2, 27, "Subsubsection"],
Cell[12095, 322, 1050, 26, 54, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13182, 353, 192, 2, 27, "Subsubsection"],
Cell[13377, 357, 919, 18, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14333, 380, 207, 3, 27, "Subsubsection"],
Cell[14543, 385, 930, 20, 192, "Input"],
Cell[15476, 407, 930, 20, 192, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16443, 432, 100, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[16568, 437, 308, 7, 31, "Input"],
Cell[16879, 446, 36152, 667, 239, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
