(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    554216,      12499]
NotebookOptionsPosition[    521175,      11512]
NotebookOutlinePosition[    522648,      11559]
CellTagsIndexPosition[    522296,      11548]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\

iLCGT Type-A VIS Rigid-Body Model\
\>", "Subtitle",
 CellChangeTimes->{{3.5109088633079133`*^9, 3.510908886523241*^9}, {
   3.5109089295327015`*^9, 3.5109089606324797`*^9}, {3.510998012935999*^9, 
   3.510998040953648*^9}, {3.511147199138874*^9, 3.511147201837679*^9}, 
   3.5111528655524273`*^9, {3.5112140422561007`*^9, 3.511214046727357*^9}, {
   3.511333214700381*^9, 3.5113332166191845`*^9}, {3.5113333850886836`*^9, 
   3.511333385931085*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Section",
 CellChangeTimes->{{3.5054543012647257`*^9, 3.505454323450515*^9}, {
   3.510907714373198*^9, 3.5109077167963367`*^9}, 3.510908178125723*^9}],

Cell[CellGroupData[{

Cell["About This Model", "Subsection",
 CellChangeTimes->{{3.510394061790189*^9, 3.5103940822418246`*^9}, {
  3.510907707872826*^9, 3.5109077115670376`*^9}}],

Cell["\<\
A 3-D rigid-body model of type-A vibration isolation system for iLCGT.
* Full system with a pre-isolator stage, SAS and suspension system (payload)
* GAS filters work as ideal vertical springs (no saturation at high \
frequencies)
\
\>", "Text",
 CellChangeTimes->{{3.505454452255293*^9, 3.505454488921332*^9}, {
   3.5077129980500813`*^9, 3.5077130433695107`*^9}, {3.5078876676897573`*^9, 
   3.5078878698873224`*^9}, {3.507891500540996*^9, 3.5078915759671288`*^9}, {
   3.508056919436692*^9, 3.508056920357094*^9}, {3.510355123371209*^9, 
   3.51035514664645*^9}, {3.5103918876678514`*^9, 3.5103918944872417`*^9}, {
   3.510623942883439*^9, 3.510624004228547*^9}, {3.510624128264365*^9, 
   3.5106243303003197`*^9}, {3.510907735689417*^9, 3.510907763414003*^9}, {
   3.510909653179636*^9, 3.510909653834837*^9}, {3.5109584516502295`*^9, 
   3.5109584654874535`*^9}, {3.5109980702504997`*^9, 3.510998172181079*^9}, {
   3.5111293295678463`*^9, 3.5111293498580065`*^9}, {3.511129506365958*^9, 
   3.511129532635461*^9}, {3.511214054289789*^9, 3.511214075686013*^9}, {
   3.5127249187349544`*^9, 3.5127249762990556`*^9}, {3.512725013333521*^9, 
   3.5127252632303596`*^9}, 3.5145090605310373`*^9, {3.5166682629870987`*^9, 
   3.5166682794295278`*^9}, {3.517697911916273*^9, 3.5176979299655046`*^9}, {
   3.518761187345641*^9, 3.5187611902940464`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version History", "Subsection",
 CellChangeTimes->{{3.5109077795259247`*^9, 3.510907781974065*^9}}],

Cell[CellGroupData[{

Cell["05/16/10 - v1.1 release.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510907788475436*^9, 3.510907825669564*^9}, {
   3.5109981953783193`*^9, 3.5109981973127227`*^9}, 3.5111293590005293`*^9, {
   3.511301582319485*^9, 3.5113015951115074`*^9}, {3.5127252375215144`*^9, 
   3.512725238395116*^9}, {3.512725273198777*^9, 3.5127252867084007`*^9}, {
   3.518761207220076*^9, 3.5187612096224804`*^9}, {3.518761284050211*^9, 
   3.5187612867334156`*^9}, {3.5187613215994773`*^9, 3.518761324781883*^9}, {
   3.518761577024929*^9, 3.5187615842633414`*^9}, 3.5187616316718245`*^9}],

Cell["\<\
Eddy current damping is taken into account.
\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510907788475436*^9, 3.510907825669564*^9}, {
   3.5109981953783193`*^9, 3.5109981973127227`*^9}, 3.5111293590005293`*^9, {
   3.511301582319485*^9, 3.5113015951115074`*^9}, {3.5127252375215144`*^9, 
   3.512725238395116*^9}, {3.512725273198777*^9, 3.5127252867084007`*^9}, {
   3.518761207220076*^9, 3.5187612096224804`*^9}, {3.518761284050211*^9, 
   3.5187612867334156`*^9}, 3.5187613215994773`*^9, {3.5187615100072107`*^9, 
   3.5187615412696657`*^9}, {3.518761603529375*^9, 3.5187616316718245`*^9}}]
}, Closed]],

Cell["04/26/10 - First release.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510907788475436*^9, 3.510907825669564*^9}, {
   3.5109981953783193`*^9, 3.5109981973127227`*^9}, 3.5111293590005293`*^9, {
   3.511301582319485*^9, 3.5113015951115074`*^9}, {3.5127252375215144`*^9, 
   3.512725238395116*^9}, {3.512725273198777*^9, 3.5127252867084007`*^9}, {
   3.518761207220076*^9, 3.5187612096224804`*^9}, {3.518761284050211*^9, 
   3.5187612867334156`*^9}, {3.5187613215994773`*^9, 3.518761324781883*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinate System", "Subsection",
 CellChangeTimes->{{3.5103935324149256`*^9, 3.510393535246088*^9}, {
  3.5103940971398506`*^9, 3.5103941199158907`*^9}}],

Cell["\<\
(VIRGO's Reference)
X-axis:  Transversal, Y-axis: Vertical, Z-axis: Longitudinal (Beam-axis)
Pitch: Rotation around x-axis, Yaw: Rotation around y-axis, Roll: Rotation \
around z-axis
\
\>", "Text",
 CellChangeTimes->{{3.5103935528940973`*^9, 3.510393696350746*^9}, {
   3.510394123098296*^9, 3.5103943553983045`*^9}, {3.510395802459265*^9, 
   3.510395835515723*^9}, {3.510624429500894*^9, 3.510624435179304*^9}, {
   3.5109079621453695`*^9, 3.510908048918333*^9}, {3.5109081088107586`*^9, 
   3.5109081217995014`*^9}, 3.512725284446397*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
 CellChangeTimes->{{3.509358217720311*^9, 3.5093582194831142`*^9}, {
  3.509358283131226*^9, 3.5093582840048275`*^9}, {3.5109081602447004`*^9, 
  3.5109081665040584`*^9}}],

Cell[CellGroupData[{

Cell["Clear Values", "Subsection",
 CellChangeTimes->{{3.5106377661991253`*^9, 3.5106377726731367`*^9}, {
  3.510908300193705*^9, 3.510908303030867*^9}, {3.510908796062067*^9, 
  3.5109088095318375`*^9}}],

Cell["Clear values and definitions of all the symbols.", "Text",
 CellChangeTimes->{{3.5109082594663754`*^9, 3.510908268789909*^9}, {
  3.5109083050389824`*^9, 3.5109083170736704`*^9}, {3.510908356790942*^9, 
  3.5109083909098935`*^9}, {3.5109084458170342`*^9, 3.510908446235058*^9}, {
  3.5112987930589027`*^9, 3.5112987971351357`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], " ", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5101923438572636`*^9, 3.510192346852469*^9}, {
   3.5105415211971025`*^9, 3.5105415220863047`*^9}, {3.5106246850761433`*^9, 
   3.5106246954033613`*^9}, {3.5106377478222933`*^9, 3.510637755653507*^9}, 
   3.5109583818557067`*^9, {3.511298860191743*^9, 3.511298870315322*^9}, {
   3.5187616715142946`*^9, 3.5187616783159065`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alart Switch OFF", "Subsection",
 CellChangeTimes->{{3.5093582266123266`*^9, 3.509358235441942*^9}, {
  3.510908785327453*^9, 3.510908786812538*^9}, {3.512712672876814*^9, 
  3.51271269337525*^9}}],

Cell[CellGroupData[{

Cell["\<\
Disable spell-checking. There are so many variables with similar names that \
it' s useless.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109082158268795`*^9, 3.5109082167409315`*^9}, 
   3.512712667838005*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"General", "::", "spell"}], ",", 
    RowBox[{"General", "::", "spell1"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5106245299962707`*^9, 3.510624543927095*^9}, {
   3.5106247451362486`*^9, 3.5106247454950495`*^9}, {3.5106377976799808`*^9, 
   3.5106377985379825`*^9}, 3.510958382947708*^9, 3.512712667838005*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disable the LinerSolve alart.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511418292811921*^9, 3.5114183319367895`*^9}, {
  3.5114185384811525`*^9, 3.5114185527395773`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"LinearSolve", "::", "luc"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5110035674345737`*^9, 3.5110035736277847`*^9}, {
  3.5114183319367895`*^9, 3.511418334307994*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Kernel Directory", "Subsection",
 CellChangeTimes->{{3.5101923522344785`*^9, 3.510192358162489*^9}}],

Cell["\<\
Set the current working directory to the directory where this notebook exists.
Imported data and packages should be placed in this directory, or the parent \
directory.\
\>", "Text",
 CellChangeTimes->{{3.5109084715615067`*^9, 3.510908486584366*^9}, {
   3.510908577266553*^9, 3.510908645640464*^9}, {3.5112989682869253`*^9, 
   3.5112990157796416`*^9}, {3.5113016406323876`*^9, 3.5113016472467995`*^9}, 
   3.5114313091697197`*^9, 3.5114315039128633`*^9, {3.512725476732334*^9, 
   3.5127254897115574`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.510192369066908*^9, 3.510958384320511*^9, 
  3.5114313091697197`*^9, 3.5114315039128633`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import Packages", "Subsection",
 CellChangeTimes->{{3.509358549500699*^9, 3.5093585508579016`*^9}, {
  3.510908771531664*^9, 3.510908776462946*^9}, {3.511431144979431*^9, 
  3.5114311459622326`*^9}}],

Cell[CellGroupData[{

Cell["Standard package for use in plotting transfer functions.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109086828285904`*^9, 3.510908700501601*^9}, {
  3.5109087550517216`*^9, 3.5109087629341726`*^9}, {3.5114311527794447`*^9, 
  3.511431169050273*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<PlotLegends`\>\""}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.5093585572227125`*^9, 3.5109583868009152`*^9, 3.5114311527794447`*^9, {
   3.5114314680016003`*^9, 3.5114314701388035`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Manual package for modeling and simulating vibration isolation systems.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5114311609694595`*^9, 3.511431194384718*^9}, 
   3.511431248501213*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<../visUtil.m\>\""}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5114311961163206`*^9, 3.5114312118099484`*^9}, {
   3.5114312446636057`*^9, 3.511431248501213*^9}, {3.51143132645455*^9, 
   3.511431328217353*^9}, {3.5114314592187843`*^9, 3.51143146218279*^9}, {
   3.511432205581296*^9, 3.5114322437545633`*^9}, 3.5126997613310375`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unit System", "Subsection",
 CellChangeTimes->{{3.507762673125991*^9, 3.5077626748989697`*^9}, {
  3.507887916125967*^9, 3.5078879248934684`*^9}, {3.510909011354381*^9, 
  3.5109090133324947`*^9}}],

Cell["\<\
MKS unit system is set as defalut. If you want to use another unit system or \
add units, please edit this subsection.\
\>", "Text",
 CellChangeTimes->{{3.510909029719432*^9, 3.5109090347067165`*^9}, {
  3.5112991343644247`*^9, 3.511299152603468*^9}, {3.5112992219044313`*^9, 
  3.5112992467198505`*^9}, {3.5112993190699887`*^9, 3.5112993260563884`*^9}, {
  3.5112996874180574`*^9, 3.5112997335146937`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kg", "=", "1.0"}], ";", 
   RowBox[{"meter", "=", "1.0"}], ";", 
   RowBox[{"rad", "=", "1.0"}], ";", 
   RowBox[{"sec", "=", "1.0"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Basical", " ", "Set"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cm", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]], "meter"}]}], ";", 
   RowBox[{"mm", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "meter"}]}], ";", " ", 
   RowBox[{"km", "=", 
    RowBox[{
     SuperscriptBox["10", "3"], "meter"}]}], ";"}], 
  RowBox[{"(*", "Length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gram", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "kg"}]}], ";", " ", 
   RowBox[{"mg", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]], "kg"}]}], ";"}], 
  RowBox[{"(*", "Mass", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deg", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"N", "[", "Pi", "]"}], "/", "180"}], ")"}], "rad"}]}], ";", 
   " ", 
   RowBox[{"mrad", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "rad"}]}], ";"}], 
  RowBox[{"(*", "Angle", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hertz", "=", 
    RowBox[{"1", "/", "sec"}]}], ";", 
   RowBox[{"mHz", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "hertz"}]}], ";", " ", 
   RowBox[{"kHz", "=", 
    RowBox[{
     SuperscriptBox["10", "3"], "hertz"}]}], ";"}], 
  RowBox[{"(*", "Frequency", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newton", "=", 
    RowBox[{"kg", " ", 
     RowBox[{"meter", "/", 
      SuperscriptBox["sec", "2"]}]}]}], ";", 
   RowBox[{"pascal", "=", 
    RowBox[{"newton", "/", 
     SuperscriptBox["meter", "2"]}]}], ";"}], 
  RowBox[{"(*", "Force", "*)"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.505459898591352*^9, 3.5054599656528482`*^9}, {
   3.505460214618761*^9, 3.505460246823139*^9}, {3.505460353839837*^9, 
   3.505460386329871*^9}, {3.5054609432258244`*^9, 3.505460943823134*^9}, {
   3.507717502489213*^9, 3.50771751561602*^9}, {3.507763954546257*^9, 
   3.50776398513273*^9}, {3.507887947930786*^9, 3.5078880664505653`*^9}, {
   3.507888099557459*^9, 3.50788814661615*^9}, {3.507888389647051*^9, 
   3.5078883993246045`*^9}, {3.507888436328721*^9, 3.507888448082393*^9}, 
   3.5109090416871157`*^9, 3.5109090778881865`*^9, {3.510909120506624*^9, 
   3.5109091273490157`*^9}, {3.5109092151620665`*^9, 3.510909215271267*^9}, {
   3.511300808916927*^9, 3.511300836123375*^9}, {3.511300869803834*^9, 
   3.5113008723622384`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Constant Values", "Section",
 CellChangeTimes->{{3.51142744973974*^9, 3.5114274556677504`*^9}, {
  3.511427538098295*^9, 3.5114275409375*^9}, {3.5126981805490613`*^9, 
  3.512698220251131*^9}, {3.5126995238362207`*^9, 3.5126995252714233`*^9}, {
  3.512709794472556*^9, 3.5127098002289667`*^9}}],

Cell[CellGroupData[{

Cell["Version", "Subsection",
 CellChangeTimes->{{3.5127256954603186`*^9, 3.5127256967083206`*^9}}],

Cell["\<\
Mass & MOI: Proposed by R. Desalvo in 04/26/11 (TM 10-kg version, but reduced \
IRM [60 kg] to achieve 300 kg payload)
Wire Specification: Proposed by E. Majorana in 04/18/11 (TM 10-kg version)
\
\>", "Text",
 CellChangeTimes->{{3.5127257083459415`*^9, 3.5127258858898535`*^9}, {
  3.512772484472748*^9, 3.5127726066521626`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Physical Constant", "Subsection",
 CellChangeTimes->{{3.5126995351930404`*^9, 3.512699537813845*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "=", 
    RowBox[{"9.81", " ", 
     RowBox[{"meter", "/", 
      SuperscriptBox["sec", "2"]}]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"local", " ", "gravity", " ", "constant"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.507762704553597*^9, 3.5077627272070923`*^9}, {
   3.507763249921364*^9, 3.507763251940638*^9}, 3.507765884859458*^9, {
   3.5078741427757235`*^9, 3.5078741430097237`*^9}, {3.5078882875472107`*^9, 
   3.5078883798324895`*^9}, 3.510910789651633*^9, {3.5127255934829397`*^9, 
   3.512725594387741*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Material Property", "Subsection",
 CellChangeTimes->{{3.5078885954778233`*^9, 3.5078886008591313`*^9}}],

Cell[CellGroupData[{

Cell["Usage note for symbols", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127058900508986`*^9, 3.5127058993329153`*^9}, {
  3.512706096907262*^9, 3.512706100963269*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "::", "usage"}], "=", 
   "\"\<rho['mat'] is volume density of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"young", "::", "usage"}], "=", 
   "\"\<young['mat'] is Young's modulus of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "::", "usage"}], "=", 
   "\"\<phi['mat'] is loss angle of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"poisson", "::", "usage"}], "=", 
   "\"\<poisson['mat'] is Poisson ratio of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127059638078284`*^9, 3.512706105643277*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Maraging Steel (MS)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5103965360817537`*^9, 3.510396544037768*^9}, 
   3.5127059285829663`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"8.0", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", 
  RowBox[{
   RowBox[{"young", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"195", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<MS\>\"", "]"}], "=", "0.9"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.507889441421377*^9}, {3.5078960325775614`*^9, 
   3.5078960964908733`*^9}, {3.5103965183445225`*^9, 3.510396588887847*^9}, {
   3.510909272975768*^9, 3.510909298450613*^9}, 3.510910792100837*^9, {
   3.510917538160895*^9, 3.5109175628401384`*^9}, {3.5110012657717195`*^9, 
   3.5110013428284593`*^9}, {3.5113005011767845`*^9, 
   3.5113005170108128`*^9}, {3.511300658220662*^9, 3.511300688422315*^9}, {
   3.512355711763343*^9, 3.512355728764315*^9}, {3.512699581587522*^9, 
   3.5126995827419243`*^9}, 3.5127059285829663`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tungsten (W)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5103965944882565`*^9, 3.5103965978578625`*^9}, 
   3.512705931312971*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"19.25", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"young", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"411", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<W\>\"", "]"}], "=", "0.3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.5078894378489714`*^9}, {3.507896109594897*^9, 
   3.507896113026903*^9}, {3.5103966082162805`*^9, 3.5103966252515106`*^9}, 
   3.5107455826730013`*^9, {3.5109092790285788`*^9, 3.5109092799021807`*^9}, 
   3.510910793146039*^9, {3.510917571108153*^9, 3.510917577987765*^9}, {
   3.5110013469000664`*^9, 3.5110013527812767`*^9}, {3.5110014676084857`*^9, 
   3.5110014906029263`*^9}, {3.5113002673217673`*^9, 
   3.5113002845129976`*^9}, {3.5113004092804227`*^9, 3.511300412774829*^9}, {
   3.511300542797658*^9, 3.5113005435620594`*^9}, {3.5113006258066044`*^9, 
   3.511300626805006*^9}, 3.51130069099632*^9, {3.512355660889433*^9, 
   3.5123556611114454`*^9}, {3.512699585487529*^9, 3.5126995863299303`*^9}, 
   3.512705931312971*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["C-70 Steel (C70)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5107455881642113`*^9, 3.5107455934682207`*^9}, 
   3.510910365408888*^9, 3.512705934167776*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"7.8", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"young", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"200", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<C70\>\"", "]"}], "=", "0.3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.5078894378489714`*^9}, {3.507896109594897*^9, 
   3.507896113026903*^9}, {3.5103966082162805`*^9, 3.5103966252515106`*^9}, {
   3.5107455826730013`*^9, 3.5107456317818875`*^9}, {3.5109092830533857`*^9, 
   3.5109092838801875`*^9}, 3.510910794362841*^9, {3.510917573572957*^9, 
   3.510917582168572*^9}, {3.5110014921005287`*^9, 3.5110015006025434`*^9}, {
   3.5113005549188795`*^9, 3.511300557196483*^9}, {3.5113006740078897`*^9, 
   3.5113006841791077`*^9}, {3.512355689126048*^9, 3.512355699808659*^9}, {
   3.512699588825935*^9, 3.512699589590336*^9}, 3.512705934167776*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bodies", "Subsection",
 CellChangeTimes->{{3.5106251018152747`*^9, 3.5106251044516797`*^9}, {
  3.5109104340490084`*^9, 3.5109104353594103`*^9}}],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.511311704314874*^9, 3.5113117105236855`*^9}, 
   3.5127091783182745`*^9}],

Cell[CellGroupData[{

Cell["Usage note for symbols.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113114603616457`*^9, 3.5113114747136707`*^9}, {
   3.511311505554925*^9, 3.511311549718603*^9}, 3.5126982410615673`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mass", "::", "usage"}], "=", "\"\<mass of bodies\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moix", "::", "usage"}], "=", 
   "\"\<moment of inertia around x-axis (pitch)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moiy", "::", "usage"}], "=", 
   "\"\<moment of inertia around y-axis (yaw)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moiz", "::", "usage"}], "=", 
   "\"\<moment of inertia around z-axis (roll)\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113096085915933`*^9, 3.5113098531844225`*^9}, {
   3.511309893479294*^9, 3.5113099178465366`*^9}, 3.511309950247793*^9, {
   3.511311488410495*^9, 3.511311526942563*^9}, 3.5113153674308243`*^9, {
   3.5126982410615673`*^9, 3.5126983525861635`*^9}, {3.512725606945763*^9, 
   3.5127256082405653`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511307444101391*^9, 3.511307473382642*^9}, {
  3.511308315877722*^9, 3.511308321212931*^9}, {3.511311718276899*^9, 
  3.5113117198681016`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "      ", 
   RowBox[{
   "F0", ",", "  ", "F1", ",", "  ", "F2", ",", "  ", "F3", ",", "  ", "F4", 
    ",", "  ", "IM", ",", "  ", "IRM", ",", "  ", "TM", ",", "  ", "RM", ",", 
    "  ", "MD"}], "   ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mass", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "544.", ",", "106.", ",", "89.4", ",", "86.5", ",", "83.7", ",", 
        "55.0", ",", "61.0", ",", "10.7", ",", "90.3", ",", "30.0"}], "}"}], 
      "kg"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moix", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "30.0", ",", "4.00", ",", "4.00", ",", "4.00", ",", "4.00", ",", 
        "0.80", ",", "2.80", ",", ".051", ",", "2.58", ",", "0.92"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiy", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "40.0", ",", "6.44", ",", "6.44", ",", "6.44", ",", "6.44", ",", 
        "1.88", ",", "5.85", ",", ".051", ",", "2.58", ",", "1.83"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiz", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "30.0", ",", "4.00", ",", "4.00", ",", "4.00", ",", "4.00", ",", 
        "1.22", ",", "3.60", ",", ".084", ",", "4.56", ",", "0.92"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511304710127389*^9, 3.511304728535421*^9}, {
   3.5113047674418893`*^9, 3.5113048860488977`*^9}, {3.5113050074015107`*^9, 
   3.51130514904976*^9}, {3.5113051832138195`*^9, 3.51130538269137*^9}, {
   3.511305417479431*^9, 3.511305551904867*^9}, {3.5113058796614428`*^9, 
   3.511305880269844*^9}, {3.5113061359454927`*^9, 3.5113061641503425`*^9}, {
   3.511306624819152*^9, 3.5113066315271635`*^9}, 3.511307473382642*^9, {
   3.511308315877722*^9, 3.511308321212931*^9}, {3.511386760794197*^9, 
   3.511386828105047*^9}, {3.5113869415443287`*^9, 3.511386973617985*^9}, {
   3.5114939721454124`*^9, 3.511493984048234*^9}, {3.5114942197842493`*^9, 
   3.511494225041459*^9}, {3.51149502317006*^9, 3.5114950728873477`*^9}, {
   3.512355081541296*^9, 3.5123550980172386`*^9}, {3.5123562660702295`*^9, 
   3.512356447654548*^9}, {3.5126972323489933`*^9, 3.512697253565031*^9}, {
   3.5126973286319647`*^9, 3.5126973856968646`*^9}, {3.5126974251337337`*^9, 
   3.512697450421378*^9}, {3.512697521946704*^9, 3.512697534910327*^9}, {
   3.5126975666875825`*^9, 3.5126976978682127`*^9}, {3.512697732281873*^9, 
   3.512697844960871*^9}, {3.5126983687633915`*^9, 3.5126983919918327`*^9}, {
   3.5127063777233553`*^9, 3.51270638635017*^9}, {3.512711677657466*^9, 
   3.5127117195591393`*^9}, {3.5127117556108027`*^9, 
   3.5127119120322776`*^9}, {3.5127256372098165`*^9, 3.5127256429818263`*^9}, 
   3.512730602065339*^9, {3.512772450558288*^9, 3.5127724661115155`*^9}, {
   3.5128017081234455`*^9, 3.512801921656621*^9}, 3.5128020728052864`*^9, {
   3.514165185307804*^9, 3.5141652510775194`*^9}, {3.514165468120701*^9, 
   3.5141655106619754`*^9}, {3.51416578654846*^9, 3.5141657950816746`*^9}, {
   3.5141669029020205`*^9, 3.514166980980158*^9}, {3.514167018919424*^9, 
   3.514167243513019*^9}, {3.514167307972332*^9, 3.5141673132607417`*^9}, {
   3.514509115443134*^9, 3.514509152695999*^9}, {3.514509215439309*^9, 
   3.5145092517717733`*^9}, {3.5145096552664824`*^9, 3.5145096554068823`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Labels", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5127067034831276`*^9, 3.51270670477793*^9}, 
   3.512707796343047*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"b$F0", "=", "1"}], ";", 
  RowBox[{"b$F1", "=", "2"}], ";", 
  RowBox[{"b$F2", "=", "3"}], ";", 
  RowBox[{"b$F3", "=", "4"}], ";", 
  RowBox[{"b$F4", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b$IM", "=", "6"}], ";", 
  RowBox[{"b$IRM", "=", "7"}], ";", 
  RowBox[{"b$TM", "=", "8"}], ";", 
  RowBox[{"b$RM", "=", "9"}], ";", 
  RowBox[{"b$MD", "=", "10"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5127067095515385`*^9, 3.5127068375965633`*^9}, {
   3.512706877985034*^9, 3.512706889950255*^9}, 3.512707796343047*^9, {
   3.512725650142239*^9, 3.5127256522014427`*^9}, {3.5145092564049816`*^9, 
   3.5145092621925917`*^9}, 3.5145109542651634`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverted pendulum legs", "Subsubsection",
 CellChangeTimes->{{3.511307457985415*^9, 3.5113074775322495`*^9}, 
   3.5113117756693993`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"leg1", ",", " ", "leg2", ",", " ", "leg3"}], "        ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"massIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2.00", ",", "2.00", ",", "2.00"}], "}"}], "kg"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moixIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".042", ",", ".042", ",", ".042"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiyIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".005", ",", ".005", ",", ".005"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moizIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".042", ",", ".042", ",", ".042"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5113056136653757`*^9, 3.511305645770232*^9}, {
   3.511305696844722*^9, 3.511305723442768*^9}, {3.5113058208025393`*^9, 
   3.5113058834990497`*^9}, {3.5113061673951483`*^9, 3.511306186473982*^9}, {
   3.5113066350371695`*^9, 3.511306643242784*^9}, 3.5113074775322495`*^9, 
   3.5113117756693993`*^9, {3.5127057880735197`*^9, 3.5127058217539787`*^9}, {
   3.512706159588172*^9, 3.5127061710385923`*^9}, {3.51270807138713*^9, 
   3.5127081551904774`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wires", "Subsection",
 CellChangeTimes->{{3.511306120572666*^9, 3.5113061311874847`*^9}}],

Cell[CellGroupData[{

Cell["Properties and Geometric Values", "Subsubsection",
 CellChangeTimes->{{3.511311536146579*^9, 3.5113115410137873`*^9}, {
  3.5113118928256054`*^9, 3.5113118955244102`*^9}}],

Cell[CellGroupData[{

Cell["Usage note for symbols.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113114603616457`*^9, 3.5113114747136707`*^9}, {
   3.511311505554925*^9, 3.511311549718603*^9}, 3.5126982410615673`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nw", "::", "usage"}], "=", "\"\<number of wires\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matw", "::", "usage"}], "=", "\"\<wire material\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lNw", "::", "usage"}], "=", "\"\<natural length of wires\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dw", "::", "usage"}], "=", "\"\<wire diameters\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dxu", "::", "usage"}], "=", 
   "\"\<x-separation of wires & COM at upper suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzu", "::", "usage"}], "=", 
   "\"\<z-separation of wires & COM at upper suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dxl", "::", "usage"}], "=", 
   "\"\<x-separation of wires & COM at lower suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzl", "::", "usage"}], "=", 
   "\"\<z-separation of wires & COM at lower suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyu", "::", "usage"}], "=", 
   "\"\<height of wire break-off below COM at upper body\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyl", "::", "usage"}], "=", 
   "\"\<height of wire break-off above COM at lower body\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113096085915933`*^9, 3.5113098531844225`*^9}, {
   3.511309893479294*^9, 3.5113099178465366`*^9}, 3.511309950247793*^9, {
   3.511311488410495*^9, 3.511311526942563*^9}, 3.5113153674308243`*^9, 
   3.5126982410615673`*^9, 3.512706179431407*^9, {3.512711537023219*^9, 
   3.512711552982047*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113115557402134`*^9, 3.5113115654278307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{
   "F1", ",", "  ", "F2", ",", "  ", "F3", ",", "  ", "F4", ",", "  ", "IM", 
    ",", "  ", "IRM", ",", "  ", "TM", ",", "  ", "RM", ",", "  ", "MD"}], 
   "     ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"matw", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<MS\>\"", ",", "\"\<MS\>\"", ",", "\"\<MS\>\"", ",", "\"\<MS\>\"", 
       ",", "\"\<MS\>\"", ",", "\"\<C70\>\"", ",", "\"\<W\>\"", ",", 
       "\"\<C70\>\"", ",", "\"\<C70\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lNw", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2.100", "}"}], ",", 
        RowBox[{"{", "2.100", "}"}], ",", 
        RowBox[{"{", "2.350", "}"}], ",", 
        RowBox[{"{", "2.085", "}"}], ",", 
        RowBox[{"{", "2.084", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.734", ",", "1.734", ",", "1.734"}], "}"}]}], "}"}], 
      "meter"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dyu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"200.", ",", "200.", ",", "200."}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dyl", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "5.0"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00"}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dw", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3.20", "}"}], ",", 
        RowBox[{"{", "3.00", "}"}], ",", 
        RowBox[{"{", "2.80", "}"}], ",", 
        RowBox[{"{", "2.50", "}"}], ",", 
        RowBox[{"{", "2.10", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.50", ",", "0.50", ",", "0.50", ",", "0.50"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.15", ",", "0.15", ",", "0.15", ",", "0.15"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.70", ",", "0.70", ",", "0.70", ",", "0.70"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.30", ",", "0.30", ",", "0.30"}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dxu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
        "30.0", ",", "12.5", ",", "28.9", ",", "0.00"}], "}"}], "cm"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dzu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
        "25.0", ",", "1.50", ",", "3.50", ",", "0.00"}], "}"}], "cm"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dxl", "=", "dxu"}], ";", 
    RowBox[{"dzl", "=", "dzu"}], ";", 
    RowBox[{"(*", 
     RowBox[{"vertical", " ", "suspension"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"nw", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "4", ",", "4", ",", 
       "4", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5126979552998652`*^9, 3.5126979725066953`*^9}, {
   3.512698487807201*^9, 3.512698593512986*^9}, 3.512699268042571*^9, {
   3.512706425599839*^9, 3.5127064636951065`*^9}, {3.512707714364903*^9, 
   3.512707749839365*^9}, {3.5127079340132885`*^9, 3.512707950642918*^9}, {
   3.5127115595340586`*^9, 3.5127115689564753`*^9}, {3.5127119288491073`*^9, 
   3.5127120018884354`*^9}, {3.5127120337436914`*^9, 3.512712065645747*^9}, {
   3.5127121919123693`*^9, 3.5127122302416363`*^9}, {3.5127259305527315`*^9, 
   3.5127259383683453`*^9}, 3.512730513737984*^9, {3.512801934448643*^9, 
   3.5128020708396826`*^9}, {3.5141672927623053`*^9, 
   3.5141673224023576`*^9}, {3.514167356722418*^9, 3.514167370263242*^9}, {
   3.514167454113389*^9, 3.5141674764214277`*^9}, {3.5141675159830976`*^9, 
   3.514167522207508*^9}, {3.5141675870412226`*^9, 3.5141679140957966`*^9}, {
   3.51417313329418*^9, 3.5141731556490192`*^9}, {3.514509273799012*^9, 
   3.5145092813806252`*^9}, {3.5145093960564265`*^9, 
   3.5145096329272428`*^9}, {3.5145110141068687`*^9, 
   3.5145110212516813`*^9}, {3.514515586183301*^9, 3.5145156032809315`*^9}, {
   3.514852659369889*^9, 3.5148526799619246`*^9}, {3.517266642753051*^9, 
   3.5172667211275883`*^9}, {3.517267594651123*^9, 3.517267596398326*^9}, {
   3.5172676866756845`*^9, 3.5172676868004847`*^9}, {3.5172677964686775`*^9, 
   3.517267813223107*^9}, {3.5175311092739277`*^9, 3.51753116719683*^9}, {
   3.5176957709749384`*^9, 3.517695779499426*^9}, {3.5176962575527687`*^9, 
   3.5176962607849536`*^9}, {3.5176987622685795`*^9, 3.517698769272992*^9}, {
   3.5176988777867827`*^9, 3.517698882295191*^9}, {3.517719728910236*^9, 
   3.517719735992648*^9}, {3.5187618392613893`*^9, 3.51876186812144*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Effective Bending Point Compensation", "Subsubsection",
 CellChangeTimes->{{3.511310011805502*^9, 3.511310013724305*^9}, {
  3.5113101034712625`*^9, 3.511310109976474*^9}, {3.511312045081873*^9, 
  3.5113120493874807`*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511310024020323*^9, 3.5113100245975237`*^9}, {
   3.5113101204128923`*^9, 3.511310123595298*^9}, 3.511311097317808*^9}],

Cell["\<\
Bending point of wire is apart from the suspension point because of the wire \
bending stiffness.
In this subsubsection, the separation between effective bending point & \
suspension point is estimated (1/lambda),
and then wire length and wire break-off are compensated. If you want to \
disable this compensation, 
please make the following symbol \"False\".\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511310128790107*^9, 3.511310207960246*^9}, {
   3.511310336208071*^9, 3.511310459167487*^9}, {3.511310496030352*^9, 
   3.511310656320634*^9}, {3.51131089921306*^9, 3.5113110646045504`*^9}, 
   3.511311097317808*^9, 3.5113135489584303`*^9, {3.512725999270852*^9, 
   3.51272600367006*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wirecompensation", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511311074011367*^9, 3.511311097317808*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load weight", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511308651590311*^9, 3.511308660326327*^9}, {
  3.51131116687833*^9, 3.51131117236954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"loadw", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "3", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "4", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "5", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$IM", "]"}], "]"}], "+", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$TM", "]"}], "]"}], "+", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$RM", "]"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$IRM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$TM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$RM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$MD", "]"}], "]"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113086367702856`*^9, 3.5113087745029273`*^9}, {
   3.5113088097589893`*^9, 3.5113088188382053`*^9}, {3.5113088861367235`*^9, 
   3.511308890411131*^9}, {3.51131110959503*^9, 3.5113111384394803`*^9}, 
   3.51131117236954*^9, {3.512706614687772*^9, 3.512706633719805*^9}, {
   3.512706853539791*^9, 3.5127068600294027`*^9}, {3.5127069021182766`*^9, 
   3.512706931742728*^9}, {3.514511092403406*^9, 3.5145110994078183`*^9}, {
   3.5145156142945504`*^9, 3.514515636337389*^9}, {3.5148526853283343`*^9, 
   3.5148526858743353`*^9}, {3.516668335995227*^9, 3.5166683383352313`*^9}, {
   3.5172678182151155`*^9, 3.517267818932717*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second moment of area", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113089605956545`*^9, 3.511309018003755*^9}, 
   3.5113093541395464`*^9, {3.511309392125613*^9, 3.511309434089687*^9}, {
   3.511311157487114*^9, 3.5113111858791637`*^9}, 3.511311299977764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"iw", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"dw", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "m"}], "]"}], "]"}], "4"], "/", "64"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "dw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113091838496475`*^9, 3.5113092569513755`*^9}, {
   3.5113093129398737`*^9, 3.5113093236882925`*^9}, 3.5113093541395464`*^9, {
   3.511311150248701*^9, 3.5113111520583043`*^9}, {3.5113111858791637`*^9, 
   3.51131121202481*^9}, 3.511311299977764*^9, {3.5113151870237074`*^9, 
   3.5113152264761767`*^9}, {3.511315400799283*^9, 3.511315403076887*^9}, {
   3.512358626588375*^9, 3.512358627446377*^9}, 3.512706501493973*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lambda", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511311218998022*^9, 3.5113112216032267`*^9}, 
   3.511311306186575*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lambdaw", "=", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"loadw", "[", 
           RowBox[{"[", "n", "]"}], "]"}], 
          RowBox[{
           RowBox[{
            RowBox[{"g", "/", 
             RowBox[{"nw", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "/", 
            RowBox[{"young", "[", 
             RowBox[{"matw", "[", 
              RowBox[{"[", "n", "]"}], "]"}], "]"}]}], "/", 
           RowBox[{"iw", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "m"}], "]"}], "]"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "dw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
       "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511309025819369*^9, 3.5113091071423116`*^9}, {
   3.511309263518987*^9, 3.5113093858388023`*^9}, 3.5113111858791637`*^9, {
   3.5113112437708654`*^9, 3.5113112539732833`*^9}, 3.511311306186575*^9, {
   3.5113134454678483`*^9, 3.5113134500074563`*^9}, {3.5113152729798584`*^9, 
   3.5113152861306815`*^9}, {3.511315413669306*^9, 3.511315416804911*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compensation", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511309454182522*^9, 3.511309456428926*^9}, {
   3.5113113155153913`*^9, 3.511311321724202*^9}, 3.5113115879074697`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lNw", "=", 
      RowBox[{"lNw", "-", 
       RowBox[{"2", "/", "lambdaw"}]}]}], ";", 
     RowBox[{"(*", 
      RowBox[{"wire", " ", "length"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"dyu", "=", 
      RowBox[{"dyu", "+", 
       RowBox[{"1", "/", "lambdaw"}]}]}], ";", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"wire", " ", "break"}], "-", 
       RowBox[{"off", " ", "at", " ", "upper", " ", "body"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"dyl", "=", 
      RowBox[{"dyl", "+", 
       RowBox[{"1", "/", "lambdaw"}]}]}], ";"}]}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"wire", " ", "break"}], "-", 
     RowBox[{"off", " ", "at", " ", "lower", " ", "body"}]}], "*)"}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.5113113332994223`*^9, 3.5113114085071545`*^9}, {
  3.5113115879074697`*^9, 3.5113116037102976`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Suspension Points", "Subsubsection",
 CellChangeTimes->{{3.511313811132491*^9, 3.5113138177781024`*^9}, 
   3.5113138856070213`*^9}],

Cell[CellGroupData[{

Cell["Description", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511327852568959*^9, 3.511327855345764*^9}, 
   3.51132791554627*^9}],

Cell["\<\
The clamp positions of wires in local coordinate of the attached mass.
If you want to add geometric asymmetry to the system, please arrange the \
following definition.
\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113160716784616`*^9, 3.511316135513774*^9}, {
   3.511316199583086*^9, 3.511316246585969*^9}, 3.51132791554627*^9, 
   3.5126992435505285`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Body corrdinates for all objects originate at COM", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510968232951127*^9, 3.510968236383133*^9}, 
   3.511327918369875*^9, {3.5113279682587624`*^9, 3.511327969631565*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posCOM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109682272727165`*^9, 3.5109682511563587`*^9}, 
   3.511327918369875*^9}]
}, Open  ]],

Cell["Suspension Points at upper bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113278633641787`*^9, 3.511327866530984*^9}, 
   3.5113279214898806`*^9, {3.51269895991083*^9, 3.5126989766652594`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"rMD", "=", 
   RowBox[{"35", "cm"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.514509737166626*^9, 3.514509770457084*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spu", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "0"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "1"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "2"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "3"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "4"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "4"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "0"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}],
        "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.510541271815065*^9, 3.5105413275383625`*^9}, {
   3.510541364338827*^9, 3.5105414659262056`*^9}, {3.5105415729735937`*^9, 
   3.5105416770257764`*^9}, {3.510541718537449*^9, 3.510541745213496*^9}, {
   3.5105418057416024`*^9, 3.5105418656925077`*^9}, {3.5105419541758633`*^9, 
   3.510541964097481*^9}, {3.510562740817388*^9, 3.51056276442023*^9}, {
   3.5106273753944683`*^9, 3.5106273856904864`*^9}, {3.5106361554478965`*^9, 
   3.5106361572418995`*^9}, {3.510636263328886*^9, 3.5106362654972897`*^9}, {
   3.510636399979926*^9, 3.510636408606741*^9}, {3.510655831710415*^9, 
   3.510655836608824*^9}, {3.510910690123458*^9, 3.5109107397159452`*^9}, {
   3.5109112296192055`*^9, 3.5109112741416836`*^9}, {3.510999339027935*^9, 
   3.5109993921616287`*^9}, {3.511154589829262*^9, 3.51115459458727*^9}, {
   3.511219031273158*^9, 3.5112190316787586`*^9}, {3.5113138771362066`*^9, 
   3.511313877448207*^9}, {3.511313922329486*^9, 3.511314076176956*^9}, {
   3.5113144895308824`*^9, 3.511314559107004*^9}, {3.511315592929221*^9, 
   3.5113156070628457`*^9}, {3.5113156392145023`*^9, 
   3.5113160247691793`*^9}, {3.5113268353067727`*^9, 3.5113268435123873`*^9}, 
   3.5113279214898806`*^9, {3.5126986628863087`*^9, 3.512698934170785*^9}, 
   3.512699128297526*^9, {3.512699214409677*^9, 3.5126992208680887`*^9}, {
   3.512707995851797*^9, 3.5127080201878405`*^9}, {3.512712331173814*^9, 
   3.512712357038659*^9}, {3.5145096704141083`*^9, 3.5145096822389293`*^9}, {
   3.514509760145466*^9, 3.5145098628872466`*^9}, {3.5145099488433976`*^9, 
   3.514510000292288*^9}, {3.5145119182616568`*^9, 3.514511923472066*^9}, {
   3.517266758536454*^9, 3.5172667641056643`*^9}, {3.5172668008593287`*^9, 
   3.51726680163933*^9}, 3.5172668326989846`*^9, {3.517266902337507*^9, 
   3.5172669213851404`*^9}, 3.5172678773080196`*^9, {3.5187618797278605`*^9, 
   3.5187619102727137`*^9}}],

Cell[CellGroupData[{

Cell["Suspension points at lower bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5126989944024906`*^9, 3.512699019736935*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spl", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "1"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "2"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "3"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "4"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Test", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Recoil", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Magnet", " ", "Disc"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}],
        "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510541271815065*^9, 3.5105413275383625`*^9}, {
   3.510541364338827*^9, 3.5105414659262056`*^9}, {3.5105415729735937`*^9, 
   3.5105416770257764`*^9}, {3.510541718537449*^9, 3.510541745213496*^9}, {
   3.5105418057416024`*^9, 3.5105418656925077`*^9}, {3.5105419541758633`*^9, 
   3.510541964097481*^9}, {3.510562740817388*^9, 3.51056276442023*^9}, {
   3.5106273753944683`*^9, 3.5106273856904864`*^9}, {3.5106361554478965`*^9, 
   3.5106361572418995`*^9}, {3.510636263328886*^9, 3.5106362654972897`*^9}, {
   3.510636399979926*^9, 3.510636408606741*^9}, {3.510655831710415*^9, 
   3.510655836608824*^9}, {3.510910690123458*^9, 3.5109107397159452`*^9}, {
   3.5109112296192055`*^9, 3.5109112741416836`*^9}, {3.510999339027935*^9, 
   3.5109993921616287`*^9}, {3.511154589829262*^9, 3.51115459458727*^9}, {
   3.511219031273158*^9, 3.5112190316787586`*^9}, {3.5113138771362066`*^9, 
   3.511313877448207*^9}, {3.511313922329486*^9, 3.511314076176956*^9}, {
   3.5113144895308824`*^9, 3.511314559107004*^9}, {3.511315592929221*^9, 
   3.5113156070628457`*^9}, {3.5113156392145023`*^9, 
   3.5113160247691793`*^9}, {3.5113268353067727`*^9, 3.5113268435123873`*^9}, 
   3.5113279214898806`*^9, {3.5126986628863087`*^9, 3.512698934170785*^9}, {
   3.512699019736935*^9, 3.512699078798639*^9}, {3.51269913639394*^9, 
   3.5126992265620985`*^9}, {3.5127080281594543`*^9, 3.512708062214314*^9}, {
   3.5127123629042697`*^9, 3.512712393121523*^9}, {3.5145100107599063`*^9, 
   3.5145101016612663`*^9}, {3.514511907482038*^9, 3.514511915578452*^9}, {
   3.517266777630888*^9, 3.5172667979889235`*^9}, {3.5172669361895666`*^9, 
   3.5172669542075977`*^9}, 3.517267874812015*^9, {3.5187619260755415`*^9, 
   3.51876193095835*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pre-isolator Stage", "Subsection",
 CellChangeTimes->{{3.5113121326448264`*^9, 3.511312140866041*^9}, {
  3.511313336751258*^9, 3.5113133378900595`*^9}, {3.511313499178743*^9, 
  3.5113135082735586`*^9}, {3.5113162941348524`*^9, 3.5113163044464703`*^9}}],

Cell[CellGroupData[{

Cell["Stiffness", "Subsubsection",
 CellChangeTimes->{{3.5113164098090553`*^9, 3.511316411088258*^9}, {
   3.511316936840381*^9, 3.511316965903232*^9}, 3.511317821903537*^9}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511317080672634*^9, 3.5113170919670534`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"lIP", "=", 
    RowBox[{"50.0", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"length", " ", "of", " ", "the", " ", "IP", " ", "leg"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lIPcom", "=", 
    RowBox[{"12.3", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"COM", " ", "position", " ", "from", " ", "the", " ", "ground"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kflex", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1896", ",", "1896", ",", "1896"}], "}"}], "newton", " ", 
     RowBox[{"meter", "/", "rad"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"stiffness", " ", "of", " ", "flex", " ", "joints", " ", "1896"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"loadIP", "=", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"load", " ", "weight"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvZbrwjQfzVeOE6KrZ4DoBTnZ80D0JP2cNSD60bN/
r3yBtNsd4W8gek/uZDM/IH1PZqIFiN4nWWULoi+mzXcE0dzPP3iAaKlPdT4g
WnXu3WYQ7Rpd1wKi0x01J4HoBQwWU8HqAwIXBAHppN3NYJrvxpfHIUC6q3v9
ExB9f0WPYCiQnsf0CkwvWf1RDkSfLjqnBqKTtwmeWwKk7/CUg+mOqx99PLWB
5gf9BdNzAqsngOiH6g/BdO8htu9fgLS9YD2YPvhelusrkD7My8sNotXd9BZ/
B9JLfr4A0z82r1kFonsEH60H0U/vbOxQ1gGGV8mGThA95/q0Zan6QP8FLgPT
AJSepP8=
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness of each leg", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511317097973064*^9, 3.511317103214673*^9}, 
   3.5113175148325973`*^9, {3.51131754495625*^9, 3.5113175473430543`*^9}, {
   3.511317808518713*^9, 3.5113178121535196`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kIP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"kflex", "[", 
        RowBox[{"[", "n", "]"}], "]"}], "/", 
       SuperscriptBox["lIP", "2"]}], "-", 
      RowBox[{"g", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"massIP", "[", 
            RowBox[{"[", "n", "]"}], "]"}], 
           RowBox[{"(", 
            RowBox[{"lIPcom", "/", "lIP"}], ")"}]}], "+", 
          RowBox[{"loadIP", "/", "3"}]}], ")"}], "/", "lIP"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kIPc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"kflex", "[", 
        RowBox[{"[", "n", "]"}], "]"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"I", " ", 
           RowBox[{"phi", "[", "\"\<MS\>\"", "]"}]}]}], ")"}], "/", 
        SuperscriptBox["lIP", "2"]}]}], "-", 
      RowBox[{"g", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"massIP", "[", 
            RowBox[{"[", "n", "]"}], "]"}], 
           RowBox[{"(", 
            RowBox[{"lIPcom", "/", "lIP"}], ")"}]}], "+", 
          RowBox[{"loadIP", "/", "3"}]}], ")"}], "/", "lIP"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511317105320677*^9, 3.511317202212447*^9}, {
   3.5113173168214493`*^9, 3.5113174561764946`*^9}, {3.5113175148325973`*^9, 
   3.511317543177847*^9}, 3.511317638369214*^9, 3.511317684358095*^9, {
   3.511318505153537*^9, 3.5113185319231834`*^9}, {3.511330963088026*^9, 
   3.5113309667228327`*^9}, {3.5113310748778224`*^9, 3.5113310950174575`*^9}, 
   3.511387352979451*^9, {3.5127070315205035`*^9, 3.512707039944518*^9}, {
   3.5127072581265016`*^9, 3.512707262010908*^9}, {3.5127082758098893`*^9, 
   3.512708280911098*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position", "Subsubsection",
 CellChangeTimes->{{3.5113164190910716`*^9, 3.5113164359703016`*^9}, 
   3.511317586982724*^9, 3.511317837503564*^9}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511317557919873*^9, 3.5113175589026747`*^9}, 
   3.5113175969043417`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rstage", "=", 
    RowBox[{"65.0", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"radius", " ", "of", " ", "the", " ", "stage"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511316438325906*^9, 3.511316552486906*^9}, {
  3.511316922020355*^9, 3.5113169235959578`*^9}, {3.511317564924285*^9, 
  3.5113175969043417`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP leg position", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113175744715023`*^9, 3.511317600648348*^9}, 
   3.5127062910340033`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"legs", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"0", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"0", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"4", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511316438325906*^9, 3.511316552486906*^9}, {
   3.511316922020355*^9, 3.5113169235959578`*^9}, 3.511317564924285*^9, 
   3.511317600648348*^9, {3.5113236206989217`*^9, 3.511323643552962*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GAS Filters", "Subsection",
 CellChangeTimes->{{3.5110753524379687`*^9, 3.51107535310877*^9}, {
  3.5113185577100286`*^9, 3.5113185602528334`*^9}}],

Cell[CellGroupData[{

Cell["Stiffness", "Subsubsection",
 CellChangeTimes->{{3.5113166496750765`*^9, 3.511316666757107*^9}, {
  3.5113167132919884`*^9, 3.5113167240872073`*^9}, {3.5113177945098886`*^9, 
  3.51131779518069*^9}}],

Cell[CellGroupData[{

Cell["Resonant frequency and loss angle", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113168213533783`*^9, 3.5113168316493964`*^9}, {
  3.5113185852440777`*^9, 3.5113185893156843`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"F0", "  ", "F1", "  ", "F2", "  ", "F3", "  ", "F4"}], "       ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f0GAS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"330", ",", "330", ",", "330", ",", "330", ",", "330"}], "}"}],
       "mHz"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phiGAS", "=", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.05", ",", "0.05", ",", "0.05", ",", "0.05"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511316742120839*^9, 3.5113168316493964`*^9}, {
  3.511318591889689*^9, 3.5113186119669247`*^9}, {3.511329385379252*^9, 
  3.511329385472852*^9}, {3.511494276037948*^9, 3.511494281232757*^9}, {
  3.515036997247939*^9, 3.5150370030823493`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load weight", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113168396054106`*^9, 3.5113168431622167`*^9}, 
   3.5113177835742693`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"loadGAS", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "2", ",", "9"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3", ",", "9"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4", ",", "9"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5", ",", "9"}], "}"}]}], "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$IM", "]"}], "]"}], "+", 
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$TM", "]"}], "]"}], "+", 
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$RM", "]"}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113168459234214`*^9, 3.511316894018306*^9}, {
  3.5113177342469826`*^9, 3.5113177835742693`*^9}, {3.512087644678827*^9, 
  3.512087708545339*^9}, {3.5145111126834416`*^9, 3.514511134929081*^9}, {
  3.514512124431619*^9, 3.5145121295328283`*^9}, {3.5166694696648183`*^9, 
  3.5166694782136335`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vertical Stiffness", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113177997670975`*^9, 3.511317803713905*^9}, 
   3.511318346860059*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kGAS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"loadGAS", "[", 
       RowBox[{"[", "n", "]"}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"f0GAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ")"}], "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Length", "[", "f0GAS", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kGASc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"loadGAS", "[", 
       RowBox[{"[", "n", "]"}], "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"I", " ", 
         RowBox[{"phiGAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"f0GAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ")"}], "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Length", "[", "f0GAS", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511318257549902*^9, 3.511318346860059*^9}, {
  3.5113186244781466`*^9, 3.5113186501869917`*^9}, {3.5150370100087614`*^9, 
  3.5150370110695634`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working Point & Direction", "Subsubsection",
 CellChangeTimes->{{3.511318358560079*^9, 3.5113183725221033`*^9}, {
  3.5113184710830765`*^9, 3.511318474639883*^9}}],

Cell[CellGroupData[{

Cell["Working position in local coordinate system of Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113184065613637`*^9, 3.5113184581974545`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wpGAS", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"5", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511075372624404*^9, 3.5110755086098433`*^9}, {
   3.511078738029937*^9, 3.511078805141255*^9}, {3.511130324732766*^9, 
   3.5111303256808205`*^9}, {3.51113120990919*^9, 3.511131263807285*^9}, {
   3.511131301715351*^9, 3.5111313116993685`*^9}, {3.5111315230641403`*^9, 
   3.511131537010565*^9}, {3.511134239146511*^9, 3.511134263607354*^9}, {
   3.511134354009513*^9, 3.5111343542903132`*^9}, {3.5111345428634443`*^9, 
   3.5111345430038447`*^9}, {3.511139200314025*^9, 3.511139200891226*^9}, {
   3.511146068745289*^9, 3.51114606933809*^9}, {3.511147884884879*^9, 
   3.5111479220441446`*^9}, {3.5111494918593016`*^9, 3.511149492046502*^9}, 
   3.511150491431057*^9, {3.5111506726877756`*^9, 3.5111506756205807`*^9}, 
   3.511152181304025*^9, {3.5111522247657013`*^9, 3.5111522629389687`*^9}, 
   3.511153090021221*^9, {3.511154622589319*^9, 3.51115462296372*^9}, {
   3.5111548408181024`*^9, 3.51115484506131*^9}, {3.5112182732458262`*^9, 
   3.5112182916694584`*^9}, {3.511316690640749*^9, 3.5113167012955675`*^9}, {
   3.511318380041317*^9, 3.5113183970765467`*^9}, {3.511318445967033*^9, 
   3.5113184581974545`*^9}, {3.5113188332689133`*^9, 3.51131884275373*^9}, {
   3.5113234944167*^9, 3.5113235005007105`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working direction in local coordinate system of Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113184793822913`*^9, 3.511318487291505*^9}, 
   3.5113187131955023`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wdGAS", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511075372624404*^9, 3.5110755086098433`*^9}, {
   3.511078738029937*^9, 3.511078805141255*^9}, {3.511130324732766*^9, 
   3.5111303256808205`*^9}, {3.51113120990919*^9, 3.511131263807285*^9}, {
   3.511131301715351*^9, 3.5111313116993685`*^9}, {3.5111315230641403`*^9, 
   3.511131537010565*^9}, {3.511134239146511*^9, 3.511134263607354*^9}, {
   3.511134354009513*^9, 3.5111343542903132`*^9}, {3.5111345428634443`*^9, 
   3.5111345430038447`*^9}, {3.511139200314025*^9, 3.511139200891226*^9}, {
   3.511146068745289*^9, 3.51114606933809*^9}, {3.511147884884879*^9, 
   3.5111479220441446`*^9}, {3.5111494918593016`*^9, 3.511149492046502*^9}, 
   3.511150491431057*^9, {3.5111506726877756`*^9, 3.5111506756205807`*^9}, 
   3.511152181304025*^9, {3.5111522247657013`*^9, 3.5111522629389687`*^9}, 
   3.511153090021221*^9, {3.511154622589319*^9, 3.51115462296372*^9}, {
   3.5111548408181024`*^9, 3.51115484506131*^9}, {3.5112182732458262`*^9, 
   3.5112182916694584`*^9}, {3.511316690640749*^9, 3.5113167012955675`*^9}, {
   3.511318380041317*^9, 3.5113183970765467`*^9}, 3.511318445967033*^9, 
   3.5113185773192635`*^9, {3.511318679702243*^9, 3.5113187131955023`*^9}, {
   3.511318810352473*^9, 3.51131882010249*^9}, {3.511322861866789*^9, 
   3.5113228718040066`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness Matrix & Storing Force Vector", "Subsubsection",
 CellChangeTimes->{{3.5113187371571445`*^9, 3.5113187452223587`*^9}, {
  3.511318874530986*^9, 3.511318883922202*^9}}],

Cell[CellGroupData[{

Cell["Stiffness matrix", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511318890068613*^9, 3.511318893001418*^9}, 
   3.511319080342147*^9, 3.5166684643522525`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matkGAS", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"kGAS", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0", ",", "0", ",", 
          "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Length", "[", "wpGAS", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5111311698795195`*^9, 3.5111311941375628`*^9}, {
   3.511131337860615*^9, 3.511131457653225*^9}, {3.5111317695913734`*^9, 
   3.511131777110586*^9}, {3.511131811649047*^9, 3.5111319010060043`*^9}, {
   3.511131942798477*^9, 3.5111319912833624`*^9}, {3.5111346002715454`*^9, 
   3.511134738175788*^9}, 3.511139306721812*^9, {3.5111437243419714`*^9, 
   3.5111437272279763`*^9}, {3.5111460759837017`*^9, 3.511146076576503*^9}, 
   3.511318867557773*^9, {3.5113189150130568`*^9, 3.5113189754007626`*^9}, {
   3.511319080342147*^9, 3.5113191008873835`*^9}, {3.512707360119481*^9, 
   3.512707373909905*^9}, {3.512733964933648*^9, 3.5127339789580727`*^9}, {
   3.512735039026735*^9, 3.512735043488343*^9}, 3.5166684643522525`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matkGASc", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DiagonalMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"kGASc", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0", ",", "0", ",", 
          "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Length", "[", "wpGAS", "]"}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.516668472479867*^9, 3.5166685339595747`*^9}}],

Cell[CellGroupData[{

Cell["Storing force vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113189787547684`*^9, 3.511318984573579*^9}, 
   3.5113190853029556`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vecfGAS", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"g", " ", 
         RowBox[{"loadGAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}], 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "wdGAS", "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5111311698795195`*^9, 3.5111311941375628`*^9}, {
   3.511131337860615*^9, 3.511131457653225*^9}, {3.5111317695913734`*^9, 
   3.511131777110586*^9}, {3.511131811649047*^9, 3.5111319010060043`*^9}, {
   3.511131942798477*^9, 3.5111319912833624`*^9}, {3.5111346002715454`*^9, 
   3.511134738175788*^9}, 3.511139306721812*^9, {3.5111437243419714`*^9, 
   3.5111437272279763`*^9}, {3.5111460759837017`*^9, 3.511146076576503*^9}, 
   3.511318867557773*^9, {3.5113189150130568`*^9, 3.5113189884891853`*^9}, {
   3.511319022450445*^9, 3.5113191264246283`*^9}, {3.5113228881840353`*^9, 
   3.511322937589322*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eddy Current Damper", "Subsection",
 CellChangeTimes->{{3.5113878607043433`*^9, 3.5113878620615454`*^9}, {
  3.5113884357525535`*^9, 3.5113884393717594`*^9}}],

Cell[CellGroupData[{

Cell["Magnet Disc", "Subsubsection",
 CellChangeTimes->{{3.5113878671315546`*^9, 3.511387911232832*^9}, {
  3.511388451492981*^9, 3.511388455751788*^9}}],

Cell[CellGroupData[{

Cell["Damping coefficient for each mode", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511387946520094*^9, 3.511387954132908*^9}, 
   3.5113883991704893`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "        ", 
   RowBox[{"x", ",", "  ", "y", ",", "  ", "z"}], "         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dampMDt", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"80", ",", "150", ",", "80"}], "}"}], 
     RowBox[{"kg", "/", "sec"}]}]}], ";"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113879591405163`*^9, 3.5113881294616156`*^9}, {
   3.511388224169382*^9, 3.5113882711566644`*^9}, 3.5113883991704893`*^9, {
   3.5114941970394096`*^9, 3.511494200206215*^9}, {3.5145115028017273`*^9, 
   3.514511511038542*^9}, {3.5145151465605288`*^9, 3.5145151513185368`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"pitch", ",", "yaw", ",", "roll"}], "         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dampMDr", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "4"}], "}"}], "kg", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["meter", "2"], "/", "rad"}], "/", "sec"}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113879591405163`*^9, 3.5113881294616156`*^9}, {
   3.511388224169382*^9, 3.511388321544753*^9}, 3.5113883991704893`*^9, {
   3.51149420313902*^9, 3.5114942057910247`*^9}, {3.514511517060152*^9, 
   3.5145115206793585`*^9}, {3.514515139384516*^9, 3.5145151421613207`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping coefficient matrix", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511388185606114*^9, 3.511388193593328*^9}, 
   3.511388406596102*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dampMD", "=", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Join", "[", 
      RowBox[{"dampMDt", ",", "dampMDr"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113881972749343`*^9, 3.511388199770939*^9}, {
  3.511388336115178*^9, 3.5113884085929055`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Actuators", "Subsection",
 CellChangeTimes->{{3.5113201245923815`*^9, 3.511320127103986*^9}}],

Cell[CellGroupData[{

Cell["Positions", "Subsubsection",
 CellChangeTimes->{{3.5113204481369495`*^9, 3.511320449650152*^9}}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113202091757298`*^9, 3.511320210205332*^9}, 
   3.511320410462883*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dxTMa", "=", 
    RowBox[{"12", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", 
    RowBox[{
    "separation", " ", "of", " ", "actuators", " ", "at", " ", "TM"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyTMa", "=", 
    RowBox[{"12", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", 
    RowBox[{
    "separation", " ", "of", " ", "actators", " ", "at", " ", "TM"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzTMa", "=", 
    RowBox[{"5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "-", 
      RowBox[{
      "separation", " ", "between", " ", "COM", " ", "of", " ", "TM"}]}], " ",
      "&"}], " ", "actuators"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzRMa", "=", 
    RowBox[{"6", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "-", 
      RowBox[{
      "separation", " ", "between", " ", "COM", " ", "of", " ", "RM"}]}], " ",
      "&"}], " ", "actuators"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113202124517355`*^9, 3.5113202217649517`*^9}, {
  3.51132026614703*^9, 3.511320410462883*^9}, {3.5113204870590177`*^9, 
  3.5113205365111046`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rF0a", "=", 
    RowBox[{"30", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "actuator", " ", "position", " ", "from", " ", "COM", " ", "of", " ", 
    "F0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tF0a", "=", 
    RowBox[{"0", "deg"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"rotation", " ", "angle"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113911030764384`*^9, 3.51139118946939*^9}, {
   3.511412517603778*^9, 3.511412540520218*^9}, {3.5114125735610757`*^9, 
   3.511412617553153*^9}, {3.5114132833935223`*^9, 3.511413331192006*^9}, 
   3.511413414433753*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position of actuators in local coordinate", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113204715057907`*^9, 3.511320480023405*^9}, 
   3.511320711652612*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posTMa", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posRMa", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511320549069127*^9, 3.5113207534450855`*^9}, {
  3.5113912026046133`*^9, 3.5113912502938967`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posF0a", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511320549069127*^9, 3.5113207534450855`*^9}, {
  3.5113912026046133`*^9, 3.511391247111491*^9}, {3.5114126973160934`*^9, 
  3.5114127193745317`*^9}, {3.5114127642402105`*^9, 3.511412794707064*^9}, {
  3.5114132109157953`*^9, 3.511413218279008*^9}, {3.5114133356380143`*^9, 
  3.511413352486044*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working Direction", "Subsubsection",
 CellChangeTimes->{{3.511320420556101*^9, 3.5113204221161036`*^9}, {
  3.5113204602893705`*^9, 3.5113204617401733`*^9}}],

Cell[CellGroupData[{

Cell["Working direction in local coordinate system at recoil body.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511320810213585*^9, 3.511320827560816*^9}, 
   3.511323594038475*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dirTMa", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511320767765911*^9, 3.5113207953779593`*^9}, {
   3.5113208372172327`*^9, 3.5113208425680423`*^9}, 3.511323594038475*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dirF0a", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511412799121872*^9, 3.5114128056270833`*^9}, {
   3.5114128689475946`*^9, 3.5114128764044075`*^9}, {3.5114129126276712`*^9, 
   3.511412938820117*^9}, {3.5114130374434905`*^9, 3.5114130582695274`*^9}, {
   3.5114133545452476`*^9, 3.5114133579616537`*^9}, 3.51141343579019*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Body Shape", "Subsection",
 CellChangeTimes->{{3.511303371161437*^9, 3.5113033797726517`*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Subsubsection",
 CellChangeTimes->{{3.5113191638334937`*^9, 3.5113191686227016`*^9}}],

Cell["\<\
This subsection contains the definition of the body appearance for eigen-mode \
3D graphics.
Containing nothing important for eigen-mode calculation or transfer function \
plots.
The 3D graphics shows not only standard bodies, but also mass-less bodies; \
the ground and key stones.
If you do not want to show them, please make the following symbols \"False\".\
\>", "Text",
 CellChangeTimes->{{3.51131927562329*^9, 3.511319695373227*^9}, {
  3.5113201748088694`*^9, 3.5113201768836727`*^9}, {3.51277273048518*^9, 
  3.51277274766081*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"showground", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showkeystones", "=", "True"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.511319700568036*^9, 3.511319716386464*^9}, {
  3.5113208734716964`*^9, 3.511320878869306*^9}, {3.5113305238848543`*^9, 
  3.5113305240252547`*^9}, {3.5145106603762474`*^9, 3.51451066204545*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shape Definition", "Subsubsection",
 CellChangeTimes->{{3.5113192607252636`*^9, 3.5113192614740653`*^9}, {
  3.511319726401682*^9, 3.5113197279772844`*^9}, {3.512708700551835*^9, 
  3.5127087296770864`*^9}}],

Cell[CellGroupData[{

Cell["Ground", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113059380991454`*^9, 3.5113059389259467`*^9}, 
   3.5113197356836977`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showground", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"shapeg", "=", "\"\<Doughnut\>\""}], ";", "\[IndentingNewLine]", 
      RowBox[{"rgi", "=", 
       RowBox[{"rstage", "-", 
        RowBox[{"20", "cm"}]}]}], ";", 
      RowBox[{"(*", 
       RowBox[{"inner", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"rgo", "=", 
       RowBox[{"rstage", "+", 
        RowBox[{"20", "cm"}]}]}], ";", 
      RowBox[{"(*", 
       RowBox[{"outer", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"dimg", "=", 
       RowBox[{"{", 
        RowBox[{"rgi", ",", "rgo"}], "}"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113034020962915`*^9, 3.5113035097988806`*^9}, 
   3.5113035528549557`*^9, {3.511303899549965*^9, 3.5113039129503884`*^9}, {
   3.5113197356836977`*^9, 3.511319750269724*^9}, 3.511321098112091*^9, {
   3.512708410016925*^9, 3.5127084313577623`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.5113199123228083`*^9, 3.511319917002816*^9}, 
   3.511319954770483*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showkeystones", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"shapeKS", "=", "\"\<yCylinder\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rKS", "=", 
       RowBox[{"2", "cm"}]}], ";", 
      RowBox[{"(*", "radius", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"hKS", "=", 
       RowBox[{"1", "cm"}]}], ";", 
      RowBox[{"(*", "height", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"dimKS", "=", 
       RowBox[{"{", 
        RowBox[{"rKS", ",", "hKS"}], "}"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511319920107222*^9, 3.5113199778741236`*^9}, 
   3.5113211007016954`*^9, {3.5127084353981695`*^9, 3.512708443666184*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP legs", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113035690321846`*^9, 3.5113035702489862`*^9}, 
   3.51131976529255*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIP", "=", "\"\<DoubleCylinder\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ruIP", "=", 
    RowBox[{"5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", " ", "cylinder", " ", "radius"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rlIP", "=", 
    RowBox[{"6.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", " ", "cylinder", " ", "radius"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"huIP", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"lIP", "-", "lIPcom"}], ",", 
      RowBox[{"-", "lIPcom"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", " ", "cylinder", " ", "range"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlIP", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "lIPcom"}], ",", 
      RowBox[{
       RowBox[{"-", "lIPcom"}], "-", 
       RowBox[{"15", "cm"}]}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", " ", "cylinder", " ", "range"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIP", "=", 
   RowBox[{"{", 
    RowBox[{"ruIP", ",", "rlIP", ",", "huIP", ",", "hlIP"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.5113035874870167`*^9, {3.5113038892851467`*^9, 3.511303893887155*^9}, 
   3.51131976529255*^9, {3.511325929705777*^9, 3.5113259341985855`*^9}, {
   3.512708451653398*^9, 3.512708476020641*^9}, {3.5127103883967996`*^9, 
   3.512710389192401*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filter 0", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113035334173217`*^9, 3.511303565990179*^9}, 
   3.5113197905021944`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeF0", " ", "=", " ", "\"\<yCylinder\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rF0", " ", "=", " ", 
    RowBox[{"70", " ", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"hF0", " ", "=", " ", 
    RowBox[{"20", " ", "cm"}]}], ";"}], 
  RowBox[{"(*", "height", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimF0", "=", 
   RowBox[{"{", 
    RowBox[{"rF0", ",", "hF0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.5113035898270206`*^9, {3.511303713379238*^9, 3.511303740086485*^9}, {
   3.5113038777099266`*^9, 3.5113038787551284`*^9}, 3.5113197905021944`*^9, {
   3.51270848149625*^9, 3.512708521837921*^9}, {3.512708847940894*^9, 
   3.512708903726592*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511303652367531*^9, 3.5113036562051373`*^9}, 
   3.51131980525982*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeGAS", "=", "\"\<TruncatedCone\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ruGAS", "=", 
    RowBox[{"28", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", "-", 
    RowBox[{"side", " ", "radius"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rlGAS", "=", 
    RowBox[{"37", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", "-", 
    RowBox[{"side", " ", "radius"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hGAS", "=", 
    RowBox[{"20", "cm"}]}], ";"}], 
  RowBox[{"(*", "height", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimGAS", "=", 
   RowBox[{"{", 
    RowBox[{"ruGAS", ",", "rlGAS", ",", "hGAS"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5113036594499435`*^9, 3.511303700181615*^9}, {
   3.5113037338464737`*^9, 3.511303748338899*^9}, {3.511303780506156*^9, 
   3.511303810895009*^9}, {3.51130401070016*^9, 3.5113040321189976`*^9}, 
   3.51131980525982*^9, {3.512708527625531*^9, 3.5127085451443624`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intermediate Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511303978642104*^9, 3.5113039899521236`*^9}, 
   3.511320006078973*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIM", "=", "\"\<Cuboid\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sxIM", "=", 
    RowBox[{"40", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"syIM", "=", 
    RowBox[{"12.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"szIM", "=", 
    RowBox[{"30", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIM", "=", 
   RowBox[{"{", 
    RowBox[{"sxIM", ",", "syIM", ",", "szIM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511303993103329*^9, 3.5113040028377466`*^9}, {
   3.5113040458002214`*^9, 3.5113040574690423`*^9}, {3.51130410174192*^9, 
   3.511304154002012*^9}, 3.511320006078973*^9, {3.5123558719185033`*^9, 
   3.512355874900674*^9}, {3.5127085520551744`*^9, 3.512708564379196*^9}, {
   3.5141679588366756`*^9, 3.514167965919088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intermediate Recoil Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10005.},
 CellChangeTimes->{{3.5113041616928253`*^9, 3.511304167308835*^9}, 
   3.51132001576659*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIRM", "=", "\"\<OpenCuboid\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sxIRM", "=", 
    RowBox[{"60", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"syIRM", "=", 
    RowBox[{"22.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"szIRM", "=", 
    RowBox[{"50", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIRM", "=", 
   RowBox[{"{", 
    RowBox[{"sxIRM", ",", "syIRM", ",", "szIRM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10005.},
 CellChangeTimes->{{3.5113041691184387`*^9, 3.511304250488181*^9}, 
   3.51132001576659*^9, {3.5123558811200294`*^9, 3.512355883265152*^9}, {
   3.5127085691684046`*^9, 3.512708574753214*^9}, {3.5141679760435057`*^9, 
   3.5141679825643167`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Test Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042574613934`*^9, 3.5113042620946016`*^9}, {
  3.5113200209769993`*^9, 3.51132002713901*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeTM", "=", "\"\<zCylinder\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rTM", "=", 
    RowBox[{"12.5", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lTM", "=", 
    RowBox[{"10", "cm"}]}], ";"}], 
  RowBox[{"(*", "length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimTM", "=", 
   RowBox[{"{", 
    RowBox[{"rTM", ",", "lTM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042642630053`*^9, 3.511304330968723*^9}, 
   3.51132002713901*^9, {3.512708577545619*^9, 3.512708587061636*^9}, {
   3.5141680068535595`*^9, 3.514168107848137*^9}, {3.514510146386544*^9, 
   3.51451014928815*^9}, 3.5145111507163086`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recoil Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10007.},
 CellChangeTimes->{{3.5113043179427*^9, 3.5113043198459034`*^9}, 
   3.511320033597421*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeRM", "=", "\"\<zCylinder\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rRM", "=", 
    RowBox[{"28.9", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lRM", "=", 
    RowBox[{"20", "cm"}]}], ";"}], 
  RowBox[{"(*", "length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimRM", "=", 
   RowBox[{"{", 
    RowBox[{"rRM", ",", "lRM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10007.},
 CellChangeTimes->{{3.511304322747508*^9, 3.511304366006384*^9}, 
   3.511320033597421*^9, 3.511321122916135*^9, {3.5123558431168556`*^9, 
   3.5123558445139356`*^9}, {3.5127085899632406`*^9, 
   3.5127086038784657`*^9}, {3.5127122763553176`*^9, 3.512712276870118*^9}, {
   3.514168124228166*^9, 3.514168190628682*^9}, {3.5145101381497297`*^9, 
   3.5145101529853563`*^9}, 3.5145111514495096`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Magnet Disc", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042574613934`*^9, 3.5113042620946016`*^9}, {
  3.5113200209769993`*^9, 3.51132002713901*^9}, {3.514510126356109*^9, 
  3.5145101281657124`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeMD", "=", "\"\<Circle\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rMD", "=", 
    RowBox[{"35.0", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimMD", "=", 
   RowBox[{"{", "rMD", "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042642630053`*^9, 3.511304330968723*^9}, 
   3.51132002713901*^9, {3.512708577545619*^9, 3.512708587061636*^9}, {
   3.5141680068535595`*^9, 3.514168107848137*^9}, {3.5145101326741204`*^9, 
   3.5145101344057236`*^9}, {3.5145101663389797`*^9, 
   3.5145102013298407`*^9}, {3.514511158875123*^9, 3.5145111616987276`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard body shape & dimension", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10008.},
 CellChangeTimes->{{3.5127087372430997`*^9, 3.512708758178336*^9}, 
   3.5127091283357863`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shape", "=", 
   RowBox[{"{", 
    RowBox[{
    "shapeF0", ",", "shapeGAS", ",", "shapeGAS", ",", "shapeGAS", ",", 
     "shapeGAS", ",", "shapeIM", ",", "shapeIRM", ",", "shapeTM", ",", 
     "shapeRM", ",", "shapeMD"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim", "=", 
   RowBox[{"{", 
    RowBox[{
    "dimF0", ",", "dimGAS", ",", "dimGAS", ",", "dimGAS", ",", "dimGAS", ",", 
     "dimIM", ",", "dimIRM", ",", "dimTM", ",", "dimRM", ",", "dimMD"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10008.},
 CellChangeTimes->{{3.5127087466967163`*^9, 3.5127088545553055`*^9}, {
   3.5127089173610163`*^9, 3.512708972429113*^9}, 3.5127091283357863`*^9, {
   3.5145102083498535`*^9, 3.514510215026665*^9}, {3.514510680749883*^9, 
   3.514510691607502*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Variables", "Section",
 CellChangeTimes->{{3.5106252414511204`*^9, 3.5106252530107403`*^9}, {
   3.510625426015044*^9, 3.5106254276374474`*^9}, {3.5106259504567657`*^9, 
   3.510625951330367*^9}, 3.510911145254257*^9}],

Cell[CellGroupData[{

Cell["Variable List", "Subsection",
 CellChangeTimes->{{3.510626076005786*^9, 3.510626107814242*^9}, {
  3.510911153662672*^9, 3.5109111566890774`*^9}, {3.510911385167079*^9, 
  3.5109113901902876`*^9}}],

Cell[CellGroupData[{

Cell["Variables Specifying Each Body", "Subsubsection",
 CellChangeTimes->{{3.5109114063519163`*^9, 3.5109114182391367`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"varg", "=", 
    RowBox[{"{", 
     RowBox[{
     "xg", ",", "yg", ",", "zg", ",", "pitchg", ",", "yawg", ",", "rollg"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", "Ground", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF0", "=", 
    RowBox[{"{", 
     RowBox[{"xF0", ",", "zF0", ",", "yawF0"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF1", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF1", ",", "yF1", ",", "zF1", ",", "pitchF1", ",", "yawF1", ",", 
      "rollF1"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF2", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF2", ",", "yF2", ",", "zF2", ",", "pitchF2", ",", "yawF2", ",", 
      "rollF2"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF3", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF3", ",", "yF3", ",", "zF3", ",", "pitchF3", ",", "yawF3", ",", 
      "rollF3"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF4", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF4", ",", "yF4", ",", "zF4", ",", "pitchF4", ",", "yawF4", ",", 
      "rollF4"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "4"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varIM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xIM", ",", "yIM", ",", "zIM", ",", "pitchIM", ",", "yawIM", ",", 
      "rollIM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varIRM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xIRM", ",", "yIRM", ",", "zIRM", ",", "pitchIRM", ",", "yawIRM", ",", 
      "rollIRM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varTM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xTM", ",", "yTM", ",", "zTM", ",", "pitchTM", ",", "yawTM", ",", 
      "rollTM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Test", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varRM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xRM", ",", "yRM", ",", "zRM", ",", "pitchRM", ",", "yawRM", ",", 
      "rollRM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varMD", "=", 
    RowBox[{"{", 
     RowBox[{
     "xMD", ",", "yMD", ",", "zMD", ",", "pitchMD", ",", "yawMD", ",", 
      "rollMD"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varGAS", "=", 
    RowBox[{"{", 
     RowBox[{
     "qGAS0", ",", "qGAS1", ",", "qGAS2", ",", "qGAS3", ",", "qGAS4"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stones"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQA2IQfe6w/os/6q8cNbIdXoHoNt3tEh0arxyvHfghBaKP
VfFrgmgDUUUDEC00wyEURNtlbQDTJo8+ZW0G0t49ufkgWvFN/TYQ/ez8ETC9
R5I96gaQvmV6Jx5ECwneygPRW+5E5oPoB8kLC28C6XeF24tAtNuM4goQvYcl
rQlEM2zx3wCi/0ZqbwTRQV7VRz8B6W8fP4HpTv7aqyD6n8ZOMC0j/2jBHyBd
NOcFmPZT5bn3F0j/10t9AKLrVsV6/gPSbdFyXiC683RyN4hmm/gJTK9qepkr
p/nKUazTqwBEc/3UCwgA0lGceRkg+taey38Oab1yPLFgEethIL29SHxDqv4r
R5X1XzaC6KhOp9Bm41eOL9o+RoBoANUbtV0=
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["All the Variables & Parameters", "Subsubsection",
 CellChangeTimes->{{3.510911424416748*^9, 3.5109114350559664`*^9}, {
  3.5109114803272457`*^9, 3.510911485444055*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"allparams", "=", 
    RowBox[{"Join", "[", "varg", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allvars", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
     "varF0", ",", "varF1", ",", "varF2", ",", "varF3", ",", "varF4", ",", 
      "\[IndentingNewLine]", "varIM", ",", "varIRM", ",", "varTM", ",", 
      "varRM", ",", "varMD"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allfloats", "=", 
    RowBox[{"Join", "[", "varGAS", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5105436285940065`*^9, 3.5105436779524927`*^9}, {
   3.5105505824294252`*^9, 3.510550583427827*^9}, {3.5105609245649977`*^9, 
   3.5105609275602026`*^9}, {3.5106256594538546`*^9, 
   3.5106256981731224`*^9}, {3.51062573105798*^9, 3.5106257692624474`*^9}, {
   3.510626150183916*^9, 3.5106261590603323`*^9}, {3.5106556411248803`*^9, 
   3.510655642092082*^9}, {3.5109113733266582`*^9, 3.510911378552667*^9}, {
   3.5109114473799877`*^9, 3.51091146552282*^9}, {3.5109116508113503`*^9, 
   3.5109116689697824`*^9}, {3.5109119407846594`*^9, 
   3.5109119478358717`*^9}, {3.510999937866187*^9, 3.510999943482197*^9}, {
   3.511075588996784*^9, 3.5110755901199865`*^9}, {3.511075685716954*^9, 
   3.511075686060155*^9}, {3.5110777999846897`*^9, 3.511077809531906*^9}, {
   3.5110778570807896`*^9, 3.511077864069602*^9}, {3.511077912663687*^9, 
   3.51107791422369*^9}, {3.5110782844591403`*^9, 3.5110782845839405`*^9}, {
   3.5111296569725723`*^9, 3.5111296786588125`*^9}, {3.511129758521381*^9, 
   3.5111297593664293`*^9}, {3.5111498442951202`*^9, 
   3.5111498693955646`*^9}, {3.5111523947904005`*^9, 
   3.5111523988152075`*^9}, {3.511153235678677*^9, 3.5111532386738825`*^9}, {
   3.511153792901862*^9, 3.5111537970826693`*^9}, {3.5112190816924467`*^9, 
   3.5112190848436522`*^9}, {3.5113214435902977`*^9, 
   3.5113214588627243`*^9}, {3.511321620947009*^9, 3.5113216299794254`*^9}, 
   3.5113217686324687`*^9, {3.5120804419053493`*^9, 3.512080457505377*^9}, {
   3.514510742650792*^9, 3.5145107448503957`*^9}, {3.516668623878133*^9, 
   3.5166686281369405`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Velocities", "Subsubsection",
 CellChangeTimes->{{3.5109115271741285`*^9, 3.5109115296233325`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"velparams", "=", 
    RowBox[{"makevel", "[", "allparams", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"velvars", "=", 
    RowBox[{"makevel", "[", "allvars", "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"velfloats", "=", 
    RowBox[{"makevel", "[", "allfloats", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109116827914066`*^9, 3.510911693009424*^9}, {
  3.5109118265768595`*^9, 3.510911843393689*^9}, {3.5109119242330303`*^9, 
  3.5109119576326895`*^9}, {3.511129681916999*^9, 3.511129693044636*^9}, {
  3.511129762019581*^9, 3.5111297628596287`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial Values", "Subsection",
 CellChangeTimes->{{3.510560357878402*^9, 3.5105603606396074`*^9}, {
  3.510625979738017*^9, 3.5106259827956223`*^9}, {3.510911978505526*^9, 
  3.510911979644328*^9}}],

Cell[CellGroupData[{

Cell["Initial Position & Orientation of Each Body", "Subsubsection",
 CellChangeTimes->{{3.51091199199955*^9, 3.510912024151206*^9}, {
  3.5113222648381405`*^9, 3.5113222658053417`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lw", "=", 
    RowBox[{"2.1", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"typical", " ", "length", " ", "of", " ", "wires"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.5113219241803417`*^9, 3.511321944241977*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"initg", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", "Ground", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF0", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF1", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"1", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF2", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"2", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF3", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"3", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF4", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"4", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "4"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initIM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"5", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initIRM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"5", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initTM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"6", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Test", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initRM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"6", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initMD", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"1", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initGAS", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.510542002925949*^9, 3.5105420494920306`*^9}, {
   3.5105436066915674`*^9, 3.510543608516771*^9}, {3.510543698622529*^9, 
   3.5105437015397344`*^9}, {3.51055031780616*^9, 3.510550319256963*^9}, {
   3.5106259640599895`*^9, 3.510625996414446*^9}, {3.510912034182024*^9, 
   3.510912037130429*^9}, {3.510912170073862*^9, 3.5109122070927277`*^9}, {
   3.5109999557906184`*^9, 3.510999980454262*^9}, {3.511075660164109*^9, 
   3.511075679258543*^9}, {3.5110757102869973`*^9, 3.511075712408601*^9}, {
   3.5110779207601013`*^9, 3.5110779389341335`*^9}, 3.511078289373149*^9, {
   3.5111296990169773`*^9, 3.511129702435173*^9}, {3.5111297677139063`*^9, 
   3.5111297678259125`*^9}, {3.5111524153668365`*^9, 3.511152441465682*^9}, {
   3.5111532486735*^9, 3.5111532518247056`*^9}, {3.5111537772238345`*^9, 
   3.5111537806558404`*^9}, {3.511219101894482*^9, 3.511219113048502*^9}, {
   3.5112290480209055`*^9, 3.5112290640733337`*^9}, {3.511231809771756*^9, 
   3.5112318099277563`*^9}, {3.511321800238124*^9, 3.511321902168703*^9}, {
   3.5113219541479945`*^9, 3.511322052240967*^9}, {3.5120804736046047`*^9, 
   3.5120805006394525`*^9}, {3.514510753976412*^9, 3.5145107588904204`*^9}, {
   3.516668644516969*^9, 3.516668649680578*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Default Values of Parameters & Initial Values of Variables and Floats\
\>", "Subsubsection",
 CellChangeTimes->{{3.5109123598637958`*^9, 3.5109123642786036`*^9}, {
  3.510912508001656*^9, 3.510912540184512*^9}, {3.5113222758205595`*^9, 
  3.511322278378964*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"defparams", "=", 
    RowBox[{"Join", "[", "initg", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initvars", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
     "initF0", ",", "initF1", ",", "initF2", ",", "initF3", ",", "initF4", 
      ",", "\[IndentingNewLine]", "initIM", ",", "initIRM", ",", "initTM", 
      ",", "initRM", ",", "initMD"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initfloats", "=", 
    RowBox[{"Join", "[", "initGAS", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.510912583599389*^9, 3.510912631117072*^9}, {
  3.5109188304827647`*^9, 3.5109188378615775`*^9}, {3.5109999852746706`*^9, 
  3.5109999912026806`*^9}, {3.5110757227670193`*^9, 3.511075724280222*^9}, {
  3.511077968542986*^9, 3.511077968683386*^9}, {3.5111297121007257`*^9, 
  3.5111297534580913`*^9}, {3.511149882561988*^9, 3.5111498881779976`*^9}, {
  3.5111532547107105`*^9, 3.5111532656775303`*^9}, {3.51115380350988*^9, 
  3.5111538083926888`*^9}, {3.511219133266137*^9, 3.511219137290944*^9}, {
  3.511322074003005*^9, 3.5113220940958405`*^9}, {3.5120820169675198`*^9, 
  3.512082035406752*^9}, {3.5145107618232255`*^9, 3.51451076408523*^9}, {
  3.516668652956584*^9, 3.516668658104593*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Substitution", "Subsubsection",
 CellChangeTimes->{{3.510913689415735*^9, 3.510913714516179*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"subdefparams", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allparams", ",", "defparams"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"subinitvars", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allvars", ",", "initvars"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"subinitfloats", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allvars", ",", "initvars"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109137313954086`*^9, 3.510913798990327*^9}, {
  3.5111524709497337`*^9, 3.511152475504942*^9}, {3.5111532804195557`*^9, 
  3.511153306814802*^9}, {3.5113221093838673`*^9, 3.5113221168250804`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position of Bodies", "Subsection",
 CellChangeTimes->{{3.5111299640521364`*^9, 3.5111299739127007`*^9}, {
   3.511215303957964*^9, 3.5112153043635645`*^9}, 3.511219171330204*^9, {
   3.511322411587598*^9, 3.511322413272401*^9}}],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.5113240301528406`*^9, 3.5113240329452457`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posg", "=", "varg"}], ";", 
  RowBox[{"posF0", "=", 
   RowBox[{"{", 
    RowBox[{"xF0", ",", 
     RowBox[{"yg", "+", "lIP"}], ",", "zF0", ",", "pitchg", ",", "yawF0", ",",
      "rollg"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posF1", "=", "varF1"}], ";", 
  RowBox[{"posF2", "=", "varF2"}], ";", 
  RowBox[{"posF3", "=", "varF3"}], ";", 
  RowBox[{"posF4", "=", "varF4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posIM", "=", "varIM"}], ";", 
  RowBox[{"posIRM", "=", "varIRM"}], ";", 
  RowBox[{"posTM", "=", "varTM"}], ";", 
  RowBox[{"posRM", "=", "varRM"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posMD", "=", "varMD"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5110785212363563`*^9, 3.5110785817020626`*^9}, {
   3.511078660653801*^9, 3.5110786610750017`*^9}, {3.5110786937726593`*^9, 
   3.511078720760707*^9}, {3.511078819072079*^9, 3.5110788518009367`*^9}, 
   3.511129970563509*^9, {3.5111345040973763`*^9, 3.5111345247986126`*^9}, {
   3.511139023940115*^9, 3.5111390369505377`*^9}, {3.5111411593030653`*^9, 
   3.5111411653558764`*^9}, {3.5111478027663345`*^9, 
   3.5111478096615467`*^9}, {3.5111479049621143`*^9, 
   3.5111479063817167`*^9}, {3.5111506315505033`*^9, 3.511150631644103*^9}, {
   3.5111539126944723`*^9, 3.5111539127880726`*^9}, {3.5112153117735777`*^9, 
   3.51121536986808*^9}, {3.51121718335091*^9, 3.511217211243759*^9}, {
   3.5112191753238115`*^9, 3.5112192073038673`*^9}, {3.511219240344725*^9, 
   3.5112193137740545`*^9}, {3.5112199675092163`*^9, 3.511220015697701*^9}, {
   3.5112200468197556`*^9, 3.5112200990954475`*^9}, {3.511220139171918*^9, 
   3.5112201564879484`*^9}, {3.511223344655672*^9, 3.5112233853405437`*^9}, {
   3.5112234306586227`*^9, 3.511223499641944*^9}, 3.511223584864894*^9, {
   3.511223625081764*^9, 3.5112238683953915`*^9}, {3.511223913994272*^9, 
   3.511223934586308*^9}, {3.511224317972582*^9, 3.5112243645854635`*^9}, {
   3.511224438295593*^9, 3.5112245600694065`*^9}, {3.511224590973061*^9, 
   3.511224591238261*^9}, 3.511225501827461*^9, {3.5112257523951006`*^9, 
   3.5112257752959414`*^9}, {3.511225857430085*^9, 3.5112258621412935`*^9}, {
   3.5112259063985715`*^9, 3.511225914682186*^9}, {3.511228887559024*^9, 
   3.5112288890878263`*^9}, {3.511228928821096*^9, 3.511228934031505*^9}, {
   3.511229587438653*^9, 3.5112295923682613`*^9}, {3.5112299221528406`*^9, 
   3.5112299244304447`*^9}, {3.5112302659306445`*^9, 3.511230266133445*^9}, {
   3.511230339812374*^9, 3.5112303404519753`*^9}, {3.511322430869232*^9, 
   3.511322506700965*^9}, {3.511322597196724*^9, 3.51132271461813*^9}, {
   3.51132295932016*^9, 3.5113230738555613`*^9}, {3.5113231260064526`*^9, 
   3.5113231777829437`*^9}, {3.511323242959858*^9, 3.51132324969907*^9}, {
   3.5113233113035784`*^9, 3.5113233186355915`*^9}, 3.511323521420347*^9, {
   3.511324086125739*^9, 3.5113241183397956`*^9}, {3.5113875058597193`*^9, 
   3.5113876400667553`*^9}, {3.5113876748080163`*^9, 
   3.5113877253989053`*^9}, {3.5113891555846176`*^9, 3.511389165412635*^9}, {
   3.5114067382148457`*^9, 3.5114067398216486`*^9}, {3.5114068871327076`*^9, 
   3.511406911905551*^9}, {3.5145107753952494`*^9, 3.514510780995659*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Subsubsection",
 CellChangeTimes->{{3.5113240803693295`*^9, 3.511324082022932*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posKS0", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"b2s", "[", 
      RowBox[{"posF0", ",", 
       RowBox[{
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"qGAS0", " ", 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}]}]}], "]"}], ",", 
     RowBox[{"posF0", "[", 
      RowBox[{"[", 
       RowBox[{"4", ";;", "6"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS1", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"b2s", "[", 
      RowBox[{"posF1", ",", 
       RowBox[{
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "+", 
        RowBox[{"qGAS1", " ", 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}]}]}], "]"}], ",", 
     RowBox[{"posF1", "[", 
      RowBox[{"[", 
       RowBox[{"4", ";;", "6"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS2", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"b2s", "[", 
      RowBox[{"posF2", ",", 
       RowBox[{
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "+", 
        RowBox[{"qGAS2", " ", 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}]}]}], "]"}], ",", 
     RowBox[{"posF2", "[", 
      RowBox[{"[", 
       RowBox[{"4", ";;", "6"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS3", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"b2s", "[", 
      RowBox[{"posF3", ",", 
       RowBox[{
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "4", "]"}], "]"}], "+", 
        RowBox[{"qGAS3", " ", 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}]}]}], "]"}], ",", 
     RowBox[{"posF3", "[", 
      RowBox[{"[", 
       RowBox[{"4", ";;", "6"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS4", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"b2s", "[", 
      RowBox[{"posF4", ",", 
       RowBox[{
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "5", "]"}], "]"}], "+", 
        RowBox[{"qGAS4", " ", 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "5", "]"}], "]"}]}]}]}], "]"}], ",", 
     RowBox[{"posF4", "[", 
      RowBox[{"[", 
       RowBox[{"4", ";;", "6"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5113240932393513`*^9, 3.511324108652179*^9}, {
  3.511332905806238*^9, 3.5113329127170506`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP Legs", "Subsubsection",
 CellChangeTimes->{{3.5113240364552517`*^9, 3.511324042898063*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posIP", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"lIPcom", " ", 
            RowBox[{"b2s", "[", 
             RowBox[{"posF0", ",", 
              RowBox[{"legs", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"lIP", "-", "lIPcom"}], ")"}], " ", 
            RowBox[{"b2s", "[", 
             RowBox[{"posg", ",", 
              RowBox[{"legs", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "]"}]}]}], ")"}], "/", 
         "lIP"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"pitchg", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posF0", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posg", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", "lIP"}]}], ",", 
          "yawg", ",", "\[IndentingNewLine]", 
          RowBox[{"rollg", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posF0", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posg", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "lIP"}]}]}], 
         "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5110785212363563`*^9, 3.5110785817020626`*^9}, {
   3.511078660653801*^9, 3.5110786610750017`*^9}, {3.5110786937726593`*^9, 
   3.511078720760707*^9}, {3.511078819072079*^9, 3.5110788518009367`*^9}, 
   3.511129970563509*^9, {3.5111345040973763`*^9, 3.5111345247986126`*^9}, {
   3.511139023940115*^9, 3.5111390369505377`*^9}, {3.5111411593030653`*^9, 
   3.5111411653558764`*^9}, {3.5111478027663345`*^9, 
   3.5111478096615467`*^9}, {3.5111479049621143`*^9, 
   3.5111479063817167`*^9}, {3.5111506315505033`*^9, 3.511150631644103*^9}, {
   3.5111539126944723`*^9, 3.5111539127880726`*^9}, {3.5112153117735777`*^9, 
   3.51121536986808*^9}, {3.51121718335091*^9, 3.511217211243759*^9}, {
   3.5112191753238115`*^9, 3.5112192073038673`*^9}, {3.511219240344725*^9, 
   3.5112193137740545`*^9}, {3.5112199675092163`*^9, 3.511220015697701*^9}, {
   3.5112200468197556`*^9, 3.5112200990954475`*^9}, {3.511220139171918*^9, 
   3.5112201564879484`*^9}, {3.511223344655672*^9, 3.5112233853405437`*^9}, {
   3.5112234306586227`*^9, 3.511223499641944*^9}, 3.511223584864894*^9, {
   3.511223625081764*^9, 3.5112238683953915`*^9}, {3.511223913994272*^9, 
   3.511223934586308*^9}, {3.511224317972582*^9, 3.5112243645854635`*^9}, {
   3.511224438295593*^9, 3.5112245600694065`*^9}, {3.511224590973061*^9, 
   3.511224591238261*^9}, 3.511225501827461*^9, {3.5112257523951006`*^9, 
   3.5112257752959414`*^9}, {3.511225857430085*^9, 3.5112258621412935`*^9}, {
   3.5112259063985715`*^9, 3.511225914682186*^9}, {3.511228887559024*^9, 
   3.5112288890878263`*^9}, {3.511228928821096*^9, 3.511228934031505*^9}, {
   3.511229587438653*^9, 3.5112295923682613`*^9}, {3.5112299221528406`*^9, 
   3.5112299244304447`*^9}, {3.5112302659306445`*^9, 3.511230266133445*^9}, {
   3.511230339812374*^9, 3.5112303404519753`*^9}, {3.511322430869232*^9, 
   3.511322506700965*^9}, {3.511322597196724*^9, 3.51132271461813*^9}, {
   3.51132295932016*^9, 3.5113230738555613`*^9}, {3.5113231260064526`*^9, 
   3.511323213257406*^9}, 3.511323533588369*^9, {3.511323708027875*^9, 
   3.511323781550804*^9}, {3.511323860096942*^9, 3.5113238703929605`*^9}, {
   3.511323998281985*^9, 3.5113240206992245`*^9}, {3.5113260153655276`*^9, 
   3.511326077141636*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Energy Calculation", "Section",
 CellChangeTimes->{{3.5106262518492947`*^9, 3.5106262674337225`*^9}, {
  3.5109170152635765`*^9, 3.5109170473996325`*^9}}],

Cell[CellGroupData[{

Cell["Body Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}, {3.5109662739308863`*^9, 
  3.51096627628649*^9}}],

Cell[CellGroupData[{

Cell["About bodylist", "Subsubsection",
 CellChangeTimes->{{3.5127269557397323`*^9, 3.51272696006094*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "bodylist"}]], "Input",
 CellChangeTimes->{{3.5127269619485435`*^9, 3.5127269651465487`*^9}}],

Cell[BoxData[
 StyleBox["\<\"bodylist is a list of structures defining bodies. Each \
structure containing the following items:\\n\tcoordinate list defining the \
body,\\n\tmass,\\n\tmoment of inertia tensor,\\n\tshape,\\n\tdimension\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5187628573733788`*^9},
 CellTags->"Info3518795256-8356998"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.5113252072217083`*^9, 3.511325209982913*^9}}],

Cell[CellGroupData[{

Cell["Position List", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.512709373490217*^9, 3.5127093777334247`*^9}, 
   3.512709433129122*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posb", "=", 
    RowBox[{"{", 
     RowBox[{
     "posF0", ",", "posF1", ",", "posF2", ",", "posF3", ",", "posF4", ",", 
      "posIM", ",", "posIRM", ",", "posTM", ",", "posRM", ",", "posMD"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127093809626303`*^9, 3.512709433129122*^9}, {
  3.51451137920271*^9, 3.514511381402314*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Make bodylist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113245884622216`*^9, 3.511324596262235*^9}, {
  3.511324730375671*^9, 3.5113247350088787`*^9}, {3.512709437309929*^9, 
  3.512709445343943*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"bodylist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"posb", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"moix", "[", 
             RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"moiy", "[", 
             RowBox[{"[", "n", "]"}], "]"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"moiz", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"(*", 
         RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"shape", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], 
        RowBox[{"dim", "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], 
       RowBox[{"(*", 
        RowBox[{"size", " ", "information"}], "*)"}], "\[IndentingNewLine]", 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "mass", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.5109662907321157`*^9, 
   3.510966396843502*^9}, {3.510967091044721*^9, 3.510967168249257*^9}, {
   3.5109955112540817`*^9, 3.5109955697864294`*^9}, {3.510997044967098*^9, 
   3.5109970462151003`*^9}, {3.5110002784771852`*^9, 
   3.5110003227344627`*^9}, {3.511000359144927*^9, 3.5110003704549465`*^9}, {
   3.511078476823078*^9, 3.511078512422341*^9}, 3.5111541017668047`*^9, {
   3.5112152637410936`*^9, 3.511215297234352*^9}, {3.511217240369011*^9, 
   3.511217254159435*^9}, {3.5112246532795706`*^9, 3.5112248007154293`*^9}, {
   3.51122485224232*^9, 3.5112249190416374`*^9}, {3.5112249915817647`*^9, 
   3.511225023593021*^9}, {3.5112253387915745`*^9, 3.5112253422859807`*^9}, {
   3.5112260225719757`*^9, 3.5112260227123756`*^9}, {3.511226094581702*^9, 
   3.5112260955489035`*^9}, {3.5113242138899636`*^9, 3.511324447937175*^9}, 
   3.511324596262235*^9, {3.511324730375671*^9, 3.5113247350088787`*^9}, 
   3.5113247888913736`*^9, {3.5127093008876896`*^9, 3.5127093655186033`*^9}, {
   3.5127094492907505`*^9, 3.5127095235312805`*^9}, {3.512710355012741*^9, 
   3.512710367024762*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Others", "Subsubsection",
 CellChangeTimes->{{3.5113252238201375`*^9, 3.5113252269869432`*^9}}],

Cell[CellGroupData[{

Cell["IP legs", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511325457602148*^9, 3.511325459318151*^9}, {
   3.5113261912558365`*^9, 3.5113261928626394`*^9}, 3.5113263166800566`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"bodylist", "=", "\[IndentingNewLine]", 
    RowBox[{"Join", "[", 
     RowBox[{"bodylist", ",", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"posIP", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "coordinate", "*)"}], 
          RowBox[{"massIP", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"moixIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"moiyIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"moizIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
          "\[IndentingNewLine]", "shapeIP", ",", 
          RowBox[{"(*", 
           RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], "dimIP"}], 
         RowBox[{"(*", 
          RowBox[{"size", " ", "information"}], "*)"}], "}"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113254642633595`*^9, 3.511325475089779*^9}, {
   3.5113255496423097`*^9, 3.511325704066981*^9}, {3.5113258654336643`*^9, 
   3.5113258688032703`*^9}, {3.5113261974490476`*^9, 3.5113262249050956`*^9}, 
   3.511326277367988*^9, 3.5113263166800566`*^9, {3.5127095530309324`*^9, 
   3.5127095542165346`*^9}, 3.5127266436143837`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ground", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511325241245368*^9, 3.511325249388582*^9}, 
   3.5113253530819645`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showground", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"bodylist", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posg", ",", 
          RowBox[{"(*", "coordinate", "*)"}], "0", ",", 
          RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
          "\[IndentingNewLine]", "shapeg", ",", 
          RowBox[{"(*", 
           RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], "dimg"}], 
         RowBox[{"(*", 
          RowBox[{"size", " ", "information"}], "*)"}], "}"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113252534913893`*^9, 3.5113253530819645`*^9}, {
  3.512709563763751*^9, 3.5127095645437527`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511325241245368*^9, 3.511325249388582*^9}, {
   3.5113253530819645`*^9, 3.5113253677459903`*^9}, 3.5113254448569255`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showkeystones", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"posKS", "=", 
       RowBox[{"{", 
        RowBox[{
        "posKS0", ",", "posKS1", ",", "posKS2", ",", "posKS3", ",", 
         "posKS4"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"bodylist", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"bodylist", ",", "\[IndentingNewLine]", 
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"posKS", "[", 
              RowBox[{"[", "n", "]"}], "]"}], ",", 
             RowBox[{"(*", "coordinate", "*)"}], "0", ",", 
             RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
             RowBox[{"(*", 
              RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
             "\[IndentingNewLine]", "shapeKS", ",", 
             RowBox[{"(*", 
              RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], "dimKS"}], 
            RowBox[{"(*", 
             RowBox[{"size", " ", "information"}], "*)"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"n", ",", 
             RowBox[{"Length", "[", "posKS", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113252534913893`*^9, 3.5113254448569255`*^9}, {
  3.511325483295393*^9, 3.5113254856821976`*^9}, {3.5127096271154623`*^9, 
  3.512709710482009*^9}, {3.512726680758049*^9, 3.51272668116365*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wire Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}}],

Cell[CellGroupData[{

Cell["About wirelist", "Subsubsection",
 CellChangeTimes->{{3.512726995441802*^9, 3.51272700010621*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "wirelist"}]], "Input",
 CellChangeTimes->{{3.5127270107922287`*^9, 3.512727011993431*^9}}],

Cell[BoxData[
 StyleBox["\<\"wirelist is a list of structures defining wires. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tattachment point for first mass (local coordinates),\\n\tcoordinate \
list defining second mass,\\n\tattachment point for second mass (local \
coordinates),\\n\tunstretched length,\\n\tlongitudinal elasticity,\\n\tloss \
angle of the material,\\n\tshear modulus of the material,\\n\tsecond moment \
of area\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.518762857638579*^9},
 CellTags->"Info3518795257-7571050"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making wirelist", "Subsubsection",
 CellChangeTimes->{{3.5127270034446163`*^9, 3.51272700581582*^9}}],

Cell[CellGroupData[{

Cell["Coordinate list of wire-attaching bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113271026756425`*^9, 3.5113271134708614`*^9}, {
   3.511327177774174*^9, 3.5113271910185976`*^9}, 3.511327439480234*^9, 
   3.51271000708533*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"posub", "=", 
     RowBox[{"{", 
      RowBox[{
      "posKS0", ",", "posKS1", ",", "posKS2", ",", "posKS3", ",", "posKS4", 
       ",", "posF4", ",", "posIM", ",", "posIM", ",", "posF0"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"poslb", "=", 
     RowBox[{"{", 
      RowBox[{
      "posF1", ",", "posF2", ",", "posF3", ",", "posF4", ",", "posIM", ",", 
       "posIRM", ",", "posTM", ",", "posRM", ",", "posMD"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511327117714069*^9, 3.5113272142158384`*^9}, 
   3.511327439480234*^9, {3.512710003122923*^9, 3.51271000708533*^9}, {
   3.5145113632906823`*^9, 3.514511369530693*^9}, {3.5177196663853264`*^9, 
   3.5177196954481773`*^9}, {3.5187625755432835`*^9, 3.518762582017295*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making wirelist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113264636323147`*^9, 3.511326468936324*^9}, 
   3.511326909453703*^9, {3.5113272309858675`*^9, 3.51132723226507*^9}, {
   3.5113274460322456`*^9, 3.5113274471086473`*^9}, {3.5113277295939436`*^9, 
   3.5113277327919493`*^9}, {3.5127270146298356`*^9, 3.512727014754636*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wirelist", "=", "\[IndentingNewLine]", 
    RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"posub", "[", 
           RowBox[{"[", "m", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "defining", " ", "upper", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"spu", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "attachment", " ", "point", " ", "at", " ", "upper", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"poslb", "[", 
           RowBox[{"[", "m", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "defining", " ", "lower", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"spl", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "attachment", " ", "point", " ", "at", " ", "lower", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"lNw", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{"Natural", " ", "Length"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"N", "[", "Pi", "]"}], 
           SuperscriptBox[
            RowBox[{"dw", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "n"}], "]"}], "]"}], "2"], 
           RowBox[{
            RowBox[{
             RowBox[{"young", "[", 
              RowBox[{"matw", "[", 
               RowBox[{"[", "m", "]"}], "]"}], "]"}], "/", 
             RowBox[{"lNw", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "/", "4"}]}], ",", 
          RowBox[{"(*", "Stiffness", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"phi", "[", 
              RowBox[{"matw", "[", 
               RowBox[{"[", "m", "]"}], "]"}], "]"}], "/", "2"}], "/", 
            RowBox[{"lNw", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "/", 
           RowBox[{"lambdaw", "[", 
            RowBox[{"[", 
             RowBox[{"m", ",", "n"}], "]"}], "]"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{"loss", " ", "angle"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"young", "[", 
             RowBox[{"matw", "[", 
              RowBox[{"[", "m", "]"}], "]"}], "]"}], "/", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"poisson", "[", 
              RowBox[{"matw", "[", 
               RowBox[{"[", "m", "]"}], "]"}], "]"}]}], ")"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{"shear", " ", "modulus"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"N", "[", "Pi", "]"}], 
           RowBox[{
            SuperscriptBox[
             RowBox[{"dw", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}], "4"], "/", "32"}]}]}], 
         "}"}], ",", 
        RowBox[{"(*", 
         RowBox[{"second", " ", "moment", " ", "of", " ", "area"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "nw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ",", "1"}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.511000024399539*^9, 
   3.5110000885468516`*^9}, {3.5110001243021145`*^9, 3.51100016160178*^9}, {
   3.5110001988390455`*^9, 3.5110002427687225`*^9}, {3.511001607649932*^9, 
   3.511001780966236*^9}, {3.5111538584687767`*^9, 3.511153869965997*^9}, {
   3.511155069015303*^9, 3.511155069842105*^9}, {3.5112246193027105`*^9, 
   3.511224643903954*^9}, {3.5112258457456646`*^9, 3.5112258461824656`*^9}, {
   3.5112259909039197`*^9, 3.511226005833146*^9}, {3.5113264112630234`*^9, 
   3.5113264144922285`*^9}, {3.5113264759095364`*^9, 
   3.5113266364338183`*^9}, {3.5113267140789595`*^9, 3.511326734109395*^9}, {
   3.511326898596084*^9, 3.511326924086529*^9}, {3.511327235587876*^9, 
   3.5113272773335495`*^9}, {3.511327366737306*^9, 3.511327419044198*^9}, {
   3.5113275248903837`*^9, 3.5113275334391985`*^9}, {3.517697402622178*^9, 
   3.5176974508262625`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}, {3.5109662739308863`*^9, 
  3.51096627628649*^9}, {3.5110788859025965`*^9, 3.5110788867761984`*^9}}],

Cell[CellGroupData[{

Cell["About springlist", "Subsubsection",
 CellChangeTimes->{{3.5127270198558445`*^9, 3.512727025378255*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "springlist"}]], "Input",
 CellChangeTimes->{{3.5127270268134575`*^9, 3.5127270288258605`*^9}}],

Cell[BoxData[
 StyleBox["\<\"springlist is a list of structures defining GAS springs. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tworking point at first mass (local coordinate)\\n\tcoordinate list \
defining second mass,\\n\tattached point at second mass (local coordinate)\\n\
\tspring constant tensor (6x6),\\n\tstoring force element vector (6x1),\\n\t\
spring constant tensor with imaginary part (6x6)\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.518762857825779*^9},
 CellTags->"Info3518795257-1422214"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making springlist", "Subsubsection",
 CellChangeTimes->{{3.512727031540265*^9, 3.51272703420787*^9}}],

Cell[CellGroupData[{

Cell["Coordinate list of spring-attaching bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113271026756425`*^9, 3.5113271134708614`*^9}, {
   3.511327177774174*^9, 3.5113271910185976`*^9}, 3.511327439480234*^9, {
   3.511327661250223*^9, 3.511327663059827*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"poss1", "=", 
   RowBox[{"{", 
    RowBox[{"posF0", ",", "posF1", ",", "posF2", ",", "posF3", ",", "posF4"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poss2", "=", 
   RowBox[{"{", 
    RowBox[{
    "posKS0", ",", "posKS1", ",", "posKS2", ",", "posKS3", ",", "posKS4"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511327117714069*^9, 3.5113272142158384`*^9}, 
   3.511327439480234*^9, {3.5113276571162157`*^9, 3.5113277233539324`*^9}, 
   3.5113277842408395`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making springlist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511327747565175*^9, 3.5113277509503813`*^9}, 
   3.5113280529669113`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"springlist", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", "GAS", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"poss1", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{
         "coordinate", " ", "list", " ", "defining", " ", "first", " ", 
          "body"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"working", " ", "point", " ", 
          RowBox[{"(", 
           RowBox[{"first", " ", "body", " ", "coordinate"}], ")"}]}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"poss2", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{
         "coordinate", " ", "list", " ", "defining", " ", "second", " ", 
          "body"}], "*)"}], "\[IndentingNewLine]", "posCOM", ",", 
        RowBox[{"(*", 
         RowBox[{"attachment", " ", "point", " ", 
          RowBox[{"(", 
           RowBox[{"second", " ", "body", " ", "coordinate"}], ")"}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"matkGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"spring", " ", "constant", " ", "tensor"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"vecfGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"storing", " ", "force", " ", "vector"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"matkGASc", "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], 
       RowBox[{"(*", 
        RowBox[{
        "spring", " ", "constant", " ", "tensor", " ", "with", " ", 
         "imaginary", " ", "part"}], "*)"}], "\[IndentingNewLine]", "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "poss1", "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.5109662907321157`*^9, 
   3.510966396843502*^9}, {3.510967091044721*^9, 3.510967168249257*^9}, {
   3.5109955112540817`*^9, 3.5109955697864294`*^9}, {3.510997044967098*^9, 
   3.5109970462151003`*^9}, {3.5110002784771852`*^9, 
   3.5110003227344627`*^9}, {3.511000359144927*^9, 3.5110003704549465`*^9}, {
   3.511078476823078*^9, 3.511078512422341*^9}, {3.511078893874211*^9, 
   3.5110789163538504`*^9}, {3.5111301717180142`*^9, 
   3.5111302177266455`*^9}, {3.511130264499321*^9, 3.5111303154552355`*^9}, {
   3.5111303524563518`*^9, 3.511130387641364*^9}, {3.5111305329186735`*^9, 
   3.5111305565030227`*^9}, {3.5111306659992857`*^9, 
   3.5111307500230913`*^9}, {3.5111310998197966`*^9, 3.51113113022425*^9}, 
   3.511132179263693*^9, {3.511134281157385*^9, 3.511134313043841*^9}, {
   3.511134822821536*^9, 3.511134849169983*^9}, 3.51113914042552*^9, 
   3.5111393361746635`*^9, {3.51113936804552*^9, 3.5111393805567417`*^9}, {
   3.5111525121650066`*^9, 3.5111525123522067`*^9}, {3.511154131282056*^9, 
   3.51115413343486*^9}, {3.5112291050234056`*^9, 3.511229108252611*^9}, {
   3.511327629769368*^9, 3.5113276327957735`*^9}, {3.5113277552715883`*^9, 
   3.511327803865674*^9}, {3.51132798381199*^9, 3.511327991175203*^9}, {
   3.511328024902462*^9, 3.5113280529669113`*^9}, {3.512726923057675*^9, 
   3.5127269360212975`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damper Definition", "Subsection",
 CellChangeTimes->{{3.511388575091998*^9, 3.51138859902244*^9}}],

Cell[CellGroupData[{

Cell["About damperlist", "Subsubsection",
 CellChangeTimes->{{3.512727052319502*^9, 3.5127270548623066`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "damperlist"}]], "Input",
 CellChangeTimes->{{3.5127270626779203`*^9, 3.5127270641287227`*^9}}],

Cell[BoxData[
 StyleBox["\<\"damperlist is is a list of structures defining dampers. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tcoordinate list defining second mass,\\n\tdamping coefficient \
matrix (6x6)\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5187628580129795`*^9},
 CellTags->"Info3518795257-2855598"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making damperlist", "Subsubsection",
 CellChangeTimes->{{3.5127270573115106`*^9, 3.5127270610087175`*^9}}],

Cell[CellGroupData[{

Cell["Making damperlist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113885915032268`*^9, 3.5113885957776346`*^9}, 
   3.511388709876235*^9, {3.5127270675607285`*^9, 3.5127270704467335`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"damperlist", "=", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"posMD", ",", 
       RowBox[{"(*", 
        RowBox[{
        "coordinate", " ", "list", " ", "defining", " ", "first", " ", 
         "body"}], "*)"}], "\[IndentingNewLine]", "posF1", ",", 
       RowBox[{"(*", 
        RowBox[{
        "coordinate", " ", "list", " ", "defining", " ", "second", " ", 
         "body"}], "*)"}], "\[IndentingNewLine]", "dampMD"}], 
      RowBox[{"(*", 
       RowBox[{"damping", " ", "coefficient", " ", "matrix"}], "*)"}], 
      "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511388612048463*^9, 3.511388709876235*^9}, {
  3.511389274160426*^9, 3.511389300805273*^9}, {3.5145140118925357`*^9, 
  3.5145140255737596`*^9}, {3.5187628318673334`*^9, 3.518762839511347*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Potential Energy Calculation", "Subsection",
 CellChangeTimes->{{3.510560448249361*^9, 3.510560448670562*^9}, {
  3.5106264014535575`*^9, 3.510626411702776*^9}, {3.5109166230008874`*^9, 
  3.510916633390506*^9}, {3.510917225723546*^9, 3.510917232306758*^9}}],

Cell[CellGroupData[{

Cell["Wire Stretching Potential", "Subsubsection",
 CellChangeTimes->{{3.511219454212905*^9, 3.511219459080114*^9}, {
  3.5113282965753393`*^9, 3.511328305264555*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"wirepot", "=", 
    RowBox[{"makewirepot", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"wirepotc", "=", 
    RowBox[{"makewirepotc", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510542091144104*^9, 3.510542093936509*^9}, {
   3.510542888481906*^9, 3.5105428899327087`*^9}, {3.510542932146383*^9, 
   3.5105429338311863`*^9}, {3.5105434500672927`*^9, 3.510543476493739*^9}, {
   3.510543521063017*^9, 3.5105435385974483`*^9}, {3.5105435839311275`*^9, 
   3.5105435894847374`*^9}, {3.510545463687629*^9, 3.5105454866664696`*^9}, {
   3.5105498942966166`*^9, 3.510550005088011*^9}, {3.5105505425245547`*^9, 
   3.5105505701990037`*^9}, {3.5105506566075554`*^9, 3.510550672535183*^9}, {
   3.5105509738653126`*^9, 3.5105509743645134`*^9}, {3.510551048137043*^9, 
   3.5105511440304117`*^9}, 3.510557050919793*^9, 3.5105572108200736`*^9, 
   3.5105577896122904`*^9, 3.510557847488392*^9, {3.5105583630068974`*^9, 
   3.510558405704172*^9}, {3.5105608134148026`*^9, 3.510560853085672*^9}, 
   3.5105608836617255`*^9, {3.5106264247287984`*^9, 3.5106264690796766`*^9}, {
   3.5109166369473124`*^9, 3.510916652516139*^9}, {3.510916956872674*^9, 
   3.510916976934309*^9}, {3.5109172133839245`*^9, 3.510917261400809*^9}, {
   3.51091783730702*^9, 3.5109178806750965`*^9}, 3.511002137801263*^9, {
   3.5111411385862293`*^9, 3.5111411749810934`*^9}, 3.511141210159155*^9, {
   3.5111541843533497`*^9, 3.5111541968957715`*^9}, {3.5112194905765696`*^9, 
   3.5112195044761934`*^9}, {3.5113282322408266`*^9, 3.511328247341653*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wire Torsional Potential", "Subsubsection",
 CellChangeTimes->{{3.511328281521313*^9, 3.511328293689335*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"torsionpot", "=", 
    RowBox[{"maketorsionpot", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"torsionpotc", "=", 
    RowBox[{"maketorsionpotc", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511002097319192*^9, 3.511002109783613*^9}, 
   3.5110021423564706`*^9, {3.5110022020421753`*^9, 3.5110022106377907`*^9}, {
   3.5110034113562994`*^9, 3.5110034150379057`*^9}, {3.511233156981127*^9, 
   3.5112331628935375`*^9}, {3.511328253441264*^9, 3.511328271802496*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring Potential", "Subsubsection",
 CellChangeTimes->{{3.5112195186878185`*^9, 3.511219521293023*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"springpot", "=", 
    RowBox[{"makespringpot", "[", "springlist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"springpotc", "=", 
    RowBox[{"makespringpotc", "[", "springlist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510542091144104*^9, 3.510542093936509*^9}, {
   3.510542888481906*^9, 3.5105428899327087`*^9}, {3.510542932146383*^9, 
   3.5105429338311863`*^9}, {3.5105434500672927`*^9, 3.510543476493739*^9}, {
   3.510543521063017*^9, 3.5105435385974483`*^9}, {3.5105435839311275`*^9, 
   3.5105435894847374`*^9}, {3.510545463687629*^9, 3.5105454866664696`*^9}, {
   3.5105498942966166`*^9, 3.510550005088011*^9}, {3.5105505425245547`*^9, 
   3.5105505701990037`*^9}, {3.5105506566075554`*^9, 3.510550672535183*^9}, {
   3.5105509738653126`*^9, 3.5105509743645134`*^9}, {3.510551048137043*^9, 
   3.5105511440304117`*^9}, 3.510557050919793*^9, 3.5105572108200736`*^9, 
   3.5105577896122904`*^9, 3.510557847488392*^9, {3.5105583630068974`*^9, 
   3.510558405704172*^9}, {3.5105608134148026`*^9, 3.510560853085672*^9}, 
   3.5105608836617255`*^9, {3.5106264247287984`*^9, 3.5106264690796766`*^9}, {
   3.5109166369473124`*^9, 3.510916652516139*^9}, {3.510916956872674*^9, 
   3.510916976934309*^9}, {3.5109172133839245`*^9, 3.510917261400809*^9}, {
   3.51091783730702*^9, 3.5109178806750965`*^9}, 3.511002137801263*^9, {
   3.5111301323777637`*^9, 3.511130142680353*^9}, {3.5111389035391035`*^9, 
   3.511138929201149*^9}, {3.511139340261871*^9, 3.511139364129913*^9}, 
   3.511139422817216*^9, {3.51114012523965*^9, 3.511140134584066*^9}, {
   3.5111409838339577`*^9, 3.5111409926791735`*^9}, {3.5111542019033804`*^9, 
   3.5111542101869946`*^9}, {3.5113283226741858`*^9, 3.5113283456218257`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravity Potential", "Subsubsection",
 CellChangeTimes->{{3.511219530216239*^9, 3.511219534256646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gravpot", "=", 
    RowBox[{"makegravpot", "[", "bodylist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109172647548146`*^9, 3.5109172699028234`*^9}, {
   3.510966585884634*^9, 3.5109665906738424`*^9}, {3.5109669988485594`*^9, 
   3.5109670018593645`*^9}, 3.5110021586428995`*^9, {3.511227259181363*^9, 
   3.5112272796485996`*^9}, 3.5113283557930436`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pre-isolator Potential", "Subsubsection",
 CellChangeTimes->{{3.511219540668257*^9, 3.511219544100263*^9}, {
  3.5113283658706617`*^9, 3.5113283754646783`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"stagepot", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{"(*", 
     RowBox[{"only", " ", "real", " ", "part"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"kIP", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "\[IndentingNewLine]", 
      RowBox[{"sqvec", "[", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"b2s", "[", 
           RowBox[{"posF0", ",", 
            RowBox[{"legs", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], "-", 
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"b2s", "[", 
           RowBox[{"varg", ",", 
            RowBox[{"legs", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5112253941092715`*^9, 3.5112254401917524`*^9}, {
  3.511226123729353*^9, 3.5112262481551714`*^9}, {3.511226299089261*^9, 
  3.5112264040462456`*^9}, {3.51122692699438*^9, 3.511227022154547*^9}, {
  3.5112272102284775`*^9, 3.511227226967307*^9}, {3.5113283815798893`*^9, 
  3.5113285014660997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"stagepotc", "=", 
    RowBox[{"Sum", "[", 
     RowBox[{"(*", 
      RowBox[{"with", " ", "imaginary", " ", "part"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"kIPc", "[", 
        RowBox[{"[", "n", "]"}], "]"}], "\[IndentingNewLine]", 
       RowBox[{"sqvec", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"b2s", "[", 
            RowBox[{"posF0", ",", 
             RowBox[{"legs", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], "-", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"b2s", "[", 
            RowBox[{"varg", ",", 
             RowBox[{"legs", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]",
       ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5112253941092715`*^9, 3.5112254401917524`*^9}, {
   3.511226123729353*^9, 3.5112262481551714`*^9}, {3.511226299089261*^9, 
   3.51122644098711*^9}, {3.511227242021333*^9, 3.511227245328539*^9}, {
   3.51123169247515*^9, 3.511231712162385*^9}, 3.5113283904563046`*^9, {
   3.511328469408043*^9, 3.5113285071133094`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Total", "Subsubsection",
 CellChangeTimes->{{3.511219549981474*^9, 3.511219550652275*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"potential", "=", 
   RowBox[{
   "wirepot", "+", "gravpot", "+", "torsionpot", "+", "springpot", "+", 
    "stagepot"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"potentialc", "=", 
   RowBox[{
   "wirepotc", "+", "gravpot", "+", "torsionpot", "+", "springpotc", "+", 
    "stagepotc"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109172740680313`*^9, 3.5109172945196667`*^9}, 
   3.5109179087707458`*^9, 3.5110004500306864`*^9, {3.5110004867843513`*^9, 
   3.5110005204336104`*^9}, 3.5110021501720843`*^9, {3.5110022152553988`*^9, 
   3.5110022192646055`*^9}, {3.5111433491457124`*^9, 3.511143363653738*^9}, {
   3.511152543224661*^9, 3.511152549573872*^9}, {3.511226445838719*^9, 
   3.511226472530366*^9}, {3.5113289728677273`*^9, 3.511328987375753*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kinetic Energy Calculation", "Subsection",
 CellChangeTimes->{{3.51091730216368*^9, 3.510917310494095*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kinetic", "=", 
    RowBox[{"makekinetic", "[", "bodylist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510917352099368*^9, 3.510917508349242*^9}, {
   3.5109668339562693`*^9, 3.51096683429947*^9}, {3.5109669425480604`*^9, 
   3.5109669488504715`*^9}, 3.510967004105768*^9, 3.510967051093051*^9, {
   3.511000390828583*^9, 3.511000401436601*^9}, {3.51114029066234*^9, 
   3.511140299008355*^9}, {3.5111504745986276`*^9, 3.5111504779058332`*^9}, {
   3.511227322049474*^9, 3.511227329007086*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping Energy Calculation", "Subsection",
 CellChangeTimes->{{3.5113890192871785`*^9, 3.5113890229843845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"damping", "=", 
    RowBox[{"makedamping", "[", "damperlist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5113890305347977`*^9, 3.511389047632428*^9}, {
  3.511389361348979*^9, 3.5113893730333996`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Equilibrium Point", "Section",
 CellChangeTimes->{{3.5106265435854073`*^9, 3.5106265504962196`*^9}, 
   3.5106554796021967`*^9}],

Cell[CellGroupData[{

Cell["Potential with Default Values of Parameters", "Subsection",
 CellChangeTimes->{{3.5106268136062813`*^9, 3.5106268456331377`*^9}, {
  3.510627087792363*^9, 3.5106271045155926`*^9}, {3.510917973136459*^9, 
  3.510917992106092*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"potential0", "=", 
    RowBox[{"potential", "/.", "subdefparams"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5105539888460145`*^9, 3.510554070636958*^9}, {
   3.510554121430648*^9, 3.5105542109124045`*^9}, 3.5105546485935736`*^9, {
   3.5105546974216595`*^9, 3.510554704051671*^9}, {3.5105571731928077`*^9, 
   3.5105571828960247`*^9}, 3.51055786907883*^9, 3.510557938810952*^9, {
   3.5105584149237885`*^9, 3.5105584273414106`*^9}, {3.510559192210754*^9, 
   3.5105592145655932`*^9}, {3.510560255901023*^9, 3.5105602574922256`*^9}, {
   3.5105606405976987`*^9, 3.51056068084577*^9}, 3.5105607235898447`*^9, 
   3.5105611168353353`*^9, {3.5106265647702446`*^9, 3.5106265760490646`*^9}, {
   3.510627120958021*^9, 3.51062714858567*^9}, {3.5106273594512405`*^9, 
   3.5106273673448544`*^9}, {3.5106274131777344`*^9, 3.510627420806148*^9}, {
   3.510636250108863*^9, 3.5106362563176737`*^9}, {3.5106557863611355`*^9, 
   3.51065579467595*^9}, {3.5108253325205708`*^9, 3.5108253359993763`*^9}, {
   3.5109179503760185`*^9, 3.5109179592680345`*^9}, {3.5109180139149303`*^9, 
   3.510918040434977*^9}, 3.5109183532935266`*^9, 3.510918580757526*^9, 
   3.510918631816416*^9, 3.51091887893645*^9, {3.511150554049567*^9, 
   3.5111505637215843`*^9}, {3.511150600678049*^9, 3.5111506134388714`*^9}, 
   3.511154234382637*^9, 3.5111613806292715`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find Equilibrium Point", "Subsection",
 CellChangeTimes->{{3.5106274478565955`*^9, 3.510627536183951*^9}, 
   3.510655478166994*^9}],

Cell["Find optimal values that make the potential energy minimum.", "Text",
 CellChangeTimes->{{3.510627542611162*^9, 3.5106275966652565`*^9}, {
   3.5109180810106487`*^9, 3.510918084910655*^9}, {3.5109182507701464`*^9, 
   3.510918255060154*^9}, 3.510975865186532*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"subminvars", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
    RowBox[{"potential0", ",", "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"comb", "[", 
        RowBox[{"allvars", ",", "initvars"}], "]"}], ",", 
       RowBox[{"comb", "[", 
        RowBox[{"allfloats", ",", "initfloats"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MaxIterations", "\[Rule]", "100"}]}], "\[IndentingNewLine]", 
    "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51055781213873*^9, 3.510557830281562*^9}, {
   3.510557969761407*^9, 3.5105579803850255`*^9}, {3.510558511285158*^9, 
   3.510558539942408*^9}, {3.5105590865985684`*^9, 3.5105591272054396`*^9}, {
   3.510559279305707*^9, 3.510559289632925*^9}, 3.5105605175134826`*^9, 
   3.51056060141043*^9, {3.510560695213395*^9, 3.5105606957281957`*^9}, 
   3.5105609712558794`*^9, 3.510561120158141*^9, {3.510627334818797*^9, 
   3.510627350855625*^9}, {3.5106274406493826`*^9, 3.510627443504188*^9}, 
   3.510627615010889*^9, {3.5106295313562555`*^9, 3.5106295448814793`*^9}, 
   3.5106361885199547`*^9, 3.51063623703604*^9, {3.510636431164381*^9, 
   3.5106364370455914`*^9}, {3.510655802725564*^9, 3.5106558188091927`*^9}, 
   3.510655856608059*^9, {3.510655900756136*^9, 3.510655922518174*^9}, 
   3.510918005334915*^9, {3.510918228306107*^9, 3.510918233828517*^9}, {
   3.5109182690221786`*^9, 3.5109182811278*^9}, {3.511004376030794*^9, 
   3.5110044189620695`*^9}, {3.5110044623613453`*^9, 3.511004473421765*^9}, {
   3.5111403358556194`*^9, 3.5111403660104723`*^9}, {3.5111412252287817`*^9, 
   3.511141227818386*^9}, 3.5111413265977592`*^9, {3.5111413751606445`*^9, 
   3.5111414888988447`*^9}, {3.5111549058546166`*^9, 3.5111549297538586`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"xF0", "\[Rule]", "1.3496363327764273`*^-35"}], ",", 
   RowBox[{"zF0", "\[Rule]", "3.3746602001144894`*^-36"}], ",", 
   RowBox[{"yawF0", "\[Rule]", 
    RowBox[{"-", "4.199826497566687`*^-31"}]}], ",", 
   RowBox[{"xF1", "\[Rule]", 
    RowBox[{"-", "6.996237936716931`*^-36"}]}], ",", 
   RowBox[{"yF1", "\[Rule]", 
    RowBox[{"-", "1.6175564572011383`"}]}], ",", 
   RowBox[{"zF1", "\[Rule]", 
    RowBox[{"-", "1.7498738992447553`*^-36"}]}], ",", 
   RowBox[{"pitchF1", "\[Rule]", 
    RowBox[{"-", "1.4066098701102795`*^-36"}]}], ",", 
   RowBox[{"yawF1", "\[Rule]", 
    RowBox[{"-", "4.199826497566385`*^-31"}]}], ",", 
   RowBox[{"rollF1", "\[Rule]", "5.62645075086714`*^-36"}], ",", 
   RowBox[{"xF2", "\[Rule]", "5.039116706364539`*^-37"}], ",", 
   RowBox[{"yF2", "\[Rule]", 
    RowBox[{"-", "3.73459229913678`"}]}], ",", 
   RowBox[{"zF2", "\[Rule]", "1.2718135910851905`*^-37"}], ",", 
   RowBox[{"pitchF2", "\[Rule]", 
    RowBox[{"-", "1.4291219125670886`*^-39"}]}], ",", 
   RowBox[{"yawF2", "\[Rule]", 
    RowBox[{"-", "4.199826497565993`*^-31"}]}], ",", 
   RowBox[{"rollF2", "\[Rule]", "6.537194649517543`*^-39"}], ",", 
   RowBox[{"xF3", "\[Rule]", 
    RowBox[{"-", "1.7864271515102407`*^-37"}]}], ",", 
   RowBox[{"yF3", "\[Rule]", 
    RowBox[{"-", "6.1019477123779735`"}]}], ",", 
   RowBox[{"zF3", "\[Rule]", 
    RowBox[{"-", "4.528057973558124`*^-38"}]}], ",", 
   RowBox[{"pitchF3", "\[Rule]", 
    RowBox[{"-", "1.085876408759336`*^-37"}]}], ",", 
   RowBox[{"yawF3", "\[Rule]", 
    RowBox[{"-", "4.199826497565418`*^-31"}]}], ",", 
   RowBox[{"rollF3", "\[Rule]", "3.265126937356201`*^-37"}], ",", 
   RowBox[{"xF4", "\[Rule]", 
    RowBox[{"-", "2.6705029672454245`*^-37"}]}], ",", 
   RowBox[{"yF4", "\[Rule]", 
    RowBox[{"-", "8.203303776901162`"}]}], ",", 
   RowBox[{"zF4", "\[Rule]", 
    RowBox[{"-", "6.574105910896013`*^-38"}]}], ",", 
   RowBox[{"pitchF4", "\[Rule]", "1.3048875080435437`*^-38"}], ",", 
   RowBox[{"yawF4", "\[Rule]", 
    RowBox[{"-", "4.199826497564615`*^-31"}]}], ",", 
   RowBox[{"rollF4", "\[Rule]", 
    RowBox[{"-", "1.836832042535552`*^-38"}]}], ",", 
   RowBox[{"xIM", "\[Rule]", 
    RowBox[{"-", "2.9299623115531907`*^-37"}]}], ",", 
   RowBox[{"yIM", "\[Rule]", 
    RowBox[{"-", "10.28697582046774`"}]}], ",", 
   RowBox[{"zIM", "\[Rule]", 
    RowBox[{"-", "7.277618906659375`*^-38"}]}], ",", 
   RowBox[{"pitchIM", "\[Rule]", "2.1896589128027017`*^-39"}], ",", 
   RowBox[{"yawIM", "\[Rule]", 
    RowBox[{"-", "4.199826497563898`*^-31"}]}], ",", 
   RowBox[{"rollIM", "\[Rule]", 
    RowBox[{"-", "9.59506015393237`*^-39"}]}], ",", 
   RowBox[{"xIRM", "\[Rule]", 
    RowBox[{"-", "3.005998419059057`*^-37"}]}], ",", 
   RowBox[{"yIRM", "\[Rule]", 
    RowBox[{"-", "10.29622754527475`"}]}], ",", 
   RowBox[{"zIRM", "\[Rule]", 
    RowBox[{"-", "6.823286805831161`*^-38"}]}], ",", 
   RowBox[{"pitchIRM", "\[Rule]", "1.323948794387842`*^-38"}], ",", 
   RowBox[{"yawIRM", "\[Rule]", 
    RowBox[{"-", "4.199826497564615`*^-31"}]}], ",", 
   RowBox[{"rollIRM", "\[Rule]", 
    RowBox[{"-", "1.824794229264578`*^-38"}]}], ",", 
   RowBox[{"xTM", "\[Rule]", 
    RowBox[{"-", "3.043814081974336`*^-37"}]}], ",", 
   RowBox[{"yTM", "\[Rule]", 
    RowBox[{"-", "12.379500988260089`"}]}], ",", 
   RowBox[{"zTM", "\[Rule]", 
    RowBox[{"-", "6.764158304202542`*^-38"}]}], ",", 
   RowBox[{"pitchTM", "\[Rule]", "1.4100845146562283`*^-39"}], ",", 
   RowBox[{"yawTM", "\[Rule]", 
    RowBox[{"-", "4.199826497563899`*^-31"}]}], ",", 
   RowBox[{"rollTM", "\[Rule]", 
    RowBox[{"-", "9.594977633389476`*^-39"}]}], ",", 
   RowBox[{"xRM", "\[Rule]", 
    RowBox[{"-", "2.9024942221263264`*^-37"}]}], ",", 
   RowBox[{"yRM", "\[Rule]", 
    RowBox[{"-", "12.377953279724714`"}]}], ",", 
   RowBox[{"zRM", "\[Rule]", 
    RowBox[{"-", "9.132070110846014`*^-38"}]}], ",", 
   RowBox[{"pitchRM", "\[Rule]", "2.5776123545065555`*^-39"}], ",", 
   RowBox[{"yawRM", "\[Rule]", 
    RowBox[{"-", "4.199826497563898`*^-31"}]}], ",", 
   RowBox[{"rollRM", "\[Rule]", 
    RowBox[{"-", "9.592348643411444`*^-39"}]}], ",", 
   RowBox[{"xMD", "\[Rule]", 
    RowBox[{"-", "6.036722808316033`*^-20"}]}], ",", 
   RowBox[{"yMD", "\[Rule]", 
    RowBox[{"-", "1.4432193145940104`"}]}], ",", 
   RowBox[{"zMD", "\[Rule]", "3.5590350797121284`*^-20"}], ",", 
   RowBox[{"pitchMD", "\[Rule]", "1.8728383416989068`*^-17"}], ",", 
   RowBox[{"yawMD", "\[Rule]", 
    RowBox[{"-", "4.40340551839644`*^-31"}]}], ",", 
   RowBox[{"rollMD", "\[Rule]", "3.1766491985622796`*^-17"}], ",", 
   RowBox[{"qGAS0", "\[Rule]", "1.6479481839763204`*^-14"}], ",", 
   RowBox[{"qGAS1", "\[Rule]", "2.0973988003441642`*^-14"}], ",", 
   RowBox[{"qGAS2", "\[Rule]", "1.5248050782988377`*^-14"}], ",", 
   RowBox[{"qGAS3", "\[Rule]", "7.440243270169406`*^-15"}], ",", 
   RowBox[{"qGAS4", "\[Rule]", "1.990702395643108`*^-14"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.510918281798601*^9, {3.5109185842987328`*^9, 3.510918588183139*^9}, 
   3.5109188021843147`*^9, 3.5109188818380547`*^9, 3.510956282795619*^9, 
   3.510958553471608*^9, 3.5109760020455723`*^9, 3.5109762224427595`*^9, 
   3.510981584761199*^9, 3.510997021052256*^9, 3.5109970696775417`*^9, 
   3.51100053174363*^9, 3.5110022334138308`*^9, 3.5110032212855654`*^9, 
   3.511003477625216*^9, 3.5110044026288404`*^9, {3.5110044639837484`*^9, 
   3.511004474498167*^9}, 3.511004507944626*^9, 3.5110674021996913`*^9, 
   3.5111403773048925`*^9, 3.511141010588004*^9, 3.5111412287075877`*^9, 
   3.5111413274869614`*^9, {3.5111413840838604`*^9, 3.5111414391659575`*^9}, {
   3.511141482034833*^9, 3.5111414896320467`*^9}, 3.511143384729375*^9, 
   3.5111469195239835`*^9, 3.5111472172193065`*^9, 3.511147933229364*^9, {
   3.511149501266118*^9, 3.5111495096589327`*^9}, 3.511150531741528*^9, 
   3.511150641955722*^9, {3.511150687227001*^9, 3.5111507000658236`*^9}, 
   3.5111525605562916`*^9, 3.511152660521267*^9, 3.5111541628097115`*^9, 
   3.5111546461141605`*^9, 3.511154858804934*^9, 3.511154922016245*^9, 
   3.5111550870333347`*^9, 3.511227338569903*^9, 3.5112285791620817`*^9, 
   3.5112287411059666`*^9, 3.5112289115986657`*^9, 3.511228943719122*^9, 
   3.5112291311846514`*^9, 3.5112291859407473`*^9, 3.511229342253022*^9, 
   3.511229667950394*^9, 3.51122993873567*^9, 3.51123036609842*^9, 
   3.511230514938282*^9, 3.5112317294784155`*^9, {3.511231796870534*^9, 
   3.5112318180085707`*^9}, 3.511232314782448*^9, 3.5112324235614386`*^9, 
   3.511232456883097*^9, 3.511232491608758*^9, 3.5112325360376368`*^9, 
   3.511232579889313*^9, 3.511232655409046*^9, 3.511232843857377*^9, 
   3.5112329061326866`*^9, 3.5112332275400505`*^9, 3.5113291732188797`*^9, 
   3.511329411712098*^9, 3.511330414918663*^9, 3.511330611135808*^9, 
   3.5113309898420725`*^9, 3.511331145155946*^9, 3.511332932014284*^9, 
   3.511343444537177*^9, 3.5113893904430304`*^9, 3.5114066658619184`*^9, 
   3.5114067613964863`*^9, 3.5114069281139793`*^9, 3.5114315309789104`*^9, 
   3.5114900390388813`*^9, 3.511494313353214*^9, 3.5114947992160673`*^9, 
   3.5114950951797867`*^9, 3.5114976128240194`*^9, 3.5123557673055196`*^9, 
   3.5123559844585347`*^9, 3.512357720304784*^9, 3.5123578229841638`*^9, 
   3.5123586976933002`*^9, 3.512358797330675*^9, 3.5123589226144953`*^9, 
   3.5124237581731677`*^9, 3.5124275277636547`*^9, 3.5127107827030926`*^9, 
   3.5127123057457695`*^9, 3.5127124974389057`*^9, 3.5127125912262707`*^9, 
   3.5127130589306917`*^9, 3.5127131447932425`*^9, 3.51273061964657*^9, 
   3.5127326937654157`*^9, 3.512733364067393*^9, 3.5127350758739996`*^9, 
   3.5128022717992363`*^9, 3.5128023938538504`*^9, 3.512802484396409*^9, {
   3.514168342323349*^9, 3.514168347876959*^9}, 3.514168527402074*^9, 
   3.514168687910756*^9, 3.5141713213879848`*^9, 3.5141731899222794`*^9, 
   3.5141732836784444`*^9, 3.514173379228612*^9, 3.514242359483553*^9, 
   3.5145115735478516`*^9, 3.5145119675889435`*^9, 3.514512186691328*^9, 
   3.5145145368178577`*^9, 3.514515206728235*^9, 3.514515696647095*^9, 
   3.5145167757165904`*^9, 3.5145188830181007`*^9, 3.514853794026291*^9, 
   3.515035842714418*^9, 3.515037070224867*^9, 3.5166689454726973`*^9, 
   3.5166695710337963`*^9, 3.517267136696718*^9, 3.5172672390640984`*^9, 
   3.517275832767699*^9, 3.5172775377570934`*^9, 3.517278401889411*^9, 
   3.517278815711338*^9, 3.5172875424004483`*^9, 3.5175271096198826`*^9, 
   3.517527189882024*^9, 3.517527249380528*^9, 3.5175311779140487`*^9, 
   3.5176109689600782`*^9, 3.517695841488971*^9, 3.5176960177970552`*^9, 
   3.517696085681938*^9, 3.517696280322071*^9, 3.5176975037103558`*^9, 
   3.517698783313017*^9, 3.517698892279208*^9, 3.517719761467493*^9, 
   3.517719840232032*^9, 3.5177199161417646`*^9, 3.517730328674652*^9, 
   3.517730426108225*^9, 3.517730502031567*^9, 3.5177320658982487`*^9, 
   3.5177321388751764`*^9, 3.517732236874549*^9, 3.51779285388688*^9, 
   3.517792946878643*^9, 3.517878454674403*^9, 3.518762540037621*^9, 
   3.518762613045749*^9, 3.518762862349787*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equations of Motion", "Section",
 CellChangeTimes->{{3.510627640017733*^9, 3.510627674649794*^9}, 
   3.5109189734102154`*^9}],

Cell[CellGroupData[{

Cell["Mass Matrix", "Subsection",
 CellChangeTimes->{{3.510561334346517*^9, 3.510561337388523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matMvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"kinetic", ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510561339822127*^9, 3.5105613828470025`*^9}, {
   3.5105614843563805`*^9, 3.51056150657082*^9}, {3.510561663541896*^9, 
   3.5105617389524283`*^9}, {3.5105619183683434`*^9, 
   3.5105619553404083`*^9}, {3.5106285477833276`*^9, 
   3.5106286902115774`*^9}, {3.510629347182332*^9, 3.510629358086751*^9}, {
   3.5106295553334975`*^9, 3.5106295558638983`*^9}, {3.5106573586878967`*^9, 
   3.5106574988697433`*^9}, 3.5106575498350325`*^9, {3.5106575855122952`*^9, 
   3.510657586838298*^9}, 3.510657701592099*^9, {3.510918992301849*^9, 
   3.510919033813522*^9}, {3.510919072236389*^9, 3.5109190853248124`*^9}, {
   3.511002629373726*^9, 3.511002636112938*^9}, {3.511142697495368*^9, 
   3.511142697651368*^9}, {3.511148104096464*^9, 3.5111481386037245`*^9}, {
   3.5112308639264946`*^9, 3.5112308672337008`*^9}, 3.5127273081131516`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matMpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"kinetic", ",", 
           RowBox[{"velvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"velparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "velparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510629277247409*^9, 3.5106293107406683`*^9}, {
   3.510629367384368*^9, 3.510629370301573*^9}, {3.5106295599043055`*^9, 
   3.5106295603567066`*^9}, {3.510657365037108*^9, 3.5106574369532347`*^9}, 
   3.510657709126912*^9, {3.5106577452409763`*^9, 3.510657747034979*^9}, {
   3.5109190411611347`*^9, 3.510919114247263*^9}, 3.51091916922176*^9, {
   3.5109193418204627`*^9, 3.51091934586087*^9}, 3.5109555482566385`*^9, {
   3.5110026383125415`*^9, 3.5110026412609468`*^9}, {3.5111427006777735`*^9, 
   3.511142701020974*^9}, {3.5111428283327975`*^9, 3.5111428289723988`*^9}, {
   3.51114814166133*^9, 3.5111481490869427`*^9}, {3.511230607696045*^9, 
   3.511230615230858*^9}, {3.5112308557832804`*^9, 3.5112308586848855`*^9}, 
   3.5127273090023527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness Matrix", "Subsection",
 CellChangeTimes->{{3.510628701318797*^9, 3.510628705218804*^9}, {
  3.510628763250906*^9, 3.5106287646393085`*^9}}],

Cell[CellGroupData[{

Cell["Only Real", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109555066872606`*^9, 3.510955522479164*^9}, {
  3.5111459241018353`*^9, 3.511145929171844*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matKvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"potential", ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5105619627036214`*^9, 3.510561989847669*^9}, 
   3.510562426586036*^9, {3.510562624565984*^9, 3.5105626282787905`*^9}, 
   3.510562823575534*^9, {3.5106287756061277`*^9, 3.5106287991777687`*^9}, 
   3.510629372735177*^9, {3.5106295648963146`*^9, 3.5106295735387297`*^9}, 
   3.510634023423352*^9, 3.5106340995670853`*^9, 3.510634705986951*^9, 
   3.5106357421095705`*^9, {3.5106577195477304`*^9, 3.5106577496869836`*^9}, {
   3.510919174588169*^9, 3.5109192067710257`*^9}, {3.51091935724889*^9, 
   3.5109193604780955`*^9}, 3.510955522479164*^9, {3.511000578777713*^9, 
   3.5110005872953277`*^9}, 3.511002643460551*^9, {3.51100273993112*^9, 
   3.511002769945573*^9}, {3.5110030522904687`*^9, 3.511003069060498*^9}, {
   3.511141726877263*^9, 3.511141728328066*^9}, 3.511141847169074*^9, {
   3.51114310883689*^9, 3.511143116262503*^9}, {3.511143405602212*^9, 
   3.5111434129186244`*^9}, {3.5111459241018353`*^9, 3.511145929171844*^9}, {
   3.5112308780601196`*^9, 3.5112308853609324`*^9}, 3.512727244075039*^9, 
   3.512727310281555*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matKpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"potential", ",", 
           RowBox[{"allvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"allparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "allparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510629298089046*^9, 3.510629328524699*^9}, {
   3.5106295791391397`*^9, 3.510629587048353*^9}, 3.5106341033890924`*^9, 
   3.5106343797903776`*^9, 3.510634742647015*^9, 3.510635745759977*^9, {
   3.510657728892147*^9, 3.510657756722596*^9}, 3.5109191710313625`*^9, {
   3.5109192125430355`*^9, 3.5109192243990564`*^9}, {3.510919348949675*^9, 
   3.5109193550336857`*^9}, {3.510955522479164*^9, 3.5109555416132584`*^9}, {
   3.5110027536747446`*^9, 3.511002764969164*^9}, {3.5111417317132716`*^9, 
   3.5111417374696817`*^9}, 3.511141852644684*^9, {3.5111428317960033`*^9, 
   3.5111428323108044`*^9}, {3.5111459241018353`*^9, 3.511145929171844*^9}, {
   3.511230887888137*^9, 3.5112309006801596`*^9}, 3.5127272467426434`*^9, 
   3.5127273111395564`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "allfloats", "]"}], "\[GreaterEqual]", "1"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"matKfv", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allvars", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKff", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKfp", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allparams", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allparams", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKvv", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfv", ".", 
          RowBox[{"Inverse", "[", "matKff", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfv", "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"matKpv", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfv", ".", 
          RowBox[{"Inverse", "[", "matKff", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfp", "]"}]}], "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5111416497975273`*^9, 3.5111417209960527`*^9}, {
  3.5111417526641083`*^9, 3.5111418619267*^9}, {3.511142246202175*^9, 
  3.5111422962938633`*^9}, {3.5111425664863377`*^9, 3.5111425873747745`*^9}, {
  3.5111428355400105`*^9, 3.5111428761468816`*^9}, {3.511142909967741*^9, 
  3.511142930606577*^9}, {3.511142981868267*^9, 3.5111430139887238`*^9}, {
  3.5111430674656177`*^9, 3.511143067824418*^9}, {3.511143466379918*^9, 
  3.51114346733152*^9}, {3.5111435471100597`*^9, 3.5111435507604666`*^9}, {
  3.5111436040657597`*^9, 3.5111436094009695`*^9}, {3.511145929171844*^9, 
  3.5111459456454725`*^9}, {3.511149406308751*^9, 3.5111494064335513`*^9}, {
  3.5112309057189684`*^9, 3.5112309636574697`*^9}, {3.5112312731776133`*^9, 
  3.5112313016164637`*^9}, {3.5127272495194483`*^9, 3.5127272553538585`*^9}, {
  3.512727288207516*^9, 3.5127273062099476`*^9}, {3.512735314694819*^9, 
  3.512735322167232*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["With Imaginary Part", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.51095551455171*^9, 3.510955530382616*^9}, {
  3.5111481601941624`*^9, 3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matKvvc", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"potentialc", ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5105619627036214`*^9, 3.510561989847669*^9}, 
   3.510562426586036*^9, {3.510562624565984*^9, 3.5105626282787905`*^9}, 
   3.510562823575534*^9, {3.5106287756061277`*^9, 3.5106287991777687`*^9}, 
   3.510629372735177*^9, {3.5106295648963146`*^9, 3.5106295735387297`*^9}, 
   3.510634023423352*^9, 3.5106340995670853`*^9, 3.510634705986951*^9, 
   3.5106357421095705`*^9, {3.5106577195477304`*^9, 3.5106577496869836`*^9}, {
   3.510919174588169*^9, 3.5109192067710257`*^9}, {3.51091935724889*^9, 
   3.5109193604780955`*^9}, {3.510922241814151*^9, 3.5109222467374325`*^9}, 
   3.510955530382616*^9, {3.5110005587316775`*^9, 3.5110005689340954`*^9}, {
   3.511002971747527*^9, 3.511002992214763*^9}, {3.5111437697380514`*^9, 
   3.5111437766956635`*^9}, 3.511143821826543*^9, {3.5111481601941624`*^9, 
   3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matKpvc", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"potentialc", ",", 
           RowBox[{"allvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"allparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "allparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510629298089046*^9, 3.510629328524699*^9}, {
   3.5106295791391397`*^9, 3.510629587048353*^9}, 3.5106341033890924`*^9, 
   3.5106343797903776`*^9, 3.510634742647015*^9, 3.510635745759977*^9, {
   3.510657728892147*^9, 3.510657756722596*^9}, 3.5109191710313625`*^9, {
   3.5109192125430355`*^9, 3.5109192243990564`*^9}, {3.510919348949675*^9, 
   3.5109193550336857`*^9}, {3.5109222445573077`*^9, 
   3.5109222483205233`*^9}, {3.510955530382616*^9, 3.510955540563198*^9}, {
   3.511002993930766*^9, 3.5110029968011713`*^9}, {3.511143772499256*^9, 
   3.511143780985671*^9}, 3.5111438228093443`*^9, {3.5111481601941624`*^9, 
   3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "allfloats", "]"}], "\[GreaterEqual]", "1"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"matKfvc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allvars", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKffc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKfpc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allparams", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allparams", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKvvc", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfvc", ".", 
          RowBox[{"Inverse", "[", "matKffc", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfvc", "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"matKpvc", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfvc", ".", 
          RowBox[{"Inverse", "[", "matKffc", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfpc", "]"}]}], "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5111416497975273`*^9, 3.5111417209960527`*^9}, {
   3.5111417526641083`*^9, 3.5111418619267*^9}, {3.511142246202175*^9, 
   3.5111422962938633`*^9}, {3.5111425664863377`*^9, 
   3.5111425873747745`*^9}, {3.5111428355400105`*^9, 
   3.5111428761468816`*^9}, {3.511142909967741*^9, 3.511142930606577*^9}, {
   3.511142981868267*^9, 3.5111430139887238`*^9}, {3.5111430674656177`*^9, 
   3.511143067824418*^9}, {3.511143466379918*^9, 3.51114346733152*^9}, {
   3.5111435471100597`*^9, 3.5111435507604666`*^9}, {3.5111436040657597`*^9, 
   3.5111436094009695`*^9}, {3.5111438011565065`*^9, 3.511143815914132*^9}, 
   3.511148165466972*^9, {3.5111494314871955`*^9, 3.511149431689996*^9}, {
   3.512727323993979*^9, 3.5127273242591796`*^9}, {3.5127352324358745`*^9, 
   3.512735240625889*^9}, {3.5127353013099957`*^9, 3.5127353103736115`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping Matrix", "Subsection",
 CellChangeTimes->{{3.510561334346517*^9, 3.510561337388523*^9}, {
  3.5113900124941225`*^9, 3.511390015442528*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matGvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"damping", ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510561339822127*^9, 3.5105613828470025`*^9}, {
   3.5105614843563805`*^9, 3.51056150657082*^9}, {3.510561663541896*^9, 
   3.5105617389524283`*^9}, {3.5105619183683434`*^9, 
   3.5105619553404083`*^9}, {3.5106285477833276`*^9, 
   3.5106286902115774`*^9}, {3.510629347182332*^9, 3.510629358086751*^9}, {
   3.5106295553334975`*^9, 3.5106295558638983`*^9}, {3.5106573586878967`*^9, 
   3.5106574988697433`*^9}, 3.5106575498350325`*^9, {3.5106575855122952`*^9, 
   3.510657586838298*^9}, 3.510657701592099*^9, {3.510918992301849*^9, 
   3.510919033813522*^9}, {3.510919072236389*^9, 3.5109190853248124`*^9}, {
   3.511002629373726*^9, 3.511002636112938*^9}, {3.511142697495368*^9, 
   3.511142697651368*^9}, {3.511148104096464*^9, 3.5111481386037245`*^9}, {
   3.5112308639264946`*^9, 3.5112308672337008`*^9}, {3.511390018359733*^9, 
   3.511390025722946*^9}, {3.5113900655654163`*^9, 3.511390079979841*^9}, 
   3.512727336255601*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matGpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"damping", ",", 
           RowBox[{"velvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"velparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "velparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510629277247409*^9, 3.5106293107406683`*^9}, {
   3.510629367384368*^9, 3.510629370301573*^9}, {3.5106295599043055`*^9, 
   3.5106295603567066`*^9}, {3.510657365037108*^9, 3.5106574369532347`*^9}, 
   3.510657709126912*^9, {3.5106577452409763`*^9, 3.510657747034979*^9}, {
   3.5109190411611347`*^9, 3.510919114247263*^9}, 3.51091916922176*^9, {
   3.5109193418204627`*^9, 3.51091934586087*^9}, 3.5109555482566385`*^9, {
   3.5110026383125415`*^9, 3.5110026412609468`*^9}, {3.5111427006777735`*^9, 
   3.511142701020974*^9}, {3.5111428283327975`*^9, 3.5111428289723988`*^9}, {
   3.51114814166133*^9, 3.5111481490869427`*^9}, {3.511230607696045*^9, 
   3.511230615230858*^9}, {3.5112308557832804`*^9, 3.5112308586848855`*^9}, {
   3.511390021198938*^9, 3.5113900346461616`*^9}, {3.5113900824290457`*^9, 
   3.511390094378667*^9}, 3.5127273373944025`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigen Mode", "Section",
 CellChangeTimes->{{3.510639974173004*^9, 3.51063997762061*^9}}],

Cell[CellGroupData[{

Cell["Eigen Frequencies & Vectors", "Subsection",
 CellChangeTimes->{{3.5106399863410254`*^9, 3.510639995685442*^9}, {
  3.5109193175936203`*^9, 3.510919324769633*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eigen", "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{
     RowBox[{"Inverse", "[", "matMvv", "]"}], ".", 
     RowBox[{"Re", "[", "matKvv", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigenf", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"eigen", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", 
       RowBox[{"N", "[", "Pi", "]"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigenv", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{"eigen", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5106404812986946`*^9, 3.5106405612644353`*^9}, {
  3.510642026727812*^9, 3.510642034652625*^9}, {3.510642839520439*^9, 
  3.510642845308049*^9}, {3.5106429258041906`*^9, 3.510642929423397*^9}, {
  3.5106434421806974`*^9, 3.510643450791913*^9}, {3.5109192830239596`*^9, 
  3.510919329933242*^9}, {3.511143879000643*^9, 3.5111438815434475`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigen Mode Listup", "Subsection",
 CellChangeTimes->{{3.5106417564485364`*^9, 3.510641767571356*^9}, {
  3.5106435074824123`*^9, 3.5106435076384125`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eigenmodetable", "[", 
  RowBox[{"eigenf", ",", "eigenv", ",", "0.2", ",", "20"}], "]"}]], "Input",
 CellChangeTimes->{{3.5106432816876154`*^9, 3.510643291593633*^9}, {
   3.510921715107025*^9, 3.510921737338297*^9}, {3.510922100897091*^9, 
   3.5109221122847424`*^9}, 3.5109585862628655`*^9, {3.511407145469161*^9, 
   3.5114071462179623`*^9}, {3.5114900165592413`*^9, 3.511490016886842*^9}, {
   3.512727357924039*^9, 3.51272735881324*^9}, {3.5141696572652583`*^9, 
   3.514169657561659*^9}, {3.514512427040951*^9, 3.514512427134551*^9}, {
   3.518762712480324*^9, 3.5187627130263247`*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"N\"\>", "\<\"Freq\"\>", "\<\"Type\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
    {"1", 
     "0.0066132039107983775`", "\<\"yawF3(-0.258068)\"\>", \
"\<\"yawF4(-0.379541)\"\>", "\<\"yawIM(-0.453954)\"\>", \
"\<\"yawIRM(-0.379629)\"\>", "\<\"yawTM(-0.454004)\"\>", "\<\"yawRM(-0.45401)\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"2", 
     "0.01752493647663441`", "\<\"yawF2(0.23548)\"\>", "\<\"yawF3(0.259452)\"\
\>", "\<\"yawIM(-0.531494)\"\>", "\<\"yawTM(-0.531907)\"\>", \
"\<\"yawRM(-0.531956)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\
\<\"\"\>"},
    {"3", 
     "0.022879129468793842`", "\<\"yawF1(0.269255)\"\>", "\<\"yawF2(0.428571)\
\"\>", "\<\"yawF3(0.23565)\"\>", "\<\"yawF4(-0.362305)\"\>", \
"\<\"yawIM(0.376024)\"\>", "\<\"yawIRM(-0.36331)\"\>", "\<\"yawTM(0.376523)\"\
\>", "\<\"yawRM(0.376581)\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"4", 
     "0.02571996368429456`", "\<\"xF0(0.310218)\"\>", \
"\<\"xF1(0.311992)\"\>", "\<\"xF2(0.313783)\"\>", "\<\"xF3(0.315791)\"\>", \
"\<\"xF4(0.317578)\"\>", "\<\"xIM(0.319356)\"\>", "\<\"xIRM(0.319358)\"\>", "\
\<\"xTM(0.321145)\"\>", "\<\"xRM(0.321144)\"\>", "\<\"xMD(0.311665)\"\>"},
    {"5", 
     "0.02571996395368479`", "\<\"zF0(-0.310218)\"\>", \
"\<\"zF1(-0.311992)\"\>", "\<\"zF2(-0.313783)\"\>", "\<\"zF3(-0.315791)\"\>", \
"\<\"zF4(-0.317578)\"\>", "\<\"zIM(-0.319356)\"\>", \
"\<\"zIRM(-0.319358)\"\>", "\<\"zTM(-0.321145)\"\>", \
"\<\"zRM(-0.321144)\"\>", "\<\"zMD(-0.311665)\"\>"},
    {"6", 
     "0.0351078391391142`", "\<\"yawF1(-0.527286)\"\>", \
"\<\"yawF2(-0.35457)\"\>", "\<\"yawF3(0.734853)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"7", 
     "0.049002711189489616`", "\<\"yawF1(0.743963)\"\>", \
"\<\"yawF2(-0.628063)\"\>", "\<\"yawF3(0.224246)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"8", 
     "0.08897449441261593`", "\<\"yawF0(0.692453)\"\>", \
"\<\"yawMD(0.712159)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"9", 
     "0.16458773627933454`", "\<\"yF3(-0.249072)\"\>", \
"\<\"yF4(-0.352073)\"\>", "\<\"yIM(-0.469037)\"\>", \
"\<\"yIRM(-0.352377)\"\>", "\<\"yTM(-0.469422)\"\>", \
"\<\"yRM(-0.469342)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"10", 
     "0.19972468585085057`", "\<\"xIM(0.345413)\"\>", \
"\<\"xIRM(0.288183)\"\>", "\<\"xTM(0.520465)\"\>", "\<\"xRM(0.521055)\"\>", "\
\<\"xMD(-0.235578)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
    {"11", 
     "0.19981466813044904`", "\<\"zIM(-0.355874)\"\>", "\<\"zIRM(-0.297597)\"\
\>", "\<\"zTM(-0.536249)\"\>", "\<\"zRM(-0.536334)\"\>", "\<\"zMD(0.242929)\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"12", 
     "0.263750345980607`", "\<\"rollIM(-0.577041)\"\>", \
"\<\"rollTM(-0.577199)\"\>", "\<\"rollRM(-0.577449)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"13", 
     "0.3092386280220194`", "\<\"pitchIM(0.440072)\"\>", \
"\<\"zIRM(0.497743)\"\>", "\<\"zTM(-0.241621)\"\>", \
"\<\"pitchTM(0.448277)\"\>", "\<\"zRM(-0.250435)\"\>", "\<\"pitchRM(0.457094)\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"14", 
     "0.31073068694336026`", "\<\"rollIM(-0.287895)\"\>", \
"\<\"xIRM(-0.678921)\"\>", "\<\"xTM(0.35397)\"\>", \
"\<\"rollTM(-0.287986)\"\>", "\<\"xRM(0.341059)\"\>", \
"\<\"rollRM(-0.288172)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"15", 
     "0.3415752747651652`", "\<\"pitchIM(-0.558733)\"\>", \
"\<\"pitchTM(-0.566382)\"\>", "\<\"pitchRM(-0.584923)\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"16", 
     "0.34486762218768546`", "\<\"xTM(-0.99212)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"17", 
     "0.34553785207703175`", "\<\"pitchIM(-0.46268)\"\>", \
"\<\"zTM(0.554438)\"\>", "\<\"pitchTM(-0.488023)\"\>", \
"\<\"pitchRM(-0.484305)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
    {"18", 
     "0.3843585933004335`", "\<\"xMD(-0.983937)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"19", 
     "0.3843719159727845`", "\<\"zMD(0.980854)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"20", 
     "0.42992451210241345`", "\<\"yF2(-0.352625)\"\>", \
"\<\"yF3(-0.412612)\"\>", "\<\"yF4(-0.287805)\"\>", "\<\"yIM(0.40776)\"\>", "\
\<\"yIRM(-0.289511)\"\>", "\<\"yTM(0.410055)\"\>", "\<\"yRM(0.409581)\"\>", "\
\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"N", "Freq", "Type"}, {
    1, 0.0066132039107983775`, "yawF3(-0.258068)", "yawF4(-0.379541)", 
     "yawIM(-0.453954)", "yawIRM(-0.379629)", "yawTM(-0.454004)", 
     "yawRM(-0.45401)"}, {
    2, 0.01752493647663441, "yawF2(0.23548)", "yawF3(0.259452)", 
     "yawIM(-0.531494)", "yawTM(-0.531907)", "yawRM(-0.531956)"}, {
    3, 0.022879129468793842`, "yawF1(0.269255)", "yawF2(0.428571)", 
     "yawF3(0.23565)", "yawF4(-0.362305)", "yawIM(0.376024)", 
     "yawIRM(-0.36331)", "yawTM(0.376523)", "yawRM(0.376581)"}, {
    4, 0.02571996368429456, "xF0(0.310218)", "xF1(0.311992)", "xF2(0.313783)",
      "xF3(0.315791)", "xF4(0.317578)", "xIM(0.319356)", "xIRM(0.319358)", 
     "xTM(0.321145)", "xRM(0.321144)", "xMD(0.311665)"}, {
    5, 0.02571996395368479, "zF0(-0.310218)", "zF1(-0.311992)", 
     "zF2(-0.313783)", "zF3(-0.315791)", "zF4(-0.317578)", "zIM(-0.319356)", 
     "zIRM(-0.319358)", "zTM(-0.321145)", "zRM(-0.321144)", 
     "zMD(-0.311665)"}, {
    6, 0.0351078391391142, "yawF1(-0.527286)", "yawF2(-0.35457)", 
     "yawF3(0.734853)"}, {
    7, 0.049002711189489616`, "yawF1(0.743963)", "yawF2(-0.628063)", 
     "yawF3(0.224246)"}, {
    8, 0.08897449441261593, "yawF0(0.692453)", "yawMD(0.712159)"}, {
    9, 0.16458773627933454`, "yF3(-0.249072)", "yF4(-0.352073)", 
     "yIM(-0.469037)", "yIRM(-0.352377)", "yTM(-0.469422)", 
     "yRM(-0.469342)"}, {
    10, 0.19972468585085057`, "xIM(0.345413)", "xIRM(0.288183)", 
     "xTM(0.520465)", "xRM(0.521055)", "xMD(-0.235578)"}, {
    11, 0.19981466813044904`, "zIM(-0.355874)", "zIRM(-0.297597)", 
     "zTM(-0.536249)", "zRM(-0.536334)", "zMD(0.242929)"}, {
    12, 0.263750345980607, "rollIM(-0.577041)", "rollTM(-0.577199)", 
     "rollRM(-0.577449)"}, {
    13, 0.3092386280220194, "pitchIM(0.440072)", "zIRM(0.497743)", 
     "zTM(-0.241621)", "pitchTM(0.448277)", "zRM(-0.250435)", 
     "pitchRM(0.457094)"}, {
    14, 0.31073068694336026`, "rollIM(-0.287895)", "xIRM(-0.678921)", 
     "xTM(0.35397)", "rollTM(-0.287986)", "xRM(0.341059)", 
     "rollRM(-0.288172)"}, {
    15, 0.3415752747651652, "pitchIM(-0.558733)", "pitchTM(-0.566382)", 
     "pitchRM(-0.584923)"}, {16, 0.34486762218768546`, "xTM(-0.99212)"}, {
    17, 0.34553785207703175`, "pitchIM(-0.46268)", "zTM(0.554438)", 
     "pitchTM(-0.488023)", "pitchRM(-0.484305)"}, {
    18, 0.3843585933004335, "xMD(-0.983937)"}, {
    19, 0.3843719159727845, "zMD(0.980854)"}, {
    20, 0.42992451210241345`, "yF2(-0.352625)", "yF3(-0.412612)", 
     "yF4(-0.287805)", "yIM(0.40776)", "yIRM(-0.289511)", "yTM(0.410055)", 
     "yRM(0.409581)"}}]]], "Output",
 CellChangeTimes->{
  3.510643292919636*^9, 3.5106433400473185`*^9, 3.5106434238662653`*^9, 
   3.5106434762355576`*^9, 3.510643723168391*^9, 3.5106438344589863`*^9, 
   3.510643892756289*^9, 3.5106577700762196`*^9, 3.5108253730494413`*^9, 
   3.51082974384672*^9, 3.510829776169977*^9, 3.5108302338369813`*^9, 
   3.5108303752356296`*^9, {3.5108305553691463`*^9, 3.51083057477558*^9}, 
   3.5108307570151005`*^9, 3.510878378699349*^9, 3.5109217415145354`*^9, 
   3.510921781893845*^9, {3.5109221017821417`*^9, 3.5109221126697645`*^9}, 
   3.510956284636422*^9, 3.510958555156411*^9, 3.5109585879476686`*^9, 
   3.510976004120376*^9, 3.5109762241431627`*^9, 3.510981586648802*^9, 
   3.510997623852915*^9, 3.510997670574997*^9, 3.5109978286968746`*^9, 
   3.5110005994633493`*^9, 3.5110012262880497`*^9, 3.511002249466259*^9, 
   3.5110027958260183`*^9, 3.5110032275255766`*^9, 3.511003483288026*^9, 
   3.5110045135606356`*^9, 3.5110674087517023`*^9, 3.511144001897659*^9, 
   3.5111469200231843`*^9, 3.511147217780907*^9, 3.5111479339157653`*^9, 
   3.511149448413225*^9, {3.5111495020461197`*^9, 3.5111495104389343`*^9}, 
   3.511150737209489*^9, 3.51115124445998*^9, 3.5111525863899364`*^9, 
   3.511152661114068*^9, 3.5111551241458*^9, 3.5112282013762183`*^9, 
   3.511228596821313*^9, 3.5112287471743765`*^9, 3.5112289126906676`*^9, 
   3.5112289448423243`*^9, 3.5112292057371826`*^9, 3.5112293438286247`*^9, 
   3.511229669666397*^9, {3.511229940545273*^9, 3.511229945724482*^9}, 
   3.511230367908024*^9, 3.5112305163578844`*^9, 3.5112318289909897`*^9, 
   3.5112323159368496`*^9, 3.511232424778241*^9, 3.5112324581154995`*^9, 
   3.51123249266956*^9, 3.511232537082838*^9, 3.5112325809033155`*^9, 
   3.5112326565478477`*^9, 3.5112328450429792`*^9, 3.511232907536689*^9, 
   3.511233228663253*^9, 3.511329491833839*^9, 3.5113304379287033`*^9, 
   3.5113306313690434`*^9, 3.511331015972119*^9, 3.511331177635203*^9, 
   3.5113329869263806`*^9, 3.511406697171174*^9, 3.5114067818637223`*^9, 
   3.5114069491428165`*^9, 3.5114071480587654`*^9, 3.5114315657357717`*^9, 
   3.511490058913316*^9, 3.511494334787651*^9, 3.511496090224537*^9, 
   3.512355787464673*^9, 3.5123560041613693`*^9, 3.5127108132167463`*^9, 
   3.5127123258698044`*^9, 3.5127125177033415`*^9, 3.5127126119275064`*^9, 
   3.512730655448633*^9, 3.5127329310730324`*^9, 3.512803856311219*^9, 
   3.5141687865653296`*^9, 3.51416965823246*^9, 3.514173620607836*^9, 
   3.514511740592945*^9, 3.5145122675930705`*^9, 3.5145124275713515`*^9, 
   3.51451543207063*^9, 3.514515800418477*^9, 3.5148538536027956`*^9, 
   3.5154522117490215`*^9, 3.5166690020851974`*^9, 3.5166696113754673`*^9, 
   3.5172673452534847`*^9, 3.5172777645970917`*^9, 3.517282886633877*^9, 
   3.517287568374494*^9, 3.517530658729537*^9, 3.5176110199253674`*^9, 
   3.517696361851734*^9, 3.5176988541527414`*^9, 3.5176991698028955`*^9, 
   3.517720016995942*^9, 3.5177323444135404`*^9, 3.5178785616593914`*^9, 
   3.5187626661794424`*^9, 3.518762713697126*^9, 3.51876289247344*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigen Mode 3D-Graphics", "Subsection",
 CellChangeTimes->{{3.5108295124827137`*^9, 3.510829513075515*^9}, {
  3.510956048202407*^9, 3.510956066017638*^9}}],

Cell[CellGroupData[{

Cell["Plot Range Definition", "Subsubsection",
 CellChangeTimes->{{3.51082764299103*^9, 3.5108276467818365`*^9}, {
   3.5109210878847294`*^9, 3.51092116774127*^9}, 3.5109212261165724`*^9, 
   3.511003172847481*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"maxz", "=", 
    RowBox[{"2.5", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", 
    RowBox[{"width", " ", "of", " ", "the", " ", "system"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maxx", "=", 
    RowBox[{"2.5", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", 
    RowBox[{"width", " ", "of", " ", "the", " ", "system"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ytop", "=", 
    RowBox[{"1.0", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Top", " ", "height", " ", "of", " ", "the", " ", "system"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ybottom", "=", 
    RowBox[{
     RowBox[{"-", "13.0"}], "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Bottom", " ", "height", " ", "of", " ", "the", " ", "system"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109211968977213`*^9, 3.5109212408741984`*^9}, {
   3.5109220308510847`*^9, 3.5109220309910927`*^9}, {3.510958542473589*^9, 
   3.51095854336279*^9}, {3.510968368593365*^9, 3.510968418575853*^9}, {
   3.5109954409480605`*^9, 3.510995447197418*^9}, {3.5109987157704387`*^9, 
   3.510998749638098*^9}, {3.511001189939986*^9, 3.511001205306013*^9}, 
   3.511003172847481*^9, {3.511129432507734*^9, 3.5111294518908424`*^9}, {
   3.511152966983805*^9, 3.5111529708682117`*^9}, {3.511228562750853*^9, 
   3.5112285692248645`*^9}, {3.511229309087364*^9, 3.5112293130029707`*^9}, {
   3.511329984950708*^9, 3.5113299977115307`*^9}, {3.5127101502779818`*^9, 
   3.512710157438394*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigen Mode 3D-Graphics", "Subsubsection",
 CellChangeTimes->{{3.512709012365183*^9, 3.5127090238936033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eigenplot", "[", 
  RowBox[{"eigenv", ",", "1.0", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{{3.5108281708803577`*^9, 3.5108281797879734`*^9}, {
   3.510829089456771*^9, 3.510829089612771*^9}, {3.5108291378012557`*^9, 
   3.510829143760466*^9}, {3.510829207346178*^9, 3.5108292251926093`*^9}, {
   3.510829318496373*^9, 3.5108293323959975`*^9}, {3.510829380802882*^9, 
   3.510829395279708*^9}, {3.5108294539514112`*^9, 3.510829454965413*^9}, {
   3.5108783919749727`*^9, 3.5108784826891317`*^9}, {3.5108858833120837`*^9, 
   3.510885917039343*^9}, {3.510922053102357*^9, 3.5109220655000668`*^9}, {
   3.510922145501642*^9, 3.510922154304146*^9}, {3.5109586034072957`*^9, 
   3.5109586510965796`*^9}, 3.510965620835739*^9, {3.510980713272068*^9, 
   3.510980713412468*^9}, {3.510980751289335*^9, 3.5109807514297347`*^9}, {
   3.5109808130498433`*^9, 3.5109808621743293`*^9}, {3.5109855664036036`*^9, 
   3.5109855667624035`*^9}, {3.5109976790926123`*^9, 
   3.5109976792174125`*^9}, {3.511001058291355*^9, 3.511001058431755*^9}, {
   3.5110023185587797`*^9, 3.5110024376649895`*^9}, {3.5110673866620636`*^9, 
   3.511067386771264*^9}, {3.5110674313873425`*^9, 3.5110674526969795`*^9}, {
   3.511144014627281*^9, 3.511144014752082*^9}, {3.5111443615094905`*^9, 
   3.5111444172171884`*^9}, {3.5111444872457113`*^9, 
   3.5111444874173117`*^9}, {3.5111456221165047`*^9, 3.511145622912106*^9}, {
   3.5111469295080013`*^9, 3.5111469378540154`*^9}, {3.511151653352298*^9, 
   3.5111516692799263`*^9}, {3.511151703802787*^9, 3.511151709512397*^9}, {
   3.511151764393293*^9, 3.5111517990409536`*^9}, {3.5111527228745766`*^9, 
   3.5111527274921846`*^9}, {3.5111617369272847`*^9, 
   3.5111617373016853`*^9}, {3.5112282465694976`*^9, 
   3.5112282467566977`*^9}, {3.51122895378114*^9, 3.5112289539215403`*^9}, {
   3.511229358477051*^9, 3.511229397243119*^9}, {3.511229844729905*^9, 
   3.5112298448859053`*^9}, {3.5112299955977697`*^9, 3.511230027671426*^9}, {
   3.511230389014861*^9, 3.5112304126021023`*^9}, {3.511230529056307*^9, 
   3.5112305886172113`*^9}, {3.5112323789921603`*^9, 3.511232379179361*^9}, {
   3.511329531691909*^9, 3.5113295318791094`*^9}, {3.5113300860076857`*^9, 
   3.5113301632590213`*^9}, {3.5113302681380053`*^9, 3.511330268933607*^9}, {
   3.511330485617987*^9, 3.5113304862263885`*^9}, {3.5114070321661625`*^9, 
   3.5114070887786617`*^9}, {3.511407177605218*^9, 3.511407177886018*^9}, {
   3.511431574518587*^9, 3.511431579869396*^9}, {3.512710907830912*^9, 
   3.5127109337113576`*^9}, {3.512730678006273*^9, 3.5127307128567343`*^9}, {
   3.5128038599460254`*^9, 3.512803860897627*^9}, {3.5141688026645575`*^9, 
   3.514168802836158*^9}, {3.514169781753477*^9, 3.5141697820186777`*^9}, {
   3.5145124135625267`*^9, 3.5145124144361286`*^9}, {3.514514861579228*^9, 
   3.5145148617664285`*^9}, {3.514514972542223*^9, 3.5145149841330433`*^9}, {
   3.5148539427569523`*^9, 3.5148539486381626`*^9}, {3.514854022987893*^9, 
   3.5148540232998934`*^9}, {3.5148540834067993`*^9, 
   3.5148541213304653`*^9}, {3.5148541570077286`*^9, 
   3.5148541571325283`*^9}, {3.5148542168026333`*^9, 
   3.5148542170522337`*^9}, {3.5148542805755453`*^9, 3.514854280996746*^9}, {
   3.5148543385764475`*^9, 3.5148543387324476`*^9}, {3.5148544255934*^9, 
   3.514854451895046*^9}, {3.5154521716881514`*^9, 3.5154521731077538`*^9}, {
   3.5166696701875706`*^9, 3.5166698756243315`*^9}, {3.517267363489917*^9, 
   3.517267363630317*^9}, {3.5172777747683096`*^9, 3.5172777752207108`*^9}, {
   3.5172780539776*^9, 3.5172780543832006`*^9}, {3.5172873270732703`*^9, 
   3.517287327541271*^9}, {3.517287585269324*^9, 3.517287585362924*^9}, {
   3.5175307367452736`*^9, 3.517530736854474*^9}, {3.517611036804597*^9, 
   3.5176110534966264`*^9}, {3.517720569478913*^9, 3.5177205699469137`*^9}, {
   3.5178786092706747`*^9, 3.517878645977539*^9}, {3.5187626788310647`*^9, 
   3.518762686506278*^9}, {3.518762722308341*^9, 3.518762730404755*^9}}],

Cell[BoxData[
 Graphics3DBox[{Point3DBox[{1.25, 1., 1.25}], Point3DBox[{-1.25, 1., 1.25}], 
   Point3DBox[{1.25, 1., -1.25}], Point3DBox[{-1.25, 1., -1.25}], 
   Point3DBox[{1.25, -13., 1.25}], Point3DBox[{-1.25, -13., 1.25}], 
   Point3DBox[{1.25, -13., -1.25}], Point3DBox[{-1.25, -13., -1.25}], 
   Line3DBox[{{-2.025998565077379*^-15, 
    0.486747968246329, -0.030229944364177808`}, {-2.0252090934857767`*^-16, \
-1.5943069232946434`, -0.004131943324635812}}], 
   Line3DBox[{{-1.5546882692861215`*^-16, -1.6304326237419966`, \
-0.0036023789675458033`}, {2.1587067791087735`*^-15, -3.7117183305409838`, 
    0.02897890954092154}}], 
   Line3DBox[{{2.2077051366125995`*^-15, -3.7470359594929943`, 
    0.029603900898732827`}, {4.746553084641176*^-15, -6.079505813617784, 
    0.06845806700781007}}], 
   Line3DBox[{{4.79743542562394*^-15, -6.113204365087618, 
    0.06907083134588991}, {6.664511032325087*^-15, -8.18204554190771, 
    0.097674879595086}}], 
   Line3DBox[{{6.84146257121316*^-15, -8.214332833133852, 
    0.09784016594011816}, {
    1.0816114941204427`*^-16, -10.281521077223577`, -0.04368554218008183}}], 
   Line3DBox[{{-0.2999999999999932, -8.206608755404442, \
-0.15220265126006455`}, {-0.29999999999997323`, -10.294502947196833`, 
    0.24773097133467142`}}], 
   Line3DBox[{{-0.2999999999999932, -8.204049169681994, 
    0.3477907972179424}, {-0.2999999999999736, -10.291901800870114`, 
    0.7477242053266795}}], 
   Line3DBox[{{0.30000000000000676`, -8.20404916968199, 0.3477907972179424}, {
    0.30000000000002636`, -10.29190180087011, 0.7477242053266799}}], 
   Line3DBox[{{
    0.30000000000000676`, -8.206608755404439, -0.15220265126006455`}, {
    0.30000000000002675`, -10.294502947196829`, 0.24773097133467184`}}], 
   Line3DBox[{{-0.12499999999999992`, -10.28115017019574, \
-0.060090594384490055`}, {-0.12500000000002057`, -12.371536364037953`, \
-0.2544348277097562}}], 
   Line3DBox[{{-0.12499999999999939`, -10.293930321541758`, \
-0.032948970785801314`}, {-0.12500000000002007`, -12.384538770438091`, \
-0.22739897322343314`}}], 
   Line3DBox[{{
    0.1250000000000006, -10.293930321541747`, -0.0329489707858015}, {
    0.12499999999997993`, -12.38453877043808, -0.22739897322343297`}}], 
   Line3DBox[{{
    0.12500000000000008`, -10.28115017019573, -0.06009059438449024}, {
    0.12499999999997943`, -12.371536364037942`, -0.254434827709756}}], 
   Line3DBox[{{-0.28900000000000015`, -10.275017275915165`, \
-0.07930907190144502}, {-0.28900000000001064`, -12.358681405488445`, \
-0.279960211706976}}], 
   Line3DBox[{{-0.2889999999999989, -10.304837629055871`, \
-0.01597861683783795}, {-0.28900000000000936`, -12.389575380032275`, \
-0.21714650033051622`}}], 
   Line3DBox[{{
    0.28900000000000103`, -10.30483762905585, -0.015978616837838397`}, {
    0.2889999999999906, -12.389575380032253`, -0.2171465003305169}}], 
   Line3DBox[{{
    0.2889999999999998, -10.275017275915143`, -0.07930907190144548}, {
    0.2889999999999893, -12.358681405488424`, -0.27996021170697666`}}], 
   Line3DBox[{{-0.35000000000000203`, 
    0.2990996570817299, -0.0302299443641777}, {-0.35000000000000775`, \
-1.4451196575121141`, -0.09195209213775278}}], 
   Line3DBox[{{0.17499999999999782`, 
    0.2990996570817299, -0.33333883568873146`}, {
    0.17499999999999186`, -1.445123668379971, -0.3950609834357702}}], 
   Line3DBox[{{0.17499999999999824`, 0.2990996570817299, 
    0.2728789469603756}, {0.17499999999999277`, -1.4451156466442572`, 
    0.21115679916026336`}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.6657395614066055, 0.6, 0.18608195169828542`}, {
         0.6657395614066055, 0.4, 0.18608195169828542`}, {0.5663118960624612, 
         0.4, 0.38121973224055344`}, {0.5663118960624612, 0.6, 
         0.38121973224055344`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.5663118960624612, 0.6, 0.38121973224055344`}, {
         0.5663118960624612, 0.4, 0.38121973224055344`}, {
         0.41144967660472925`, 0.4, 0.5360819516982854}, {
         0.41144967660472925`, 0.6, 0.5360819516982854}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.41144967660472925`, 0.6, 0.5360819516982854}, {
         0.41144967660472925`, 0.4, 0.5360819516982854}, {0.2163118960624612, 
         0.4, 0.6355096170424297}, {0.2163118960624612, 0.6, 
         0.6355096170424297}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.2163118960624612, 0.6, 0.6355096170424297}, {
         0.2163118960624612, 0.4, 
         0.6355096170424297}, {-2.025998565077379*^-15, 0.4, 
         0.6697700556358223}, {-2.025998565077379*^-15, 0.6, 
         0.6697700556358223}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.025998565077379*^-15, 0.6, 
         0.6697700556358223}, {-2.025998565077379*^-15, 0.4, 
         0.6697700556358223}, {-0.21631189606246526`, 0.4, 
         0.6355096170424297}, {-0.21631189606246526`, 0.6, 
         0.6355096170424297}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.21631189606246526`, 0.6, 
         0.6355096170424297}, {-0.21631189606246526`, 0.4, 
         0.6355096170424297}, {-0.41144967660473325`, 0.4, 
         0.5360819516982854}, {-0.41144967660473325`, 0.6, 
         0.5360819516982854}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.41144967660473325`, 0.6, 
         0.5360819516982854}, {-0.41144967660473325`, 0.4, 
         0.5360819516982854}, {-0.5663118960624652, 0.4, 
         0.38121973224055344`}, {-0.5663118960624652, 0.6, 
         0.38121973224055344`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.5663118960624652, 0.6, 
         0.38121973224055344`}, {-0.5663118960624652, 0.4, 
         0.38121973224055344`}, {-0.6657395614066095, 0.4, 
         0.18608195169828542`}, {-0.6657395614066095, 0.6, 
         0.18608195169828542`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.6657395614066095, 0.6, 
         0.18608195169828542`}, {-0.6657395614066095, 0.4, 
         0.18608195169828542`}, {-0.7000000000000021, 
         0.4, -0.030229944364177808`}, {-0.7000000000000021, 
         0.6, -0.030229944364177808`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.7000000000000021, 
         0.6, -0.030229944364177808`}, {-0.7000000000000021, 
         0.4, -0.030229944364177808`}, {-0.6657395614066095, 
         0.4, -0.24654184042664104`}, {-0.6657395614066095, 
         0.6, -0.24654184042664104`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.6657395614066095, 
         0.6, -0.24654184042664104`}, {-0.6657395614066095, 
         0.4, -0.24654184042664104`}, {-0.5663118960624652, 
         0.4, -0.44167962096890906`}, {-0.5663118960624652, 
         0.6, -0.44167962096890906`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.5663118960624652, 
         0.6, -0.44167962096890906`}, {-0.5663118960624652, 
         0.4, -0.44167962096890906`}, {-0.41144967660473325`, 
         0.4, -0.596541840426641}, {-0.41144967660473325`, 
         0.6, -0.596541840426641}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.41144967660473325`, 
         0.6, -0.596541840426641}, {-0.41144967660473325`, 
         0.4, -0.596541840426641}, {-0.21631189606246526`, 
         0.4, -0.6959695057707853}, {-0.21631189606246526`, 
         0.6, -0.6959695057707853}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.21631189606246526`, 
         0.6, -0.6959695057707853}, {-0.21631189606246526`, 
         0.4, -0.6959695057707853}, {-2.025998565077379*^-15, 
         0.4, -0.7302299443641779}, {-2.025998565077379*^-15, 
         0.6, -0.7302299443641779}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.025998565077379*^-15, 
         0.6, -0.7302299443641779}, {-2.025998565077379*^-15, 
         0.4, -0.7302299443641779}, {0.2163118960624612, 
         0.4, -0.6959695057707853}, {0.2163118960624612, 
         0.6, -0.6959695057707853}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2163118960624612, 0.6, -0.6959695057707853}, {
         0.2163118960624612, 0.4, -0.6959695057707853}, {0.41144967660472925`,
          0.4, -0.596541840426641}, {0.41144967660472925`, 
         0.6, -0.596541840426641}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.41144967660472925`, 0.6, -0.596541840426641}, {
         0.41144967660472925`, 0.4, -0.596541840426641}, {0.5663118960624612, 
         0.4, -0.44167962096890906`}, {0.5663118960624612, 
         0.6, -0.44167962096890906`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.5663118960624612, 0.6, -0.44167962096890906`}, {
         0.5663118960624612, 0.4, -0.44167962096890906`}, {0.6657395614066055,
          0.4, -0.24654184042664104`}, {0.6657395614066055, 
         0.6, -0.24654184042664104`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.6657395614066055, 0.6, -0.24654184042664104`}, {
         0.6657395614066055, 0.4, -0.24654184042664104`}, {0.6999999999999981,
          0.4, -0.030229944364177808`}, {0.6999999999999981, 
         0.6, -0.030229944364177808`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.6999999999999981, 0.6, -0.030229944364177808`}, {
         0.6999999999999981, 0.4, -0.030229944364177808`}, {
         0.6657395614066055, 0.4, 0.18608195169828542`}, {0.6657395614066055, 
         0.6, 0.18608195169828542`}}]}}, {{{1., 0., 0.}, {0., 1., 0.}, {0., 
       0., 1.}}, {0., 0., 0.}}], {{{1., 0., 3.07009404309885*^-16}, {0., 1., 
      0.}, {-3.07009404309885*^-16, 0., 1.}}, {9.280877211567076*^-18, 0., 
      0.}}], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {0., 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26629582456264284`, -1.5175564572011375`, 
         0.08273362854682584}, {0.3518909110292066, -1.7175564572011377`, 
         0.1105451580405711}, {0.2993362879187304, -1.7175564572011377`, 
         0.2136894134700556}, {0.22652475842498515`, -1.5175564572011375`, 
         0.16078874076373303`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.22652475842498515`, -1.5175564572011375`, 
         0.16078874076373303`}, {0.2993362879187304, -1.7175564572011377`, 
         0.2136894134700556}, {0.2174805433482149, -1.7175564572011377`, 
         0.29554515804057113`}, {0.16457987064189233`, -1.5175564572011375`, 
         0.22273362854682585`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457987064189233`, -1.5175564572011375`, 
         0.22273362854682585`}, {0.2174805433482149, -1.7175564572011377`, 
         0.29554515804057113`}, {0.11433628791873039`, -1.7175564572011377`, 
         0.34809978115104734`}, {0.08652475842498512, -1.5175564572011375`, 
         0.26250469468448356`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652475842498512, -1.5175564572011375`, 
         0.26250469468448356`}, {0.11433628791873039`, -1.7175564572011377`, 
         0.34809978115104734`}, {-1.722394484482313*^-16, \
-1.7175564572011377`, 
         0.36620887012184056`}, {-1.722394484482313*^-16, \
-1.5175564572011375`, 0.2762088701218406}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.722394484482313*^-16, -1.5175564572011375`, 
         0.2762088701218406}, {-1.722394484482313*^-16, -1.7175564572011377`, 
         0.36620887012184056`}, {-0.11433628791873073`, -1.7175564572011377`, 
         0.34809978115104734`}, {-0.08652475842498546, -1.5175564572011375`, 
         0.26250469468448356`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652475842498546, -1.5175564572011375`, 
         0.26250469468448356`}, {-0.11433628791873073`, -1.7175564572011377`, 
         0.34809978115104734`}, {-0.21748054334821523`, -1.7175564572011377`, 
         0.29554515804057113`}, {-0.16457987064189267`, -1.5175564572011375`, 
         0.22273362854682585`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064189267`, -1.5175564572011375`, 
         0.22273362854682585`}, {-0.21748054334821523`, -1.7175564572011377`, 
         0.29554515804057113`}, {-0.29933628791873074`, -1.7175564572011377`, 
         0.2136894134700556}, {-0.22652475842498548`, -1.5175564572011375`, 
         0.16078874076373303`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498548`, -1.5175564572011375`, 
         0.16078874076373303`}, {-0.29933628791873074`, -1.7175564572011377`, 
         0.2136894134700556}, {-0.35189091102920694`, -1.7175564572011377`, 
         0.1105451580405711}, {-0.26629582456264317`, -1.5175564572011375`, 
         0.08273362854682584}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629582456264317`, -1.5175564572011375`, 
         0.08273362854682584}, {-0.35189091102920694`, -1.7175564572011377`, 
         0.1105451580405711}, {-0.37000000000000016`, -1.7175564572011377`, \
-0.003791129878159453}, {-0.2800000000000002, -1.5175564572011375`, \
-0.003791129878159453}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2800000000000002, -1.5175564572011375`, \
-0.003791129878159453}, {-0.37000000000000016`, -1.7175564572011377`, \
-0.003791129878159453}, {-0.35189091102920694`, -1.7175564572011377`, \
-0.11812741779689001`}, {-0.26629582456264317`, -1.5175564572011375`, \
-0.09031588830314474}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629582456264317`, -1.5175564572011375`, \
-0.09031588830314474}, {-0.35189091102920694`, -1.7175564572011377`, \
-0.11812741779689001`}, {-0.29933628791873074`, -1.7175564572011377`, \
-0.22127167322637453`}, {-0.22652475842498548`, -1.5175564572011375`, \
-0.16837100052005197`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498548`, -1.5175564572011375`, \
-0.16837100052005197`}, {-0.29933628791873074`, -1.7175564572011377`, \
-0.22127167322637453`}, {-0.21748054334821523`, -1.7175564572011377`, \
-0.30312741779689}, {-0.16457987064189267`, -1.5175564572011375`, \
-0.23031588830314478`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064189267`, -1.5175564572011375`, \
-0.23031588830314478`}, {-0.21748054334821523`, -1.7175564572011377`, \
-0.30312741779689}, {-0.11433628791873073`, -1.7175564572011377`, \
-0.3556820409073662}, {-0.08652475842498546, -1.5175564572011375`, \
-0.27008695444080244`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652475842498546, -1.5175564572011375`, \
-0.27008695444080244`}, {-0.11433628791873073`, -1.7175564572011377`, \
-0.3556820409073662}, {-1.722394484482313*^-16, -1.7175564572011377`, \
-0.37379112987815943`}, {-1.722394484482313*^-16, -1.5175564572011375`, \
-0.28379112987815946`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.722394484482313*^-16, -1.5175564572011375`, \
-0.28379112987815946`}, {-1.722394484482313*^-16, -1.7175564572011377`, \
-0.37379112987815943`}, {
         0.11433628791873039`, -1.7175564572011377`, -0.3556820409073662}, {
         0.08652475842498512, -1.5175564572011375`, -0.27008695444080244`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652475842498512, -1.5175564572011375`, -0.27008695444080244`}, {
         0.11433628791873039`, -1.7175564572011377`, -0.3556820409073662}, {
         0.2174805433482149, -1.7175564572011377`, -0.30312741779689}, {
         0.16457987064189233`, -1.5175564572011375`, \
-0.23031588830314478`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457987064189233`, -1.5175564572011375`, -0.23031588830314478`}, {
         0.2174805433482149, -1.7175564572011377`, -0.30312741779689}, {
         0.2993362879187304, -1.7175564572011377`, -0.22127167322637453`}, {
         0.22652475842498515`, -1.5175564572011375`, \
-0.16837100052005197`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.22652475842498515`, -1.5175564572011375`, -0.16837100052005197`}, {
         0.2993362879187304, -1.7175564572011377`, -0.22127167322637453`}, {
         0.3518909110292066, -1.7175564572011377`, -0.11812741779689001`}, {
         0.26629582456264284`, -1.5175564572011375`, -0.09031588830314474}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.26629582456264284`, -1.5175564572011375`, -0.09031588830314474}, {
         0.3518909110292066, -1.7175564572011377`, -0.11812741779689001`}, {
         0.36999999999999983`, -1.7175564572011377`, -0.003791129878159453}, {
         0.27999999999999986`, -1.5175564572011375`, \
-0.003791129878159453}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.27999999999999986`, -1.5175564572011375`, -0.003791129878159453}, {
         0.36999999999999983`, -1.7175564572011377`, -0.003791129878159453}, {
         0.3518909110292066, -1.7175564572011377`, 0.1105451580405711}, {
         0.26629582456264284`, -1.5175564572011375`, 
         0.08273362854682584}}]}}, {{{1., 0., 0.}, {0., 0.9998925750996549, 
       0.014657361992562233`}, {0., -0.014657361992562233`, 
       0.9998925750996549}}, {
       0., -0.00011819787823230676`, -0.02370951779835293}}], {{{1., 
      0., -3.003687979541431*^-16}, {0., 1., 0.}, {3.003687979541431*^-16, 0.,
       1.}}, {-1.1387371243907927`*^-18, 0., 0.}}], {{{
     1., -1.306857623373863*^-15, 0.}, {1.306857623373863*^-15, 1., 0.}, {0., 
     0., 1.}}, {-2.1139159873309244`*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26629582456264517`, -3.6345922991367794`, 
         0.11590845257674932`}, {0.35189091102920894`, -3.8345922991367796`, 
         0.14371998207049458`}, {0.29933628791873274`, -3.8345922991367796`, 
         0.2468642374999791}, {0.2265247584249875, -3.6345922991367794`, 
         0.19396356479365653`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265247584249875, -3.6345922991367794`, 
         0.19396356479365653`}, {0.29933628791873274`, -3.8345922991367796`, 
         0.2468642374999791}, {0.21748054334821726`, -3.8345922991367796`, 
         0.3287199820704946}, {0.1645798706418947, -3.6345922991367794`, 
         0.2559084525767493}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.1645798706418947, -3.6345922991367794`, 
         0.2559084525767493}, {0.21748054334821726`, -3.8345922991367796`, 
         0.3287199820704946}, {0.11433628791873275`, -3.8345922991367796`, 
         0.3812746051809708}, {0.08652475842498748, -3.6345922991367794`, 
         0.295679518714407}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652475842498748, -3.6345922991367794`, 
         0.295679518714407}, {0.11433628791873275`, -3.8345922991367796`, 
         0.3812746051809708}, {2.1904412676360473`*^-15, -3.8345922991367796`,
          0.399383694151764}, {2.1904412676360473`*^-15, -3.6345922991367794`,
          0.30938369415176403`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{2.1904412676360473`*^-15, -3.6345922991367794`, 
         0.30938369415176403`}, {
         2.1904412676360473`*^-15, -3.8345922991367796`, 
         0.399383694151764}, {-0.11433628791872837`, -3.8345922991367796`, 
         0.3812746051809708}, {-0.0865247584249831, -3.6345922991367794`, 
         0.295679518714407}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0865247584249831, -3.6345922991367794`, 
         0.295679518714407}, {-0.11433628791872837`, -3.8345922991367796`, 
         0.3812746051809708}, {-0.21748054334821287`, -3.8345922991367796`, 
         0.3287199820704946}, {-0.1645798706418903, -3.6345922991367794`, 
         0.2559084525767493}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1645798706418903, -3.6345922991367794`, 
         0.2559084525767493}, {-0.21748054334821287`, -3.8345922991367796`, 
         0.3287199820704946}, {-0.2993362879187284, -3.8345922991367796`, 
         0.2468642374999791}, {-0.22652475842498312`, -3.6345922991367794`, 
         0.19396356479365653`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498312`, -3.6345922991367794`, 
         0.19396356479365653`}, {-0.2993362879187284, -3.8345922991367796`, 
         0.2468642374999791}, {-0.3518909110292046, -3.8345922991367796`, 
         0.14371998207049458`}, {-0.26629582456264084`, -3.6345922991367794`, 
         0.11590845257674932`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629582456264084`, -3.6345922991367794`, 
         0.11590845257674932`}, {-0.3518909110292046, -3.8345922991367796`, 
         0.14371998207049458`}, {-0.36999999999999783`, -3.8345922991367796`, 
         0.029383694151764034`}, {-0.27999999999999786`, -3.6345922991367794`,
          0.029383694151764034`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.27999999999999786`, -3.6345922991367794`, 
         0.029383694151764034`}, {-0.36999999999999783`, -3.8345922991367796`,
          0.029383694151764034`}, {-0.3518909110292046, -3.8345922991367796`, \
-0.08495259376696652}, {-0.26629582456264084`, -3.6345922991367794`, \
-0.057141064273221256`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629582456264084`, -3.6345922991367794`, \
-0.057141064273221256`}, {-0.3518909110292046, -3.8345922991367796`, \
-0.08495259376696652}, {-0.2993362879187284, -3.8345922991367796`, \
-0.18809684919645103`}, {-0.22652475842498312`, -3.6345922991367794`, \
-0.13519617649012847`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498312`, -3.6345922991367794`, \
-0.13519617649012847`}, {-0.2993362879187284, -3.8345922991367796`, \
-0.18809684919645103`}, {-0.21748054334821287`, -3.8345922991367796`, \
-0.26995259376696656`}, {-0.1645798706418903, -3.6345922991367794`, \
-0.19714106427322128`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1645798706418903, -3.6345922991367794`, \
-0.19714106427322128`}, {-0.21748054334821287`, -3.8345922991367796`, \
-0.26995259376696656`}, {-0.11433628791872837`, -3.8345922991367796`, \
-0.32250721687744277`}, {-0.0865247584249831, -3.6345922991367794`, \
-0.23691213041087897`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0865247584249831, -3.6345922991367794`, \
-0.23691213041087897`}, {-0.11433628791872837`, -3.8345922991367796`, \
-0.32250721687744277`}, {
         2.1904412676360473`*^-15, -3.8345922991367796`, -0.340616305848236}, \
{2.1904412676360473`*^-15, -3.6345922991367794`, -0.250616305848236}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         2.1904412676360473`*^-15, -3.6345922991367794`, -0.250616305848236}, \
{2.1904412676360473`*^-15, -3.8345922991367796`, -0.340616305848236}, {
         0.11433628791873275`, -3.8345922991367796`, -0.32250721687744277`}, {
         0.08652475842498748, -3.6345922991367794`, -0.23691213041087897`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652475842498748, -3.6345922991367794`, -0.23691213041087897`}, {
         0.11433628791873275`, -3.8345922991367796`, -0.32250721687744277`}, {
         0.21748054334821726`, -3.8345922991367796`, -0.26995259376696656`}, {
         0.1645798706418947, -3.6345922991367794`, -0.19714106427322128`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.1645798706418947, -3.6345922991367794`, -0.19714106427322128`}, {
         0.21748054334821726`, -3.8345922991367796`, -0.26995259376696656`}, {
         0.29933628791873274`, -3.8345922991367796`, -0.18809684919645103`}, {
         0.2265247584249875, -3.6345922991367794`, -0.13519617649012847`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265247584249875, -3.6345922991367794`, -0.13519617649012847`}, {
         0.29933628791873274`, -3.8345922991367796`, -0.18809684919645103`}, {
         0.35189091102920894`, -3.8345922991367796`, -0.08495259376696652}, {
         0.26629582456264517`, -3.6345922991367794`, \
-0.057141064273221256`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.26629582456264517`, -3.6345922991367794`, -0.057141064273221256`}, \
{0.35189091102920894`, -3.8345922991367796`, -0.08495259376696652}, {
         0.37000000000000216`, -3.8345922991367796`, 0.029383694151764034`}, {
         0.2800000000000022, -3.6345922991367794`, 0.029383694151764034`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.2800000000000022, -3.6345922991367794`, 
         0.029383694151764034`}, {0.37000000000000216`, -3.8345922991367796`, 
         0.029383694151764034`}, {0.35189091102920894`, -3.8345922991367796`, 
         0.14371998207049458`}, {0.26629582456264517`, -3.6345922991367794`, 
         0.11590845257674932`}}]}}, {{{1., 0., 0.}, {0., 0.9998434572489837, 
       0.017693529789156417`}, {0., -0.017693529789156417`, 
       0.9998434572489837}}, {
       0., -0.0011045246202208148`, -0.06607352029081322}}], {{{1., 
      0., -5.437163763304894*^-16}, {0., 1., 0.}, {5.437163763304894*^-16, 0.,
       1.}}, {1.5976395707400538`*^-17, 0., 0.}}], {{{
     1., -1.3969843674153117`*^-15, 0.}, {1.3969843674153117`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-5.2171670605636885`*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2662958245626478, -6.001947712377974, 
         0.15539090217910156`}, {0.35189091102921155`, -6.201947712377973, 
         0.18320243167284683`}, {0.29933628791873534`, -6.201947712377973, 
         0.28634668710233135`}, {0.2265247584249901, -6.001947712377974, 
         0.23344601439600876`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265247584249901, -6.001947712377974, 
         0.23344601439600876`}, {0.29933628791873534`, -6.201947712377973, 
         0.28634668710233135`}, {0.21748054334821984`, -6.201947712377973, 
         0.36820243167284683`}, {0.16457987064189727`, -6.001947712377974, 
         0.2953909021791016}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457987064189727`, -6.001947712377974, 
         0.2953909021791016}, {0.21748054334821984`, -6.201947712377973, 
         0.36820243167284683`}, {0.11433628791873533`, -6.201947712377973, 
         0.42075705478332304`}, {0.08652475842499006, -6.001947712377974, 
         0.33516196831675926`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652475842499006, -6.001947712377974, 
         0.33516196831675926`}, {0.11433628791873533`, -6.201947712377973, 
         0.42075705478332304`}, {4.780438705690461*^-15, -6.201947712377973, 
         0.43886614375411626`}, {4.780438705690461*^-15, -6.001947712377974, 
         0.3488661437541163}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{4.780438705690461*^-15, -6.001947712377974, 
         0.3488661437541163}, {4.780438705690461*^-15, -6.201947712377973, 
         0.43886614375411626`}, {-0.11433628791872578`, -6.201947712377973, 
         0.42075705478332304`}, {-0.08652475842498052, -6.001947712377974, 
         0.33516196831675926`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652475842498052, -6.001947712377974, 
         0.33516196831675926`}, {-0.11433628791872578`, -6.201947712377973, 
         0.42075705478332304`}, {-0.2174805433482103, -6.201947712377973, 
         0.36820243167284683`}, {-0.16457987064188773`, -6.001947712377974, 
         0.2953909021791016}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064188773`, -6.001947712377974, 
         0.2953909021791016}, {-0.2174805433482103, -6.201947712377973, 
         0.36820243167284683`}, {-0.2993362879187258, -6.201947712377973, 
         0.28634668710233135`}, {-0.22652475842498054`, -6.001947712377974, 
         0.23344601439600876`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498054`, -6.001947712377974, 
         0.23344601439600876`}, {-0.2993362879187258, -6.201947712377973, 
         0.28634668710233135`}, {-0.351890911029202, -6.201947712377973, 
         0.18320243167284683`}, {-0.26629582456263823`, -6.001947712377974, 
         0.15539090217910156`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629582456263823`, -6.001947712377974, 
         0.15539090217910156`}, {-0.351890911029202, -6.201947712377973, 
         0.18320243167284683`}, {-0.3699999999999952, -6.201947712377973, 
         0.06886614375411627}, {-0.27999999999999525`, -6.001947712377974, 
         0.06886614375411627}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.27999999999999525`, -6.001947712377974, 
         0.06886614375411627}, {-0.3699999999999952, -6.201947712377973, 
         0.06886614375411627}, {-0.351890911029202, -6.201947712377973, \
-0.045470144164614285`}, {-0.26629582456263823`, -6.001947712377974, \
-0.017658614670869016`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629582456263823`, -6.001947712377974, \
-0.017658614670869016`}, {-0.351890911029202, -6.201947712377973, \
-0.045470144164614285`}, {-0.2993362879187258, -6.201947712377973, \
-0.14861439959409878`}, {-0.22652475842498054`, -6.001947712377974, \
-0.09571372688777623}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842498054`, -6.001947712377974, \
-0.09571372688777623}, {-0.2993362879187258, -6.201947712377973, \
-0.14861439959409878`}, {-0.2174805433482103, -6.201947712377973, \
-0.2304701441646143}, {-0.16457987064188773`, -6.001947712377974, \
-0.15765861467086906`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064188773`, -6.001947712377974, \
-0.15765861467086906`}, {-0.2174805433482103, -6.201947712377973, \
-0.2304701441646143}, {-0.11433628791872578`, -6.201947712377973, \
-0.2830247672750905}, {-0.08652475842498052, -6.001947712377974, \
-0.19742968080852674`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652475842498052, -6.001947712377974, \
-0.19742968080852674`}, {-0.11433628791872578`, -6.201947712377973, \
-0.2830247672750905}, {
         4.780438705690461*^-15, -6.201947712377973, -0.30113385624588374`}, {
         4.780438705690461*^-15, -6.001947712377974, \
-0.21113385624588377`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         4.780438705690461*^-15, -6.001947712377974, -0.21113385624588377`}, {
         4.780438705690461*^-15, -6.201947712377973, -0.30113385624588374`}, {
         0.11433628791873533`, -6.201947712377973, -0.2830247672750905}, {
         0.08652475842499006, -6.001947712377974, -0.19742968080852674`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652475842499006, -6.001947712377974, -0.19742968080852674`}, {
         0.11433628791873533`, -6.201947712377973, -0.2830247672750905}, {
         0.21748054334821984`, -6.201947712377973, -0.2304701441646143}, {
         0.16457987064189727`, -6.001947712377974, -0.15765861467086906`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457987064189727`, -6.001947712377974, -0.15765861467086906`}, {
         0.21748054334821984`, -6.201947712377973, -0.2304701441646143}, {
         0.29933628791873534`, -6.201947712377973, -0.14861439959409878`}, {
         0.2265247584249901, -6.001947712377974, -0.09571372688777623}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265247584249901, -6.001947712377974, -0.09571372688777623}, {
         0.29933628791873534`, -6.201947712377973, -0.14861439959409878`}, {
         0.35189091102921155`, -6.201947712377973, -0.045470144164614285`}, {
         0.2662958245626478, -6.001947712377974, -0.017658614670869016`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2662958245626478, -6.001947712377974, -0.017658614670869016`}, {
         0.35189091102921155`, -6.201947712377973, -0.045470144164614285`}, {
         0.37000000000000477`, -6.201947712377973, 0.06886614375411627}, {
         0.2800000000000048, -6.001947712377974, 0.06886614375411627}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.2800000000000048, -6.001947712377974, 
         0.06886614375411627}, {0.37000000000000477`, -6.201947712377973, 
         0.06886614375411627}, {0.35189091102921155`, -6.201947712377973, 
         0.18320243167284683`}, {0.2662958245626478, -6.001947712377974, 
         0.15539090217910156`}}]}}, {{{1., 0., 0.}, {0., 0.999834717520262, 
       0.018180694188561504`}, {0., -0.018180694188561504`, 
       0.999834717520262}}, {
       0., -0.002260579348672742, -0.11092626294632672`}}], {{{1., 
      0., -3.7333881471317603`*^-16}, {0., 1., 0.}, {3.7333881471317603`*^-16,
       0., 1.}}, {2.5710404483028786`*^-17, 0., 0.}}], {{{
     1., -1.5167153324140427`*^-15, 0.}, {1.5167153324140427`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-9.254917652952468*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2662958245626498, -8.103303776901162, 
         0.18430846399557022`}, {0.35189091102921355`, -8.303303776901162, 
         0.21211999348931548`}, {0.29933628791873734`, -8.303303776901162, 
         0.3152642489188}, {0.2265247584249921, -8.103303776901162, 
         0.2623635762124774}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265247584249921, -8.103303776901162, 
         0.2623635762124774}, {0.29933628791873734`, -8.303303776901162, 
         0.3152642489188}, {0.21748054334822184`, -8.303303776901162, 
         0.3971199934893155}, {0.16457987064189927`, -8.103303776901162, 
         0.32430846399557023`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457987064189927`, -8.103303776901162, 
         0.32430846399557023`}, {0.21748054334822184`, -8.303303776901162, 
         0.3971199934893155}, {0.11433628791873734`, -8.303303776901162, 
         0.4496746165997917}, {0.08652475842499208, -8.103303776901162, 
         0.3640795301332279}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652475842499208, -8.103303776901162, 
         0.3640795301332279}, {0.11433628791873734`, -8.303303776901162, 
         0.4496746165997917}, {6.7810174735061865`*^-15, -8.303303776901162, 
         0.4677837055705849}, {6.7810174735061865`*^-15, -8.103303776901162, 
         0.37778370557058494`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{6.7810174735061865`*^-15, -8.103303776901162, 
         0.37778370557058494`}, {6.7810174735061865`*^-15, -8.303303776901162,
          0.4677837055705849}, {-0.11433628791872377`, -8.303303776901162, 
         0.4496746165997917}, {-0.0865247584249785, -8.103303776901162, 
         0.3640795301332279}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0865247584249785, -8.103303776901162, 
         0.3640795301332279}, {-0.11433628791872377`, -8.303303776901162, 
         0.4496746165997917}, {-0.2174805433482083, -8.303303776901162, 
         0.3971199934893155}, {-0.16457987064188573`, -8.103303776901162, 
         0.32430846399557023`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064188573`, -8.103303776901162, 
         0.32430846399557023`}, {-0.2174805433482083, -8.303303776901162, 
         0.3971199934893155}, {-0.2993362879187238, -8.303303776901162, 
         0.3152642489188}, {-0.22652475842497855`, -8.103303776901162, 
         0.2623635762124774}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842497855`, -8.103303776901162, 
         0.2623635762124774}, {-0.2993362879187238, -8.303303776901162, 
         0.3152642489188}, {-0.3518909110292, -8.303303776901162, 
         0.21211999348931548`}, {-0.26629582456263623`, -8.103303776901162, 
         0.18430846399557022`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629582456263623`, -8.103303776901162, 
         0.18430846399557022`}, {-0.3518909110292, -8.303303776901162, 
         0.21211999348931548`}, {-0.3699999999999932, -8.303303776901162, 
         0.09778370557058491}, {-0.27999999999999325`, -8.103303776901162, 
         0.09778370557058491}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.27999999999999325`, -8.103303776901162, 
         0.09778370557058491}, {-0.3699999999999932, -8.303303776901162, 
         0.09778370557058491}, {-0.3518909110292, -8.303303776901162, \
-0.016552582348145647`}, {-0.26629582456263623`, -8.103303776901162, 
         0.011258947145599621`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629582456263623`, -8.103303776901162, 
         0.011258947145599621`}, {-0.3518909110292, -8.303303776901162, \
-0.016552582348145647`}, {-0.2993362879187238, -8.303303776901162, \
-0.11969683777763016`}, {-0.22652475842497855`, -8.103303776901162, \
-0.06679616507130759}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652475842497855`, -8.103303776901162, \
-0.06679616507130759}, {-0.2993362879187238, -8.303303776901162, \
-0.11969683777763016`}, {-0.2174805433482083, -8.303303776901162, \
-0.20155258234814566`}, {-0.16457987064188573`, -8.103303776901162, \
-0.1287410528544004}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457987064188573`, -8.103303776901162, \
-0.1287410528544004}, {-0.2174805433482083, -8.303303776901162, \
-0.20155258234814566`}, {-0.11433628791872377`, -8.303303776901162, \
-0.25410720545862187`}, {-0.0865247584249785, -8.103303776901162, \
-0.1685121189920581}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0865247584249785, -8.103303776901162, \
-0.1685121189920581}, {-0.11433628791872377`, -8.303303776901162, \
-0.25410720545862187`}, {
         6.7810174735061865`*^-15, -8.303303776901162, -0.2722162944294151}, {
         6.7810174735061865`*^-15, -8.103303776901162, \
-0.18221629442941512`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         6.7810174735061865`*^-15, -8.103303776901162, \
-0.18221629442941512`}, {
         6.7810174735061865`*^-15, -8.303303776901162, -0.2722162944294151}, {
         0.11433628791873734`, -8.303303776901162, -0.25410720545862187`}, {
         0.08652475842499208, -8.103303776901162, -0.1685121189920581}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652475842499208, -8.103303776901162, -0.1685121189920581}, {
         0.11433628791873734`, -8.303303776901162, -0.25410720545862187`}, {
         0.21748054334822184`, -8.303303776901162, -0.20155258234814566`}, {
         0.16457987064189927`, -8.103303776901162, -0.1287410528544004}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457987064189927`, -8.103303776901162, -0.1287410528544004}, {
         0.21748054334822184`, -8.303303776901162, -0.20155258234814566`}, {
         0.29933628791873734`, -8.303303776901162, -0.11969683777763016`}, {
         0.2265247584249921, -8.103303776901162, -0.06679616507130759}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265247584249921, -8.103303776901162, -0.06679616507130759}, {
         0.29933628791873734`, -8.303303776901162, -0.11969683777763016`}, {
         0.35189091102921355`, -8.303303776901162, -0.016552582348145647`}, {
         0.2662958245626498, -8.103303776901162, 0.011258947145599621`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.2662958245626498, -8.103303776901162, 
         0.011258947145599621`}, {
         0.35189091102921355`, -8.303303776901162, -0.016552582348145647`}, {
         0.37000000000000677`, -8.303303776901162, 0.09778370557058491}, {
         0.2800000000000068, -8.103303776901162, 0.09778370557058491}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.2800000000000068, -8.103303776901162, 
         0.09778370557058491}, {0.37000000000000677`, -8.303303776901162, 
         0.09778370557058491}, {0.35189091102921355`, -8.303303776901162, 
         0.21211999348931548`}, {0.2662958245626498, -8.103303776901162, 
         0.18430846399557022`}}]}}, {{{1., 0., 0.}, {0., 0.999986896956014, 
       0.005119171444896211}, {0., -0.005119171444896211, 
       0.999986896956014}}, {
       0., -0.0006080598035538287, -0.04199283718432645}}], {{{1., 
      0., -2.3794973291790866`*^-17}, {0., 1., 0.}, {2.3794973291790866`*^-17,
       0., 1.}}, {2.3267606624246183`*^-18, 0., 0.}}], {{{
     1., -5.4806540019983934`*^-15, 0.}, {5.4806540019983934`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-4.495946967448189*^-14, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.19999999999999968`, -10.224475820467745`, \
-0.19625401211559138`}, {-0.19999999999999968`, -10.224475820467745`, 
        0.10374598788440861`}, {-0.19999999999999968`, -10.349475820467745`, 
        0.10374598788440861`}, {-0.19999999999999968`, -10.349475820467745`, \
-0.19625401211559138`}}], 
       Polygon3DBox[{{
        0.20000000000000034`, -10.224475820467745`, -0.19625401211559138`}, {
        0.20000000000000034`, -10.224475820467745`, 0.10374598788440861`}, {
        0.20000000000000034`, -10.349475820467745`, 0.10374598788440861`}, {
        0.20000000000000034`, -10.349475820467745`, -0.19625401211559138`}}], 
       Polygon3DBox[{{-0.19999999999999968`, -10.349475820467745`, \
-0.19625401211559138`}, {-0.19999999999999968`, -10.224475820467745`, \
-0.19625401211559138`}, {
        0.20000000000000034`, -10.224475820467745`, -0.19625401211559138`}, {
        0.20000000000000034`, -10.349475820467745`, -0.19625401211559138`}}], 
       Polygon3DBox[{{-0.19999999999999968`, -10.349475820467745`, 
        0.10374598788440861`}, {-0.19999999999999968`, -10.224475820467745`, 
        0.10374598788440861`}, {0.20000000000000034`, -10.224475820467745`, 
        0.10374598788440861`}, {0.20000000000000034`, -10.349475820467745`, 
        0.10374598788440861`}}], 
       Polygon3DBox[{{-0.19999999999999968`, -10.349475820467745`, \
-0.19625401211559138`}, {-0.19999999999999968`, -10.349475820467745`, 
        0.10374598788440861`}, {0.20000000000000034`, -10.349475820467745`, 
        0.10374598788440861`}, {
        0.20000000000000034`, -10.349475820467745`, -0.19625401211559138`}}], 
       Polygon3DBox[{{-0.19999999999999968`, -10.224475820467745`, \
-0.19625401211559138`}, {-0.19999999999999968`, -10.224475820467745`, 
        0.10374598788440861`}, {0.20000000000000034`, -10.224475820467745`, 
        0.10374598788440861`}, {
        0.20000000000000034`, -10.224475820467745`, \
-0.19625401211559138`}}]}, {{{1., 0., 0.}, {0., 
       0.9047207866229581, -0.4260050448672363}, {0., 0.4260050448672363, 
       0.9047207866229581}}, {0., -0.999839406709409, 
       4.377896550056631}}], {{{1., 0., 7.74453714864147*^-16}, {0., 1., 
      0.}, {-7.74453714864147*^-16, 0., 1.}}, {3.5821591510290984`*^-17, 0., 
      0.}}], {{{1., -3.974044167501401*^-14, 0.}, {3.974044167501401*^-14, 1.,
      0.}, {0., 0., 1.}}, {-4.0880896260557787`*^-13, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.2999999999999734, -10.183727545274749`, 
        0.24774332636976698`}, {-0.2999999999999734, -10.183727545274749`, 
        0.747743326369767}, {-0.2999999999999734, -10.40872754527475, 
        0.747743326369767}, {-0.2999999999999734, -10.40872754527475, 
        0.24774332636976698`}}], 
       Polygon3DBox[{{0.3000000000000266, -10.183727545274749`, 
        0.24774332636976698`}, {0.3000000000000266, -10.183727545274749`, 
        0.747743326369767}, {0.3000000000000266, -10.40872754527475, 
        0.747743326369767}, {0.3000000000000266, -10.40872754527475, 
        0.24774332636976698`}}], 
       Polygon3DBox[{{-0.2999999999999734, -10.40872754527475, 
        0.24774332636976698`}, {-0.2999999999999734, -10.183727545274749`, 
        0.24774332636976698`}, {0.3000000000000266, -10.183727545274749`, 
        0.24774332636976698`}, {0.3000000000000266, -10.40872754527475, 
        0.24774332636976698`}}], 
       Polygon3DBox[{{-0.2999999999999734, -10.40872754527475, 
        0.747743326369767}, {-0.2999999999999734, -10.183727545274749`, 
        0.747743326369767}, {0.3000000000000266, -10.183727545274749`, 
        0.747743326369767}, {0.3000000000000266, -10.40872754527475, 
        0.747743326369767}}]}, {{{1., 0., 0.}, {0., 0.9999864679840162, 
       0.005202292653434572}, {0., -0.005202292653434572, 
       0.9999864679840162}}, {
       0., -0.0027287351657836467`, -0.05355725344622525}}], {{{1., 
      0., -6.985828856142572*^-16}, {0., 1., 0.}, {6.985828856142572*^-16, 0.,
       1.}}, {3.4771496923062966`*^-16, 0., 0.}}], {{{
     1., -5.511297313234868*^-15, 0.}, {5.511297313234868*^-15, 1., 0.}, {0., 
     0., 1.}}, {-5.674557120672756*^-14, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.11888206453687393`, -12.340873863963226`, -0.1916207064022714}, {
         0.11888206453687393`, -12.340873863963226`, -0.29162070640227145`}, {
         0.10112712429684817`, -12.306027831723535`, -0.29162070640227145`}, {
         0.10112712429684817`, -12.306027831723535`, -0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.10112712429684817`, -12.306027831723535`, -0.1916207064022714}, {
         0.10112712429684817`, -12.306027831723535`, -0.29162070640227145`}, {
         0.07347315653653888, -12.278373863963226`, -0.29162070640227145`}, {
         0.07347315653653888, -12.278373863963226`, -0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.07347315653653888, -12.278373863963226`, -0.1916207064022714}, {
         0.07347315653653888, -12.278373863963226`, -0.29162070640227145`}, {
         0.03862712429684817, -12.2606189237232, -0.29162070640227145`}, {
         0.03862712429684817, -12.2606189237232, -0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.03862712429684817, -12.2606189237232, -0.1916207064022714}, {
         0.03862712429684817, -12.2606189237232, -0.29162070640227145`}, \
{-2.026236778797283*^-14, -12.254500988260094`, -0.29162070640227145`}, \
{-2.026236778797283*^-14, -12.254500988260094`, -0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.026236778797283*^-14, -12.254500988260094`, \
-0.1916207064022714}, {-2.026236778797283*^-14, -12.254500988260094`, \
-0.29162070640227145`}, {-0.03862712429688869, -12.2606189237232, \
-0.29162070640227145`}, {-0.03862712429688869, -12.2606189237232, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.03862712429688869, -12.2606189237232, \
-0.1916207064022714}, {-0.03862712429688869, -12.2606189237232, \
-0.29162070640227145`}, {-0.0734731565365794, -12.278373863963226`, \
-0.29162070640227145`}, {-0.0734731565365794, -12.278373863963226`, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0734731565365794, -12.278373863963226`, \
-0.1916207064022714}, {-0.0734731565365794, -12.278373863963226`, \
-0.29162070640227145`}, {-0.10112712429688869`, -12.306027831723535`, \
-0.29162070640227145`}, {-0.10112712429688869`, -12.306027831723535`, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.10112712429688869`, -12.306027831723535`, \
-0.1916207064022714}, {-0.10112712429688869`, -12.306027831723535`, \
-0.29162070640227145`}, {-0.11888206453691445`, -12.340873863963226`, \
-0.29162070640227145`}, {-0.11888206453691445`, -12.340873863963226`, \
-0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.11888206453691445`, -12.340873863963226`, \
-0.1916207064022714}, {-0.11888206453691445`, -12.340873863963226`, \
-0.29162070640227145`}, {-0.12500000000002026`, -12.379500988260094`, \
-0.29162070640227145`}, {-0.12500000000002026`, -12.379500988260094`, \
-0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.12500000000002026`, -12.379500988260094`, \
-0.1916207064022714}, {-0.12500000000002026`, -12.379500988260094`, \
-0.29162070640227145`}, {-0.11888206453691445`, -12.418128112556962`, \
-0.29162070640227145`}, {-0.11888206453691445`, -12.418128112556962`, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.11888206453691445`, -12.418128112556962`, \
-0.1916207064022714}, {-0.11888206453691445`, -12.418128112556962`, \
-0.29162070640227145`}, {-0.10112712429688869`, -12.452974144796654`, \
-0.29162070640227145`}, {-0.10112712429688869`, -12.452974144796654`, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.10112712429688869`, -12.452974144796654`, \
-0.1916207064022714}, {-0.10112712429688869`, -12.452974144796654`, \
-0.29162070640227145`}, {-0.0734731565365794, -12.480628112556962`, \
-0.29162070640227145`}, {-0.0734731565365794, -12.480628112556962`, \
-0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0734731565365794, -12.480628112556962`, \
-0.1916207064022714}, {-0.0734731565365794, -12.480628112556962`, \
-0.29162070640227145`}, {-0.03862712429688869, -12.498383052796989`, \
-0.29162070640227145`}, {-0.03862712429688869, -12.498383052796989`, \
-0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.03862712429688869, -12.498383052796989`, \
-0.1916207064022714}, {-0.03862712429688869, -12.498383052796989`, \
-0.29162070640227145`}, {-2.026236778797283*^-14, -12.504500988260094`, \
-0.29162070640227145`}, {-2.026236778797283*^-14, -12.504500988260094`, \
-0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.026236778797283*^-14, -12.504500988260094`, \
-0.1916207064022714}, {-2.026236778797283*^-14, -12.504500988260094`, \
-0.29162070640227145`}, {
         0.03862712429684817, -12.498383052796989`, -0.29162070640227145`}, {
         0.03862712429684817, -12.498383052796989`, -0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.03862712429684817, -12.498383052796989`, -0.1916207064022714}, {
         0.03862712429684817, -12.498383052796989`, -0.29162070640227145`}, {
         0.07347315653653888, -12.480628112556962`, -0.29162070640227145`}, {
         0.07347315653653888, -12.480628112556962`, -0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.07347315653653888, -12.480628112556962`, -0.1916207064022714}, {
         0.07347315653653888, -12.480628112556962`, -0.29162070640227145`}, {
         0.10112712429684817`, -12.452974144796654`, -0.29162070640227145`}, {
         0.10112712429684817`, -12.452974144796654`, -0.1916207064022714}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.10112712429684817`, -12.452974144796654`, -0.1916207064022714}, {
         0.10112712429684817`, -12.452974144796654`, -0.29162070640227145`}, {
         0.11888206453687393`, -12.418128112556962`, -0.29162070640227145`}, {
         0.11888206453687393`, -12.418128112556962`, -0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.11888206453687393`, -12.418128112556962`, -0.1916207064022714}, {
         0.11888206453687393`, -12.418128112556962`, -0.29162070640227145`}, {
         0.12499999999997974`, -12.379500988260094`, -0.29162070640227145`}, {
         0.12499999999997974`, -12.379500988260094`, -0.1916207064022714}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.12499999999997974`, -12.379500988260094`, -0.1916207064022714}, {
         0.12499999999997974`, -12.379500988260094`, -0.29162070640227145`}, {
         0.11888206453687393`, -12.340873863963226`, -0.29162070640227145`}, {
         0.11888206453687393`, -12.340873863963226`, \
-0.1916207064022714}}]}}, {{{1., 0., 0.}, {0., 
       0.9011951495441017, -0.4334135466712873}, {0., 0.4334135466712873, 
       0.9011951495441017}}, {0., -1.3278764311747135`, 
       5.341570131579389}}], {{{1., 0., -6.794893024488185*^-16}, {0., 1., 
      0.}, {6.794893024488185*^-16, 0., 1.}}, {-1.6417868525047012`*^-16, 0., 
      0.}}], {{{1., -3.986690261462227*^-14, 0.}, {3.986690261462227*^-14, 1.,
      0.}, {0., 0., 1.}}, {-4.935323603165854*^-13, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.27485533320928945`, -12.28864736835036, -0.1504345688609887}, {
         0.27485533320928945`, -12.28864736835036, -0.35043456886098867`}, {
         0.2338059113743499, -12.208083341812195`, -0.35043456886098867`}, {
         0.2338059113743499, -12.208083341812195`, -0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2338059113743499, -12.208083341812195`, -0.1504345688609887}, {
         0.2338059113743499, -12.208083341812195`, -0.35043456886098867`}, {
         0.1698699379125148, -12.14414736835036, -0.35043456886098867`}, {
         0.1698699379125148, -12.14414736835036, -0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.1698699379125148, -12.14414736835036, -0.1504345688609887}, {
         0.1698699379125148, -12.14414736835036, -0.35043456886098867`}, {
         0.08930591137434991, -12.10309794651542, -0.35043456886098867`}, {
         0.08930591137434991, -12.10309794651542, -0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.08930591137434991, -12.10309794651542, -0.1504345688609887}, {
         0.08930591137434991, -12.10309794651542, -0.35043456886098867`}, \
{-9.899297431071714*^-15, -12.08895327972472, -0.35043456886098867`}, \
{-9.899297431071714*^-15, -12.08895327972472, -0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-9.899297431071714*^-15, -12.08895327972472, \
-0.1504345688609887}, {-9.899297431071714*^-15, -12.08895327972472, \
-0.35043456886098867`}, {-0.0893059113743697, -12.10309794651542, \
-0.35043456886098867`}, {-0.0893059113743697, -12.10309794651542, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0893059113743697, -12.10309794651542, \
-0.1504345688609887}, {-0.0893059113743697, -12.10309794651542, \
-0.35043456886098867`}, {-0.16986993791253463`, -12.14414736835036, \
-0.35043456886098867`}, {-0.16986993791253463`, -12.14414736835036, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16986993791253463`, -12.14414736835036, \
-0.1504345688609887}, {-0.16986993791253463`, -12.14414736835036, \
-0.35043456886098867`}, {-0.2338059113743697, -12.208083341812195`, \
-0.35043456886098867`}, {-0.2338059113743697, -12.208083341812195`, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2338059113743697, -12.208083341812195`, \
-0.1504345688609887}, {-0.2338059113743697, -12.208083341812195`, \
-0.35043456886098867`}, {-0.2748553332093092, -12.28864736835036, \
-0.35043456886098867`}, {-0.2748553332093092, -12.28864736835036, \
-0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2748553332093092, -12.28864736835036, \
-0.1504345688609887}, {-0.2748553332093092, -12.28864736835036, \
-0.35043456886098867`}, {-0.28900000000000986`, -12.37795327972472, \
-0.35043456886098867`}, {-0.28900000000000986`, -12.37795327972472, \
-0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.28900000000000986`, -12.37795327972472, \
-0.1504345688609887}, {-0.28900000000000986`, -12.37795327972472, \
-0.35043456886098867`}, {-0.2748553332093092, -12.46725919109908, \
-0.35043456886098867`}, {-0.2748553332093092, -12.46725919109908, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2748553332093092, -12.46725919109908, \
-0.1504345688609887}, {-0.2748553332093092, -12.46725919109908, \
-0.35043456886098867`}, {-0.2338059113743697, -12.547823217637244`, \
-0.35043456886098867`}, {-0.2338059113743697, -12.547823217637244`, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2338059113743697, -12.547823217637244`, \
-0.1504345688609887}, {-0.2338059113743697, -12.547823217637244`, \
-0.35043456886098867`}, {-0.16986993791253463`, -12.611759191099079`, \
-0.35043456886098867`}, {-0.16986993791253463`, -12.611759191099079`, \
-0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16986993791253463`, -12.611759191099079`, \
-0.1504345688609887}, {-0.16986993791253463`, -12.611759191099079`, \
-0.35043456886098867`}, {-0.0893059113743697, -12.652808612934018`, \
-0.35043456886098867`}, {-0.0893059113743697, -12.652808612934018`, \
-0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0893059113743697, -12.652808612934018`, \
-0.1504345688609887}, {-0.0893059113743697, -12.652808612934018`, \
-0.35043456886098867`}, {-9.899297431071714*^-15, -12.66695327972472, \
-0.35043456886098867`}, {-9.899297431071714*^-15, -12.66695327972472, \
-0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-9.899297431071714*^-15, -12.66695327972472, \
-0.1504345688609887}, {-9.899297431071714*^-15, -12.66695327972472, \
-0.35043456886098867`}, {
         0.08930591137434991, -12.652808612934018`, -0.35043456886098867`}, {
         0.08930591137434991, -12.652808612934018`, -0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08930591137434991, -12.652808612934018`, -0.1504345688609887}, {
         0.08930591137434991, -12.652808612934018`, -0.35043456886098867`}, {
         0.1698699379125148, -12.611759191099079`, -0.35043456886098867`}, {
         0.1698699379125148, -12.611759191099079`, -0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.1698699379125148, -12.611759191099079`, -0.1504345688609887}, {
         0.1698699379125148, -12.611759191099079`, -0.35043456886098867`}, {
         0.2338059113743499, -12.547823217637244`, -0.35043456886098867`}, {
         0.2338059113743499, -12.547823217637244`, -0.1504345688609887}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2338059113743499, -12.547823217637244`, -0.1504345688609887}, {
         0.2338059113743499, -12.547823217637244`, -0.35043456886098867`}, {
         0.27485533320928945`, -12.46725919109908, -0.35043456886098867`}, {
         0.27485533320928945`, -12.46725919109908, -0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.27485533320928945`, -12.46725919109908, -0.1504345688609887}, {
         0.27485533320928945`, -12.46725919109908, -0.35043456886098867`}, {
         0.2889999999999901, -12.37795327972472, -0.35043456886098867`}, {
         0.2889999999999901, -12.37795327972472, -0.1504345688609887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2889999999999901, -12.37795327972472, -0.1504345688609887}, {
         0.2889999999999901, -12.37795327972472, -0.35043456886098867`}, {
         0.27485533320928945`, -12.28864736835036, -0.35043456886098867`}, {
         0.27485533320928945`, -12.28864736835036, -0.1504345688609887}}]}}, \
{{{1., 0., 0.}, {0., 0.897338733949425, -0.44134249348328464`}, {0., 
       0.44134249348328464`, 0.897338733949425}}, {0., -1.3812637718869265`, 
       5.437206834791209}}], {{{1., 0., 1.1651185227726646`*^-15}, {0., 1., 
      0.}, {-1.1651185227726646`*^-15, 0., 1.}}, {2.917859549225235*^-16, 0., 
      0.}}], {{{1., -3.975583929240699*^-14, 0.}, {3.975583929240699*^-14, 1.,
      0.}, {0., 0., 1.}}, {-4.92095921357658*^-13, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.33286978070329604`, -1.4432193145940104`, 
        0.01620383074731961}, {0.2831559480312239, -1.4432193145940104`, 
        0.11377272101845362`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{0.2831559480312239, -1.4432193145940104`, 
        0.11377272101845362`}, {0.20572483830235788`, -1.4432193145940104`, 
        0.19120383074731961`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{0.20572483830235788`, -1.4432193145940104`, 
        0.19120383074731961`}, {0.10815594803122389`, -1.4432193145940104`, 
        0.24091766341939175`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{0.10815594803122389`, -1.4432193145940104`, 
        0.24091766341939175`}, {-7.731126823933607*^-15, -1.4432193145940104`,
         0.25804788271608803`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{-7.731126823933607*^-15, -1.4432193145940104`, 
        0.25804788271608803`}, {-0.10815594803123935`, -1.4432193145940104`, 
        0.24091766341939175`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{-0.10815594803123935`, -1.4432193145940104`, 
        0.24091766341939175`}, {-0.20572483830237337`, -1.4432193145940104`, 
        0.19120383074731961`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{-0.20572483830237337`, -1.4432193145940104`, 
        0.19120383074731961`}, {-0.28315594803123934`, -1.4432193145940104`, 
        0.11377272101845362`}, {-7.731126823933607*^-15, \
-1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{-0.28315594803123934`, -1.4432193145940104`, 
        0.11377272101845362`}, {-0.33286978070331147`, -1.4432193145940104`, 
        0.01620383074731961}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.33286978070331147`, -1.4432193145940104`, 
        0.01620383074731961}, {-0.35000000000000775`, -1.4432193145940104`, \
-0.091952117283912}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.35000000000000775`, -1.4432193145940104`, \
-0.091952117283912}, {-0.33286978070331147`, -1.4432193145940104`, \
-0.20010806531514364`}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.33286978070331147`, -1.4432193145940104`, \
-0.20010806531514364`}, {-0.28315594803123934`, -1.4432193145940104`, \
-0.2976769555862776}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.28315594803123934`, -1.4432193145940104`, \
-0.2976769555862776}, {-0.20572483830237337`, -1.4432193145940104`, \
-0.3751080653151436}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.20572483830237337`, -1.4432193145940104`, \
-0.3751080653151436}, {-0.10815594803123935`, -1.4432193145940104`, \
-0.42482189798721576`}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-0.10815594803123935`, -1.4432193145940104`, \
-0.42482189798721576`}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.44195211728391204`}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}], 
       Polygon3DBox[{{-7.731126823933607*^-15, -1.4432193145940104`, \
-0.44195211728391204`}, {
        0.10815594803122389`, -1.4432193145940104`, -0.42482189798721576`}, \
{-7.731126823933607*^-15, -1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{
        0.10815594803122389`, -1.4432193145940104`, -0.42482189798721576`}, {
        0.20572483830235788`, -1.4432193145940104`, -0.3751080653151436}, \
{-7.731126823933607*^-15, -1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{
        0.20572483830235788`, -1.4432193145940104`, -0.3751080653151436}, {
        0.2831559480312239, -1.4432193145940104`, -0.2976769555862776}, \
{-7.731126823933607*^-15, -1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{
        0.2831559480312239, -1.4432193145940104`, -0.2976769555862776}, {
        0.33286978070329604`, -1.4432193145940104`, -0.20010806531514364`}, \
{-7.731126823933607*^-15, -1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{
        0.33286978070329604`, -1.4432193145940104`, -0.20010806531514364`}, {
        0.3499999999999923, -1.4432193145940104`, -0.091952117283912}, \
{-7.731126823933607*^-15, -1.4432193145940104`, -0.091952117283912}}], 
       Polygon3DBox[{{
        0.3499999999999923, -1.4432193145940104`, -0.091952117283912}, {
        0.33286978070329604`, -1.4432193145940104`, 
        0.01620383074731961}, {-7.731126823933607*^-15, -1.4432193145940104`, \
-0.091952117283912}}]}, {{{1., 0., 0.}, {0., 0.9999999999124514, 
       0.000013232432210584313`}, {0., -0.000013232432210584313`, 
       0.9999999999124514}}, {0., 
       1.216623806810091*^-6, -0.000019097309795657047`}}], {{{1., 0., 
      1.0795360441747033`*^-15}, {0., 1., 0.}, {-1.0795360441747033`*^-15, 0.,
       1.}}, {9.926562494616314*^-17, 0., 0.}}], {{{
     1., -2.3832878177683907`*^-16, 0.}, {2.3832878177683907`*^-16, 1., 0.}, {
     0., 0., 1.}}, {-3.439607010839959*^-16, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.6024471741852429, 0.5, 
        0.00801428340515968}, {-0.6024471741852429, 0., 
        0.00801428340515968}, {-0.6095491502812532, 0., 
        0.021952696301035964`}, {-0.6095491502812532, 0.5, 
        0.021952696301035964`}}], 
       Polygon3DBox[{{-0.6095491502812532, 0.5, 
        0.021952696301035964`}, {-0.6095491502812532, 0., 
        0.021952696301035964`}, {-0.6206107373853769, 0., 
        0.03301428340515969}, {-0.6206107373853769, 0.5, 
        0.03301428340515969}}], 
       Polygon3DBox[{{-0.6206107373853769, 0.5, 
        0.03301428340515969}, {-0.6206107373853769, 0., 
        0.03301428340515969}, {-0.6345491502812532, 0., 
        0.04011625950116999}, {-0.6345491502812532, 0.5, 
        0.04011625950116999}}], 
       Polygon3DBox[{{-0.6345491502812532, 0.5, 
        0.04011625950116999}, {-0.6345491502812532, 0., 
        0.04011625950116999}, {-0.6500000000000006, 0., 
        0.042563433686412314`}, {-0.6500000000000006, 0.5, 
        0.042563433686412314`}}], 
       Polygon3DBox[{{-0.6500000000000006, 0.5, 
        0.042563433686412314`}, {-0.6500000000000006, 0., 
        0.042563433686412314`}, {-0.6654508497187479, 0., 
        0.04011625950116999}, {-0.6654508497187479, 0.5, 
        0.04011625950116999}}], 
       Polygon3DBox[{{-0.6654508497187479, 0.5, 
        0.04011625950116999}, {-0.6654508497187479, 0., 
        0.04011625950116999}, {-0.6793892626146243, 0., 
        0.03301428340515969}, {-0.6793892626146243, 0.5, 
        0.03301428340515969}}], 
       Polygon3DBox[{{-0.6793892626146243, 0.5, 
        0.03301428340515969}, {-0.6793892626146243, 0., 
        0.03301428340515969}, {-0.6904508497187479, 0., 
        0.021952696301035964`}, {-0.6904508497187479, 0.5, 
        0.021952696301035964`}}], 
       Polygon3DBox[{{-0.6904508497187479, 0.5, 
        0.021952696301035964`}, {-0.6904508497187479, 0., 
        0.021952696301035964`}, {-0.6975528258147583, 0., 
        0.00801428340515968}, {-0.6975528258147583, 0.5, 
        0.00801428340515968}}], 
       Polygon3DBox[{{-0.6975528258147583, 0.5, 
        0.00801428340515968}, {-0.6975528258147583, 0., 
        0.00801428340515968}, {-0.7000000000000006, 
        0., -0.007436566313587692}, {-0.7000000000000006, 
        0.5, -0.007436566313587692}}], 
       Polygon3DBox[{{-0.7000000000000006, 
        0.5, -0.007436566313587692}, {-0.7000000000000006, 
        0., -0.007436566313587692}, {-0.6975528258147583, 
        0., -0.022887416032335066`}, {-0.6975528258147583, 
        0.5, -0.022887416032335066`}}], 
       Polygon3DBox[{{-0.6975528258147583, 
        0.5, -0.022887416032335066`}, {-0.6975528258147583, 
        0., -0.022887416032335066`}, {-0.6904508497187479, 
        0., -0.036825828928211346`}, {-0.6904508497187479, 
        0.5, -0.036825828928211346`}}], 
       Polygon3DBox[{{-0.6904508497187479, 
        0.5, -0.036825828928211346`}, {-0.6904508497187479, 
        0., -0.036825828928211346`}, {-0.6793892626146243, 
        0., -0.04788741603233507}, {-0.6793892626146243, 
        0.5, -0.04788741603233507}}], 
       Polygon3DBox[{{-0.6793892626146243, 
        0.5, -0.04788741603233507}, {-0.6793892626146243, 
        0., -0.04788741603233507}, {-0.6654508497187479, 
        0., -0.05498939212834537}, {-0.6654508497187479, 
        0.5, -0.05498939212834537}}], 
       Polygon3DBox[{{-0.6654508497187479, 
        0.5, -0.05498939212834537}, {-0.6654508497187479, 
        0., -0.05498939212834537}, {-0.6500000000000006, 
        0., -0.05743656631358769}, {-0.6500000000000006, 
        0.5, -0.05743656631358769}}], 
       Polygon3DBox[{{-0.6500000000000006, 
        0.5, -0.05743656631358769}, {-0.6500000000000006, 
        0., -0.05743656631358769}, {-0.6345491502812532, 
        0., -0.05498939212834537}, {-0.6345491502812532, 
        0.5, -0.05498939212834537}}], 
       Polygon3DBox[{{-0.6345491502812532, 
        0.5, -0.05498939212834537}, {-0.6345491502812532, 
        0., -0.05498939212834537}, {-0.6206107373853769, 
        0., -0.04788741603233507}, {-0.6206107373853769, 
        0.5, -0.04788741603233507}}], 
       Polygon3DBox[{{-0.6206107373853769, 
        0.5, -0.04788741603233507}, {-0.6206107373853769, 
        0., -0.04788741603233507}, {-0.6095491502812532, 
        0., -0.036825828928211346`}, {-0.6095491502812532, 
        0.5, -0.036825828928211346`}}], 
       Polygon3DBox[{{-0.6095491502812532, 
        0.5, -0.036825828928211346`}, {-0.6095491502812532, 
        0., -0.036825828928211346`}, {-0.6024471741852429, 
        0., -0.022887416032335066`}, {-0.6024471741852429, 
        0.5, -0.022887416032335066`}}], 
       Polygon3DBox[{{-0.6024471741852429, 
        0.5, -0.022887416032335066`}, {-0.6024471741852429, 
        0., -0.022887416032335066`}, {-0.6000000000000005, 
        0., -0.007436566313587692}, {-0.6000000000000005, 
        0.5, -0.007436566313587692}}], 
       Polygon3DBox[{{-0.6000000000000005, 
        0.5, -0.007436566313587692}, {-0.6000000000000005, 
        0., -0.007436566313587692}, {-0.6024471741852429, 0., 
        0.00801428340515968}, {-0.6024471741852429, 0.5, 
        0.00801428340515968}}], 
       Polygon3DBox[{{-0.5881813264408156, 0., 
        0.012649538320783891`}, {-0.5881813264408156, -0.15000000000000002`, 
        0.012649538320783891`}, {-0.5974138953656289, -0.15000000000000002`, 
        0.030769475085423065`}, {-0.5974138953656289, 0., 
        0.030769475085423065`}}], 
       Polygon3DBox[{{-0.5974138953656289, 0., 
        0.030769475085423065`}, {-0.5974138953656289, -0.15000000000000002`, 
        0.030769475085423065`}, {-0.6117939586009898, -0.15000000000000002`, 
        0.045149538320783895`}, {-0.6117939586009898, 0., 
        0.045149538320783895`}}], 
       Polygon3DBox[{{-0.6117939586009898, 0., 
        0.045149538320783895`}, {-0.6117939586009898, -0.15000000000000002`, 
        0.045149538320783895`}, {-0.629913895365629, -0.15000000000000002`, 
        0.05438210724559729}, {-0.629913895365629, 0., 0.05438210724559729}}],
        Polygon3DBox[{{-0.629913895365629, 0., 
        0.05438210724559729}, {-0.629913895365629, -0.15000000000000002`, 
        0.05438210724559729}, {-0.6500000000000006, -0.15000000000000002`, 
        0.05756343368641231}, {-0.6500000000000006, 0., 
        0.05756343368641231}}], 
       Polygon3DBox[{{-0.6500000000000006, 0., 
        0.05756343368641231}, {-0.6500000000000006, -0.15000000000000002`, 
        0.05756343368641231}, {-0.6700861046343721, -0.15000000000000002`, 
        0.05438210724559729}, {-0.6700861046343721, 0., 
        0.05438210724559729}}], 
       Polygon3DBox[{{-0.6700861046343721, 0., 
        0.05438210724559729}, {-0.6700861046343721, -0.15000000000000002`, 
        0.05438210724559729}, {-0.6882060413990113, -0.15000000000000002`, 
        0.045149538320783895`}, {-0.6882060413990113, 0., 
        0.045149538320783895`}}], 
       Polygon3DBox[{{-0.6882060413990113, 0., 
        0.045149538320783895`}, {-0.6882060413990113, -0.15000000000000002`, 
        0.045149538320783895`}, {-0.7025861046343722, -0.15000000000000002`, 
        0.030769475085423065`}, {-0.7025861046343722, 0., 
        0.030769475085423065`}}], 
       Polygon3DBox[{{-0.7025861046343722, 0., 
        0.030769475085423065`}, {-0.7025861046343722, -0.15000000000000002`, 
        0.030769475085423065`}, {-0.7118186735591856, -0.15000000000000002`, 
        0.012649538320783891`}, {-0.7118186735591856, 0., 
        0.012649538320783891`}}], 
       Polygon3DBox[{{-0.7118186735591856, 0., 
        0.012649538320783891`}, {-0.7118186735591856, -0.15000000000000002`, 
        0.012649538320783891`}, {-0.7150000000000005, -0.15000000000000002`, \
-0.007436566313587692}, {-0.7150000000000005, 0., -0.007436566313587692}}], 
       Polygon3DBox[{{-0.7150000000000005, 
        0., -0.007436566313587692}, {-0.7150000000000005, \
-0.15000000000000002`, -0.007436566313587692}, {-0.7118186735591856, \
-0.15000000000000002`, -0.027522670947959276`}, {-0.7118186735591856, 
        0., -0.027522670947959276`}}], 
       Polygon3DBox[{{-0.7118186735591856, 
        0., -0.027522670947959276`}, {-0.7118186735591856, \
-0.15000000000000002`, -0.027522670947959276`}, {-0.7025861046343722, \
-0.15000000000000002`, -0.04564260771259845}, {-0.7025861046343722, 
        0., -0.04564260771259845}}], 
       Polygon3DBox[{{-0.7025861046343722, 
        0., -0.04564260771259845}, {-0.7025861046343722, \
-0.15000000000000002`, -0.04564260771259845}, {-0.6882060413990113, \
-0.15000000000000002`, -0.060022670947959274`}, {-0.6882060413990113, 
        0., -0.060022670947959274`}}], 
       Polygon3DBox[{{-0.6882060413990113, 
        0., -0.060022670947959274`}, {-0.6882060413990113, \
-0.15000000000000002`, -0.060022670947959274`}, {-0.6700861046343721, \
-0.15000000000000002`, -0.06925523987277267}, {-0.6700861046343721, 
        0., -0.06925523987277267}}], 
       Polygon3DBox[{{-0.6700861046343721, 
        0., -0.06925523987277267}, {-0.6700861046343721, \
-0.15000000000000002`, -0.06925523987277267}, {-0.6500000000000006, \
-0.15000000000000002`, -0.07243656631358769}, {-0.6500000000000006, 
        0., -0.07243656631358769}}], 
       Polygon3DBox[{{-0.6500000000000006, 
        0., -0.07243656631358769}, {-0.6500000000000006, \
-0.15000000000000002`, -0.07243656631358769}, {-0.629913895365629, \
-0.15000000000000002`, -0.06925523987277267}, {-0.629913895365629, 
        0., -0.06925523987277267}}], 
       Polygon3DBox[{{-0.629913895365629, 
        0., -0.06925523987277267}, {-0.629913895365629, \
-0.15000000000000002`, -0.06925523987277267}, {-0.6117939586009898, \
-0.15000000000000002`, -0.060022670947959274`}, {-0.6117939586009898, 
        0., -0.060022670947959274`}}], 
       Polygon3DBox[{{-0.6117939586009898, 
        0., -0.060022670947959274`}, {-0.6117939586009898, \
-0.15000000000000002`, -0.060022670947959274`}, {-0.5974138953656289, \
-0.15000000000000002`, -0.04564260771259845}, {-0.5974138953656289, 
        0., -0.04564260771259845}}], 
       Polygon3DBox[{{-0.5974138953656289, 
        0., -0.04564260771259845}, {-0.5974138953656289, \
-0.15000000000000002`, -0.04564260771259845}, {-0.5881813264408156, \
-0.15000000000000002`, -0.027522670947959276`}, {-0.5881813264408156, 
        0., -0.027522670947959276`}}], 
       Polygon3DBox[{{-0.5881813264408156, 
        0., -0.027522670947959276`}, {-0.5881813264408156, \
-0.15000000000000002`, -0.027522670947959276`}, {-0.5850000000000006, \
-0.15000000000000002`, -0.007436566313587692}, {-0.5850000000000006, 
        0., -0.007436566313587692}}], 
       Polygon3DBox[{{-0.5850000000000006, 
        0., -0.007436566313587692}, {-0.5850000000000006, \
-0.15000000000000002`, -0.007436566313587692}, {-0.5881813264408156, \
-0.15000000000000002`, 0.012649538320783891`}, {-0.5881813264408156, 0., 
        0.012649538320783891`}}]}, {{{1., 0., 0.}, {0., 0.9981728576069607, 
       0.06042306129909427}, {0., -0.06042306129909427, 
       0.9981728576069607}}, {0., 0.0006740786165645163, 
       0.007418448874218392}}], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {
      0., 0., 0.}}], {{{1., -4.051997130154758*^-15, 0.}, {
     4.051997130154758*^-15, 1., 0.}, {0., 0., 1.}}, {4.440892098500626*^-16, 
     2.6367796834847468`*^-15, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.37255282581475696`, 0.5, -0.5549022290547256}, {
        0.37255282581475696`, 0., -0.5549022290547256}, {0.36545084971874664`,
         0., -0.5409638161588493}, {0.36545084971874664`, 
        0.5, -0.5409638161588493}}], 
       Polygon3DBox[{{0.36545084971874664`, 0.5, -0.5409638161588493}, {
        0.36545084971874664`, 0., -0.5409638161588493}, {0.35438926261462295`,
         0., -0.5299022290547256}, {0.35438926261462295`, 
        0.5, -0.5299022290547256}}], 
       Polygon3DBox[{{0.35438926261462295`, 0.5, -0.5299022290547256}, {
        0.35438926261462295`, 0., -0.5299022290547256}, {0.3404508497187467, 
        0., -0.5228002529587152}, {0.3404508497187467, 
        0.5, -0.5228002529587152}}], 
       Polygon3DBox[{{0.3404508497187467, 0.5, -0.5228002529587152}, {
        0.3404508497187467, 0., -0.5228002529587152}, {0.3249999999999993, 
        0., -0.5203530787734729}, {0.3249999999999993, 
        0.5, -0.5203530787734729}}], 
       Polygon3DBox[{{0.3249999999999993, 0.5, -0.5203530787734729}, {
        0.3249999999999993, 0., -0.5203530787734729}, {0.3095491502812519, 
        0., -0.5228002529587152}, {0.3095491502812519, 
        0.5, -0.5228002529587152}}], 
       Polygon3DBox[{{0.3095491502812519, 0.5, -0.5228002529587152}, {
        0.3095491502812519, 0., -0.5228002529587152}, {0.29561073738537563`, 
        0., -0.5299022290547256}, {0.29561073738537563`, 
        0.5, -0.5299022290547256}}], 
       Polygon3DBox[{{0.29561073738537563`, 0.5, -0.5299022290547256}, {
        0.29561073738537563`, 0., -0.5299022290547256}, {0.28454915028125194`,
         0., -0.5409638161588493}, {0.28454915028125194`, 
        0.5, -0.5409638161588493}}], 
       Polygon3DBox[{{0.28454915028125194`, 0.5, -0.5409638161588493}, {
        0.28454915028125194`, 0., -0.5409638161588493}, {0.2774471741852416, 
        0., -0.5549022290547256}, {0.2774471741852416, 
        0.5, -0.5549022290547256}}], 
       Polygon3DBox[{{0.2774471741852416, 0.5, -0.5549022290547256}, {
        0.2774471741852416, 0., -0.5549022290547256}, {0.2749999999999993, 
        0., -0.570353078773473}, {0.2749999999999993, 
        0.5, -0.570353078773473}}], 
       Polygon3DBox[{{0.2749999999999993, 0.5, -0.570353078773473}, {
        0.2749999999999993, 0., -0.570353078773473}, {0.2774471741852416, 
        0., -0.5858039284922203}, {0.2774471741852416, 
        0.5, -0.5858039284922203}}], 
       Polygon3DBox[{{0.2774471741852416, 0.5, -0.5858039284922203}, {
        0.2774471741852416, 0., -0.5858039284922203}, {0.28454915028125194`, 
        0., -0.5997423413880967}, {0.28454915028125194`, 
        0.5, -0.5997423413880967}}], 
       Polygon3DBox[{{0.28454915028125194`, 0.5, -0.5997423413880967}, {
        0.28454915028125194`, 0., -0.5997423413880967}, {0.29561073738537563`,
         0., -0.6108039284922203}, {0.29561073738537563`, 
        0.5, -0.6108039284922203}}], 
       Polygon3DBox[{{0.29561073738537563`, 0.5, -0.6108039284922203}, {
        0.29561073738537563`, 0., -0.6108039284922203}, {0.3095491502812519, 
        0., -0.6179059045882307}, {0.3095491502812519, 
        0.5, -0.6179059045882307}}], 
       Polygon3DBox[{{0.3095491502812519, 0.5, -0.6179059045882307}, {
        0.3095491502812519, 0., -0.6179059045882307}, {0.3249999999999993, 
        0., -0.620353078773473}, {0.3249999999999993, 
        0.5, -0.620353078773473}}], 
       Polygon3DBox[{{0.3249999999999993, 0.5, -0.620353078773473}, {
        0.3249999999999993, 0., -0.620353078773473}, {0.3404508497187467, 
        0., -0.6179059045882307}, {0.3404508497187467, 
        0.5, -0.6179059045882307}}], 
       Polygon3DBox[{{0.3404508497187467, 0.5, -0.6179059045882307}, {
        0.3404508497187467, 0., -0.6179059045882307}, {0.35438926261462295`, 
        0., -0.6108039284922203}, {0.35438926261462295`, 
        0.5, -0.6108039284922203}}], 
       Polygon3DBox[{{0.35438926261462295`, 0.5, -0.6108039284922203}, {
        0.35438926261462295`, 0., -0.6108039284922203}, {0.36545084971874664`,
         0., -0.5997423413880967}, {0.36545084971874664`, 
        0.5, -0.5997423413880967}}], 
       Polygon3DBox[{{0.36545084971874664`, 0.5, -0.5997423413880967}, {
        0.36545084971874664`, 0., -0.5997423413880967}, {0.37255282581475696`,
         0., -0.5858039284922203}, {0.37255282581475696`, 
        0.5, -0.5858039284922203}}], 
       Polygon3DBox[{{0.37255282581475696`, 0.5, -0.5858039284922203}, {
        0.37255282581475696`, 0., -0.5858039284922203}, {0.3749999999999993, 
        0., -0.570353078773473}, {0.3749999999999993, 
        0.5, -0.570353078773473}}], 
       Polygon3DBox[{{0.3749999999999993, 0.5, -0.570353078773473}, {
        0.3749999999999993, 0., -0.570353078773473}, {0.37255282581475696`, 
        0., -0.5549022290547256}, {0.37255282581475696`, 
        0.5, -0.5549022290547256}}], 
       Polygon3DBox[{{0.38681867355918426`, 0., -0.5502669741391014}, {
        0.38681867355918426`, -0.15000000000000002`, -0.5502669741391014}, {
        0.37758610463437087`, -0.15000000000000002`, -0.5321470373744622}, {
        0.37758610463437087`, 0., -0.5321470373744622}}], 
       Polygon3DBox[{{0.37758610463437087`, 0., -0.5321470373744622}, {
        0.37758610463437087`, -0.15000000000000002`, -0.5321470373744622}, {
        0.36320604139901, -0.15000000000000002`, -0.5177669741391013}, {
        0.36320604139901, 0., -0.5177669741391013}}], 
       Polygon3DBox[{{0.36320604139901, 0., -0.5177669741391013}, {
        0.36320604139901, -0.15000000000000002`, -0.5177669741391013}, {
        0.3450861046343709, -0.15000000000000002`, -0.5085344052142879}, {
        0.3450861046343709, 0., -0.5085344052142879}}], 
       Polygon3DBox[{{0.3450861046343709, 0., -0.5085344052142879}, {
        0.3450861046343709, -0.15000000000000002`, -0.5085344052142879}, {
        0.3249999999999993, -0.15000000000000002`, -0.505353078773473}, {
        0.3249999999999993, 0., -0.505353078773473}}], 
       Polygon3DBox[{{0.3249999999999993, 0., -0.505353078773473}, {
        0.3249999999999993, -0.15000000000000002`, -0.505353078773473}, {
        0.3049138953656277, -0.15000000000000002`, -0.5085344052142879}, {
        0.3049138953656277, 0., -0.5085344052142879}}], 
       Polygon3DBox[{{0.3049138953656277, 0., -0.5085344052142879}, {
        0.3049138953656277, -0.15000000000000002`, -0.5085344052142879}, {
        0.28679395860098855`, -0.15000000000000002`, -0.5177669741391013}, {
        0.28679395860098855`, 0., -0.5177669741391013}}], 
       Polygon3DBox[{{0.28679395860098855`, 0., -0.5177669741391013}, {
        0.28679395860098855`, -0.15000000000000002`, -0.5177669741391013}, {
        0.2724138953656277, -0.15000000000000002`, -0.5321470373744622}, {
        0.2724138953656277, 0., -0.5321470373744622}}], 
       Polygon3DBox[{{0.2724138953656277, 0., -0.5321470373744622}, {
        0.2724138953656277, -0.15000000000000002`, -0.5321470373744622}, {
        0.2631813264408143, -0.15000000000000002`, -0.5502669741391014}, {
        0.2631813264408143, 0., -0.5502669741391014}}], 
       Polygon3DBox[{{0.2631813264408143, 0., -0.5502669741391014}, {
        0.2631813264408143, -0.15000000000000002`, -0.5502669741391014}, {
        0.2599999999999993, -0.15000000000000002`, -0.570353078773473}, {
        0.2599999999999993, 0., -0.570353078773473}}], 
       Polygon3DBox[{{0.2599999999999993, 0., -0.570353078773473}, {
        0.2599999999999993, -0.15000000000000002`, -0.570353078773473}, {
        0.2631813264408143, -0.15000000000000002`, -0.5904391834078445}, {
        0.2631813264408143, 0., -0.5904391834078445}}], 
       Polygon3DBox[{{0.2631813264408143, 0., -0.5904391834078445}, {
        0.2631813264408143, -0.15000000000000002`, -0.5904391834078445}, {
        0.2724138953656277, -0.15000000000000002`, -0.6085591201724837}, {
        0.2724138953656277, 0., -0.6085591201724837}}], 
       Polygon3DBox[{{0.2724138953656277, 0., -0.6085591201724837}, {
        0.2724138953656277, -0.15000000000000002`, -0.6085591201724837}, {
        0.28679395860098855`, -0.15000000000000002`, -0.6229391834078446}, {
        0.28679395860098855`, 0., -0.6229391834078446}}], 
       Polygon3DBox[{{0.28679395860098855`, 0., -0.6229391834078446}, {
        0.28679395860098855`, -0.15000000000000002`, -0.6229391834078446}, {
        0.3049138953656277, -0.15000000000000002`, -0.632171752332658}, {
        0.3049138953656277, 0., -0.632171752332658}}], 
       Polygon3DBox[{{0.3049138953656277, 0., -0.632171752332658}, {
        0.3049138953656277, -0.15000000000000002`, -0.632171752332658}, {
        0.3249999999999993, -0.15000000000000002`, -0.6353530787734729}, {
        0.3249999999999993, 0., -0.6353530787734729}}], 
       Polygon3DBox[{{0.3249999999999993, 0., -0.6353530787734729}, {
        0.3249999999999993, -0.15000000000000002`, -0.6353530787734729}, {
        0.3450861046343709, -0.15000000000000002`, -0.632171752332658}, {
        0.3450861046343709, 0., -0.632171752332658}}], 
       Polygon3DBox[{{0.3450861046343709, 0., -0.632171752332658}, {
        0.3450861046343709, -0.15000000000000002`, -0.632171752332658}, {
        0.36320604139901, -0.15000000000000002`, -0.6229391834078446}, {
        0.36320604139901, 0., -0.6229391834078446}}], 
       Polygon3DBox[{{0.36320604139901, 0., -0.6229391834078446}, {
        0.36320604139901, -0.15000000000000002`, -0.6229391834078446}, {
        0.37758610463437087`, -0.15000000000000002`, -0.6085591201724837}, {
        0.37758610463437087`, 0., -0.6085591201724837}}], 
       Polygon3DBox[{{0.37758610463437087`, 0., -0.6085591201724837}, {
        0.37758610463437087`, -0.15000000000000002`, -0.6085591201724837}, {
        0.38681867355918426`, -0.15000000000000002`, -0.5904391834078445}, {
        0.38681867355918426`, 0., -0.5904391834078445}}], 
       Polygon3DBox[{{0.38681867355918426`, 0., -0.5904391834078445}, {
        0.38681867355918426`, -0.15000000000000002`, -0.5904391834078445}, {
        0.3899999999999993, -0.15000000000000002`, -0.570353078773473}, {
        0.3899999999999993, 0., -0.570353078773473}}], 
       Polygon3DBox[{{0.3899999999999993, 0., -0.570353078773473}, {
        0.3899999999999993, -0.15000000000000002`, -0.570353078773473}, {
        0.38681867355918426`, -0.15000000000000002`, -0.5502669741391014}, {
        0.38681867355918426`, 0., -0.5502669741391014}}]}, {{{1., 0., 0.}, {
       0., 0.9981728576069607, 0.060423061299094895`}, {
       0., -0.060423061299094895`, 0.9981728576069607}}, {0., 
       0.03468721755520089, 0.006389920250561176}}], {{{1., 0., 0.}, {0., 1., 
      0.}, {0., 0., 1.}}, {0., 0., 0.}}], {{{1., -4.3298697960381105`*^-15, 
     0.}, {4.3298697960381105`*^-15, 1., 0.}, {0., 0., 1.}}, {
     5.551115123125783*^-16, -1.4016565685892601`*^-15, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.3725528258147575, 0.5, 0.5709307958650445}, {
        0.3725528258147575, 0., 0.5709307958650445}, {0.3654508497187472, 0., 
        0.5848692087609209}, {0.3654508497187472, 0.5, 0.5848692087609209}}], 
       Polygon3DBox[{{0.3654508497187472, 0.5, 0.5848692087609209}, {
        0.3654508497187472, 0., 0.5848692087609209}, {0.3543892626146235, 0., 
        0.5959307958650445}, {0.3543892626146235, 0.5, 0.5959307958650445}}], 
       Polygon3DBox[{{0.3543892626146235, 0.5, 0.5959307958650445}, {
        0.3543892626146235, 0., 0.5959307958650445}, {0.34045084971874723`, 
        0., 0.6030327719610549}, {0.34045084971874723`, 0.5, 
        0.6030327719610549}}], 
       Polygon3DBox[{{0.34045084971874723`, 0.5, 0.6030327719610549}, {
        0.34045084971874723`, 0., 0.6030327719610549}, {0.32499999999999984`, 
        0., 0.6054799461462972}, {0.32499999999999984`, 0.5, 
        0.6054799461462972}}], 
       Polygon3DBox[{{0.32499999999999984`, 0.5, 0.6054799461462972}, {
        0.32499999999999984`, 0., 0.6054799461462972}, {0.30954915028125246`, 
        0., 0.6030327719610549}, {0.30954915028125246`, 0.5, 
        0.6030327719610549}}], 
       Polygon3DBox[{{0.30954915028125246`, 0.5, 0.6030327719610549}, {
        0.30954915028125246`, 0., 0.6030327719610549}, {0.2956107373853762, 
        0., 0.5959307958650445}, {0.2956107373853762, 0.5, 
        0.5959307958650445}}], 
       Polygon3DBox[{{0.2956107373853762, 0.5, 0.5959307958650445}, {
        0.2956107373853762, 0., 0.5959307958650445}, {0.2845491502812525, 0., 
        0.5848692087609209}, {0.2845491502812525, 0.5, 0.5848692087609209}}], 
       Polygon3DBox[{{0.2845491502812525, 0.5, 0.5848692087609209}, {
        0.2845491502812525, 0., 0.5848692087609209}, {0.2774471741852422, 0., 
        0.5709307958650445}, {0.2774471741852422, 0.5, 0.5709307958650445}}], 
       Polygon3DBox[{{0.2774471741852422, 0.5, 0.5709307958650445}, {
        0.2774471741852422, 0., 0.5709307958650445}, {0.27499999999999986`, 
        0., 0.5554799461462971}, {0.27499999999999986`, 0.5, 
        0.5554799461462971}}], 
       Polygon3DBox[{{0.27499999999999986`, 0.5, 0.5554799461462971}, {
        0.27499999999999986`, 0., 0.5554799461462971}, {0.2774471741852422, 
        0., 0.5400290964275498}, {0.2774471741852422, 0.5, 
        0.5400290964275498}}], 
       Polygon3DBox[{{0.2774471741852422, 0.5, 0.5400290964275498}, {
        0.2774471741852422, 0., 0.5400290964275498}, {0.2845491502812525, 0., 
        0.5260906835316734}, {0.2845491502812525, 0.5, 0.5260906835316734}}], 
       Polygon3DBox[{{0.2845491502812525, 0.5, 0.5260906835316734}, {
        0.2845491502812525, 0., 0.5260906835316734}, {0.2956107373853762, 0., 
        0.5150290964275498}, {0.2956107373853762, 0.5, 0.5150290964275498}}], 
       Polygon3DBox[{{0.2956107373853762, 0.5, 0.5150290964275498}, {
        0.2956107373853762, 0., 0.5150290964275498}, {0.30954915028125246`, 
        0., 0.5079271203315394}, {0.30954915028125246`, 0.5, 
        0.5079271203315394}}], 
       Polygon3DBox[{{0.30954915028125246`, 0.5, 0.5079271203315394}, {
        0.30954915028125246`, 0., 0.5079271203315394}, {0.32499999999999984`, 
        0., 0.5054799461462971}, {0.32499999999999984`, 0.5, 
        0.5054799461462971}}], 
       Polygon3DBox[{{0.32499999999999984`, 0.5, 0.5054799461462971}, {
        0.32499999999999984`, 0., 0.5054799461462971}, {0.34045084971874723`, 
        0., 0.5079271203315394}, {0.34045084971874723`, 0.5, 
        0.5079271203315394}}], 
       Polygon3DBox[{{0.34045084971874723`, 0.5, 0.5079271203315394}, {
        0.34045084971874723`, 0., 0.5079271203315394}, {0.3543892626146235, 
        0., 0.5150290964275498}, {0.3543892626146235, 0.5, 
        0.5150290964275498}}], 
       Polygon3DBox[{{0.3543892626146235, 0.5, 0.5150290964275498}, {
        0.3543892626146235, 0., 0.5150290964275498}, {0.3654508497187472, 0., 
        0.5260906835316734}, {0.3654508497187472, 0.5, 0.5260906835316734}}], 
       Polygon3DBox[{{0.3654508497187472, 0.5, 0.5260906835316734}, {
        0.3654508497187472, 0., 0.5260906835316734}, {0.3725528258147575, 0., 
        0.5400290964275498}, {0.3725528258147575, 0.5, 0.5400290964275498}}], 
       Polygon3DBox[{{0.3725528258147575, 0.5, 0.5400290964275498}, {
        0.3725528258147575, 0., 0.5400290964275498}, {0.37499999999999983`, 
        0., 0.5554799461462971}, {0.37499999999999983`, 0.5, 
        0.5554799461462971}}], 
       Polygon3DBox[{{0.37499999999999983`, 0.5, 0.5554799461462971}, {
        0.37499999999999983`, 0., 0.5554799461462971}, {0.3725528258147575, 
        0., 0.5709307958650445}, {0.3725528258147575, 0.5, 
        0.5709307958650445}}], 
       Polygon3DBox[{{0.3868186735591848, 0., 0.5755660507806687}, {
        0.3868186735591848, -0.15000000000000002`, 0.5755660507806687}, {
        0.3775861046343714, -0.15000000000000002`, 0.5936859875453079}, {
        0.3775861046343714, 0., 0.5936859875453079}}], 
       Polygon3DBox[{{0.3775861046343714, 0., 0.5936859875453079}, {
        0.3775861046343714, -0.15000000000000002`, 0.5936859875453079}, {
        0.3632060413990106, -0.15000000000000002`, 0.6080660507806688}, {
        0.3632060413990106, 0., 0.6080660507806688}}], 
       Polygon3DBox[{{0.3632060413990106, 0., 0.6080660507806688}, {
        0.3632060413990106, -0.15000000000000002`, 0.6080660507806688}, {
        0.34508610463437145`, -0.15000000000000002`, 0.6172986197054822}, {
        0.34508610463437145`, 0., 0.6172986197054822}}], 
       Polygon3DBox[{{0.34508610463437145`, 0., 0.6172986197054822}, {
        0.34508610463437145`, -0.15000000000000002`, 0.6172986197054822}, {
        0.32499999999999984`, -0.15000000000000002`, 0.6204799461462971}, {
        0.32499999999999984`, 0., 0.6204799461462971}}], 
       Polygon3DBox[{{0.32499999999999984`, 0., 0.6204799461462971}, {
        0.32499999999999984`, -0.15000000000000002`, 0.6204799461462971}, {
        0.30491389536562824`, -0.15000000000000002`, 0.6172986197054822}, {
        0.30491389536562824`, 0., 0.6172986197054822}}], 
       Polygon3DBox[{{0.30491389536562824`, 0., 0.6172986197054822}, {
        0.30491389536562824`, -0.15000000000000002`, 0.6172986197054822}, {
        0.2867939586009891, -0.15000000000000002`, 0.6080660507806688}, {
        0.2867939586009891, 0., 0.6080660507806688}}], 
       Polygon3DBox[{{0.2867939586009891, 0., 0.6080660507806688}, {
        0.2867939586009891, -0.15000000000000002`, 0.6080660507806688}, {
        0.27241389536562827`, -0.15000000000000002`, 0.5936859875453079}, {
        0.27241389536562827`, 0., 0.5936859875453079}}], 
       Polygon3DBox[{{0.27241389536562827`, 0., 0.5936859875453079}, {
        0.27241389536562827`, -0.15000000000000002`, 0.5936859875453079}, {
        0.2631813264408149, -0.15000000000000002`, 0.5755660507806687}, {
        0.2631813264408149, 0., 0.5755660507806687}}], 
       Polygon3DBox[{{0.2631813264408149, 0., 0.5755660507806687}, {
        0.2631813264408149, -0.15000000000000002`, 0.5755660507806687}, {
        0.25999999999999984`, -0.15000000000000002`, 0.5554799461462971}, {
        0.25999999999999984`, 0., 0.5554799461462971}}], 
       Polygon3DBox[{{0.25999999999999984`, 0., 0.5554799461462971}, {
        0.25999999999999984`, -0.15000000000000002`, 0.5554799461462971}, {
        0.2631813264408149, -0.15000000000000002`, 0.5353938415119256}, {
        0.2631813264408149, 0., 0.5353938415119256}}], 
       Polygon3DBox[{{0.2631813264408149, 0., 0.5353938415119256}, {
        0.2631813264408149, -0.15000000000000002`, 0.5353938415119256}, {
        0.27241389536562827`, -0.15000000000000002`, 0.5172739047472864}, {
        0.27241389536562827`, 0., 0.5172739047472864}}], 
       Polygon3DBox[{{0.27241389536562827`, 0., 0.5172739047472864}, {
        0.27241389536562827`, -0.15000000000000002`, 0.5172739047472864}, {
        0.2867939586009891, -0.15000000000000002`, 0.5028938415119255}, {
        0.2867939586009891, 0., 0.5028938415119255}}], 
       Polygon3DBox[{{0.2867939586009891, 0., 0.5028938415119255}, {
        0.2867939586009891, -0.15000000000000002`, 0.5028938415119255}, {
        0.30491389536562824`, -0.15000000000000002`, 0.4936612725871122}, {
        0.30491389536562824`, 0., 0.4936612725871122}}], 
       Polygon3DBox[{{0.30491389536562824`, 0., 0.4936612725871122}, {
        0.30491389536562824`, -0.15000000000000002`, 0.4936612725871122}, {
        0.32499999999999984`, -0.15000000000000002`, 0.49047994614629714`}, {
        0.32499999999999984`, 0., 0.49047994614629714`}}], 
       Polygon3DBox[{{0.32499999999999984`, 0., 0.49047994614629714`}, {
        0.32499999999999984`, -0.15000000000000002`, 0.49047994614629714`}, {
        0.34508610463437145`, -0.15000000000000002`, 0.4936612725871122}, {
        0.34508610463437145`, 0., 0.4936612725871122}}], 
       Polygon3DBox[{{0.34508610463437145`, 0., 0.4936612725871122}, {
        0.34508610463437145`, -0.15000000000000002`, 0.4936612725871122}, {
        0.3632060413990106, -0.15000000000000002`, 0.5028938415119255}, {
        0.3632060413990106, 0., 0.5028938415119255}}], 
       Polygon3DBox[{{0.3632060413990106, 0., 0.5028938415119255}, {
        0.3632060413990106, -0.15000000000000002`, 0.5028938415119255}, {
        0.3775861046343714, -0.15000000000000002`, 0.5172739047472864}, {
        0.3775861046343714, 0., 0.5172739047472864}}], 
       Polygon3DBox[{{0.3775861046343714, 0., 0.5172739047472864}, {
        0.3775861046343714, -0.15000000000000002`, 0.5172739047472864}, {
        0.3868186735591848, -0.15000000000000002`, 0.5353938415119256}, {
        0.3868186735591848, 0., 0.5353938415119256}}], 
       Polygon3DBox[{{0.3868186735591848, 0., 0.5353938415119256}, {
        0.3868186735591848, -0.15000000000000002`, 0.5353938415119256}, {
        0.38999999999999985`, -0.15000000000000002`, 0.5554799461462971}, {
        0.38999999999999985`, 0., 0.5554799461462971}}], 
       Polygon3DBox[{{0.38999999999999985`, 0., 0.5554799461462971}, {
        0.38999999999999985`, -0.15000000000000002`, 0.5554799461462971}, {
        0.3868186735591848, -0.15000000000000002`, 0.5755660507806687}, {
        0.3868186735591848, 0., 0.5755660507806687}}]}, {{{1., 0., 0.}, {0., 
       0.9981728576069607, 0.060423061299094895`}, {
       0., -0.060423061299094895`, 0.9981728576069607}}, {
       0., -0.033339060322071803`, 0.008446977497875707}}], {{{1., 0., 0.}, {
      0., 1., 0.}, {0., 0., 1.}}, {0., 0., 0.}}], {{{
     1., -3.6637359812630166`*^-15, 0.}, {3.6637359812630166`*^-15, 1., 0.}, {
     0., 0., 1.}}, {4.440892098500626*^-16, -1.1934897514720433`*^-15, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.8083980388508806, 0, 0.26266444521870536`}, {
         0.4279754323328191, 0, 0.13905764746872637`}, {
         0.3640576474687264, 0, 0.2645033635316129}, {
         0.6876644452187054, 0, 0.4996174644486022}}], 
       Polygon3DBox[{{0.6876644452187054, 0, 0.4996174644486022}, {
         0.3640576474687264, 0, 0.2645033635316129}, {
         0.2645033635316129, 0, 0.3640576474687264}, {
         0.4996174644486022, 0, 0.6876644452187054}}], 
       Polygon3DBox[{{0.4996174644486022, 0, 0.6876644452187054}, {
         0.2645033635316129, 0, 0.3640576474687264}, {
         0.13905764746872637`, 0, 0.4279754323328191}, {
         0.26266444521870536`, 0, 0.8083980388508806}}], 
       Polygon3DBox[{{0.26266444521870536`, 0, 0.8083980388508806}, {
         0.13905764746872637`, 0, 0.4279754323328191}, {0., 0, 0.45}, {
         0., 0, 0.8500000000000001}}], 
       Polygon3DBox[{{0., 0, 0.8500000000000001}, {
         0., 0, 0.45}, {-0.13905764746872637`, 0, 
          0.4279754323328191}, {-0.26266444521870536`, 0, 
          0.8083980388508806}}], 
       Polygon3DBox[{{-0.26266444521870536`, 0, 
          0.8083980388508806}, {-0.13905764746872637`, 0, 
          0.4279754323328191}, {-0.2645033635316129, 0, 
          0.3640576474687264}, {-0.4996174644486022, 0, 0.6876644452187054}}],
        Polygon3DBox[{{-0.4996174644486022, 0, 
          0.6876644452187054}, {-0.2645033635316129, 0, 
          0.3640576474687264}, {-0.3640576474687264, 0, 
          0.2645033635316129}, {-0.6876644452187054, 0, 0.4996174644486022}}],
        Polygon3DBox[{{-0.6876644452187054, 0, 
          0.4996174644486022}, {-0.3640576474687264, 0, 
          0.2645033635316129}, {-0.4279754323328191, 0, 
          0.13905764746872637`}, {-0.8083980388508806, 0, 
          0.26266444521870536`}}], 
       Polygon3DBox[{{-0.8083980388508806, 0, 
          0.26266444521870536`}, {-0.4279754323328191, 0, 
          0.13905764746872637`}, {-0.45, 0, 0.}, {-0.8500000000000001, 0, 
          0.}}], Polygon3DBox[{{-0.8500000000000001, 0, 0.}, {-0.45, 0, 
          0.}, {-0.4279754323328191, 
          0, -0.13905764746872637`}, {-0.8083980388508806, 
          0, -0.26266444521870536`}}], 
       Polygon3DBox[{{-0.8083980388508806, 
          0, -0.26266444521870536`}, {-0.4279754323328191, 
          0, -0.13905764746872637`}, {-0.3640576474687264, 
          0, -0.2645033635316129}, {-0.6876644452187054, 
          0, -0.4996174644486022}}], 
       Polygon3DBox[{{-0.6876644452187054, 
          0, -0.4996174644486022}, {-0.3640576474687264, 
          0, -0.2645033635316129}, {-0.2645033635316129, 
          0, -0.3640576474687264}, {-0.4996174644486022, 
          0, -0.6876644452187054}}], 
       Polygon3DBox[{{-0.4996174644486022, 
          0, -0.6876644452187054}, {-0.2645033635316129, 
          0, -0.3640576474687264}, {-0.13905764746872637`, 
          0, -0.4279754323328191}, {-0.26266444521870536`, 
          0, -0.8083980388508806}}], 
       Polygon3DBox[{{-0.26266444521870536`, 
          0, -0.8083980388508806}, {-0.13905764746872637`, 
          0, -0.4279754323328191}, {0., 0, -0.45}, {
         0., 0, -0.8500000000000001}}], 
       Polygon3DBox[{{0., 0, -0.8500000000000001}, {0., 0, -0.45}, {
         0.13905764746872637`, 0, -0.4279754323328191}, {
         0.26266444521870536`, 0, -0.8083980388508806}}], 
       Polygon3DBox[{{0.26266444521870536`, 0, -0.8083980388508806}, {
         0.13905764746872637`, 0, -0.4279754323328191}, {
         0.2645033635316129, 0, -0.3640576474687264}, {
         0.4996174644486022, 0, -0.6876644452187054}}], 
       Polygon3DBox[{{0.4996174644486022, 0, -0.6876644452187054}, {
         0.2645033635316129, 0, -0.3640576474687264}, {
         0.3640576474687264, 0, -0.2645033635316129}, {
         0.6876644452187054, 0, -0.4996174644486022}}], 
       Polygon3DBox[{{0.6876644452187054, 0, -0.4996174644486022}, {
         0.3640576474687264, 0, -0.2645033635316129}, {
         0.4279754323328191, 0, -0.13905764746872637`}, {
         0.8083980388508806, 0, -0.26266444521870536`}}], 
       Polygon3DBox[{{0.8083980388508806, 0, -0.26266444521870536`}, {
         0.4279754323328191, 0, -0.13905764746872637`}, {0.45, 0, 0.}, {
         0.8500000000000001, 0, 0.}}], 
       Polygon3DBox[{{0.8500000000000001, 0, 0.}, {0.45, 0, 0.}, {
         0.4279754323328191, 0, 0.13905764746872637`}, {
         0.8083980388508806, 0, 0.26266444521870536`}}]}, {{{1, 0, 0}, {0, 1, 
       0}, {0, 0, 1}}, {0, 0, 0}}], {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {0, 0,
       0}}], {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {0, 0, 0}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019021130325901046`, 
         0.491747968246329, -0.02404960447667886}, {0.019021130325901046`, 
         0.481747968246329, -0.02404960447667886}, {0.01618033988749692, 
         0.481747968246329, -0.018474239318328346`}, {0.01618033988749692, 
         0.491747968246329, -0.018474239318328346`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01618033988749692, 
         0.491747968246329, -0.018474239318328346`}, {0.01618033988749692, 
         0.481747968246329, -0.018474239318328346`}, {0.011755705045847437`, 
         0.481747968246329, -0.01404960447667886}, {0.011755705045847437`, 
         0.491747968246329, -0.01404960447667886}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045847437`, 
         0.491747968246329, -0.01404960447667886}, {0.011755705045847437`, 
         0.481747968246329, -0.01404960447667886}, {0.006180339887496923, 
         0.481747968246329, -0.011208814038274735`}, {0.006180339887496923, 
         0.491747968246329, -0.011208814038274735`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180339887496923, 
         0.491747968246329, -0.011208814038274735`}, {0.006180339887496923, 
         0.481747968246329, -0.011208814038274735`}, {-2.025998565077379*^-15,
          0.481747968246329, -0.010229944364177807`}, \
{-2.025998565077379*^-15, 0.491747968246329, -0.010229944364177807`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.025998565077379*^-15, 
         0.491747968246329, -0.010229944364177807`}, {-2.025998565077379*^-15,
          0.481747968246329, -0.010229944364177807`}, \
{-0.0061803398875009755`, 
         0.481747968246329, -0.011208814038274735`}, {-0.0061803398875009755`,
          0.491747968246329, -0.011208814038274735`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0061803398875009755`, 
         0.491747968246329, -0.011208814038274735`}, {-0.0061803398875009755`,
          0.481747968246329, -0.011208814038274735`}, {-0.01175570504585149, 
         0.481747968246329, -0.01404960447667886}, {-0.01175570504585149, 
         0.491747968246329, -0.01404960447667886}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01175570504585149, 
         0.491747968246329, -0.01404960447667886}, {-0.01175570504585149, 
         0.481747968246329, -0.01404960447667886}, {-0.016180339887500974`, 
         0.481747968246329, -0.018474239318328346`}, {-0.016180339887500974`, 
         0.491747968246329, -0.018474239318328346`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180339887500974`, 
         0.491747968246329, -0.018474239318328346`}, {-0.016180339887500974`, 
         0.481747968246329, -0.018474239318328346`}, {-0.0190211303259051, 
         0.481747968246329, -0.02404960447667886}, {-0.0190211303259051, 
         0.491747968246329, -0.02404960447667886}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0190211303259051, 
         0.491747968246329, -0.02404960447667886}, {-0.0190211303259051, 
         0.481747968246329, -0.02404960447667886}, {-0.020000000000002027`, 
         0.481747968246329, -0.030229944364177808`}, {-0.020000000000002027`, 
         0.491747968246329, -0.030229944364177808`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.020000000000002027`, 
         0.491747968246329, -0.030229944364177808`}, {-0.020000000000002027`, 
         0.481747968246329, -0.030229944364177808`}, {-0.0190211303259051, 
         0.481747968246329, -0.03641028425167676}, {-0.0190211303259051, 
         0.491747968246329, -0.03641028425167676}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0190211303259051, 
         0.491747968246329, -0.03641028425167676}, {-0.0190211303259051, 
         0.481747968246329, -0.03641028425167676}, {-0.016180339887500974`, 
         0.481747968246329, -0.04198564941002727}, {-0.016180339887500974`, 
         0.491747968246329, -0.04198564941002727}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180339887500974`, 
         0.491747968246329, -0.04198564941002727}, {-0.016180339887500974`, 
         0.481747968246329, -0.04198564941002727}, {-0.01175570504585149, 
         0.481747968246329, -0.04641028425167676}, {-0.01175570504585149, 
         0.491747968246329, -0.04641028425167676}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01175570504585149, 
         0.491747968246329, -0.04641028425167676}, {-0.01175570504585149, 
         0.481747968246329, -0.04641028425167676}, {-0.0061803398875009755`, 
         0.481747968246329, -0.04925107469008088}, {-0.0061803398875009755`, 
         0.491747968246329, -0.04925107469008088}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0061803398875009755`, 
         0.491747968246329, -0.04925107469008088}, {-0.0061803398875009755`, 
         0.481747968246329, -0.04925107469008088}, {-2.025998565077379*^-15, 
         0.481747968246329, -0.05022994436417781}, {-2.025998565077379*^-15, 
         0.491747968246329, -0.05022994436417781}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.025998565077379*^-15, 
         0.491747968246329, -0.05022994436417781}, {-2.025998565077379*^-15, 
         0.481747968246329, -0.05022994436417781}, {0.006180339887496923, 
         0.481747968246329, -0.04925107469008088}, {0.006180339887496923, 
         0.491747968246329, -0.04925107469008088}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.006180339887496923, 
         0.491747968246329, -0.04925107469008088}, {0.006180339887496923, 
         0.481747968246329, -0.04925107469008088}, {0.011755705045847437`, 
         0.481747968246329, -0.04641028425167676}, {0.011755705045847437`, 
         0.491747968246329, -0.04641028425167676}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045847437`, 
         0.491747968246329, -0.04641028425167676}, {0.011755705045847437`, 
         0.481747968246329, -0.04641028425167676}, {0.01618033988749692, 
         0.481747968246329, -0.04198564941002727}, {0.01618033988749692, 
         0.491747968246329, -0.04198564941002727}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01618033988749692, 
         0.491747968246329, -0.04198564941002727}, {0.01618033988749692, 
         0.481747968246329, -0.04198564941002727}, {0.019021130325901046`, 
         0.481747968246329, -0.03641028425167676}, {0.019021130325901046`, 
         0.491747968246329, -0.03641028425167676}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.019021130325901046`, 
         0.491747968246329, -0.03641028425167676}, {0.019021130325901046`, 
         0.481747968246329, -0.03641028425167676}, {0.019999999999997974`, 
         0.481747968246329, -0.030229944364177808`}, {0.019999999999997974`, 
         0.491747968246329, -0.030229944364177808`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.019999999999997974`, 
         0.491747968246329, -0.030229944364177808`}, {0.019999999999997974`, 
         0.481747968246329, -0.030229944364177808`}, {0.019021130325901046`, 
         0.481747968246329, -0.02404960447667886}, {0.019021130325901046`, 
         0.491747968246329, -0.02404960447667886}}]}}, {{{1., 0., 0.}, {0., 
       1., 0.}, {0., 0., 1.}}, {0., 0., 0.}}], {{{1., 0., 
      3.07009404309885*^-16}, {0., 1., 0.}, {-3.07009404309885*^-16, 0., 
      1.}}, {9.280877211567076*^-18, 0., 0.}}], {{{1., 0., 0.}, {0., 1., 
     0.}, {0., 0., 1.}}, {0., 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019021130325902916`, -1.6254326237419967`, 
         0.002577960919953146}, {0.019021130325902916`, -1.6354326237419965`, 
         0.002577960919953146}, {0.01618033988749879, -1.6354326237419965`, 
         0.00815332607830366}, {0.01618033988749879, -1.6254326237419967`, 
         0.00815332607830366}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01618033988749879, -1.6254326237419967`, 
         0.00815332607830366}, {0.01618033988749879, -1.6354326237419965`, 
         0.00815332607830366}, {0.011755705045849309`, -1.6354326237419965`, 
         0.012577960919953146`}, {0.011755705045849309`, -1.6254326237419967`,
          0.012577960919953146`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045849309`, -1.6254326237419967`, 
         0.012577960919953146`}, {0.011755705045849309`, -1.6354326237419965`,
          0.012577960919953146`}, {0.006180339887498793, -1.6354326237419965`,
          0.01541875135835727}, {0.006180339887498793, -1.6254326237419967`, 
         0.01541875135835727}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180339887498793, -1.6254326237419967`, 
         0.01541875135835727}, {0.006180339887498793, -1.6354326237419965`, 
         0.01541875135835727}, {-1.5546882692861215`*^-16, \
-1.6354326237419965`, 
         0.016397621032454197`}, {-1.5546882692861215`*^-16, \
-1.6254326237419967`, 0.016397621032454197`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.5546882692861215`*^-16, -1.6254326237419967`, 
         0.016397621032454197`}, {-1.5546882692861215`*^-16, \
-1.6354326237419965`, 
         0.016397621032454197`}, {-0.006180339887499105, -1.6354326237419965`,
          0.01541875135835727}, {-0.006180339887499105, -1.6254326237419967`, 
         0.01541875135835727}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180339887499105, -1.6254326237419967`, 
         0.01541875135835727}, {-0.006180339887499105, -1.6354326237419965`, 
         0.01541875135835727}, {-0.011755705045849617`, -1.6354326237419965`, 
         0.012577960919953146`}, {-0.011755705045849617`, \
-1.6254326237419967`, 0.012577960919953146`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045849617`, -1.6254326237419967`, 
         0.012577960919953146`}, {-0.011755705045849617`, \
-1.6354326237419965`, 
         0.012577960919953146`}, {-0.016180339887499104`, \
-1.6354326237419965`, 
         0.00815332607830366}, {-0.016180339887499104`, -1.6254326237419967`, 
         0.00815332607830366}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180339887499104`, -1.6254326237419967`, 
         0.00815332607830366}, {-0.016180339887499104`, -1.6354326237419965`, 
         0.00815332607830366}, {-0.01902113032590323, -1.6354326237419965`, 
         0.002577960919953146}, {-0.01902113032590323, -1.6254326237419967`, 
         0.002577960919953146}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.01902113032590323, -1.6254326237419967`, 
         0.002577960919953146}, {-0.01902113032590323, -1.6354326237419965`, 
         0.002577960919953146}, {-0.020000000000000157`, \
-1.6354326237419965`, -0.0036023789675458033`}, {-0.020000000000000157`, \
-1.6254326237419967`, -0.0036023789675458033`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.020000000000000157`, -1.6254326237419967`, \
-0.0036023789675458033`}, {-0.020000000000000157`, -1.6354326237419965`, \
-0.0036023789675458033`}, {-0.01902113032590323, -1.6354326237419965`, \
-0.009782718855044751}, {-0.01902113032590323, -1.6254326237419967`, \
-0.009782718855044751}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01902113032590323, -1.6254326237419967`, \
-0.009782718855044751}, {-0.01902113032590323, -1.6354326237419965`, \
-0.009782718855044751}, {-0.016180339887499104`, -1.6354326237419965`, \
-0.015358084013395267`}, {-0.016180339887499104`, -1.6254326237419967`, \
-0.015358084013395267`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180339887499104`, -1.6254326237419967`, \
-0.015358084013395267`}, {-0.016180339887499104`, -1.6354326237419965`, \
-0.015358084013395267`}, {-0.011755705045849617`, -1.6354326237419965`, \
-0.01978271885504475}, {-0.011755705045849617`, -1.6254326237419967`, \
-0.01978271885504475}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045849617`, -1.6254326237419967`, \
-0.01978271885504475}, {-0.011755705045849617`, -1.6354326237419965`, \
-0.01978271885504475}, {-0.006180339887499105, -1.6354326237419965`, \
-0.022623509293448876`}, {-0.006180339887499105, -1.6254326237419967`, \
-0.022623509293448876`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180339887499105, -1.6254326237419967`, \
-0.022623509293448876`}, {-0.006180339887499105, -1.6354326237419965`, \
-0.022623509293448876`}, {-1.5546882692861215`*^-16, -1.6354326237419965`, \
-0.023602378967545804`}, {-1.5546882692861215`*^-16, -1.6254326237419967`, \
-0.023602378967545804`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.5546882692861215`*^-16, -1.6254326237419967`, \
-0.023602378967545804`}, {-1.5546882692861215`*^-16, -1.6354326237419965`, \
-0.023602378967545804`}, {
         0.006180339887498793, -1.6354326237419965`, -0.022623509293448876`}, \
{0.006180339887498793, -1.6254326237419967`, -0.022623509293448876`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.006180339887498793, -1.6254326237419967`, -0.022623509293448876`}, \
{0.006180339887498793, -1.6354326237419965`, -0.022623509293448876`}, {
         0.011755705045849309`, -1.6354326237419965`, -0.01978271885504475}, {
         0.011755705045849309`, -1.6254326237419967`, \
-0.01978271885504475}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.011755705045849309`, -1.6254326237419967`, -0.01978271885504475}, {
         0.011755705045849309`, -1.6354326237419965`, -0.01978271885504475}, {
         0.01618033988749879, -1.6354326237419965`, -0.015358084013395267`}, {
         0.01618033988749879, -1.6254326237419967`, \
-0.015358084013395267`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.01618033988749879, -1.6254326237419967`, -0.015358084013395267`}, {
         0.01618033988749879, -1.6354326237419965`, -0.015358084013395267`}, {
         0.019021130325902916`, -1.6354326237419965`, -0.009782718855044751}, \
{0.019021130325902916`, -1.6254326237419967`, -0.009782718855044751}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019021130325902916`, -1.6254326237419967`, -0.009782718855044751}, 
         {
         0.019021130325902916`, -1.6354326237419965`, -0.009782718855044751}, \
{0.019999999999999844`, -1.6354326237419965`, -0.0036023789675458033`}, {
         0.019999999999999844`, -1.6254326237419967`, \
-0.0036023789675458033`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019999999999999844`, -1.6254326237419967`, \
-0.0036023789675458033`}, {
         0.019999999999999844`, -1.6354326237419965`, \
-0.0036023789675458033`}, {0.019021130325902916`, -1.6354326237419965`, 
         0.002577960919953146}, {0.019021130325902916`, -1.6254326237419967`, 
         0.002577960919953146}}]}}, {{{1., 0., 0.}, {0., 0.9998925750996549, 
       0.014657361992562233`}, {0., -0.014657361992562233`, 
       0.9998925750996549}}, {
       0., -0.00012234768956309594`, -0.023898228155871056`}}], {{{1., 
      0., -3.003687979541431*^-16}, {0., 1., 0.}, {3.003687979541431*^-16, 0.,
       1.}}, {-1.0820422402570076`*^-18, 0., 0.}}], {{{
     1., -1.306857623373863*^-15, 0.}, {1.306857623373863*^-15, 1., 0.}, {0., 
     0., 1.}}, {-2.1307433037346775`*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01902113032590528, -3.7420359594929944`, 
         0.035784240786231776`}, {0.01902113032590528, -3.752035959492994, 
         0.035784240786231776`}, {0.016180339887501154`, -3.752035959492994, 
         0.04135960594458229}, {0.016180339887501154`, -3.7420359594929944`, 
         0.04135960594458229}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887501154`, -3.7420359594929944`, 
         0.04135960594458229}, {0.016180339887501154`, -3.752035959492994, 
         0.04135960594458229}, {0.011755705045851671`, -3.752035959492994, 
         0.04578424078623178}, {0.011755705045851671`, -3.7420359594929944`, 
         0.04578424078623178}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045851671`, -3.7420359594929944`, 
         0.04578424078623178}, {0.011755705045851671`, -3.752035959492994, 
         0.04578424078623178}, {0.006180339887501157, -3.752035959492994, 
         0.0486250312246359}, {0.006180339887501157, -3.7420359594929944`, 
         0.0486250312246359}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180339887501157, -3.7420359594929944`, 
         0.0486250312246359}, {0.006180339887501157, -3.752035959492994, 
         0.0486250312246359}, {2.2077051366125995`*^-15, -3.752035959492994, 
         0.04960390089873283}, {
         2.2077051366125995`*^-15, -3.7420359594929944`, 
         0.04960390089873283}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{2.2077051366125995`*^-15, -3.7420359594929944`, 
         0.04960390089873283}, {2.2077051366125995`*^-15, -3.752035959492994, 
         0.04960390089873283}, {-0.006180339887496742, -3.752035959492994, 
         0.0486250312246359}, {-0.006180339887496742, -3.7420359594929944`, 
         0.0486250312246359}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180339887496742, -3.7420359594929944`, 
         0.0486250312246359}, {-0.006180339887496742, -3.752035959492994, 
         0.0486250312246359}, {-0.011755705045847255`, -3.752035959492994, 
         0.04578424078623178}, {-0.011755705045847255`, -3.7420359594929944`, 
         0.04578424078623178}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045847255`, -3.7420359594929944`, 
         0.04578424078623178}, {-0.011755705045847255`, -3.752035959492994, 
         0.04578424078623178}, {-0.01618033988749674, -3.752035959492994, 
         0.04135960594458229}, {-0.01618033988749674, -3.7420359594929944`, 
         0.04135960594458229}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749674, -3.7420359594929944`, 
         0.04135960594458229}, {-0.01618033988749674, -3.752035959492994, 
         0.04135960594458229}, {-0.019021130325900866`, -3.752035959492994, 
         0.035784240786231776`}, {-0.019021130325900866`, \
-3.7420359594929944`, 0.035784240786231776`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019021130325900866`, -3.7420359594929944`, 
         0.035784240786231776`}, {-0.019021130325900866`, -3.752035959492994, 
         0.035784240786231776`}, {-0.019999999999997794`, -3.752035959492994, 
         0.029603900898732827`}, {-0.019999999999997794`, \
-3.7420359594929944`, 0.029603900898732827`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019999999999997794`, -3.7420359594929944`, 
         0.029603900898732827`}, {-0.019999999999997794`, -3.752035959492994, 
         0.029603900898732827`}, {-0.019021130325900866`, -3.752035959492994, 
         0.023423561011233877`}, {-0.019021130325900866`, \
-3.7420359594929944`, 0.023423561011233877`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.019021130325900866`, -3.7420359594929944`, 
         0.023423561011233877`}, {-0.019021130325900866`, -3.752035959492994, 
         0.023423561011233877`}, {-0.01618033988749674, -3.752035959492994, 
         0.017848195852883365`}, {-0.01618033988749674, -3.7420359594929944`, 
         0.017848195852883365`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749674, -3.7420359594929944`, 
         0.017848195852883365`}, {-0.01618033988749674, -3.752035959492994, 
         0.017848195852883365`}, {-0.011755705045847255`, -3.752035959492994, 
         0.013423561011233879`}, {-0.011755705045847255`, \
-3.7420359594929944`, 0.013423561011233879`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045847255`, -3.7420359594929944`, 
         0.013423561011233879`}, {-0.011755705045847255`, -3.752035959492994, 
         0.013423561011233879`}, {-0.006180339887496742, -3.752035959492994, 
         0.010582770572829754`}, {-0.006180339887496742, -3.7420359594929944`,
          0.010582770572829754`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180339887496742, -3.7420359594929944`, 
         0.010582770572829754`}, {-0.006180339887496742, -3.752035959492994, 
         0.010582770572829754`}, {
         2.2077051366125995`*^-15, -3.752035959492994, 
         0.009603900898732826}, {
         2.2077051366125995`*^-15, -3.7420359594929944`, 
         0.009603900898732826}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{2.2077051366125995`*^-15, -3.7420359594929944`, 
         0.009603900898732826}, {2.2077051366125995`*^-15, -3.752035959492994,
          0.009603900898732826}, {0.006180339887501157, -3.752035959492994, 
         0.010582770572829754`}, {0.006180339887501157, -3.7420359594929944`, 
         0.010582770572829754`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.006180339887501157, -3.7420359594929944`, 
         0.010582770572829754`}, {0.006180339887501157, -3.752035959492994, 
         0.010582770572829754`}, {0.011755705045851671`, -3.752035959492994, 
         0.013423561011233879`}, {0.011755705045851671`, -3.7420359594929944`,
          0.013423561011233879`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045851671`, -3.7420359594929944`, 
         0.013423561011233879`}, {0.011755705045851671`, -3.752035959492994, 
         0.013423561011233879`}, {0.016180339887501154`, -3.752035959492994, 
         0.017848195852883365`}, {0.016180339887501154`, -3.7420359594929944`,
          0.017848195852883365`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887501154`, -3.7420359594929944`, 
         0.017848195852883365`}, {0.016180339887501154`, -3.752035959492994, 
         0.017848195852883365`}, {0.01902113032590528, -3.752035959492994, 
         0.023423561011233877`}, {0.01902113032590528, -3.7420359594929944`, 
         0.023423561011233877`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.01902113032590528, -3.7420359594929944`, 
         0.023423561011233877`}, {0.01902113032590528, -3.752035959492994, 
         0.023423561011233877`}, {0.020000000000002207`, -3.752035959492994, 
         0.029603900898732827`}, {0.020000000000002207`, -3.7420359594929944`,
          0.029603900898732827`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.020000000000002207`, -3.7420359594929944`, 
         0.029603900898732827`}, {0.020000000000002207`, -3.752035959492994, 
         0.029603900898732827`}, {0.01902113032590528, -3.752035959492994, 
         0.035784240786231776`}, {0.01902113032590528, -3.7420359594929944`, 
         0.035784240786231776`}}]}}, {{{1., 0., 0.}, {0., 0.9998434572489837, 
       0.017693529789156417`}, {0., -0.017693529789156417`, 
       0.9998434572489837}}, {
       0., -0.0011103688196829609`, -0.06629365809424209}}], {{{1., 
      0., -5.437163763304894*^-16}, {0., 1., 0.}, {5.437163763304894*^-16, 0.,
       1.}}, {1.6096125721905855`*^-17, 0., 0.}}], {{{
     1., -1.3969843674153117`*^-15, 0.}, {1.3969843674153117`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-5.234550659554747*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01902113032590787, -6.1082043650876185`, 
         0.07525117123338887}, {0.01902113032590787, -6.118204365087618, 
         0.07525117123338887}, {0.016180339887503746`, -6.118204365087618, 
         0.08082653639173938}, {0.016180339887503746`, -6.1082043650876185`, 
         0.08082653639173938}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887503746`, -6.1082043650876185`, 
         0.08082653639173938}, {0.016180339887503746`, -6.118204365087618, 
         0.08082653639173938}, {0.011755705045854261`, -6.118204365087618, 
         0.08525117123338886}, {0.011755705045854261`, -6.1082043650876185`, 
         0.08525117123338886}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045854261`, -6.1082043650876185`, 
         0.08525117123338886}, {0.011755705045854261`, -6.118204365087618, 
         0.08525117123338886}, {0.006180339887503747, -6.118204365087618, 
         0.08809196167179298}, {0.006180339887503747, -6.1082043650876185`, 
         0.08809196167179298}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180339887503747, -6.1082043650876185`, 
         0.08809196167179298}, {0.006180339887503747, -6.118204365087618, 
         0.08809196167179298}, {4.79743542562394*^-15, -6.118204365087618, 
         0.08907083134588992}, {4.79743542562394*^-15, -6.1082043650876185`, 
         0.08907083134588992}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{4.79743542562394*^-15, -6.1082043650876185`, 
         0.08907083134588992}, {4.79743542562394*^-15, -6.118204365087618, 
         0.08907083134588992}, {-0.006180339887494152, -6.118204365087618, 
         0.08809196167179298}, {-0.006180339887494152, -6.1082043650876185`, 
         0.08809196167179298}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180339887494152, -6.1082043650876185`, 
         0.08809196167179298}, {-0.006180339887494152, -6.118204365087618, 
         0.08809196167179298}, {-0.011755705045844665`, -6.118204365087618, 
         0.08525117123338886}, {-0.011755705045844665`, -6.1082043650876185`, 
         0.08525117123338886}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045844665`, -6.1082043650876185`, 
         0.08525117123338886}, {-0.011755705045844665`, -6.118204365087618, 
         0.08525117123338886}, {-0.01618033988749415, -6.118204365087618, 
         0.08082653639173938}, {-0.01618033988749415, -6.1082043650876185`, 
         0.08082653639173938}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749415, -6.1082043650876185`, 
         0.08082653639173938}, {-0.01618033988749415, -6.118204365087618, 
         0.08082653639173938}, {-0.019021130325898274`, -6.118204365087618, 
         0.07525117123338887}, {-0.019021130325898274`, -6.1082043650876185`, 
         0.07525117123338887}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019021130325898274`, -6.1082043650876185`, 
         0.07525117123338887}, {-0.019021130325898274`, -6.118204365087618, 
         0.07525117123338887}, {-0.019999999999995202`, -6.118204365087618, 
         0.06907083134588991}, {-0.019999999999995202`, -6.1082043650876185`, 
         0.06907083134588991}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019999999999995202`, -6.1082043650876185`, 
         0.06907083134588991}, {-0.019999999999995202`, -6.118204365087618, 
         0.06907083134588991}, {-0.019021130325898274`, -6.118204365087618, 
         0.06289049145839096}, {-0.019021130325898274`, -6.1082043650876185`, 
         0.06289049145839096}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.019021130325898274`, -6.1082043650876185`, 
         0.06289049145839096}, {-0.019021130325898274`, -6.118204365087618, 
         0.06289049145839096}, {-0.01618033988749415, -6.118204365087618, 
         0.057315126300040445`}, {-0.01618033988749415, -6.1082043650876185`, 
         0.057315126300040445`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749415, -6.1082043650876185`, 
         0.057315126300040445`}, {-0.01618033988749415, -6.118204365087618, 
         0.057315126300040445`}, {-0.011755705045844665`, -6.118204365087618, 
         0.052890491458390955`}, {-0.011755705045844665`, \
-6.1082043650876185`, 0.052890491458390955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045844665`, -6.1082043650876185`, 
         0.052890491458390955`}, {-0.011755705045844665`, -6.118204365087618, 
         0.052890491458390955`}, {-0.006180339887494152, -6.118204365087618, 
         0.050049701019986834`}, {-0.006180339887494152, -6.1082043650876185`,
          0.050049701019986834`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180339887494152, -6.1082043650876185`, 
         0.050049701019986834`}, {-0.006180339887494152, -6.118204365087618, 
         0.050049701019986834`}, {4.79743542562394*^-15, -6.118204365087618, 
         0.0490708313458899}, {4.79743542562394*^-15, -6.1082043650876185`, 
         0.0490708313458899}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{4.79743542562394*^-15, -6.1082043650876185`, 
         0.0490708313458899}, {4.79743542562394*^-15, -6.118204365087618, 
         0.0490708313458899}, {0.006180339887503747, -6.118204365087618, 
         0.050049701019986834`}, {0.006180339887503747, -6.1082043650876185`, 
         0.050049701019986834`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.006180339887503747, -6.1082043650876185`, 
         0.050049701019986834`}, {0.006180339887503747, -6.118204365087618, 
         0.050049701019986834`}, {0.011755705045854261`, -6.118204365087618, 
         0.052890491458390955`}, {0.011755705045854261`, -6.1082043650876185`,
          0.052890491458390955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045854261`, -6.1082043650876185`, 
         0.052890491458390955`}, {0.011755705045854261`, -6.118204365087618, 
         0.052890491458390955`}, {0.016180339887503746`, -6.118204365087618, 
         0.057315126300040445`}, {0.016180339887503746`, -6.1082043650876185`,
          0.057315126300040445`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887503746`, -6.1082043650876185`, 
         0.057315126300040445`}, {0.016180339887503746`, -6.118204365087618, 
         0.057315126300040445`}, {0.01902113032590787, -6.118204365087618, 
         0.06289049145839096}, {0.01902113032590787, -6.1082043650876185`, 
         0.06289049145839096}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.01902113032590787, -6.1082043650876185`, 
         0.06289049145839096}, {0.01902113032590787, -6.118204365087618, 
         0.06289049145839096}, {0.0200000000000048, -6.118204365087618, 
         0.06907083134588991}, {0.0200000000000048, -6.1082043650876185`, 
         0.06907083134588991}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.0200000000000048, -6.1082043650876185`, 
         0.06907083134588991}, {0.0200000000000048, -6.118204365087618, 
         0.06907083134588991}, {0.01902113032590787, -6.118204365087618, 
         0.07525117123338887}, {0.01902113032590787, -6.1082043650876185`, 
         0.07525117123338887}}]}}, {{{1., 0., 0.}, {0., 0.999834717520262, 
       0.018180694188561504`}, {0., -0.018180694188561504`, 
       0.999834717520262}}, {
       0., -0.0022661612386558616`, -0.11113088287555485`}}], {{{1., 
      0., -3.7333881471317603`*^-16}, {0., 1., 0.}, {3.7333881471317603`*^-16,
       0., 1.}}, {2.5786822305928533`*^-17, 0., 0.}}], {{{
     1., -1.5167153324140427`*^-15, 0.}, {1.5167153324140427`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-9.271990790708843*^-15, 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01902113032590991, -8.209332833133852, 
         0.1040205058276171}, {0.01902113032590991, -8.219332833133853, 
         0.1040205058276171}, {0.016180339887505786`, -8.219332833133853, 
         0.10959587098596762`}, {0.016180339887505786`, -8.209332833133852, 
         0.10959587098596762`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887505786`, -8.209332833133852, 
         0.10959587098596762`}, {0.016180339887505786`, -8.219332833133853, 
         0.10959587098596762`}, {0.011755705045856305`, -8.219332833133853, 
         0.11402050582761711`}, {0.011755705045856305`, -8.209332833133852, 
         0.11402050582761711`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045856305`, -8.209332833133852, 
         0.11402050582761711`}, {0.011755705045856305`, -8.219332833133853, 
         0.11402050582761711`}, {0.006180339887505791, -8.219332833133853, 
         0.11686129626602124`}, {0.006180339887505791, -8.209332833133852, 
         0.11686129626602124`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180339887505791, -8.209332833133852, 
         0.11686129626602124`}, {0.006180339887505791, -8.219332833133853, 
         0.11686129626602124`}, {6.84146257121316*^-15, -8.219332833133853, 
         0.11784016594011816`}, {6.84146257121316*^-15, -8.209332833133852, 
         0.11784016594011816`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{6.84146257121316*^-15, -8.209332833133852, 
         0.11784016594011816`}, {6.84146257121316*^-15, -8.219332833133853, 
         0.11784016594011816`}, {-0.0061803398874921076`, -8.219332833133853, 
         0.11686129626602124`}, {-0.0061803398874921076`, -8.209332833133852, 
         0.11686129626602124`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.0061803398874921076`, -8.209332833133852, 
         0.11686129626602124`}, {-0.0061803398874921076`, -8.219332833133853, 
         0.11686129626602124`}, {-0.011755705045842621`, -8.219332833133853, 
         0.11402050582761711`}, {-0.011755705045842621`, -8.209332833133852, 
         0.11402050582761711`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045842621`, -8.209332833133852, 
         0.11402050582761711`}, {-0.011755705045842621`, -8.219332833133853, 
         0.11402050582761711`}, {-0.01618033988749211, -8.219332833133853, 
         0.10959587098596762`}, {-0.01618033988749211, -8.209332833133852, 
         0.10959587098596762`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749211, -8.209332833133852, 
         0.10959587098596762`}, {-0.01618033988749211, -8.219332833133853, 
         0.10959587098596762`}, {-0.019021130325896234`, -8.219332833133853, 
         0.1040205058276171}, {-0.019021130325896234`, -8.209332833133852, 
         0.1040205058276171}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019021130325896234`, -8.209332833133852, 
         0.1040205058276171}, {-0.019021130325896234`, -8.219332833133853, 
         0.1040205058276171}, {-0.019999999999993162`, -8.219332833133853, 
         0.09784016594011816}, {-0.019999999999993162`, -8.209332833133852, 
         0.09784016594011816}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019999999999993162`, -8.209332833133852, 
         0.09784016594011816}, {-0.019999999999993162`, -8.219332833133853, 
         0.09784016594011816}, {-0.019021130325896234`, -8.219332833133853, 
         0.09165982605261921}, {-0.019021130325896234`, -8.209332833133852, 
         0.09165982605261921}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.019021130325896234`, -8.209332833133852, 
         0.09165982605261921}, {-0.019021130325896234`, -8.219332833133853, 
         0.09165982605261921}, {-0.01618033988749211, -8.219332833133853, 
         0.08608446089426869}, {-0.01618033988749211, -8.209332833133852, 
         0.08608446089426869}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618033988749211, -8.209332833133852, 
         0.08608446089426869}, {-0.01618033988749211, -8.219332833133853, 
         0.08608446089426869}, {-0.011755705045842621`, -8.219332833133853, 
         0.0816598260526192}, {-0.011755705045842621`, -8.209332833133852, 
         0.0816598260526192}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755705045842621`, -8.209332833133852, 
         0.0816598260526192}, {-0.011755705045842621`, -8.219332833133853, 
         0.0816598260526192}, {-0.0061803398874921076`, -8.219332833133853, 
         0.07881903561421508}, {-0.0061803398874921076`, -8.209332833133852, 
         0.07881903561421508}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.0061803398874921076`, -8.209332833133852, 
         0.07881903561421508}, {-0.0061803398874921076`, -8.219332833133853, 
         0.07881903561421508}, {6.84146257121316*^-15, -8.219332833133853, 
         0.07784016594011815}, {6.84146257121316*^-15, -8.209332833133852, 
         0.07784016594011815}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{6.84146257121316*^-15, -8.209332833133852, 
         0.07784016594011815}, {6.84146257121316*^-15, -8.219332833133853, 
         0.07784016594011815}, {0.006180339887505791, -8.219332833133853, 
         0.07881903561421508}, {0.006180339887505791, -8.209332833133852, 
         0.07881903561421508}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.006180339887505791, -8.209332833133852, 
         0.07881903561421508}, {0.006180339887505791, -8.219332833133853, 
         0.07881903561421508}, {0.011755705045856305`, -8.219332833133853, 
         0.0816598260526192}, {0.011755705045856305`, -8.209332833133852, 
         0.0816598260526192}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755705045856305`, -8.209332833133852, 
         0.0816598260526192}, {0.011755705045856305`, -8.219332833133853, 
         0.0816598260526192}, {0.016180339887505786`, -8.219332833133853, 
         0.08608446089426869}, {0.016180339887505786`, -8.209332833133852, 
         0.08608446089426869}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180339887505786`, -8.209332833133852, 
         0.08608446089426869}, {0.016180339887505786`, -8.219332833133853, 
         0.08608446089426869}, {0.01902113032590991, -8.219332833133853, 
         0.09165982605261921}, {0.01902113032590991, -8.209332833133852, 
         0.09165982605261921}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.01902113032590991, -8.209332833133852, 
         0.09165982605261921}, {0.01902113032590991, -8.219332833133853, 
         0.09165982605261921}, {0.02000000000000684, -8.219332833133853, 
         0.09784016594011816}, {0.02000000000000684, -8.209332833133852, 
         0.09784016594011816}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.02000000000000684, -8.209332833133852, 
         0.09784016594011816}, {0.02000000000000684, -8.219332833133853, 
         0.09784016594011816}, {0.01902113032590991, -8.219332833133853, 
         0.1040205058276171}, {0.01902113032590991, -8.209332833133852, 
         0.1040205058276171}}]}}, {{{1., 0., 0.}, {0., 0.999986896956014, 
       0.005119171444896211}, {0., -0.005119171444896211, 
       0.999986896956014}}, {
       0., -0.0006084933480732246, -0.04204929607425428}}], {{{1., 
      0., -2.3794973291790866`*^-17}, {0., 1., 0.}, {2.3794973291790866`*^-17,
       0., 1.}}, {2.3281041354097558`*^-18, 0., 0.}}], {{{
     1., -5.4806540019983934`*^-15, 0.}, {5.4806540019983934`*^-15, 1., 0.}, {
     0., 0., 1.}}, {-4.501991611566185*^-14, 0., 0.}}]},
  AutomaticImageSize->True,
  ImageSize->{96.05993211554322, 519.6363393579753},
  ViewPoint->{3.356706469966171, 0.4161019012363536, -0.09685495482802614},
  ViewVertical->{2.728533196164403, 
   0.8731885423935786, -0.06645665380153766}]], "Output",
 CellChangeTimes->{
  3.517287339693692*^9, {3.5172875691856956`*^9, 3.517287587234927*^9}, 
   3.517530661069541*^9, 3.517530738617277*^9, {3.517611022234172*^9, 
   3.5176110556650305`*^9}, 3.5176963643668785`*^9, 3.5176988560091443`*^9, 
   3.517699171456499*^9, 3.5177200195543466`*^9, 3.517720572224518*^9, 
   3.5177323479547467`*^9, 3.5178785639213953`*^9, {3.517878611751079*^9, 
   3.5178786480055428`*^9}, {3.5187626685818467`*^9, 
   3.5187626884250813`*^9}, {3.5187627252567463`*^9, 3.518762732261159*^9}, 
   3.518762893253441*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transfer Function Plot", "Section",
 CellChangeTimes->{{3.510629600074376*^9, 3.5106296028355813`*^9}, {
  3.510922302451619*^9, 3.5109223035016794`*^9}}],

Cell[CellGroupData[{

Cell["Frequency List", "Subsection",
 CellChangeTimes->{{3.505457309098371*^9, 3.5054573134988823`*^9}, {
  3.505457392369238*^9, 3.505457393435096*^9}, {3.507903438769166*^9, 
  3.507903442019352*^9}, {3.5079450761978855`*^9, 3.5079450876015053`*^9}, {
  3.507945118302359*^9, 3.507945140813199*^9}, {3.5109227629829597`*^9, 
  3.510922763595995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fmin", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "1"}]], " ", "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"minimum", " ", "frequency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmax", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", "1"], "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"maximum", " ", "freqnency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ngrid", "=", "2001"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"number", " ", "of", " ", "grids"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727491881474*^9}, {
   3.514512526272725*^9, 3.514512533885538*^9}, {3.514512755015927*^9, 
   3.5145127581671324`*^9}, {3.517611922398961*^9, 3.5176119274949703`*^9}, {
   3.5176120612636013`*^9, 3.517612064508407*^9}, {3.5176299373002257`*^9, 
   3.517629937565426*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"freq", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"imin", ",", "imax", ",", "dgrid"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"imin", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmin"}], "]"}]}], ";", 
       RowBox[{"imax", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmax"}], "]"}]}], ";", 
       RowBox[{"dgrid", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"imax", "-", "imin"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"ngrid", "-", "1"}], ")"}]}]}], ";", "\n", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"10", "^", "i"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "imin", ",", "imax", ",", "dgrid"}], "}"}]}], 
        "]"}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Frequency", " ", "list"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727540428759*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Actuator Definition", "Subsection",
 CellChangeTimes->{{3.5109654612318583`*^9, 3.510965462635861*^9}, {
  3.5109690024068785`*^9, 3.510969004138481*^9}}],

Cell[CellGroupData[{

Cell["Actuator Name List", "Subsubsection",
 CellChangeTimes->{{3.5113307936249285`*^9, 3.5113308073529525`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"allacts", "=", 
    RowBox[{"{", 
     RowBox[{
     "aTM1", ",", "aTM2", ",", "aTM3", ",", "aTM4", ",", "aF01", ",", "aF02", 
      ",", "aF03"}], "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109727782843103`*^9, 3.5109728075967617`*^9}, 
   3.51133080025494*^9, {3.5113912910255685`*^9, 3.5113912956275764`*^9}, {
   3.5114124581364727`*^9, 3.511412463674483*^9}, {3.5114130712487497`*^9, 
   3.5114130854447746`*^9}, 3.5127114692567*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making Actuator List", "Subsubsection",
 CellChangeTimes->{{3.5113308136397634`*^9, 3.511330818600572*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"actuatorlist", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"(*", "TM", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posTM", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "actuated", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posTMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "actuated",
             " ", "body"}], "*)"}], "\[IndentingNewLine]", "posRM", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "recoil", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posRMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "recoil", 
            " ", "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"dirTMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], 
         RowBox[{"(*", 
          RowBox[{
          "working", " ", "direction", " ", "defined", " ", "at", " ", 
           "recoil", " ", "body"}], "*)"}], "\[IndentingNewLine]", "}"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "4"}], "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"(*", "F0", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posF0", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "actuated", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "actuated",
             " ", "body"}], "*)"}], "\[IndentingNewLine]", "posg", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "recoil", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "recoil", 
            " ", "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"dirF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], 
         RowBox[{"(*", 
          RowBox[{
          "working", " ", "direction", " ", "defined", " ", "at", " ", 
           "recoil", " ", "body"}], "*)"}], "\[IndentingNewLine]", "}"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109654818394947`*^9, 3.510965501292729*^9}, {
   3.510967724749034*^9, 3.510967731956247*^9}, {3.510969081296217*^9, 
   3.5109691312787046`*^9}, {3.5109691764251842`*^9, 3.510969496490946*^9}, {
   3.510969534071412*^9, 3.5109695354442143`*^9}, {3.5109728140863733`*^9, 
   3.510972844880827*^9}, 3.510974608651125*^9, {3.511003646932313*^9, 
   3.5110036534843245`*^9}, {3.5111471459271812`*^9, 
   3.5111471546631966`*^9}, {3.5111473903484106`*^9, 3.511147422125666*^9}, {
   3.5111552347923946`*^9, 3.5111552422648077`*^9}, {3.5113307607556705`*^9, 
   3.511330775575697*^9}, {3.5113321606397295`*^9, 3.511332172963751*^9}, {
   3.5113913047691927`*^9, 3.5113913416788573`*^9}, {3.5114131119804215`*^9, 
   3.5114131610581074`*^9}, 3.5127114769319134`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer Function Plot", "Subsection",
 CellChangeTimes->{{3.5106327360154905`*^9, 3.510632742271102*^9}, {
  3.5109229122064953`*^9, 3.5109229133585615`*^9}, {3.510975022395052*^9, 
  3.510975046309894*^9}, {3.511431088725732*^9, 3.511431089770934*^9}}],

Cell[CellGroupData[{

Cell["Usage Notes", "Subsubsection",
 CellChangeTimes->{{3.512731063640951*^9, 3.5127310662461557`*^9}}],

Cell[BoxData[
 RowBox[{"?", "tfplot"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127276236861057`*^9, 3.5127276254801083`*^9}, 
   3.5127278088272305`*^9, 3.5127285744453754`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplot[{param},{var},freqlist] calculates transfer functions \
from input parameters' displacement to output variables' displacement.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.518762893705842*^9},
 CellTags->"Info3518795293-9802361"],

Cell[BoxData[
 RowBox[{"?", "tfplotf"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127277012026415`*^9, 3.512727705445849*^9}, 
   3.5127278088272305`*^9, 3.5127285744609756`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplot[{varin},{varout},freq] calculates transfer functions \
from force exerted to the input variables, to output variables' displacement.\
\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5187628941114426`*^9},
 CellTags->"Info3518795293-4276075"],

Cell[BoxData[
 RowBox[{"?", "tfplota"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.512727708347454*^9, 3.512727710375458*^9}, 
   3.5127278088272305`*^9, 3.5127285744609756`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplota[{act},{var},freqlist] shows transfer functions from \
input actuator force to output variables' displacement. Input can be a linear \
combination of actuators.\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5187628944858437`*^9},
 CellTags->"Info3518795294-6540251"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots", "Subsubsection",
 CellChangeTimes->{{3.5127310719245653`*^9, 3.512731072782567*^9}}],

Cell[CellGroupData[{

Cell["Transfer function from disp. to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511418345274813*^9, 3.511418367785653*^9}}],

Cell[BoxData[
 RowBox[{"tfplot", "[", 
  RowBox[{
   RowBox[{"{", "zg", "}"}], ",", 
   RowBox[{"{", "zTM", "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510957748603794*^9, 3.5109577777446456`*^9}, {
   3.510957947894144*^9, 3.510957950312149*^9}, 3.5109588754873734`*^9, {
   3.510960251768591*^9, 3.5109602568386*^9}, {3.5109644688037157`*^9, 
   3.5109645325454273`*^9}, {3.5109646318084016`*^9, 3.510964636956411*^9}, {
   3.5109652306946535`*^9, 3.510965232036256*^9}, {3.5109653621872845`*^9, 
   3.510965374776507*^9}, {3.510965421685789*^9, 3.510965427161399*^9}, {
   3.5109750765583467`*^9, 3.5109750793195515`*^9}, {3.5109818646568904`*^9, 
   3.5109818950301437`*^9}, {3.5109829019735146`*^9, 
   3.5109829028627157`*^9}, {3.511147957815007*^9, 3.511147970092229*^9}, {
   3.5111480189515142`*^9, 3.5111480302771344`*^9}, {3.511152738053403*^9, 
   3.5111527568982363`*^9}, {3.5111614206837378`*^9, 
   3.5111614428905745`*^9}, {3.511232181917014*^9, 3.5112321830402164`*^9}, {
   3.5112326734114776`*^9, 3.5112326900723066`*^9}, {3.5112327680568438`*^9, 
   3.5112327702252474`*^9}, 3.51123286263981*^9, {3.5112329654595904`*^9, 
   3.5112329723704023`*^9}, {3.51123301048127*^9, 3.51123301626888*^9}, {
   3.511233061602559*^9, 3.511233087561005*^9}, {3.511233247133685*^9, 
   3.511233263388914*^9}, {3.511330838459407*^9, 3.511330842000613*^9}, {
   3.5113312692229633`*^9, 3.5113312709701667`*^9}, {3.5113904840985513`*^9, 
   3.511390509822996*^9}, {3.511414980348903*^9, 3.5114149810821047`*^9}, 
   3.511418367785653*^9, {3.512728004420374*^9, 3.5127280098959837`*^9}, {
   3.512733378388218*^9, 3.512733383676627*^9}, {3.5127354019145722`*^9, 
   3.512735408201383*^9}, {3.5145126445521326`*^9, 3.51451264860814*^9}, {
   3.514512709089446*^9, 3.5145127106026487`*^9}, {3.5176299531030536`*^9, 
   3.5176299558486586`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJw0nHdcTv0bx++7TUPrbu9FpZ0dX2SEZO8RIpRRqJCtSJQQmaFsylOkUrku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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{-2.302585092994045, -40.05730498437614},
     BaseStyle->{FontSize -> Scaled[0.04]},
     CoordinatesToolOptions:>{"DisplayFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& )},
     DisplayFunction:>$DisplayFunction,
     FormatType->TraditionalForm,
     Frame->True,
     FrameLabel->{
       FormBox["\"Frequency [Hz]\"", TraditionalForm]},
     FrameTicks->{{{{-39.14394658089878, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "17"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-32.23619130191664, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "14"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-25.328436022934504`, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-18.420680743952367`, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-11.512925464970229`, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-4.605170185988091, 
          FormBox["0.01`", TraditionalForm]}, {-34.42544770960368, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.73677480943866, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.332805587922074`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.04587229873253, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.823178286648194`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.64115653498315, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.48722005672038, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.35384934538487, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-27.517692430621544`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.82901953045652, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.42505030893994, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.1381170197504, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.915423007666057`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.733401256001017`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.57946477773825, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.446094066402736`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-20.609937151639407`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.921264251474383`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.5172950299578, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.230361740768263`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.00766772868392, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.82564597701888, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.671709498756112`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.5383387874206, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-13.70218187265727, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-13.013508972492247`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.609539750975665`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.322606461786126`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.099912449701783`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.917890698036741`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.763954219773973`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.63058350843846, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.794426593675134, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.10575369351011, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.701784471993528, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.4148511828039885`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.192157170719646, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.010135419054604, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8561989407918364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.722828229456324, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-39.14394658089878, 
          FormBox["\"\"", TraditionalForm]}, {-32.23619130191664, 
          FormBox["\"\"", TraditionalForm]}, {-25.328436022934504`, 
          FormBox["\"\"", TraditionalForm]}, {-18.420680743952367`, 
          FormBox["\"\"", TraditionalForm]}, {-11.512925464970229`, 
          FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
          FormBox["\"\"", TraditionalForm]}, {-34.42544770960368, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.73677480943866, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.332805587922074`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-33.04587229873253, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.823178286648194`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.64115653498315, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.48722005672038, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-32.35384934538487, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-27.517692430621544`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.82901953045652, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.42505030893994, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-26.1381170197504, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.915423007666057`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.733401256001017`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.57946477773825, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-25.446094066402736`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-20.609937151639407`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.921264251474383`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.5172950299578, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.230361740768263`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-19.00766772868392, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.82564597701888, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.671709498756112`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-18.5383387874206, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-13.70218187265727, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-13.013508972492247`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.609539750975665`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.322606461786126`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-12.099912449701783`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.917890698036741`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.763954219773973`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-11.63058350843846, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.794426593675134, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.10575369351011, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.701784471993528, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.4148511828039885`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.192157170719646, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.010135419054604, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8561989407918364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.722828229456324, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}}, {{{-2.302585092994046, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-1.6094379124341003`, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-0.6931471805599453, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {0., 
          FormBox[
           TagBox[
            InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {0.6931471805599453, 
          FormBox[
           TagBox[
            InterpretationBox["\"2.0\"", 2., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {1.6094379124341003`, 
          FormBox[
           TagBox[
            InterpretationBox["\"5.0\"", 5., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {2.302585092994046, 
          FormBox[
           TagBox[
            InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {2.995732273553991, 
          FormBox[
           TagBox[
            InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {3.912023005428146, 
          FormBox[
           TagBox[
            InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-1.2039728043259361`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5108256237659907, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.35667494393873245`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2231435513142097, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.10536051565782628`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.0986122886681098`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3862943611198906`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.791759469228055, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9459101490553132`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.0794415416798357`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.1972245773362196`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.4011973816621555`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6888794541139363`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-2.302585092994046, 
          FormBox["\"\"", TraditionalForm]}, {-1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm]}, {-0.6931471805599453, 
          FormBox["\"\"", TraditionalForm]}, {0., 
          FormBox["\"\"", TraditionalForm]}, {0.6931471805599453, 
          FormBox["\"\"", TraditionalForm]}, {1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
          FormBox["\"\"", TraditionalForm]}, {2.995732273553991, 
          FormBox["\"\"", TraditionalForm]}, {3.912023005428146, 
          FormBox["\"\"", TraditionalForm]}, {-1.2039728043259361`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5108256237659907, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.35667494393873245`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2231435513142097, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.10536051565782628`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.0986122886681098`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3862943611198906`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.791759469228055, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9459101490553132`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.0794415416798357`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.1972245773362196`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.4011973816621555`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {3.6888794541139363`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}}},
     GridLines->{{-2.302585092994046, -1.6094379124341003`, \
-0.6931471805599453, 0., 0.6931471805599453, 1.6094379124341003`, 
       2.302585092994046, 2.995732273553991, 
       3.912023005428146, -1.2039728043259361`, -0.916290731874155, \
-0.5108256237659907, -0.35667494393873245`, -0.2231435513142097, \
-0.10536051565782628`, 1.0986122886681098`, 1.3862943611198906`, 
       1.791759469228055, 1.9459101490553132`, 2.0794415416798357`, 
       2.1972245773362196`, 3.4011973816621555`, 
       3.6888794541139363`}, CompressedData["
1:eJwBfQGC/iFib1JlAQAAAC4AAABnqnDXbJJDwHOqPoQ7HkDA/lQZYhRUOcAW
VbW7sWsywFuqoiqeBifAFVW1u7FrEsD1cw8SdTZBwCCHD6NO3kDAkwaeX5mq
QMCebLsk34VAwDX39eddaUDARq/WahFSQMDfyBA6XT5AwMwRc+9KLUDAAui6
fYeEO8BYDrufOtQ6wD8N2BjQbDrAVdkSo1sjOsCC7ocpWeo5wKReSS/AuznA
15G9zVeUOcCwI4I4M3I5wBroVtcknDTAcA5X+dfrM8BWDXRybYQzwG3Zrvz4
OjPAmu4jg/YBM8C8XuWIXdMywO+RWSf1qzLAyCMektCJMsBk0OVhhGcrwBAd
5qXqBirA3RogmBU4KcAKs5WsLKUowGTdf7knMyjAp70CxfXVJ8ANJOsBJYcn
wL9HdNfbQifAKKE7Kn4tG8CAOjyySmwYwBk2sJagzhbAc2abv86oFcAou2/Z
xMQUwK57dfBgChTAekhGar9sE8Dej1gVLeQSwMYBsvA=
       "]},
     ImageSize->600,
     Method->{},
     PlotRange->{{-2.302585092994045, 2.302585092994045}, {-40.05730498437614,
       0.8115974087171347}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]},
     Ticks->{{{-2.302585092994046, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-1.6094379124341003`, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-0.6931471805599453, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {0., 
         FormBox[
          TagBox[
           InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {0.6931471805599453, 
         FormBox[
          TagBox[
           InterpretationBox["\"2.0\"", 2., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {1.6094379124341003`, 
         FormBox[
          TagBox[
           InterpretationBox["\"5.0\"", 5., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {2.302585092994046, 
         FormBox[
          TagBox[
           InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {2.995732273553991, 
         FormBox[
          TagBox[
           InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {3.912023005428146, 
         FormBox[
          TagBox[
           InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-1.2039728043259361`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.916290731874155, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.5108256237659907, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.35667494393873245`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.2231435513142097, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.10536051565782628`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.0986122886681098`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.3862943611198906`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.791759469228055, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.9459101490553132`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {2.0794415416798357`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {2.1972245773362196`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {3.4011973816621555`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {3.6888794541139363`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}}, {{-39.14394658089878, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "17"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox], TraditionalForm]}, {-32.23619130191664, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "14"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox], TraditionalForm]}, {-25.328436022934504`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
           SuperscriptBox], TraditionalForm]}, {-18.420680743952367`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm]}, {-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm]}, {-4.605170185988091, 
         FormBox["0.01`", TraditionalForm]}, {-34.42544770960368, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-33.73677480943866, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-33.332805587922074`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-33.04587229873253, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-32.823178286648194`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-32.64115653498315, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-32.48722005672038, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-32.35384934538487, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-27.517692430621544`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-26.82901953045652, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-26.42505030893994, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-26.1381170197504, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-25.915423007666057`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-25.733401256001017`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-25.57946477773825, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-25.446094066402736`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-20.609937151639407`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-19.921264251474383`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-19.5172950299578, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-19.230361740768263`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-19.00766772868392, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-18.82564597701888, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-18.671709498756112`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-18.5383387874206, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-13.70218187265727, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-13.013508972492247`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-12.609539750975665`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-12.322606461786126`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-12.099912449701783`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-11.917890698036741`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-11.763954219773973`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-11.63058350843846, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-6.794426593675134, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-6.10575369351011, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.701784471993528, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.4148511828039885`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.192157170719646, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.010135419054604, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.8561989407918364`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.722828229456324, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}}}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], GraphicsGroupBox[{
     {GrayLevel[0], RectangleBox[{0.35, 0.3}, {0.688, 0.38}]}, 
     {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.001]}], 
      GraphicsGroupBox[{RectangleBox[{0.35, 0.3}, {0.688, 0.38}], InsetBox[
         GraphicsBox[{{InsetBox[
             GraphicsBox[{
               {Hue[0.67, 0.6, 0.6], Thickness[Large], 
                LineBox[{{0, 0.5}, {1, 0.5}}]}, {}},
              PlotRange->{{0, 1}, {0, 1}}], {0, 0}, {Left, Bottom}, {1, 1}], 
            InsetBox[
             StyleBox["\<\"zTM/zg\"\>",
              StripOnInput->False,
              FontSize->14], NCache[{1.05, Rational[1, 2]}, {1.05, 0.5}], {-1, 0},
              Automatic, {1, 0}]}, {}},
          AspectRatio->0.2366863905325444,
          FormatType->TraditionalForm,
          PlotRange->{{-0.1, 3.6}, {-0.1, 1.1}}], {0.35, 0.3}, {
         Left, Bottom}, {0.338, 0.08}]}]}}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->600.,
  PlotRange->All]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511161422990941*^9, 3.5111614478109827`*^9}, 
   3.511230657179332*^9, 3.511230687973786*^9, 3.511231850987028*^9, 
   3.5112321855830207`*^9, 3.5112326978099203`*^9, 3.5112327732360525`*^9, {
   3.5112328563529987`*^9, 3.5112328659626155`*^9}, 3.5112329164599047`*^9, 
   3.5112329747416067`*^9, {3.5112330127276735`*^9, 3.5112330177040825`*^9}, {
   3.5112330645665646`*^9, 3.511233088918207*^9}, {3.5112332403788733`*^9, 
   3.511233264777316*^9}, 3.511330866367856*^9, 3.5113313123882394`*^9, 
   3.511390364321541*^9, 3.5113904650821176`*^9, {3.511390495814172*^9, 
   3.5113905162346077`*^9}, 3.511418367785653*^9, 3.5114185710696096`*^9, 
   3.511431634843893*^9, 3.512730750000399*^9, 3.5127333926310434`*^9, {
   3.512735394317359*^9, 3.5127354208530054`*^9}, 3.5145125759276123`*^9, 
   3.5145126576873555`*^9, 3.514512719182664*^9, 3.5145127724879575`*^9, 
   3.51666994877286*^9, 3.5176299714018855`*^9, 3.518762781978446*^9, 
   3.518762907277866*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer function from force to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5109750603967185`*^9, 3.5109750715975385`*^9}, {
  3.5114183861780853`*^9, 3.5114184005613103`*^9}}],

Cell[BoxData[
 RowBox[{"tfplotf", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"zIM", "-", "zIRM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"zTM", ",", "pitchTM"}], "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.510957748603794*^9, 3.5109577777446456`*^9}, {
   3.510957947894144*^9, 3.510957950312149*^9}, 3.5109588754873734`*^9, {
   3.510960251768591*^9, 3.5109602568386*^9}, {3.5109644688037157`*^9, 
   3.5109645325454273`*^9}, {3.5109646318084016`*^9, 3.510964636956411*^9}, {
   3.5109652306946535`*^9, 3.510965232036256*^9}, {3.5109653621872845`*^9, 
   3.510965374776507*^9}, {3.510965421685789*^9, 3.510965427161399*^9}, {
   3.5109750765583467`*^9, 3.5109750893035693`*^9}, {3.5109828951875024`*^9, 
   3.510982897106306*^9}, {3.511002574321229*^9, 3.511002578689237*^9}, {
   3.511147126083946*^9, 3.511147126583147*^9}, {3.51133135800272*^9, 
   3.5113313625891275`*^9}, 3.5114184005613103`*^9, {3.511431802278987*^9, 
   3.511431817223813*^9}, {3.5114319322428155`*^9, 3.511431934083619*^9}, {
   3.511494423146207*^9, 3.511494426297412*^9}, {3.5114944629106765`*^9, 
   3.511494463940278*^9}, {3.511494528649192*^9, 3.511494529819194*^9}, {
   3.511494611407337*^9, 3.5114946157285447`*^9}, {3.5114947070511055`*^9, 
   3.51149470978111*^9}, {3.511495153274289*^9, 3.511495157252296*^9}, {
   3.511495906471814*^9, 3.5114959082502174`*^9}, 3.511495988091158*^9, {
   3.5114960625188885`*^9, 3.5114960693985004`*^9}, {3.5114976579860983`*^9, 
   3.5114976911673565`*^9}, {3.511497813627572*^9, 3.511497817184378*^9}, {
   3.5123560718342876`*^9, 3.512356077871499*^9}, {3.5123561129091606`*^9, 
   3.512356116699967*^9}, {3.5123595749764414`*^9, 3.51235961417931*^9}, 
   3.512359690713044*^9, {3.512423733837125*^9, 3.5124237421987395`*^9}, {
   3.512728016650796*^9, 3.5127280238736086`*^9}, {3.514170374388322*^9, 
   3.5141703868683434`*^9}, {3.5142423784843864`*^9, 
   3.5142423866744003`*^9}, {3.5145128785369434`*^9, 
   3.5145128975221767`*^9}, {3.5176119005701246`*^9, 
   3.5176119037837305`*^9}, {3.5176120016754985`*^9, 
   3.5176120285075455`*^9}, {3.5187631494994917`*^9, 3.518763151340295*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer function from actuator to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510969554959849*^9, 3.510969560841059*^9}, {
   3.5109751070876007`*^9, 3.5109751100048056`*^9}, {3.5114184059745197`*^9, 
   3.511418444678188*^9}, 3.5127279886643467`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ca1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ca2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"-", "0.25"}], ",", 
     RowBox[{"-", "0.25"}], ",", 
     RowBox[{"+", "0.25"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aTMlist", "=", 
   RowBox[{"{", 
    RowBox[{"aTM1", ",", "aTM2", ",", "aTM3", ",", "aTM4"}], "}"}]}], 
  ";"}]}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.512727879666955*^9, 3.5127279886643467`*^9}}],

Cell[BoxData[
 RowBox[{"tfplota", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ca1", ".", "aTMlist"}], ",", 
     RowBox[{"ca2", ".", "aTMlist"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"zTM", ",", "pitchTM"}], "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510974630101163*^9, 3.510974667307228*^9}, {
   3.5109751707513123`*^9, 3.510975230827018*^9}, {3.510975278219901*^9, 
   3.510975296534333*^9}, 3.510975617333297*^9, 3.5109762079503345`*^9, {
   3.510976711909239*^9, 3.5109767681005373`*^9}, {3.510981275918256*^9, 
   3.510981277462659*^9}, {3.5109815367911143`*^9, 3.510981543436726*^9}, {
   3.5110039773252935`*^9, 3.5110039774500937`*^9}, {3.5111476837225256`*^9, 
   3.511147683909726*^9}, {3.511149615115118*^9, 3.5111496153023186`*^9}, {
   3.5111518249681997`*^9, 3.5111518251085997`*^9}, {3.511155202125937*^9, 
   3.511155202281937*^9}, {3.511155261842842*^9, 3.511155266881651*^9}, {
   3.51133147809173*^9, 3.511331483863741*^9}, {3.5113317639466324`*^9, 
   3.511331775989854*^9}, {3.5113321818401666`*^9, 3.5113321940861883`*^9}, {
   3.511332324533617*^9, 3.511332347590458*^9}, {3.511332426900997*^9, 
   3.511332473513879*^9}, {3.511332686797454*^9, 3.51133270737389*^9}, {
   3.511332765078391*^9, 3.511332767293595*^9}, {3.511391414234585*^9, 
   3.511391414983386*^9}, {3.511418452665402*^9, 3.511418453414203*^9}, {
   3.51141849147827*^9, 3.5114185140983095`*^9}, {3.511418638882929*^9, 
   3.51141863970973*^9}, {3.5114187268670835`*^9, 3.511418727069884*^9}, {
   3.511418809126028*^9, 3.5114188156312394`*^9}, {3.5114318640550957`*^9, 
   3.5114318802947245`*^9}, {3.5127278701353383`*^9, 3.512727873208544*^9}, {
   3.5127279545158863`*^9, 3.5127279886643467`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["State-Space Model", "Section",
 CellChangeTimes->{{3.511335807091339*^9, 3.5113358106481447`*^9}, 
   3.511337659532192*^9, {3.512773070004176*^9, 3.5127730729993815`*^9}}],

Cell[CellGroupData[{

Cell["State-Space Matrices", "Subsection",
 CellChangeTimes->{{3.511338449601981*^9, 3.511338476356028*^9}}],

Cell[CellGroupData[{

Cell["Set Input", "Subsubsection",
 CellChangeTimes->{{3.511345101119687*^9, 3.5113451151285114`*^9}, 
   3.5113452765575953`*^9, {3.5113491519476023`*^9, 3.511349152649603*^9}}],

Cell[CellGroupData[{

Cell["Create parameter input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393300724698*^9}, 
   3.511393991963113*^9, {3.511394540569276*^9, 3.5113945443288827`*^9}, 
   3.512728164258255*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputp", "=", 
   RowBox[{"{", "zg", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputvecp", "=", 
   RowBox[{"makeinputvecp", "[", "inputp", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, 3.5113933213323345`*^9, 3.511393991963113*^9, {
   3.5127281565986414`*^9, 3.5127281605922484`*^9}, {3.5127308942850523`*^9, 
   3.51273090969788*^9}, {3.5148599087639613`*^9, 3.514859909281991*^9}, {
   3.514861273035993*^9, 3.5148612741040545`*^9}, {3.516669984840123*^9, 
   3.5166699868525267`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create force input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393313891122*^9}, 
   3.5113939948803177`*^9, {3.5113945468248873`*^9, 3.5113945475892887`*^9}, 
   3.5127281856926928`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputf", "=", 
   RowBox[{"{", "zF0", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputvecf", "=", 
   RowBox[{"makeinputvecf", "[", "inputf", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, {3.5113933227831373`*^9, 3.511393333874757*^9}, 
   3.5113939948803177`*^9, {3.511419195257906*^9, 3.5114191953359065`*^9}, 
   3.51143273690463*^9, {3.5127281700770655`*^9, 3.5127281744762726`*^9}, {
   3.5127309033018684`*^9, 3.512730912833485*^9}, {3.514859401173958*^9, 
   3.514859412374778*^9}, {3.5148594572404566`*^9, 3.514859458504059*^9}, {
   3.5148612767252045`*^9, 3.514861278426302*^9}, {3.5166699905965333`*^9, 
   3.5166700259461956`*^9}, {3.518762972704381*^9, 3.5187629799271936`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create actuator input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393346042778*^9}, {
   3.511394549476892*^9, 3.5113945509276943`*^9}, {3.5127281815742855`*^9, 
   3.5127281824634867`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputa", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputveca", "=", 
   RowBox[{"makeinputveca", "[", "inputa", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, {3.5113933227831373`*^9, 3.511393333874757*^9}, {
   3.5113934356805353`*^9, 3.511393441889346*^9}, {3.5113939599674563`*^9, 
   3.5113939625102606`*^9}, {3.5114327391510344`*^9, 
   3.5114327467638474`*^9}, {3.512728188204297*^9, 3.512728199093116*^9}, {
   3.5127309146586885`*^9, 3.51273092685791*^9}, 3.514859392781143*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Output", "Subsubsection",
 CellChangeTimes->{{3.5113471295288496`*^9, 3.511347130230851*^9}, {
  3.511349154038006*^9, 3.511349154693207*^9}}],

Cell[CellGroupData[{

Cell["Create output vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, {
   3.511347126221644*^9, 3.5113471378280644`*^9}, {3.511394532363662*^9, 
   3.5113945368876696`*^9}, {3.512728214271943*^9, 3.5127282158943453`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outputv", "=", 
   RowBox[{"{", 
    RowBox[{
    "zF0", ",", "zF1", ",", "zF2", ",", "zF3", ",", "zF4", ",", "zIM", ",", 
     "zIRM", ",", "zTM", ",", "zRM"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outputvecv", "=", 
   RowBox[{"makeoutputvecv", "[", "outputv", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, {3.5113470309210763`*^9, 
   3.511347050530311*^9}, 3.511347126221644*^9, {3.5113926520031586`*^9, 
   3.51139265832117*^9}, {3.5113944608687363`*^9, 3.511394475579562*^9}, 
   3.5114190053119726`*^9, {3.512728211682338*^9, 3.5127282259251633`*^9}, {
   3.5127309369199276`*^9, 3.512730975311595*^9}, {3.514859461015663*^9, 
   3.5148594946649218`*^9}, {3.5166700335590086`*^9, 3.5166700562570486`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["State-Space Matrices", "Subsubsection",
 CellChangeTimes->{{3.5113428440609226`*^9, 3.5113428707837696`*^9}, {
  3.5114035961001205`*^9, 3.511403604336935*^9}, {3.511404827987484*^9, 
  3.511404832542692*^9}}],

Cell[CellGroupData[{

Cell["\<\
Damping frequency (for use in converting structure damping to viscous damping)\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511404853665129*^9, 3.5114048575495358`*^9}, {
  3.5114049021188145`*^9, 3.5114049368912754`*^9}, {3.5114050434862623`*^9, 
  3.5114050447498646`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fdamp", "=", 
    RowBox[{"0.03", "hertz"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511404881448778*^9, 3.5114049021188145`*^9}, {
  3.5114059906771326`*^9, 3.511405991878335*^9}, {3.511406097755721*^9, 
  3.5114061003297253`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create the \"A\" matrix. Structure damping is considered to be zero.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.511349227935335*^9, 3.5113492291365376`*^9}, {3.5114048144466605`*^9, 
  3.51140481996907*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssAr", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"IdentityMatrix", "[", 
          RowBox[{"Length", "[", "allvars", "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKvv"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matGvv"}]}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113426757990274`*^9, 3.5113426772342296`*^9}, {
   3.5113427437527466`*^9, 3.5113427464047513`*^9}, {3.511342836120509*^9, 
   3.511342836338909*^9}, {3.5113428792545843`*^9, 3.511342914588647*^9}, {
   3.5113433061181345`*^9, 3.5113433157745514`*^9}, {3.511343413555523*^9, 
   3.51134342885915*^9}, {3.511343479060038*^9, 3.5113435935642395`*^9}, {
   3.511343633001108*^9, 3.5113436752147827`*^9}, {3.5113438056778116`*^9, 
   3.5113438390618706`*^9}, 3.5113438807139435`*^9, 3.51134391846601*^9, {
   3.511347221849812*^9, 3.511347406320136*^9}, {3.511347441045797*^9, 
   3.5113474641026373`*^9}, 3.511347506503512*^9, 3.511349063230246*^9, 
   3.5113491808076525`*^9, {3.511352291731519*^9, 3.5113522926051207`*^9}, {
   3.5113527927143993`*^9, 3.5113528109664316`*^9}, {3.5113905926279416`*^9, 
   3.5113905982283516`*^9}, {3.5114050655291014`*^9, 3.511405068290306*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create the \"A\" matrix. Structure damping is approximated by viscous damping \
such that the amount of phase lag is the same at damping frequency.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.511349227935335*^9, 3.5113492291365376`*^9}, {3.51140477454179*^9, 
  3.5114048023878393`*^9}, {3.5114048635711465`*^9, 3.5114048754583673`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssAa", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"IdentityMatrix", "[", 
          RowBox[{"Length", "[", "allvars", "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKvv"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matGvv"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"Inverse", "[", "matMvv", "]"}], ".", 
            RowBox[{"Im", "[", "matKvvc", "]"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], "fdamp"}], ")"}]}]}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113426757990274`*^9, 3.5113426772342296`*^9}, {
   3.5113427437527466`*^9, 3.5113427464047513`*^9}, {3.511342836120509*^9, 
   3.511342836338909*^9}, {3.5113428792545843`*^9, 3.511342914588647*^9}, {
   3.5113433061181345`*^9, 3.5113433157745514`*^9}, {3.511343413555523*^9, 
   3.51134342885915*^9}, {3.511343479060038*^9, 3.5113435935642395`*^9}, {
   3.511343633001108*^9, 3.5113436752147827`*^9}, {3.5113438056778116`*^9, 
   3.5113438390618706`*^9}, 3.5113438807139435`*^9, 3.51134391846601*^9, {
   3.511347221849812*^9, 3.511347406320136*^9}, {3.511347441045797*^9, 
   3.5113474641026373`*^9}, 3.511347506503512*^9, 3.511349063230246*^9, 
   3.5113491808076525`*^9, {3.511352291731519*^9, 3.5113522926051207`*^9}, {
   3.5113527927143993`*^9, 3.5113528109664316`*^9}, {3.5113905926279416`*^9, 
   3.5113905982283516`*^9}, 3.5114048023878393`*^9, {3.511405008043*^9, 
   3.5114051058707724`*^9}, {3.5114054963638587`*^9, 3.511405506831477*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"B\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113492256733313`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssB", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputp", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputf", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputa", "]"}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKpv", ".", 
           "inputvecp"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "inputvecf"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "inputveca"}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511343921024414*^9, 3.5113439340036373`*^9}, {
   3.5113475427891755`*^9, 3.5113477094598684`*^9}, {3.5113478660841436`*^9, 
   3.5113479747539344`*^9}, {3.511348254119225*^9, 3.5113482681436496`*^9}, {
   3.5113485186332893`*^9, 3.51134851882049*^9}, 3.511349064587448*^9, 
   3.511349196797681*^9, {3.5113528177836437`*^9, 3.5113528253184566`*^9}, {
   3.5113529173430185`*^9, 3.5113529199950233`*^9}, {3.511392437830383*^9, 
   3.511392440373187*^9}, {3.5113925180769234`*^9, 3.511392522725732*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"C\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113492162977147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssC", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{"outputvecv", ",", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", "2"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511348273494459*^9, 3.5113482899836884`*^9}, {
   3.5113483981230783`*^9, 3.5113484770436163`*^9}, {3.5113485408165283`*^9, 
   3.511348569692179*^9}, 3.5113486013602347`*^9, {3.511348992686922*^9, 
   3.5113490063369465`*^9}, {3.511349044089012*^9, 3.5113490659446507`*^9}, 
   3.5113492071716986`*^9, {3.5113529435354643`*^9, 3.511352946218669*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"D\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.5113492109469056`*^9, 3.5113492202133217`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssD", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputp", "]"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputf", "]"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputa", "]"}], "}"}]}], "]"}], ",", "2"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511349068035054*^9, 3.511349108813526*^9}, {
  3.5113492202133217`*^9, 3.511349221913725*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Subsection",
 CellChangeTimes->{{3.5113492434105625`*^9, 3.5113492506957755`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matlabexport", "[", 
    RowBox[{"\"\<matlab/ss110704_eddy.m\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssA\>\"", ",", "ssAa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssB\>\"", ",", "ssB"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssC\>\"", ",", "ssC"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssD\>\"", ",", "ssD"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.511349255204183*^9, 3.511349323360703*^9}, 
   3.5114051453544416`*^9, {3.5114052158381658`*^9, 3.5114052352194*^9}, 
   3.5114055594347696`*^9, 3.511418896018181*^9, 3.511431975798092*^9, {
   3.5114323267943096`*^9, 3.5114323285415125`*^9}, {3.5148593508950696`*^9, 
   3.514859353890275*^9}, {3.516670096411519*^9, 3.516670112214347*^9}, {
   3.518762990816013*^9, 3.518762994092018*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise", "Section",
 CellChangeTimes->{{3.512731095621007*^9, 3.512731107040227*^9}}],

Cell[CellGroupData[{

Cell["About This Section", "Subsection",
 CellChangeTimes->{{3.518762140341918*^9, 3.5187621449907265`*^9}}],

Cell["\<\
The data of the seismic vibration level in Kamioka are imported from the \
\"../seism_kamioka\" folder. The vibration of the TM caused by the seismic \
motion is estimated, and the spectrum densities, RMS displacement, and RMS \
velocities are plotted.
\
\>", "Text",
 CellChangeTimes->{{3.518762219699258*^9, 3.5187622745021534`*^9}, {
  3.518762314204624*^9, 3.5187624772319107`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frequency List", "Subsection",
 CellChangeTimes->{{3.505457309098371*^9, 3.5054573134988823`*^9}, {
  3.505457392369238*^9, 3.505457393435096*^9}, {3.507903438769166*^9, 
  3.507903442019352*^9}, {3.5079450761978855`*^9, 3.5079450876015053`*^9}, {
  3.507945118302359*^9, 3.507945140813199*^9}, {3.5109227629829597`*^9, 
  3.510922763595995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fmin", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]], " ", "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"minimum", " ", "frequency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmax", "=", 
    RowBox[{"2", " ", 
     SuperscriptBox["10", "1"], "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"maximum", " ", "freqnency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ngrid", "=", "2001"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"number", " ", "of", " ", "grids"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727491881474*^9}, {
   3.512735563374856*^9, 3.51273556568366*^9}, {3.512735595916513*^9, 
   3.5127355960881133`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"freq", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"imin", ",", "imax", ",", "dgrid"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"imin", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmin"}], "]"}]}], ";", 
       RowBox[{"imax", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmax"}], "]"}]}], ";", 
       RowBox[{"dgrid", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"imax", "-", "imin"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"ngrid", "-", "1"}], ")"}]}]}], ";", "\n", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"10", "^", "i"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "imin", ",", "imax", ",", "dgrid"}], "}"}]}], 
        "]"}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Frequency", " ", "list"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727540428759*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise Level in Kamioka", "Subsection",
 CellChangeTimes->{{3.512731113826239*^9, 3.512731119130248*^9}, {
  3.512731225506835*^9, 3.5127312319340467`*^9}}],

Cell[CellGroupData[{

Cell["Import Data", "Subsubsection",
 CellChangeTimes->{{3.51273123979646*^9, 3.5127312417152634`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaQD", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<../seism_kamioka/kamiokaQ.txt\>\"", ",", "\"\<Table\>\""}], 
     "]"}]}], ";"}], 
  RowBox[{"(*", "normal", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaND", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<../seism_kamioka/kamiokaN.txt\>\"", ",", "\"\<Table\>\""}], 
     "]"}]}], ";"}], 
  RowBox[{"(*", "noisy", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512731124044257*^9, 3.512731183324361*^9}, {
  3.5127313785115056`*^9, 3.5127313796035075`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolation", "Subsubsection",
 CellChangeTimes->{{3.5127312456152706`*^9, 3.5127312474092736`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kamiokaQI", "=", 
   RowBox[{"Interpolation", "[", "kamiokaQD", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaNI", "=", 
   RowBox[{"Interpolation", "[", "kamiokaND", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaQ", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"kamiokaQI", "[", 
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaN", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"kamiokaNI", "[", 
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512731309964985*^9, 3.5127314691788645`*^9}, {
  3.5127328485644875`*^9, 3.5127328496252894`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer Function", "Subsection",
 CellChangeTimes->{{3.512731535759782*^9, 3.5127315489106045`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMh", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"tfcalc", "[", 
      RowBox[{"zg", ",", "zTM", ",", "freq"}], "]"}], "]"}]}], ";"}], 
  RowBox[{"(*", "horizontal", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMv", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"tfcalc", "[", 
      RowBox[{"yg", ",", "yTM", ",", "freq"}], "]"}], "]"}]}], ";"}], 
  RowBox[{"(*", "vertical", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMm", "=", 
    RowBox[{"tfgr2TMh", "+", 
     RowBox[{"tfgr2TMv", "*", "0.01"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"H", "+", 
    RowBox[{"V", "*", "0.01"}]}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5127315591754227`*^9, 3.5127317173909006`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["TM Displacement", "Subsection",
 CellChangeTimes->{{3.512737312371275*^9, 3.5127373256310334`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"seismTM", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"kamiokaN", "[", 
        RowBox[{"[", "n", "]"}], "]"}], 
       RowBox[{"tfgr2TMm", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127368633335915`*^9, 3.512736871853079*^9}, 
   3.512737338522771*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Amplitude", "Subsection",
 CellChangeTimes->{{3.512737343119034*^9, 3.5127373479093075`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsG", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"kamiokaN", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 3.5127368011750364`*^9}, 
   3.512736888779047*^9, {3.512737005731736*^9, 3.512737006619787*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsTM", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"seismTM", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
  3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
  3.5127365074132338`*^9}, {3.5127365389750395`*^9, 3.5127366695405073`*^9}, {
  3.5127367255437107`*^9, 3.5127368011750364`*^9}, {3.512736888779047*^9, 
  3.5127369084451714`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Velocity", "Subsection",
 CellChangeTimes->{{3.5127373596419787`*^9, 3.512737362145122*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsGv", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], 
             RowBox[{"freq", "[", 
              RowBox[{"[", 
               RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"kamiokaN", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             "\[IndentingNewLine]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 3.5127368011750364`*^9}, 
   3.512736888779047*^9, {3.512737005731736*^9, 3.512737006619787*^9}, {
   3.5127371563913536`*^9, 3.5127372121745443`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsTMv", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], 
             RowBox[{"freq", "[", 
              RowBox[{"[", 
               RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"seismTM", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             "\[IndentingNewLine]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 
   3.5127368011750364`*^9}, {3.512736888779047*^9, 3.5127369084451714`*^9}, 
   3.5127371603895817`*^9, {3.5127372199189873`*^9, 3.5127372226241417`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot", "Subsection",
 CellChangeTimes->{{3.5127324150709257`*^9, 3.5127324159289274`*^9}}],

Cell[CellGroupData[{

Cell["Transfer Function", "Subsubsection",
 CellChangeTimes->{{3.5127324243373423`*^9, 3.5127324316693554`*^9}, {
  3.512735786767248*^9, 3.512735789684453*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tfgr2TMh", ",", "tfgr2TMv", ",", "tfgr2TMm"}], "}"}], ",", 
   "freq", ",", "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Horizontal\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Vertical\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<H+V*0.01\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512732433853359*^9, 3.5127324824474444`*^9}, {
  3.512732521244713*^9, 3.512732581726019*^9}, {3.512735625416165*^9, 
  3.5127356343861804`*^9}, {3.5127356820130644`*^9, 3.5127357681720157`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise in Kamioka", "Subsubsection",
 CellChangeTimes->{{3.512735800011671*^9, 3.51273580487888*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kamiokaQ", ",", "kamiokaN"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Normal\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Noisy\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512735814020496*^9, 3.5127358381849384`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displacement of TM", "Subsubsection",
 CellChangeTimes->{{3.512735870445795*^9, 3.5127358735502005`*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kamiokaN", ",", "seismTM"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "24"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127359108810663`*^9, 3.512735932487104*^9}, {
  3.5127360578145185`*^9, 3.5127360749604993`*^9}, {3.512736876635352*^9, 
  3.512736877886424*^9}, {3.5127374336122093`*^9, 3.5127374629808893`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Amplitude", "Subsubsection",
 CellChangeTimes->{{3.512736221085857*^9, 3.512736229689349*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rmsG", ",", "rmsTM"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], ",", 
        RowBox[{"5", " ", 
         SuperscriptBox["10", "0"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127369493235097`*^9, 3.5127369555868683`*^9}, {
  3.5127370239277773`*^9, 3.512737123213456*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Velocity", "Subsubsection",
 CellChangeTimes->{{3.512736221085857*^9, 3.512736229689349*^9}, {
  3.5127371487029133`*^9, 3.5127371538812103`*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rmsGv", ",", "rmsTMv"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], ",", 
        RowBox[{"5", " ", 
         SuperscriptBox["10", "0"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127369493235097`*^9, 3.5127369555868683`*^9}, {
  3.5127370239277773`*^9, 3.512737123213456*^9}, {3.512737228658487*^9, 
  3.512737266235636*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Subsection",
 CellChangeTimes->{{3.512737737191573*^9, 3.512737738408643*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "file", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"file", "=", 
       RowBox[{
       "OpenWrite", "[", "\"\<data/typeA_seism_110704.txt\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", "\[IndentingNewLine]", 
       RowBox[{"file", ",", "\[IndentingNewLine]", 
        RowBox[{"ExportString", "[", 
         RowBox[{
          RowBox[{"comb", "[", 
           RowBox[{"freq", ",", "seismTM"}], "]"}], ",", "\"\<Table\>\""}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5120931380276957`*^9, 3.5120932074634175`*^9}, {
   3.5120944398499823`*^9, 3.512094444951191*^9}, {3.512094493982077*^9, 
   3.5120944961036806`*^9}, {3.512729825246375*^9, 3.5127298255739756`*^9}, 
   3.5127302268534803`*^9, {3.512737834559142*^9, 3.512737910425482*^9}, {
   3.512737965140611*^9, 3.5127379740961237`*^9}, {3.51273804413513*^9, 
   3.512738045349199*^9}, {3.518763231696036*^9, 3.5187632336304393`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1008, 720},
WindowMargins->{{18, Automatic}, {-23, Automatic}},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (2008\:5e7412\:670810\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3518795256-8356998"->{
  Cell[153427, 4175, 355, 6, 70, "Print",
   CellTags->"Info3518795256-8356998"]},
 "Info3518795257-7571050"->{
  Cell[164586, 4463, 597, 9, 70, "Print",
   CellTags->"Info3518795257-7571050"]},
 "Info3518795257-1422214"->{
  Cell[172735, 4663, 575, 9, 70, "Print",
   CellTags->"Info3518795257-1422214"]},
 "Info3518795257-2855598"->{
  Cell[178838, 4812, 376, 6, 70, "Print",
   CellTags->"Info3518795257-2855598"]},
 "Info3518795293-9802361"->{
  Cell[401699, 8994, 282, 5, 44, "Print",
   CellTags->"Info3518795293-9802361"]},
 "Info3518795293-4276075"->{
  Cell[402210, 9007, 289, 5, 44, "Print",
   CellTags->"Info3518795293-4276075"]},
 "Info3518795294-6540251"->{
  Cell[402726, 9020, 315, 5, 67, "Print",
   CellTags->"Info3518795294-6540251"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3518795256-8356998", 521518, 11524},
 {"Info3518795257-7571050", 521630, 11527},
 {"Info3518795257-1422214", 521742, 11530},
 {"Info3518795257-2855598", 521854, 11533},
 {"Info3518795293-9802361", 521966, 11536},
 {"Info3518795293-4276075", 522078, 11539},
 {"Info3518795294-6540251", 522190, 11542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 460, 9, 77, "Subtitle"],
Cell[CellGroupData[{
Cell[1052, 35, 172, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[1249, 41, 157, 2, 36, "Subsection"],
Cell[1409, 45, 1360, 21, 83, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2806, 71, 105, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[2936, 76, 617, 8, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[3556, 86, 647, 11, 47, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[4218, 100, 542, 7, 26, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[4797, 112, 160, 2, 36, "Subsection"],
Cell[4960, 116, 552, 11, 83, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5561, 133, 204, 3, 71, "Section"],
Cell[CellGroupData[{
Cell[5790, 140, 204, 3, 36, "Subsection"],
Cell[5997, 145, 337, 4, 29, "Text"],
Cell[6337, 151, 500, 9, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6874, 165, 203, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[7102, 172, 265, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[7370, 180, 465, 10, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[7872, 195, 219, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8094, 200, 306, 7, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8449, 213, 110, 1, 36, "Subsection"],
Cell[8562, 216, 518, 9, 47, "Text"],
Cell[9083, 227, 279, 7, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9399, 239, 205, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[9629, 246, 297, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[9929, 252, 302, 6, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[10268, 263, 242, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[10513, 270, 447, 7, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11009, 283, 203, 3, 36, "Subsection"],
Cell[11215, 288, 417, 7, 29, "Text"],
Cell[11635, 297, 2734, 79, 155, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14418, 382, 300, 4, 41, "Section"],
Cell[CellGroupData[{
Cell[14743, 390, 99, 1, 36, "Subsection"],
Cell[14845, 393, 339, 7, 65, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15221, 405, 107, 1, 36, "Subsection"],
Cell[15331, 408, 603, 14, 54, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15971, 427, 109, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[16105, 432, 210, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[16318, 437, 785, 22, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[17140, 464, 184, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[17327, 469, 1448, 32, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[18812, 506, 177, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[18992, 511, 1658, 35, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[20687, 551, 203, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[20893, 556, 1507, 32, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22449, 594, 151, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[22625, 600, 136, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[22786, 606, 236, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[23025, 611, 981, 25, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[24043, 641, 241, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24287, 647, 3638, 71, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[27962, 723, 168, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[28133, 728, 781, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28963, 751, 143, 2, 27, "Subsubsection"],
Cell[29109, 755, 1482, 37, 132, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30640, 798, 95, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[30760, 803, 177, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[30962, 809, 236, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[31201, 814, 1885, 52, 232, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[33123, 871, 145, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[33271, 875, 6793, 155, 552, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40113, 1036, 229, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[40367, 1043, 222, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[40592, 1048, 748, 14, 83, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41343, 1064, 244, 6, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[41624, 1075, 193, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[41820, 1080, 3260, 82, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[45117, 1167, 306, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[45426, 1173, 1256, 29, 98, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[46719, 1207, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[46891, 1212, 1576, 38, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[48504, 1255, 223, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[48730, 1260, 1087, 28, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49866, 1294, 138, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[50029, 1300, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[50203, 1305, 412, 9, 65, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[50652, 1319, 258, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[50913, 1324, 322, 9, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[51250, 1336, 245, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51498, 1341, 156, 4, 31, "Input"],
Cell[51657, 1347, 11134, 297, 652, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[CellGroupData[{
Cell[62816, 1648, 170, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[62989, 1652, 11554, 311, 652, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74604, 1970, 260, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[74889, 1977, 174, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[75088, 1983, 143, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[75234, 1987, 1579, 45, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[76850, 2037, 283, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[77136, 2043, 2093, 57, 76, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79278, 2106, 151, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[79454, 2112, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[79628, 2117, 443, 11, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[80108, 2133, 180, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[80291, 2138, 1927, 57, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82279, 2202, 153, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[82457, 2208, 205, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[82687, 2215, 225, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[82915, 2220, 890, 21, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[83842, 2246, 178, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[84023, 2251, 2028, 60, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[86088, 2316, 181, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[86272, 2321, 1420, 43, 76, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87741, 2370, 169, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[87935, 2376, 193, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[88131, 2380, 2602, 58, 172, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[90770, 2443, 220, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[90993, 2448, 2004, 35, 172, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93046, 2489, 183, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[93254, 2495, 201, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[93458, 2500, 1413, 28, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[94886, 2531, 682, 18, 112, "Input"],
Cell[CellGroupData[{
Cell[95593, 2553, 185, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[95781, 2558, 1339, 29, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97181, 2594, 164, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[97370, 2600, 153, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[97548, 2606, 196, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[97747, 2611, 683, 15, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[98433, 2628, 790, 19, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[99260, 2652, 187, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[99450, 2657, 400, 10, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99911, 2674, 99, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[100035, 2679, 102, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[100162, 2684, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[100334, 2689, 1357, 44, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[101694, 2735, 727, 20, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[102458, 2760, 204, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[102665, 2765, 2334, 69, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[105002, 2836, 2269, 66, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107320, 2908, 163, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[107508, 2914, 221, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[107732, 2919, 758, 17, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[108493, 2938, 2048, 59, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110602, 3004, 100, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[110727, 3009, 106, 1, 27, "Subsubsection"],
Cell[110836, 3012, 549, 11, 83, "Text"],
Cell[111388, 3025, 407, 8, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111832, 3038, 213, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[112070, 3045, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[112246, 3050, 1096, 25, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[113379, 3080, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[113555, 3085, 847, 20, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[114439, 3110, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[114613, 3115, 1589, 50, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[116239, 3170, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[116415, 3175, 853, 23, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[117305, 3203, 178, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[117486, 3208, 1151, 32, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[118674, 3245, 180, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[118857, 3250, 1146, 31, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[120040, 3286, 186, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10005.}],
Cell[120229, 3291, 1063, 31, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10005.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[121329, 3327, 198, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}],
Cell[121530, 3332, 843, 22, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[122410, 3359, 172, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10007.}],
Cell[122585, 3364, 977, 24, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10007.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[123599, 3393, 251, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}],
Cell[123853, 3399, 752, 16, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[124642, 3420, 196, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10008.}],
Cell[124841, 3425, 868, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10008.}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125782, 3452, 224, 3, 41, "Section"],
Cell[CellGroupData[{
Cell[126031, 3459, 203, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[126259, 3466, 125, 1, 27, "Subsubsection"],
Cell[126387, 3469, 3664, 115, 272, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[130088, 3589, 174, 2, 27, "Subsubsection"],
Cell[130265, 3593, 2286, 42, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132588, 3640, 105, 1, 27, "Subsubsection"],
Cell[132696, 3643, 803, 19, 92, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133548, 3668, 204, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[133777, 3675, 186, 2, 27, "Subsubsection"],
Cell[133966, 3679, 270, 8, 31, "Input"],
Cell[134239, 3689, 4565, 127, 272, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138841, 3821, 272, 5, 27, "Subsubsection"],
Cell[139116, 3828, 1432, 29, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140585, 3862, 103, 1, 27, "Subsubsection"],
Cell[140691, 3865, 863, 21, 92, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141603, 3892, 234, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[141862, 3899, 110, 1, 27, "Subsubsection"],
Cell[141975, 3902, 3259, 53, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145271, 3960, 103, 1, 27, "Subsubsection"],
Cell[145377, 3963, 2578, 82, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147992, 4050, 100, 1, 27, "Subsubsection"],
Cell[148095, 4053, 4599, 93, 192, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[152755, 4153, 160, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[152940, 4159, 207, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[153172, 4166, 106, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[153303, 4171, 121, 2, 31, "Input"],
Cell[153427, 4175, 355, 6, 70, "Print",
 CellTags->"Info3518795256-8356998"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153831, 4187, 108, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[153964, 4192, 176, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[154143, 4197, 467, 11, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[154647, 4213, 250, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[154900, 4219, 2915, 61, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[157864, 4286, 101, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[157990, 4291, 220, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[158213, 4296, 2045, 47, 192, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[160295, 4348, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[160467, 4353, 1302, 31, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[161806, 4389, 223, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[162032, 4394, 2060, 47, 252, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164153, 4448, 157, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[164335, 4454, 104, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[164464, 4459, 119, 2, 31, "Input"],
Cell[164586, 4463, 597, 9, 70, "Print",
 CellTags->"Info3518795257-7571050"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[165232, 4478, 107, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[165364, 4483, 278, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[165645, 4489, 931, 21, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[166613, 4515, 381, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[166997, 4522, 5133, 118, 347, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[172191, 4647, 259, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[172475, 4654, 109, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[172609, 4659, 123, 2, 31, "Input"],
Cell[172735, 4663, 575, 9, 70, "Print",
 CellTags->"Info3518795257-1422214"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173359, 4678, 107, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[173491, 4683, 305, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[173799, 4689, 611, 15, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[174447, 4709, 182, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[174632, 4714, 3756, 77, 252, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178449, 4798, 104, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[178578, 4803, 109, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[178712, 4808, 123, 2, 31, "Input"],
Cell[178838, 4812, 376, 6, 70, "Print",
 CellTags->"Info3518795257-2855598"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179263, 4824, 112, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[179400, 4829, 232, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[179635, 4834, 1026, 22, 192, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[180722, 4863, 264, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[181011, 4870, 167, 2, 27, "Subsubsection"],
Cell[181181, 4874, 1848, 32, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[183066, 4911, 115, 1, 27, "Subsubsection"],
Cell[183184, 4914, 795, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[184016, 4937, 109, 1, 27, "Subsubsection"],
Cell[184128, 4940, 2007, 34, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[186172, 4979, 108, 1, 27, "Subsubsection"],
Cell[186283, 4982, 436, 9, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186756, 4996, 166, 2, 27, "Subsubsection"],
Cell[186925, 5000, 1387, 37, 112, "Input"],
Cell[188315, 5039, 1482, 38, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189834, 5082, 96, 1, 27, "Subsubsection"],
Cell[189933, 5085, 864, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190846, 5108, 113, 1, 36, "Subsection"],
Cell[190962, 5111, 574, 11, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191573, 5127, 118, 1, 36, "Subsection"],
Cell[191694, 5130, 281, 7, 52, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[192024, 5143, 139, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[192188, 5149, 235, 3, 36, "Subsection"],
Cell[192426, 5154, 1414, 22, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193877, 5181, 138, 2, 36, "Subsection"],
Cell[194018, 5185, 269, 3, 29, "Text"],
Cell[CellGroupData[{
Cell[194312, 5192, 1917, 33, 132, "Input"],
Cell[196232, 5227, 9034, 163, 70, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[205327, 5397, 132, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[205484, 5403, 99, 1, 36, "Subsection"],
Cell[205586, 5406, 1611, 34, 72, "Input"],
Cell[207200, 5442, 1594, 34, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[208831, 5481, 155, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[209011, 5487, 197, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[209211, 5492, 1874, 38, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[211088, 5532, 1648, 35, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[212739, 5569, 4305, 99, 292, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[217081, 5673, 204, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[217288, 5678, 1662, 35, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[218953, 5715, 1546, 34, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[220502, 5751, 4251, 98, 292, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[224802, 5855, 153, 2, 36, "Subsection"],
Cell[224958, 5859, 1711, 36, 72, "Input"],
Cell[226672, 5897, 1694, 35, 92, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[228415, 5938, 94, 1, 41, "Section"],
Cell[CellGroupData[{
Cell[228534, 5943, 168, 2, 36, "Subsection"],
Cell[228705, 5947, 1095, 29, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[229837, 5981, 160, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[230022, 5987, 616, 9, 31, "Input"],
Cell[230641, 5998, 10982, 194, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[241672, 6198, 161, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[241858, 6204, 214, 3, 27, "Subsubsection"],
Cell[242075, 6209, 1631, 41, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243743, 6255, 115, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[243883, 6260, 3970, 55, 31, "Input"],
Cell[247856, 6317, 142721, 2415, 70, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[390650, 8740, 160, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[390835, 8746, 352, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[391212, 8755, 2373, 45, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[393588, 8802, 2457, 50, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[396094, 8858, 160, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[396279, 8864, 113, 1, 27, "Subsubsection"],
Cell[396395, 8867, 516, 11, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396948, 8883, 113, 1, 27, "Subsubsection"],
Cell[397064, 8886, 3967, 86, 472, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[401080, 8978, 260, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[401365, 8985, 104, 1, 27, "Subsubsection"],
Cell[401472, 8988, 224, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[401699, 8994, 282, 5, 44, "Print",
 CellTags->"Info3518795293-9802361"],
Cell[401984, 9001, 223, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[402210, 9007, 289, 5, 44, "Print",
 CellTags->"Info3518795293-4276075"],
Cell[402502, 9014, 221, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[402726, 9020, 315, 5, 67, "Print",
 CellTags->"Info3518795294-6540251"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403078, 9030, 98, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[403201, 9035, 172, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[403376, 9039, 1913, 29, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[405292, 9070, 64322, 1137, 390, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[469651, 10212, 229, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[469883, 10217, 2195, 34, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[472115, 10256, 305, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[472423, 10262, 750, 23, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[473176, 10287, 1789, 29, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[475038, 10324, 178, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[475241, 10330, 108, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[475374, 10335, 178, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[475577, 10341, 416, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[475996, 10349, 922, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[476955, 10371, 418, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[477376, 10379, 1123, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[478536, 10403, 421, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[478960, 10411, 940, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[479949, 10434, 152, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[480126, 10440, 383, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[480512, 10447, 949, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[481510, 10471, 215, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[481750, 10478, 329, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[482082, 10486, 358, 8, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[482477, 10499, 314, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[482794, 10507, 2122, 42, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[484953, 10554, 443, 7, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[485399, 10563, 2494, 51, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[487930, 10619, 161, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[488094, 10623, 2297, 50, 312, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[490428, 10678, 161, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[490592, 10682, 910, 18, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[491539, 10705, 214, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[491756, 10710, 1136, 29, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[492953, 10746, 98, 1, 36, "Subsection"],
Cell[493054, 10749, 882, 19, 52, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[493985, 10774, 98, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[494108, 10779, 108, 1, 36, "Subsection"],
Cell[494219, 10782, 396, 8, 65, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[494652, 10795, 352, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[495029, 10804, 2220, 43, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[497252, 10849, 2457, 50, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[499758, 10905, 169, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[499952, 10911, 103, 1, 27, "Subsubsection"],
Cell[500058, 10914, 622, 16, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[500717, 10935, 108, 1, 27, "Subsubsection"],
Cell[500828, 10938, 991, 30, 112, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[501868, 10974, 107, 1, 36, "Subsection"],
Cell[501978, 10977, 809, 23, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[502824, 11005, 105, 1, 36, "Subsection"],
Cell[502932, 11008, 486, 15, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[503455, 11028, 103, 1, 36, "Subsection"],
Cell[503561, 11031, 2054, 52, 119, "Input"],
Cell[505618, 11085, 2030, 52, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[507685, 11142, 102, 1, 36, "Subsection"],
Cell[507790, 11145, 2328, 58, 140, "Input"],
Cell[510121, 11205, 2332, 58, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[512490, 11268, 96, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[512611, 11273, 161, 2, 27, "Subsubsection"],
Cell[512775, 11277, 1190, 27, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[514002, 11309, 114, 1, 27, "Subsubsection"],
Cell[514119, 11312, 926, 23, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[515082, 11340, 111, 1, 27, "Subsubsection"],
Cell[515196, 11343, 1350, 34, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[516583, 11382, 104, 1, 27, "Subsubsection"],
Cell[516690, 11385, 1415, 39, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[518142, 11429, 156, 2, 27, "Subsubsection"],
Cell[518301, 11433, 1465, 40, 96, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[519815, 11479, 94, 1, 36, "Subsection"],
Cell[519912, 11482, 1223, 25, 192, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
