(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    588660,      13300]
NotebookOptionsPosition[    554886,      12291]
NotebookOutlinePosition[    556361,      12338]
CellTagsIndexPosition[    556009,      12327]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\

iLCGT Type-A VIS Rigid-Body Model
(More Precise in High Frequencies)\
\>", "Subtitle",
 CellChangeTimes->{{3.5109088633079133`*^9, 3.510908886523241*^9}, {
   3.5109089295327015`*^9, 3.5109089606324797`*^9}, {3.510998012935999*^9, 
   3.510998040953648*^9}, {3.511147199138874*^9, 3.511147201837679*^9}, 
   3.5111528655524273`*^9, {3.5112140422561007`*^9, 3.511214046727357*^9}, {
   3.511333214700381*^9, 3.5113332166191845`*^9}, {3.5113333850886836`*^9, 
   3.511333385931085*^9}, {3.518816778493554*^9, 3.51881679119328*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Section",
 CellChangeTimes->{{3.5054543012647257`*^9, 3.505454323450515*^9}, {
   3.510907714373198*^9, 3.5109077167963367`*^9}, 3.510908178125723*^9}],

Cell[CellGroupData[{

Cell["About This Model", "Subsection",
 CellChangeTimes->{{3.510394061790189*^9, 3.5103940822418246`*^9}, {
  3.510907707872826*^9, 3.5109077115670376`*^9}}],

Cell["\<\
A 3-D rigid-body model of type-A vibration isolation system for iLCGT.
* Full system with a pre-isolator stage, SAS and suspension system (payload)
* The saturation of GASF in high freq is taken into account.
* Inner resonace of GASF and bounce of the maraging wires are taken into \
account.

\
\>", "Text",
 CellChangeTimes->{{3.505454452255293*^9, 3.505454488921332*^9}, {
   3.5077129980500813`*^9, 3.5077130433695107`*^9}, {3.5078876676897573`*^9, 
   3.5078878698873224`*^9}, {3.507891500540996*^9, 3.5078915759671288`*^9}, {
   3.508056919436692*^9, 3.508056920357094*^9}, {3.510355123371209*^9, 
   3.51035514664645*^9}, {3.5103918876678514`*^9, 3.5103918944872417`*^9}, {
   3.510623942883439*^9, 3.510624004228547*^9}, {3.510624128264365*^9, 
   3.5106243303003197`*^9}, {3.510907735689417*^9, 3.510907763414003*^9}, {
   3.510909653179636*^9, 3.510909653834837*^9}, {3.5109584516502295`*^9, 
   3.5109584654874535`*^9}, {3.5109980702504997`*^9, 3.510998172181079*^9}, {
   3.5111293295678463`*^9, 3.5111293498580065`*^9}, {3.511129506365958*^9, 
   3.511129532635461*^9}, {3.511214054289789*^9, 3.511214075686013*^9}, {
   3.5127249187349544`*^9, 3.5127249762990556`*^9}, {3.512725013333521*^9, 
   3.5127252632303596`*^9}, 3.5145090605310373`*^9, {3.518816798807716*^9, 
   3.5188168635424185`*^9}, {3.518817065785986*^9, 3.5188171075083723`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version History", "Subsection",
 CellChangeTimes->{{3.5109077795259247`*^9, 3.510907781974065*^9}}],

Cell[CellGroupData[{

Cell["05/16/11 - v1.1 release.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5188171592773333`*^9, 3.5188171950453796`*^9}}],

Cell["Eddy current damping is taken into account.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5188171797825065`*^9, 3.5188171950453796`*^9}}]
}, Closed]],

Cell["05/13/11 - First release.", "Text",
 CellChangeTimes->{{3.510907788475436*^9, 3.510907825669564*^9}, {
   3.5109981953783193`*^9, 3.5109981973127227`*^9}, 3.5111293590005293`*^9, {
   3.511301582319485*^9, 3.5113015951115074`*^9}, {3.5127252375215144`*^9, 
   3.512725238395116*^9}, {3.512725273198777*^9, 3.5127252867084007`*^9}, {
   3.518817137719101*^9, 3.518817167054778*^9}, 3.5188171991886168`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordinate System", "Subsection",
 CellChangeTimes->{{3.5103935324149256`*^9, 3.510393535246088*^9}, {
  3.5103940971398506`*^9, 3.5103941199158907`*^9}}],

Cell["\<\
(VIRGO's Reference)
X-axis:  Transversal, Y-axis: Vertical, Z-axis: Longitudinal (Beam-axis)
Pitch: Rotation around x-axis, Yaw: Rotation around y-axis, Roll: Rotation \
around z-axis
\
\>", "Text",
 CellChangeTimes->{{3.5103935528940973`*^9, 3.510393696350746*^9}, {
   3.510394123098296*^9, 3.5103943553983045`*^9}, {3.510395802459265*^9, 
   3.510395835515723*^9}, {3.510624429500894*^9, 3.510624435179304*^9}, {
   3.5109079621453695`*^9, 3.510908048918333*^9}, {3.5109081088107586`*^9, 
   3.5109081217995014`*^9}, 3.512725284446397*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preliminaries", "Section",
 CellChangeTimes->{{3.509358217720311*^9, 3.5093582194831142`*^9}, {
  3.509358283131226*^9, 3.5093582840048275`*^9}, {3.5109081602447004`*^9, 
  3.5109081665040584`*^9}}],

Cell[CellGroupData[{

Cell["Clear Values", "Subsection",
 CellChangeTimes->{{3.5106377661991253`*^9, 3.5106377726731367`*^9}, {
  3.510908300193705*^9, 3.510908303030867*^9}, {3.510908796062067*^9, 
  3.5109088095318375`*^9}}],

Cell["Clear values and definitions of all the symbols.", "Text",
 CellChangeTimes->{{3.5109082594663754`*^9, 3.510908268789909*^9}, {
  3.5109083050389824`*^9, 3.5109083170736704`*^9}, {3.510908356790942*^9, 
  3.5109083909098935`*^9}, {3.5109084458170342`*^9, 3.510908446235058*^9}, {
  3.5112987930589027`*^9, 3.5112987971351357`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], " ", "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5101923438572636`*^9, 3.510192346852469*^9}, {
   3.5105415211971025`*^9, 3.5105415220863047`*^9}, {3.5106246850761433`*^9, 
   3.5106246954033613`*^9}, {3.5106377478222933`*^9, 3.510637755653507*^9}, 
   3.5109583818557067`*^9, {3.511298860191743*^9, 3.511298870315322*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alart Switch OFF", "Subsection",
 CellChangeTimes->{{3.5093582266123266`*^9, 3.509358235441942*^9}, {
  3.510908785327453*^9, 3.510908786812538*^9}, {3.512712672876814*^9, 
  3.51271269337525*^9}}],

Cell[CellGroupData[{

Cell["\<\
Disable spell-checking. There are so many variables with similar names that \
it' s useless.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109082158268795`*^9, 3.5109082167409315`*^9}, 
   3.512712667838005*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{
    RowBox[{"General", "::", "spell"}], ",", 
    RowBox[{"General", "::", "spell1"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5106245299962707`*^9, 3.510624543927095*^9}, {
   3.5106247451362486`*^9, 3.5106247454950495`*^9}, {3.5106377976799808`*^9, 
   3.5106377985379825`*^9}, 3.510958382947708*^9, 3.512712667838005*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disable the LinerSolve alart.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511418292811921*^9, 3.5114183319367895`*^9}, {
  3.5114185384811525`*^9, 3.5114185527395773`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"LinearSolve", "::", "luc"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5110035674345737`*^9, 3.5110035736277847`*^9}, {
  3.5114183319367895`*^9, 3.511418334307994*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Kernel Directory", "Subsection",
 CellChangeTimes->{{3.5101923522344785`*^9, 3.510192358162489*^9}}],

Cell["\<\
Set the current working directory to the directory where this notebook exists.
Imported data and packages should be placed in this directory, or the parent \
directory.\
\>", "Text",
 CellChangeTimes->{{3.5109084715615067`*^9, 3.510908486584366*^9}, {
   3.510908577266553*^9, 3.510908645640464*^9}, {3.5112989682869253`*^9, 
   3.5112990157796416`*^9}, {3.5113016406323876`*^9, 3.5113016472467995`*^9}, 
   3.5114313091697197`*^9, 3.5114315039128633`*^9, {3.512725476732334*^9, 
   3.5127254897115574`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.510192369066908*^9, 3.510958384320511*^9, 
  3.5114313091697197`*^9, 3.5114315039128633`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import Packages", "Subsection",
 CellChangeTimes->{{3.509358549500699*^9, 3.5093585508579016`*^9}, {
  3.510908771531664*^9, 3.510908776462946*^9}, {3.511431144979431*^9, 
  3.5114311459622326`*^9}}],

Cell[CellGroupData[{

Cell["Standard package for use in plotting transfer functions.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109086828285904`*^9, 3.510908700501601*^9}, {
  3.5109087550517216`*^9, 3.5109087629341726`*^9}, {3.5114311527794447`*^9, 
  3.511431169050273*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<PlotLegends`\>\""}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.5093585572227125`*^9, 3.5109583868009152`*^9, 3.5114311527794447`*^9, {
   3.5114314680016003`*^9, 3.5114314701388035`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Manual package for modeling and simulating vibration isolation systems.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5114311609694595`*^9, 3.511431194384718*^9}, 
   3.511431248501213*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "\"\<../visUtil.m\>\""}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5114311961163206`*^9, 3.5114312118099484`*^9}, {
   3.5114312446636057`*^9, 3.511431248501213*^9}, {3.51143132645455*^9, 
   3.511431328217353*^9}, {3.5114314592187843`*^9, 3.51143146218279*^9}, {
   3.511432205581296*^9, 3.5114322437545633`*^9}, 3.5126997613310375`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unit System", "Subsection",
 CellChangeTimes->{{3.507762673125991*^9, 3.5077626748989697`*^9}, {
  3.507887916125967*^9, 3.5078879248934684`*^9}, {3.510909011354381*^9, 
  3.5109090133324947`*^9}}],

Cell["\<\
MKS unit system is set as defalut. If you want to use another unit system or \
add units, please edit this subsection.\
\>", "Text",
 CellChangeTimes->{{3.510909029719432*^9, 3.5109090347067165`*^9}, {
  3.5112991343644247`*^9, 3.511299152603468*^9}, {3.5112992219044313`*^9, 
  3.5112992467198505`*^9}, {3.5112993190699887`*^9, 3.5112993260563884`*^9}, {
  3.5112996874180574`*^9, 3.5112997335146937`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kg", "=", "1.0"}], ";", 
   RowBox[{"meter", "=", "1.0"}], ";", 
   RowBox[{"rad", "=", "1.0"}], ";", 
   RowBox[{"sec", "=", "1.0"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Basical", " ", "Set"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"cm", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]], "meter"}]}], ";", 
   RowBox[{"mm", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "meter"}]}], ";", " ", 
   RowBox[{"km", "=", 
    RowBox[{
     SuperscriptBox["10", "3"], "meter"}]}], ";"}], 
  RowBox[{"(*", "Length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gram", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "kg"}]}], ";", " ", 
   RowBox[{"mg", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "6"}]], "kg"}]}], ";"}], 
  RowBox[{"(*", "Mass", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"deg", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"N", "[", "Pi", "]"}], "/", "180"}], ")"}], "rad"}]}], ";", 
   " ", 
   RowBox[{"mrad", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "rad"}]}], ";"}], 
  RowBox[{"(*", "Angle", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hertz", "=", 
    RowBox[{"1", "/", "sec"}]}], ";", 
   RowBox[{"mHz", "=", 
    RowBox[{
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], "hertz"}]}], ";", " ", 
   RowBox[{"kHz", "=", 
    RowBox[{
     SuperscriptBox["10", "3"], "hertz"}]}], ";"}], 
  RowBox[{"(*", "Frequency", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"newton", "=", 
    RowBox[{"kg", " ", 
     RowBox[{"meter", "/", 
      SuperscriptBox["sec", "2"]}]}]}], ";", 
   RowBox[{"pascal", "=", 
    RowBox[{"newton", "/", 
     SuperscriptBox["meter", "2"]}]}], ";"}], 
  RowBox[{"(*", "Force", "*)"}]}], "\n"}], "Input",
 CellChangeTimes->{{3.505459898591352*^9, 3.5054599656528482`*^9}, {
   3.505460214618761*^9, 3.505460246823139*^9}, {3.505460353839837*^9, 
   3.505460386329871*^9}, {3.5054609432258244`*^9, 3.505460943823134*^9}, {
   3.507717502489213*^9, 3.50771751561602*^9}, {3.507763954546257*^9, 
   3.50776398513273*^9}, {3.507887947930786*^9, 3.5078880664505653`*^9}, {
   3.507888099557459*^9, 3.50788814661615*^9}, {3.507888389647051*^9, 
   3.5078883993246045`*^9}, {3.507888436328721*^9, 3.507888448082393*^9}, 
   3.5109090416871157`*^9, 3.5109090778881865`*^9, {3.510909120506624*^9, 
   3.5109091273490157`*^9}, {3.5109092151620665`*^9, 3.510909215271267*^9}, {
   3.511300808916927*^9, 3.511300836123375*^9}, {3.511300869803834*^9, 
   3.5113008723622384`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Constant Values", "Section",
 CellChangeTimes->{{3.51142744973974*^9, 3.5114274556677504`*^9}, {
  3.511427538098295*^9, 3.5114275409375*^9}, {3.5126981805490613`*^9, 
  3.512698220251131*^9}, {3.5126995238362207`*^9, 3.5126995252714233`*^9}, {
  3.512709794472556*^9, 3.5127098002289667`*^9}}],

Cell[CellGroupData[{

Cell["Version", "Subsection",
 CellChangeTimes->{{3.5127256954603186`*^9, 3.5127256967083206`*^9}}],

Cell["\<\
Mass & MOI: Proposed by R. Desalvo in 04/26/11 (TM 10-kg version, but reduced \
IRM [60 kg] to achieve 300 kg payload)
Wire Specification: Proposed by E. Majorana in 04/18/11 (TM 10-kg version)
\
\>", "Text",
 CellChangeTimes->{{3.5127257083459415`*^9, 3.5127258858898535`*^9}, {
  3.512772484472748*^9, 3.5127726066521626`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Physical Constant", "Subsection",
 CellChangeTimes->{{3.5126995351930404`*^9, 3.512699537813845*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "=", 
    RowBox[{"9.81", " ", 
     RowBox[{"meter", "/", 
      SuperscriptBox["sec", "2"]}]}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"local", " ", "gravity", " ", "constant"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.507762704553597*^9, 3.5077627272070923`*^9}, {
   3.507763249921364*^9, 3.507763251940638*^9}, 3.507765884859458*^9, {
   3.5078741427757235`*^9, 3.5078741430097237`*^9}, {3.5078882875472107`*^9, 
   3.5078883798324895`*^9}, 3.510910789651633*^9, {3.5127255934829397`*^9, 
   3.512725594387741*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Material Property", "Subsection",
 CellChangeTimes->{{3.5078885954778233`*^9, 3.5078886008591313`*^9}}],

Cell[CellGroupData[{

Cell["Usage note for symbols", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127058900508986`*^9, 3.5127058993329153`*^9}, {
  3.512706096907262*^9, 3.512706100963269*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "::", "usage"}], "=", 
   "\"\<rho['mat'] is volume density of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"young", "::", "usage"}], "=", 
   "\"\<young['mat'] is Young's modulus of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "::", "usage"}], "=", 
   "\"\<phi['mat'] is loss angle of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"poisson", "::", "usage"}], "=", 
   "\"\<poisson['mat'] is Poisson ratio of the material.\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127059638078284`*^9, 3.512706105643277*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Maraging Steel (MS)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5103965360817537`*^9, 3.510396544037768*^9}, 
   3.5127059285829663`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"8.0", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", 
  RowBox[{
   RowBox[{"young", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"195", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<MS\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<MS\>\"", "]"}], "=", "0.9"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.507889441421377*^9}, {3.5078960325775614`*^9, 
   3.5078960964908733`*^9}, {3.5103965183445225`*^9, 3.510396588887847*^9}, {
   3.510909272975768*^9, 3.510909298450613*^9}, 3.510910792100837*^9, {
   3.510917538160895*^9, 3.5109175628401384`*^9}, {3.5110012657717195`*^9, 
   3.5110013428284593`*^9}, {3.5113005011767845`*^9, 
   3.5113005170108128`*^9}, {3.511300658220662*^9, 3.511300688422315*^9}, {
   3.512355711763343*^9, 3.512355728764315*^9}, {3.512699581587522*^9, 
   3.5126995827419243`*^9}, 3.5127059285829663`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tungsten (W)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5103965944882565`*^9, 3.5103965978578625`*^9}, 
   3.512705931312971*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"19.25", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"young", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"411", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<W\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<W\>\"", "]"}], "=", "0.3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.5078894378489714`*^9}, {3.507896109594897*^9, 
   3.507896113026903*^9}, {3.5103966082162805`*^9, 3.5103966252515106`*^9}, 
   3.5107455826730013`*^9, {3.5109092790285788`*^9, 3.5109092799021807`*^9}, 
   3.510910793146039*^9, {3.510917571108153*^9, 3.510917577987765*^9}, {
   3.5110013469000664`*^9, 3.5110013527812767`*^9}, {3.5110014676084857`*^9, 
   3.5110014906029263`*^9}, {3.5113002673217673`*^9, 
   3.5113002845129976`*^9}, {3.5113004092804227`*^9, 3.511300412774829*^9}, {
   3.511300542797658*^9, 3.5113005435620594`*^9}, {3.5113006258066044`*^9, 
   3.511300626805006*^9}, 3.51130069099632*^9, {3.512355660889433*^9, 
   3.5123556611114454`*^9}, {3.512699585487529*^9, 3.5126995863299303`*^9}, 
   3.512705931312971*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["C-70 Steel (C70)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5107455881642113`*^9, 3.5107455934682207`*^9}, 
   3.510910365408888*^9, 3.512705934167776*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rho", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"7.8", 
    RowBox[{"gram", "/", 
     SuperscriptBox["cm", "3"]}]}]}], ";", " ", 
  RowBox[{
   RowBox[{"young", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"200", " ", 
    SuperscriptBox["10", "9"], " ", "pascal"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"phi", "[", "\"\<C70\>\"", "]"}], "=", 
   RowBox[{"1.0", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";", 
  RowBox[{
   RowBox[{"poisson", "[", "\"\<C70\>\"", "]"}], "=", "0.3"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5078886139238787`*^9, 3.507888680536689*^9}, {
   3.507888827152075*^9, 3.5078888913997498`*^9}, {3.5078889230655603`*^9, 
   3.507889061793495*^9}, {3.507889125559222*^9, 3.5078891537796717`*^9}, {
   3.507889406024915*^9, 3.5078894378489714`*^9}, {3.507896109594897*^9, 
   3.507896113026903*^9}, {3.5103966082162805`*^9, 3.5103966252515106`*^9}, {
   3.5107455826730013`*^9, 3.5107456317818875`*^9}, {3.5109092830533857`*^9, 
   3.5109092838801875`*^9}, 3.510910794362841*^9, {3.510917573572957*^9, 
   3.510917582168572*^9}, {3.5110014921005287`*^9, 3.5110015006025434`*^9}, {
   3.5113005549188795`*^9, 3.511300557196483*^9}, {3.5113006740078897`*^9, 
   3.5113006841791077`*^9}, {3.512355689126048*^9, 3.512355699808659*^9}, {
   3.512699588825935*^9, 3.512699589590336*^9}, 3.512705934167776*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bodies", "Subsection",
 CellChangeTimes->{{3.5106251018152747`*^9, 3.5106251044516797`*^9}, {
  3.5109104340490084`*^9, 3.5109104353594103`*^9}}],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.511311704314874*^9, 3.5113117105236855`*^9}, 
   3.5127091783182745`*^9}],

Cell[CellGroupData[{

Cell["Usage note for symbols.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113114603616457`*^9, 3.5113114747136707`*^9}, {
   3.511311505554925*^9, 3.511311549718603*^9}, 3.5126982410615673`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mass", "::", "usage"}], "=", "\"\<mass of bodies\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moix", "::", "usage"}], "=", 
   "\"\<moment of inertia around x-axis (pitch)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moiy", "::", "usage"}], "=", 
   "\"\<moment of inertia around y-axis (yaw)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"moiz", "::", "usage"}], "=", 
   "\"\<moment of inertia around z-axis (roll)\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113096085915933`*^9, 3.5113098531844225`*^9}, {
   3.511309893479294*^9, 3.5113099178465366`*^9}, 3.511309950247793*^9, {
   3.511311488410495*^9, 3.511311526942563*^9}, 3.5113153674308243`*^9, {
   3.5126982410615673`*^9, 3.5126983525861635`*^9}, {3.512725606945763*^9, 
   3.5127256082405653`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511307444101391*^9, 3.511307473382642*^9}, {
  3.511308315877722*^9, 3.511308321212931*^9}, {3.511311718276899*^9, 
  3.5113117198681016`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "      ", 
   RowBox[{
   "F0", ",", "  ", "F1", ",", "  ", "F2", ",", "  ", "F3", ",", "  ", "F4", 
    ",", "  ", "IM", ",", "  ", "IRM", ",", "  ", "TM", ",", "  ", "RM", ",", 
    "  ", "MD"}], "   ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mass", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "544.", ",", "106.", ",", "89.4", ",", "86.5", ",", "83.7", ",", 
        "55.0", ",", "61.0", ",", "10.7", ",", "90.3", ",", "30.0"}], "}"}], 
      "kg"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moix", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "30.0", ",", "4.00", ",", "4.00", ",", "4.00", ",", "4.00", ",", 
        "0.80", ",", "2.80", ",", ".051", ",", "2.58", ",", "0.92"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiy", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "40.0", ",", "6.44", ",", "6.44", ",", "6.44", ",", "6.44", ",", 
        "1.88", ",", "5.85", ",", ".051", ",", "2.58", ",", "1.83"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiz", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "30.0", ",", "4.00", ",", "4.00", ",", "4.00", ",", "4.00", ",", 
        "1.22", ",", "3.60", ",", ".084", ",", "4.56", ",", "0.92"}], "}"}], 
      "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511304710127389*^9, 3.511304728535421*^9}, {
   3.5113047674418893`*^9, 3.5113048860488977`*^9}, {3.5113050074015107`*^9, 
   3.51130514904976*^9}, {3.5113051832138195`*^9, 3.51130538269137*^9}, {
   3.511305417479431*^9, 3.511305551904867*^9}, {3.5113058796614428`*^9, 
   3.511305880269844*^9}, {3.5113061359454927`*^9, 3.5113061641503425`*^9}, {
   3.511306624819152*^9, 3.5113066315271635`*^9}, 3.511307473382642*^9, {
   3.511308315877722*^9, 3.511308321212931*^9}, {3.511386760794197*^9, 
   3.511386828105047*^9}, {3.5113869415443287`*^9, 3.511386973617985*^9}, {
   3.5114939721454124`*^9, 3.511493984048234*^9}, {3.5114942197842493`*^9, 
   3.511494225041459*^9}, {3.51149502317006*^9, 3.5114950728873477`*^9}, {
   3.512355081541296*^9, 3.5123550980172386`*^9}, {3.5123562660702295`*^9, 
   3.512356447654548*^9}, {3.5126972323489933`*^9, 3.512697253565031*^9}, {
   3.5126973286319647`*^9, 3.5126973856968646`*^9}, {3.5126974251337337`*^9, 
   3.512697450421378*^9}, {3.512697521946704*^9, 3.512697534910327*^9}, {
   3.5126975666875825`*^9, 3.5126976978682127`*^9}, {3.512697732281873*^9, 
   3.512697844960871*^9}, {3.5126983687633915`*^9, 3.5126983919918327`*^9}, {
   3.5127063777233553`*^9, 3.51270638635017*^9}, {3.512711677657466*^9, 
   3.5127117195591393`*^9}, {3.5127117556108027`*^9, 
   3.5127119120322776`*^9}, {3.5127256372098165`*^9, 3.5127256429818263`*^9}, 
   3.512730602065339*^9, {3.512772450558288*^9, 3.5127724661115155`*^9}, {
   3.5128017081234455`*^9, 3.512801921656621*^9}, 3.5128020728052864`*^9, {
   3.514165185307804*^9, 3.5141652510775194`*^9}, {3.514165468120701*^9, 
   3.5141655106619754`*^9}, {3.51416578654846*^9, 3.5141657950816746`*^9}, {
   3.5141669029020205`*^9, 3.514166980980158*^9}, {3.514167018919424*^9, 
   3.514167243513019*^9}, {3.514167307972332*^9, 3.5141673132607417`*^9}, {
   3.514509115443134*^9, 3.514509152695999*^9}, {3.514509215439309*^9, 
   3.5145092517717733`*^9}, {3.5145096552664824`*^9, 3.5145096554068823`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Labels", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5127067034831276`*^9, 3.51270670477793*^9}, 
   3.512707796343047*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"b$F0", "=", "1"}], ";", 
  RowBox[{"b$F1", "=", "2"}], ";", 
  RowBox[{"b$F2", "=", "3"}], ";", 
  RowBox[{"b$F3", "=", "4"}], ";", 
  RowBox[{"b$F4", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b$IM", "=", "6"}], ";", 
  RowBox[{"b$IRM", "=", "7"}], ";", 
  RowBox[{"b$TM", "=", "8"}], ";", 
  RowBox[{"b$RM", "=", "9"}], ";", 
  RowBox[{"b$MD", "=", "10"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5127067095515385`*^9, 3.5127068375965633`*^9}, {
   3.512706877985034*^9, 3.512706889950255*^9}, 3.512707796343047*^9, {
   3.512725650142239*^9, 3.5127256522014427`*^9}, {3.5145092564049816`*^9, 
   3.5145092621925917`*^9}, 3.5145109542651634`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverted pendulum legs", "Subsubsection",
 CellChangeTimes->{{3.511307457985415*^9, 3.5113074775322495`*^9}, 
   3.5113117756693993`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"leg1", ",", " ", "leg2", ",", " ", "leg3"}], "        ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"massIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2.00", ",", "2.00", ",", "2.00"}], "}"}], "kg"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moixIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".042", ",", ".042", ",", ".042"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiyIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".005", ",", ".005", ",", ".005"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moizIP", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".042", ",", ".042", ",", ".042"}], "}"}], "kg", " ", 
      SuperscriptBox["meter", "2"]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5113056136653757`*^9, 3.511305645770232*^9}, {
   3.511305696844722*^9, 3.511305723442768*^9}, {3.5113058208025393`*^9, 
   3.5113058834990497`*^9}, {3.5113061673951483`*^9, 3.511306186473982*^9}, {
   3.5113066350371695`*^9, 3.511306643242784*^9}, 3.5113074775322495`*^9, 
   3.5113117756693993`*^9, {3.5127057880735197`*^9, 3.5127058217539787`*^9}, {
   3.512706159588172*^9, 3.5127061710385923`*^9}, {3.51270807138713*^9, 
   3.5127081551904774`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Subsubsection",
 CellChangeTimes->{{3.512079648782933*^9, 3.5120796575864363`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "         ", 
   RowBox[{
   "F0", ",", "  ", "F1", ",", "  ", "F2", ",", "  ", "F3", ",", "  ", "F4"}],
    "         ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"massKS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5.00", ",", "3.00", ",", "3.00", ",", "3.00", ",", "3.00"}], 
       "}"}], "kg"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moixKS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".008", ",", ".004", ",", ".004", ",", ".004", ",", ".004"}], 
       "}"}], "kg"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moiyKS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".016", ",", ".008", ",", ".008", ",", ".008", ",", ".008"}], 
       "}"}], "kg"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"moizKS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{".008", ",", ".004", ",", ".004", ",", ".004", ",", ".004"}], 
       "}"}], "kg"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5120796604416*^9, 3.512079739087098*^9}, {
  3.512079861641108*^9, 3.5120798981771975`*^9}, {3.5120799641719723`*^9, 
  3.5120799957277775`*^9}, {3.512080074886305*^9, 3.5120800764353933`*^9}, {
  3.514510467045108*^9, 3.5145105231584063`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wires", "Subsection",
 CellChangeTimes->{{3.511306120572666*^9, 3.5113061311874847`*^9}}],

Cell[CellGroupData[{

Cell["Properties and Geometric Values", "Subsubsection",
 CellChangeTimes->{{3.511311536146579*^9, 3.5113115410137873`*^9}, {
  3.5113118928256054`*^9, 3.5113118955244102`*^9}}],

Cell[CellGroupData[{

Cell["Usage note for symbols.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113114603616457`*^9, 3.5113114747136707`*^9}, {
   3.511311505554925*^9, 3.511311549718603*^9}, 3.5126982410615673`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nw", "::", "usage"}], "=", "\"\<number of wires\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"matw", "::", "usage"}], "=", "\"\<wire material\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lNw", "::", "usage"}], "=", "\"\<natural length of wires\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dw", "::", "usage"}], "=", "\"\<wire diameters\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dxu", "::", "usage"}], "=", 
   "\"\<x-separation of wires & COM at upper suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzu", "::", "usage"}], "=", 
   "\"\<z-separation of wires & COM at upper suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dxl", "::", "usage"}], "=", 
   "\"\<x-separation of wires & COM at lower suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzl", "::", "usage"}], "=", 
   "\"\<z-separation of wires & COM at lower suspension points\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyu", "::", "usage"}], "=", 
   "\"\<height of wire break-off below COM at upper body\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyl", "::", "usage"}], "=", 
   "\"\<height of wire break-off above COM at lower body\>\""}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113096085915933`*^9, 3.5113098531844225`*^9}, {
   3.511309893479294*^9, 3.5113099178465366`*^9}, 3.511309950247793*^9, {
   3.511311488410495*^9, 3.511311526942563*^9}, 3.5113153674308243`*^9, 
   3.5126982410615673`*^9, 3.512706179431407*^9, {3.512711537023219*^9, 
   3.512711552982047*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113115557402134`*^9, 3.5113115654278307`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{
   "F1", ",", "  ", "F2", ",", "  ", "F3", ",", "  ", "F4", ",", "  ", "IM", 
    ",", "  ", "IRM", ",", "  ", "TM", ",", "  ", "RM", ",", "  ", "MD"}], 
   "     ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"matw", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<MS\>\"", ",", "\"\<MS\>\"", ",", "\"\<MS\>\"", ",", "\"\<MS\>\"", 
       ",", "\"\<MS\>\"", ",", "\"\<C70\>\"", ",", "\"\<W\>\"", ",", 
       "\"\<C70\>\"", ",", "\"\<C70\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lNw", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2.100", "}"}], ",", 
        RowBox[{"{", "2.100", "}"}], ",", 
        RowBox[{"{", "2.350", "}"}], ",", 
        RowBox[{"{", "2.085", "}"}], ",", 
        RowBox[{"{", "2.084", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"2.084", ",", "2.084", ",", "2.084", ",", "2.084"}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.734", ",", "1.734", ",", "1.734"}], "}"}]}], "}"}], 
      "meter"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dyu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", 
        RowBox[{"{", "0.00", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.00", ",", "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"200.", ",", "200.", ",", "200."}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dyl", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", "10.0", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"-", "5.0"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00", ",", "1.00"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"1.00", ",", "1.00", ",", "1.00"}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dw", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "3.20", "}"}], ",", 
        RowBox[{"{", "3.00", "}"}], ",", 
        RowBox[{"{", "2.80", "}"}], ",", 
        RowBox[{"{", "2.50", "}"}], ",", 
        RowBox[{"{", "2.10", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.50", ",", "0.50", ",", "0.50", ",", "0.50"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.15", ",", "0.15", ",", "0.15", ",", "0.15"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.70", ",", "0.70", ",", "0.70", ",", "0.70"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"0.30", ",", "0.30", ",", "0.30"}], "}"}]}], "}"}], "mm"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dxu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
        "30.0", ",", "12.5", ",", "28.9", ",", "0.00"}], "}"}], "cm"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dzu", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
        "25.0", ",", "1.50", ",", "3.50", ",", "0.00"}], "}"}], "cm"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dxl", "=", "dxu"}], ";", 
    RowBox[{"dzl", "=", "dzu"}], ";"}], 
   RowBox[{"(*", 
    RowBox[{"vertical", " ", "suspension"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nw", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "4", ",", "4", ",", 
       "4", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5126979552998652`*^9, 3.5126979725066953`*^9}, {
   3.512698487807201*^9, 3.512698593512986*^9}, 3.512699268042571*^9, {
   3.512706425599839*^9, 3.5127064636951065`*^9}, {3.512707714364903*^9, 
   3.512707749839365*^9}, {3.5127079340132885`*^9, 3.512707950642918*^9}, {
   3.5127115595340586`*^9, 3.5127115689564753`*^9}, {3.5127119288491073`*^9, 
   3.5127120018884354`*^9}, {3.5127120337436914`*^9, 3.512712065645747*^9}, {
   3.5127121919123693`*^9, 3.5127122302416363`*^9}, {3.5127259305527315`*^9, 
   3.5127259383683453`*^9}, 3.512730513737984*^9, {3.512801934448643*^9, 
   3.5128020708396826`*^9}, {3.5141672927623053`*^9, 
   3.5141673224023576`*^9}, {3.514167356722418*^9, 3.514167370263242*^9}, {
   3.514167454113389*^9, 3.5141674764214277`*^9}, {3.5141675159830976`*^9, 
   3.514167522207508*^9}, {3.5141675870412226`*^9, 3.5141679140957966`*^9}, {
   3.51417313329418*^9, 3.5141731556490192`*^9}, {3.514509273799012*^9, 
   3.5145092813806252`*^9}, {3.5145093960564265`*^9, 
   3.5145096329272428`*^9}, {3.5145110141068687`*^9, 
   3.5145110212516813`*^9}, {3.514515586183301*^9, 3.5145156032809315`*^9}, {
   3.514852659369889*^9, 3.5148526799619246`*^9}, {3.517266642753051*^9, 
   3.5172667211275883`*^9}, {3.517267594651123*^9, 3.517267596398326*^9}, {
   3.5172676866756845`*^9, 3.5172676868004847`*^9}, {3.5172677964686775`*^9, 
   3.517267813223107*^9}, {3.5175311092739277`*^9, 3.51753116719683*^9}, {
   3.5176957709749384`*^9, 3.517695779499426*^9}, {3.5176962575527687`*^9, 
   3.5176962607849536`*^9}, {3.5176987622685795`*^9, 3.517698769272992*^9}, {
   3.5176988777867827`*^9, 3.517698882295191*^9}, {3.517719728910236*^9, 
   3.517719735992648*^9}, {3.5187618392613893`*^9, 3.51876186812144*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Effective Bending Point Compensation", "Subsubsection",
 CellChangeTimes->{{3.511310011805502*^9, 3.511310013724305*^9}, {
  3.5113101034712625`*^9, 3.511310109976474*^9}, {3.511312045081873*^9, 
  3.5113120493874807`*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511310024020323*^9, 3.5113100245975237`*^9}, {
   3.5113101204128923`*^9, 3.511310123595298*^9}, 3.511311097317808*^9}],

Cell["\<\
Bending point of wire is apart from the suspension point because of the wire \
bending stiffness.
In this subsubsection, the separation between effective bending point & \
suspension point is estimated (1/lambda),
and then wire length and wire break-off are compensated. If you want to \
disable this compensation, 
please make the following symbol \"False\".\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511310128790107*^9, 3.511310207960246*^9}, {
   3.511310336208071*^9, 3.511310459167487*^9}, {3.511310496030352*^9, 
   3.511310656320634*^9}, {3.51131089921306*^9, 3.5113110646045504`*^9}, 
   3.511311097317808*^9, 3.5113135489584303`*^9, {3.512725999270852*^9, 
   3.51272600367006*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wirecompensation", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511311074011367*^9, 3.511311097317808*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load weight", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511308651590311*^9, 3.511308660326327*^9}, {
  3.51131116687833*^9, 3.51131117236954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"loadw", "=", 
      RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "2", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "3", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "4", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"mass", "[", 
          RowBox[{"[", "n", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", "5", ",", "9"}], "}"}]}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$IM", "]"}], "]"}], "+", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$TM", "]"}], "]"}], "+", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "b$RM", "]"}], "]"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$IRM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$TM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$RM", "]"}], "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"loadw", ",", 
       RowBox[{"mass", "[", 
        RowBox[{"[", "b$MD", "]"}], "]"}]}], "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113086367702856`*^9, 3.5113087745029273`*^9}, {
   3.5113088097589893`*^9, 3.5113088188382053`*^9}, {3.5113088861367235`*^9, 
   3.511308890411131*^9}, {3.51131110959503*^9, 3.5113111384394803`*^9}, 
   3.51131117236954*^9, {3.512706614687772*^9, 3.512706633719805*^9}, {
   3.512706853539791*^9, 3.5127068600294027`*^9}, {3.5127069021182766`*^9, 
   3.512706931742728*^9}, {3.514511092403406*^9, 3.5145110994078183`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second moment of area", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113089605956545`*^9, 3.511309018003755*^9}, 
   3.5113093541395464`*^9, {3.511309392125613*^9, 3.511309434089687*^9}, {
   3.511311157487114*^9, 3.5113111858791637`*^9}, 3.511311299977764*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"iw", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"dw", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "m"}], "]"}], "]"}], "4"], "/", "64"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "dw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113091838496475`*^9, 3.5113092569513755`*^9}, {
   3.5113093129398737`*^9, 3.5113093236882925`*^9}, 3.5113093541395464`*^9, {
   3.511311150248701*^9, 3.5113111520583043`*^9}, {3.5113111858791637`*^9, 
   3.51131121202481*^9}, 3.511311299977764*^9, {3.5113151870237074`*^9, 
   3.5113152264761767`*^9}, {3.511315400799283*^9, 3.511315403076887*^9}, {
   3.512358626588375*^9, 3.512358627446377*^9}, 3.512706501493973*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Lambda", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511311218998022*^9, 3.5113112216032267`*^9}, 
   3.511311306186575*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lambdaw", "=", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"loadw", "[", 
           RowBox[{"[", "n", "]"}], "]"}], 
          RowBox[{
           RowBox[{
            RowBox[{"g", "/", 
             RowBox[{"nw", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "/", 
            RowBox[{"young", "[", 
             RowBox[{"matw", "[", 
              RowBox[{"[", "n", "]"}], "]"}], "]"}]}], "/", 
           RowBox[{"iw", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "m"}], "]"}], "]"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "dw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
       "]"}]}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511309025819369*^9, 3.5113091071423116`*^9}, {
   3.511309263518987*^9, 3.5113093858388023`*^9}, 3.5113111858791637`*^9, {
   3.5113112437708654`*^9, 3.5113112539732833`*^9}, 3.511311306186575*^9, {
   3.5113134454678483`*^9, 3.5113134500074563`*^9}, {3.5113152729798584`*^9, 
   3.5113152861306815`*^9}, {3.511315413669306*^9, 3.511315416804911*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compensation", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511309454182522*^9, 3.511309456428926*^9}, {
   3.5113113155153913`*^9, 3.511311321724202*^9}, 3.5113115879074697`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{"wirecompensation", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lNw", "=", 
      RowBox[{"lNw", "-", 
       RowBox[{"2", "/", "lambdaw"}]}]}], ";", 
     RowBox[{"(*", 
      RowBox[{"wire", " ", "length"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"dyu", "=", 
      RowBox[{"dyu", "+", 
       RowBox[{"1", "/", "lambdaw"}]}]}], ";", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"wire", " ", "break"}], "-", 
       RowBox[{"off", " ", "at", " ", "upper", " ", "body"}]}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"dyl", "=", 
      RowBox[{"dyl", "+", 
       RowBox[{"1", "/", "lambdaw"}]}]}], ";"}]}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"wire", " ", "break"}], "-", 
     RowBox[{"off", " ", "at", " ", "lower", " ", "body"}]}], "*)"}], 
   "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.5113113332994223`*^9, 3.5113114085071545`*^9}, {
  3.5113115879074697`*^9, 3.5113116037102976`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Suspension Points", "Subsubsection",
 CellChangeTimes->{{3.511313811132491*^9, 3.5113138177781024`*^9}, 
   3.5113138856070213`*^9}],

Cell[CellGroupData[{

Cell["Description", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511327852568959*^9, 3.511327855345764*^9}, 
   3.51132791554627*^9}],

Cell["\<\
The clamp positions of wires in local coordinate of the attached mass.
If you want to add geometric asymmetry to the system, please arrange the \
following definition.
\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113160716784616`*^9, 3.511316135513774*^9}, {
   3.511316199583086*^9, 3.511316246585969*^9}, 3.51132791554627*^9, 
   3.5126992435505285`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Body corrdinates for all objects originate at COM", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510968232951127*^9, 3.510968236383133*^9}, 
   3.511327918369875*^9, {3.5113279682587624`*^9, 3.511327969631565*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posCOM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109682272727165`*^9, 3.5109682511563587`*^9}, 
   3.511327918369875*^9}]
}, Open  ]],

Cell["Suspension Points at upper bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113278633641787`*^9, 3.511327866530984*^9}, 
   3.5113279214898806`*^9, {3.51269895991083*^9, 3.5126989766652594`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"rMD", "=", 
   RowBox[{"35", "cm"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.514509737166626*^9, 3.514509770457084*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spu", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "0"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "1"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "2"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "3"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Key", " ", "Stone", " ", "4"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "4"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzu", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "0"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyu", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}],
        "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.510541271815065*^9, 3.5105413275383625`*^9}, {
   3.510541364338827*^9, 3.5105414659262056`*^9}, {3.5105415729735937`*^9, 
   3.5105416770257764`*^9}, {3.510541718537449*^9, 3.510541745213496*^9}, {
   3.5105418057416024`*^9, 3.5105418656925077`*^9}, {3.5105419541758633`*^9, 
   3.510541964097481*^9}, {3.510562740817388*^9, 3.51056276442023*^9}, {
   3.5106273753944683`*^9, 3.5106273856904864`*^9}, {3.5106361554478965`*^9, 
   3.5106361572418995`*^9}, {3.510636263328886*^9, 3.5106362654972897`*^9}, {
   3.510636399979926*^9, 3.510636408606741*^9}, {3.510655831710415*^9, 
   3.510655836608824*^9}, {3.510910690123458*^9, 3.5109107397159452`*^9}, {
   3.5109112296192055`*^9, 3.5109112741416836`*^9}, {3.510999339027935*^9, 
   3.5109993921616287`*^9}, {3.511154589829262*^9, 3.51115459458727*^9}, {
   3.511219031273158*^9, 3.5112190316787586`*^9}, {3.5113138771362066`*^9, 
   3.511313877448207*^9}, {3.511313922329486*^9, 3.511314076176956*^9}, {
   3.5113144895308824`*^9, 3.511314559107004*^9}, {3.511315592929221*^9, 
   3.5113156070628457`*^9}, {3.5113156392145023`*^9, 
   3.5113160247691793`*^9}, {3.5113268353067727`*^9, 3.5113268435123873`*^9}, 
   3.5113279214898806`*^9, {3.5126986628863087`*^9, 3.512698934170785*^9}, 
   3.512699128297526*^9, {3.512699214409677*^9, 3.5126992208680887`*^9}, {
   3.512707995851797*^9, 3.5127080201878405`*^9}, {3.512712331173814*^9, 
   3.512712357038659*^9}, {3.5145096704141083`*^9, 3.5145096822389293`*^9}, {
   3.514509760145466*^9, 3.5145098628872466`*^9}, {3.5145099488433976`*^9, 
   3.514510000292288*^9}, {3.5145119182616568`*^9, 3.514511923472066*^9}, {
   3.517266758536454*^9, 3.5172667641056643`*^9}, {3.5172668008593287`*^9, 
   3.51726680163933*^9}, 3.5172668326989846`*^9, {3.517266902337507*^9, 
   3.5172669213851404`*^9}, 3.5172678773080196`*^9, {3.5187618797278605`*^9, 
   3.5187619102727137`*^9}}],

Cell[CellGroupData[{

Cell["Suspension points at lower bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5126989944024906`*^9, 3.512699019736935*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spl", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "1"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "2"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "3"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Filter", " ", "4"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"+", 
          RowBox[{"dyl", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"6", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "6", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Test", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"7", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "7", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Recoil", " ", "Mass"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"+", 
           RowBox[{"dxl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}], ",", 
          RowBox[{"+", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"8", ",", "4"}], "]"}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dzl", "[", 
            RowBox[{"[", "8", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"(*", 
        RowBox[{"Magnet", " ", "Disc"}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"0", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", 
          RowBox[{"-", 
           RowBox[{"dyl", "[", 
            RowBox[{"[", 
             RowBox[{"9", ",", "3"}], "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "rMD"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"4", "*", 
             RowBox[{
              RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}],
        "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510541271815065*^9, 3.5105413275383625`*^9}, {
   3.510541364338827*^9, 3.5105414659262056`*^9}, {3.5105415729735937`*^9, 
   3.5105416770257764`*^9}, {3.510541718537449*^9, 3.510541745213496*^9}, {
   3.5105418057416024`*^9, 3.5105418656925077`*^9}, {3.5105419541758633`*^9, 
   3.510541964097481*^9}, {3.510562740817388*^9, 3.51056276442023*^9}, {
   3.5106273753944683`*^9, 3.5106273856904864`*^9}, {3.5106361554478965`*^9, 
   3.5106361572418995`*^9}, {3.510636263328886*^9, 3.5106362654972897`*^9}, {
   3.510636399979926*^9, 3.510636408606741*^9}, {3.510655831710415*^9, 
   3.510655836608824*^9}, {3.510910690123458*^9, 3.5109107397159452`*^9}, {
   3.5109112296192055`*^9, 3.5109112741416836`*^9}, {3.510999339027935*^9, 
   3.5109993921616287`*^9}, {3.511154589829262*^9, 3.51115459458727*^9}, {
   3.511219031273158*^9, 3.5112190316787586`*^9}, {3.5113138771362066`*^9, 
   3.511313877448207*^9}, {3.511313922329486*^9, 3.511314076176956*^9}, {
   3.5113144895308824`*^9, 3.511314559107004*^9}, {3.511315592929221*^9, 
   3.5113156070628457`*^9}, {3.5113156392145023`*^9, 
   3.5113160247691793`*^9}, {3.5113268353067727`*^9, 3.5113268435123873`*^9}, 
   3.5113279214898806`*^9, {3.5126986628863087`*^9, 3.512698934170785*^9}, {
   3.512699019736935*^9, 3.512699078798639*^9}, {3.51269913639394*^9, 
   3.5126992265620985`*^9}, {3.5127080281594543`*^9, 3.512708062214314*^9}, {
   3.5127123629042697`*^9, 3.512712393121523*^9}, {3.5145100107599063`*^9, 
   3.5145101016612663`*^9}, {3.514511907482038*^9, 3.514511915578452*^9}, {
   3.517266777630888*^9, 3.5172667979889235`*^9}, {3.5172669361895666`*^9, 
   3.5172669542075977`*^9}, 3.517267874812015*^9, {3.5187619260755415`*^9, 
   3.51876193095835*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pre-isolator Stage", "Subsection",
 CellChangeTimes->{{3.5113121326448264`*^9, 3.511312140866041*^9}, {
  3.511313336751258*^9, 3.5113133378900595`*^9}, {3.511313499178743*^9, 
  3.5113135082735586`*^9}, {3.5113162941348524`*^9, 3.5113163044464703`*^9}}],

Cell[CellGroupData[{

Cell["Stiffness", "Subsubsection",
 CellChangeTimes->{{3.5113164098090553`*^9, 3.511316411088258*^9}, {
   3.511316936840381*^9, 3.511316965903232*^9}, 3.511317821903537*^9}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511317080672634*^9, 3.5113170919670534`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"lIP", "=", 
    RowBox[{"50.0", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"length", " ", "of", " ", "the", " ", "IP", " ", "leg"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lIPcom", "=", 
    RowBox[{"12.3", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"COM", " ", "position", " ", "from", " ", "the", " ", "ground"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kflex", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1896", ",", "1896", ",", "1896"}], "}"}], "newton", " ", 
     RowBox[{"meter", "/", "rad"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"stiffness", " ", "of", " ", "flex", " ", "joints", " ", "1896"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"loadIP", "=", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"mass", "[", 
       RowBox[{"[", "n", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"load", " ", "weight"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvZbrwjQfzVeOE6KrZ4DoBTnZ80D0JP2cNSD60bN/
r3yBtNsd4W8gek/uZDM/IH1PZqIFiN4nWWULoi+mzXcE0dzPP3iAaKlPdT4g
WnXu3WYQ7Rpd1wKi0x01J4HoBQwWU8HqAwIXBAHppN3NYJrvxpfHIUC6q3v9
ExB9f0WPYCiQnsf0CkwvWf1RDkSfLjqnBqKTtwmeWwKk7/CUg+mOqx99PLWB
5gf9BdNzAqsngOiH6g/BdO8htu9fgLS9YD2YPvhelusrkD7My8sNotXd9BZ/
B9JLfr4A0z82r1kFonsEH60H0U/vbOxQ1gGGV8mGThA95/q0Zan6QP8FLgPT
AJSepP8=
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness of each leg", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511317097973064*^9, 3.511317103214673*^9}, 
   3.5113175148325973`*^9, {3.51131754495625*^9, 3.5113175473430543`*^9}, {
   3.511317808518713*^9, 3.5113178121535196`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kIP", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"kflex", "[", 
        RowBox[{"[", "n", "]"}], "]"}], "/", 
       SuperscriptBox["lIP", "2"]}], "-", 
      RowBox[{"g", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"massIP", "[", 
            RowBox[{"[", "n", "]"}], "]"}], 
           RowBox[{"(", 
            RowBox[{"lIPcom", "/", "lIP"}], ")"}]}], "+", 
          RowBox[{"loadIP", "/", "3"}]}], ")"}], "/", "lIP"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kIPc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"kflex", "[", 
        RowBox[{"[", "n", "]"}], "]"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"I", " ", 
           RowBox[{"phi", "[", "\"\<MS\>\"", "]"}]}]}], ")"}], "/", 
        SuperscriptBox["lIP", "2"]}]}], "-", 
      RowBox[{"g", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"massIP", "[", 
            RowBox[{"[", "n", "]"}], "]"}], 
           RowBox[{"(", 
            RowBox[{"lIPcom", "/", "lIP"}], ")"}]}], "+", 
          RowBox[{"loadIP", "/", "3"}]}], ")"}], "/", "lIP"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511317105320677*^9, 3.511317202212447*^9}, {
   3.5113173168214493`*^9, 3.5113174561764946`*^9}, {3.5113175148325973`*^9, 
   3.511317543177847*^9}, 3.511317638369214*^9, 3.511317684358095*^9, {
   3.511318505153537*^9, 3.5113185319231834`*^9}, {3.511330963088026*^9, 
   3.5113309667228327`*^9}, {3.5113310748778224`*^9, 3.5113310950174575`*^9}, 
   3.511387352979451*^9, {3.5127070315205035`*^9, 3.512707039944518*^9}, {
   3.5127072581265016`*^9, 3.512707262010908*^9}, {3.5127082758098893`*^9, 
   3.512708280911098*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position", "Subsubsection",
 CellChangeTimes->{{3.5113164190910716`*^9, 3.5113164359703016`*^9}, 
   3.511317586982724*^9, 3.511317837503564*^9}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511317557919873*^9, 3.5113175589026747`*^9}, 
   3.5113175969043417`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rstage", "=", 
    RowBox[{"65.0", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"radius", " ", "of", " ", "the", " ", "stage"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511316438325906*^9, 3.511316552486906*^9}, {
  3.511316922020355*^9, 3.5113169235959578`*^9}, {3.511317564924285*^9, 
  3.5113175969043417`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP leg position", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113175744715023`*^9, 3.511317600648348*^9}, 
   3.5127062910340033`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"legs", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"0", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"0", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"2", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"4", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}], ",", "0", 
        ",", 
        RowBox[{
         RowBox[{"-", "rstage"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", 
           RowBox[{
            RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "]"}]}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511316438325906*^9, 3.511316552486906*^9}, {
   3.511316922020355*^9, 3.5113169235959578`*^9}, 3.511317564924285*^9, 
   3.511317600648348*^9, {3.5113236206989217`*^9, 3.511323643552962*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GAS Filters", "Subsection",
 CellChangeTimes->{{3.5110753524379687`*^9, 3.51107535310877*^9}, {
  3.5113185577100286`*^9, 3.5113185602528334`*^9}}],

Cell[CellGroupData[{

Cell["Stiffness", "Subsubsection",
 CellChangeTimes->{{3.5113166496750765`*^9, 3.511316666757107*^9}, {
  3.5113167132919884`*^9, 3.5113167240872073`*^9}, {3.5113177945098886`*^9, 
  3.51131779518069*^9}}],

Cell[CellGroupData[{

Cell["Resonant frequency and loss angle", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113168213533783`*^9, 3.5113168316493964`*^9}, {
  3.5113185852440777`*^9, 3.5113185893156843`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"F0", "  ", "F1", "  ", "F2", "  ", "F3", "  ", "F4"}], "       ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f0GAS", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"330", ",", "330", ",", "330", ",", "330", ",", "330"}], "}"}],
       "mHz"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phiGAS", "=", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.01", ",", "0.01", ",", "0.01", ",", "0.01"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511316742120839*^9, 3.5113168316493964`*^9}, {
  3.511318591889689*^9, 3.5113186119669247`*^9}, {3.511329385379252*^9, 
  3.511329385472852*^9}, {3.511494276037948*^9, 3.511494281232757*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load weight", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113168396054106`*^9, 3.5113168431622167`*^9}, 
   3.5113177835742693`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"loadGAS", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"mass", "[", 
        RowBox[{"[", "n", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "2", ",", "9"}], "}"}]}], "]"}], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"massKS", "[", 
        RowBox[{"[", "m", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "1", ",", "5"}], "}"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"mass", "[", 
        RowBox[{"[", "n", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "3", ",", "9"}], "}"}]}], "]"}], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"massKS", "[", 
        RowBox[{"[", "m", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "2", ",", "5"}], "}"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"mass", "[", 
        RowBox[{"[", "n", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "4", ",", "9"}], "}"}]}], "]"}], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"massKS", "[", 
        RowBox[{"[", "m", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "3", ",", "5"}], "}"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"mass", "[", 
        RowBox[{"[", "n", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "5", ",", "9"}], "}"}]}], "]"}], "+", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"massKS", "[", 
        RowBox[{"[", "m", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "4", ",", "5"}], "}"}]}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"loadGAS", ",", 
    RowBox[{
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$IM", "]"}], "]"}], "+", 
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$TM", "]"}], "]"}], "+", 
     RowBox[{"mass", "[", 
      RowBox[{"[", "b$RM", "]"}], "]"}], "+", 
     RowBox[{"massKS", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113168459234214`*^9, 3.511316894018306*^9}, {
  3.5113177342469826`*^9, 3.5113177835742693`*^9}, {3.512087644678827*^9, 
  3.512087708545339*^9}, {3.5145111126834416`*^9, 3.514511134929081*^9}, {
  3.514512124431619*^9, 3.5145121295328283`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vertical Stiffness", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113177997670975`*^9, 3.511317803713905*^9}, 
   3.511318346860059*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kGAS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"loadGAS", "[", 
       RowBox[{"[", "n", "]"}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"f0GAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ")"}], "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Length", "[", "f0GAS", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kGASc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"loadGAS", "[", 
       RowBox[{"[", "n", "]"}], "]"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"phiGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", 
         RowBox[{"N", "[", "Pi", "]"}], 
         RowBox[{"f0GAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ")"}], "2"]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"Length", "[", "f0GAS", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511318257549902*^9, 3.511318346860059*^9}, {
  3.5113186244781466`*^9, 3.5113186501869917`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Saturation Level", "Subsubsection",
 CellChangeTimes->{{3.5120877900086823`*^9, 3.5120877937682886`*^9}}],

Cell[CellGroupData[{

Cell["Saturation Level (dB)", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.512087554666669*^9, 3.5120875777859097`*^9}, {
  3.512087762615034*^9, 3.5120877773726597`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"satGAS", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "70"}], ",", 
      RowBox[{"-", "70"}]}], "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5120875807031145`*^9, 3.5120875927775354`*^9}, {
  3.5120877707738485`*^9, 3.5120877773726597`*^9}, {3.5120878683832197`*^9, 
  3.5120878714252253`*^9}, {3.5120883985189505`*^9, 3.512088404181761*^9}, {
  3.5120888127932787`*^9, 3.512088819766491*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inertia Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.5120876005463495`*^9, 3.512087603369954*^9}, 
   3.512087780679866*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"miGAS", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"loadGAS", "[", 
        RowBox[{"[", "n", "]"}], "]"}], 
       RowBox[{"(", 
        RowBox[{"10", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"satGAS", "[", 
            RowBox[{"[", "n", "]"}], "]"}], "/", "20"}], ")"}]}], ")"}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "satGAS", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.512087608814364*^9, 3.512087612761171*^9}, {
  3.512087724098566*^9, 3.512087780679866*^9}, {3.512087813705124*^9, 
  3.5120878784764376`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working Point & Direction", "Subsubsection",
 CellChangeTimes->{{3.511318358560079*^9, 3.5113183725221033`*^9}, {
  3.5113184710830765`*^9, 3.511318474639883*^9}}],

Cell[CellGroupData[{

Cell["Working position in local coordinate system of Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113184065613637`*^9, 3.5113184581974545`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wpGAS", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"3", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         RowBox[{"dyu", "[", 
          RowBox[{"[", 
           RowBox[{"5", ",", "1"}], "]"}], "]"}]}], ",", "0"}], "}"}]}], 
     "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511075372624404*^9, 3.5110755086098433`*^9}, {
   3.511078738029937*^9, 3.511078805141255*^9}, {3.511130324732766*^9, 
   3.5111303256808205`*^9}, {3.51113120990919*^9, 3.511131263807285*^9}, {
   3.511131301715351*^9, 3.5111313116993685`*^9}, {3.5111315230641403`*^9, 
   3.511131537010565*^9}, {3.511134239146511*^9, 3.511134263607354*^9}, {
   3.511134354009513*^9, 3.5111343542903132`*^9}, {3.5111345428634443`*^9, 
   3.5111345430038447`*^9}, {3.511139200314025*^9, 3.511139200891226*^9}, {
   3.511146068745289*^9, 3.51114606933809*^9}, {3.511147884884879*^9, 
   3.5111479220441446`*^9}, {3.5111494918593016`*^9, 3.511149492046502*^9}, 
   3.511150491431057*^9, {3.5111506726877756`*^9, 3.5111506756205807`*^9}, 
   3.511152181304025*^9, {3.5111522247657013`*^9, 3.5111522629389687`*^9}, 
   3.511153090021221*^9, {3.511154622589319*^9, 3.51115462296372*^9}, {
   3.5111548408181024`*^9, 3.51115484506131*^9}, {3.5112182732458262`*^9, 
   3.5112182916694584`*^9}, {3.511316690640749*^9, 3.5113167012955675`*^9}, {
   3.511318380041317*^9, 3.5113183970765467`*^9}, {3.511318445967033*^9, 
   3.5113184581974545`*^9}, {3.5113188332689133`*^9, 3.51131884275373*^9}, {
   3.5113234944167*^9, 3.5113235005007105`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working direction in local coordinate system of Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113184793822913`*^9, 3.511318487291505*^9}, 
   3.5113187131955023`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wdGAS", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "\[IndentingNewLine]", 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511075372624404*^9, 3.5110755086098433`*^9}, {
   3.511078738029937*^9, 3.511078805141255*^9}, {3.511130324732766*^9, 
   3.5111303256808205`*^9}, {3.51113120990919*^9, 3.511131263807285*^9}, {
   3.511131301715351*^9, 3.5111313116993685`*^9}, {3.5111315230641403`*^9, 
   3.511131537010565*^9}, {3.511134239146511*^9, 3.511134263607354*^9}, {
   3.511134354009513*^9, 3.5111343542903132`*^9}, {3.5111345428634443`*^9, 
   3.5111345430038447`*^9}, {3.511139200314025*^9, 3.511139200891226*^9}, {
   3.511146068745289*^9, 3.51114606933809*^9}, {3.511147884884879*^9, 
   3.5111479220441446`*^9}, {3.5111494918593016`*^9, 3.511149492046502*^9}, 
   3.511150491431057*^9, {3.5111506726877756`*^9, 3.5111506756205807`*^9}, 
   3.511152181304025*^9, {3.5111522247657013`*^9, 3.5111522629389687`*^9}, 
   3.511153090021221*^9, {3.511154622589319*^9, 3.51115462296372*^9}, {
   3.5111548408181024`*^9, 3.51115484506131*^9}, {3.5112182732458262`*^9, 
   3.5112182916694584`*^9}, {3.511316690640749*^9, 3.5113167012955675`*^9}, {
   3.511318380041317*^9, 3.5113183970765467`*^9}, 3.511318445967033*^9, 
   3.5113185773192635`*^9, {3.511318679702243*^9, 3.5113187131955023`*^9}, {
   3.511318810352473*^9, 3.51131882010249*^9}, {3.511322861866789*^9, 
   3.5113228718040066`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness Matrix & Storing Force Vector", "Subsubsection",
 CellChangeTimes->{{3.5113187371571445`*^9, 3.5113187452223587`*^9}, {
  3.511318874530986*^9, 3.511318883922202*^9}}],

Cell[CellGroupData[{

Cell["\<\
Stiffness matrix (stiffness matrix of GASF with 4 blades is measured by \
Alessandro)\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511318890068613*^9, 3.511318893001418*^9}, 
   3.511319080342147*^9, {3.5188172899656305`*^9, 3.5188173257520933`*^9}, {
   3.518817399468432*^9, 3.5188173996400323`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matkGASc", "=", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1966", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "25."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGASc", "[", 
             RowBox[{"[", "1", "]"}], "]"}], 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["10", 
                 RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ",", "0.00", ",", 
           "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1966", ",", 
           RowBox[{"-", "25."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "25."}], ",", "4.91", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "25.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "25."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "4.91"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1680", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "21."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGASc", "[", 
             RowBox[{"[", "2", "]"}], "]"}], 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["10", 
                 RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ",", "0.00", ",", 
           "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1680", ",", 
           RowBox[{"-", "21."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "21."}], ",", "4.20", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "21.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "21."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "4.20"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1400", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "17."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGASc", "[", 
             RowBox[{"[", "3", "]"}], "]"}], 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["10", 
                 RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ",", "0.00", ",", 
           "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1400", ",", 
           RowBox[{"-", "17."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "17."}], ",", "3.50", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "17.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "17."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "3.50"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1120", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "14."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGASc", "[", 
             RowBox[{"[", "4", "]"}], "]"}], 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["10", 
                 RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ",", "0.00", ",", 
           "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1120", ",", 
           RowBox[{"-", "14."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "14."}], ",", "2.80", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "14.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "14."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "2.80"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "840.", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "11."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGASc", "[", 
             RowBox[{"[", "5", "]"}], "]"}], 
            RowBox[{
             SuperscriptBox["10", 
              RowBox[{"-", "3"}]], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SuperscriptBox["10", 
                 RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ",", "0.00", ",", 
           "0.00", ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "840.", ",", 
           RowBox[{"-", "11."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "11."}], ",", "2.10", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "11.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "11."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "2.10"}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
      "\[IndentingNewLine]", "}"}], 
     SuperscriptBox["10", "3"], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "3"}]], "I"}]}], ")"}]}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5111311698795195`*^9, 3.5111311941375628`*^9}, {
   3.511131337860615*^9, 3.511131457653225*^9}, {3.5111317695913734`*^9, 
   3.511131777110586*^9}, {3.511131811649047*^9, 3.5111319010060043`*^9}, {
   3.511131942798477*^9, 3.5111319912833624`*^9}, {3.5111346002715454`*^9, 
   3.511134738175788*^9}, 3.511139306721812*^9, {3.5111437243419714`*^9, 
   3.5111437272279763`*^9}, {3.5111460759837017`*^9, 3.511146076576503*^9}, 
   3.511318867557773*^9, {3.5113189150130568`*^9, 3.5113189754007626`*^9}, {
   3.511319080342147*^9, 3.5113191008873835`*^9}, {3.5120807757529383`*^9, 
   3.512080877418317*^9}, {3.512080988301713*^9, 3.512080990501317*^9}, {
   3.5120810261941795`*^9, 3.512081080466675*^9}, {3.5120811256287537`*^9, 
   3.5120811276099577`*^9}, {3.512081188621665*^9, 3.512081200711686*^9}, {
   3.512081286449436*^9, 3.5120815477186956`*^9}, {3.5120815829903574`*^9, 
   3.5120817726554904`*^9}, {3.512081812934761*^9, 3.5120819700114374`*^9}, {
   3.5120827895120764`*^9, 3.5120828125689173`*^9}, {3.5145112354172573`*^9, 
   3.5145112772253313`*^9}, {3.5145113114205914`*^9, 3.5145113347270317`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matkGAS", "=", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1966", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "25."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGAS", "[", 
             RowBox[{"[", "1", "]"}], "]"}], 
            SuperscriptBox["10", 
             RowBox[{"-", "3"}]]}], ",", "0.00", ",", "0.00", ",", "0.00", 
           ",", "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1966", ",", 
           RowBox[{"-", "25."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "25."}], ",", "4.91", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "25.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "25."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "4.91"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1680", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "21."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGAS", "[", 
             RowBox[{"[", "2", "]"}], "]"}], 
            SuperscriptBox["10", 
             RowBox[{"-", "3"}]]}], ",", "0.00", ",", "0.00", ",", "0.00", 
           ",", "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1680", ",", 
           RowBox[{"-", "21."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "21."}], ",", "4.20", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "21.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "21."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "4.20"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1400", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "17."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGAS", "[", 
             RowBox[{"[", "3", "]"}], "]"}], 
            SuperscriptBox["10", 
             RowBox[{"-", "3"}]]}], ",", "0.00", ",", "0.00", ",", "0.00", 
           ",", "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1400", ",", 
           RowBox[{"-", "17."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "17."}], ",", "3.50", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "17.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "17."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "3.50"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "1120", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "14."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGAS", "[", 
             RowBox[{"[", "4", "]"}], "]"}], 
            SuperscriptBox["10", 
             RowBox[{"-", "3"}]]}], ",", "0.00", ",", "0.00", ",", "0.00", 
           ",", "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "1120", ",", 
           RowBox[{"-", "14."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "14."}], ",", "2.80", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "14.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "14."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "2.80"}], "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "840.", ",", "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           RowBox[{"-", "11."}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", 
           RowBox[{
            RowBox[{"kGAS", "[", 
             RowBox[{"[", "5", "]"}], "]"}], 
            SuperscriptBox["10", 
             RowBox[{"-", "3"}]]}], ",", "0.00", ",", "0.00", ",", "0.00", 
           ",", "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", "840.", ",", 
           RowBox[{"-", "11."}], ",", "0.00", ",", "0.00"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"0.00", ",", "0.00", ",", 
           RowBox[{"-", "11."}], ",", "2.10", ",", "0.00", ",", "0.00"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
          "0.00", ",", "0.00", ",", "0.00", ",", "0.00", ",", "11.0", ",", 
           "0.00"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "11."}], ",", "0.00", ",", "0.00", ",", "0.00", ",", 
           "0.00", ",", "2.10"}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
      "\[IndentingNewLine]", "}"}], 
     SuperscriptBox["10", "3"]}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.5145112173368263`*^9, 3.5145113373478365`*^9}],

Cell[CellGroupData[{

Cell["Storing force vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113189787547684`*^9, 3.511318984573579*^9}, 
   3.5113190853029556`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"vecfGAS", "=", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"g", " ", 
         RowBox[{"loadGAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}], 
         RowBox[{"wdGAS", "[", 
          RowBox[{"[", "n", "]"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "wdGAS", "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5111311698795195`*^9, 3.5111311941375628`*^9}, {
   3.511131337860615*^9, 3.511131457653225*^9}, {3.5111317695913734`*^9, 
   3.511131777110586*^9}, {3.511131811649047*^9, 3.5111319010060043`*^9}, {
   3.511131942798477*^9, 3.5111319912833624`*^9}, {3.5111346002715454`*^9, 
   3.511134738175788*^9}, 3.511139306721812*^9, {3.5111437243419714`*^9, 
   3.5111437272279763`*^9}, {3.5111460759837017`*^9, 3.511146076576503*^9}, 
   3.511318867557773*^9, {3.5113189150130568`*^9, 3.5113189884891853`*^9}, {
   3.511319022450445*^9, 3.5113191264246283`*^9}, {3.5113228881840353`*^9, 
   3.511322937589322*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eddy Current Damper", "Subsection",
 CellChangeTimes->{{3.5113878607043433`*^9, 3.5113878620615454`*^9}, {
  3.5113884357525535`*^9, 3.5113884393717594`*^9}}],

Cell[CellGroupData[{

Cell["Magnet Disc", "Subsubsection",
 CellChangeTimes->{{3.5113878671315546`*^9, 3.511387911232832*^9}, {
  3.511388451492981*^9, 3.511388455751788*^9}}],

Cell[CellGroupData[{

Cell["Damping coefficient for each mode", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511387946520094*^9, 3.511387954132908*^9}, 
   3.5113883991704893`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "        ", 
   RowBox[{"x", ",", "  ", "y", ",", "  ", "z"}], "         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"dampMDt", "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"80", ",", "150", ",", "80"}], "}"}], 
     RowBox[{"kg", "/", "sec"}]}]}], ";"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113879591405163`*^9, 3.5113881294616156`*^9}, {
   3.511388224169382*^9, 3.5113882711566644`*^9}, 3.5113883991704893`*^9, {
   3.5114941970394096`*^9, 3.511494200206215*^9}, {3.5145115028017273`*^9, 
   3.514511511038542*^9}, {3.5188275716456184`*^9, 3.518827577402028*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "       ", 
   RowBox[{"pitch", ",", "yaw", ",", "roll"}], "         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dampMDr", "=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "8", ",", "4"}], "}"}], "kg", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["meter", "2"], "/", "rad"}], "/", "sec"}]}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113879591405163`*^9, 3.5113881294616156`*^9}, {
   3.511388224169382*^9, 3.511388321544753*^9}, 3.5113883991704893`*^9, {
   3.51149420313902*^9, 3.5114942057910247`*^9}, {3.514511517060152*^9, 
   3.5145115206793585`*^9}, {3.518827564500806*^9, 3.518827567589611*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping coefficient matrix", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511388185606114*^9, 3.511388193593328*^9}, 
   3.511388406596102*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dampMD", "=", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Join", "[", 
      RowBox[{"dampMDt", ",", "dampMDr"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113881972749343`*^9, 3.511388199770939*^9}, {
  3.511388336115178*^9, 3.5113884085929055`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Actuators", "Subsection",
 CellChangeTimes->{{3.5113201245923815`*^9, 3.511320127103986*^9}}],

Cell[CellGroupData[{

Cell["Positions", "Subsubsection",
 CellChangeTimes->{{3.5113204481369495`*^9, 3.511320449650152*^9}}],

Cell[CellGroupData[{

Cell["Values", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113202091757298`*^9, 3.511320210205332*^9}, 
   3.511320410462883*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dxTMa", "=", 
    RowBox[{"12", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", 
    RowBox[{
    "separation", " ", "of", " ", "actuators", " ", "at", " ", "TM"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dyTMa", "=", 
    RowBox[{"12", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", 
    RowBox[{
    "separation", " ", "of", " ", "actators", " ", "at", " ", "TM"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzTMa", "=", 
    RowBox[{"5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "-", 
      RowBox[{
      "separation", " ", "between", " ", "COM", " ", "of", " ", "TM"}]}], " ",
      "&"}], " ", "actuators"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dzRMa", "=", 
    RowBox[{"6", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "-", 
      RowBox[{
      "separation", " ", "between", " ", "COM", " ", "of", " ", "RM"}]}], " ",
      "&"}], " ", "actuators"}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113202124517355`*^9, 3.5113202217649517`*^9}, {
  3.51132026614703*^9, 3.511320410462883*^9}, {3.5113204870590177`*^9, 
  3.5113205365111046`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rF0a", "=", 
    RowBox[{"30", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
   "actuator", " ", "position", " ", "from", " ", "COM", " ", "of", " ", 
    "F0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tF0a", "=", 
    RowBox[{"0", "deg"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"rotation", " ", "angle"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113911030764384`*^9, 3.51139118946939*^9}, {
   3.511412517603778*^9, 3.511412540520218*^9}, {3.5114125735610757`*^9, 
   3.511412617553153*^9}, {3.5114132833935223`*^9, 3.511413331192006*^9}, 
   3.511413414433753*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position of actuators in local coordinate", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113204715057907`*^9, 3.511320480023405*^9}, 
   3.511320711652612*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posTMa", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzTMa"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posRMa", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"+", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"+", "dxTMa"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "dyTMa"}], "/", "2"}], ",", 
       RowBox[{"-", "dzRMa"}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511320549069127*^9, 3.5113207534450855`*^9}, {
  3.5113912026046133`*^9, 3.5113912502938967`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posF0a", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{
         RowBox[{"+", "rF0a"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511320549069127*^9, 3.5113207534450855`*^9}, {
  3.5113912026046133`*^9, 3.511391247111491*^9}, {3.5114126973160934`*^9, 
  3.5114127193745317`*^9}, {3.5114127642402105`*^9, 3.511412794707064*^9}, {
  3.5114132109157953`*^9, 3.511413218279008*^9}, {3.5114133356380143`*^9, 
  3.511413352486044*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working Direction", "Subsubsection",
 CellChangeTimes->{{3.511320420556101*^9, 3.5113204221161036`*^9}, {
  3.5113204602893705`*^9, 3.5113204617401733`*^9}}],

Cell[CellGroupData[{

Cell["Working direction in local coordinate system at recoil body.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511320810213585*^9, 3.511320827560816*^9}, 
   3.511323594038475*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dirTMa", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "\[IndentingNewLine]", 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511320767765911*^9, 3.5113207953779593`*^9}, {
   3.5113208372172327`*^9, 3.5113208425680423`*^9}, 3.511323594038475*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dirF0a", "=", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"0", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"2", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}], ",", "0", ",", 
        RowBox[{"+", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{
             RowBox[{"N", "[", "Pi", "]"}], "/", "3"}]}], "+", "tF0a"}], 
          "]"}]}]}], "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511412799121872*^9, 3.5114128056270833`*^9}, {
   3.5114128689475946`*^9, 3.5114128764044075`*^9}, {3.5114129126276712`*^9, 
   3.511412938820117*^9}, {3.5114130374434905`*^9, 3.5114130582695274`*^9}, {
   3.5114133545452476`*^9, 3.5114133579616537`*^9}, 3.51141343579019*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Body Shape", "Subsection",
 CellChangeTimes->{{3.511303371161437*^9, 3.5113033797726517`*^9}}],

Cell[CellGroupData[{

Cell["Discription", "Subsubsection",
 CellChangeTimes->{{3.5113191638334937`*^9, 3.5113191686227016`*^9}}],

Cell["\<\
This subsection contains the definition of the body appearance for eigen-mode \
3D graphics.
Containing nothing important for eigen-mode calculation or transfer function \
plots.
The 3D graphics shows not only standard bodies, but also mass-less bodies; \
the ground and key stones.
If you do not want to show them, please make the following symbols \"False\".\
\>", "Text",
 CellChangeTimes->{{3.51131927562329*^9, 3.511319695373227*^9}, {
  3.5113201748088694`*^9, 3.5113201768836727`*^9}, {3.51277273048518*^9, 
  3.51277274766081*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"showground", "=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showkeystones", "=", "True"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.511319700568036*^9, 3.511319716386464*^9}, {
  3.5113208734716964`*^9, 3.511320878869306*^9}, {3.5113305238848543`*^9, 
  3.5113305240252547`*^9}, {3.5145106603762474`*^9, 3.51451066204545*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shape Definition", "Subsubsection",
 CellChangeTimes->{{3.5113192607252636`*^9, 3.5113192614740653`*^9}, {
  3.511319726401682*^9, 3.5113197279772844`*^9}, {3.512708700551835*^9, 
  3.5127087296770864`*^9}}],

Cell[CellGroupData[{

Cell["Ground", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113059380991454`*^9, 3.5113059389259467`*^9}, 
   3.5113197356836977`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showground", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"shapeg", "=", "\"\<Doughnut\>\""}], ";", "\[IndentingNewLine]", 
      RowBox[{"rgi", "=", 
       RowBox[{"rstage", "-", 
        RowBox[{"20", "cm"}]}]}], ";", 
      RowBox[{"(*", 
       RowBox[{"inner", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"rgo", "=", 
       RowBox[{"rstage", "+", 
        RowBox[{"20", "cm"}]}]}], ";", 
      RowBox[{"(*", 
       RowBox[{"outer", " ", "radius"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"dimg", "=", 
       RowBox[{"{", 
        RowBox[{"rgi", ",", "rgo"}], "}"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113034020962915`*^9, 3.5113035097988806`*^9}, 
   3.5113035528549557`*^9, {3.511303899549965*^9, 3.5113039129503884`*^9}, {
   3.5113197356836977`*^9, 3.511319750269724*^9}, 3.511321098112091*^9, {
   3.512708410016925*^9, 3.5127084313577623`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.5113199123228083`*^9, 3.511319917002816*^9}, 
   3.511319954770483*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showkeystones", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"shapeKS", "=", "\"\<yCylinder\>\""}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rKS", "=", 
       RowBox[{"2", "cm"}]}], ";", 
      RowBox[{"(*", "radius", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"hKS", "=", 
       RowBox[{"1", "cm"}]}], ";", 
      RowBox[{"(*", "height", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"dimKS", "=", 
       RowBox[{"{", 
        RowBox[{"rKS", ",", "hKS"}], "}"}]}], ";"}]}], "\[IndentingNewLine]", 
    "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511319920107222*^9, 3.5113199778741236`*^9}, 
   3.5113211007016954`*^9, {3.5127084353981695`*^9, 3.512708443666184*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP legs", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113035690321846`*^9, 3.5113035702489862`*^9}, 
   3.51131976529255*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIP", "=", "\"\<DoubleCylinder\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ruIP", "=", 
    RowBox[{"5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", " ", "cylinder", " ", "radius"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rlIP", "=", 
    RowBox[{"6.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", " ", "cylinder", " ", "radius"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"huIP", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"lIP", "-", "lIPcom"}], ",", 
      RowBox[{"-", "lIPcom"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", " ", "cylinder", " ", "range"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hlIP", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "lIPcom"}], ",", 
      RowBox[{
       RowBox[{"-", "lIPcom"}], "-", 
       RowBox[{"15", "cm"}]}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", " ", "cylinder", " ", "range"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIP", "=", 
   RowBox[{"{", 
    RowBox[{"ruIP", ",", "rlIP", ",", "huIP", ",", "hlIP"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.5113035874870167`*^9, {3.5113038892851467`*^9, 3.511303893887155*^9}, 
   3.51131976529255*^9, {3.511325929705777*^9, 3.5113259341985855`*^9}, {
   3.512708451653398*^9, 3.512708476020641*^9}, {3.5127103883967996`*^9, 
   3.512710389192401*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filter 0", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113035334173217`*^9, 3.511303565990179*^9}, 
   3.5113197905021944`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeF0", " ", "=", " ", "\"\<yCylinder\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"rF0", " ", "=", " ", 
    RowBox[{"70", " ", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"hF0", " ", "=", " ", 
    RowBox[{"20", " ", "cm"}]}], ";"}], 
  RowBox[{"(*", "height", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimF0", "=", 
   RowBox[{"{", 
    RowBox[{"rF0", ",", "hF0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{
  3.5113035898270206`*^9, {3.511303713379238*^9, 3.511303740086485*^9}, {
   3.5113038777099266`*^9, 3.5113038787551284`*^9}, 3.5113197905021944`*^9, {
   3.51270848149625*^9, 3.512708521837921*^9}, {3.512708847940894*^9, 
   3.512708903726592*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Filters", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511303652367531*^9, 3.5113036562051373`*^9}, 
   3.51131980525982*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeGAS", "=", "\"\<TruncatedCone\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ruGAS", "=", 
    RowBox[{"28", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"upper", "-", 
    RowBox[{"side", " ", "radius"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rlGAS", "=", 
    RowBox[{"37", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"lower", "-", 
    RowBox[{"side", " ", "radius"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hGAS", "=", 
    RowBox[{"20", "cm"}]}], ";"}], 
  RowBox[{"(*", "height", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimGAS", "=", 
   RowBox[{"{", 
    RowBox[{"ruGAS", ",", "rlGAS", ",", "hGAS"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.5113036594499435`*^9, 3.511303700181615*^9}, {
   3.5113037338464737`*^9, 3.511303748338899*^9}, {3.511303780506156*^9, 
   3.511303810895009*^9}, {3.51130401070016*^9, 3.5113040321189976`*^9}, 
   3.51131980525982*^9, {3.512708527625531*^9, 3.5127085451443624`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intermediate Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511303978642104*^9, 3.5113039899521236`*^9}, 
   3.511320006078973*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIM", "=", "\"\<Cuboid\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sxIM", "=", 
    RowBox[{"40", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"syIM", "=", 
    RowBox[{"12.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"szIM", "=", 
    RowBox[{"30", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIM", "=", 
   RowBox[{"{", 
    RowBox[{"sxIM", ",", "syIM", ",", "szIM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.},
 CellChangeTimes->{{3.511303993103329*^9, 3.5113040028377466`*^9}, {
   3.5113040458002214`*^9, 3.5113040574690423`*^9}, {3.51130410174192*^9, 
   3.511304154002012*^9}, 3.511320006078973*^9, {3.5123558719185033`*^9, 
   3.512355874900674*^9}, {3.5127085520551744`*^9, 3.512708564379196*^9}, {
   3.5141679588366756`*^9, 3.514167965919088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Intermediate Recoil Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10005.},
 CellChangeTimes->{{3.5113041616928253`*^9, 3.511304167308835*^9}, 
   3.51132001576659*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeIRM", "=", "\"\<OpenCuboid\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sxIRM", "=", 
    RowBox[{"60", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"syIRM", "=", 
    RowBox[{"22.5", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"y", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"szIRM", "=", 
    RowBox[{"50", "cm"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", "size"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimIRM", "=", 
   RowBox[{"{", 
    RowBox[{"sxIRM", ",", "syIRM", ",", "szIRM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10005.},
 CellChangeTimes->{{3.5113041691184387`*^9, 3.511304250488181*^9}, 
   3.51132001576659*^9, {3.5123558811200294`*^9, 3.512355883265152*^9}, {
   3.5127085691684046`*^9, 3.512708574753214*^9}, {3.5141679760435057`*^9, 
   3.5141679825643167`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Test Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042574613934`*^9, 3.5113042620946016`*^9}, {
  3.5113200209769993`*^9, 3.51132002713901*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeTM", "=", "\"\<zCylinder\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rTM", "=", 
    RowBox[{"12.5", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lTM", "=", 
    RowBox[{"10", "cm"}]}], ";"}], 
  RowBox[{"(*", "length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimTM", "=", 
   RowBox[{"{", 
    RowBox[{"rTM", ",", "lTM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042642630053`*^9, 3.511304330968723*^9}, 
   3.51132002713901*^9, {3.512708577545619*^9, 3.512708587061636*^9}, {
   3.5141680068535595`*^9, 3.514168107848137*^9}, {3.514510146386544*^9, 
   3.51451014928815*^9}, 3.5145111507163086`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recoil Mass", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10007.},
 CellChangeTimes->{{3.5113043179427*^9, 3.5113043198459034`*^9}, 
   3.511320033597421*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeRM", "=", "\"\<zCylinder\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rRM", "=", 
    RowBox[{"28.9", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"lRM", "=", 
    RowBox[{"20", "cm"}]}], ";"}], 
  RowBox[{"(*", "length", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimRM", "=", 
   RowBox[{"{", 
    RowBox[{"rRM", ",", "lRM"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10007.},
 CellChangeTimes->{{3.511304322747508*^9, 3.511304366006384*^9}, 
   3.511320033597421*^9, 3.511321122916135*^9, {3.5123558431168556`*^9, 
   3.5123558445139356`*^9}, {3.5127085899632406`*^9, 
   3.5127086038784657`*^9}, {3.5127122763553176`*^9, 3.512712276870118*^9}, {
   3.514168124228166*^9, 3.514168190628682*^9}, {3.5145101381497297`*^9, 
   3.5145101529853563`*^9}, 3.5145111514495096`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Magnet Disc", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042574613934`*^9, 3.5113042620946016`*^9}, {
  3.5113200209769993`*^9, 3.51132002713901*^9}, {3.514510126356109*^9, 
  3.5145101281657124`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shapeMD", "=", "\"\<Circle\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rMD", "=", 
    RowBox[{"35.0", "cm"}]}], ";"}], 
  RowBox[{"(*", "radius", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimMD", "=", 
   RowBox[{"{", "rMD", "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.},
 CellChangeTimes->{{3.5113042642630053`*^9, 3.511304330968723*^9}, 
   3.51132002713901*^9, {3.512708577545619*^9, 3.512708587061636*^9}, {
   3.5141680068535595`*^9, 3.514168107848137*^9}, {3.5145101326741204`*^9, 
   3.5145101344057236`*^9}, {3.5145101663389797`*^9, 
   3.5145102013298407`*^9}, {3.514511158875123*^9, 3.5145111616987276`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard body shape & dimension", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10008.},
 CellChangeTimes->{{3.5127087372430997`*^9, 3.512708758178336*^9}, 
   3.5127091283357863`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"shape", "=", 
   RowBox[{"{", 
    RowBox[{
    "shapeF0", ",", "shapeGAS", ",", "shapeGAS", ",", "shapeGAS", ",", 
     "shapeGAS", ",", "shapeIM", ",", "shapeIRM", ",", "shapeTM", ",", 
     "shapeRM", ",", "shapeMD"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim", "=", 
   RowBox[{"{", 
    RowBox[{
    "dimF0", ",", "dimGAS", ",", "dimGAS", ",", "dimGAS", ",", "dimGAS", ",", 
     "dimIM", ",", "dimIRM", ",", "dimTM", ",", "dimRM", ",", "dimMD"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10008.},
 CellChangeTimes->{{3.5127087466967163`*^9, 3.5127088545553055`*^9}, {
   3.5127089173610163`*^9, 3.512708972429113*^9}, 3.5127091283357863`*^9, {
   3.5145102083498535`*^9, 3.514510215026665*^9}, {3.514510680749883*^9, 
   3.514510691607502*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Variables", "Section",
 CellChangeTimes->{{3.5106252414511204`*^9, 3.5106252530107403`*^9}, {
   3.510625426015044*^9, 3.5106254276374474`*^9}, {3.5106259504567657`*^9, 
   3.510625951330367*^9}, 3.510911145254257*^9}],

Cell[CellGroupData[{

Cell["Variable List", "Subsection",
 CellChangeTimes->{{3.510626076005786*^9, 3.510626107814242*^9}, {
  3.510911153662672*^9, 3.5109111566890774`*^9}, {3.510911385167079*^9, 
  3.5109113901902876`*^9}}],

Cell[CellGroupData[{

Cell["Variables Specifying Each Body", "Subsubsection",
 CellChangeTimes->{{3.5109114063519163`*^9, 3.5109114182391367`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"varg", "=", 
    RowBox[{"{", 
     RowBox[{
     "xg", ",", "yg", ",", "zg", ",", "pitchg", ",", "yawg", ",", "rollg"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", "Ground", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF0", "=", 
    RowBox[{"{", 
     RowBox[{"xF0", ",", "zF0", ",", "yawF0"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF1", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF1", ",", "yF1", ",", "zF1", ",", "pitchF1", ",", "yawF1", ",", 
      "rollF1"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF2", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF2", ",", "yF2", ",", "zF2", ",", "pitchF2", ",", "yawF2", ",", 
      "rollF2"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF3", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF3", ",", "yF3", ",", "zF3", ",", "pitchF3", ",", "yawF3", ",", 
      "rollF3"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varF4", "=", 
    RowBox[{"{", 
     RowBox[{
     "xF4", ",", "yF4", ",", "zF4", ",", "pitchF4", ",", "yawF4", ",", 
      "rollF4"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "4"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varIM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xIM", ",", "yIM", ",", "zIM", ",", "pitchIM", ",", "yawIM", ",", 
      "rollIM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varIRM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xIRM", ",", "yIRM", ",", "zIRM", ",", "pitchIRM", ",", "yawIRM", ",", 
      "rollIRM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varTM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xTM", ",", "yTM", ",", "zTM", ",", "pitchTM", ",", "yawTM", ",", 
      "rollTM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Test", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varRM", "=", 
    RowBox[{"{", 
     RowBox[{
     "xRM", ",", "yRM", ",", "zRM", ",", "pitchRM", ",", "yawRM", ",", 
      "rollRM"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varMD", "=", 
    RowBox[{"{", 
     RowBox[{
     "xMD", ",", "yMD", ",", "zMD", ",", "pitchMD", ",", "yawMD", ",", 
      "rollMD"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varKS0", "=", 
    RowBox[{"{", 
     RowBox[{
     "xKS0", ",", "yKS0", ",", "zKS0", ",", "pitchKS0", ",", "yawKS0", ",", 
      "rollKS0"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varKS1", "=", 
    RowBox[{"{", 
     RowBox[{
     "xKS1", ",", "yKS1", ",", "zKS1", ",", "pitchKS1", ",", "yawKS1", ",", 
      "rollKS1"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varKS2", "=", 
    RowBox[{"{", 
     RowBox[{
     "xKS2", ",", "yKS2", ",", "zKS2", ",", "pitchKS2", ",", "yawKS2", ",", 
      "rollKS2"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varKS3", "=", 
    RowBox[{"{", 
     RowBox[{
     "xKS3", ",", "yKS3", ",", "zKS3", ",", "pitchKS3", ",", "yawKS3", ",", 
      "rollKS3"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"varKS4", "=", 
    RowBox[{"{", 
     RowBox[{
     "xKS4", ",", "yKS4", ",", "zKS4", ",", "pitchKS4", ",", "yawKS4", ",", 
      "rollKS4"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "4"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQfe6w/os/6q8cNbIdXoHoNt3tEh0arxyvHfghBaKP
VfFrgmgDUUUDEC00wyEURNtlbQDTJo8+ZW0G0t49ufkgWvFN/TYQ/ez8ETC9
R5I96gaQvmV6Jx5ECwneygPRW+5E5oPoB8kLC28C6XeF24tAtNuM4goQvYcl
rQlEM2zx3wCi/0ZqbwTRQV7VRz8B6W8fP4HpTv7aqyD6n8ZOMC0j/2jBHyBd
NOcFmPZT5bn3F0j/10t9AKLrVsV6/gPSbdFyXiC683RyN4hmm/gJTK9qepkr
p/nKUazTqwBEc/3UCwgA0lGceRkg+taey38Oab1yPLFgEethIL29SHxDqv4r
R5X1XzaCaAC8Jq1p
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["All the Variables & Parameters", "Subsubsection",
 CellChangeTimes->{{3.510911424416748*^9, 3.5109114350559664`*^9}, {
  3.5109114803272457`*^9, 3.510911485444055*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"allparams", "=", 
    RowBox[{"Join", "[", "varg", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allvars", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
     "varF0", ",", "varF1", ",", "varF2", ",", "varF3", ",", "varF4", ",", 
      "\[IndentingNewLine]", "varIM", ",", "varIRM", ",", "varTM", ",", 
      "varRM", ",", "varMD", ",", "\[IndentingNewLine]", "varKS0", ",", 
      "varKS1", ",", "varKS2", ",", "varKS3", ",", "varKS4"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"allfloats", "=", 
    RowBox[{"Join", "[", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5105436285940065`*^9, 3.5105436779524927`*^9}, {
   3.5105505824294252`*^9, 3.510550583427827*^9}, {3.5105609245649977`*^9, 
   3.5105609275602026`*^9}, {3.5106256594538546`*^9, 
   3.5106256981731224`*^9}, {3.51062573105798*^9, 3.5106257692624474`*^9}, {
   3.510626150183916*^9, 3.5106261590603323`*^9}, {3.5106556411248803`*^9, 
   3.510655642092082*^9}, {3.5109113733266582`*^9, 3.510911378552667*^9}, {
   3.5109114473799877`*^9, 3.51091146552282*^9}, {3.5109116508113503`*^9, 
   3.5109116689697824`*^9}, {3.5109119407846594`*^9, 
   3.5109119478358717`*^9}, {3.510999937866187*^9, 3.510999943482197*^9}, {
   3.511075588996784*^9, 3.5110755901199865`*^9}, {3.511075685716954*^9, 
   3.511075686060155*^9}, {3.5110777999846897`*^9, 3.511077809531906*^9}, {
   3.5110778570807896`*^9, 3.511077864069602*^9}, {3.511077912663687*^9, 
   3.51107791422369*^9}, {3.5110782844591403`*^9, 3.5110782845839405`*^9}, {
   3.5111296569725723`*^9, 3.5111296786588125`*^9}, {3.511129758521381*^9, 
   3.5111297593664293`*^9}, {3.5111498442951202`*^9, 
   3.5111498693955646`*^9}, {3.5111523947904005`*^9, 
   3.5111523988152075`*^9}, {3.511153235678677*^9, 3.5111532386738825`*^9}, {
   3.511153792901862*^9, 3.5111537970826693`*^9}, {3.5112190816924467`*^9, 
   3.5112190848436522`*^9}, {3.5113214435902977`*^9, 
   3.5113214588627243`*^9}, {3.511321620947009*^9, 3.5113216299794254`*^9}, 
   3.5113217686324687`*^9, {3.5120804419053493`*^9, 3.512080457505377*^9}, {
   3.514510742650792*^9, 3.5145107448503957`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Velocities", "Subsubsection",
 CellChangeTimes->{{3.5109115271741285`*^9, 3.5109115296233325`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"velparams", "=", 
    RowBox[{"makevel", "[", "allparams", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"velvars", "=", 
    RowBox[{"makevel", "[", "allvars", "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"velfloats", "=", 
    RowBox[{"makevel", "[", "allfloats", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109116827914066`*^9, 3.510911693009424*^9}, {
  3.5109118265768595`*^9, 3.510911843393689*^9}, {3.5109119242330303`*^9, 
  3.5109119576326895`*^9}, {3.511129681916999*^9, 3.511129693044636*^9}, {
  3.511129762019581*^9, 3.5111297628596287`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initial Values", "Subsection",
 CellChangeTimes->{{3.510560357878402*^9, 3.5105603606396074`*^9}, {
  3.510625979738017*^9, 3.5106259827956223`*^9}, {3.510911978505526*^9, 
  3.510911979644328*^9}}],

Cell[CellGroupData[{

Cell["Initial Position & Orientation of Each Body", "Subsubsection",
 CellChangeTimes->{{3.51091199199955*^9, 3.510912024151206*^9}, {
  3.5113222648381405`*^9, 3.5113222658053417`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"lw", "=", 
    RowBox[{"2.1", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"typical", " ", "length", " ", "of", " ", "wires"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.5113219241803417`*^9, 3.511321944241977*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"initg", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", "Ground", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF0", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF1", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"1", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF2", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"2", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF3", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"3", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initF4", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"4", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Filter", " ", "4"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initIM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"5", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initIRM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"5", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Intermediate", " ", "Recoil", " ", "Mass"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initTM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"6", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Test", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initRM", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"6", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initMD", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"lIP", "-", 
       RowBox[{"1", "lw"}]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Recoil", " ", "Mass"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initKS0", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initKS1", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initKS2", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "2"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initKS3", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "3"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initKS4", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    ";"}], 
  RowBox[{"(*", 
   RowBox[{"Key", " ", "Stone", " ", "4"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.510542002925949*^9, 3.5105420494920306`*^9}, {
   3.5105436066915674`*^9, 3.510543608516771*^9}, {3.510543698622529*^9, 
   3.5105437015397344`*^9}, {3.51055031780616*^9, 3.510550319256963*^9}, {
   3.5106259640599895`*^9, 3.510625996414446*^9}, {3.510912034182024*^9, 
   3.510912037130429*^9}, {3.510912170073862*^9, 3.5109122070927277`*^9}, {
   3.5109999557906184`*^9, 3.510999980454262*^9}, {3.511075660164109*^9, 
   3.511075679258543*^9}, {3.5110757102869973`*^9, 3.511075712408601*^9}, {
   3.5110779207601013`*^9, 3.5110779389341335`*^9}, 3.511078289373149*^9, {
   3.5111296990169773`*^9, 3.511129702435173*^9}, {3.5111297677139063`*^9, 
   3.5111297678259125`*^9}, {3.5111524153668365`*^9, 3.511152441465682*^9}, {
   3.5111532486735*^9, 3.5111532518247056`*^9}, {3.5111537772238345`*^9, 
   3.5111537806558404`*^9}, {3.511219101894482*^9, 3.511219113048502*^9}, {
   3.5112290480209055`*^9, 3.5112290640733337`*^9}, {3.511231809771756*^9, 
   3.5112318099277563`*^9}, {3.511321800238124*^9, 3.511321902168703*^9}, {
   3.5113219541479945`*^9, 3.511322052240967*^9}, {3.5120804736046047`*^9, 
   3.5120805006394525`*^9}, {3.514510753976412*^9, 3.5145107588904204`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Default Values of Parameters & Initial Values of Variables and Floats\
\>", "Subsubsection",
 CellChangeTimes->{{3.5109123598637958`*^9, 3.5109123642786036`*^9}, {
  3.510912508001656*^9, 3.510912540184512*^9}, {3.5113222758205595`*^9, 
  3.511322278378964*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"defparams", "=", 
    RowBox[{"Join", "[", "initg", "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initvars", "=", 
    RowBox[{"Join", "[", 
     RowBox[{
     "initF0", ",", "initF1", ",", "initF2", ",", "initF3", ",", "initF4", 
      ",", "\[IndentingNewLine]", "initIM", ",", "initIRM", ",", "initTM", 
      ",", "initRM", ",", "initMD", ",", "\[IndentingNewLine]", "initKS0", 
      ",", "initKS1", ",", "initKS2", ",", "initKS3", ",", "initKS4"}], 
     "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initfloats", "=", 
    RowBox[{"Join", "[", "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.510912583599389*^9, 3.510912631117072*^9}, {
  3.5109188304827647`*^9, 3.5109188378615775`*^9}, {3.5109999852746706`*^9, 
  3.5109999912026806`*^9}, {3.5110757227670193`*^9, 3.511075724280222*^9}, {
  3.511077968542986*^9, 3.511077968683386*^9}, {3.5111297121007257`*^9, 
  3.5111297534580913`*^9}, {3.511149882561988*^9, 3.5111498881779976`*^9}, {
  3.5111532547107105`*^9, 3.5111532656775303`*^9}, {3.51115380350988*^9, 
  3.5111538083926888`*^9}, {3.511219133266137*^9, 3.511219137290944*^9}, {
  3.511322074003005*^9, 3.5113220940958405`*^9}, {3.5120820169675198`*^9, 
  3.512082035406752*^9}, {3.5145107618232255`*^9, 3.51451076408523*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Substitution", "Subsubsection",
 CellChangeTimes->{{3.510913689415735*^9, 3.510913714516179*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"subdefparams", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allparams", ",", "defparams"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Parameters", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"subinitvars", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allvars", ",", "initvars"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Variables", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"subinitfloats", "=", 
    RowBox[{"makesub", "[", 
     RowBox[{"allvars", ",", "initvars"}], "]"}]}], ";"}], 
  RowBox[{"(*", "Floats", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109137313954086`*^9, 3.510913798990327*^9}, {
  3.5111524709497337`*^9, 3.511152475504942*^9}, {3.5111532804195557`*^9, 
  3.511153306814802*^9}, {3.5113221093838673`*^9, 3.5113221168250804`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Position of Bodies", "Subsection",
 CellChangeTimes->{{3.5111299640521364`*^9, 3.5111299739127007`*^9}, {
   3.511215303957964*^9, 3.5112153043635645`*^9}, 3.511219171330204*^9, {
   3.511322411587598*^9, 3.511322413272401*^9}}],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.5113240301528406`*^9, 3.5113240329452457`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posg", "=", "varg"}], ";", 
  RowBox[{"posF0", "=", 
   RowBox[{"{", 
    RowBox[{"xF0", ",", 
     RowBox[{"yg", "+", "lIP"}], ",", "zF0", ",", "pitchg", ",", "yawF0", ",",
      "rollg"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posF1", "=", "varF1"}], ";", 
  RowBox[{"posF2", "=", "varF2"}], ";", 
  RowBox[{"posF3", "=", "varF3"}], ";", 
  RowBox[{"posF4", "=", "varF4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posIM", "=", "varIM"}], ";", 
  RowBox[{"posIRM", "=", "varIRM"}], ";", 
  RowBox[{"posTM", "=", "varTM"}], ";", 
  RowBox[{"posRM", "=", "varRM"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posMD", "=", "varMD"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5110785212363563`*^9, 3.5110785817020626`*^9}, {
   3.511078660653801*^9, 3.5110786610750017`*^9}, {3.5110786937726593`*^9, 
   3.511078720760707*^9}, {3.511078819072079*^9, 3.5110788518009367`*^9}, 
   3.511129970563509*^9, {3.5111345040973763`*^9, 3.5111345247986126`*^9}, {
   3.511139023940115*^9, 3.5111390369505377`*^9}, {3.5111411593030653`*^9, 
   3.5111411653558764`*^9}, {3.5111478027663345`*^9, 
   3.5111478096615467`*^9}, {3.5111479049621143`*^9, 
   3.5111479063817167`*^9}, {3.5111506315505033`*^9, 3.511150631644103*^9}, {
   3.5111539126944723`*^9, 3.5111539127880726`*^9}, {3.5112153117735777`*^9, 
   3.51121536986808*^9}, {3.51121718335091*^9, 3.511217211243759*^9}, {
   3.5112191753238115`*^9, 3.5112192073038673`*^9}, {3.511219240344725*^9, 
   3.5112193137740545`*^9}, {3.5112199675092163`*^9, 3.511220015697701*^9}, {
   3.5112200468197556`*^9, 3.5112200990954475`*^9}, {3.511220139171918*^9, 
   3.5112201564879484`*^9}, {3.511223344655672*^9, 3.5112233853405437`*^9}, {
   3.5112234306586227`*^9, 3.511223499641944*^9}, 3.511223584864894*^9, {
   3.511223625081764*^9, 3.5112238683953915`*^9}, {3.511223913994272*^9, 
   3.511223934586308*^9}, {3.511224317972582*^9, 3.5112243645854635`*^9}, {
   3.511224438295593*^9, 3.5112245600694065`*^9}, {3.511224590973061*^9, 
   3.511224591238261*^9}, 3.511225501827461*^9, {3.5112257523951006`*^9, 
   3.5112257752959414`*^9}, {3.511225857430085*^9, 3.5112258621412935`*^9}, {
   3.5112259063985715`*^9, 3.511225914682186*^9}, {3.511228887559024*^9, 
   3.5112288890878263`*^9}, {3.511228928821096*^9, 3.511228934031505*^9}, {
   3.511229587438653*^9, 3.5112295923682613`*^9}, {3.5112299221528406`*^9, 
   3.5112299244304447`*^9}, {3.5112302659306445`*^9, 3.511230266133445*^9}, {
   3.511230339812374*^9, 3.5112303404519753`*^9}, {3.511322430869232*^9, 
   3.511322506700965*^9}, {3.511322597196724*^9, 3.51132271461813*^9}, {
   3.51132295932016*^9, 3.5113230738555613`*^9}, {3.5113231260064526`*^9, 
   3.5113231777829437`*^9}, {3.511323242959858*^9, 3.51132324969907*^9}, {
   3.5113233113035784`*^9, 3.5113233186355915`*^9}, 3.511323521420347*^9, {
   3.511324086125739*^9, 3.5113241183397956`*^9}, {3.5113875058597193`*^9, 
   3.5113876400667553`*^9}, {3.5113876748080163`*^9, 
   3.5113877253989053`*^9}, {3.5113891555846176`*^9, 3.511389165412635*^9}, {
   3.5114067382148457`*^9, 3.5114067398216486`*^9}, {3.5114068871327076`*^9, 
   3.511406911905551*^9}, {3.5145107753952494`*^9, 3.514510780995659*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Subsubsection",
 CellChangeTimes->{{3.5113240803693295`*^9, 3.511324082022932*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posKS", "=", 
   RowBox[{"{", 
    RowBox[{
    "varKS0", ",", "varKS1", ",", "varKS2", ",", "varKS3", ",", "varKS4"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS0", "=", "varKS0"}], ";", 
  RowBox[{"posKS1", "=", "varKS1"}], ";", 
  RowBox[{"posKS2", "=", "varKS2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"posKS3", "=", "varKS3"}], ";", 
  RowBox[{"posKS4", "=", "varKS4"}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5113240932393513`*^9, 3.511324108652179*^9}, {
  3.511332905806238*^9, 3.5113329127170506`*^9}, {3.5120805139462757`*^9, 
  3.512080541433524*^9}, {3.512080644799306*^9, 3.512080661491335*^9}, {
  3.5120821234065065`*^9, 3.5120821523913574`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["IP Legs", "Subsubsection",
 CellChangeTimes->{{3.5113240364552517`*^9, 3.511324042898063*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posIP", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Join", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"lIPcom", " ", 
            RowBox[{"b2s", "[", 
             RowBox[{"posF0", ",", 
              RowBox[{"legs", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"lIP", "-", "lIPcom"}], ")"}], " ", 
            RowBox[{"b2s", "[", 
             RowBox[{"posg", ",", 
              RowBox[{"legs", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "]"}]}]}], ")"}], "/", 
         "lIP"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"pitchg", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posF0", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posg", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ")"}], "/", "lIP"}]}], ",", 
          "yawg", ",", "\[IndentingNewLine]", 
          RowBox[{"rollg", "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posF0", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"b2s", "[", 
                RowBox[{"posg", ",", 
                 RowBox[{"legs", "[", 
                  RowBox[{"[", "n", "]"}], "]"}]}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "lIP"}]}]}], 
         "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5110785212363563`*^9, 3.5110785817020626`*^9}, {
   3.511078660653801*^9, 3.5110786610750017`*^9}, {3.5110786937726593`*^9, 
   3.511078720760707*^9}, {3.511078819072079*^9, 3.5110788518009367`*^9}, 
   3.511129970563509*^9, {3.5111345040973763`*^9, 3.5111345247986126`*^9}, {
   3.511139023940115*^9, 3.5111390369505377`*^9}, {3.5111411593030653`*^9, 
   3.5111411653558764`*^9}, {3.5111478027663345`*^9, 
   3.5111478096615467`*^9}, {3.5111479049621143`*^9, 
   3.5111479063817167`*^9}, {3.5111506315505033`*^9, 3.511150631644103*^9}, {
   3.5111539126944723`*^9, 3.5111539127880726`*^9}, {3.5112153117735777`*^9, 
   3.51121536986808*^9}, {3.51121718335091*^9, 3.511217211243759*^9}, {
   3.5112191753238115`*^9, 3.5112192073038673`*^9}, {3.511219240344725*^9, 
   3.5112193137740545`*^9}, {3.5112199675092163`*^9, 3.511220015697701*^9}, {
   3.5112200468197556`*^9, 3.5112200990954475`*^9}, {3.511220139171918*^9, 
   3.5112201564879484`*^9}, {3.511223344655672*^9, 3.5112233853405437`*^9}, {
   3.5112234306586227`*^9, 3.511223499641944*^9}, 3.511223584864894*^9, {
   3.511223625081764*^9, 3.5112238683953915`*^9}, {3.511223913994272*^9, 
   3.511223934586308*^9}, {3.511224317972582*^9, 3.5112243645854635`*^9}, {
   3.511224438295593*^9, 3.5112245600694065`*^9}, {3.511224590973061*^9, 
   3.511224591238261*^9}, 3.511225501827461*^9, {3.5112257523951006`*^9, 
   3.5112257752959414`*^9}, {3.511225857430085*^9, 3.5112258621412935`*^9}, {
   3.5112259063985715`*^9, 3.511225914682186*^9}, {3.511228887559024*^9, 
   3.5112288890878263`*^9}, {3.511228928821096*^9, 3.511228934031505*^9}, {
   3.511229587438653*^9, 3.5112295923682613`*^9}, {3.5112299221528406`*^9, 
   3.5112299244304447`*^9}, {3.5112302659306445`*^9, 3.511230266133445*^9}, {
   3.511230339812374*^9, 3.5112303404519753`*^9}, {3.511322430869232*^9, 
   3.511322506700965*^9}, {3.511322597196724*^9, 3.51132271461813*^9}, {
   3.51132295932016*^9, 3.5113230738555613`*^9}, {3.5113231260064526`*^9, 
   3.511323213257406*^9}, 3.511323533588369*^9, {3.511323708027875*^9, 
   3.511323781550804*^9}, {3.511323860096942*^9, 3.5113238703929605`*^9}, {
   3.511323998281985*^9, 3.5113240206992245`*^9}, {3.5113260153655276`*^9, 
   3.511326077141636*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Energy Calculation", "Section",
 CellChangeTimes->{{3.5106262518492947`*^9, 3.5106262674337225`*^9}, {
  3.5109170152635765`*^9, 3.5109170473996325`*^9}}],

Cell[CellGroupData[{

Cell["Body Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}, {3.5109662739308863`*^9, 
  3.51096627628649*^9}}],

Cell[CellGroupData[{

Cell["About bodylist", "Subsubsection",
 CellChangeTimes->{{3.5127269557397323`*^9, 3.51272696006094*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "bodylist"}]], "Input",
 CellChangeTimes->{{3.5127269619485435`*^9, 3.5127269651465487`*^9}}],

Cell[BoxData[
 StyleBox["\<\"bodylist is a list of structures defining bodies. Each \
structure containing the following items:\\n\tcoordinate list defining the \
body,\\n\tmass,\\n\tmoment of inertia tensor,\\n\tshape,\\n\tdimension\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.518835395592121*^9},
 CellTags->"Info3518867795-7951492"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Bodies", "Subsubsection",
 CellChangeTimes->{{3.5113252072217083`*^9, 3.511325209982913*^9}}],

Cell[CellGroupData[{

Cell["Position List", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.512709373490217*^9, 3.5127093777334247`*^9}, 
   3.512709433129122*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"posb", "=", 
    RowBox[{"{", 
     RowBox[{
     "posF0", ",", "posF1", ",", "posF2", ",", "posF3", ",", "posF4", ",", 
      "posIM", ",", "posIRM", ",", "posTM", ",", "posRM", ",", "posMD"}], 
     "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127093809626303`*^9, 3.512709433129122*^9}, {
  3.51451137920271*^9, 3.514511381402314*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Make bodylist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113245884622216`*^9, 3.511324596262235*^9}, {
  3.511324730375671*^9, 3.5113247350088787`*^9}, {3.512709437309929*^9, 
  3.512709445343943*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"bodylist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"posb", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"mass", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"moix", "[", 
             RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"moiy", "[", 
             RowBox[{"[", "n", "]"}], "]"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"moiz", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"(*", 
         RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"shape", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], 
        RowBox[{"dim", "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], 
       RowBox[{"(*", 
        RowBox[{"size", " ", "information"}], "*)"}], "\[IndentingNewLine]", 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "mass", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.5109662907321157`*^9, 
   3.510966396843502*^9}, {3.510967091044721*^9, 3.510967168249257*^9}, {
   3.5109955112540817`*^9, 3.5109955697864294`*^9}, {3.510997044967098*^9, 
   3.5109970462151003`*^9}, {3.5110002784771852`*^9, 
   3.5110003227344627`*^9}, {3.511000359144927*^9, 3.5110003704549465`*^9}, {
   3.511078476823078*^9, 3.511078512422341*^9}, 3.5111541017668047`*^9, {
   3.5112152637410936`*^9, 3.511215297234352*^9}, {3.511217240369011*^9, 
   3.511217254159435*^9}, {3.5112246532795706`*^9, 3.5112248007154293`*^9}, {
   3.51122485224232*^9, 3.5112249190416374`*^9}, {3.5112249915817647`*^9, 
   3.511225023593021*^9}, {3.5112253387915745`*^9, 3.5112253422859807`*^9}, {
   3.5112260225719757`*^9, 3.5112260227123756`*^9}, {3.511226094581702*^9, 
   3.5112260955489035`*^9}, {3.5113242138899636`*^9, 3.511324447937175*^9}, 
   3.511324596262235*^9, {3.511324730375671*^9, 3.5113247350088787`*^9}, 
   3.5113247888913736`*^9, {3.5127093008876896`*^9, 3.5127093655186033`*^9}, {
   3.5127094492907505`*^9, 3.5127095235312805`*^9}, {3.512710355012741*^9, 
   3.512710367024762*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Others", "Subsubsection",
 CellChangeTimes->{{3.5113252238201375`*^9, 3.5113252269869432`*^9}}],

Cell[CellGroupData[{

Cell["IP legs", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511325457602148*^9, 3.511325459318151*^9}, {
   3.5113261912558365`*^9, 3.5113261928626394`*^9}, 3.5113263166800566`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"bodylist", "=", "\[IndentingNewLine]", 
    RowBox[{"Join", "[", 
     RowBox[{"bodylist", ",", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"posIP", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "coordinate", "*)"}], 
          RowBox[{"massIP", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"moixIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"moiyIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"moizIP", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
          "\[IndentingNewLine]", "shapeIP", ",", 
          RowBox[{"(*", 
           RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], "dimIP"}], 
         RowBox[{"(*", 
          RowBox[{"size", " ", "information"}], "*)"}], "}"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113254642633595`*^9, 3.511325475089779*^9}, {
   3.5113255496423097`*^9, 3.511325704066981*^9}, {3.5113258654336643`*^9, 
   3.5113258688032703`*^9}, {3.5113261974490476`*^9, 3.5113262249050956`*^9}, 
   3.511326277367988*^9, 3.5113263166800566`*^9, {3.5127095530309324`*^9, 
   3.5127095542165346`*^9}, 3.5127266436143837`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ground", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511325241245368*^9, 3.511325249388582*^9}, 
   3.5113253530819645`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"showground", ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"bodylist", ",", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posg", ",", 
          RowBox[{"(*", "coordinate", "*)"}], "0", ",", 
          RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
          "\[IndentingNewLine]", "shapeg", ",", 
          RowBox[{"(*", 
           RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], "dimg"}], 
         RowBox[{"(*", 
          RowBox[{"size", " ", "information"}], "*)"}], "}"}]}], "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113252534913893`*^9, 3.5113253530819645`*^9}, {
  3.512709563763751*^9, 3.5127095645437527`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Key Stones", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511325241245368*^9, 3.511325249388582*^9}, {
   3.5113253530819645`*^9, 3.5113253677459903`*^9}, 3.5113254448569255`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"bodylist", "=", "\[IndentingNewLine]", 
    RowBox[{"Join", "[", 
     RowBox[{"bodylist", ",", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"posKS", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "coordinate", "*)"}], 
          RowBox[{"massKS", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", "mass", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"moixKS", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0", ",", "0"}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"moiyKS", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", 
              RowBox[{"moizKS", "[", 
               RowBox[{"[", "n", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
          RowBox[{"(*", 
           RowBox[{"moment", " ", "of", " ", "inertia"}], "*)"}], 
          "\[IndentingNewLine]", "shapeKS", ",", 
          RowBox[{"(*", 
           RowBox[{"type", " ", "of", " ", "shape"}], "*)"}], 
          RowBox[{"{", 
           RowBox[{"rKS", ",", "hKS"}], "}"}]}], 
         RowBox[{"(*", 
          RowBox[{"size", " ", "information"}], "*)"}], "}"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "5"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113252534913893`*^9, 3.5113254448569255`*^9}, {
   3.511325483295393*^9, 3.5113254856821976`*^9}, {3.512080575987585*^9, 
   3.5120805829139967`*^9}, {3.5120806190124607`*^9, 3.512080633614086*^9}, {
   3.5120806710541515`*^9, 3.512080697246598*^9}, 3.5145108477481766`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wire Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}}],

Cell[CellGroupData[{

Cell["About wirelist", "Subsubsection",
 CellChangeTimes->{{3.512726995441802*^9, 3.51272700010621*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "wirelist"}]], "Input",
 CellChangeTimes->{{3.5127270107922287`*^9, 3.512727011993431*^9}}],

Cell[BoxData[
 StyleBox["\<\"wirelist is a list of structures defining wires. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tattachment point for first mass (local coordinates),\\n\tcoordinate \
list defining second mass,\\n\tattachment point for second mass (local \
coordinates),\\n\tunstretched length,\\n\tlongitudinal elasticity,\\n\tloss \
angle of the material,\\n\tshear modulus of the material,\\n\tsecond moment \
of area\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5188353958417215`*^9},
 CellTags->"Info3518867795-8101306"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making wirelist", "Subsubsection",
 CellChangeTimes->{{3.5127270034446163`*^9, 3.51272700581582*^9}}],

Cell[CellGroupData[{

Cell["Coordinate list of wire-attaching bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5113271026756425`*^9, 3.5113271134708614`*^9}, {
   3.511327177774174*^9, 3.5113271910185976`*^9}, 3.511327439480234*^9, 
   3.51271000708533*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"posub", "=", 
   RowBox[{"{", 
    RowBox[{
    "posKS0", ",", "posKS1", ",", "posKS2", ",", "posKS3", ",", "posKS4", ",",
      "posF4", ",", "posIM", ",", "posIM", ",", "posF0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poslb", "=", 
   RowBox[{"{", 
    RowBox[{
    "posF1", ",", "posF2", ",", "posF3", ",", "posF4", ",", "posIM", ",", 
     "posIRM", ",", "posTM", ",", "posRM", ",", "posMD"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511327117714069*^9, 3.5113272142158384`*^9}, 
   3.511327439480234*^9, {3.512710003122923*^9, 3.51271000708533*^9}, {
   3.5145113632906823`*^9, 3.514511369530693*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making wirelist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113264636323147`*^9, 3.511326468936324*^9}, 
   3.511326909453703*^9, {3.5113272309858675`*^9, 3.51132723226507*^9}, {
   3.5113274460322456`*^9, 3.5113274471086473`*^9}, {3.5113277295939436`*^9, 
   3.5113277327919493`*^9}, {3.5127270146298356`*^9, 3.512727014754636*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"wirelist", "=", "\[IndentingNewLine]", 
    RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"posub", "[", 
           RowBox[{"[", "m", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "defining", " ", "upper", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"spu", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "attachment", " ", "point", " ", "at", " ", "upper", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"poslb", "[", 
           RowBox[{"[", "m", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "defining", " ", "lower", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"spl", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "attachment", " ", "point", " ", "at", " ", "lower", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"lNw", "[", 
           RowBox[{"[", 
            RowBox[{"m", ",", "n"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{"Natural", " ", "Length"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"N", "[", "Pi", "]"}], 
           SuperscriptBox[
            RowBox[{"dw", "[", 
             RowBox[{"[", 
              RowBox[{"m", ",", "n"}], "]"}], "]"}], "2"], 
           RowBox[{
            RowBox[{
             RowBox[{"young", "[", 
              RowBox[{"matw", "[", 
               RowBox[{"[", "m", "]"}], "]"}], "]"}], "/", 
             RowBox[{"lNw", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}]}], "/", "4"}]}], ",", 
          RowBox[{"(*", "Stiffness", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"phi", "[", 
           RowBox[{"matw", "[", 
            RowBox[{"[", "m", "]"}], "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{"loss", " ", "angle"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"young", "[", 
             RowBox[{"matw", "[", 
              RowBox[{"[", "m", "]"}], "]"}], "]"}], "/", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"poisson", "[", 
              RowBox[{"matw", "[", 
               RowBox[{"[", "m", "]"}], "]"}], "]"}]}], ")"}]}], ",", 
          RowBox[{"(*", 
           RowBox[{"shear", " ", "modulus"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"N", "[", "Pi", "]"}], 
           RowBox[{
            SuperscriptBox[
             RowBox[{"dw", "[", 
              RowBox[{"[", 
               RowBox[{"m", ",", "n"}], "]"}], "]"}], "4"], "/", "32"}]}]}], 
         "}"}], ",", 
        RowBox[{"(*", 
         RowBox[{"second", " ", "moment", " ", "of", " ", "area"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "nw", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"nw", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
       "]"}], ",", "1"}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.511000024399539*^9, 
   3.5110000885468516`*^9}, {3.5110001243021145`*^9, 3.51100016160178*^9}, {
   3.5110001988390455`*^9, 3.5110002427687225`*^9}, {3.511001607649932*^9, 
   3.511001780966236*^9}, {3.5111538584687767`*^9, 3.511153869965997*^9}, {
   3.511155069015303*^9, 3.511155069842105*^9}, {3.5112246193027105`*^9, 
   3.511224643903954*^9}, {3.5112258457456646`*^9, 3.5112258461824656`*^9}, {
   3.5112259909039197`*^9, 3.511226005833146*^9}, {3.5113264112630234`*^9, 
   3.5113264144922285`*^9}, {3.5113264759095364`*^9, 
   3.5113266364338183`*^9}, {3.5113267140789595`*^9, 3.511326734109395*^9}, {
   3.511326898596084*^9, 3.511326924086529*^9}, {3.511327235587876*^9, 
   3.5113272773335495`*^9}, {3.511327366737306*^9, 3.511327419044198*^9}, {
   3.5113275248903837`*^9, 3.5113275334391985`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring Definition", "Subsection",
 CellChangeTimes->{{3.5109140124455023`*^9, 3.51091404542396*^9}, {
  3.5109169162814026`*^9, 3.5109169184810066`*^9}, {3.5109662739308863`*^9, 
  3.51096627628649*^9}, {3.5110788859025965`*^9, 3.5110788867761984`*^9}}],

Cell[CellGroupData[{

Cell["About springlist", "Subsubsection",
 CellChangeTimes->{{3.5127270198558445`*^9, 3.512727025378255*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "springlist"}]], "Input",
 CellChangeTimes->{{3.5127270268134575`*^9, 3.5127270288258605`*^9}}],

Cell[BoxData[
 StyleBox["\<\"springlist is a list of structures defining GAS springs. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tworking point at first mass (local coordinate)\\n\tcoordinate list \
defining second mass,\\n\tattached point at second mass (local coordinate)\\n\
\tspring constant tensor (6x6),\\n\tstoring force element vector (6x1),\\n\t\
spring constant tensor with imaginary part (6x6)\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.518835396153722*^9},
 CellTags->"Info3518867796-2584648"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making springlist", "Subsubsection",
 CellChangeTimes->{{3.512727031540265*^9, 3.51272703420787*^9}}],

Cell[CellGroupData[{

Cell["Coordinate list of spring-attaching bodies", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113271026756425`*^9, 3.5113271134708614`*^9}, {
   3.511327177774174*^9, 3.5113271910185976`*^9}, 3.511327439480234*^9, {
   3.511327661250223*^9, 3.511327663059827*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"poss1", "=", 
   RowBox[{"{", 
    RowBox[{"posF0", ",", "posF1", ",", "posF2", ",", "posF3", ",", "posF4"}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"poss2", "=", 
   RowBox[{"{", 
    RowBox[{
    "posKS0", ",", "posKS1", ",", "posKS2", ",", "posKS3", ",", "posKS4"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511327117714069*^9, 3.5113272142158384`*^9}, 
   3.511327439480234*^9, {3.5113276571162157`*^9, 3.5113277233539324`*^9}, 
   3.5113277842408395`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making springlist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511327747565175*^9, 3.5113277509503813`*^9}, 
   3.5113280529669113`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"springlist", "=", "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"(*", "GAS", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"poss1", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{
         "coordinate", " ", "list", " ", "defining", " ", "first", " ", 
          "body"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"wpGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"working", " ", "point", " ", 
          RowBox[{"(", 
           RowBox[{"first", " ", "body", " ", "coordinate"}], ")"}]}], "*)"}],
         "\[IndentingNewLine]", 
        RowBox[{"poss2", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{
         "coordinate", " ", "list", " ", "defining", " ", "second", " ", 
          "body"}], "*)"}], "\[IndentingNewLine]", "posCOM", ",", 
        RowBox[{"(*", 
         RowBox[{"attachment", " ", "point", " ", 
          RowBox[{"(", 
           RowBox[{"second", " ", "body", " ", "coordinate"}], ")"}]}], 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"matkGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"spring", " ", "constant", " ", "tensor"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"vecfGAS", "[", 
         RowBox[{"[", "n", "]"}], "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"storing", " ", "force", " ", "vector"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"matkGASc", "[", 
         RowBox[{"[", "n", "]"}], "]"}]}], 
       RowBox[{"(*", 
        RowBox[{
        "spring", " ", "constant", " ", "tensor", " ", "with", " ", 
         "imaginary", " ", "part"}], "*)"}], "\[IndentingNewLine]", "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"Length", "[", "poss1", "]"}]}], "}"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5109140609147873`*^9, 3.5109140779968176`*^9}, {
   3.5109141081360703`*^9, 3.5109142185842648`*^9}, {3.5109143213572445`*^9, 
   3.5109145997085333`*^9}, 3.510917211730322*^9, {3.5109176320262594`*^9, 
   3.5109176547555*^9}, 3.510917743488456*^9, {3.5109662907321157`*^9, 
   3.510966396843502*^9}, {3.510967091044721*^9, 3.510967168249257*^9}, {
   3.5109955112540817`*^9, 3.5109955697864294`*^9}, {3.510997044967098*^9, 
   3.5109970462151003`*^9}, {3.5110002784771852`*^9, 
   3.5110003227344627`*^9}, {3.511000359144927*^9, 3.5110003704549465`*^9}, {
   3.511078476823078*^9, 3.511078512422341*^9}, {3.511078893874211*^9, 
   3.5110789163538504`*^9}, {3.5111301717180142`*^9, 
   3.5111302177266455`*^9}, {3.511130264499321*^9, 3.5111303154552355`*^9}, {
   3.5111303524563518`*^9, 3.511130387641364*^9}, {3.5111305329186735`*^9, 
   3.5111305565030227`*^9}, {3.5111306659992857`*^9, 
   3.5111307500230913`*^9}, {3.5111310998197966`*^9, 3.51113113022425*^9}, 
   3.511132179263693*^9, {3.511134281157385*^9, 3.511134313043841*^9}, {
   3.511134822821536*^9, 3.511134849169983*^9}, 3.51113914042552*^9, 
   3.5111393361746635`*^9, {3.51113936804552*^9, 3.5111393805567417`*^9}, {
   3.5111525121650066`*^9, 3.5111525123522067`*^9}, {3.511154131282056*^9, 
   3.51115413343486*^9}, {3.5112291050234056`*^9, 3.511229108252611*^9}, {
   3.511327629769368*^9, 3.5113276327957735`*^9}, {3.5113277552715883`*^9, 
   3.511327803865674*^9}, {3.51132798381199*^9, 3.511327991175203*^9}, {
   3.511328024902462*^9, 3.5113280529669113`*^9}, {3.512726923057675*^9, 
   3.5127269360212975`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damper Definition", "Subsection",
 CellChangeTimes->{{3.511388575091998*^9, 3.51138859902244*^9}}],

Cell[CellGroupData[{

Cell["About damperlist", "Subsubsection",
 CellChangeTimes->{{3.512727052319502*^9, 3.5127270548623066`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "damperlist"}]], "Input",
 CellChangeTimes->{{3.5127270626779203`*^9, 3.5127270641287227`*^9}}],

Cell[BoxData[
 StyleBox["\<\"damperlist is is a list of structures defining dampers. Each \
structure containing the following items:\\n\tcoordinate list defining first \
mass,\\n\tcoordinate list defining second mass,\\n\tdamping coefficient \
matrix (6x6)\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.518835396387722*^9},
 CellTags->"Info3518867796-7320688"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making damperlist", "Subsubsection",
 CellChangeTimes->{{3.5127270573115106`*^9, 3.5127270610087175`*^9}}],

Cell[CellGroupData[{

Cell["Making damperlist", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113885915032268`*^9, 3.5113885957776346`*^9}, 
   3.511388709876235*^9, {3.5127270675607285`*^9, 3.5127270704467335`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"damperlist", "=", "\[IndentingNewLine]", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"posMD", ",", 
       RowBox[{"(*", 
        RowBox[{
        "coordinate", " ", "list", " ", "defining", " ", "first", " ", 
         "body"}], "*)"}], "\[IndentingNewLine]", "posF1", ",", 
       RowBox[{"(*", 
        RowBox[{
        "coordinate", " ", "list", " ", "defining", " ", "second", " ", 
         "body"}], "*)"}], "\[IndentingNewLine]", "dampMD"}], 
      RowBox[{"(*", 
       RowBox[{"damping", " ", "coefficient", " ", "matrix"}], "*)"}], 
      "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "}"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511388612048463*^9, 3.511388709876235*^9}, {
  3.511389274160426*^9, 3.511389300805273*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Potential Energy Calculation", "Subsection",
 CellChangeTimes->{{3.510560448249361*^9, 3.510560448670562*^9}, {
  3.5106264014535575`*^9, 3.510626411702776*^9}, {3.5109166230008874`*^9, 
  3.510916633390506*^9}, {3.510917225723546*^9, 3.510917232306758*^9}}],

Cell[CellGroupData[{

Cell["Wire Stretching Potential", "Subsubsection",
 CellChangeTimes->{{3.511219454212905*^9, 3.511219459080114*^9}, {
  3.5113282965753393`*^9, 3.511328305264555*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"wirepot", "=", 
    RowBox[{"makewirepot", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"wirepotc", "=", 
    RowBox[{"makewirepotc", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510542091144104*^9, 3.510542093936509*^9}, {
   3.510542888481906*^9, 3.5105428899327087`*^9}, {3.510542932146383*^9, 
   3.5105429338311863`*^9}, {3.5105434500672927`*^9, 3.510543476493739*^9}, {
   3.510543521063017*^9, 3.5105435385974483`*^9}, {3.5105435839311275`*^9, 
   3.5105435894847374`*^9}, {3.510545463687629*^9, 3.5105454866664696`*^9}, {
   3.5105498942966166`*^9, 3.510550005088011*^9}, {3.5105505425245547`*^9, 
   3.5105505701990037`*^9}, {3.5105506566075554`*^9, 3.510550672535183*^9}, {
   3.5105509738653126`*^9, 3.5105509743645134`*^9}, {3.510551048137043*^9, 
   3.5105511440304117`*^9}, 3.510557050919793*^9, 3.5105572108200736`*^9, 
   3.5105577896122904`*^9, 3.510557847488392*^9, {3.5105583630068974`*^9, 
   3.510558405704172*^9}, {3.5105608134148026`*^9, 3.510560853085672*^9}, 
   3.5105608836617255`*^9, {3.5106264247287984`*^9, 3.5106264690796766`*^9}, {
   3.5109166369473124`*^9, 3.510916652516139*^9}, {3.510916956872674*^9, 
   3.510916976934309*^9}, {3.5109172133839245`*^9, 3.510917261400809*^9}, {
   3.51091783730702*^9, 3.5109178806750965`*^9}, 3.511002137801263*^9, {
   3.5111411385862293`*^9, 3.5111411749810934`*^9}, 3.511141210159155*^9, {
   3.5111541843533497`*^9, 3.5111541968957715`*^9}, {3.5112194905765696`*^9, 
   3.5112195044761934`*^9}, {3.5113282322408266`*^9, 3.511328247341653*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wire Torsional Potential", "Subsubsection",
 CellChangeTimes->{{3.511328281521313*^9, 3.511328293689335*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"torsionpot", "=", 
    RowBox[{"maketorsionpot", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"torsionpotc", "=", 
    RowBox[{"maketorsionpotc", "[", "wirelist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511002097319192*^9, 3.511002109783613*^9}, 
   3.5110021423564706`*^9, {3.5110022020421753`*^9, 3.5110022106377907`*^9}, {
   3.5110034113562994`*^9, 3.5110034150379057`*^9}, {3.511233156981127*^9, 
   3.5112331628935375`*^9}, {3.511328253441264*^9, 3.511328271802496*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spring Potential", "Subsubsection",
 CellChangeTimes->{{3.5112195186878185`*^9, 3.511219521293023*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"springpot", "=", 
    RowBox[{"makespringpot", "[", "springlist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"only", " ", "real", " ", "part"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"springpotc", "=", 
    RowBox[{"makespringpotc", "[", "springlist", "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"with", " ", "imaginary", " ", "part"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510542091144104*^9, 3.510542093936509*^9}, {
   3.510542888481906*^9, 3.5105428899327087`*^9}, {3.510542932146383*^9, 
   3.5105429338311863`*^9}, {3.5105434500672927`*^9, 3.510543476493739*^9}, {
   3.510543521063017*^9, 3.5105435385974483`*^9}, {3.5105435839311275`*^9, 
   3.5105435894847374`*^9}, {3.510545463687629*^9, 3.5105454866664696`*^9}, {
   3.5105498942966166`*^9, 3.510550005088011*^9}, {3.5105505425245547`*^9, 
   3.5105505701990037`*^9}, {3.5105506566075554`*^9, 3.510550672535183*^9}, {
   3.5105509738653126`*^9, 3.5105509743645134`*^9}, {3.510551048137043*^9, 
   3.5105511440304117`*^9}, 3.510557050919793*^9, 3.5105572108200736`*^9, 
   3.5105577896122904`*^9, 3.510557847488392*^9, {3.5105583630068974`*^9, 
   3.510558405704172*^9}, {3.5105608134148026`*^9, 3.510560853085672*^9}, 
   3.5105608836617255`*^9, {3.5106264247287984`*^9, 3.5106264690796766`*^9}, {
   3.5109166369473124`*^9, 3.510916652516139*^9}, {3.510916956872674*^9, 
   3.510916976934309*^9}, {3.5109172133839245`*^9, 3.510917261400809*^9}, {
   3.51091783730702*^9, 3.5109178806750965`*^9}, 3.511002137801263*^9, {
   3.5111301323777637`*^9, 3.511130142680353*^9}, {3.5111389035391035`*^9, 
   3.511138929201149*^9}, {3.511139340261871*^9, 3.511139364129913*^9}, 
   3.511139422817216*^9, {3.51114012523965*^9, 3.511140134584066*^9}, {
   3.5111409838339577`*^9, 3.5111409926791735`*^9}, {3.5111542019033804`*^9, 
   3.5111542101869946`*^9}, {3.5113283226741858`*^9, 3.5113283456218257`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravity Potential", "Subsubsection",
 CellChangeTimes->{{3.511219530216239*^9, 3.511219534256646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"gravpot", "=", 
    RowBox[{"makegravpot", "[", "bodylist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109172647548146`*^9, 3.5109172699028234`*^9}, {
   3.510966585884634*^9, 3.5109665906738424`*^9}, {3.5109669988485594`*^9, 
   3.5109670018593645`*^9}, 3.5110021586428995`*^9, {3.511227259181363*^9, 
   3.5112272796485996`*^9}, 3.5113283557930436`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pre-isolator Potential", "Subsubsection",
 CellChangeTimes->{{3.511219540668257*^9, 3.511219544100263*^9}, {
  3.5113283658706617`*^9, 3.5113283754646783`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"stagepot", "=", 
   RowBox[{"Sum", "[", 
    RowBox[{"(*", 
     RowBox[{"only", " ", "real", " ", "part"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], 
      RowBox[{"kIP", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "\[IndentingNewLine]", 
      RowBox[{"sqvec", "[", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"b2s", "[", 
           RowBox[{"posF0", ",", 
            RowBox[{"legs", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], "-", 
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"b2s", "[", 
           RowBox[{"varg", ",", 
            RowBox[{"legs", "[", 
             RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
     ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5112253941092715`*^9, 3.5112254401917524`*^9}, {
  3.511226123729353*^9, 3.5112262481551714`*^9}, {3.511226299089261*^9, 
  3.5112264040462456`*^9}, {3.51122692699438*^9, 3.511227022154547*^9}, {
  3.5112272102284775`*^9, 3.511227226967307*^9}, {3.5113283815798893`*^9, 
  3.5113285014660997`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"stagepotc", "=", 
    RowBox[{"Sum", "[", 
     RowBox[{"(*", 
      RowBox[{"with", " ", "imaginary", " ", "part"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], 
       RowBox[{"kIPc", "[", 
        RowBox[{"[", "n", "]"}], "]"}], "\[IndentingNewLine]", 
       RowBox[{"sqvec", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"b2s", "[", 
            RowBox[{"posF0", ",", 
             RowBox[{"legs", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}], "-", 
         RowBox[{"Drop", "[", 
          RowBox[{
           RowBox[{"b2s", "[", 
            RowBox[{"varg", ",", 
             RowBox[{"legs", "[", 
              RowBox[{"[", "n", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]",
       ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5112253941092715`*^9, 3.5112254401917524`*^9}, {
   3.511226123729353*^9, 3.5112262481551714`*^9}, {3.511226299089261*^9, 
   3.51122644098711*^9}, {3.511227242021333*^9, 3.511227245328539*^9}, {
   3.51123169247515*^9, 3.511231712162385*^9}, 3.5113283904563046`*^9, {
   3.511328469408043*^9, 3.5113285071133094`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Total", "Subsubsection",
 CellChangeTimes->{{3.511219549981474*^9, 3.511219550652275*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"potential", "=", 
   RowBox[{
   "wirepot", "+", "gravpot", "+", "torsionpot", "+", "springpot", "+", 
    "stagepot"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"potentialc", "=", 
   RowBox[{
   "wirepotc", "+", "gravpot", "+", "torsionpot", "+", "springpotc", "+", 
    "stagepotc"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109172740680313`*^9, 3.5109172945196667`*^9}, 
   3.5109179087707458`*^9, 3.5110004500306864`*^9, {3.5110004867843513`*^9, 
   3.5110005204336104`*^9}, 3.5110021501720843`*^9, {3.5110022152553988`*^9, 
   3.5110022192646055`*^9}, {3.5111433491457124`*^9, 3.511143363653738*^9}, {
   3.511152543224661*^9, 3.511152549573872*^9}, {3.511226445838719*^9, 
   3.511226472530366*^9}, {3.5113289728677273`*^9, 3.511328987375753*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kinetic Energy Calculation", "Subsection",
 CellChangeTimes->{{3.51091730216368*^9, 3.510917310494095*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"kinetic", "=", 
    RowBox[{"makekinetic", "[", "bodylist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510917352099368*^9, 3.510917508349242*^9}, {
   3.5109668339562693`*^9, 3.51096683429947*^9}, {3.5109669425480604`*^9, 
   3.5109669488504715`*^9}, 3.510967004105768*^9, 3.510967051093051*^9, {
   3.511000390828583*^9, 3.511000401436601*^9}, {3.51114029066234*^9, 
   3.511140299008355*^9}, {3.5111504745986276`*^9, 3.5111504779058332`*^9}, {
   3.511227322049474*^9, 3.511227329007086*^9}}],

Cell[CellGroupData[{

Cell["Center of Percussion Effect", "Subsubsection",
 CellChangeTimes->{{3.518827663061779*^9, 3.518827670705792*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kinetic", "+=", 
   RowBox[{"vyKS0", " ", "vyF0", " ", 
    RowBox[{"miGAS", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kinetic", "+=", 
   RowBox[{"vyKS1", " ", "vyF1", " ", 
    RowBox[{"miGAS", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kinetic", "+=", 
   RowBox[{"vyKS2", " ", "vyF2", " ", 
    RowBox[{"miGAS", "[", 
     RowBox[{"[", "3", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kinetic", "+=", 
   RowBox[{"vyKS3", " ", "vyF3", " ", 
    RowBox[{"miGAS", "[", 
     RowBox[{"[", "4", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kinetic", "+=", 
   RowBox[{"vyKS4", " ", "vyF4", " ", 
    RowBox[{"miGAS", "[", 
     RowBox[{"[", "5", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{3.5145108979022646`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping Energy Calculation", "Subsection",
 CellChangeTimes->{{3.5113890192871785`*^9, 3.5113890229843845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"damping", "=", 
    RowBox[{"makedamping", "[", "damperlist", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5113890305347977`*^9, 3.511389047632428*^9}, {
  3.511389361348979*^9, 3.5113893730333996`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Find Equilibrium Point", "Section",
 CellChangeTimes->{{3.5106265435854073`*^9, 3.5106265504962196`*^9}, 
   3.5106554796021967`*^9}],

Cell[CellGroupData[{

Cell["Potential with Default Values of Parameters", "Subsection",
 CellChangeTimes->{{3.5106268136062813`*^9, 3.5106268456331377`*^9}, {
  3.510627087792363*^9, 3.5106271045155926`*^9}, {3.510917973136459*^9, 
  3.510917992106092*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"potential0", "=", 
    RowBox[{"potential", "/.", "subdefparams"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5105539888460145`*^9, 3.510554070636958*^9}, {
   3.510554121430648*^9, 3.5105542109124045`*^9}, 3.5105546485935736`*^9, {
   3.5105546974216595`*^9, 3.510554704051671*^9}, {3.5105571731928077`*^9, 
   3.5105571828960247`*^9}, 3.51055786907883*^9, 3.510557938810952*^9, {
   3.5105584149237885`*^9, 3.5105584273414106`*^9}, {3.510559192210754*^9, 
   3.5105592145655932`*^9}, {3.510560255901023*^9, 3.5105602574922256`*^9}, {
   3.5105606405976987`*^9, 3.51056068084577*^9}, 3.5105607235898447`*^9, 
   3.5105611168353353`*^9, {3.5106265647702446`*^9, 3.5106265760490646`*^9}, {
   3.510627120958021*^9, 3.51062714858567*^9}, {3.5106273594512405`*^9, 
   3.5106273673448544`*^9}, {3.5106274131777344`*^9, 3.510627420806148*^9}, {
   3.510636250108863*^9, 3.5106362563176737`*^9}, {3.5106557863611355`*^9, 
   3.51065579467595*^9}, {3.5108253325205708`*^9, 3.5108253359993763`*^9}, {
   3.5109179503760185`*^9, 3.5109179592680345`*^9}, {3.5109180139149303`*^9, 
   3.510918040434977*^9}, 3.5109183532935266`*^9, 3.510918580757526*^9, 
   3.510918631816416*^9, 3.51091887893645*^9, {3.511150554049567*^9, 
   3.5111505637215843`*^9}, {3.511150600678049*^9, 3.5111506134388714`*^9}, 
   3.511154234382637*^9, 3.5111613806292715`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Find Equilibrium Point", "Subsection",
 CellChangeTimes->{{3.5106274478565955`*^9, 3.510627536183951*^9}, 
   3.510655478166994*^9}],

Cell["Find optimal values that make the potential energy minimum.", "Text",
 CellChangeTimes->{{3.510627542611162*^9, 3.5106275966652565`*^9}, {
   3.5109180810106487`*^9, 3.510918084910655*^9}, {3.5109182507701464`*^9, 
   3.510918255060154*^9}, 3.510975865186532*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"subminvars", "=", 
  RowBox[{
   RowBox[{"FindMinimum", "[", "\[IndentingNewLine]", 
    RowBox[{"potential0", ",", "\[IndentingNewLine]", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"comb", "[", 
        RowBox[{"allvars", ",", "initvars"}], "]"}], ",", 
       RowBox[{"comb", "[", 
        RowBox[{"allfloats", ",", "initfloats"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"MaxIterations", "\[Rule]", "100"}]}], "\[IndentingNewLine]", 
    "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.51055781213873*^9, 3.510557830281562*^9}, {
   3.510557969761407*^9, 3.5105579803850255`*^9}, {3.510558511285158*^9, 
   3.510558539942408*^9}, {3.5105590865985684`*^9, 3.5105591272054396`*^9}, {
   3.510559279305707*^9, 3.510559289632925*^9}, 3.5105605175134826`*^9, 
   3.51056060141043*^9, {3.510560695213395*^9, 3.5105606957281957`*^9}, 
   3.5105609712558794`*^9, 3.510561120158141*^9, {3.510627334818797*^9, 
   3.510627350855625*^9}, {3.5106274406493826`*^9, 3.510627443504188*^9}, 
   3.510627615010889*^9, {3.5106295313562555`*^9, 3.5106295448814793`*^9}, 
   3.5106361885199547`*^9, 3.51063623703604*^9, {3.510636431164381*^9, 
   3.5106364370455914`*^9}, {3.510655802725564*^9, 3.5106558188091927`*^9}, 
   3.510655856608059*^9, {3.510655900756136*^9, 3.510655922518174*^9}, 
   3.510918005334915*^9, {3.510918228306107*^9, 3.510918233828517*^9}, {
   3.5109182690221786`*^9, 3.5109182811278*^9}, {3.511004376030794*^9, 
   3.5110044189620695`*^9}, {3.5110044623613453`*^9, 3.511004473421765*^9}, {
   3.5111403358556194`*^9, 3.5111403660104723`*^9}, {3.5111412252287817`*^9, 
   3.511141227818386*^9}, 3.5111413265977592`*^9, {3.5111413751606445`*^9, 
   3.5111414888988447`*^9}, {3.5111549058546166`*^9, 3.5111549297538586`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"xF0", "\[Rule]", 
    RowBox[{"-", "1.458593583178984`*^-37"}]}], ",", 
   RowBox[{"zF0", "\[Rule]", "1.5443932057192856`*^-37"}], ",", 
   RowBox[{"yawF0", "\[Rule]", 
    RowBox[{"-", "4.199826497566694`*^-31"}]}], ",", 
   RowBox[{"xF1", "\[Rule]", "3.6929075415480315`*^-38"}], ",", 
   RowBox[{"yF1", "\[Rule]", 
    RowBox[{"-", "1.6177120999857761`"}]}], ",", 
   RowBox[{"zF1", "\[Rule]", 
    RowBox[{"-", "3.6855679810481916`*^-38"}]}], ",", 
   RowBox[{"pitchF1", "\[Rule]", 
    RowBox[{"-", "1.6609042002412417`*^-37"}]}], ",", 
   RowBox[{"yawF1", "\[Rule]", 
    RowBox[{"-", "4.199826497540939`*^-31"}]}], ",", 
   RowBox[{"rollF1", "\[Rule]", 
    RowBox[{"-", "1.4394268423629183`*^-37"}]}], ",", 
   RowBox[{"xF2", "\[Rule]", "2.6595025734540387`*^-37"}], ",", 
   RowBox[{"yF2", "\[Rule]", 
    RowBox[{"-", "3.7348808050714553`"}]}], ",", 
   RowBox[{"zF2", "\[Rule]", 
    RowBox[{"-", "3.0128161899667223`*^-37"}]}], ",", 
   RowBox[{"pitchF2", "\[Rule]", "5.780218095275105`*^-39"}], ",", 
   RowBox[{"yawF2", "\[Rule]", 
    RowBox[{"-", "4.199826497526297`*^-31"}]}], ",", 
   RowBox[{"rollF2", "\[Rule]", "1.4641895044514185`*^-38"}], ",", 
   RowBox[{"xF3", "\[Rule]", "2.115175881704619`*^-37"}], ",", 
   RowBox[{"yF3", "\[Rule]", 
    RowBox[{"-", "6.102350196823493`"}]}], ",", 
   RowBox[{"zF3", "\[Rule]", 
    RowBox[{"-", "2.7971613870861443`*^-37"}]}], ",", 
   RowBox[{"pitchF3", "\[Rule]", "4.445965582335659`*^-39"}], ",", 
   RowBox[{"yawF3", "\[Rule]", 
    RowBox[{"-", "4.199826497571229`*^-31"}]}], ",", 
   RowBox[{"rollF3", "\[Rule]", "1.1020930905578695`*^-38"}], ",", 
   RowBox[{"xF4", "\[Rule]", "1.4726092934434412`*^-37"}], ",", 
   RowBox[{"yF4", "\[Rule]", 
    RowBox[{"-", "8.203769674028974`"}]}], ",", 
   RowBox[{"zF4", "\[Rule]", 
    RowBox[{"-", "2.5356498203145023`*^-37"}]}], ",", 
   RowBox[{"pitchF4", "\[Rule]", 
    RowBox[{"-", "7.920574109480053`*^-40"}]}], ",", 
   RowBox[{"yawF4", "\[Rule]", 
    RowBox[{"-", "4.199826497581187`*^-31"}]}], ",", 
   RowBox[{"rollF4", "\[Rule]", 
    RowBox[{"-", "5.661911130153713`*^-40"}]}], ",", 
   RowBox[{"xIM", "\[Rule]", "1.5172996546549264`*^-37"}], ",", 
   RowBox[{"yIM", "\[Rule]", 
    RowBox[{"-", "10.287441717595225`"}]}], ",", 
   RowBox[{"zIM", "\[Rule]", 
    RowBox[{"-", "2.59824305130054`*^-37"}]}], ",", 
   RowBox[{"pitchIM", "\[Rule]", "3.076935646376702`*^-42"}], ",", 
   RowBox[{"yawIM", "\[Rule]", 
    RowBox[{"-", "4.199826497580489`*^-31"}]}], ",", 
   RowBox[{"rollIM", "\[Rule]", "2.458415507563479`*^-42"}], ",", 
   RowBox[{"xIRM", "\[Rule]", "1.5632830563535062`*^-37"}], ",", 
   RowBox[{"yIRM", "\[Rule]", 
    RowBox[{"-", "10.29669344240256`"}]}], ",", 
   RowBox[{"zIRM", "\[Rule]", 
    RowBox[{"-", "2.513831837736511`*^-37"}]}], ",", 
   RowBox[{"pitchIRM", "\[Rule]", 
    RowBox[{"-", "7.922369702566652`*^-40"}]}], ",", 
   RowBox[{"yawIRM", "\[Rule]", 
    RowBox[{"-", "4.199826497581187`*^-31"}]}], ",", 
   RowBox[{"rollIRM", "\[Rule]", 
    RowBox[{"-", "5.637239048984447`*^-40"}]}], ",", 
   RowBox[{"xTM", "\[Rule]", "1.5172995964927445`*^-37"}], ",", 
   RowBox[{"yTM", "\[Rule]", 
    RowBox[{"-", "12.379966885387574`"}]}], ",", 
   RowBox[{"zTM", "\[Rule]", 
    RowBox[{"-", "2.598243333325725`*^-37"}]}], ",", 
   RowBox[{"pitchTM", "\[Rule]", "9.664438427522097`*^-42"}], ",", 
   RowBox[{"yawTM", "\[Rule]", 
    RowBox[{"-", "4.1998264975804895`*^-31"}]}], ",", 
   RowBox[{"rollTM", "\[Rule]", 
    RowBox[{"-", "2.7262642996058314`*^-42"}]}], ",", 
   RowBox[{"xRM", "\[Rule]", "1.5173016755828043`*^-37"}], ",", 
   RowBox[{"yRM", "\[Rule]", 
    RowBox[{"-", "12.378419176852201`"}]}], ",", 
   RowBox[{"zRM", "\[Rule]", 
    RowBox[{"-", "2.598243377874875`*^-37"}]}], ",", 
   RowBox[{"pitchRM", "\[Rule]", "3.786831464527584`*^-42"}], ",", 
   RowBox[{"yawRM", "\[Rule]", 
    RowBox[{"-", "4.199826497580489`*^-31"}]}], ",", 
   RowBox[{"rollRM", "\[Rule]", "2.4566020938148385`*^-42"}], ",", 
   RowBox[{"xMD", "\[Rule]", 
    RowBox[{"-", "6.036722808316038`*^-20"}]}], ",", 
   RowBox[{"yMD", "\[Rule]", 
    RowBox[{"-", "1.4432193145940104`"}]}], ",", 
   RowBox[{"zMD", "\[Rule]", "3.559035079712129`*^-20"}], ",", 
   RowBox[{"pitchMD", "\[Rule]", "1.8728383416989068`*^-17"}], ",", 
   RowBox[{"yawMD", "\[Rule]", 
    RowBox[{"-", "4.403405518396446`*^-31"}]}], ",", 
   RowBox[{"rollMD", "\[Rule]", "3.176649198562281`*^-17"}], ",", 
   RowBox[{"xKS0", "\[Rule]", 
    RowBox[{"-", "1.3973380121694367`*^-37"}]}], ",", 
   RowBox[{"yKS0", "\[Rule]", "0.4867479682464714`"}], ",", 
   RowBox[{"zKS0", "\[Rule]", "1.4017442892778815`*^-37"}], ",", 
   RowBox[{"pitchKS0", "\[Rule]", "8.877424670668216`*^-38"}], ",", 
   RowBox[{"yawKS0", "\[Rule]", 
    RowBox[{"-", "4.199826497566693`*^-31"}]}], ",", 
   RowBox[{"rollKS0", "\[Rule]", 
    RowBox[{"-", "4.4371295507204155`*^-38"}]}], ",", 
   RowBox[{"xKS1", "\[Rule]", "2.6607428315548957`*^-37"}], ",", 
   RowBox[{"yKS1", "\[Rule]", 
    RowBox[{"-", "1.6305896498959136`"}]}], ",", 
   RowBox[{"zKS1", "\[Rule]", 
    RowBox[{"-", "3.013462999275589`*^-37"}]}], ",", 
   RowBox[{"pitchKS1", "\[Rule]", 
    RowBox[{"-", "1.911104052457981`*^-37"}]}], ",", 
   RowBox[{"yawKS1", "\[Rule]", 
    RowBox[{"-", "4.199826497540939`*^-31"}]}], ",", 
   RowBox[{"rollKS1", "\[Rule]", 
    RowBox[{"-", "1.1507441202282988`*^-37"}]}], ",", 
   RowBox[{"xKS2", "\[Rule]", "2.117010690648966`*^-37"}], ",", 
   RowBox[{"yKS2", "\[Rule]", 
    RowBox[{"-", "3.7473264136973583`"}]}], ",", 
   RowBox[{"zKS2", "\[Rule]", 
    RowBox[{"-", "2.798011901146192`*^-37"}]}], ",", 
   RowBox[{"pitchKS2", "\[Rule]", "5.9695438079094115`*^-40"}], ",", 
   RowBox[{"yawKS2", "\[Rule]", 
    RowBox[{"-", "4.199826497526298`*^-31"}]}], ",", 
   RowBox[{"rollKS2", "\[Rule]", "1.5028430591007896`*^-38"}], ",", 
   RowBox[{"xKS3", "\[Rule]", "1.4766103352290761`*^-37"}], ",", 
   RowBox[{"yKS3", "\[Rule]", 
    RowBox[{"-", "6.11360871036816`"}]}], ",", 
   RowBox[{"zKS3", "\[Rule]", 
    RowBox[{"-", "2.537483084035874`*^-37"}]}], ",", 
   RowBox[{"pitchKS3", "\[Rule]", 
    RowBox[{"-", "7.455991605489962`*^-39"}]}], ",", 
   RowBox[{"yawKS3", "\[Rule]", 
    RowBox[{"-", "4.199826497571229`*^-31"}]}], ",", 
   RowBox[{"rollKS3", "\[Rule]", "3.9447814079809236`*^-57"}], ",", 
   RowBox[{"xKS4", "\[Rule]", "1.517046348989019`*^-37"}], ",", 
   RowBox[{"yKS4", "\[Rule]", 
    RowBox[{"-", "8.214798874777436`"}]}], ",", 
   RowBox[{"zKS4", "\[Rule]", 
    RowBox[{"-", "2.5979361670574635`*^-37"}]}], ",", 
   RowBox[{"pitchKS4", "\[Rule]", 
    RowBox[{"-", "3.425281188838081`*^-39"}]}], ",", 
   RowBox[{"yawKS4", "\[Rule]", 
    RowBox[{"-", "4.199826497581187`*^-31"}]}], ",", 
   RowBox[{"rollKS4", "\[Rule]", "2.0642045922350144`*^-39"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.510918281798601*^9, {3.5109185842987328`*^9, 3.510918588183139*^9}, 
   3.5109188021843147`*^9, 3.5109188818380547`*^9, 3.510956282795619*^9, 
   3.510958553471608*^9, 3.5109760020455723`*^9, 3.5109762224427595`*^9, 
   3.510981584761199*^9, 3.510997021052256*^9, 3.5109970696775417`*^9, 
   3.51100053174363*^9, 3.5110022334138308`*^9, 3.5110032212855654`*^9, 
   3.511003477625216*^9, 3.5110044026288404`*^9, {3.5110044639837484`*^9, 
   3.511004474498167*^9}, 3.511004507944626*^9, 3.5110674021996913`*^9, 
   3.5111403773048925`*^9, 3.511141010588004*^9, 3.5111412287075877`*^9, 
   3.5111413274869614`*^9, {3.5111413840838604`*^9, 3.5111414391659575`*^9}, {
   3.511141482034833*^9, 3.5111414896320467`*^9}, 3.511143384729375*^9, 
   3.5111469195239835`*^9, 3.5111472172193065`*^9, 3.511147933229364*^9, {
   3.511149501266118*^9, 3.5111495096589327`*^9}, 3.511150531741528*^9, 
   3.511150641955722*^9, {3.511150687227001*^9, 3.5111507000658236`*^9}, 
   3.5111525605562916`*^9, 3.511152660521267*^9, 3.5111541628097115`*^9, 
   3.5111546461141605`*^9, 3.511154858804934*^9, 3.511154922016245*^9, 
   3.5111550870333347`*^9, 3.511227338569903*^9, 3.5112285791620817`*^9, 
   3.5112287411059666`*^9, 3.5112289115986657`*^9, 3.511228943719122*^9, 
   3.5112291311846514`*^9, 3.5112291859407473`*^9, 3.511229342253022*^9, 
   3.511229667950394*^9, 3.51122993873567*^9, 3.51123036609842*^9, 
   3.511230514938282*^9, 3.5112317294784155`*^9, {3.511231796870534*^9, 
   3.5112318180085707`*^9}, 3.511232314782448*^9, 3.5112324235614386`*^9, 
   3.511232456883097*^9, 3.511232491608758*^9, 3.5112325360376368`*^9, 
   3.511232579889313*^9, 3.511232655409046*^9, 3.511232843857377*^9, 
   3.5112329061326866`*^9, 3.5112332275400505`*^9, 3.5113291732188797`*^9, 
   3.511329411712098*^9, 3.511330414918663*^9, 3.511330611135808*^9, 
   3.5113309898420725`*^9, 3.511331145155946*^9, 3.511332932014284*^9, 
   3.511343444537177*^9, 3.5113893904430304`*^9, 3.5114066658619184`*^9, 
   3.5114067613964863`*^9, 3.5114069281139793`*^9, 3.5114315309789104`*^9, 
   3.5114900390388813`*^9, 3.511494313353214*^9, 3.5114947992160673`*^9, 
   3.5114950951797867`*^9, 3.5114976128240194`*^9, 3.5123557673055196`*^9, 
   3.5123559844585347`*^9, 3.512357720304784*^9, 3.5123578229841638`*^9, 
   3.5123586976933002`*^9, 3.512358797330675*^9, 3.5123589226144953`*^9, 
   3.5124237581731677`*^9, 3.5124275277636547`*^9, 3.5127107827030926`*^9, 
   3.5127123057457695`*^9, 3.5127124974389057`*^9, 3.5127125912262707`*^9, 
   3.5127130589306917`*^9, 3.5127131447932425`*^9, 3.51273061964657*^9, 
   3.5127326937654157`*^9, 3.512733364067393*^9, 3.5127350758739996`*^9, 
   3.5128022717992363`*^9, 3.5128023938538504`*^9, 3.512802484396409*^9, {
   3.514168342323349*^9, 3.514168347876959*^9}, 3.514168527402074*^9, 
   3.514168687910756*^9, 3.5141713213879848`*^9, 3.5141731899222794`*^9, 
   3.5141732836784444`*^9, 3.514173379228612*^9, 3.514242359483553*^9, 
   3.5145115735478516`*^9, 3.5145119675889435`*^9, 3.514512186691328*^9, 
   3.518817670628108*^9, 3.518827757083144*^9, 3.5188352297794294`*^9, 
   3.518835433141387*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equations of Motion", "Section",
 CellChangeTimes->{{3.510627640017733*^9, 3.510627674649794*^9}, 
   3.5109189734102154`*^9}],

Cell[CellGroupData[{

Cell["Mass Matrix", "Subsection",
 CellChangeTimes->{{3.510561334346517*^9, 3.510561337388523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matMvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"kinetic", ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510561339822127*^9, 3.5105613828470025`*^9}, {
   3.5105614843563805`*^9, 3.51056150657082*^9}, {3.510561663541896*^9, 
   3.5105617389524283`*^9}, {3.5105619183683434`*^9, 
   3.5105619553404083`*^9}, {3.5106285477833276`*^9, 
   3.5106286902115774`*^9}, {3.510629347182332*^9, 3.510629358086751*^9}, {
   3.5106295553334975`*^9, 3.5106295558638983`*^9}, {3.5106573586878967`*^9, 
   3.5106574988697433`*^9}, 3.5106575498350325`*^9, {3.5106575855122952`*^9, 
   3.510657586838298*^9}, 3.510657701592099*^9, {3.510918992301849*^9, 
   3.510919033813522*^9}, {3.510919072236389*^9, 3.5109190853248124`*^9}, {
   3.511002629373726*^9, 3.511002636112938*^9}, {3.511142697495368*^9, 
   3.511142697651368*^9}, {3.511148104096464*^9, 3.5111481386037245`*^9}, {
   3.5112308639264946`*^9, 3.5112308672337008`*^9}, 3.5127273081131516`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matMpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"kinetic", ",", 
           RowBox[{"velvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"velparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "velparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510629277247409*^9, 3.5106293107406683`*^9}, {
   3.510629367384368*^9, 3.510629370301573*^9}, {3.5106295599043055`*^9, 
   3.5106295603567066`*^9}, {3.510657365037108*^9, 3.5106574369532347`*^9}, 
   3.510657709126912*^9, {3.5106577452409763`*^9, 3.510657747034979*^9}, {
   3.5109190411611347`*^9, 3.510919114247263*^9}, 3.51091916922176*^9, {
   3.5109193418204627`*^9, 3.51091934586087*^9}, 3.5109555482566385`*^9, {
   3.5110026383125415`*^9, 3.5110026412609468`*^9}, {3.5111427006777735`*^9, 
   3.511142701020974*^9}, {3.5111428283327975`*^9, 3.5111428289723988`*^9}, {
   3.51114814166133*^9, 3.5111481490869427`*^9}, {3.511230607696045*^9, 
   3.511230615230858*^9}, {3.5112308557832804`*^9, 3.5112308586848855`*^9}, 
   3.5127273090023527`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stiffness Matrix", "Subsection",
 CellChangeTimes->{{3.510628701318797*^9, 3.510628705218804*^9}, {
  3.510628763250906*^9, 3.5106287646393085`*^9}}],

Cell[CellGroupData[{

Cell["Only Real", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5109555066872606`*^9, 3.510955522479164*^9}, {
  3.5111459241018353`*^9, 3.511145929171844*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matKvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"potential", ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5105619627036214`*^9, 3.510561989847669*^9}, 
   3.510562426586036*^9, {3.510562624565984*^9, 3.5105626282787905`*^9}, 
   3.510562823575534*^9, {3.5106287756061277`*^9, 3.5106287991777687`*^9}, 
   3.510629372735177*^9, {3.5106295648963146`*^9, 3.5106295735387297`*^9}, 
   3.510634023423352*^9, 3.5106340995670853`*^9, 3.510634705986951*^9, 
   3.5106357421095705`*^9, {3.5106577195477304`*^9, 3.5106577496869836`*^9}, {
   3.510919174588169*^9, 3.5109192067710257`*^9}, {3.51091935724889*^9, 
   3.5109193604780955`*^9}, 3.510955522479164*^9, {3.511000578777713*^9, 
   3.5110005872953277`*^9}, 3.511002643460551*^9, {3.51100273993112*^9, 
   3.511002769945573*^9}, {3.5110030522904687`*^9, 3.511003069060498*^9}, {
   3.511141726877263*^9, 3.511141728328066*^9}, 3.511141847169074*^9, {
   3.51114310883689*^9, 3.511143116262503*^9}, {3.511143405602212*^9, 
   3.5111434129186244`*^9}, {3.5111459241018353`*^9, 3.511145929171844*^9}, {
   3.5112308780601196`*^9, 3.5112308853609324`*^9}, 3.512727244075039*^9, 
   3.512727310281555*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matKpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"potential", ",", 
           RowBox[{"allvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"allparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "allparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.510629298089046*^9, 3.510629328524699*^9}, {
   3.5106295791391397`*^9, 3.510629587048353*^9}, 3.5106341033890924`*^9, 
   3.5106343797903776`*^9, 3.510634742647015*^9, 3.510635745759977*^9, {
   3.510657728892147*^9, 3.510657756722596*^9}, 3.5109191710313625`*^9, {
   3.5109192125430355`*^9, 3.5109192243990564`*^9}, {3.510919348949675*^9, 
   3.5109193550336857`*^9}, {3.510955522479164*^9, 3.5109555416132584`*^9}, {
   3.5110027536747446`*^9, 3.511002764969164*^9}, {3.5111417317132716`*^9, 
   3.5111417374696817`*^9}, 3.511141852644684*^9, {3.5111428317960033`*^9, 
   3.5111428323108044`*^9}, {3.5111459241018353`*^9, 3.511145929171844*^9}, {
   3.511230887888137*^9, 3.5112309006801596`*^9}, 3.5127272467426434`*^9, 
   3.5127273111395564`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "allfloats", "]"}], "\[GreaterEqual]", "1"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"matKfv", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allvars", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKff", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKfp", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potential", ",", 
              RowBox[{"allparams", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allparams", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKvv", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfv", ".", 
          RowBox[{"Inverse", "[", "matKff", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfv", "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"matKpv", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfv", ".", 
          RowBox[{"Inverse", "[", "matKff", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfp", "]"}]}], "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5111416497975273`*^9, 3.5111417209960527`*^9}, {
  3.5111417526641083`*^9, 3.5111418619267*^9}, {3.511142246202175*^9, 
  3.5111422962938633`*^9}, {3.5111425664863377`*^9, 3.5111425873747745`*^9}, {
  3.5111428355400105`*^9, 3.5111428761468816`*^9}, {3.511142909967741*^9, 
  3.511142930606577*^9}, {3.511142981868267*^9, 3.5111430139887238`*^9}, {
  3.5111430674656177`*^9, 3.511143067824418*^9}, {3.511143466379918*^9, 
  3.51114346733152*^9}, {3.5111435471100597`*^9, 3.5111435507604666`*^9}, {
  3.5111436040657597`*^9, 3.5111436094009695`*^9}, {3.511145929171844*^9, 
  3.5111459456454725`*^9}, {3.511149406308751*^9, 3.5111494064335513`*^9}, {
  3.5112309057189684`*^9, 3.5112309636574697`*^9}, {3.5112312731776133`*^9, 
  3.5112313016164637`*^9}, {3.5127272495194483`*^9, 3.5127272553538585`*^9}, {
  3.512727288207516*^9, 3.5127273062099476`*^9}, {3.512735314694819*^9, 
  3.512735322167232*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["With Imaginary Part", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.51095551455171*^9, 3.510955530382616*^9}, {
  3.5111481601941624`*^9, 3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matKvvc", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"potentialc", ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"allvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "allvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5105619627036214`*^9, 3.510561989847669*^9}, 
   3.510562426586036*^9, {3.510562624565984*^9, 3.5105626282787905`*^9}, 
   3.510562823575534*^9, {3.5106287756061277`*^9, 3.5106287991777687`*^9}, 
   3.510629372735177*^9, {3.5106295648963146`*^9, 3.5106295735387297`*^9}, 
   3.510634023423352*^9, 3.5106340995670853`*^9, 3.510634705986951*^9, 
   3.5106357421095705`*^9, {3.5106577195477304`*^9, 3.5106577496869836`*^9}, {
   3.510919174588169*^9, 3.5109192067710257`*^9}, {3.51091935724889*^9, 
   3.5109193604780955`*^9}, {3.510922241814151*^9, 3.5109222467374325`*^9}, 
   3.510955530382616*^9, {3.5110005587316775`*^9, 3.5110005689340954`*^9}, {
   3.511002971747527*^9, 3.511002992214763*^9}, {3.5111437697380514`*^9, 
   3.5111437766956635`*^9}, 3.511143821826543*^9, {3.5111481601941624`*^9, 
   3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matKpvc", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"potentialc", ",", 
           RowBox[{"allvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"allparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "allparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510629298089046*^9, 3.510629328524699*^9}, {
   3.5106295791391397`*^9, 3.510629587048353*^9}, 3.5106341033890924`*^9, 
   3.5106343797903776`*^9, 3.510634742647015*^9, 3.510635745759977*^9, {
   3.510657728892147*^9, 3.510657756722596*^9}, 3.5109191710313625`*^9, {
   3.5109192125430355`*^9, 3.5109192243990564`*^9}, {3.510919348949675*^9, 
   3.5109193550336857`*^9}, {3.5109222445573077`*^9, 
   3.5109222483205233`*^9}, {3.510955530382616*^9, 3.510955540563198*^9}, {
   3.511002993930766*^9, 3.5110029968011713`*^9}, {3.511143772499256*^9, 
   3.511143780985671*^9}, 3.5111438228093443`*^9, {3.5111481601941624`*^9, 
   3.511148165466972*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Length", "[", "allfloats", "]"}], "\[GreaterEqual]", "1"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"matKfvc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allvars", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allvars", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKffc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKfpc", "=", 
       RowBox[{"Chop", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"potentialc", ",", 
              RowBox[{"allparams", "[", 
               RowBox[{"[", "n", "]"}], "]"}], ",", 
              RowBox[{"allfloats", "[", 
               RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"Length", "[", "allparams", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"Length", "[", "allfloats", "]"}]}], "}"}]}], "]"}], "/.",
           "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"matKvvc", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfvc", ".", 
          RowBox[{"Inverse", "[", "matKffc", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfvc", "]"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"matKpvc", "+=", 
       RowBox[{"-", 
        RowBox[{"Chop", "[", 
         RowBox[{"matKfvc", ".", 
          RowBox[{"Inverse", "[", "matKffc", "]"}], ".", 
          RowBox[{"Transpose", "[", "matKfpc", "]"}]}], "]"}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5111416497975273`*^9, 3.5111417209960527`*^9}, {
   3.5111417526641083`*^9, 3.5111418619267*^9}, {3.511142246202175*^9, 
   3.5111422962938633`*^9}, {3.5111425664863377`*^9, 
   3.5111425873747745`*^9}, {3.5111428355400105`*^9, 
   3.5111428761468816`*^9}, {3.511142909967741*^9, 3.511142930606577*^9}, {
   3.511142981868267*^9, 3.5111430139887238`*^9}, {3.5111430674656177`*^9, 
   3.511143067824418*^9}, {3.511143466379918*^9, 3.51114346733152*^9}, {
   3.5111435471100597`*^9, 3.5111435507604666`*^9}, {3.5111436040657597`*^9, 
   3.5111436094009695`*^9}, {3.5111438011565065`*^9, 3.511143815914132*^9}, 
   3.511148165466972*^9, {3.5111494314871955`*^9, 3.511149431689996*^9}, {
   3.512727323993979*^9, 3.5127273242591796`*^9}, {3.5127352324358745`*^9, 
   3.512735240625889*^9}, {3.5127353013099957`*^9, 3.5127353103736115`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Damping Matrix", "Subsection",
 CellChangeTimes->{{3.510561334346517*^9, 3.510561337388523*^9}, {
  3.5113900124941225`*^9, 3.511390015442528*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"matGvv", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"damping", ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"velvars", "[", 
           RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", 
          RowBox[{"Length", "[", "velvars", "]"}]}], "}"}]}], "]"}], "/.", 
      "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.510561339822127*^9, 3.5105613828470025`*^9}, {
   3.5105614843563805`*^9, 3.51056150657082*^9}, {3.510561663541896*^9, 
   3.5105617389524283`*^9}, {3.5105619183683434`*^9, 
   3.5105619553404083`*^9}, {3.5106285477833276`*^9, 
   3.5106286902115774`*^9}, {3.510629347182332*^9, 3.510629358086751*^9}, {
   3.5106295553334975`*^9, 3.5106295558638983`*^9}, {3.5106573586878967`*^9, 
   3.5106574988697433`*^9}, 3.5106575498350325`*^9, {3.5106575855122952`*^9, 
   3.510657586838298*^9}, 3.510657701592099*^9, {3.510918992301849*^9, 
   3.510919033813522*^9}, {3.510919072236389*^9, 3.5109190853248124`*^9}, {
   3.511002629373726*^9, 3.511002636112938*^9}, {3.511142697495368*^9, 
   3.511142697651368*^9}, {3.511148104096464*^9, 3.5111481386037245`*^9}, {
   3.5112308639264946`*^9, 3.5112308672337008`*^9}, {3.511390018359733*^9, 
   3.511390025722946*^9}, {3.5113900655654163`*^9, 3.511390079979841*^9}, 
   3.512727336255601*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matGpv", "=", 
    RowBox[{"Chop", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"damping", ",", 
           RowBox[{"velvars", "[", 
            RowBox[{"[", "n", "]"}], "]"}], ",", 
           RowBox[{"velparams", "[", 
            RowBox[{"[", "m", "]"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"Length", "[", "velvars", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", 
           RowBox[{"Length", "[", "velparams", "]"}]}], "}"}]}], "]"}], "/.", 
       "\[IndentingNewLine]", "subminvars"}], "/.", "subdefparams"}], "]"}]}],
    ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.510629277247409*^9, 3.5106293107406683`*^9}, {
   3.510629367384368*^9, 3.510629370301573*^9}, {3.5106295599043055`*^9, 
   3.5106295603567066`*^9}, {3.510657365037108*^9, 3.5106574369532347`*^9}, 
   3.510657709126912*^9, {3.5106577452409763`*^9, 3.510657747034979*^9}, {
   3.5109190411611347`*^9, 3.510919114247263*^9}, 3.51091916922176*^9, {
   3.5109193418204627`*^9, 3.51091934586087*^9}, 3.5109555482566385`*^9, {
   3.5110026383125415`*^9, 3.5110026412609468`*^9}, {3.5111427006777735`*^9, 
   3.511142701020974*^9}, {3.5111428283327975`*^9, 3.5111428289723988`*^9}, {
   3.51114814166133*^9, 3.5111481490869427`*^9}, {3.511230607696045*^9, 
   3.511230615230858*^9}, {3.5112308557832804`*^9, 3.5112308586848855`*^9}, {
   3.511390021198938*^9, 3.5113900346461616`*^9}, {3.5113900824290457`*^9, 
   3.511390094378667*^9}, 3.5127273373944025`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigen Mode", "Section",
 CellChangeTimes->{{3.510639974173004*^9, 3.51063997762061*^9}}],

Cell[CellGroupData[{

Cell["Eigen Frequencies & Vectors", "Subsection",
 CellChangeTimes->{{3.5106399863410254`*^9, 3.510639995685442*^9}, {
  3.5109193175936203`*^9, 3.510919324769633*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eigen", "=", 
   RowBox[{"Eigensystem", "[", 
    RowBox[{
     RowBox[{"Inverse", "[", "matMvv", "]"}], ".", 
     RowBox[{"Re", "[", "matKvv", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigenf", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"eigen", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", 
       RowBox[{"N", "[", "Pi", "]"}]}], ")"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eigenv", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{"eigen", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5106404812986946`*^9, 3.5106405612644353`*^9}, {
  3.510642026727812*^9, 3.510642034652625*^9}, {3.510642839520439*^9, 
  3.510642845308049*^9}, {3.5106429258041906`*^9, 3.510642929423397*^9}, {
  3.5106434421806974`*^9, 3.510643450791913*^9}, {3.5109192830239596`*^9, 
  3.510919329933242*^9}, {3.511143879000643*^9, 3.5111438815434475`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eigen Mode Listup", "Subsection",
 CellChangeTimes->{{3.5106417564485364`*^9, 3.510641767571356*^9}, {
  3.5106435074824123`*^9, 3.5106435076384125`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eigenmodetable", "[", 
  RowBox[{"eigenf", ",", "eigenv", ",", "0.2"}], "]"}]], "Input",
 CellChangeTimes->{{3.5106432816876154`*^9, 3.510643291593633*^9}, {
   3.510921715107025*^9, 3.510921737338297*^9}, {3.510922100897091*^9, 
   3.5109221122847424`*^9}, 3.5109585862628655`*^9, {3.511407145469161*^9, 
   3.5114071462179623`*^9}, {3.5114900165592413`*^9, 3.511490016886842*^9}, {
   3.512727357924039*^9, 3.51272735881324*^9}, {3.5141696572652583`*^9, 
   3.514169657561659*^9}, {3.514512427040951*^9, 3.514512427134551*^9}}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"\<\"N\"\>", "\<\"Freq\"\>", "\<\"Type\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"1", 
     "0.006611274804478073`", "\<\"yawF3(0.232007)\"\>", "\<\"yawF4(0.341188)\
\"\>", "\<\"yawIM(0.408035)\"\>", "\<\"yawIRM(0.341267)\"\>", \
"\<\"yawTM(0.40808)\"\>", "\<\"yawRM(0.408085)\"\>", \
"\<\"yawKS3(0.232008)\"\>", "\<\"yawKS4(0.341188)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"2", 
     "0.01752036233352758`", "\<\"yawF2(-0.220169)\"\>", \
"\<\"yawF3(-0.242462)\"\>", "\<\"yawIM(0.49668)\"\>", \
"\<\"yawTM(0.497066)\"\>", "\<\"yawRM(0.497112)\"\>", \
"\<\"yawKS2(-0.220169)\"\>", "\<\"yawKS3(-0.242461)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"3", 
     "0.022869555283969445`", "\<\"yawF1(-0.223954)\"\>", \
"\<\"yawF2(-0.356402)\"\>", "\<\"yawF4(0.301612)\"\>", \
"\<\"yawIM(-0.313566)\"\>", "\<\"yawIRM(0.302448)\"\>", "\<\"yawTM(-0.313981)\
\"\>", "\<\"yawRM(-0.31403)\"\>", "\<\"yawKS1(-0.223955)\"\>", \
"\<\"yawKS2(-0.356401)\"\>", "\<\"yawKS4(0.30161)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"4", 
     "0.02553509590231963`", "\<\"xF0(0.253964)\"\>", \
"\<\"xF1(0.255397)\"\>", "\<\"xF2(0.256841)\"\>", "\<\"xF3(0.258461)\"\>", \
"\<\"xF4(0.259903)\"\>", "\<\"xIM(0.261337)\"\>", "\<\"xIRM(0.261338)\"\>", "\
\<\"xTM(0.262779)\"\>", "\<\"xRM(0.262778)\"\>", "\<\"xMD(0.255131)\"\>", "\<\
\"xKS0(0.253966)\"\>", "\<\"xKS1(0.255406)\"\>", "\<\"xKS2(0.25685)\"\>", "\<\
\"xKS3(0.258469)\"\>", "\<\"xKS4(0.25991)\"\>"},
    {"5", 
     "0.02553509616514809`", "\<\"zF0(0.253973)\"\>", \
"\<\"zF1(0.255407)\"\>", "\<\"zF2(0.256851)\"\>", "\<\"zF3(0.258471)\"\>", \
"\<\"zF4(0.259913)\"\>", "\<\"zIM(0.261347)\"\>", "\<\"zIRM(0.261348)\"\>", "\
\<\"zTM(0.26279)\"\>", "\<\"zRM(0.262789)\"\>", "\<\"zMD(0.255141)\"\>", \
"\<\"zKS0(0.253976)\"\>", "\<\"zKS1(0.255416)\"\>", "\<\"zKS2(0.25686)\"\>", \
"\<\"zKS3(0.258479)\"\>", "\<\"zKS4(0.25992)\"\>"},
    {"6", 
     "0.035086459518890896`", "\<\"yawF1(0.375767)\"\>", "\<\"yawF2(0.252664)\
\"\>", "\<\"yawF3(-0.523708)\"\>", "\<\"yawKS1(0.375766)\"\>", \
"\<\"yawKS2(0.252658)\"\>", "\<\"yawKS3(-0.523704)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>"},
    {"7", 
     "0.04897215036196222`", "\<\"yawF1(-0.526184)\"\>", \
"\<\"yawF2(0.44421)\"\>", "\<\"yawKS1(-0.526175)\"\>", \
"\<\"yawKS2(0.444205)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\
\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
    {"8", 
     "0.08895749918516478`", "\<\"yawF0(-0.566758)\"\>", "\<\"yawMD(-0.58288)\
\"\>", "\<\"yawKS0(-0.566751)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"9", 
     "0.1646651328468239`", "\<\"yF3(0.207799)\"\>", "\<\"yF4(0.293925)\"\>", \
"\<\"yIM(0.391721)\"\>", "\<\"yIRM(0.294179)\"\>", "\<\"yTM(0.392043)\"\>", "\
\<\"yRM(0.391977)\"\>", "\<\"yKS2(0.207542)\"\>", "\<\"yKS3(0.293683)\"\>", "\
\<\"yKS4(0.391522)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
    {"10", 
     "0.20014242250588496`", "\<\"xIM(-0.329829)\"\>", \
"\<\"xIRM(-0.27447)\"\>", "\<\"xTM(-0.498044)\"\>", "\<\"xRM(-0.49862)\"\>", \
"\<\"xMD(0.223925)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"11", 
     "0.20023398877257859`", "\<\"zIM(0.339157)\"\>", \
"\<\"zIRM(0.282895)\"\>", "\<\"zTM(0.512149)\"\>", "\<\"zRM(0.512233)\"\>", "\
\<\"zMD(-0.230469)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"12", 
     "0.26375099851074074`", "\<\"rollIM(0.577017)\"\>", \
"\<\"rollTM(0.577176)\"\>", "\<\"rollRM(0.577425)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"13", 
     "0.30911354722807866`", "\<\"pitchIM(0.436044)\"\>", "\<\"zIRM(0.493072)\
\"\>", "\<\"zTM(-0.240528)\"\>", "\<\"pitchTM(0.444171)\"\>", \
"\<\"zRM(-0.24922)\"\>", "\<\"pitchRM(0.452897)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"14", 
     "0.31060684546864176`", "\<\"rollIM(-0.284779)\"\>", \
"\<\"xIRM(-0.666999)\"\>", "\<\"xTM(0.349332)\"\>", \
"\<\"rollTM(-0.284868)\"\>", "\<\"xRM(0.336619)\"\>", \
"\<\"rollRM(-0.285052)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"15", 
     "0.34157439410258456`", "\<\"pitchIM(0.558737)\"\>", \
"\<\"pitchTM(0.566388)\"\>", "\<\"pitchRM(0.584928)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"16", 
     "0.3448676215540721`", "\<\"xTM(-0.99212)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"17", 
     "0.3455376996112846`", "\<\"pitchIM(-0.462647)\"\>", \
"\<\"zTM(0.554523)\"\>", "\<\"pitchTM(-0.487992)\"\>", \
"\<\"pitchRM(-0.484271)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"18", 
     "0.3841411517511399`", "\<\"xMD(-0.976194)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"19", 
     "0.3841553153998802`", "\<\"zMD(0.973206)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"20", 
     "0.42867605070704884`", "\<\"yF2(-0.280903)\"\>", \
"\<\"yF3(-0.328027)\"\>", "\<\"yF4(-0.226581)\"\>", "\<\"yIM(0.325864)\"\>", \
"\<\"yIRM(-0.227916)\"\>", "\<\"yTM(0.327688)\"\>", "\<\"yRM(0.327311)\"\>", \
"\<\"yKS1(-0.280508)\"\>", "\<\"yKS2(-0.327886)\"\>", \
"\<\"yKS3(-0.226879)\"\>", "\<\"yKS4(0.324735)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
    {"21", 
     "0.46614340634053886`", "\<\"xF2(-0.222123)\"\>", \
"\<\"xF3(-0.34709)\"\>", "\<\"xF4(-0.298956)\"\>", \
"\<\"rollF4(0.206344)\"\>", "\<\"xIRM(0.36079)\"\>", "\<\"rollIRM(0.207314)\"\
\>", "\<\"xTM(0.200938)\"\>", "\<\"xRM(0.202737)\"\>", "\<\"xKS2(-0.223188)\"\
\>", "\<\"xKS3(-0.347481)\"\>", "\<\"xKS4(-0.296978)\"\>", \
"\<\"rollKS4(0.207903)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"22", 
     "0.4663498460894357`", "\<\"zF2(0.22508)\"\>", "\<\"zF3(0.351459)\"\>", \
"\<\"zF4(0.303735)\"\>", "\<\"zIRM(-0.366236)\"\>", "\<\"zTM(-0.204358)\"\>", \
"\<\"zRM(-0.20669)\"\>", "\<\"zKS2(0.226159)\"\>", "\<\"zKS3(0.351855)\"\>", \
"\<\"zKS4(0.302309)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>"},
    {"23", 
     "0.517422628441875`", "\<\"rollF4(0.574031)\"\>", "\<\"rollIRM(0.577104)\
\"\>", "\<\"rollKS4(0.580058)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"24", 
     "0.5464958977194536`", "\<\"pitchF4(-0.577814)\"\>", \
"\<\"pitchIRM(-0.581655)\"\>", "\<\"pitchKS4(-0.571784)\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"25", 
     "0.5472037536912936`", "\<\"yawMD(0.997835)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"26", 
     "0.6010278062059558`", "\<\"yawF4(0.558047)\"\>", "\<\"yawIRM(-0.614135)\
\"\>", "\<\"yawKS4(0.55805)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>"},
    {"27", 
     "0.6279727527011708`", "\<\"yawTM(-0.999764)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"28", 
     "0.6702404081331205`", "\<\"yF1(-0.304113)\"\>", \
"\<\"yF2(-0.390868)\"\>", "\<\"yF4(0.374778)\"\>", "\<\"yIRM(0.380224)\"\>", \
"\<\"yKS0(-0.303115)\"\>", "\<\"yKS1(-0.390627)\"\>", \
"\<\"yKS3(0.373418)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"29", 
     "0.7019749550871838`", "\<\"xF2(0.29553)\"\>", \
"\<\"rollF3(-0.287582)\"\>", "\<\"xF4(-0.203955)\"\>", \
"\<\"xIM(-0.504079)\"\>", "\<\"xKS2(0.29592)\"\>", \
"\<\"rollKS3(-0.289412)\"\>", "\<\"xKS4(-0.202644)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"30", 
     "0.7022997956316064`", "\<\"zF2(-0.287165)\"\>", "\<\"pitchF3(-0.280573)\
\"\>", "\<\"pitchF4(0.22461)\"\>", "\<\"zIM(0.489404)\"\>", \
"\<\"pitchIRM(0.227194)\"\>", "\<\"zKS2(-0.287542)\"\>", \
"\<\"pitchKS3(-0.278796)\"\>", "\<\"pitchKS4(0.220742)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"31", 
     "0.8375996921521169`", "\<\"rollF3(-0.69988)\"\>", \
"\<\"rollKS3(-0.710016)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"32", 
     "0.8376275451909397`", "\<\"pitchF3(-0.70998)\"\>", \
"\<\"pitchKS3(-0.699757)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"33", 
     "0.901202989483659`", "\<\"pitchF2(0.245771)\"\>", \
"\<\"pitchF3(-0.55902)\"\>", "\<\"zIM(0.247331)\"\>", "\<\"pitchKS2(0.243611)\
\"\>", "\<\"pitchKS3(-0.550599)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>"},
    {"34", 
     "0.9012049180740906`", "\<\"rollF2(-0.243192)\"\>", \
"\<\"rollF3(0.552649)\"\>", "\<\"xIM(0.244603)\"\>", \
"\<\"rollKS2(-0.245349)\"\>", "\<\"rollKS3(0.561028)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"35", 
     "0.9227153874209668`", "\<\"yawIM(-0.665652)\"\>", \
"\<\"yawTM(0.576987)\"\>", "\<\"yawRM(0.473279)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"36", 
     "0.9614924762919154`", "\<\"rollF2(-0.700557)\"\>", \
"\<\"rollKS2(-0.710746)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"37", 
     "0.9615192680277201`", "\<\"pitchF2(0.710771)\"\>", \
"\<\"pitchKS2(0.700497)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"38", 
     "1.0084144058665307`", "\<\"yF1(0.424515)\"\>", \
"\<\"yF3(-0.521514)\"\>", "\<\"yKS0(0.423185)\"\>", \
"\<\"yKS2(-0.519782)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"39", 
     "1.0799599185237503`", "\<\"rollF1(-0.698659)\"\>", \
"\<\"rollKS1(-0.709542)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"40", 
     "1.079995474405024`", "\<\"pitchF1(0.709542)\"\>", \
"\<\"pitchKS1(0.698556)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"41", 
     "1.1316350955291243`", "\<\"rollF1(0.527678)\"\>", \
"\<\"rollF2(-0.232344)\"\>", "\<\"xF3(0.251332)\"\>", \
"\<\"xF4(-0.236755)\"\>", "\<\"rollKS1(0.534567)\"\>", \
"\<\"rollKS2(-0.237284)\"\>", "\<\"xKS3(0.250312)\"\>", \
"\<\"xKS4(-0.236102)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"42", 
     "1.1316871464759524`", "\<\"pitchF1(-0.531935)\"\>", \
"\<\"pitchF2(0.234357)\"\>", "\<\"zF3(0.253479)\"\>", \
"\<\"zF4(-0.238775)\"\>", "\<\"pitchKS1(-0.525046)\"\>", \
"\<\"pitchKS2(0.229404)\"\>", "\<\"zKS3(0.252451)\"\>", \
"\<\"zKS4(-0.238059)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"43", 
     "1.2831074088531564`", "\<\"pitchTM(-0.999823)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"44", 
     "1.3158684753795915`", "\<\"yF1(0.372369)\"\>", \
"\<\"yF2(-0.516956)\"\>", "\<\"yF3(0.304963)\"\>", "\<\"yKS0(0.371272)\"\>", \
"\<\"yKS1(-0.514306)\"\>", "\<\"yKS2(0.302372)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>"},
    {"45", 
     "1.366967070780184`", "\<\"xF1(0.38403)\"\>", "\<\"xF2(-0.454769)\"\>", \
"\<\"rollF2(0.226845)\"\>", "\<\"xF3(0.254167)\"\>", \
"\<\"xKS1(0.382087)\"\>", "\<\"xKS2(-0.451802)\"\>", "\<\"rollKS2(0.226163)\"\
\>", "\<\"xKS3(0.252708)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"46", 
     "1.3669729146468717`", "\<\"zF1(-0.383499)\"\>", \
"\<\"zF2(0.454152)\"\>", "\<\"pitchF2(0.226536)\"\>", \
"\<\"zF3(-0.253852)\"\>", "\<\"zKS1(-0.381558)\"\>", \
"\<\"zKS2(0.451188)\"\>", "\<\"pitchKS2(0.227258)\"\>", \
"\<\"zKS3(-0.252395)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"47", 
     "2.8167868040521875`", "\<\"pitchIM(0.933985)\"\>", \
"\<\"pitchTM(-0.231431)\"\>", "\<\"pitchRM(-0.272234)\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"48", 
     "4.546763801144445`", "\<\"yMD(1.)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"49", 
     "5.80375596256867`", "\<\"yTM(0.994059)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"50", 
     "6.42452829405283`", "\<\"pitchMD(-0.999997)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"51", 
     "6.424528294053039`", "\<\"rollMD(-1.)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"52", 
     "7.325426295074404`", "\<\"yF4(0.500031)\"\>", \
"\<\"yIRM(-0.703129)\"\>", "\<\"yKS3(0.505503)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"53", 
     "8.113311870289929`", "\<\"rollTM(0.999834)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"54", 
     "8.530889641333166`", "\<\"pitchF4(-0.499394)\"\>", \
"\<\"pitchIRM(0.709399)\"\>", "\<\"pitchKS4(-0.497332)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"55", 
     "9.542757433099792`", "\<\"rollF4(-0.55393)\"\>", "\<\"rollIRM(0.612835)\
\"\>", "\<\"rollKS4(-0.563535)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"56", 
     "10.57236449292648`", "\<\"yIM(0.61925)\"\>", "\<\"yTM(-0.25965)\"\>", "\
\<\"yRM(-0.36669)\"\>", "\<\"yKS4(0.643925)\"\>", "\<\"\"\>", "\<\"\"\>", "\<\
\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"57", 
     "18.177587762433646`", "\<\"rollIM(0.940419)\"\>", \
"\<\"rollTM(-0.233543)\"\>", "\<\"rollRM(-0.247124)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"58", 
     "54.093124337514354`", "\<\"yKS4(0.998439)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"59", 
     "63.442114856438174`", "\<\"yKS0(-0.998881)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"60", 
     "63.80237764316609`", "\<\"yKS3(-0.999284)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"61", 
     "67.27371095509277`", "\<\"yKS2(0.999313)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"62", 
     "76.26828550511355`", "\<\"yKS1(-0.999413)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"63", 
     "79.89798123837188`", "\<\"rollKS4(-0.995427)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"64", 
     "79.91056100928303`", "\<\"pitchKS4(0.995408)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"65", 
     "92.77567559410595`", "\<\"rollKS0(-0.996248)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"66", 
     "92.77567560045782`", "\<\"pitchKS0(0.996248)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"67", 
     "92.77938180347252`", "\<\"rollKS3(-0.995076)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"68", 
     "92.79242794309825`", "\<\"pitchKS3(-0.995057)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"69", 
     "104.03308980515189`", "\<\"rollKS2(0.994833)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"70", 
     "104.04939813902644`", "\<\"pitchKS2(0.994809)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"71", 
     "113.32473990490314`", "\<\"rollKS1(-0.99497)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"72", 
     "113.34339624086078`", "\<\"pitchKS1(-0.994946)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"73", 
     "119.48932139733805`", "\<\"pitchKS4(-0.999909)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"74", 
     "119.51065612256144`", "\<\"rollKS4(0.999909)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"75", 
     "130.40124067610523`", "\<\"pitchKS0(-0.999833)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"76", 
     "130.40124067768818`", "\<\"rollKS0(0.999833)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"77", 
     "137.59876598422315`", "\<\"pitchKS3(-0.999916)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"78", 
     "137.6220693687376`", "\<\"rollKS3(0.999915)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"79", 
     "153.58729253538266`", "\<\"pitchKS2(-0.99992)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"80", 
     "153.61578442457312`", "\<\"rollKS2(0.999919)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"81", 
     "168.46237373323208`", "\<\"pitchKS1(0.999917)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"82", 
     "168.49525296743982`", "\<\"rollKS1(-0.999916)\"\>", "\<\"\"\>", "\<\"\"\
\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"83", 
     "186.74199685915355`", "\<\"yawKS4(-0.999999)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"84", 
     "198.98411570066727`", "\<\"yawKS0(-1.)\"\>", "\<\"\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"85", 
     "210.67364677154032`", "\<\"yawKS3(0.999999)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"86", 
     "232.1511698496585`", "\<\"yawKS2(0.999999)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"87", 
     "258.02179693963905`", "\<\"yawKS1(-0.999999)\"\>", "\<\"\"\>", \
"\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\
\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{"N", "Freq", "Type"}, {
    1, 0.006611274804478073, "yawF3(0.232007)", "yawF4(0.341188)", 
     "yawIM(0.408035)", "yawIRM(0.341267)", "yawTM(0.40808)", 
     "yawRM(0.408085)", "yawKS3(0.232008)", "yawKS4(0.341188)"}, {
    2, 0.01752036233352758, "yawF2(-0.220169)", "yawF3(-0.242462)", 
     "yawIM(0.49668)", "yawTM(0.497066)", "yawRM(0.497112)", 
     "yawKS2(-0.220169)", "yawKS3(-0.242461)"}, {
    3, 0.022869555283969445`, "yawF1(-0.223954)", "yawF2(-0.356402)", 
     "yawF4(0.301612)", "yawIM(-0.313566)", "yawIRM(0.302448)", 
     "yawTM(-0.313981)", "yawRM(-0.31403)", "yawKS1(-0.223955)", 
     "yawKS2(-0.356401)", "yawKS4(0.30161)"}, {
    4, 0.02553509590231963, "xF0(0.253964)", "xF1(0.255397)", "xF2(0.256841)",
      "xF3(0.258461)", "xF4(0.259903)", "xIM(0.261337)", "xIRM(0.261338)", 
     "xTM(0.262779)", "xRM(0.262778)", "xMD(0.255131)", "xKS0(0.253966)", 
     "xKS1(0.255406)", "xKS2(0.25685)", "xKS3(0.258469)", "xKS4(0.25991)"}, {
    5, 0.02553509616514809, "zF0(0.253973)", "zF1(0.255407)", "zF2(0.256851)",
      "zF3(0.258471)", "zF4(0.259913)", "zIM(0.261347)", "zIRM(0.261348)", 
     "zTM(0.26279)", "zRM(0.262789)", "zMD(0.255141)", "zKS0(0.253976)", 
     "zKS1(0.255416)", "zKS2(0.25686)", "zKS3(0.258479)", "zKS4(0.25992)"}, {
    6, 0.035086459518890896`, "yawF1(0.375767)", "yawF2(0.252664)", 
     "yawF3(-0.523708)", "yawKS1(0.375766)", "yawKS2(0.252658)", 
     "yawKS3(-0.523704)"}, {
    7, 0.04897215036196222, "yawF1(-0.526184)", "yawF2(0.44421)", 
     "yawKS1(-0.526175)", "yawKS2(0.444205)"}, {
    8, 0.08895749918516478, "yawF0(-0.566758)", "yawMD(-0.58288)", 
     "yawKS0(-0.566751)"}, {
    9, 0.1646651328468239, "yF3(0.207799)", "yF4(0.293925)", "yIM(0.391721)", 
     "yIRM(0.294179)", "yTM(0.392043)", "yRM(0.391977)", "yKS2(0.207542)", 
     "yKS3(0.293683)", "yKS4(0.391522)"}, {
    10, 0.20014242250588496`, "xIM(-0.329829)", "xIRM(-0.27447)", 
     "xTM(-0.498044)", "xRM(-0.49862)", "xMD(0.223925)"}, {
    11, 0.20023398877257859`, "zIM(0.339157)", "zIRM(0.282895)", 
     "zTM(0.512149)", "zRM(0.512233)", "zMD(-0.230469)"}, {
    12, 0.26375099851074074`, "rollIM(0.577017)", "rollTM(0.577176)", 
     "rollRM(0.577425)"}, {
    13, 0.30911354722807866`, "pitchIM(0.436044)", "zIRM(0.493072)", 
     "zTM(-0.240528)", "pitchTM(0.444171)", "zRM(-0.24922)", 
     "pitchRM(0.452897)"}, {
    14, 0.31060684546864176`, "rollIM(-0.284779)", "xIRM(-0.666999)", 
     "xTM(0.349332)", "rollTM(-0.284868)", "xRM(0.336619)", 
     "rollRM(-0.285052)"}, {
    15, 0.34157439410258456`, "pitchIM(0.558737)", "pitchTM(0.566388)", 
     "pitchRM(0.584928)"}, {16, 0.3448676215540721, "xTM(-0.99212)"}, {
    17, 0.3455376996112846, "pitchIM(-0.462647)", "zTM(0.554523)", 
     "pitchTM(-0.487992)", "pitchRM(-0.484271)"}, {
    18, 0.3841411517511399, "xMD(-0.976194)"}, {
    19, 0.3841553153998802, "zMD(0.973206)"}, {
    20, 0.42867605070704884`, "yF2(-0.280903)", "yF3(-0.328027)", 
     "yF4(-0.226581)", "yIM(0.325864)", "yIRM(-0.227916)", "yTM(0.327688)", 
     "yRM(0.327311)", "yKS1(-0.280508)", "yKS2(-0.327886)", "yKS3(-0.226879)",
      "yKS4(0.324735)"}, {
    21, 0.46614340634053886`, "xF2(-0.222123)", "xF3(-0.34709)", 
     "xF4(-0.298956)", "rollF4(0.206344)", "xIRM(0.36079)", 
     "rollIRM(0.207314)", "xTM(0.200938)", "xRM(0.202737)", "xKS2(-0.223188)",
      "xKS3(-0.347481)", "xKS4(-0.296978)", "rollKS4(0.207903)"}, {
    22, 0.4663498460894357, "zF2(0.22508)", "zF3(0.351459)", "zF4(0.303735)", 
     "zIRM(-0.366236)", "zTM(-0.204358)", "zRM(-0.20669)", "zKS2(0.226159)", 
     "zKS3(0.351855)", "zKS4(0.302309)"}, {
    23, 0.517422628441875, "rollF4(0.574031)", "rollIRM(0.577104)", 
     "rollKS4(0.580058)"}, {
    24, 0.5464958977194536, "pitchF4(-0.577814)", "pitchIRM(-0.581655)", 
     "pitchKS4(-0.571784)"}, {25, 0.5472037536912936, "yawMD(0.997835)"}, {
    26, 0.6010278062059558, "yawF4(0.558047)", "yawIRM(-0.614135)", 
     "yawKS4(0.55805)"}, {27, 0.6279727527011708, "yawTM(-0.999764)"}, {
    28, 0.6702404081331205, "yF1(-0.304113)", "yF2(-0.390868)", 
     "yF4(0.374778)", "yIRM(0.380224)", "yKS0(-0.303115)", "yKS1(-0.390627)", 
     "yKS3(0.373418)"}, {
    29, 0.7019749550871838, "xF2(0.29553)", "rollF3(-0.287582)", 
     "xF4(-0.203955)", "xIM(-0.504079)", "xKS2(0.29592)", 
     "rollKS3(-0.289412)", "xKS4(-0.202644)"}, {
    30, 0.7022997956316064, "zF2(-0.287165)", "pitchF3(-0.280573)", 
     "pitchF4(0.22461)", "zIM(0.489404)", "pitchIRM(0.227194)", 
     "zKS2(-0.287542)", "pitchKS3(-0.278796)", "pitchKS4(0.220742)"}, {
    31, 0.8375996921521169, "rollF3(-0.69988)", "rollKS3(-0.710016)"}, {
    32, 0.8376275451909397, "pitchF3(-0.70998)", "pitchKS3(-0.699757)"}, {
    33, 0.901202989483659, "pitchF2(0.245771)", "pitchF3(-0.55902)", 
     "zIM(0.247331)", "pitchKS2(0.243611)", "pitchKS3(-0.550599)"}, {
    34, 0.9012049180740906, "rollF2(-0.243192)", "rollF3(0.552649)", 
     "xIM(0.244603)", "rollKS2(-0.245349)", "rollKS3(0.561028)"}, {
    35, 0.9227153874209668, "yawIM(-0.665652)", "yawTM(0.576987)", 
     "yawRM(0.473279)"}, {
    36, 0.9614924762919154, "rollF2(-0.700557)", "rollKS2(-0.710746)"}, {
    37, 0.9615192680277201, "pitchF2(0.710771)", "pitchKS2(0.700497)"}, {
    38, 1.0084144058665307`, "yF1(0.424515)", "yF3(-0.521514)", 
     "yKS0(0.423185)", "yKS2(-0.519782)"}, {
    39, 1.0799599185237503`, "rollF1(-0.698659)", "rollKS1(-0.709542)"}, {
    40, 1.079995474405024, "pitchF1(0.709542)", "pitchKS1(0.698556)"}, {
    41, 1.1316350955291243`, "rollF1(0.527678)", "rollF2(-0.232344)", 
     "xF3(0.251332)", "xF4(-0.236755)", "rollKS1(0.534567)", 
     "rollKS2(-0.237284)", "xKS3(0.250312)", "xKS4(-0.236102)"}, {
    42, 1.1316871464759524`, "pitchF1(-0.531935)", "pitchF2(0.234357)", 
     "zF3(0.253479)", "zF4(-0.238775)", "pitchKS1(-0.525046)", 
     "pitchKS2(0.229404)", "zKS3(0.252451)", "zKS4(-0.238059)"}, {
    43, 1.2831074088531564`, "pitchTM(-0.999823)"}, {
    44, 1.3158684753795915`, "yF1(0.372369)", "yF2(-0.516956)", 
     "yF3(0.304963)", "yKS0(0.371272)", "yKS1(-0.514306)", 
     "yKS2(0.302372)"}, {
    45, 1.366967070780184, "xF1(0.38403)", "xF2(-0.454769)", 
     "rollF2(0.226845)", "xF3(0.254167)", "xKS1(0.382087)", "xKS2(-0.451802)",
      "rollKS2(0.226163)", "xKS3(0.252708)"}, {
    46, 1.3669729146468717`, "zF1(-0.383499)", "zF2(0.454152)", 
     "pitchF2(0.226536)", "zF3(-0.253852)", "zKS1(-0.381558)", 
     "zKS2(0.451188)", "pitchKS2(0.227258)", "zKS3(-0.252395)"}, {
    47, 2.8167868040521875`, "pitchIM(0.933985)", "pitchTM(-0.231431)", 
     "pitchRM(-0.272234)"}, {48, 4.546763801144445, "yMD(1.)"}, {
    49, 5.80375596256867, "yTM(0.994059)"}, {
    50, 6.42452829405283, "pitchMD(-0.999997)"}, {
    51, 6.424528294053039, "rollMD(-1.)"}, {
    52, 7.325426295074404, "yF4(0.500031)", "yIRM(-0.703129)", 
     "yKS3(0.505503)"}, {53, 8.113311870289929, "rollTM(0.999834)"}, {
    54, 8.530889641333166, "pitchF4(-0.499394)", "pitchIRM(0.709399)", 
     "pitchKS4(-0.497332)"}, {
    55, 9.542757433099792, "rollF4(-0.55393)", "rollIRM(0.612835)", 
     "rollKS4(-0.563535)"}, {
    56, 10.57236449292648, "yIM(0.61925)", "yTM(-0.25965)", "yRM(-0.36669)", 
     "yKS4(0.643925)"}, {
    57, 18.177587762433646`, "rollIM(0.940419)", "rollTM(-0.233543)", 
     "rollRM(-0.247124)"}, {58, 54.093124337514354`, "yKS4(0.998439)"}, {
    59, 63.442114856438174`, "yKS0(-0.998881)"}, {
    60, 63.80237764316609, "yKS3(-0.999284)"}, {
    61, 67.27371095509277, "yKS2(0.999313)"}, {
    62, 76.26828550511355, "yKS1(-0.999413)"}, {
    63, 79.89798123837188, "rollKS4(-0.995427)"}, {
    64, 79.91056100928303, "pitchKS4(0.995408)"}, {
    65, 92.77567559410595, "rollKS0(-0.996248)"}, {
    66, 92.77567560045782, "pitchKS0(0.996248)"}, {
    67, 92.77938180347252, "rollKS3(-0.995076)"}, {
    68, 92.79242794309825, "pitchKS3(-0.995057)"}, {
    69, 104.03308980515189`, "rollKS2(0.994833)"}, {
    70, 104.04939813902644`, "pitchKS2(0.994809)"}, {
    71, 113.32473990490314`, "rollKS1(-0.99497)"}, {
    72, 113.34339624086078`, "pitchKS1(-0.994946)"}, {
    73, 119.48932139733805`, "pitchKS4(-0.999909)"}, {
    74, 119.51065612256144`, "rollKS4(0.999909)"}, {
    75, 130.40124067610523`, "pitchKS0(-0.999833)"}, {
    76, 130.40124067768818`, "rollKS0(0.999833)"}, {
    77, 137.59876598422315`, "pitchKS3(-0.999916)"}, {
    78, 137.6220693687376, "rollKS3(0.999915)"}, {
    79, 153.58729253538266`, "pitchKS2(-0.99992)"}, {
    80, 153.61578442457312`, "rollKS2(0.999919)"}, {
    81, 168.46237373323208`, "pitchKS1(0.999917)"}, {
    82, 168.49525296743982`, "rollKS1(-0.999916)"}, {
    83, 186.74199685915355`, "yawKS4(-0.999999)"}, {
    84, 198.98411570066727`, "yawKS0(-1.)"}, {
    85, 210.67364677154032`, "yawKS3(0.999999)"}, {
    86, 232.1511698496585, "yawKS2(0.999999)"}, {
    87, 258.02179693963905`, "yawKS1(-0.999999)"}}]]], "Output",
 CellChangeTimes->{
  3.510643292919636*^9, 3.5106433400473185`*^9, 3.5106434238662653`*^9, 
   3.5106434762355576`*^9, 3.510643723168391*^9, 3.5106438344589863`*^9, 
   3.510643892756289*^9, 3.5106577700762196`*^9, 3.5108253730494413`*^9, 
   3.51082974384672*^9, 3.510829776169977*^9, 3.5108302338369813`*^9, 
   3.5108303752356296`*^9, {3.5108305553691463`*^9, 3.51083057477558*^9}, 
   3.5108307570151005`*^9, 3.510878378699349*^9, 3.5109217415145354`*^9, 
   3.510921781893845*^9, {3.5109221017821417`*^9, 3.5109221126697645`*^9}, 
   3.510956284636422*^9, 3.510958555156411*^9, 3.5109585879476686`*^9, 
   3.510976004120376*^9, 3.5109762241431627`*^9, 3.510981586648802*^9, 
   3.510997623852915*^9, 3.510997670574997*^9, 3.5109978286968746`*^9, 
   3.5110005994633493`*^9, 3.5110012262880497`*^9, 3.511002249466259*^9, 
   3.5110027958260183`*^9, 3.5110032275255766`*^9, 3.511003483288026*^9, 
   3.5110045135606356`*^9, 3.5110674087517023`*^9, 3.511144001897659*^9, 
   3.5111469200231843`*^9, 3.511147217780907*^9, 3.5111479339157653`*^9, 
   3.511149448413225*^9, {3.5111495020461197`*^9, 3.5111495104389343`*^9}, 
   3.511150737209489*^9, 3.51115124445998*^9, 3.5111525863899364`*^9, 
   3.511152661114068*^9, 3.5111551241458*^9, 3.5112282013762183`*^9, 
   3.511228596821313*^9, 3.5112287471743765`*^9, 3.5112289126906676`*^9, 
   3.5112289448423243`*^9, 3.5112292057371826`*^9, 3.5112293438286247`*^9, 
   3.511229669666397*^9, {3.511229940545273*^9, 3.511229945724482*^9}, 
   3.511230367908024*^9, 3.5112305163578844`*^9, 3.5112318289909897`*^9, 
   3.5112323159368496`*^9, 3.511232424778241*^9, 3.5112324581154995`*^9, 
   3.51123249266956*^9, 3.511232537082838*^9, 3.5112325809033155`*^9, 
   3.5112326565478477`*^9, 3.5112328450429792`*^9, 3.511232907536689*^9, 
   3.511233228663253*^9, 3.511329491833839*^9, 3.5113304379287033`*^9, 
   3.5113306313690434`*^9, 3.511331015972119*^9, 3.511331177635203*^9, 
   3.5113329869263806`*^9, 3.511406697171174*^9, 3.5114067818637223`*^9, 
   3.5114069491428165`*^9, 3.5114071480587654`*^9, 3.5114315657357717`*^9, 
   3.511490058913316*^9, 3.511494334787651*^9, 3.511496090224537*^9, 
   3.512355787464673*^9, 3.5123560041613693`*^9, 3.5127108132167463`*^9, 
   3.5127123258698044`*^9, 3.5127125177033415`*^9, 3.5127126119275064`*^9, 
   3.512730655448633*^9, 3.5127329310730324`*^9, 3.512803856311219*^9, 
   3.5141687865653296`*^9, 3.51416965823246*^9, 3.514173620607836*^9, 
   3.514511740592945*^9, 3.5145122675930705`*^9, 3.5145124275713515`*^9, 
   3.5188352823515215`*^9, 3.518835495510296*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigen Mode 3D-Graphics", "Subsection",
 CellChangeTimes->{{3.5108295124827137`*^9, 3.510829513075515*^9}, {
  3.510956048202407*^9, 3.510956066017638*^9}}],

Cell[CellGroupData[{

Cell["Plot Range Definition", "Subsubsection",
 CellChangeTimes->{{3.51082764299103*^9, 3.5108276467818365`*^9}, {
   3.5109210878847294`*^9, 3.51092116774127*^9}, 3.5109212261165724`*^9, 
   3.511003172847481*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"maxz", "=", 
    RowBox[{"2.5", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"z", "-", 
    RowBox[{"width", " ", "of", " ", "the", " ", "system"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"maxx", "=", 
    RowBox[{"2.5", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"x", "-", 
    RowBox[{"width", " ", "of", " ", "the", " ", "system"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ytop", "=", 
    RowBox[{"1.0", "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Top", " ", "height", " ", "of", " ", "the", " ", "system"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ybottom", "=", 
    RowBox[{
     RowBox[{"-", "13.0"}], "meter"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Bottom", " ", "height", " ", "of", " ", "the", " ", "system"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5109211968977213`*^9, 3.5109212408741984`*^9}, {
   3.5109220308510847`*^9, 3.5109220309910927`*^9}, {3.510958542473589*^9, 
   3.51095854336279*^9}, {3.510968368593365*^9, 3.510968418575853*^9}, {
   3.5109954409480605`*^9, 3.510995447197418*^9}, {3.5109987157704387`*^9, 
   3.510998749638098*^9}, {3.511001189939986*^9, 3.511001205306013*^9}, 
   3.511003172847481*^9, {3.511129432507734*^9, 3.5111294518908424`*^9}, {
   3.511152966983805*^9, 3.5111529708682117`*^9}, {3.511228562750853*^9, 
   3.5112285692248645`*^9}, {3.511229309087364*^9, 3.5112293130029707`*^9}, {
   3.511329984950708*^9, 3.5113299977115307`*^9}, {3.5127101502779818`*^9, 
   3.512710157438394*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigen Mode 3D-Graphics", "Subsubsection",
 CellChangeTimes->{{3.512709012365183*^9, 3.5127090238936033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eigenplot", "[", 
  RowBox[{"eigenv", ",", "0.3", ",", "16"}], "]"}]], "Input",
 CellChangeTimes->{{3.5108281708803577`*^9, 3.5108281797879734`*^9}, {
   3.510829089456771*^9, 3.510829089612771*^9}, {3.5108291378012557`*^9, 
   3.510829143760466*^9}, {3.510829207346178*^9, 3.5108292251926093`*^9}, {
   3.510829318496373*^9, 3.5108293323959975`*^9}, {3.510829380802882*^9, 
   3.510829395279708*^9}, {3.5108294539514112`*^9, 3.510829454965413*^9}, {
   3.5108783919749727`*^9, 3.5108784826891317`*^9}, {3.5108858833120837`*^9, 
   3.510885917039343*^9}, {3.510922053102357*^9, 3.5109220655000668`*^9}, {
   3.510922145501642*^9, 3.510922154304146*^9}, {3.5109586034072957`*^9, 
   3.5109586510965796`*^9}, 3.510965620835739*^9, {3.510980713272068*^9, 
   3.510980713412468*^9}, {3.510980751289335*^9, 3.5109807514297347`*^9}, {
   3.5109808130498433`*^9, 3.5109808621743293`*^9}, {3.5109855664036036`*^9, 
   3.5109855667624035`*^9}, {3.5109976790926123`*^9, 
   3.5109976792174125`*^9}, {3.511001058291355*^9, 3.511001058431755*^9}, {
   3.5110023185587797`*^9, 3.5110024376649895`*^9}, {3.5110673866620636`*^9, 
   3.511067386771264*^9}, {3.5110674313873425`*^9, 3.5110674526969795`*^9}, {
   3.511144014627281*^9, 3.511144014752082*^9}, {3.5111443615094905`*^9, 
   3.5111444172171884`*^9}, {3.5111444872457113`*^9, 
   3.5111444874173117`*^9}, {3.5111456221165047`*^9, 3.511145622912106*^9}, {
   3.5111469295080013`*^9, 3.5111469378540154`*^9}, {3.511151653352298*^9, 
   3.5111516692799263`*^9}, {3.511151703802787*^9, 3.511151709512397*^9}, {
   3.511151764393293*^9, 3.5111517990409536`*^9}, {3.5111527228745766`*^9, 
   3.5111527274921846`*^9}, {3.5111617369272847`*^9, 
   3.5111617373016853`*^9}, {3.5112282465694976`*^9, 
   3.5112282467566977`*^9}, {3.51122895378114*^9, 3.5112289539215403`*^9}, {
   3.511229358477051*^9, 3.511229397243119*^9}, {3.511229844729905*^9, 
   3.5112298448859053`*^9}, {3.5112299955977697`*^9, 3.511230027671426*^9}, {
   3.511230389014861*^9, 3.5112304126021023`*^9}, {3.511230529056307*^9, 
   3.5112305886172113`*^9}, {3.5112323789921603`*^9, 3.511232379179361*^9}, {
   3.511329531691909*^9, 3.5113295318791094`*^9}, {3.5113300860076857`*^9, 
   3.5113301632590213`*^9}, {3.5113302681380053`*^9, 3.511330268933607*^9}, {
   3.511330485617987*^9, 3.5113304862263885`*^9}, {3.5114070321661625`*^9, 
   3.5114070887786617`*^9}, {3.511407177605218*^9, 3.511407177886018*^9}, {
   3.511431574518587*^9, 3.511431579869396*^9}, {3.512710907830912*^9, 
   3.5127109337113576`*^9}, {3.512730678006273*^9, 3.5127307128567343`*^9}, {
   3.5128038599460254`*^9, 3.512803860897627*^9}, {3.5141688026645575`*^9, 
   3.514168802836158*^9}, {3.514169781753477*^9, 3.5141697820186777`*^9}, {
   3.5145124135625267`*^9, 3.5145124144361286`*^9}}],

Cell[BoxData[
 Graphics3DBox[{Point3DBox[{1.25, 1., 1.25}], Point3DBox[{-1.25, 1., 1.25}], 
   Point3DBox[{1.25, 1., -1.25}], Point3DBox[{-1.25, 1., -1.25}], 
   Point3DBox[{1.25, -13., 1.25}], Point3DBox[{-1.25, -13., 1.25}], 
   Point3DBox[{1.25, -13., -1.25}], Point3DBox[{-1.25, -13., -1.25}], 
   Line3DBox[{{1.673790912970372*^-7, 0.4867479682464967, 
    1.6025513612019303`*^-15}, {-3.628417294701211*^-8, -1.5944600682320629`, \
-2.2359586835542945`*^-16}}], 
   Line3DBox[{{-4.040676538818394*^-8, -1.6305896498958634`, \
-2.5436884207139746`*^-16}, {-2.8109424666109173`*^-7, -3.71200325516101, \
-2.1582935982706906`*^-15}}], 
   Line3DBox[{{-2.8567597622283046`*^-7, -3.747326413697286, \
-2.2162498517158838`*^-15}, {-5.442439629174079*^-7, -6.079904588197378, \
-4.584378566818743*^-15}}], 
   Line3DBox[{{-5.481925605362881*^-7, -6.113608710368101, \
-4.50898088422439*^-15}, {-6.854880597501004*^-7, -8.182511160485962, \
-4.519341684302167*^-15}}], 
   Line3DBox[{{-1.1333595423787333`*^-7, -8.214798874777498, \
-4.5081353053986595`*^-15}, {
    0.00019534807246427742`, -10.281412666907412`, -4.440544339356469*^-15}}],
    Line3DBox[{{-0.30000038790151684`, -8.205798720156105, \
-0.2500000000000033}, {-0.3005055164321874, -10.293672053331068`, \
-0.2500000000000006}}], 
   Line3DBox[{{-0.30000038790151484`, -8.205798720156105, 
    0.2499999999999967}, {-0.30050551643218976`, -10.293672053331068`, 
    0.2499999999999994}}], 
   Line3DBox[{{0.2999996120494879, -8.205791052258393, 
    0.24999999999999425`}, {0.29949448351908975`, -10.29366440711743, 
    0.25000000000000216`}}], 
   Line3DBox[{{0.2999996120494859, -8.205791052258393, -0.2500000000000057}, {
    0.2994944835190921, -10.29366440711743, -0.2499999999999978}}], 
   Line3DBox[{{-0.1248484802698888, -10.287183654980621`, \
-0.014999999999993697`}, {-0.42262117700503815`, -12.377446298721669`, \
-0.014999999984850774`}}], 
   Line3DBox[{{-0.12484848026988617`, -10.287183654980623`, 
    0.015000000000006302`}, {-0.4226211770050338, -12.37744629872166, 
    0.015000000015149225`}}], 
   Line3DBox[{{0.1251452974736778, -10.288947483062248`, 
    0.014999999999984248`}, {-0.17262761053733458`, -12.379239821724036`, 
    0.015000000015113648`}}], 
   Line3DBox[{{
    0.12514529747367517`, -10.288947483062246`, -0.01500000000001575}, \
{-0.1726276105373389, -12.379239821724045`, -0.014999999984886351`}}], 
   Line3DBox[{{-0.28886301469747955`, -10.288665129525693`, \
-0.034999999999979346`}, {-0.2534463341860059, -12.372116411095714`, \
-0.035000000001768075`}}], 
   Line3DBox[{{-0.2888630146974734, -10.288665129525697`, 
    0.03500000000002066}, {-0.25344633418599677`, -12.37211641109572, 
    0.03499999999823193}}], 
   Line3DBox[{{0.2891225994456465, -10.292743100050416`, 
    0.03499999999996967}, {0.3245392600772495, -12.37619719829454, 
    0.034999999998156534`}}], 
   Line3DBox[{{
    0.28912259944564034`, -10.292743100050412`, -0.03500000000003033}, {
    0.3245392600772404, -12.376197198294534`, -0.03500000000184347}}], 
   Line3DBox[{{-0.3499998323126053, 0.2990996570817299, 
    1.6409159657312559`*^-15}, {-0.34999898477335806`, -1.445119657448649, 
    1.0769413241770342`*^-14}}], 
   Line3DBox[{{0.17500016768739463`, 
    0.2990996570817299, -0.303108891324552}, {
    0.17500101522664188`, -1.445119657544096, -0.3031088913245429}}], 
   Line3DBox[{{0.17500016768739493`, 0.2990996570817299, 
    0.3031088913245551}, {0.17500101522664221`, -1.445119657544096, 
    0.3031088913245642}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.6657397290940023, 0.6, 0.21631189606246484`}, {
         0.6657397290940023, 0.4, 0.21631189606246484`}, {0.566312063749858, 
         0.4, 0.41144967660473286`}, {0.566312063749858, 0.6, 
         0.41144967660473286`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.566312063749858, 0.6, 0.41144967660473286`}, {
         0.566312063749858, 0.4, 0.41144967660473286`}, {0.411449844292126, 
         0.4, 0.5663118960624648}, {0.411449844292126, 0.6, 
         0.5663118960624648}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.411449844292126, 0.6, 0.5663118960624648}, {
         0.411449844292126, 0.4, 0.5663118960624648}, {0.21631206374985795`, 
         0.4, 0.6657395614066091}, {0.21631206374985795`, 0.6, 
         0.6657395614066091}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.21631206374985795`, 0.6, 0.6657395614066091}, {
         0.21631206374985795`, 0.4, 0.6657395614066091}, {
         1.6768739472825917`*^-7, 0.4, 0.7000000000000016}, {
         1.6768739472825917`*^-7, 0.6, 0.7000000000000016}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{1.6768739472825917`*^-7, 0.6, 0.7000000000000016}, {
         1.6768739472825917`*^-7, 0.4, 
         0.7000000000000016}, {-0.2163117283750685, 0.4, 
         0.6657395614066091}, {-0.2163117283750685, 0.6, 
         0.6657395614066091}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2163117283750685, 0.6, 
         0.6657395614066091}, {-0.2163117283750685, 0.4, 
         0.6657395614066091}, {-0.4114495089173365, 0.4, 
         0.5663118960624648}, {-0.4114495089173365, 0.6, 
         0.5663118960624648}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.4114495089173365, 0.6, 
         0.5663118960624648}, {-0.4114495089173365, 0.4, 
         0.5663118960624648}, {-0.5663117283750685, 0.4, 
         0.41144967660473286`}, {-0.5663117283750685, 0.6, 
         0.41144967660473286`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.5663117283750685, 0.6, 
         0.41144967660473286`}, {-0.5663117283750685, 0.4, 
         0.41144967660473286`}, {-0.6657393937192128, 0.4, 
         0.21631189606246484`}, {-0.6657393937192128, 0.6, 
         0.21631189606246484`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.6657393937192128, 0.6, 
         0.21631189606246484`}, {-0.6657393937192128, 0.4, 
         0.21631189606246484`}, {-0.6999998323126053, 0.4, 
         1.6057669929401085`*^-15}, {-0.6999998323126053, 0.6, 
         1.6057669929401085`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.6999998323126053, 0.6, 
         1.6057669929401085`*^-15}, {-0.6999998323126053, 0.4, 
         1.6057669929401085`*^-15}, {-0.6657393937192128, 
         0.4, -0.21631189606246162`}, {-0.6657393937192128, 
         0.6, -0.21631189606246162`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.6657393937192128, 
         0.6, -0.21631189606246162`}, {-0.6657393937192128, 
         0.4, -0.21631189606246162`}, {-0.5663117283750685, 
         0.4, -0.41144967660472964`}, {-0.5663117283750685, 
         0.6, -0.41144967660472964`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.5663117283750685, 
         0.6, -0.41144967660472964`}, {-0.5663117283750685, 
         0.4, -0.41144967660472964`}, {-0.4114495089173365, 
         0.4, -0.5663118960624617}, {-0.4114495089173365, 
         0.6, -0.5663118960624617}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.4114495089173365, 
         0.6, -0.5663118960624617}, {-0.4114495089173365, 
         0.4, -0.5663118960624617}, {-0.2163117283750685, 
         0.4, -0.665739561406606}, {-0.2163117283750685, 
         0.6, -0.665739561406606}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2163117283750685, 
         0.6, -0.665739561406606}, {-0.2163117283750685, 
         0.4, -0.665739561406606}, {1.6768739472825917`*^-7, 
         0.4, -0.6999999999999985}, {1.6768739472825917`*^-7, 
         0.6, -0.6999999999999985}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{1.6768739472825917`*^-7, 0.6, -0.6999999999999985}, {
         1.6768739472825917`*^-7, 0.4, -0.6999999999999985}, {
         0.21631206374985795`, 0.4, -0.665739561406606}, {
         0.21631206374985795`, 0.6, -0.665739561406606}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.21631206374985795`, 0.6, -0.665739561406606}, {
         0.21631206374985795`, 0.4, -0.665739561406606}, {0.411449844292126, 
         0.4, -0.5663118960624617}, {0.411449844292126, 
         0.6, -0.5663118960624617}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.411449844292126, 0.6, -0.5663118960624617}, {
         0.411449844292126, 0.4, -0.5663118960624617}, {0.566312063749858, 
         0.4, -0.41144967660472964`}, {0.566312063749858, 
         0.6, -0.41144967660472964`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.566312063749858, 0.6, -0.41144967660472964`}, {
         0.566312063749858, 0.4, -0.41144967660472964`}, {0.6657397290940023, 
         0.4, -0.21631189606246162`}, {0.6657397290940023, 
         0.6, -0.21631189606246162`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.6657397290940023, 0.6, -0.21631189606246162`}, {
         0.6657397290940023, 0.4, -0.21631189606246162`}, {0.7000001676873948,
          0.4, 1.6057669929401085`*^-15}, {0.7000001676873948, 0.6, 
         1.6057669929401085`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.7000001676873948, 0.6, 1.6057669929401085`*^-15}, {
         0.7000001676873948, 0.4, 1.6057669929401085`*^-15}, {
         0.6657397290940023, 0.4, 0.21631189606246484`}, {0.6657397290940023, 
         0.6, 0.21631189606246484`}}]}}, {{{1., 0., 0.}, {0., 1., 0.}, {0., 
       0., 1.}}, {0., 0., 0.}}], {{{1., 0., 1.0042563654613579`*^-16}, {0., 
      1., 0.}, {-1.0042563654613579`*^-16, 0., 1.}}, {0., 0., 
      1.6840113313681697`*^-23}}], {{{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
     1.}}, {0., 0., 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26629578562728456`, -1.5177120999857507`, 
         0.08652475842498504}, {0.35189087209384834`, -1.717712099985751, 
         0.11433628791873031`}, {0.29933624898337213`, -1.717712099985751, 
         0.21748054334821482`}, {0.22652471948962688`, -1.5177120999857507`, 
         0.16457987064189225`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.22652471948962688`, -1.5177120999857507`, 
         0.16457987064189225`}, {0.29933624898337213`, -1.717712099985751, 
         0.21748054334821482`}, {0.21748050441285663`, -1.717712099985751, 
         0.29933628791873035`}, {0.16457983170653406`, -1.5177120999857507`, 
         0.22652475842498507`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457983170653406`, -1.5177120999857507`, 
         0.22652475842498507`}, {0.21748050441285663`, -1.717712099985751, 
         0.29933628791873035`}, {0.11433624898337212`, -1.717712099985751, 
         0.35189091102920655`}, {0.08652471948962685, -1.5177120999857507`, 
         0.2662958245626428}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652471948962685, -1.5177120999857507`, 
         0.2662958245626428}, {0.11433624898337212`, -1.717712099985751, 
         0.35189091102920655`}, {-3.893535844030226*^-8, -1.717712099985751, 
         0.3699999999999998}, {-3.893535844030226*^-8, -1.5177120999857507`, 
         0.2799999999999998}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-3.893535844030226*^-8, -1.5177120999857507`, 
         0.2799999999999998}, {-3.893535844030226*^-8, -1.717712099985751, 
         0.3699999999999998}, {-0.114336326854089, -1.717712099985751, 
         0.35189091102920655`}, {-0.08652479736034373, -1.5177120999857507`, 
         0.2662958245626428}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652479736034373, -1.5177120999857507`, 
         0.2662958245626428}, {-0.114336326854089, -1.717712099985751, 
         0.35189091102920655`}, {-0.2174805822835735, -1.717712099985751, 
         0.29933628791873035`}, {-0.16457990957725094`, -1.5177120999857507`, 
         0.22652475842498507`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457990957725094`, -1.5177120999857507`, 
         0.22652475842498507`}, {-0.2174805822835735, -1.717712099985751, 
         0.29933628791873035`}, {-0.299336326854089, -1.717712099985751, 
         0.21748054334821482`}, {-0.22652479736034375`, -1.5177120999857507`, 
         0.16457987064189225`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652479736034375`, -1.5177120999857507`, 
         0.16457987064189225`}, {-0.299336326854089, -1.717712099985751, 
         0.21748054334821482`}, {-0.3518909499645652, -1.717712099985751, 
         0.11433628791873031`}, {-0.26629586349800144`, -1.5177120999857507`, 
         0.08652475842498504}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629586349800144`, -1.5177120999857507`, 
         0.08652475842498504}, {-0.3518909499645652, -1.717712099985751, 
         0.11433628791873031`}, {-0.37000003893535843`, -1.717712099985751, \
-2.4482040089975313`*^-16}, {-0.28000003893535846`, -1.5177120999857507`, \
-2.4482040089975313`*^-16}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.28000003893535846`, -1.5177120999857507`, \
-2.4482040089975313`*^-16}, {-0.37000003893535843`, -1.717712099985751, \
-2.4482040089975313`*^-16}, {-0.3518909499645652, -1.717712099985751, \
-0.11433628791873081`}, {-0.26629586349800144`, -1.5177120999857507`, \
-0.08652475842498554}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629586349800144`, -1.5177120999857507`, \
-0.08652475842498554}, {-0.3518909499645652, -1.717712099985751, \
-0.11433628791873081`}, {-0.299336326854089, -1.717712099985751, \
-0.21748054334821532`}, {-0.22652479736034375`, -1.5177120999857507`, \
-0.16457987064189275`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652479736034375`, -1.5177120999857507`, \
-0.16457987064189275`}, {-0.299336326854089, -1.717712099985751, \
-0.21748054334821532`}, {-0.2174805822835735, -1.717712099985751, \
-0.2993362879187308}, {-0.16457990957725094`, -1.5177120999857507`, \
-0.22652475842498557`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16457990957725094`, -1.5177120999857507`, \
-0.22652475842498557`}, {-0.2174805822835735, -1.717712099985751, \
-0.2993362879187308}, {-0.114336326854089, -1.717712099985751, \
-0.351890911029207}, {-0.08652479736034373, -1.5177120999857507`, \
-0.2662958245626432}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652479736034373, -1.5177120999857507`, \
-0.2662958245626432}, {-0.114336326854089, -1.717712099985751, \
-0.351890911029207}, {-3.893535844030226*^-8, -1.717712099985751, \
-0.3700000000000002}, {-3.893535844030226*^-8, -1.5177120999857507`, \
-0.28000000000000025`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-3.893535844030226*^-8, -1.5177120999857507`, \
-0.28000000000000025`}, {-3.893535844030226*^-8, -1.717712099985751, \
-0.3700000000000002}, {
         0.11433624898337212`, -1.717712099985751, -0.351890911029207}, {
         0.08652471948962685, -1.5177120999857507`, -0.2662958245626432}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652471948962685, -1.5177120999857507`, -0.2662958245626432}, {
         0.11433624898337212`, -1.717712099985751, -0.351890911029207}, {
         0.21748050441285663`, -1.717712099985751, -0.2993362879187308}, {
         0.16457983170653406`, -1.5177120999857507`, \
-0.22652475842498557`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457983170653406`, -1.5177120999857507`, -0.22652475842498557`}, {
         0.21748050441285663`, -1.717712099985751, -0.2993362879187308}, {
         0.29933624898337213`, -1.717712099985751, -0.21748054334821532`}, {
         0.22652471948962688`, -1.5177120999857507`, \
-0.16457987064189275`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.22652471948962688`, -1.5177120999857507`, -0.16457987064189275`}, {
         0.29933624898337213`, -1.717712099985751, -0.21748054334821532`}, {
         0.35189087209384834`, -1.717712099985751, -0.11433628791873081`}, {
         0.26629578562728456`, -1.5177120999857507`, -0.08652475842498554}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.26629578562728456`, -1.5177120999857507`, -0.08652475842498554}, {
         0.35189087209384834`, -1.717712099985751, -0.11433628791873081`}, {
         0.36999996106464156`, -1.717712099985751, \
-2.4482040089975313`*^-16}, {
         0.2799999610646416, -1.5177120999857507`, \
-2.4482040089975313`*^-16}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2799999610646416, -1.5177120999857507`, \
-2.4482040089975313`*^-16}, {
         0.36999996106464156`, -1.717712099985751, \
-2.4482040089975313`*^-16}, {0.35189087209384834`, -1.717712099985751, 
         0.11433628791873031`}, {0.26629578562728456`, -1.5177120999857507`, 
         0.08652475842498504}}]}}, {{{1., 0., 0.}, {0., 
       1., -9.128033528062377*^-16}, {0., 9.128033528062377*^-16, 1.}}, {0., 
       0., 1.476653028742213*^-15}}], {{{1., 0., 1.2267967534835704`*^-16}, {
      0., 1., 0.}, {-1.2267967534835704`*^-16, 0., 1.}}, {0., 
      0., -4.776577137193675*^-24}}], {{{0.9999999999999934, 
     1.140195197294801*^-7, 0.}, {-1.140195197294801*^-7, 0.9999999999999934, 
     0.}, {0., 0., 1.}}, {1.8445075670094375`*^-7, -1.509903313490213*^-14, 
     0.}}], GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2662955404620583, -3.634880805071405, 
         0.0865247584249831}, {0.35189062692862205`, -3.834880805071405, 
         0.11433628791872837`}, {0.29933600381814585`, -3.834880805071405, 
         0.21748054334821287`}, {0.2265244743244006, -3.634880805071405, 
         0.1645798706418903}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265244743244006, -3.634880805071405, 
         0.1645798706418903}, {0.29933600381814585`, -3.834880805071405, 
         0.21748054334821287`}, {0.21748025924763034`, -3.834880805071405, 
         0.29933628791872835`}, {0.16457958654130778`, -3.634880805071405, 
         0.22652475842498312`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457958654130778`, -3.634880805071405, 
         0.22652475842498312`}, {0.21748025924763034`, -3.834880805071405, 
         0.29933628791872835`}, {0.11433600381814583`, -3.834880805071405, 
         0.35189091102920456`}, {0.08652447432440057, -3.634880805071405, 
         0.2662958245626408}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652447432440057, -3.634880805071405, 
         0.2662958245626408}, {0.11433600381814583`, -3.834880805071405, 
         0.35189091102920456`}, {-2.8410058473036883`*^-7, -3.834880805071405,
          0.3699999999999978}, {-2.8410058473036883`*^-7, -3.634880805071405, 
         0.2799999999999978}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.8410058473036883`*^-7, -3.634880805071405, 
         0.2799999999999978}, {-2.8410058473036883`*^-7, -3.834880805071405, 
         0.3699999999999978}, {-0.11433657201931528`, -3.834880805071405, 
         0.35189091102920456`}, {-0.08652504252557001, -3.634880805071405, 
         0.2662958245626408}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652504252557001, -3.634880805071405, 
         0.2662958245626408}, {-0.11433657201931528`, -3.834880805071405, 
         0.35189091102920456`}, {-0.2174808274487998, -3.834880805071405, 
         0.29933628791872835`}, {-0.16458015474247722`, -3.634880805071405, 
         0.22652475842498312`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16458015474247722`, -3.634880805071405, 
         0.22652475842498312`}, {-0.2174808274487998, -3.834880805071405, 
         0.29933628791872835`}, {-0.2993365720193153, -3.834880805071405, 
         0.21748054334821287`}, {-0.22652504252557004`, -3.634880805071405, 
         0.1645798706418903}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652504252557004`, -3.634880805071405, 
         0.1645798706418903}, {-0.2993365720193153, -3.834880805071405, 
         0.21748054334821287`}, {-0.3518911951297915, -3.834880805071405, 
         0.11433628791872837`}, {-0.2662961086632277, -3.634880805071405, 
         0.0865247584249831}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2662961086632277, -3.634880805071405, 
         0.0865247584249831}, {-0.3518911951297915, -3.834880805071405, 
         0.11433628791872837`}, {-0.3700002841005847, -3.834880805071405, \
-2.199006198005543*^-15}, {-0.28000028410058475`, -3.634880805071405, \
-2.199006198005543*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.28000028410058475`, -3.634880805071405, \
-2.199006198005543*^-15}, {-0.3700002841005847, -3.834880805071405, \
-2.199006198005543*^-15}, {-0.3518911951297915, -3.834880805071405, \
-0.11433628791873275`}, {-0.2662961086632277, -3.634880805071405, \
-0.08652475842498748}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2662961086632277, -3.634880805071405, \
-0.08652475842498748}, {-0.3518911951297915, -3.834880805071405, \
-0.11433628791873275`}, {-0.2993365720193153, -3.834880805071405, \
-0.21748054334821726`}, {-0.22652504252557004`, -3.634880805071405, \
-0.1645798706418947}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652504252557004`, -3.634880805071405, \
-0.1645798706418947}, {-0.2993365720193153, -3.834880805071405, \
-0.21748054334821726`}, {-0.2174808274487998, -3.834880805071405, \
-0.2993362879187328}, {-0.16458015474247722`, -3.634880805071405, \
-0.2265247584249875}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16458015474247722`, -3.634880805071405, \
-0.2265247584249875}, {-0.2174808274487998, -3.834880805071405, \
-0.2993362879187328}, {-0.11433657201931528`, -3.834880805071405, \
-0.351890911029209}, {-0.08652504252557001, -3.634880805071405, \
-0.2662958245626452}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652504252557001, -3.634880805071405, \
-0.2662958245626452}, {-0.11433657201931528`, -3.834880805071405, \
-0.351890911029209}, {-2.8410058473036883`*^-7, -3.834880805071405, \
-0.3700000000000022}, {-2.8410058473036883`*^-7, -3.634880805071405, \
-0.28000000000000225`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.8410058473036883`*^-7, -3.634880805071405, \
-0.28000000000000225`}, {-2.8410058473036883`*^-7, -3.834880805071405, \
-0.3700000000000022}, {
         0.11433600381814583`, -3.834880805071405, -0.351890911029209}, {
         0.08652447432440057, -3.634880805071405, -0.2662958245626452}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652447432440057, -3.634880805071405, -0.2662958245626452}, {
         0.11433600381814583`, -3.834880805071405, -0.351890911029209}, {
         0.21748025924763034`, -3.834880805071405, -0.2993362879187328}, {
         0.16457958654130778`, -3.634880805071405, -0.2265247584249875}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457958654130778`, -3.634880805071405, -0.2265247584249875}, {
         0.21748025924763034`, -3.834880805071405, -0.2993362879187328}, {
         0.29933600381814585`, -3.834880805071405, -0.21748054334821726`}, {
         0.2265244743244006, -3.634880805071405, -0.1645798706418947}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265244743244006, -3.634880805071405, -0.1645798706418947}, {
         0.29933600381814585`, -3.834880805071405, -0.21748054334821726`}, {
         0.35189062692862205`, -3.834880805071405, -0.11433628791873275`}, {
         0.2662955404620583, -3.634880805071405, -0.08652475842498748}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2662955404620583, -3.634880805071405, -0.08652475842498748}, {
         0.35189062692862205`, -3.834880805071405, -0.11433628791873275`}, {
         0.36999971589941527`, -3.834880805071405, -2.199006198005543*^-15}, {
         0.2799997158994153, -3.634880805071405, -2.199006198005543*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2799997158994153, -3.634880805071405, -2.199006198005543*^-15}, {
         0.36999971589941527`, -3.834880805071405, -2.199006198005543*^-15}, {
         0.35189062692862205`, -3.834880805071405, 0.11433628791872837`}, {
         0.2662955404620583, -3.634880805071405, 0.0865247584249831}}]}}, {{{
       1., 0., 0.}, {0., 1., -1.7795874074939043`*^-15}, {0., 
       1.7795874074939043`*^-15, 1.}}, {0., 0., 6.646546849195768*^-15}}], {{{
      1., 0., 1.1897203404686487`*^-15}, {0., 1., 
      0.}, {-1.1897203404686487`*^-15, 0., 1.}}, {0., 
      0., -3.380002442493684*^-22}}], {{{0.9999999999999913, 
     1.3140996658523544`*^-7, 0.}, {-1.3140996658523544`*^-7, 
     0.9999999999999913, 0.}, {0., 0., 1.}}, {
     4.908005617942681*^-7, -6.972200594645983*^-14, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2662952775871276, -6.0023501968234205`, 
         0.08652475842498077}, {0.3518903640536914, -6.20235019682342, 
         0.11433628791872603`}, {0.2993357409432152, -6.20235019682342, 
         0.21748054334821054`}, {0.2265242114494699, -6.0023501968234205`, 
         0.16457987064188798`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265242114494699, -6.0023501968234205`, 
         0.16457987064188798`}, {0.2993357409432152, -6.20235019682342, 
         0.21748054334821054`}, {0.21747999637269966`, -6.20235019682342, 
         0.299336287918726}, {0.1645793236663771, -6.0023501968234205`, 
         0.2265247584249808}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.1645793236663771, -6.0023501968234205`, 
         0.2265247584249808}, {0.21747999637269966`, -6.20235019682342, 
         0.299336287918726}, {0.11433574094321516`, -6.20235019682342, 
         0.3518909110292022}, {0.0865242114494699, -6.0023501968234205`, 
         0.26629582456263845`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.0865242114494699, -6.0023501968234205`, 
         0.26629582456263845`}, {0.11433574094321516`, -6.20235019682342, 
         0.3518909110292022}, {-5.46975515401619*^-7, -6.20235019682342, 
         0.36999999999999544`}, {-5.46975515401619*^-7, -6.0023501968234205`, 
         0.2799999999999955}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-5.46975515401619*^-7, -6.0023501968234205`, 
         0.2799999999999955}, {-5.46975515401619*^-7, -6.20235019682342, 
         0.36999999999999544`}, {-0.11433683489424595`, -6.20235019682342, 
         0.3518909110292022}, {-0.08652530540050068, -6.0023501968234205`, 
         0.26629582456263845`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652530540050068, -6.0023501968234205`, 
         0.26629582456263845`}, {-0.11433683489424595`, -6.20235019682342, 
         0.3518909110292022}, {-0.21748109032373047`, -6.20235019682342, 
         0.299336287918726}, {-0.1645804176174079, -6.0023501968234205`, 
         0.2265247584249808}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1645804176174079, -6.0023501968234205`, 
         0.2265247584249808}, {-0.21748109032373047`, -6.20235019682342, 
         0.299336287918726}, {-0.29933683489424595`, -6.20235019682342, 
         0.21748054334821054`}, {-0.22652530540050073`, -6.0023501968234205`, 
         0.16457987064188798`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652530540050073`, -6.0023501968234205`, 
         0.16457987064188798`}, {-0.29933683489424595`, -6.20235019682342, 
         0.21748054334821054`}, {-0.35189145800472216`, -6.20235019682342, 
         0.11433628791872603`}, {-0.2662963715381584, -6.0023501968234205`, 
         0.08652475842498077}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2662963715381584, -6.0023501968234205`, 
         0.08652475842498077}, {-0.35189145800472216`, -6.20235019682342, 
         0.11433628791872603`}, {-0.3700005469755154, -6.20235019682342, \
-4.527302997198385*^-15}, {-0.2800005469755154, -6.0023501968234205`, \
-4.527302997198385*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2800005469755154, -6.0023501968234205`, \
-4.527302997198385*^-15}, {-0.3700005469755154, -6.20235019682342, \
-4.527302997198385*^-15}, {-0.35189145800472216`, -6.20235019682342, \
-0.11433628791873508`}, {-0.2662963715381584, -6.0023501968234205`, \
-0.08652475842498981}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.2662963715381584, -6.0023501968234205`, \
-0.08652475842498981}, {-0.35189145800472216`, -6.20235019682342, \
-0.11433628791873508`}, {-0.29933683489424595`, -6.20235019682342, \
-0.2174805433482196}, {-0.22652530540050073`, -6.0023501968234205`, \
-0.16457987064189702`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652530540050073`, -6.0023501968234205`, \
-0.16457987064189702`}, {-0.29933683489424595`, -6.20235019682342, \
-0.2174805433482196}, {-0.21748109032373047`, -6.20235019682342, \
-0.2993362879187351}, {-0.1645804176174079, -6.0023501968234205`, \
-0.22652475842498984`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1645804176174079, -6.0023501968234205`, \
-0.22652475842498984`}, {-0.21748109032373047`, -6.20235019682342, \
-0.2993362879187351}, {-0.11433683489424595`, -6.20235019682342, \
-0.35189091102921133`}, {-0.08652530540050068, -6.0023501968234205`, \
-0.26629582456264755`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652530540050068, -6.0023501968234205`, \
-0.26629582456264755`}, {-0.11433683489424595`, -6.20235019682342, \
-0.35189091102921133`}, {-5.46975515401619*^-7, -6.20235019682342, \
-0.37000000000000455`}, {-5.46975515401619*^-7, -6.0023501968234205`, \
-0.2800000000000046}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-5.46975515401619*^-7, -6.0023501968234205`, \
-0.2800000000000046}, {-5.46975515401619*^-7, -6.20235019682342, \
-0.37000000000000455`}, {
         0.11433574094321516`, -6.20235019682342, -0.35189091102921133`}, {
         0.0865242114494699, -6.0023501968234205`, -0.26629582456264755`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.0865242114494699, -6.0023501968234205`, -0.26629582456264755`}, {
         0.11433574094321516`, -6.20235019682342, -0.35189091102921133`}, {
         0.21747999637269966`, -6.20235019682342, -0.2993362879187351}, {
         0.1645793236663771, -6.0023501968234205`, -0.22652475842498984`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.1645793236663771, -6.0023501968234205`, -0.22652475842498984`}, {
         0.21747999637269966`, -6.20235019682342, -0.2993362879187351}, {
         0.2993357409432152, -6.20235019682342, -0.2174805433482196}, {
         0.2265242114494699, -6.0023501968234205`, -0.16457987064189702`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265242114494699, -6.0023501968234205`, -0.16457987064189702`}, {
         0.2993357409432152, -6.20235019682342, -0.2174805433482196}, {
         0.3518903640536914, -6.20235019682342, -0.11433628791873508`}, {
         0.2662952775871276, -6.0023501968234205`, -0.08652475842498981}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2662952775871276, -6.0023501968234205`, -0.08652475842498981}, {
         0.3518903640536914, -6.20235019682342, -0.11433628791873508`}, {
         0.3699994530244846, -6.20235019682342, -4.527302997198385*^-15}, {
         0.27999945302448465`, -6.0023501968234205`, \
-4.527302997198385*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.27999945302448465`, -6.0023501968234205`, \
-4.527302997198385*^-15}, {
         0.3699994530244846, -6.20235019682342, -4.527302997198385*^-15}, {
         0.3518903640536914, -6.20235019682342, 0.11433628791872603`}, {
         0.2662952775871276, -6.0023501968234205`, 
         0.08652475842498077}}]}}, {{{1., 0., 0.}, {0., 1., 
       2.5428390279485292`*^-15}, {0., -2.5428390279485292`*^-15, 1.}}, {0., 
       0., -1.5517294242691982`*^-14}}], {{{1., 0., 
      1.1824473186542362`*^-14}, {0., 1., 0.}, {-1.1824473186542362`*^-14, 0.,
       1.}}, {0., 0., -6.467697315430515*^-21}}], {{{0.9999999999999926, 
     1.2169652112003533`*^-7, 0.}, {-1.2169652112003533`*^-7, 
     0.9999999999999926, 0.}, {0., 0., 1.}}, {
     7.426347896095691*^-7, -1.1191048088221578`*^-13, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26629541075476215`, -8.103769674028916, 
         0.08652475842498078}, {0.3518904972213259, -8.303769674028915, 
         0.11433628791872605`}, {0.2993358741108497, -8.303769674028915, 
         0.21748054334821054`}, {0.2265243446171045, -8.103769674028916, 
         0.16457987064188798`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2265243446171045, -8.103769674028916, 
         0.16457987064188798`}, {0.2993358741108497, -8.303769674028915, 
         0.21748054334821054`}, {0.21748012954033424`, -8.303769674028915, 
         0.2993362879187261}, {0.16457945683401168`, -8.103769674028916, 
         0.2265247584249808}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.16457945683401168`, -8.103769674028916, 
         0.2265247584249808}, {0.21748012954033424`, -8.303769674028915, 
         0.2993362879187261}, {0.11433587411084972`, -8.303769674028915, 
         0.3518909110292023}, {0.08652434461710445, -8.103769674028916, 
         0.2662958245626385}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.08652434461710445, -8.103769674028916, 
         0.2662958245626385}, {0.11433587411084972`, -8.303769674028915, 
         0.3518909110292023}, {-4.1380788083299217`*^-7, -8.303769674028915, 
         0.3699999999999955}, {-4.1380788083299217`*^-7, -8.103769674028916, 
         0.27999999999999553`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-4.1380788083299217`*^-7, -8.103769674028916, 
         0.27999999999999553`}, {-4.1380788083299217`*^-7, -8.303769674028915,
          0.3699999999999955}, {-0.1143367017266114, -8.303769674028915, 
         0.3518909110292023}, {-0.08652517223286613, -8.103769674028916, 
         0.2662958245626385}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.08652517223286613, -8.103769674028916, 
         0.2662958245626385}, {-0.1143367017266114, -8.303769674028915, 
         0.3518909110292023}, {-0.2174809571560959, -8.303769674028915, 
         0.2993362879187261}, {-0.16458028444977332`, -8.103769674028916, 
         0.2265247584249808}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16458028444977332`, -8.103769674028916, 
         0.2265247584249808}, {-0.2174809571560959, -8.303769674028915, 
         0.2993362879187261}, {-0.2993367017266114, -8.303769674028915, 
         0.21748054334821054`}, {-0.22652517223286614`, -8.103769674028916, 
         0.16457987064188798`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652517223286614`, -8.103769674028916, 
         0.16457987064188798`}, {-0.2993367017266114, -8.303769674028915, 
         0.21748054334821054`}, {-0.3518913248370876, -8.303769674028915, 
         0.11433628791872605`}, {-0.26629623837052385`, -8.103769674028916, 
         0.08652475842498078}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.26629623837052385`, -8.103769674028916, 
         0.08652475842498078}, {-0.3518913248370876, -8.303769674028915, 
         0.11433628791872605`}, {-0.37000041380788085`, -8.303769674028915, \
-4.511536350676839*^-15}, {-0.2800004138078809, -8.103769674028916, \
-4.511536350676839*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2800004138078809, -8.103769674028916, \
-4.511536350676839*^-15}, {-0.37000041380788085`, -8.303769674028915, \
-4.511536350676839*^-15}, {-0.3518913248370876, -8.303769674028915, \
-0.11433628791873507`}, {-0.26629623837052385`, -8.103769674028916, \
-0.0865247584249898}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.26629623837052385`, -8.103769674028916, \
-0.0865247584249898}, {-0.3518913248370876, -8.303769674028915, \
-0.11433628791873507`}, {-0.2993367017266114, -8.303769674028915, \
-0.2174805433482196}, {-0.22652517223286614`, -8.103769674028916, \
-0.16457987064189702`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22652517223286614`, -8.103769674028916, \
-0.16457987064189702`}, {-0.2993367017266114, -8.303769674028915, \
-0.2174805433482196}, {-0.2174809571560959, -8.303769674028915, \
-0.29933628791873507`}, {-0.16458028444977332`, -8.103769674028916, \
-0.22652475842498984`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.16458028444977332`, -8.103769674028916, \
-0.22652475842498984`}, {-0.2174809571560959, -8.303769674028915, \
-0.29933628791873507`}, {-0.1143367017266114, -8.303769674028915, \
-0.3518909110292113}, {-0.08652517223286613, -8.103769674028916, \
-0.2662958245626475}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.08652517223286613, -8.103769674028916, \
-0.2662958245626475}, {-0.1143367017266114, -8.303769674028915, \
-0.3518909110292113}, {-4.1380788083299217`*^-7, -8.303769674028915, \
-0.3700000000000045}, {-4.1380788083299217`*^-7, -8.103769674028916, \
-0.2800000000000045}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-4.1380788083299217`*^-7, -8.103769674028916, \
-0.2800000000000045}, {-4.1380788083299217`*^-7, -8.303769674028915, \
-0.3700000000000045}, {
         0.11433587411084972`, -8.303769674028915, -0.3518909110292113}, {
         0.08652434461710445, -8.103769674028916, -0.2662958245626475}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.08652434461710445, -8.103769674028916, -0.2662958245626475}, {
         0.11433587411084972`, -8.303769674028915, -0.3518909110292113}, {
         0.21748012954033424`, -8.303769674028915, -0.29933628791873507`}, {
         0.16457945683401168`, -8.103769674028916, -0.22652475842498984`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.16457945683401168`, -8.103769674028916, -0.22652475842498984`}, {
         0.21748012954033424`, -8.303769674028915, -0.29933628791873507`}, {
         0.2993358741108497, -8.303769674028915, -0.2174805433482196}, {
         0.2265243446171045, -8.103769674028916, -0.16457987064189702`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.2265243446171045, -8.103769674028916, -0.16457987064189702`}, {
         0.2993358741108497, -8.303769674028915, -0.2174805433482196}, {
         0.3518904972213259, -8.303769674028915, -0.11433628791873507`}, {
         0.26629541075476215`, -8.103769674028916, -0.0865247584249898}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.26629541075476215`, -8.103769674028916, -0.0865247584249898}, {
         0.3518904972213259, -8.303769674028915, -0.11433628791873507`}, {
         0.36999958619211915`, -8.303769674028915, -4.511536350676839*^-15}, {
         0.2799995861921192, -8.103769674028916, -4.511536350676839*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.2799995861921192, -8.103769674028916, -4.511536350676839*^-15}, {
         0.36999958619211915`, -8.303769674028915, -4.511536350676839*^-15}, {
         0.3518904972213259, -8.303769674028915, 0.11433628791872605`}, {
         0.26629541075476215`, -8.103769674028916, 
         0.08652475842498078}}]}}, {{{1., 0., 0.}, {0., 1., 
       3.671627185465985*^-16}, {0., -3.671627185465985*^-16, 1.}}, {0., 
       0., -3.012118375846599*^-15}}], {{{1., 0., 4.028137554011449*^-15}, {
      0., 1., 0.}, {-4.028137554011449*^-15, 0., 1.}}, {0., 
      0., -1.6668750652739565`*^-21}}], {{{
     0.999999999918338, -0.000012779829518465106`, 0.}, {
     0.000012779829518465106`, 0.999999999918338, 0.}, {0., 0., 
     1.}}, {-0.00010484277784287739`, -6.646487804573553*^-10, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.19984718982189775`, -10.224941717595287`, \
-0.15000000000000469`}, {-0.19984718982189775`, -10.224941717595287`, 
        0.1499999999999953}, {-0.19984718982189775`, -10.349941717595287`, 
        0.1499999999999953}, {-0.19984718982189775`, -10.349941717595287`, \
-0.15000000000000469`}}], 
       Polygon3DBox[{{
        0.20015281017810227`, -10.224941717595287`, -0.15000000000000469`}, {
        0.20015281017810227`, -10.224941717595287`, 0.1499999999999953}, {
        0.20015281017810227`, -10.349941717595287`, 0.1499999999999953}, {
        0.20015281017810227`, -10.349941717595287`, -0.15000000000000469`}}], 
       Polygon3DBox[{{-0.19984718982189775`, -10.349941717595287`, \
-0.15000000000000469`}, {-0.19984718982189775`, -10.224941717595287`, \
-0.15000000000000469`}, {
        0.20015281017810227`, -10.224941717595287`, -0.15000000000000469`}, {
        0.20015281017810227`, -10.349941717595287`, -0.15000000000000469`}}], 
       Polygon3DBox[{{-0.19984718982189775`, -10.349941717595287`, 
        0.1499999999999953}, {-0.19984718982189775`, -10.224941717595287`, 
        0.1499999999999953}, {0.20015281017810227`, -10.224941717595287`, 
        0.1499999999999953}, {0.20015281017810227`, -10.349941717595287`, 
        0.1499999999999953}}], 
       Polygon3DBox[{{-0.19984718982189775`, -10.349941717595287`, \
-0.15000000000000469`}, {-0.19984718982189775`, -10.349941717595287`, 
        0.1499999999999953}, {0.20015281017810227`, -10.349941717595287`, 
        0.1499999999999953}, {
        0.20015281017810227`, -10.349941717595287`, -0.15000000000000469`}}], 
       Polygon3DBox[{{-0.19984718982189775`, -10.224941717595287`, \
-0.15000000000000469`}, {-0.19984718982189775`, -10.224941717595287`, 
        0.1499999999999953}, {0.20015281017810227`, -10.224941717595287`, 
        0.1499999999999953}, {
        0.20015281017810227`, -10.224941717595287`, \
-0.15000000000000469`}}]}, {{{1., 0., 0.}, {0., 
       1., -4.2757585855222067`*^-14}, {0., 4.2757585855222067`*^-14, 1.}}, {
       0., 0., 4.398661724706737*^-13}}], {{{1., 0., 8.82106768164855*^-14}, {
      0., 1., 0.}, {-8.82106768164855*^-14, 0., 1.}}, {0., 0., 
      1.3479489234847192`*^-17}}], {{{0.999975110974256, 0.007055312326502916,
      0.}, {-0.007055312326502916, 0.999975110974256, 0.}, {0., 0., 1.}}, {
     0.07258111816162684, -0.0002549662782165285, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.30050547790418447`, -10.184193442402501`, \
-0.2499999999999992}, {-0.30050547790418447`, -10.184193442402501`, 
        0.2500000000000008}, {-0.30050547790418447`, -10.409193442402502`, 
        0.2500000000000008}, {-0.30050547790418447`, -10.409193442402502`, \
-0.2499999999999992}}], 
       Polygon3DBox[{{
        0.2994945220958155, -10.184193442402501`, -0.2499999999999992}, {
        0.2994945220958155, -10.184193442402501`, 0.2500000000000008}, {
        0.2994945220958155, -10.409193442402502`, 0.2500000000000008}, {
        0.2994945220958155, -10.409193442402502`, -0.2499999999999992}}], 
       Polygon3DBox[{{-0.30050547790418447`, -10.409193442402502`, \
-0.2499999999999992}, {-0.30050547790418447`, -10.184193442402501`, \
-0.2499999999999992}, {
        0.2994945220958155, -10.184193442402501`, -0.2499999999999992}, {
        0.2994945220958155, -10.409193442402502`, -0.2499999999999992}}], 
       Polygon3DBox[{{-0.30050547790418447`, -10.409193442402502`, 
        0.2500000000000008}, {-0.30050547790418447`, -10.184193442402501`, 
        0.2500000000000008}, {0.2994945220958155, -10.184193442402501`, 
        0.2500000000000008}, {0.2994945220958155, -10.409193442402502`, 
        0.2500000000000008}}]}, {{{1., 0., 0.}, {0., 1., 
       3.549013863111597*^-16}, {0., -3.549013863111597*^-16, 1.}}, {0., 
       0., -3.654310777129675*^-15}}], {{{1., 0., -4.662335123367939*^-15}, {
      0., 1., 0.}, {4.662335123367939*^-15, 0., 1.}}, {0., 0., 
      2.356707386765825*^-18}}], {{{
     0.9999999999187992, -0.000012743689399755866`, 0.}, {
     0.000012743689399755866`, 0.9999999999187992, 0.}, {0., 0., 
     1.}}, {-0.00013121786311552565`, 5.605553354826043*^-9, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.17875397900522838`, -12.34133976109077, 
         0.050000000015131905`}, {-0.17875397900522838`, -12.34133976109077, \
-0.0499999999848681}, {-0.19650891924525415`, -12.306493728851079`, \
-0.0499999999848681}, {-0.19650891924525415`, -12.306493728851079`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.19650891924525415`, -12.306493728851079`, 
         0.050000000015131905`}, {-0.19650891924525415`, \
-12.306493728851079`, -0.0499999999848681}, {-0.22416288700556344`, \
-12.27883976109077, -0.0499999999848681}, {-0.22416288700556344`, \
-12.27883976109077, 0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22416288700556344`, -12.27883976109077, 
         0.050000000015131905`}, {-0.22416288700556344`, -12.27883976109077, \
-0.0499999999848681}, {-0.25900891924525415`, -12.261084820850744`, \
-0.0499999999848681}, {-0.25900891924525415`, -12.261084820850744`, 
         0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.25900891924525415`, -12.261084820850744`, 
         0.050000000015131905`}, {-0.25900891924525415`, \
-12.261084820850744`, -0.0499999999848681}, {-0.2976360435421226, \
-12.254966885387638`, -0.0499999999848681}, {-0.2976360435421226, \
-12.254966885387638`, 0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2976360435421226, -12.254966885387638`, 
         0.050000000015131905`}, {-0.2976360435421226, -12.254966885387638`, \
-0.0499999999848681}, {-0.336263167838991, -12.261084820850744`, \
-0.0499999999848681}, {-0.336263167838991, -12.261084820850744`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.336263167838991, -12.261084820850744`, 
         0.050000000015131905`}, {-0.336263167838991, -12.261084820850744`, \
-0.0499999999848681}, {-0.37110920007868176`, -12.27883976109077, \
-0.0499999999848681}, {-0.37110920007868176`, -12.27883976109077, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.37110920007868176`, -12.27883976109077, 
         0.050000000015131905`}, {-0.37110920007868176`, -12.27883976109077, \
-0.0499999999848681}, {-0.398763167838991, -12.306493728851079`, \
-0.0499999999848681}, {-0.398763167838991, -12.306493728851079`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.398763167838991, -12.306493728851079`, 
         0.050000000015131905`}, {-0.398763167838991, -12.306493728851079`, \
-0.0499999999848681}, {-0.4165181080790168, -12.34133976109077, \
-0.0499999999848681}, {-0.4165181080790168, -12.34133976109077, 
         0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.4165181080790168, -12.34133976109077, 
         0.050000000015131905`}, {-0.4165181080790168, -12.34133976109077, \
-0.0499999999848681}, {-0.4226360435421226, -12.379966885387638`, \
-0.0499999999848681}, {-0.4226360435421226, -12.379966885387638`, 
         0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.4226360435421226, -12.379966885387638`, 
         0.050000000015131905`}, {-0.4226360435421226, -12.379966885387638`, \
-0.0499999999848681}, {-0.4165181080790168, -12.418594009684506`, \
-0.0499999999848681}, {-0.4165181080790168, -12.418594009684506`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.4165181080790168, -12.418594009684506`, 
         0.050000000015131905`}, {-0.4165181080790168, -12.418594009684506`, \
-0.0499999999848681}, {-0.398763167838991, -12.453440041924198`, \
-0.0499999999848681}, {-0.398763167838991, -12.453440041924198`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.398763167838991, -12.453440041924198`, 
         0.050000000015131905`}, {-0.398763167838991, -12.453440041924198`, \
-0.0499999999848681}, {-0.37110920007868176`, -12.481094009684506`, \
-0.0499999999848681}, {-0.37110920007868176`, -12.481094009684506`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.37110920007868176`, -12.481094009684506`, 
         0.050000000015131905`}, {-0.37110920007868176`, \
-12.481094009684506`, -0.0499999999848681}, {-0.336263167838991, \
-12.498848949924533`, -0.0499999999848681}, {-0.336263167838991, \
-12.498848949924533`, 0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.336263167838991, -12.498848949924533`, 
         0.050000000015131905`}, {-0.336263167838991, -12.498848949924533`, \
-0.0499999999848681}, {-0.2976360435421226, -12.504966885387638`, \
-0.0499999999848681}, {-0.2976360435421226, -12.504966885387638`, 
         0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.2976360435421226, -12.504966885387638`, 
         0.050000000015131905`}, {-0.2976360435421226, -12.504966885387638`, \
-0.0499999999848681}, {-0.25900891924525415`, -12.498848949924533`, \
-0.0499999999848681}, {-0.25900891924525415`, -12.498848949924533`, 
         0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.25900891924525415`, -12.498848949924533`, 
         0.050000000015131905`}, {-0.25900891924525415`, \
-12.498848949924533`, -0.0499999999848681}, {-0.22416288700556344`, \
-12.481094009684506`, -0.0499999999848681}, {-0.22416288700556344`, \
-12.481094009684506`, 0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.22416288700556344`, -12.481094009684506`, 
         0.050000000015131905`}, {-0.22416288700556344`, \
-12.481094009684506`, -0.0499999999848681}, {-0.19650891924525415`, \
-12.453440041924198`, -0.0499999999848681}, {-0.19650891924525415`, \
-12.453440041924198`, 0.050000000015131905`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.19650891924525415`, -12.453440041924198`, 
         0.050000000015131905`}, {-0.19650891924525415`, \
-12.453440041924198`, -0.0499999999848681}, {-0.17875397900522838`, \
-12.418594009684506`, -0.0499999999848681}, {-0.17875397900522838`, \
-12.418594009684506`, 0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.17875397900522838`, -12.418594009684506`, 
         0.050000000015131905`}, {-0.17875397900522838`, \
-12.418594009684506`, -0.0499999999848681}, {-0.17263604354212259`, \
-12.379966885387638`, -0.0499999999848681}, {-0.17263604354212259`, \
-12.379966885387638`, 0.050000000015131905`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.17263604354212259`, -12.379966885387638`, 
         0.050000000015131905`}, {-0.17263604354212259`, \
-12.379966885387638`, -0.0499999999848681}, {-0.17875397900522838`, \
-12.34133976109077, -0.0499999999848681}, {-0.17875397900522838`, \
-12.34133976109077, 0.050000000015131905`}}]}}, {{{1., 0., 0.}, {0., 1., 
       2.858458160812474*^-13}, {0., -2.858458160812474*^-13, 1.}}, {0., 
       0., -3.5387617374124493`*^-12}}], {{{1., 0., 
      1.4231322028101111`*^-13}, {0., 1., 0.}, {-1.4231322028101111`*^-13, 0.,
       1.}}, {0., 0., -4.2357543828178897`*^-14}}], {{{0.9999742658707969, 
     0.007174092009504219, 0.}, {-0.007174092009504219, 0.9999742658707969, 
     0.}, {0., 0., 1.}}, {0.08880736210598628, -0.0024538560290743305`, 0.}}],
    GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.3103717022669279, -12.289113265477903`, 
         0.09999999999819396}, {
         0.3103717022669279, -12.289113265477903`, -0.10000000000180605`}, {
         0.26932228043198836`, -12.208549238939739`, -0.10000000000180605`}, {
         0.26932228043198836`, -12.208549238939739`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26932228043198836`, -12.208549238939739`, 
         0.09999999999819396}, {
         0.26932228043198836`, -12.208549238939739`, -0.10000000000180605`}, {
         0.2053863069701533, -12.144613265477904`, -0.10000000000180605`}, {
         0.2053863069701533, -12.144613265477904`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2053863069701533, -12.144613265477904`, 
         0.09999999999819396}, {
         0.2053863069701533, -12.144613265477904`, -0.10000000000180605`}, {
         0.1248222804319884, -12.103563843642965`, -0.10000000000180605`}, {
         0.1248222804319884, -12.103563843642965`, 0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.1248222804319884, -12.103563843642965`, 
         0.09999999999819396}, {
         0.1248222804319884, -12.103563843642965`, -0.10000000000180605`}, {
         0.03551636905762859, -12.089419176852264`, -0.10000000000180605`}, {
         0.03551636905762859, -12.089419176852264`, 0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.03551636905762859, -12.089419176852264`, 
         0.09999999999819396}, {
         0.03551636905762859, -12.089419176852264`, -0.10000000000180605`}, \
{-0.05378954231673122, -12.103563843642965`, -0.10000000000180605`}, \
{-0.05378954231673122, -12.103563843642965`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.05378954231673122, -12.103563843642965`, 
         0.09999999999819396}, {-0.05378954231673122, -12.103563843642965`, \
-0.10000000000180605`}, {-0.13435356885489613`, -12.144613265477904`, \
-0.10000000000180605`}, {-0.13435356885489613`, -12.144613265477904`, 
         0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.13435356885489613`, -12.144613265477904`, 
         0.09999999999819396}, {-0.13435356885489613`, -12.144613265477904`, \
-0.10000000000180605`}, {-0.1982895423167312, -12.208549238939739`, \
-0.10000000000180605`}, {-0.1982895423167312, -12.208549238939739`, 
         0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1982895423167312, -12.208549238939739`, 
         0.09999999999819396}, {-0.1982895423167312, -12.208549238939739`, \
-0.10000000000180605`}, {-0.23933896415167075`, -12.289113265477903`, \
-0.10000000000180605`}, {-0.23933896415167075`, -12.289113265477903`, 
         0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.23933896415167075`, -12.289113265477903`, 
         0.09999999999819396}, {-0.23933896415167075`, -12.289113265477903`, \
-0.10000000000180605`}, {-0.25348363094237136`, -12.378419176852264`, \
-0.10000000000180605`}, {-0.25348363094237136`, -12.378419176852264`, 
         0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.25348363094237136`, -12.378419176852264`, 
         0.09999999999819396}, {-0.25348363094237136`, -12.378419176852264`, \
-0.10000000000180605`}, {-0.23933896415167075`, -12.467725088226624`, \
-0.10000000000180605`}, {-0.23933896415167075`, -12.467725088226624`, 
         0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.23933896415167075`, -12.467725088226624`, 
         0.09999999999819396}, {-0.23933896415167075`, -12.467725088226624`, \
-0.10000000000180605`}, {-0.1982895423167312, -12.548289114764788`, \
-0.10000000000180605`}, {-0.1982895423167312, -12.548289114764788`, 
         0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.1982895423167312, -12.548289114764788`, 
         0.09999999999819396}, {-0.1982895423167312, -12.548289114764788`, \
-0.10000000000180605`}, {-0.13435356885489613`, -12.612225088226623`, \
-0.10000000000180605`}, {-0.13435356885489613`, -12.612225088226623`, 
         0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.13435356885489613`, -12.612225088226623`, 
         0.09999999999819396}, {-0.13435356885489613`, -12.612225088226623`, \
-0.10000000000180605`}, {-0.05378954231673122, -12.653274510061562`, \
-0.10000000000180605`}, {-0.05378954231673122, -12.653274510061562`, 
         0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.05378954231673122, -12.653274510061562`, 
         0.09999999999819396}, {-0.05378954231673122, -12.653274510061562`, \
-0.10000000000180605`}, {
         0.03551636905762859, -12.667419176852263`, -0.10000000000180605`}, {
         0.03551636905762859, -12.667419176852263`, 0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.03551636905762859, -12.667419176852263`, 
         0.09999999999819396}, {
         0.03551636905762859, -12.667419176852263`, -0.10000000000180605`}, {
         0.1248222804319884, -12.653274510061562`, -0.10000000000180605`}, {
         0.1248222804319884, -12.653274510061562`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.1248222804319884, -12.653274510061562`, 
         0.09999999999819396}, {
         0.1248222804319884, -12.653274510061562`, -0.10000000000180605`}, {
         0.2053863069701533, -12.612225088226623`, -0.10000000000180605`}, {
         0.2053863069701533, -12.612225088226623`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.2053863069701533, -12.612225088226623`, 
         0.09999999999819396}, {
         0.2053863069701533, -12.612225088226623`, -0.10000000000180605`}, {
         0.26932228043198836`, -12.548289114764788`, -0.10000000000180605`}, {
         0.26932228043198836`, -12.548289114764788`, 0.09999999999819396}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.26932228043198836`, -12.548289114764788`, 
         0.09999999999819396}, {
         0.26932228043198836`, -12.548289114764788`, -0.10000000000180605`}, {
         0.3103717022669279, -12.467725088226624`, -0.10000000000180605`}, {
         0.3103717022669279, -12.467725088226624`, 0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.3103717022669279, -12.467725088226624`, 
         0.09999999999819396}, {
         0.3103717022669279, -12.467725088226624`, -0.10000000000180605`}, {
         0.3245163690576286, -12.378419176852264`, -0.10000000000180605`}, {
         0.3245163690576286, -12.378419176852264`, 0.09999999999819396}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.3245163690576286, -12.378419176852264`, 
         0.09999999999819396}, {
         0.3245163690576286, -12.378419176852264`, -0.10000000000180605`}, {
         0.3103717022669279, -12.289113265477903`, -0.10000000000180605`}, {
         0.3103717022669279, -12.289113265477903`, 
         0.09999999999819396}}]}}, {{{1., 0., 0.}, {0., 
       1., -6.307858389385264*^-14}, {0., 6.307858389385264*^-14, 1.}}, {0., 
       0., 7.808131525203498*^-13}}], {{{1., 0., 1.3044639262860383`*^-13}, {
      0., 1., 0.}, {-1.3044639262860383`*^-13, 0., 1.}}, {0., 0., 
      4.632982222833725*^-15}}], {{{0.9999750765800108, 0.007060185465085072, 
     0.}, {-0.007060185465085072, 0.9999750765800108, 0.}, {0., 0., 1.}}, {
     0.08739482034252519, -0.00005776038735305633, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.33287079593029123`, -1.4432193145940104`, 
        0.10815594803124234`}, {0.2831569632582191, -1.4432193145940104`, 
        0.20572483830237634`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{0.2831569632582191, -1.4432193145940104`, 
        0.20572483830237634`}, {0.2057258535293531, -1.4432193145940104`, 
        0.28315594803124233`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{0.2057258535293531, -1.4432193145940104`, 
        0.28315594803124233`}, {0.1081569632582191, -1.4432193145940104`, 
        0.33286978070331447`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{0.1081569632582191, -1.4432193145940104`, 
        0.33286978070331447`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         0.35000000000001075`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{1.0152269874825005`*^-6, -1.4432193145940104`, 
        0.35000000000001075`}, {-0.10815493280424414`, -1.4432193145940104`, 
        0.33286978070331447`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.10815493280424414`, -1.4432193145940104`, 
        0.33286978070331447`}, {-0.20572382307537815`, -1.4432193145940104`, 
        0.28315594803124233`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.20572382307537815`, -1.4432193145940104`, 
        0.28315594803124233`}, {-0.28315493280424414`, -1.4432193145940104`, 
        0.20572483830237634`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.28315493280424414`, -1.4432193145940104`, 
        0.20572483830237634`}, {-0.3328687654763163, -1.4432193145940104`, 
        0.10815594803124234`}, {1.0152269874825005`*^-6, -1.4432193145940104`,
         1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.3328687654763163, -1.4432193145940104`, 
        0.10815594803124234`}, {-0.34999898477301256`, -1.4432193145940104`, 
        1.0726755192185082`*^-14}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.34999898477301256`, -1.4432193145940104`, 
        1.0726755192185082`*^-14}, {-0.3328687654763163, \
-1.4432193145940104`, -0.10815594803122089`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.3328687654763163, -1.4432193145940104`, \
-0.10815594803122089`}, {-0.28315493280424414`, -1.4432193145940104`, \
-0.2057248383023549}, {1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.28315493280424414`, -1.4432193145940104`, \
-0.2057248383023549}, {-0.20572382307537815`, -1.4432193145940104`, \
-0.2831559480312209}, {1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.20572382307537815`, -1.4432193145940104`, \
-0.2831559480312209}, {-0.10815493280424414`, -1.4432193145940104`, \
-0.33286978070329304`}, {1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{-0.10815493280424414`, -1.4432193145940104`, \
-0.33286978070329304`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, -0.3499999999999893}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{
        1.0152269874825005`*^-6, -1.4432193145940104`, -0.3499999999999893}, {
        0.1081569632582191, -1.4432193145940104`, -0.33286978070329304`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{
        0.1081569632582191, -1.4432193145940104`, -0.33286978070329304`}, {
        0.2057258535293531, -1.4432193145940104`, -0.2831559480312209}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{
        0.2057258535293531, -1.4432193145940104`, -0.2831559480312209}, {
        0.2831569632582191, -1.4432193145940104`, -0.2057248383023549}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{
        0.2831569632582191, -1.4432193145940104`, -0.2057248383023549}, {
        0.33287079593029123`, -1.4432193145940104`, -0.10815594803122089`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{
        0.33287079593029123`, -1.4432193145940104`, -0.10815594803122089`}, {
        0.3500010152269875, -1.4432193145940104`, 1.0726755192185082`*^-14}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}], 
       Polygon3DBox[{{0.3500010152269875, -1.4432193145940104`, 
        1.0726755192185082`*^-14}, {
        0.33287079593029123`, -1.4432193145940104`, 0.10815594803124234`}, {
        1.0152269874825005`*^-6, -1.4432193145940104`, 
        1.0726755192185082`*^-14}}]}, {{{1., 0., 0.}, {0., 
       1., -1.8704781153412052`*^-17}, {0., 1.8704781153412052`*^-17, 1.}}, {
       0., 0., 2.6995101435858528`*^-17}}], {{{1., 0., 
      1.2198170023903519`*^-16}, {0., 1., 0.}, {-1.2198170023903519`*^-16, 0.,
       1.}}, {0., 0., 1.2383911463595432`*^-22}}], {{{1., 
     1.818042720568299*^-10, 0.}, {-1.818042720568299*^-10, 1., 0.}, {0., 0., 
     1.}}, {2.623834369081098*^-10, 2.220446049250313*^-16, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{-0.6024471329341432, 0.5, 
        0.015450849718747784`}, {-0.6024471329341432, 0., 
        0.015450849718747784`}, {-0.6095491090301536, 0., 
        0.029389262614624066`}, {-0.6095491090301536, 0.5, 
        0.029389262614624066`}}], 
       Polygon3DBox[{{-0.6095491090301536, 0.5, 
        0.029389262614624066`}, {-0.6095491090301536, 0., 
        0.029389262614624066`}, {-0.6206106961342772, 0., 
        0.04045084971874779}, {-0.6206106961342772, 0.5, 
        0.04045084971874779}}], 
       Polygon3DBox[{{-0.6206106961342772, 0.5, 
        0.04045084971874779}, {-0.6206106961342772, 0., 
        0.04045084971874779}, {-0.6345491090301536, 0., 
        0.04755282581475809}, {-0.6345491090301536, 0.5, 
        0.04755282581475809}}], 
       Polygon3DBox[{{-0.6345491090301536, 0.5, 
        0.04755282581475809}, {-0.6345491090301536, 0., 
        0.04755282581475809}, {-0.6499999587489009, 0., 
        0.05000000000000041}, {-0.6499999587489009, 0.5, 
        0.05000000000000041}}], 
       Polygon3DBox[{{-0.6499999587489009, 0.5, 
        0.05000000000000041}, {-0.6499999587489009, 0., 
        0.05000000000000041}, {-0.6654508084676483, 0., 
        0.04755282581475809}, {-0.6654508084676483, 0.5, 
        0.04755282581475809}}], 
       Polygon3DBox[{{-0.6654508084676483, 0.5, 
        0.04755282581475809}, {-0.6654508084676483, 0., 
        0.04755282581475809}, {-0.6793892213635246, 0., 
        0.04045084971874779}, {-0.6793892213635246, 0.5, 
        0.04045084971874779}}], 
       Polygon3DBox[{{-0.6793892213635246, 0.5, 
        0.04045084971874779}, {-0.6793892213635246, 0., 
        0.04045084971874779}, {-0.6904508084676483, 0., 
        0.029389262614624066`}, {-0.6904508084676483, 0.5, 
        0.029389262614624066`}}], 
       Polygon3DBox[{{-0.6904508084676483, 0.5, 
        0.029389262614624066`}, {-0.6904508084676483, 0., 
        0.029389262614624066`}, {-0.6975527845636587, 0., 
        0.015450849718747784`}, {-0.6975527845636587, 0.5, 
        0.015450849718747784`}}], 
       Polygon3DBox[{{-0.6975527845636587, 0.5, 
        0.015450849718747784`}, {-0.6975527845636587, 0., 
        0.015450849718747784`}, {-0.699999958748901, 0., 
        4.1107673954699383`*^-16}, {-0.699999958748901, 0.5, 
        4.1107673954699383`*^-16}}], 
       Polygon3DBox[{{-0.699999958748901, 0.5, 
        4.1107673954699383`*^-16}, {-0.699999958748901, 0., 
        4.1107673954699383`*^-16}, {-0.6975527845636587, 
        0., -0.015450849718746962`}, {-0.6975527845636587, 
        0.5, -0.015450849718746962`}}], 
       Polygon3DBox[{{-0.6975527845636587, 
        0.5, -0.015450849718746962`}, {-0.6975527845636587, 
        0., -0.015450849718746962`}, {-0.6904508084676483, 
        0., -0.029389262614623247`}, {-0.6904508084676483, 
        0.5, -0.029389262614623247`}}], 
       Polygon3DBox[{{-0.6904508084676483, 
        0.5, -0.029389262614623247`}, {-0.6904508084676483, 
        0., -0.029389262614623247`}, {-0.6793892213635246, 
        0., -0.04045084971874697}, {-0.6793892213635246, 
        0.5, -0.04045084971874697}}], 
       Polygon3DBox[{{-0.6793892213635246, 
        0.5, -0.04045084971874697}, {-0.6793892213635246, 
        0., -0.04045084971874697}, {-0.6654508084676483, 
        0., -0.04755282581475727}, {-0.6654508084676483, 
        0.5, -0.04755282581475727}}], 
       Polygon3DBox[{{-0.6654508084676483, 
        0.5, -0.04755282581475727}, {-0.6654508084676483, 
        0., -0.04755282581475727}, {-0.6499999587489009, 
        0., -0.04999999999999959}, {-0.6499999587489009, 
        0.5, -0.04999999999999959}}], 
       Polygon3DBox[{{-0.6499999587489009, 
        0.5, -0.04999999999999959}, {-0.6499999587489009, 
        0., -0.04999999999999959}, {-0.6345491090301536, 
        0., -0.04755282581475727}, {-0.6345491090301536, 
        0.5, -0.04755282581475727}}], 
       Polygon3DBox[{{-0.6345491090301536, 
        0.5, -0.04755282581475727}, {-0.6345491090301536, 
        0., -0.04755282581475727}, {-0.6206106961342772, 
        0., -0.04045084971874697}, {-0.6206106961342772, 
        0.5, -0.04045084971874697}}], 
       Polygon3DBox[{{-0.6206106961342772, 
        0.5, -0.04045084971874697}, {-0.6206106961342772, 
        0., -0.04045084971874697}, {-0.6095491090301536, 
        0., -0.029389262614623247`}, {-0.6095491090301536, 
        0.5, -0.029389262614623247`}}], 
       Polygon3DBox[{{-0.6095491090301536, 
        0.5, -0.029389262614623247`}, {-0.6095491090301536, 
        0., -0.029389262614623247`}, {-0.6024471329341432, 
        0., -0.015450849718746962`}, {-0.6024471329341432, 
        0.5, -0.015450849718746962`}}], 
       Polygon3DBox[{{-0.6024471329341432, 
        0.5, -0.015450849718746962`}, {-0.6024471329341432, 
        0., -0.015450849718746962`}, {-0.5999999587489009, 0., 
        4.1107673954699383`*^-16}, {-0.5999999587489009, 0.5, 
        4.1107673954699383`*^-16}}], 
       Polygon3DBox[{{-0.5999999587489009, 0.5, 
        4.1107673954699383`*^-16}, {-0.5999999587489009, 0., 
        4.1107673954699383`*^-16}, {-0.6024471329341432, 0., 
        0.015450849718747784`}, {-0.6024471329341432, 0.5, 
        0.015450849718747784`}}], 
       Polygon3DBox[{{-0.5881812851897159, 0., 
        0.020086104634371993`}, {-0.5881812851897159, -0.15000000000000002`, 
        0.020086104634371993`}, {-0.5974138541145293, -0.15000000000000002`, 
        0.03820604139901117}, {-0.5974138541145293, 0., 
        0.03820604139901117}}], 
       Polygon3DBox[{{-0.5974138541145293, 0., 
        0.03820604139901117}, {-0.5974138541145293, -0.15000000000000002`, 
        0.03820604139901117}, {-0.6117939173498902, -0.15000000000000002`, 
        0.052586104634371994`}, {-0.6117939173498902, 0., 
        0.052586104634371994`}}], 
       Polygon3DBox[{{-0.6117939173498902, 0., 
        0.052586104634371994`}, {-0.6117939173498902, -0.15000000000000002`, 
        0.052586104634371994`}, {-0.6299138541145294, -0.15000000000000002`, 
        0.06181867355918539}, {-0.6299138541145294, 0., 
        0.06181867355918539}}], 
       Polygon3DBox[{{-0.6299138541145294, 0., 
        0.06181867355918539}, {-0.6299138541145294, -0.15000000000000002`, 
        0.06181867355918539}, {-0.6499999587489009, -0.15000000000000002`, 
        0.06500000000000042}, {-0.6499999587489009, 0., 
        0.06500000000000042}}], 
       Polygon3DBox[{{-0.6499999587489009, 0., 
        0.06500000000000042}, {-0.6499999587489009, -0.15000000000000002`, 
        0.06500000000000042}, {-0.6700860633832725, -0.15000000000000002`, 
        0.06181867355918539}, {-0.6700860633832725, 0., 
        0.06181867355918539}}], 
       Polygon3DBox[{{-0.6700860633832725, 0., 
        0.06181867355918539}, {-0.6700860633832725, -0.15000000000000002`, 
        0.06181867355918539}, {-0.6882060001479117, -0.15000000000000002`, 
        0.052586104634371994`}, {-0.6882060001479117, 0., 
        0.052586104634371994`}}], 
       Polygon3DBox[{{-0.6882060001479117, 0., 
        0.052586104634371994`}, {-0.6882060001479117, -0.15000000000000002`, 
        0.052586104634371994`}, {-0.7025860633832726, -0.15000000000000002`, 
        0.03820604139901117}, {-0.7025860633832726, 0., 
        0.03820604139901117}}], 
       Polygon3DBox[{{-0.7025860633832726, 0., 
        0.03820604139901117}, {-0.7025860633832726, -0.15000000000000002`, 
        0.03820604139901117}, {-0.711818632308086, -0.15000000000000002`, 
        0.020086104634371993`}, {-0.711818632308086, 0., 
        0.020086104634371993`}}], 
       Polygon3DBox[{{-0.711818632308086, 0., 
        0.020086104634371993`}, {-0.711818632308086, -0.15000000000000002`, 
        0.020086104634371993`}, {-0.7149999587489009, -0.15000000000000002`, 
        4.1107673954699383`*^-16}, {-0.7149999587489009, 0., 
        4.1107673954699383`*^-16}}], 
       Polygon3DBox[{{-0.7149999587489009, 0., 
        4.1107673954699383`*^-16}, {-0.7149999587489009, \
-0.15000000000000002`, 
        4.1107673954699383`*^-16}, {-0.711818632308086, \
-0.15000000000000002`, -0.020086104634371174`}, {-0.711818632308086, 
        0., -0.020086104634371174`}}], 
       Polygon3DBox[{{-0.711818632308086, 
        0., -0.020086104634371174`}, {-0.711818632308086, \
-0.15000000000000002`, -0.020086104634371174`}, {-0.7025860633832726, \
-0.15000000000000002`, -0.03820604139901035}, {-0.7025860633832726, 
        0., -0.03820604139901035}}], 
       Polygon3DBox[{{-0.7025860633832726, 
        0., -0.03820604139901035}, {-0.7025860633832726, \
-0.15000000000000002`, -0.03820604139901035}, {-0.6882060001479117, \
-0.15000000000000002`, -0.052586104634371175`}, {-0.6882060001479117, 
        0., -0.052586104634371175`}}], 
       Polygon3DBox[{{-0.6882060001479117, 
        0., -0.052586104634371175`}, {-0.6882060001479117, \
-0.15000000000000002`, -0.052586104634371175`}, {-0.6700860633832725, \
-0.15000000000000002`, -0.06181867355918457}, {-0.6700860633832725, 
        0., -0.06181867355918457}}], 
       Polygon3DBox[{{-0.6700860633832725, 
        0., -0.06181867355918457}, {-0.6700860633832725, \
-0.15000000000000002`, -0.06181867355918457}, {-0.6499999587489009, \
-0.15000000000000002`, -0.06499999999999959}, {-0.6499999587489009, 
        0., -0.06499999999999959}}], 
       Polygon3DBox[{{-0.6499999587489009, 
        0., -0.06499999999999959}, {-0.6499999587489009, \
-0.15000000000000002`, -0.06499999999999959}, {-0.6299138541145294, \
-0.15000000000000002`, -0.06181867355918457}, {-0.6299138541145294, 
        0., -0.06181867355918457}}], 
       Polygon3DBox[{{-0.6299138541145294, 
        0., -0.06181867355918457}, {-0.6299138541145294, \
-0.15000000000000002`, -0.06181867355918457}, {-0.6117939173498902, \
-0.15000000000000002`, -0.052586104634371175`}, {-0.6117939173498902, 
        0., -0.052586104634371175`}}], 
       Polygon3DBox[{{-0.6117939173498902, 
        0., -0.052586104634371175`}, {-0.6117939173498902, \
-0.15000000000000002`, -0.052586104634371175`}, {-0.5974138541145293, \
-0.15000000000000002`, -0.03820604139901035}, {-0.5974138541145293, 
        0., -0.03820604139901035}}], 
       Polygon3DBox[{{-0.5974138541145293, 
        0., -0.03820604139901035}, {-0.5974138541145293, \
-0.15000000000000002`, -0.03820604139901035}, {-0.5881812851897159, \
-0.15000000000000002`, -0.020086104634371174`}, {-0.5881812851897159, 
        0., -0.020086104634371174`}}], 
       Polygon3DBox[{{-0.5881812851897159, 
        0., -0.020086104634371174`}, {-0.5881812851897159, \
-0.15000000000000002`, -0.020086104634371174`}, {-0.584999958748901, \
-0.15000000000000002`, 4.1107673954699383`*^-16}, {-0.584999958748901, 0., 
        4.1107673954699383`*^-16}}], 
       Polygon3DBox[{{-0.584999958748901, 0., 
        4.1107673954699383`*^-16}, {-0.584999958748901, -0.15000000000000002`,
         4.1107673954699383`*^-16}, {-0.5881812851897159, \
-0.15000000000000002`, 0.020086104634371993`}, {-0.5881812851897159, 0., 
        0.020086104634371993`}}]}, {{{1., 0., 0.}, {0., 
       1., -3.3420873133901936`*^-15}, {0., 3.3420873133901936`*^-15, 1.}}, {
       0., 0., -4.1107673954699383`*^-16}}], {{{1., 0., 0.}, {0., 1., 0.}, {
      0., 0., 1.}}, {0., 0., 0.}}], {{{0.9999999999999437, 
     3.3537478945651203`*^-7, 0.}, {-3.3537478945651203`*^-7, 
     0.9999999999999437, 0.}, {0., 0., 
     1.}}, {-4.125113572950312*^-8, -2.1799359238572347`*^-7, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.3725528670658566, 0.5, -0.5474656627411375}, {
        0.3725528670658566, 0., -0.5474656627411375}, {0.3654508909698463, 
        0., -0.5335272498452612}, {0.3654508909698463, 
        0.5, -0.5335272498452612}}], 
       Polygon3DBox[{{0.3654508909698463, 0.5, -0.5335272498452612}, {
        0.3654508909698463, 0., -0.5335272498452612}, {0.3543893038657226, 
        0., -0.5224656627411375}, {0.3543893038657226, 
        0.5, -0.5224656627411375}}], 
       Polygon3DBox[{{0.3543893038657226, 0.5, -0.5224656627411375}, {
        0.3543893038657226, 0., -0.5224656627411375}, {0.3404508909698463, 
        0., -0.5153636866451271}, {0.3404508909698463, 
        0.5, -0.5153636866451271}}], 
       Polygon3DBox[{{0.3404508909698463, 0.5, -0.5153636866451271}, {
        0.3404508909698463, 0., -0.5153636866451271}, {0.32500004125109894`, 
        0., -0.5129165124598848}, {0.32500004125109894`, 
        0.5, -0.5129165124598848}}], 
       Polygon3DBox[{{0.32500004125109894`, 0.5, -0.5129165124598848}, {
        0.32500004125109894`, 0., -0.5129165124598848}, {0.30954919153235155`,
         0., -0.5153636866451271}, {0.30954919153235155`, 
        0.5, -0.5153636866451271}}], 
       Polygon3DBox[{{0.30954919153235155`, 0.5, -0.5153636866451271}, {
        0.30954919153235155`, 0., -0.5153636866451271}, {0.2956107786364753, 
        0., -0.5224656627411375}, {0.2956107786364753, 
        0.5, -0.5224656627411375}}], 
       Polygon3DBox[{{0.2956107786364753, 0.5, -0.5224656627411375}, {
        0.2956107786364753, 0., -0.5224656627411375}, {0.2845491915323516, 
        0., -0.5335272498452612}, {0.2845491915323516, 
        0.5, -0.5335272498452612}}], 
       Polygon3DBox[{{0.2845491915323516, 0.5, -0.5335272498452612}, {
        0.2845491915323516, 0., -0.5335272498452612}, {0.27744721543634127`, 
        0., -0.5474656627411375}, {0.27744721543634127`, 
        0.5, -0.5474656627411375}}], 
       Polygon3DBox[{{0.27744721543634127`, 0.5, -0.5474656627411375}, {
        0.27744721543634127`, 0., -0.5474656627411375}, {0.27500004125109895`,
         0., -0.5629165124598848}, {0.27500004125109895`, 
        0.5, -0.5629165124598848}}], 
       Polygon3DBox[{{0.27500004125109895`, 0.5, -0.5629165124598848}, {
        0.27500004125109895`, 0., -0.5629165124598848}, {0.27744721543634127`,
         0., -0.5783673621786322}, {0.27744721543634127`, 
        0.5, -0.5783673621786322}}], 
       Polygon3DBox[{{0.27744721543634127`, 0.5, -0.5783673621786322}, {
        0.27744721543634127`, 0., -0.5783673621786322}, {0.2845491915323516, 
        0., -0.5923057750745084}, {0.2845491915323516, 
        0.5, -0.5923057750745084}}], 
       Polygon3DBox[{{0.2845491915323516, 0.5, -0.5923057750745084}, {
        0.2845491915323516, 0., -0.5923057750745084}, {0.2956107786364753, 
        0., -0.6033673621786322}, {0.2956107786364753, 
        0.5, -0.6033673621786322}}], 
       Polygon3DBox[{{0.2956107786364753, 0.5, -0.6033673621786322}, {
        0.2956107786364753, 0., -0.6033673621786322}, {0.30954919153235155`, 
        0., -0.6104693382746426}, {0.30954919153235155`, 
        0.5, -0.6104693382746426}}], 
       Polygon3DBox[{{0.30954919153235155`, 0.5, -0.6104693382746426}, {
        0.30954919153235155`, 0., -0.6104693382746426}, {0.32500004125109894`,
         0., -0.6129165124598849}, {0.32500004125109894`, 
        0.5, -0.6129165124598849}}], 
       Polygon3DBox[{{0.32500004125109894`, 0.5, -0.6129165124598849}, {
        0.32500004125109894`, 0., -0.6129165124598849}, {0.3404508909698463, 
        0., -0.6104693382746426}, {0.3404508909698463, 
        0.5, -0.6104693382746426}}], 
       Polygon3DBox[{{0.3404508909698463, 0.5, -0.6104693382746426}, {
        0.3404508909698463, 0., -0.6104693382746426}, {0.3543893038657226, 
        0., -0.6033673621786322}, {0.3543893038657226, 
        0.5, -0.6033673621786322}}], 
       Polygon3DBox[{{0.3543893038657226, 0.5, -0.6033673621786322}, {
        0.3543893038657226, 0., -0.6033673621786322}, {0.3654508909698463, 
        0., -0.5923057750745084}, {0.3654508909698463, 
        0.5, -0.5923057750745084}}], 
       Polygon3DBox[{{0.3654508909698463, 0.5, -0.5923057750745084}, {
        0.3654508909698463, 0., -0.5923057750745084}, {0.3725528670658566, 
        0., -0.5783673621786322}, {0.3725528670658566, 
        0.5, -0.5783673621786322}}], 
       Polygon3DBox[{{0.3725528670658566, 0.5, -0.5783673621786322}, {
        0.3725528670658566, 0., -0.5783673621786322}, {0.3750000412510989, 
        0., -0.5629165124598848}, {0.3750000412510989, 
        0.5, -0.5629165124598848}}], 
       Polygon3DBox[{{0.3750000412510989, 0.5, -0.5629165124598848}, {
        0.3750000412510989, 0., -0.5629165124598848}, {0.3725528670658566, 
        0., -0.5474656627411375}, {0.3725528670658566, 
        0.5, -0.5474656627411375}}], 
       Polygon3DBox[{{0.3868187148102839, 0., -0.5428304078255133}, {
        0.3868187148102839, -0.15000000000000002`, -0.5428304078255133}, {
        0.3775861458854705, -0.15000000000000002`, -0.5247104710608741}, {
        0.3775861458854705, 0., -0.5247104710608741}}], 
       Polygon3DBox[{{0.3775861458854705, 0., -0.5247104710608741}, {
        0.3775861458854705, -0.15000000000000002`, -0.5247104710608741}, {
        0.3632060826501097, -0.15000000000000002`, -0.5103304078255132}, {
        0.3632060826501097, 0., -0.5103304078255132}}], 
       Polygon3DBox[{{0.3632060826501097, 0., -0.5103304078255132}, {
        0.3632060826501097, -0.15000000000000002`, -0.5103304078255132}, {
        0.34508614588547054`, -0.15000000000000002`, -0.5010978389006998}, {
        0.34508614588547054`, 0., -0.5010978389006998}}], 
       Polygon3DBox[{{0.34508614588547054`, 0., -0.5010978389006998}, {
        0.34508614588547054`, -0.15000000000000002`, -0.5010978389006998}, {
        0.32500004125109894`, -0.15000000000000002`, -0.49791651245988483`}, {
        0.32500004125109894`, 0., -0.49791651245988483`}}], 
       Polygon3DBox[{{0.32500004125109894`, 0., -0.49791651245988483`}, {
        0.32500004125109894`, -0.15000000000000002`, -0.49791651245988483`}, {
        0.30491393661672733`, -0.15000000000000002`, -0.5010978389006998}, {
        0.30491393661672733`, 0., -0.5010978389006998}}], 
       Polygon3DBox[{{0.30491393661672733`, 0., -0.5010978389006998}, {
        0.30491393661672733`, -0.15000000000000002`, -0.5010978389006998}, {
        0.2867939998520882, -0.15000000000000002`, -0.5103304078255132}, {
        0.2867939998520882, 0., -0.5103304078255132}}], 
       Polygon3DBox[{{0.2867939998520882, 0., -0.5103304078255132}, {
        0.2867939998520882, -0.15000000000000002`, -0.5103304078255132}, {
        0.27241393661672736`, -0.15000000000000002`, -0.5247104710608741}, {
        0.27241393661672736`, 0., -0.5247104710608741}}], 
       Polygon3DBox[{{0.27241393661672736`, 0., -0.5247104710608741}, {
        0.27241393661672736`, -0.15000000000000002`, -0.5247104710608741}, {
        0.26318136769191397`, -0.15000000000000002`, -0.5428304078255133}, {
        0.26318136769191397`, 0., -0.5428304078255133}}], 
       Polygon3DBox[{{0.26318136769191397`, 0., -0.5428304078255133}, {
        0.26318136769191397`, -0.15000000000000002`, -0.5428304078255133}, {
        0.26000004125109893`, -0.15000000000000002`, -0.5629165124598848}, {
        0.26000004125109893`, 0., -0.5629165124598848}}], 
       Polygon3DBox[{{0.26000004125109893`, 0., -0.5629165124598848}, {
        0.26000004125109893`, -0.15000000000000002`, -0.5629165124598848}, {
        0.26318136769191397`, -0.15000000000000002`, -0.5830026170942564}, {
        0.26318136769191397`, 0., -0.5830026170942564}}], 
       Polygon3DBox[{{0.26318136769191397`, 0., -0.5830026170942564}, {
        0.26318136769191397`, -0.15000000000000002`, -0.5830026170942564}, {
        0.27241393661672736`, -0.15000000000000002`, -0.6011225538588956}, {
        0.27241393661672736`, 0., -0.6011225538588956}}], 
       Polygon3DBox[{{0.27241393661672736`, 0., -0.6011225538588956}, {
        0.27241393661672736`, -0.15000000000000002`, -0.6011225538588956}, {
        0.2867939998520882, -0.15000000000000002`, -0.6155026170942565}, {
        0.2867939998520882, 0., -0.6155026170942565}}], 
       Polygon3DBox[{{0.2867939998520882, 0., -0.6155026170942565}, {
        0.2867939998520882, -0.15000000000000002`, -0.6155026170942565}, {
        0.30491393661672733`, -0.15000000000000002`, -0.6247351860190699}, {
        0.30491393661672733`, 0., -0.6247351860190699}}], 
       Polygon3DBox[{{0.30491393661672733`, 0., -0.6247351860190699}, {
        0.30491393661672733`, -0.15000000000000002`, -0.6247351860190699}, {
        0.32500004125109894`, -0.15000000000000002`, -0.6279165124598849}, {
        0.32500004125109894`, 0., -0.6279165124598849}}], 
       Polygon3DBox[{{0.32500004125109894`, 0., -0.6279165124598849}, {
        0.32500004125109894`, -0.15000000000000002`, -0.6279165124598849}, {
        0.34508614588547054`, -0.15000000000000002`, -0.6247351860190699}, {
        0.34508614588547054`, 0., -0.6247351860190699}}], 
       Polygon3DBox[{{0.34508614588547054`, 0., -0.6247351860190699}, {
        0.34508614588547054`, -0.15000000000000002`, -0.6247351860190699}, {
        0.3632060826501097, -0.15000000000000002`, -0.6155026170942565}, {
        0.3632060826501097, 0., -0.6155026170942565}}], 
       Polygon3DBox[{{0.3632060826501097, 0., -0.6155026170942565}, {
        0.3632060826501097, -0.15000000000000002`, -0.6155026170942565}, {
        0.3775861458854705, -0.15000000000000002`, -0.6011225538588956}, {
        0.3775861458854705, 0., -0.6011225538588956}}], 
       Polygon3DBox[{{0.3775861458854705, 0., -0.6011225538588956}, {
        0.3775861458854705, -0.15000000000000002`, -0.6011225538588956}, {
        0.3868187148102839, -0.15000000000000002`, -0.5830026170942564}, {
        0.3868187148102839, 0., -0.5830026170942564}}], 
       Polygon3DBox[{{0.3868187148102839, 0., -0.5830026170942564}, {
        0.3868187148102839, -0.15000000000000002`, -0.5830026170942564}, {
        0.39000004125109894`, -0.15000000000000002`, -0.5629165124598848}, {
        0.39000004125109894`, 0., -0.5629165124598848}}], 
       Polygon3DBox[{{0.39000004125109894`, 0., -0.5629165124598848}, {
        0.39000004125109894`, -0.15000000000000002`, -0.5629165124598848}, {
        0.3868187148102839, -0.15000000000000002`, -0.5428304078255133}, {
        0.3868187148102839, 0., -0.5428304078255133}}]}, {{{1., 0., 0.}, {0., 
       1., -3.1086244689504383`*^-15}, {0., 3.1086244689504383`*^-15, 1.}}, {
       0., -1.7486012637846216`*^-15, -3.3306690738754696`*^-16}}], {{{1., 0.,
       0.}, {0., 1., 0.}, {0., 0., 1.}}, {0., 0., 0.}}], {{{
     0.9999999999999437, 3.3537478938416224`*^-7, 
     0.}, {-3.3537478938416224`*^-7, 0.9999999999999437, 0.}, {0., 0., 
     1.}}, {-4.12510807734634*^-8, 1.0899682731380089`*^-7, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.37255286706585705`, 0.5, 0.5783673621786327}, {
        0.37255286706585705`, 0., 0.5783673621786327}, {0.36545089096984673`, 
        0., 0.5923057750745091}, {0.36545089096984673`, 0.5, 
        0.5923057750745091}}], 
       Polygon3DBox[{{0.36545089096984673`, 0.5, 0.5923057750745091}, {
        0.36545089096984673`, 0., 0.5923057750745091}, {0.35438930386572304`, 
        0., 0.6033673621786327}, {0.35438930386572304`, 0.5, 
        0.6033673621786327}}], 
       Polygon3DBox[{{0.35438930386572304`, 0.5, 0.6033673621786327}, {
        0.35438930386572304`, 0., 0.6033673621786327}, {0.34045089096984676`, 
        0., 0.6104693382746431}, {0.34045089096984676`, 0.5, 
        0.6104693382746431}}], 
       Polygon3DBox[{{0.34045089096984676`, 0.5, 0.6104693382746431}, {
        0.34045089096984676`, 0., 0.6104693382746431}, {0.3250000412510994, 
        0., 0.6129165124598854}, {0.3250000412510994, 0.5, 
        0.6129165124598854}}], 
       Polygon3DBox[{{0.3250000412510994, 0.5, 0.6129165124598854}, {
        0.3250000412510994, 0., 0.6129165124598854}, {0.309549191532352, 0., 
        0.6104693382746431}, {0.309549191532352, 0.5, 0.6104693382746431}}], 
       Polygon3DBox[{{0.309549191532352, 0.5, 0.6104693382746431}, {
        0.309549191532352, 0., 0.6104693382746431}, {0.2956107786364757, 0., 
        0.6033673621786327}, {0.2956107786364757, 0.5, 0.6033673621786327}}], 
       Polygon3DBox[{{0.2956107786364757, 0.5, 0.6033673621786327}, {
        0.2956107786364757, 0., 0.6033673621786327}, {0.28454919153235203`, 
        0., 0.5923057750745091}, {0.28454919153235203`, 0.5, 
        0.5923057750745091}}], 
       Polygon3DBox[{{0.28454919153235203`, 0.5, 0.5923057750745091}, {
        0.28454919153235203`, 0., 0.5923057750745091}, {0.2774472154363417, 
        0., 0.5783673621786327}, {0.2774472154363417, 0.5, 
        0.5783673621786327}}], 
       Polygon3DBox[{{0.2774472154363417, 0.5, 0.5783673621786327}, {
        0.2774472154363417, 0., 0.5783673621786327}, {0.2750000412510994, 0., 
        0.5629165124598854}, {0.2750000412510994, 0.5, 0.5629165124598854}}], 
       Polygon3DBox[{{0.2750000412510994, 0.5, 0.5629165124598854}, {
        0.2750000412510994, 0., 0.5629165124598854}, {0.2774472154363417, 0., 
        0.5474656627411381}, {0.2774472154363417, 0.5, 0.5474656627411381}}], 
       Polygon3DBox[{{0.2774472154363417, 0.5, 0.5474656627411381}, {
        0.2774472154363417, 0., 0.5474656627411381}, {0.28454919153235203`, 
        0., 0.5335272498452617}, {0.28454919153235203`, 0.5, 
        0.5335272498452617}}], 
       Polygon3DBox[{{0.28454919153235203`, 0.5, 0.5335272498452617}, {
        0.28454919153235203`, 0., 0.5335272498452617}, {0.2956107786364757, 
        0., 0.522465662741138}, {0.2956107786364757, 0.5, 
        0.522465662741138}}], 
       Polygon3DBox[{{0.2956107786364757, 0.5, 0.522465662741138}, {
        0.2956107786364757, 0., 0.522465662741138}, {0.309549191532352, 0., 
        0.5153636866451277}, {0.309549191532352, 0.5, 0.5153636866451277}}], 
       Polygon3DBox[{{0.309549191532352, 0.5, 0.5153636866451277}, {
        0.309549191532352, 0., 0.5153636866451277}, {0.3250000412510994, 0., 
        0.5129165124598853}, {0.3250000412510994, 0.5, 0.5129165124598853}}], 
       Polygon3DBox[{{0.3250000412510994, 0.5, 0.5129165124598853}, {
        0.3250000412510994, 0., 0.5129165124598853}, {0.34045089096984676`, 
        0., 0.5153636866451277}, {0.34045089096984676`, 0.5, 
        0.5153636866451277}}], 
       Polygon3DBox[{{0.34045089096984676`, 0.5, 0.5153636866451277}, {
        0.34045089096984676`, 0., 0.5153636866451277}, {0.35438930386572304`, 
        0., 0.522465662741138}, {0.35438930386572304`, 0.5, 
        0.522465662741138}}], 
       Polygon3DBox[{{0.35438930386572304`, 0.5, 0.522465662741138}, {
        0.35438930386572304`, 0., 0.522465662741138}, {0.36545089096984673`, 
        0., 0.5335272498452617}, {0.36545089096984673`, 0.5, 
        0.5335272498452617}}], 
       Polygon3DBox[{{0.36545089096984673`, 0.5, 0.5335272498452617}, {
        0.36545089096984673`, 0., 0.5335272498452617}, {0.37255286706585705`, 
        0., 0.5474656627411381}, {0.37255286706585705`, 0.5, 
        0.5474656627411381}}], 
       Polygon3DBox[{{0.37255286706585705`, 0.5, 0.5474656627411381}, {
        0.37255286706585705`, 0., 0.5474656627411381}, {0.37500004125109937`, 
        0., 0.5629165124598854}, {0.37500004125109937`, 0.5, 
        0.5629165124598854}}], 
       Polygon3DBox[{{0.37500004125109937`, 0.5, 0.5629165124598854}, {
        0.37500004125109937`, 0., 0.5629165124598854}, {0.37255286706585705`, 
        0., 0.5783673621786327}, {0.37255286706585705`, 0.5, 
        0.5783673621786327}}], 
       Polygon3DBox[{{0.38681871481028435`, 0., 0.5830026170942569}, {
        0.38681871481028435`, -0.15000000000000002`, 0.5830026170942569}, {
        0.37758614588547096`, -0.15000000000000002`, 0.6011225538588961}, {
        0.37758614588547096`, 0., 0.6011225538588961}}], 
       Polygon3DBox[{{0.37758614588547096`, 0., 0.6011225538588961}, {
        0.37758614588547096`, -0.15000000000000002`, 0.6011225538588961}, {
        0.3632060826501101, -0.15000000000000002`, 0.615502617094257}, {
        0.3632060826501101, 0., 0.615502617094257}}], 
       Polygon3DBox[{{0.3632060826501101, 0., 0.615502617094257}, {
        0.3632060826501101, -0.15000000000000002`, 0.615502617094257}, {
        0.345086145885471, -0.15000000000000002`, 0.6247351860190704}, {
        0.345086145885471, 0., 0.6247351860190704}}], 
       Polygon3DBox[{{0.345086145885471, 0., 0.6247351860190704}, {
        0.345086145885471, -0.15000000000000002`, 0.6247351860190704}, {
        0.3250000412510994, -0.15000000000000002`, 0.6279165124598853}, {
        0.3250000412510994, 0., 0.6279165124598853}}], 
       Polygon3DBox[{{0.3250000412510994, 0., 0.6279165124598853}, {
        0.3250000412510994, -0.15000000000000002`, 0.6279165124598853}, {
        0.3049139366167278, -0.15000000000000002`, 0.6247351860190704}, {
        0.3049139366167278, 0., 0.6247351860190704}}], 
       Polygon3DBox[{{0.3049139366167278, 0., 0.6247351860190704}, {
        0.3049139366167278, -0.15000000000000002`, 0.6247351860190704}, {
        0.28679399985208864`, -0.15000000000000002`, 0.615502617094257}, {
        0.28679399985208864`, 0., 0.615502617094257}}], 
       Polygon3DBox[{{0.28679399985208864`, 0., 0.615502617094257}, {
        0.28679399985208864`, -0.15000000000000002`, 0.615502617094257}, {
        0.2724139366167278, -0.15000000000000002`, 0.6011225538588961}, {
        0.2724139366167278, 0., 0.6011225538588961}}], 
       Polygon3DBox[{{0.2724139366167278, 0., 0.6011225538588961}, {
        0.2724139366167278, -0.15000000000000002`, 0.6011225538588961}, {
        0.2631813676919144, -0.15000000000000002`, 0.5830026170942569}, {
        0.2631813676919144, 0., 0.5830026170942569}}], 
       Polygon3DBox[{{0.2631813676919144, 0., 0.5830026170942569}, {
        0.2631813676919144, -0.15000000000000002`, 0.5830026170942569}, {
        0.2600000412510994, -0.15000000000000002`, 0.5629165124598854}, {
        0.2600000412510994, 0., 0.5629165124598854}}], 
       Polygon3DBox[{{0.2600000412510994, 0., 0.5629165124598854}, {
        0.2600000412510994, -0.15000000000000002`, 0.5629165124598854}, {
        0.2631813676919144, -0.15000000000000002`, 0.5428304078255138}, {
        0.2631813676919144, 0., 0.5428304078255138}}], 
       Polygon3DBox[{{0.2631813676919144, 0., 0.5428304078255138}, {
        0.2631813676919144, -0.15000000000000002`, 0.5428304078255138}, {
        0.2724139366167278, -0.15000000000000002`, 0.5247104710608747}, {
        0.2724139366167278, 0., 0.5247104710608747}}], 
       Polygon3DBox[{{0.2724139366167278, 0., 0.5247104710608747}, {
        0.2724139366167278, -0.15000000000000002`, 0.5247104710608747}, {
        0.28679399985208864`, -0.15000000000000002`, 0.5103304078255138}, {
        0.28679399985208864`, 0., 0.5103304078255138}}], 
       Polygon3DBox[{{0.28679399985208864`, 0., 0.5103304078255138}, {
        0.28679399985208864`, -0.15000000000000002`, 0.5103304078255138}, {
        0.3049139366167278, -0.15000000000000002`, 0.5010978389007004}, {
        0.3049139366167278, 0., 0.5010978389007004}}], 
       Polygon3DBox[{{0.3049139366167278, 0., 0.5010978389007004}, {
        0.3049139366167278, -0.15000000000000002`, 0.5010978389007004}, {
        0.3250000412510994, -0.15000000000000002`, 0.4979165124598854}, {
        0.3250000412510994, 0., 0.4979165124598854}}], 
       Polygon3DBox[{{0.3250000412510994, 0., 0.4979165124598854}, {
        0.3250000412510994, -0.15000000000000002`, 0.4979165124598854}, {
        0.345086145885471, -0.15000000000000002`, 0.5010978389007004}, {
        0.345086145885471, 0., 0.5010978389007004}}], 
       Polygon3DBox[{{0.345086145885471, 0., 0.5010978389007004}, {
        0.345086145885471, -0.15000000000000002`, 0.5010978389007004}, {
        0.3632060826501101, -0.15000000000000002`, 0.5103304078255138}, {
        0.3632060826501101, 0., 0.5103304078255138}}], 
       Polygon3DBox[{{0.3632060826501101, 0., 0.5103304078255138}, {
        0.3632060826501101, -0.15000000000000002`, 0.5103304078255138}, {
        0.37758614588547096`, -0.15000000000000002`, 0.5247104710608747}, {
        0.37758614588547096`, 0., 0.5247104710608747}}], 
       Polygon3DBox[{{0.37758614588547096`, 0., 0.5247104710608747}, {
        0.37758614588547096`, -0.15000000000000002`, 0.5247104710608747}, {
        0.38681871481028435`, -0.15000000000000002`, 0.5428304078255138}, {
        0.38681871481028435`, 0., 0.5428304078255138}}], 
       Polygon3DBox[{{0.38681871481028435`, 0., 0.5428304078255138}, {
        0.38681871481028435`, -0.15000000000000002`, 0.5428304078255138}, {
        0.3900000412510994, -0.15000000000000002`, 0.5629165124598854}, {
        0.3900000412510994, 0., 0.5629165124598854}}], 
       Polygon3DBox[{{0.3900000412510994, 0., 0.5629165124598854}, {
        0.3900000412510994, -0.15000000000000002`, 0.5629165124598854}, {
        0.38681871481028435`, -0.15000000000000002`, 0.5830026170942569}, {
        0.38681871481028435`, 0., 0.5830026170942569}}]}, {{{1., 0., 0.}, {0.,
        1., -3.1086244689504383`*^-15}, {0., 3.1086244689504383`*^-15, 1.}}, {
       0., 1.7486012637846216`*^-15, -3.3306690738754696`*^-16}}], {{{1., 0., 
      0.}, {0., 1., 0.}, {0., 0., 1.}}, {0., 0., 0.}}], {{{0.9999999999999437,
      3.3537478960620684`*^-7, 0.}, {-3.3537478960620684`*^-7, 
     0.9999999999999437, 0.}, {0., 0., 1.}}, {-4.125108082897455*^-8, 
     1.0899682738318983`*^-7, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[
     GeometricTransformation3DBox[{
       Polygon3DBox[{{0.8083980388508806, 0, 0.26266444521870536`}, {
         0.4279754323328191, 0, 0.13905764746872637`}, {
         0.3640576474687264, 0, 0.2645033635316129}, {
         0.6876644452187054, 0, 0.4996174644486022}}], 
       Polygon3DBox[{{0.6876644452187054, 0, 0.4996174644486022}, {
         0.3640576474687264, 0, 0.2645033635316129}, {
         0.2645033635316129, 0, 0.3640576474687264}, {
         0.4996174644486022, 0, 0.6876644452187054}}], 
       Polygon3DBox[{{0.4996174644486022, 0, 0.6876644452187054}, {
         0.2645033635316129, 0, 0.3640576474687264}, {
         0.13905764746872637`, 0, 0.4279754323328191}, {
         0.26266444521870536`, 0, 0.8083980388508806}}], 
       Polygon3DBox[{{0.26266444521870536`, 0, 0.8083980388508806}, {
         0.13905764746872637`, 0, 0.4279754323328191}, {0., 0, 0.45}, {
         0., 0, 0.8500000000000001}}], 
       Polygon3DBox[{{0., 0, 0.8500000000000001}, {
         0., 0, 0.45}, {-0.13905764746872637`, 0, 
          0.4279754323328191}, {-0.26266444521870536`, 0, 
          0.8083980388508806}}], 
       Polygon3DBox[{{-0.26266444521870536`, 0, 
          0.8083980388508806}, {-0.13905764746872637`, 0, 
          0.4279754323328191}, {-0.2645033635316129, 0, 
          0.3640576474687264}, {-0.4996174644486022, 0, 0.6876644452187054}}],
        Polygon3DBox[{{-0.4996174644486022, 0, 
          0.6876644452187054}, {-0.2645033635316129, 0, 
          0.3640576474687264}, {-0.3640576474687264, 0, 
          0.2645033635316129}, {-0.6876644452187054, 0, 0.4996174644486022}}],
        Polygon3DBox[{{-0.6876644452187054, 0, 
          0.4996174644486022}, {-0.3640576474687264, 0, 
          0.2645033635316129}, {-0.4279754323328191, 0, 
          0.13905764746872637`}, {-0.8083980388508806, 0, 
          0.26266444521870536`}}], 
       Polygon3DBox[{{-0.8083980388508806, 0, 
          0.26266444521870536`}, {-0.4279754323328191, 0, 
          0.13905764746872637`}, {-0.45, 0, 0.}, {-0.8500000000000001, 0, 
          0.}}], Polygon3DBox[{{-0.8500000000000001, 0, 0.}, {-0.45, 0, 
          0.}, {-0.4279754323328191, 
          0, -0.13905764746872637`}, {-0.8083980388508806, 
          0, -0.26266444521870536`}}], 
       Polygon3DBox[{{-0.8083980388508806, 
          0, -0.26266444521870536`}, {-0.4279754323328191, 
          0, -0.13905764746872637`}, {-0.3640576474687264, 
          0, -0.2645033635316129}, {-0.6876644452187054, 
          0, -0.4996174644486022}}], 
       Polygon3DBox[{{-0.6876644452187054, 
          0, -0.4996174644486022}, {-0.3640576474687264, 
          0, -0.2645033635316129}, {-0.2645033635316129, 
          0, -0.3640576474687264}, {-0.4996174644486022, 
          0, -0.6876644452187054}}], 
       Polygon3DBox[{{-0.4996174644486022, 
          0, -0.6876644452187054}, {-0.2645033635316129, 
          0, -0.3640576474687264}, {-0.13905764746872637`, 
          0, -0.4279754323328191}, {-0.26266444521870536`, 
          0, -0.8083980388508806}}], 
       Polygon3DBox[{{-0.26266444521870536`, 
          0, -0.8083980388508806}, {-0.13905764746872637`, 
          0, -0.4279754323328191}, {0., 0, -0.45}, {
         0., 0, -0.8500000000000001}}], 
       Polygon3DBox[{{0., 0, -0.8500000000000001}, {0., 0, -0.45}, {
         0.13905764746872637`, 0, -0.4279754323328191}, {
         0.26266444521870536`, 0, -0.8083980388508806}}], 
       Polygon3DBox[{{0.26266444521870536`, 0, -0.8083980388508806}, {
         0.13905764746872637`, 0, -0.4279754323328191}, {
         0.2645033635316129, 0, -0.3640576474687264}, {
         0.4996174644486022, 0, -0.6876644452187054}}], 
       Polygon3DBox[{{0.4996174644486022, 0, -0.6876644452187054}, {
         0.2645033635316129, 0, -0.3640576474687264}, {
         0.3640576474687264, 0, -0.2645033635316129}, {
         0.6876644452187054, 0, -0.4996174644486022}}], 
       Polygon3DBox[{{0.6876644452187054, 0, -0.4996174644486022}, {
         0.3640576474687264, 0, -0.2645033635316129}, {
         0.4279754323328191, 0, -0.13905764746872637`}, {
         0.8083980388508806, 0, -0.26266444521870536`}}], 
       Polygon3DBox[{{0.8083980388508806, 0, -0.26266444521870536`}, {
         0.4279754323328191, 0, -0.13905764746872637`}, {0.45, 0, 0.}, {
         0.8500000000000001, 0, 0.}}], 
       Polygon3DBox[{{0.8500000000000001, 0, 0.}, {0.45, 0, 0.}, {
         0.4279754323328191, 0, 0.13905764746872637`}, {
         0.8083980388508806, 0, 0.26266444521870536`}}]}, {{{1, 0, 0}, {0, 1, 
       0}, {0, 0, 1}}, {0, 0, 0}}], {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {0, 0,
       0}}], {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {0, 0, 0}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019021297704994368`, 0.4917479682464967, 
         0.006180339887500552}, {0.019021297704994368`, 0.4817479682464967, 
         0.006180339887500552}, {0.016180507266590243`, 0.4817479682464967, 
         0.011755705045851066`}, {0.016180507266590243`, 0.4917479682464967, 
         0.011755705045851066`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180507266590243`, 0.4917479682464967, 
         0.011755705045851066`}, {0.016180507266590243`, 0.4817479682464967, 
         0.011755705045851066`}, {0.01175587242494076, 0.4817479682464967, 
         0.01618033988750055}, {0.01175587242494076, 0.4917479682464967, 
         0.01618033988750055}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01175587242494076, 0.4917479682464967, 
         0.01618033988750055}, {0.01175587242494076, 0.4817479682464967, 
         0.01618033988750055}, {0.006180507266590246, 0.4817479682464967, 
         0.019021130325904675`}, {0.006180507266590246, 0.4917479682464967, 
         0.019021130325904675`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180507266590246, 0.4917479682464967, 
         0.019021130325904675`}, {0.006180507266590246, 0.4817479682464967, 
         0.019021130325904675`}, {1.673790912970372*^-7, 0.4817479682464967, 
         0.020000000000001603`}, {1.673790912970372*^-7, 0.4917479682464967, 
         0.020000000000001603`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{1.673790912970372*^-7, 0.4917479682464967, 
         0.020000000000001603`}, {1.673790912970372*^-7, 0.4817479682464967, 
         0.020000000000001603`}, {-0.006180172508407652, 0.4817479682464967, 
         0.019021130325904675`}, {-0.006180172508407652, 0.4917479682464967, 
         0.019021130325904675`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180172508407652, 0.4917479682464967, 
         0.019021130325904675`}, {-0.006180172508407652, 0.4817479682464967, 
         0.019021130325904675`}, {-0.011755537666758166`, 0.4817479682464967, 
         0.01618033988750055}, {-0.011755537666758166`, 0.4917479682464967, 
         0.01618033988750055}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755537666758166`, 0.4917479682464967, 
         0.01618033988750055}, {-0.011755537666758166`, 0.4817479682464967, 
         0.01618033988750055}, {-0.016180172508407652`, 0.4817479682464967, 
         0.011755705045851066`}, {-0.016180172508407652`, 0.4917479682464967, 
         0.011755705045851066`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180172508407652`, 0.4917479682464967, 
         0.011755705045851066`}, {-0.016180172508407652`, 0.4817479682464967, 
         0.011755705045851066`}, {-0.019020962946811777`, 0.4817479682464967, 
         0.006180339887500552}, {-0.019020962946811777`, 0.4917479682464967, 
         0.006180339887500552}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019020962946811777`, 0.4917479682464967, 
         0.006180339887500552}, {-0.019020962946811777`, 0.4817479682464967, 
         0.006180339887500552}, {-0.019999832620908705`, 0.4817479682464967, 
         1.6025513612019303`*^-15}, {-0.019999832620908705`, 
         0.4917479682464967, 1.6025513612019303`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019999832620908705`, 0.4917479682464967, 
         1.6025513612019303`*^-15}, {-0.019999832620908705`, 
         0.4817479682464967, 
         1.6025513612019303`*^-15}, {-0.019020962946811777`, 
         0.4817479682464967, -0.006180339887497346}, {-0.019020962946811777`, 
         0.4917479682464967, -0.006180339887497346}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.019020962946811777`, 
         0.4917479682464967, -0.006180339887497346}, {-0.019020962946811777`, 
         0.4817479682464967, -0.006180339887497346}, {-0.016180172508407652`, 
         0.4817479682464967, -0.01175570504584786}, {-0.016180172508407652`, 
         0.4917479682464967, -0.01175570504584786}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180172508407652`, 
         0.4917479682464967, -0.01175570504584786}, {-0.016180172508407652`, 
         0.4817479682464967, -0.01175570504584786}, {-0.011755537666758166`, 
         0.4817479682464967, -0.016180339887497345`}, {-0.011755537666758166`,
          0.4917479682464967, -0.016180339887497345`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755537666758166`, 
         0.4917479682464967, -0.016180339887497345`}, {-0.011755537666758166`,
          0.4817479682464967, -0.016180339887497345`}, {-0.006180172508407652,
          0.4817479682464967, -0.01902113032590147}, {-0.006180172508407652, 
         0.4917479682464967, -0.01902113032590147}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180172508407652, 
         0.4917479682464967, -0.01902113032590147}, {-0.006180172508407652, 
         0.4817479682464967, -0.01902113032590147}, {1.673790912970372*^-7, 
         0.4817479682464967, -0.019999999999998398`}, {1.673790912970372*^-7, 
         0.4917479682464967, -0.019999999999998398`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{1.673790912970372*^-7, 
         0.4917479682464967, -0.019999999999998398`}, {1.673790912970372*^-7, 
         0.4817479682464967, -0.019999999999998398`}, {0.006180507266590246, 
         0.4817479682464967, -0.01902113032590147}, {0.006180507266590246, 
         0.4917479682464967, -0.01902113032590147}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.006180507266590246, 
         0.4917479682464967, -0.01902113032590147}, {0.006180507266590246, 
         0.4817479682464967, -0.01902113032590147}, {0.01175587242494076, 
         0.4817479682464967, -0.016180339887497345`}, {0.01175587242494076, 
         0.4917479682464967, -0.016180339887497345`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01175587242494076, 
         0.4917479682464967, -0.016180339887497345`}, {0.01175587242494076, 
         0.4817479682464967, -0.016180339887497345`}, {0.016180507266590243`, 
         0.4817479682464967, -0.01175570504584786}, {0.016180507266590243`, 
         0.4917479682464967, -0.01175570504584786}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180507266590243`, 
         0.4917479682464967, -0.01175570504584786}, {0.016180507266590243`, 
         0.4817479682464967, -0.01175570504584786}, {0.019021297704994368`, 
         0.4817479682464967, -0.006180339887497346}, {0.019021297704994368`, 
         0.4917479682464967, -0.006180339887497346}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.019021297704994368`, 
         0.4917479682464967, -0.006180339887497346}, {0.019021297704994368`, 
         0.4817479682464967, -0.006180339887497346}, {0.020000167379091296`, 
         0.4817479682464967, 1.6025513612019303`*^-15}, {
         0.020000167379091296`, 0.4917479682464967, 
         1.6025513612019303`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.020000167379091296`, 0.4917479682464967, 
         1.6025513612019303`*^-15}, {0.020000167379091296`, 
         0.4817479682464967, 1.6025513612019303`*^-15}, {
         0.019021297704994368`, 0.4817479682464967, 0.006180339887500552}, {
         0.019021297704994368`, 0.4917479682464967, 
         0.006180339887500552}}]}}, {{{1., 0., 0.}, {0., 
       1., -6.051872572657478*^-17}, {0., 6.051872572657478*^-17, 1.}}, {0., 
       0., -2.945736678827724*^-17}}], {{{1., 0., 1.0118066519708342`*^-16}, {
      0., 1., 0.}, {-1.0118066519708342`*^-16, 0., 1.}}, {0., 0., 
      1.6935527815105215`*^-23}}], {{{1., -1.5697850808258716`*^-9, 0.}, {
     1.5697850808258716`*^-9, 1., 0.}, {0., 0., 1.}}, {
     7.64089698675654*^-10, -2.7755575615628914`*^-16, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019021089919137684`, -1.6255896498958635`, 
         0.006180339887498695}, {0.019021089919137684`, -1.6355896498958633`, 
         0.006180339887498695}, {0.01618029948073356, -1.6355896498958633`, 
         0.011755705045849208`}, {0.01618029948073356, -1.6255896498958635`, 
         0.011755705045849208`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01618029948073356, -1.6255896498958635`, 
         0.011755705045849208`}, {0.01618029948073356, -1.6355896498958633`, 
         0.011755705045849208`}, {0.011755664639084075`, -1.6355896498958633`,
          0.016180339887498695`}, {
         0.011755664639084075`, -1.6255896498958635`, 
         0.016180339887498695`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755664639084075`, -1.6255896498958635`, 
         0.016180339887498695`}, {0.011755664639084075`, -1.6355896498958633`,
          0.016180339887498695`}, {0.006180299480733561, -1.6355896498958633`,
          0.01902113032590282}, {0.006180299480733561, -1.6255896498958635`, 
         0.01902113032590282}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180299480733561, -1.6255896498958635`, 
         0.01902113032590282}, {0.006180299480733561, -1.6355896498958633`, 
         0.01902113032590282}, {-4.040676538818394*^-8, -1.6355896498958633`, 
         0.019999999999999747`}, {-4.040676538818394*^-8, \
-1.6255896498958635`, 0.019999999999999747`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-4.040676538818394*^-8, -1.6255896498958635`, 
         0.019999999999999747`}, {-4.040676538818394*^-8, \
-1.6355896498958633`, 
         0.019999999999999747`}, {-0.006180380294264338, -1.6355896498958633`,
          0.01902113032590282}, {-0.006180380294264338, -1.6255896498958635`, 
         0.01902113032590282}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180380294264338, -1.6255896498958635`, 
         0.01902113032590282}, {-0.006180380294264338, -1.6355896498958633`, 
         0.01902113032590282}, {-0.011755745452614852`, -1.6355896498958633`, 
         0.016180339887498695`}, {-0.011755745452614852`, \
-1.6255896498958635`, 0.016180339887498695`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755745452614852`, -1.6255896498958635`, 
         0.016180339887498695`}, {-0.011755745452614852`, \
-1.6355896498958633`, 
         0.016180339887498695`}, {-0.016180380294264336`, \
-1.6355896498958633`, 
         0.011755705045849208`}, {-0.016180380294264336`, \
-1.6255896498958635`, 0.011755705045849208`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180380294264336`, -1.6255896498958635`, 
         0.011755705045849208`}, {-0.016180380294264336`, \
-1.6355896498958633`, 
         0.011755705045849208`}, {-0.01902117073266846, -1.6355896498958633`, 
         0.006180339887498695}, {-0.01902117073266846, -1.6255896498958635`, 
         0.006180339887498695}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.01902117073266846, -1.6255896498958635`, 
         0.006180339887498695}, {-0.01902117073266846, -1.6355896498958633`, 
         0.006180339887498695}, {-0.02000004040676539, -1.6355896498958633`, \
-2.5436884207139746`*^-16}, {-0.02000004040676539, -1.6255896498958635`, \
-2.5436884207139746`*^-16}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.02000004040676539, -1.6255896498958635`, \
-2.5436884207139746`*^-16}, {-0.02000004040676539, -1.6355896498958633`, \
-2.5436884207139746`*^-16}, {-0.01902117073266846, -1.6355896498958633`, \
-0.0061803398874992034`}, {-0.01902117073266846, -1.6255896498958635`, \
-0.0061803398874992034`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01902117073266846, -1.6255896498958635`, \
-0.0061803398874992034`}, {-0.01902117073266846, -1.6355896498958633`, \
-0.0061803398874992034`}, {-0.016180380294264336`, -1.6355896498958633`, \
-0.011755705045849718`}, {-0.016180380294264336`, -1.6255896498958635`, \
-0.011755705045849718`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180380294264336`, -1.6255896498958635`, \
-0.011755705045849718`}, {-0.016180380294264336`, -1.6355896498958633`, \
-0.011755705045849718`}, {-0.011755745452614852`, -1.6355896498958633`, \
-0.0161803398874992}, {-0.011755745452614852`, -1.6255896498958635`, \
-0.0161803398874992}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755745452614852`, -1.6255896498958635`, \
-0.0161803398874992}, {-0.011755745452614852`, -1.6355896498958633`, \
-0.0161803398874992}, {-0.006180380294264338, -1.6355896498958633`, \
-0.019021130325903326`}, {-0.006180380294264338, -1.6255896498958635`, \
-0.019021130325903326`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180380294264338, -1.6255896498958635`, \
-0.019021130325903326`}, {-0.006180380294264338, -1.6355896498958633`, \
-0.019021130325903326`}, {-4.040676538818394*^-8, -1.6355896498958633`, \
-0.020000000000000254`}, {-4.040676538818394*^-8, -1.6255896498958635`, \
-0.020000000000000254`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-4.040676538818394*^-8, -1.6255896498958635`, \
-0.020000000000000254`}, {-4.040676538818394*^-8, -1.6355896498958633`, \
-0.020000000000000254`}, {
         0.006180299480733561, -1.6355896498958633`, -0.019021130325903326`}, \
{0.006180299480733561, -1.6255896498958635`, -0.019021130325903326`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.006180299480733561, -1.6255896498958635`, -0.019021130325903326`}, \
{0.006180299480733561, -1.6355896498958633`, -0.019021130325903326`}, {
         0.011755664639084075`, -1.6355896498958633`, -0.0161803398874992}, {
         0.011755664639084075`, -1.6255896498958635`, -0.0161803398874992}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.011755664639084075`, -1.6255896498958635`, -0.0161803398874992}, {
         0.011755664639084075`, -1.6355896498958633`, -0.0161803398874992}, {
         0.01618029948073356, -1.6355896498958633`, -0.011755705045849718`}, {
         0.01618029948073356, -1.6255896498958635`, \
-0.011755705045849718`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.01618029948073356, -1.6255896498958635`, -0.011755705045849718`}, {
         0.01618029948073356, -1.6355896498958633`, -0.011755705045849718`}, {
         0.019021089919137684`, -1.6355896498958633`, \
-0.0061803398874992034`}, {
         0.019021089919137684`, -1.6255896498958635`, \
-0.0061803398874992034`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019021089919137684`, -1.6255896498958635`, \
-0.0061803398874992034`}, {
         0.019021089919137684`, -1.6355896498958633`, \
-0.0061803398874992034`}, {
         0.019999959593234612`, -1.6355896498958633`, \
-2.5436884207139746`*^-16}, {
         0.019999959593234612`, -1.6255896498958635`, \
-2.5436884207139746`*^-16}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019999959593234612`, -1.6255896498958635`, \
-2.5436884207139746`*^-16}, {
         0.019999959593234612`, -1.6355896498958633`, \
-2.5436884207139746`*^-16}, {0.019021089919137684`, -1.6355896498958633`, 
         0.006180339887498695}, {0.019021089919137684`, -1.6255896498958635`, 
         0.006180339887498695}}]}}, {{{1., 0., 0.}, {0., 
       1., -8.851959610078477*^-16}, {0., 8.851959610078477*^-16, 1.}}, {0., 
       0., 1.4433913721490187`*^-15}}], {{{1., 0., 
      1.1562077050858728`*^-16}, {0., 1., 0.}, {-1.1562077050858728`*^-16, 0.,
       1.}}, {0., 0., -4.671861324748116*^-24}}], {{{0.9999999999999934, 
     1.1400445507995879`*^-7, 0.}, {-1.1400445507995879`*^-7, 
     0.9999999999999934, 0.}, {0., 0., 1.}}, {
     1.8589448449539843`*^-7, -1.532107773982716*^-14, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01902084464992685, -3.742326413697286, 
         0.006180339887496733}, {0.01902084464992685, -3.752326413697286, 
         0.006180339887496733}, {0.016180054211522726`, -3.752326413697286, 
         0.011755705045847246`}, {0.016180054211522726`, -3.742326413697286, 
         0.011755705045847246`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.016180054211522726`, -3.742326413697286, 
         0.011755705045847246`}, {0.016180054211522726`, -3.752326413697286, 
         0.011755705045847246`}, {0.011755419369873241`, -3.752326413697286, 
         0.01618033988749673}, {0.011755419369873241`, -3.742326413697286, 
         0.01618033988749673}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755419369873241`, -3.742326413697286, 
         0.01618033988749673}, {0.011755419369873241`, -3.752326413697286, 
         0.01618033988749673}, {0.006180054211522726, -3.752326413697286, 
         0.019021130325900856`}, {0.006180054211522726, -3.742326413697286, 
         0.019021130325900856`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180054211522726, -3.742326413697286, 
         0.019021130325900856`}, {0.006180054211522726, -3.752326413697286, 
         0.019021130325900856`}, {-2.8567597622283046`*^-7, \
-3.752326413697286, 
         0.019999999999997783`}, {-2.8567597622283046`*^-7, \
-3.742326413697286, 0.019999999999997783`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.8567597622283046`*^-7, -3.742326413697286, 
         0.019999999999997783`}, {-2.8567597622283046`*^-7, \
-3.752326413697286, 
         0.019999999999997783`}, {-0.006180625563475172, -3.752326413697286, 
         0.019021130325900856`}, {-0.006180625563475172, -3.742326413697286, 
         0.019021130325900856`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180625563475172, -3.742326413697286, 
         0.019021130325900856`}, {-0.006180625563475172, -3.752326413697286, 
         0.019021130325900856`}, {-0.011755990721825685`, -3.752326413697286, 
         0.01618033988749673}, {-0.011755990721825685`, -3.742326413697286, 
         0.01618033988749673}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755990721825685`, -3.742326413697286, 
         0.01618033988749673}, {-0.011755990721825685`, -3.752326413697286, 
         0.01618033988749673}, {-0.01618062556347517, -3.752326413697286, 
         0.011755705045847246`}, {-0.01618062556347517, -3.742326413697286, 
         0.011755705045847246`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618062556347517, -3.742326413697286, 
         0.011755705045847246`}, {-0.01618062556347517, -3.752326413697286, 
         0.011755705045847246`}, {-0.019021416001879295`, -3.752326413697286, 
         0.006180339887496733}, {-0.019021416001879295`, -3.742326413697286, 
         0.006180339887496733}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.019021416001879295`, -3.742326413697286, 
         0.006180339887496733}, {-0.019021416001879295`, -3.752326413697286, 
         0.006180339887496733}, {-0.020000285675976223`, -3.752326413697286, \
-2.2162498517158838`*^-15}, {-0.020000285675976223`, -3.742326413697286, \
-2.2162498517158838`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.020000285675976223`, -3.742326413697286, \
-2.2162498517158838`*^-15}, {-0.020000285675976223`, -3.752326413697286, \
-2.2162498517158838`*^-15}, {-0.019021416001879295`, -3.752326413697286, \
-0.006180339887501165}, {-0.019021416001879295`, -3.742326413697286, \
-0.006180339887501165}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.019021416001879295`, -3.742326413697286, \
-0.006180339887501165}, {-0.019021416001879295`, -3.752326413697286, \
-0.006180339887501165}, {-0.01618062556347517, -3.752326413697286, \
-0.01175570504585168}, {-0.01618062556347517, -3.742326413697286, \
-0.01175570504585168}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01618062556347517, -3.742326413697286, \
-0.01175570504585168}, {-0.01618062556347517, -3.752326413697286, \
-0.01175570504585168}, {-0.011755990721825685`, -3.752326413697286, \
-0.016180339887501165`}, {-0.011755990721825685`, -3.742326413697286, \
-0.016180339887501165`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755990721825685`, -3.742326413697286, \
-0.016180339887501165`}, {-0.011755990721825685`, -3.752326413697286, \
-0.016180339887501165`}, {-0.006180625563475172, -3.752326413697286, \
-0.01902113032590529}, {-0.006180625563475172, -3.742326413697286, \
-0.01902113032590529}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180625563475172, -3.742326413697286, \
-0.01902113032590529}, {-0.006180625563475172, -3.752326413697286, \
-0.01902113032590529}, {-2.8567597622283046`*^-7, -3.752326413697286, \
-0.020000000000002217`}, {-2.8567597622283046`*^-7, -3.742326413697286, \
-0.020000000000002217`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-2.8567597622283046`*^-7, -3.742326413697286, \
-0.020000000000002217`}, {-2.8567597622283046`*^-7, -3.752326413697286, \
-0.020000000000002217`}, {
         0.006180054211522726, -3.752326413697286, -0.01902113032590529}, {
         0.006180054211522726, -3.742326413697286, -0.01902113032590529}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.006180054211522726, -3.742326413697286, -0.01902113032590529}, {
         0.006180054211522726, -3.752326413697286, -0.01902113032590529}, {
         0.011755419369873241`, -3.752326413697286, -0.016180339887501165`}, {
         0.011755419369873241`, -3.742326413697286, \
-0.016180339887501165`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.011755419369873241`, -3.742326413697286, -0.016180339887501165`}, {
         0.011755419369873241`, -3.752326413697286, -0.016180339887501165`}, {
         0.016180054211522726`, -3.752326413697286, -0.01175570504585168}, {
         0.016180054211522726`, -3.742326413697286, -0.01175570504585168}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.016180054211522726`, -3.742326413697286, -0.01175570504585168}, {
         0.016180054211522726`, -3.752326413697286, -0.01175570504585168}, {
         0.01902084464992685, -3.752326413697286, -0.006180339887501165}, {
         0.01902084464992685, -3.742326413697286, -0.006180339887501165}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.01902084464992685, -3.742326413697286, -0.006180339887501165}, {
         0.01902084464992685, -3.752326413697286, -0.006180339887501165}, {
         0.01999971432402378, -3.752326413697286, -2.2162498517158838`*^-15}, \
{0.01999971432402378, -3.742326413697286, -2.2162498517158838`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.01999971432402378, -3.742326413697286, -2.2162498517158838`*^-15}, \
{0.01999971432402378, -3.752326413697286, -2.2162498517158838`*^-15}, {
         0.01902084464992685, -3.752326413697286, 0.006180339887496733}, {
         0.01902084464992685, -3.742326413697286, 
         0.006180339887496733}}]}}, {{{1., 0., 0.}, {0., 
       1., -1.7655977584953862`*^-15}, {0., 1.7655977584953862`*^-15, 1.}}, {
       0., 0., 6.616271116374482*^-15}}], {{{1., 0., 
      1.1655883066232412`*^-15}, {0., 1., 0.}, {-1.1655883066232412`*^-15, 0.,
       1.}}, {0., 0., -3.32980577553471*^-22}}], {{{0.9999999999999913, 
     1.3170251724369087`*^-7, 0.}, {-1.3170251724369087`*^-7, 
     0.9999999999999913, 0.}, {0., 0., 1.}}, {
     4.935323216177026*^-7, -7.016609515630989*^-14, 0.}}], 
   GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019020582133342536`, -6.1086087103681015`, 
         0.00618033988749444}, {0.019020582133342536`, -6.118608710368101, 
         0.00618033988749444}, {0.01617979169493841, -6.118608710368101, 
         0.011755705045844955`}, {0.01617979169493841, -6.1086087103681015`, 
         0.011755705045844955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01617979169493841, -6.1086087103681015`, 
         0.011755705045844955`}, {0.01617979169493841, -6.118608710368101, 
         0.011755705045844955`}, {0.011755156853288927`, -6.118608710368101, 
         0.016180339887494437`}, {0.011755156853288927`, -6.1086087103681015`,
          0.016180339887494437`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755156853288927`, -6.1086087103681015`, 
         0.016180339887494437`}, {0.011755156853288927`, -6.118608710368101, 
         0.016180339887494437`}, {0.006179791694938413, -6.118608710368101, 
         0.019021130325898562`}, {0.006179791694938413, -6.1086087103681015`, 
         0.019021130325898562`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006179791694938413, -6.1086087103681015`, 
         0.019021130325898562`}, {0.006179791694938413, -6.118608710368101, 
         0.019021130325898562`}, {-5.481925605362881*^-7, -6.118608710368101, 
         0.01999999999999549}, {-5.481925605362881*^-7, -6.1086087103681015`, 
         0.01999999999999549}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-5.481925605362881*^-7, -6.1086087103681015`, 
         0.01999999999999549}, {-5.481925605362881*^-7, -6.118608710368101, 
         0.01999999999999549}, {-0.006180888080059486, -6.118608710368101, 
         0.019021130325898562`}, {-0.006180888080059486, -6.1086087103681015`,
          0.019021130325898562`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180888080059486, -6.1086087103681015`, 
         0.019021130325898562`}, {-0.006180888080059486, -6.118608710368101, 
         0.019021130325898562`}, {-0.01175625323841, -6.118608710368101, 
         0.016180339887494437`}, {-0.01175625323841, -6.1086087103681015`, 
         0.016180339887494437`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01175625323841, -6.1086087103681015`, 
         0.016180339887494437`}, {-0.01175625323841, -6.118608710368101, 
         0.016180339887494437`}, {-0.016180888080059484`, -6.118608710368101, 
         0.011755705045844955`}, {-0.016180888080059484`, \
-6.1086087103681015`, 0.011755705045844955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180888080059484`, -6.1086087103681015`, 
         0.011755705045844955`}, {-0.016180888080059484`, -6.118608710368101, 
         0.011755705045844955`}, {-0.01902167851846361, -6.118608710368101, 
         0.00618033988749444}, {-0.01902167851846361, -6.1086087103681015`, 
         0.00618033988749444}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.01902167851846361, -6.1086087103681015`, 
         0.00618033988749444}, {-0.01902167851846361, -6.118608710368101, 
         0.00618033988749444}, {-0.020000548192560537`, -6.118608710368101, \
-4.50898088422439*^-15}, {-0.020000548192560537`, -6.1086087103681015`, \
-4.50898088422439*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.020000548192560537`, -6.1086087103681015`, \
-4.50898088422439*^-15}, {-0.020000548192560537`, -6.118608710368101, \
-4.50898088422439*^-15}, {-0.01902167851846361, -6.118608710368101, \
-0.006180339887503459}, {-0.01902167851846361, -6.1086087103681015`, \
-0.006180339887503459}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01902167851846361, -6.1086087103681015`, \
-0.006180339887503459}, {-0.01902167851846361, -6.118608710368101, \
-0.006180339887503459}, {-0.016180888080059484`, -6.118608710368101, \
-0.011755705045853972`}, {-0.016180888080059484`, -6.1086087103681015`, \
-0.011755705045853972`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180888080059484`, -6.1086087103681015`, \
-0.011755705045853972`}, {-0.016180888080059484`, -6.118608710368101, \
-0.011755705045853972`}, {-0.01175625323841, -6.118608710368101, \
-0.016180339887503458`}, {-0.01175625323841, -6.1086087103681015`, \
-0.016180339887503458`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01175625323841, -6.1086087103681015`, \
-0.016180339887503458`}, {-0.01175625323841, -6.118608710368101, \
-0.016180339887503458`}, {-0.006180888080059486, -6.118608710368101, \
-0.019021130325907583`}, {-0.006180888080059486, -6.1086087103681015`, \
-0.019021130325907583`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180888080059486, -6.1086087103681015`, \
-0.019021130325907583`}, {-0.006180888080059486, -6.118608710368101, \
-0.019021130325907583`}, {-5.481925605362881*^-7, -6.118608710368101, \
-0.02000000000000451}, {-5.481925605362881*^-7, -6.1086087103681015`, \
-0.02000000000000451}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-5.481925605362881*^-7, -6.1086087103681015`, \
-0.02000000000000451}, {-5.481925605362881*^-7, -6.118608710368101, \
-0.02000000000000451}, {
         0.006179791694938413, -6.118608710368101, -0.019021130325907583`}, {
         0.006179791694938413, -6.1086087103681015`, \
-0.019021130325907583`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.006179791694938413, -6.1086087103681015`, -0.019021130325907583`}, \
{0.006179791694938413, -6.118608710368101, -0.019021130325907583`}, {
         0.011755156853288927`, -6.118608710368101, -0.016180339887503458`}, {
         0.011755156853288927`, -6.1086087103681015`, \
-0.016180339887503458`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.011755156853288927`, -6.1086087103681015`, \
-0.016180339887503458`}, {
         0.011755156853288927`, -6.118608710368101, -0.016180339887503458`}, {
         0.01617979169493841, -6.118608710368101, -0.011755705045853972`}, {
         0.01617979169493841, -6.1086087103681015`, \
-0.011755705045853972`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.01617979169493841, -6.1086087103681015`, -0.011755705045853972`}, {
         0.01617979169493841, -6.118608710368101, -0.011755705045853972`}, {
         0.019020582133342536`, -6.118608710368101, -0.006180339887503459}, {
         0.019020582133342536`, -6.1086087103681015`, \
-0.006180339887503459}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019020582133342536`, -6.1086087103681015`, -0.006180339887503459}, \
{0.019020582133342536`, -6.118608710368101, -0.006180339887503459}, {
         0.019999451807439464`, -6.118608710368101, -4.50898088422439*^-15}, {
         0.019999451807439464`, -6.1086087103681015`, \
-4.50898088422439*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019999451807439464`, -6.1086087103681015`, \
-4.50898088422439*^-15}, {
         0.019999451807439464`, -6.118608710368101, -4.50898088422439*^-15}, {
         0.019020582133342536`, -6.118608710368101, 0.00618033988749444}, {
         0.019020582133342536`, -6.1086087103681015`, 
         0.00618033988749444}}]}}, {{{1., 0., 0.}, {0., 1., 
       2.612664429387322*^-15}, {0., -2.612664429387322*^-15, 1.}}, {0., 
       0., -1.5972808012771235`*^-14}}], {{{1., 0., 
      1.1827147089603897`*^-14}, {0., 1., 0.}, {-1.1827147089603897`*^-14, 0.,
       1.}}, {0., 0., -6.483554046769877*^-21}}], {{{0.9999999999999925, 
     1.224627265564809*^-7, 0.}, {-1.224627265564809*^-7, 0.9999999999999925, 
     0.}, {0., 0., 1.}}, {7.486891917711244*^-7, -1.1368683772161603`*^-13, 
     0.}}], GeometricTransformation3DBox[
    GeometricTransformation3DBox[GeometricTransformation3DBox[{
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.019021016989948836`, -8.209798874777498, 
         0.006180339887494441}, {0.019021016989948836`, -8.2197988747775, 
         0.006180339887494441}, {0.01618022655154471, -8.2197988747775, 
         0.011755705045844955`}, {0.01618022655154471, -8.209798874777498, 
         0.011755705045844955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.01618022655154471, -8.209798874777498, 
         0.011755705045844955`}, {0.01618022655154471, -8.2197988747775, 
         0.011755705045844955`}, {0.011755591709895225`, -8.2197988747775, 
         0.01618033988749444}, {0.011755591709895225`, -8.209798874777498, 
         0.01618033988749444}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{0.011755591709895225`, -8.209798874777498, 
         0.01618033988749444}, {0.011755591709895225`, -8.2197988747775, 
         0.01618033988749444}, {0.006180226551544711, -8.2197988747775, 
         0.019021130325898566`}, {0.006180226551544711, -8.209798874777498, 
         0.019021130325898566`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{0.006180226551544711, -8.209798874777498, 
         0.019021130325898566`}, {0.006180226551544711, -8.2197988747775, 
         0.019021130325898566`}, {-1.1333595423787333`*^-7, -8.2197988747775, 
         0.019999999999995494`}, {-1.1333595423787333`*^-7, \
-8.209798874777498, 0.019999999999995494`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.1333595423787333`*^-7, -8.209798874777498, 
         0.019999999999995494`}, {-1.1333595423787333`*^-7, -8.2197988747775, 
         0.019999999999995494`}, {-0.006180453223453187, -8.2197988747775, 
         0.019021130325898566`}, {-0.006180453223453187, -8.209798874777498, 
         0.019021130325898566`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.006180453223453187, -8.209798874777498, 
         0.019021130325898566`}, {-0.006180453223453187, -8.2197988747775, 
         0.019021130325898566`}, {-0.011755818381803701`, -8.2197988747775, 
         0.01618033988749444}, {-0.011755818381803701`, -8.209798874777498, 
         0.01618033988749444}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755818381803701`, -8.209798874777498, 
         0.01618033988749444}, {-0.011755818381803701`, -8.2197988747775, 
         0.01618033988749444}, {-0.016180453223453184`, -8.2197988747775, 
         0.011755705045844955`}, {-0.016180453223453184`, -8.209798874777498, 
         0.011755705045844955`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180453223453184`, -8.209798874777498, 
         0.011755705045844955`}, {-0.016180453223453184`, -8.2197988747775, 
         0.011755705045844955`}, {-0.01902124366185731, -8.2197988747775, 
         0.006180339887494441}, {-0.01902124366185731, -8.209798874777498, 
         0.006180339887494441}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.01902124366185731, -8.209798874777498, 
         0.006180339887494441}, {-0.01902124366185731, -8.2197988747775, 
         0.006180339887494441}, {-0.020000113335954237`, -8.2197988747775, \
-4.5081353053986595`*^-15}, {-0.020000113335954237`, -8.209798874777498, \
-4.5081353053986595`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.020000113335954237`, -8.209798874777498, \
-4.5081353053986595`*^-15}, {-0.020000113335954237`, -8.2197988747775, \
-4.5081353053986595`*^-15}, {-0.01902124366185731, -8.2197988747775, \
-0.006180339887503458}, {-0.01902124366185731, -8.209798874777498, \
-0.006180339887503458}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.01902124366185731, -8.209798874777498, \
-0.006180339887503458}, {-0.01902124366185731, -8.2197988747775, \
-0.006180339887503458}, {-0.016180453223453184`, -8.2197988747775, \
-0.011755705045853972`}, {-0.016180453223453184`, -8.209798874777498, \
-0.011755705045853972`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.016180453223453184`, -8.209798874777498, \
-0.011755705045853972`}, {-0.016180453223453184`, -8.2197988747775, \
-0.011755705045853972`}, {-0.011755818381803701`, -8.2197988747775, \
-0.016180339887503455`}, {-0.011755818381803701`, -8.209798874777498, \
-0.016180339887503455`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{-0.011755818381803701`, -8.209798874777498, \
-0.016180339887503455`}, {-0.011755818381803701`, -8.2197988747775, \
-0.016180339887503455`}, {-0.006180453223453187, -8.2197988747775, \
-0.01902113032590758}, {-0.006180453223453187, -8.209798874777498, \
-0.01902113032590758}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-0.006180453223453187, -8.209798874777498, \
-0.01902113032590758}, {-0.006180453223453187, -8.2197988747775, \
-0.01902113032590758}, {-1.1333595423787333`*^-7, -8.2197988747775, \
-0.020000000000004507`}, {-1.1333595423787333`*^-7, -8.209798874777498, \
-0.020000000000004507`}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{-1.1333595423787333`*^-7, -8.209798874777498, \
-0.020000000000004507`}, {-1.1333595423787333`*^-7, -8.2197988747775, \
-0.020000000000004507`}, {
         0.006180226551544711, -8.2197988747775, -0.01902113032590758}, {
         0.006180226551544711, -8.209798874777498, -0.01902113032590758}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.006180226551544711, -8.209798874777498, -0.01902113032590758}, {
         0.006180226551544711, -8.2197988747775, -0.01902113032590758}, {
         0.011755591709895225`, -8.2197988747775, -0.016180339887503455`}, {
         0.011755591709895225`, -8.209798874777498, \
-0.016180339887503455`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.011755591709895225`, -8.209798874777498, -0.016180339887503455`}, {
         0.011755591709895225`, -8.2197988747775, -0.016180339887503455`}, {
         0.01618022655154471, -8.2197988747775, -0.011755705045853972`}, {
         0.01618022655154471, -8.209798874777498, -0.011755705045853972`}}]}, 
       {RGBColor[0, 0, 1], 
        Polygon3DBox[{{
         0.01618022655154471, -8.209798874777498, -0.011755705045853972`}, {
         0.01618022655154471, -8.2197988747775, -0.011755705045853972`}, {
         0.019021016989948836`, -8.2197988747775, -0.006180339887503458}, {
         0.019021016989948836`, -8.209798874777498, -0.006180339887503458}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019021016989948836`, -8.209798874777498, -0.006180339887503458}, {
         0.019021016989948836`, -8.2197988747775, -0.006180339887503458}, {
         0.019999886664045764`, -8.2197988747775, -4.5081353053986595`*^-15}, \
{0.019999886664045764`, -8.209798874777498, -4.5081353053986595`*^-15}}]}, 
       {RGBColor[1, 0, 0], 
        Polygon3DBox[{{
         0.019999886664045764`, -8.209798874777498, \
-4.5081353053986595`*^-15}, {
         0.019999886664045764`, -8.2197988747775, -4.5081353053986595`*^-15}, \
{0.019021016989948836`, -8.2197988747775, 0.006180339887494441}, {
         0.019021016989948836`, -8.209798874777498, 
         0.006180339887494441}}]}}, {{{1., 0., 0.}, {0., 1., 
       4.0940898372726366`*^-16}, {0., -4.0940898372726366`*^-16, 1.}}, {0., 
       0., -3.363212458846525*^-15}}], {{{1., 0., 4.048441960765067*^-15}, {
      0., 1., 0.}, {-4.048441960765067*^-15, 0., 1.}}, {0., 
      0., -4.588340327336891*^-22}}], {{{
     0.9999999999286662, -0.000011944352135605818`, 0.}, {
     0.000011944352135605818`, 0.9999999999286662, 0.}, {0., 0., 
     1.}}, {-0.00009812045048352898, -5.846398920539286*^-10, 0.}}]},
  AutomaticImageSize->True,
  ImageSize->{158.86743592926766`, 832.7805469071428},
  ViewPoint->{3.3603231317180025`, 0.3782936646909637, 0.12297297953450688`},
  ViewVertical->{2.7808484026590192`, 0.867621251433198, 
   0.141846601641186}]], "Output",
 CellChangeTimes->{
  3.5111617395012894`*^9, {3.511228226351862*^9, 3.511228247177899*^9}, 
   3.511228383444138*^9, 3.511228597258114*^9, 3.511228747564378*^9, 
   3.5112287993252687`*^9, 3.5112289130494685`*^9, {3.511228945216725*^9, 
   3.511228955434743*^9}, 3.5112292060803833`*^9, {3.5112293442498255`*^9, 
   3.51122939789832*^9}, 3.5112296699939976`*^9, 3.511229845541106*^9, {
   3.5112299408728733`*^9, 3.5112299460676827`*^9}, {3.5112300007925787`*^9, 
   3.5112300283266273`*^9}, {3.5112303683760242`*^9, 3.511230413304103*^9}, {
   3.5112305166542845`*^9, 3.5112305897248135`*^9}, 3.511231829458991*^9, 
   3.5112323163736506`*^9, 3.511232379912562*^9, 3.511232425199442*^9, 
   3.5112324586459007`*^9, 3.511232492997161*^9, 3.511232537472839*^9, 
   3.511232581215316*^9, 3.5112326569066486`*^9, 3.5112328454329796`*^9, 
   3.5112329079110894`*^9, 3.5112332290844536`*^9, 3.511329534437514*^9, 
   3.511329918135791*^9, {3.511330019067968*^9, 3.511330036477598*^9}, {
   3.5113300876612883`*^9, 3.511330164990624*^9}, 3.511330270368809*^9, 
   3.511330439254706*^9, 3.511330487630391*^9, 3.5113306319774446`*^9, 
   3.5113329875503817`*^9, 3.5114066981539755`*^9, 3.5114067825033236`*^9, 
   3.5114069498136177`*^9, {3.511407033226964*^9, 3.5114070948626723`*^9}, 
   3.51140717883762*^9, {3.511431565876172*^9, 3.511431582537001*^9}, 
   3.511490059584117*^9, 3.5114943360824537`*^9, 3.5114960912229385`*^9, 
   3.5123557887907486`*^9, {3.512355920904023*^9, 3.5123559369096513`*^9}, 
   3.51235600480097*^9, 3.512710814199548*^9, {3.512710909468915*^9, 
   3.512710934569359*^9}, 3.5127123264782057`*^9, 3.512712518342942*^9, 
   3.512712612567108*^9, {3.512730656244234*^9, 3.512730713636735*^9}, 
   3.5127329316658335`*^9, {3.51280385695082*^9, 3.5128038620988293`*^9}, {
   3.514168787548131*^9, 3.514168803725359*^9}, 3.5141697830794797`*^9, 
   3.5145117420593476`*^9, 3.514512268341872*^9, 3.5145124154345303`*^9, 
   3.5188352831627235`*^9, 3.518835496383898*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer Function Plot", "Section",
 CellChangeTimes->{{3.510629600074376*^9, 3.5106296028355813`*^9}, {
  3.510922302451619*^9, 3.5109223035016794`*^9}}],

Cell[CellGroupData[{

Cell["Frequency List", "Subsection",
 CellChangeTimes->{{3.505457309098371*^9, 3.5054573134988823`*^9}, {
  3.505457392369238*^9, 3.505457393435096*^9}, {3.507903438769166*^9, 
  3.507903442019352*^9}, {3.5079450761978855`*^9, 3.5079450876015053`*^9}, {
  3.507945118302359*^9, 3.507945140813199*^9}, {3.5109227629829597`*^9, 
  3.510922763595995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fmin", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], " ", "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"minimum", " ", "frequency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmax", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "1"}]], "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"maximum", " ", "freqnency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ngrid", "=", "1001"}], ";", 
  RowBox[{"(*", 
   RowBox[{"number", " ", "of", " ", "grids"}], "*)"}], 
  "\[IndentingNewLine]"}]}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727491881474*^9}, {
   3.514512526272725*^9, 3.514512533885538*^9}, {3.514512755015927*^9, 
   3.5145127581671324`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"freq", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"imin", ",", "imax", ",", "dgrid"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"imin", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmin"}], "]"}]}], ";", 
       RowBox[{"imax", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmax"}], "]"}]}], ";", 
       RowBox[{"dgrid", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"imax", "-", "imin"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"ngrid", "-", "1"}], ")"}]}]}], ";", "\n", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"10", "^", "i"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "imin", ",", "imax", ",", "dgrid"}], "}"}]}], 
        "]"}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Frequency", " ", "list"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727540428759*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Actuator Definition", "Subsection",
 CellChangeTimes->{{3.5109654612318583`*^9, 3.510965462635861*^9}, {
  3.5109690024068785`*^9, 3.510969004138481*^9}}],

Cell[CellGroupData[{

Cell["Actuator Name List", "Subsubsection",
 CellChangeTimes->{{3.5113307936249285`*^9, 3.5113308073529525`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"allacts", "=", 
    RowBox[{"{", 
     RowBox[{
     "aTM1", ",", "aTM2", ",", "aTM3", ",", "aTM4", ",", "aF01", ",", "aF02", 
      ",", "aF03"}], "}"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109727782843103`*^9, 3.5109728075967617`*^9}, 
   3.51133080025494*^9, {3.5113912910255685`*^9, 3.5113912956275764`*^9}, {
   3.5114124581364727`*^9, 3.511412463674483*^9}, {3.5114130712487497`*^9, 
   3.5114130854447746`*^9}, 3.5127114692567*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Making Actuator List", "Subsubsection",
 CellChangeTimes->{{3.5113308136397634`*^9, 3.511330818600572*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"actuatorlist", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"(*", "TM", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posTM", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "actuated", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posTMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "actuated",
             " ", "body"}], "*)"}], "\[IndentingNewLine]", "posRM", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "recoil", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posRMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "recoil", 
            " ", "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"dirTMa", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], 
         RowBox[{"(*", 
          RowBox[{
          "working", " ", "direction", " ", "defined", " ", "at", " ", 
           "recoil", " ", "body"}], "*)"}], "\[IndentingNewLine]", "}"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "4"}], "}"}]}], "\[IndentingNewLine]", "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"(*", "F0", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"posF0", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "actuated", " ", 
            "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "actuated",
             " ", "body"}], "*)"}], "\[IndentingNewLine]", "posg", ",", 
          RowBox[{"(*", 
           RowBox[{
           "coordinate", " ", "list", " ", "of", " ", "recoil", " ", "body"}],
            "*)"}], "\[IndentingNewLine]", 
          RowBox[{"posF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}], ",", 
          RowBox[{"(*", 
           RowBox[{
           "position", " ", "of", " ", "actuator", " ", "at", " ", "recoil", 
            " ", "body"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"dirF0a", "[", 
           RowBox[{"[", "n", "]"}], "]"}]}], 
         RowBox[{"(*", 
          RowBox[{
          "working", " ", "direction", " ", "defined", " ", "at", " ", 
           "recoil", " ", "body"}], "*)"}], "\[IndentingNewLine]", "}"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"n", ",", "3"}], "}"}]}], "\[IndentingNewLine]", "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5109654818394947`*^9, 3.510965501292729*^9}, {
   3.510967724749034*^9, 3.510967731956247*^9}, {3.510969081296217*^9, 
   3.5109691312787046`*^9}, {3.5109691764251842`*^9, 3.510969496490946*^9}, {
   3.510969534071412*^9, 3.5109695354442143`*^9}, {3.5109728140863733`*^9, 
   3.510972844880827*^9}, 3.510974608651125*^9, {3.511003646932313*^9, 
   3.5110036534843245`*^9}, {3.5111471459271812`*^9, 
   3.5111471546631966`*^9}, {3.5111473903484106`*^9, 3.511147422125666*^9}, {
   3.5111552347923946`*^9, 3.5111552422648077`*^9}, {3.5113307607556705`*^9, 
   3.511330775575697*^9}, {3.5113321606397295`*^9, 3.511332172963751*^9}, {
   3.5113913047691927`*^9, 3.5113913416788573`*^9}, {3.5114131119804215`*^9, 
   3.5114131610581074`*^9}, 3.5127114769319134`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer Function Plot", "Subsection",
 CellChangeTimes->{{3.5106327360154905`*^9, 3.510632742271102*^9}, {
  3.5109229122064953`*^9, 3.5109229133585615`*^9}, {3.510975022395052*^9, 
  3.510975046309894*^9}, {3.511431088725732*^9, 3.511431089770934*^9}}],

Cell[CellGroupData[{

Cell["Usage Notes", "Subsubsection",
 CellChangeTimes->{{3.512731063640951*^9, 3.5127310662461557`*^9}}],

Cell[BoxData[
 RowBox[{"?", "tfplot"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127276236861057`*^9, 3.5127276254801083`*^9}, 
   3.5127278088272305`*^9, 3.5127285744453754`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplot[{param},{var},freqlist] calculates transfer functions \
from input parameters' displacement to output variables' displacement.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.512730831884943*^9},
 CellTags->"Info3512763231-3783408"],

Cell[BoxData[
 RowBox[{"?", "tfplotf"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5127277012026415`*^9, 3.512727705445849*^9}, 
   3.5127278088272305`*^9, 3.5127285744609756`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplot[{varin},{varout},freq] calculates transfer functions \
from force exerted to the input variables, to output variables' displacement.\
\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5127308323061438`*^9},
 CellTags->"Info3512763232-9783139"],

Cell[BoxData[
 RowBox[{"?", "tfplota"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.512727708347454*^9, 3.512727710375458*^9}, 
   3.5127278088272305`*^9, 3.5127285744609756`*^9}],

Cell[BoxData[
 StyleBox["\<\"tfplota[{act},{var},freqlist] shows transfer functions from \
input actuator force to output variables' displacement. Input can be a linear \
combination of actuators.\"\>", "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.5127308328365445`*^9},
 CellTags->"Info3512763232-5043775"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plots", "Subsubsection",
 CellChangeTimes->{{3.5127310719245653`*^9, 3.512731072782567*^9}}],

Cell[CellGroupData[{

Cell["Transfer function from disp. to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511418345274813*^9, 3.511418367785653*^9}}],

Cell[BoxData[
 RowBox[{"tfplot", "[", 
  RowBox[{
   RowBox[{"{", "yawg", "}"}], ",", 
   RowBox[{"{", "yawTM", "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.510957748603794*^9, 3.5109577777446456`*^9}, {
   3.510957947894144*^9, 3.510957950312149*^9}, 3.5109588754873734`*^9, {
   3.510960251768591*^9, 3.5109602568386*^9}, {3.5109644688037157`*^9, 
   3.5109645325454273`*^9}, {3.5109646318084016`*^9, 3.510964636956411*^9}, {
   3.5109652306946535`*^9, 3.510965232036256*^9}, {3.5109653621872845`*^9, 
   3.510965374776507*^9}, {3.510965421685789*^9, 3.510965427161399*^9}, {
   3.5109750765583467`*^9, 3.5109750793195515`*^9}, {3.5109818646568904`*^9, 
   3.5109818950301437`*^9}, {3.5109829019735146`*^9, 
   3.5109829028627157`*^9}, {3.511147957815007*^9, 3.511147970092229*^9}, {
   3.5111480189515142`*^9, 3.5111480302771344`*^9}, {3.511152738053403*^9, 
   3.5111527568982363`*^9}, {3.5111614206837378`*^9, 
   3.5111614428905745`*^9}, {3.511232181917014*^9, 3.5112321830402164`*^9}, {
   3.5112326734114776`*^9, 3.5112326900723066`*^9}, {3.5112327680568438`*^9, 
   3.5112327702252474`*^9}, 3.51123286263981*^9, {3.5112329654595904`*^9, 
   3.5112329723704023`*^9}, {3.51123301048127*^9, 3.51123301626888*^9}, {
   3.511233061602559*^9, 3.511233087561005*^9}, {3.511233247133685*^9, 
   3.511233263388914*^9}, {3.511330838459407*^9, 3.511330842000613*^9}, {
   3.5113312692229633`*^9, 3.5113312709701667`*^9}, {3.5113904840985513`*^9, 
   3.511390509822996*^9}, {3.511414980348903*^9, 3.5114149810821047`*^9}, 
   3.511418367785653*^9, {3.512728004420374*^9, 3.5127280098959837`*^9}, {
   3.512733378388218*^9, 3.512733383676627*^9}, {3.5127354019145722`*^9, 
   3.512735408201383*^9}, {3.5145126445521326`*^9, 3.51451264860814*^9}, {
   3.514512709089446*^9, 3.5145127106026487`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwl2nc41f8XAHBce969ZO8WiUrFoSXR0hIqoShSksY3pZKKpGhqSGSXLUnl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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{-6.907755278982136, -12.6596641098266},
     BaseStyle->{FontSize -> Scaled[0.04]},
     CoordinatesToolOptions:>{"DisplayFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& )},
     DisplayFunction:>$DisplayFunction,
     FormatType->TraditionalForm,
     Frame->True,
     FrameLabel->{
       FormBox["\"Frequency [Hz]\"", TraditionalForm]},
     FrameTicks->{{{{-11.512925464970229`, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-9.210340371976182, 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
          FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
          FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0, 
          FormBox["1", TraditionalForm]}, {2.302585092994046, 
          FormBox["10", TraditionalForm]}, {-10.819778284410283`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-10.414313176302118`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-10.126631103850338`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.903487552536127, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.721165995742174, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.567015315914915, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.433483923290392, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.315700887634009, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-8.517193191416238, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-8.111728083308073, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.824046010856292, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.600902459542082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.418580902748127, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.264430222920869, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.1308988302963465`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.013115794639964, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.214608098422191, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.809142990314028, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.521460917862246, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.298317366548036, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.115995809754082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.961845129926823, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8283137373023015`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.710530701645918, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.912023005428146, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.506557897319982, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.2188758248682006`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.995732273553991, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.8134107167600364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.659260036932778, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5257286443082556`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.4079456086518722`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.203972804325936, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5108256237659905, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3566749439387323, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2231435513142097, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.10536051565782628`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.0986122886681098`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3862943611198906`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.791759469228055, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9459101490553132`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.0794415416798357`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.1972245773362196`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-11.512925464970229`, 
          FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
          FormBox["\"\"", TraditionalForm]}, {-6.907755278982137, 
          FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
          FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
          FormBox["\"\"", TraditionalForm]}, {0, 
          FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
          FormBox["\"\"", TraditionalForm]}, {-10.819778284410283`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-10.414313176302118`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-10.126631103850338`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.903487552536127, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.721165995742174, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.567015315914915, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.433483923290392, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-9.315700887634009, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-8.517193191416238, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-8.111728083308073, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.824046010856292, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.600902459542082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.418580902748127, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.264430222920869, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.1308988302963465`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-7.013115794639964, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-6.214608098422191, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.809142990314028, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.521460917862246, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.298317366548036, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.115995809754082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.961845129926823, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8283137373023015`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.710530701645918, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.912023005428146, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.506557897319982, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.2188758248682006`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.995732273553991, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.8134107167600364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.659260036932778, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5257286443082556`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.4079456086518722`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.203972804325936, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5108256237659905, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.3566749439387323, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2231435513142097, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.10536051565782628`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.0986122886681098`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3862943611198906`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.791759469228055, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9459101490553132`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.0794415416798357`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.1972245773362196`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}}, {{{-6.907755278982137, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.001\"", 0.001, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-6.214608098422191, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.002\"", 0.002, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-5.298317366548036, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.005\"", 0.005, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-4.605170185988092, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-3.912023005428146, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.020\"", 0.02, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-2.995732273553991, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-2.302585092994046, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-1.6094379124341003`, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.200\"", 0.2, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-0.6931471805599453, 
          FormBox[
           TagBox[
            InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
            NumberForm[#, {
              DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
           TraditionalForm]}, {-5.809142990314028, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.521460917862246, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.115995809754082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.961845129926823, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8283137373023015`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.710530701645918, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.506557897319982, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.2188758248682006`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.8134107167600364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.6592600369327783`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5257286443082556`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.4079456086518722`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2039728043259361`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}, {{-6.907755278982137, 
          FormBox["\"\"", TraditionalForm]}, {-6.214608098422191, 
          FormBox["\"\"", TraditionalForm]}, {-5.298317366548036, 
          FormBox["\"\"", TraditionalForm]}, {-4.605170185988092, 
          FormBox["\"\"", TraditionalForm]}, {-3.912023005428146, 
          FormBox["\"\"", TraditionalForm]}, {-2.995732273553991, 
          FormBox["\"\"", TraditionalForm]}, {-2.302585092994046, 
          FormBox["\"\"", TraditionalForm]}, {-1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm]}, {-0.6931471805599453, 
          FormBox["\"\"", TraditionalForm]}, {-5.809142990314028, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.521460917862246, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.115995809754082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.961845129926823, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8283137373023015`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.710530701645918, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.506557897319982, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.2188758248682006`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.8134107167600364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.6592600369327783`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5257286443082556`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.4079456086518722`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.2039728043259361`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}}},
     GridLines->{{-6.907755278982137, -6.214608098422191, -5.298317366548036, \
-4.605170185988092, -3.912023005428146, -2.995732273553991, \
-2.302585092994046, -1.6094379124341003`, -0.6931471805599453, \
-5.809142990314028, -5.521460917862246, -5.115995809754082, \
-4.961845129926823, -4.8283137373023015`, -4.710530701645918, \
-3.506557897319982, -3.2188758248682006`, -2.8134107167600364`, \
-2.6592600369327783`, -2.5257286443082556`, -2.4079456086518722`, \
-1.2039728043259361`, -0.916290731874155}, {-11.512925464970229`, \
-9.210340371976182, -6.907755278982137, -4.605170185988091, \
-2.3025850929940455`, 0, 
        2.302585092994046, -10.819778284410283`, -10.414313176302118`, \
-10.126631103850338`, -9.903487552536127, -9.721165995742174, \
-9.567015315914915, -9.433483923290392, -9.315700887634009, \
-8.517193191416238, -8.111728083308073, -7.824046010856292, \
-7.600902459542082, -7.418580902748127, -7.264430222920869, \
-7.1308988302963465`, -7.013115794639964, -6.214608098422191, \
-5.809142990314028, -5.521460917862246, -5.298317366548036, \
-5.115995809754082, -4.961845129926823, -4.8283137373023015`, \
-4.710530701645918, -3.912023005428146, -3.506557897319982, \
-3.2188758248682006`, -2.995732273553991, -2.8134107167600364`, \
-2.659260036932778, -2.5257286443082556`, -2.4079456086518722`, \
-1.6094379124341003`, -1.203972804325936, -0.916290731874155, \
-0.6931471805599453, -0.5108256237659905, -0.3566749439387323, \
-0.2231435513142097, -0.10536051565782628`, 0.6931471805599453, 
        1.0986122886681098`, 1.3862943611198906`, 1.6094379124341003`, 
        1.791759469228055, 1.9459101490553132`, 2.0794415416798357`, 
        2.1972245773362196`}},
     ImageSize->600,
     Method->{},
     PlotRange->{{-6.907755278982136, -2.3025850929940455`}, \
{-12.6596641098266, 2.6691946358760714`}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]},
     Ticks->{{{-6.907755278982137, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.001\"", 0.001, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-6.214608098422191, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.002\"", 0.002, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-5.298317366548036, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.005\"", 0.005, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-4.605170185988092, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-3.912023005428146, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.020\"", 0.02, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-2.995732273553991, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.050\"", 0.05, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-2.302585092994046, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-1.6094379124341003`, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.200\"", 0.2, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-0.6931471805599453, 
         FormBox[
          TagBox[
           InterpretationBox["\"0.500\"", 0.5, AutoDelete -> True], 
           NumberForm[#, {
             DirectedInfinity[1], 3}, NumberPadding -> {"", "0"}]& ], 
          TraditionalForm]}, {-5.809142990314028, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.521460917862246, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.115995809754082, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.961845129926823, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.8283137373023015`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.710530701645918, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-3.506557897319982, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-3.2188758248682006`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.8134107167600364`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.6592600369327783`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.5257286443082556`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.4079456086518722`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-1.2039728043259361`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.916290731874155, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}}, {{-11.512925464970229`, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm]}, {-9.210340371976182, 
         FormBox[
          TemplateBox[{"10", 
            RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox],
           TraditionalForm]}, {-6.907755278982137, 
         FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
         FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
         FormBox["0.1`", TraditionalForm]}, {0, 
         FormBox["1", TraditionalForm]}, {2.302585092994046, 
         FormBox["10", TraditionalForm]}, {-10.819778284410283`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-10.414313176302118`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-10.126631103850338`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-9.903487552536127, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-9.721165995742174, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-9.567015315914915, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-9.433483923290392, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-9.315700887634009, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-8.517193191416238, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-8.111728083308073, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.824046010856292, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.600902459542082, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.418580902748127, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.264430222920869, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.1308988302963465`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-7.013115794639964, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-6.214608098422191, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.809142990314028, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.521460917862246, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.298317366548036, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-5.115995809754082, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.961845129926823, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.8283137373023015`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-4.710530701645918, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-3.912023005428146, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-3.506557897319982, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-3.2188758248682006`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.995732273553991, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.8134107167600364`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.659260036932778, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.5257286443082556`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-2.4079456086518722`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-1.6094379124341003`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-1.203972804325936, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.916290731874155, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.6931471805599453, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.5108256237659905, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.3566749439387323, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.2231435513142097, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {-0.10536051565782628`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {0.6931471805599453, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.0986122886681098`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.3862943611198906`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.6094379124341003`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.791759469228055, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {1.9459101490553132`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {2.0794415416798357`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}, {2.1972245773362196`, 
         FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
          Thickness[0.001]}}}}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], GraphicsGroupBox[{
     {GrayLevel[0], RectangleBox[{0.35, 0.3}, {0.78, 0.38}]}, 
     {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.001]}], 
      GraphicsGroupBox[{RectangleBox[{0.35, 0.3}, {0.78, 0.38}], InsetBox[
         GraphicsBox[{{InsetBox[
             GraphicsBox[{
               {Hue[0.67, 0.6, 0.6], Thickness[Large], 
                LineBox[{{0, 0.5}, {1, 0.5}}]}, {}},
              PlotRange->{{0, 1}, {0, 1}}], {0, 0}, {Left, Bottom}, {1, 1}], 
            InsetBox[
             StyleBox["\<\"yawTM/yawg\"\>",
              StripOnInput->False,
              FontSize->14], NCache[{1.05, Rational[1, 2]}, {1.05, 0.5}], {-1, 0},
              Automatic, {1, 0}]}, {}},
          AspectRatio->0.186046511627907,
          FormatType->TraditionalForm,
          PlotRange->{{-0.1, 3.6}, {-0.1, 1.1}}], {0.35, 0.3}, {
         Left, Bottom}, {0.43, 0.08}]}]}}]},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->600.,
  PlotRange->All]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511161422990941*^9, 3.5111614478109827`*^9}, 
   3.511230657179332*^9, 3.511230687973786*^9, 3.511231850987028*^9, 
   3.5112321855830207`*^9, 3.5112326978099203`*^9, 3.5112327732360525`*^9, {
   3.5112328563529987`*^9, 3.5112328659626155`*^9}, 3.5112329164599047`*^9, 
   3.5112329747416067`*^9, {3.5112330127276735`*^9, 3.5112330177040825`*^9}, {
   3.5112330645665646`*^9, 3.511233088918207*^9}, {3.5112332403788733`*^9, 
   3.511233264777316*^9}, 3.511330866367856*^9, 3.5113313123882394`*^9, 
   3.511390364321541*^9, 3.5113904650821176`*^9, {3.511390495814172*^9, 
   3.5113905162346077`*^9}, 3.511418367785653*^9, 3.5114185710696096`*^9, 
   3.511431634843893*^9, 3.512730750000399*^9, 3.5127333926310434`*^9, {
   3.512735394317359*^9, 3.5127354208530054`*^9}, 3.5145125759276123`*^9, 
   3.5145126576873555`*^9, 3.514512719182664*^9, 3.5145127724879575`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer function from force to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5109750603967185`*^9, 3.5109750715975385`*^9}, {
  3.5114183861780853`*^9, 3.5114184005613103`*^9}}],

Cell[BoxData[
 RowBox[{"tfplotf", "[", 
  RowBox[{
   RowBox[{"{", "yawTM", "}"}], ",", 
   RowBox[{"{", "yawTM", "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.510957748603794*^9, 3.5109577777446456`*^9}, {
   3.510957947894144*^9, 3.510957950312149*^9}, 3.5109588754873734`*^9, {
   3.510960251768591*^9, 3.5109602568386*^9}, {3.5109644688037157`*^9, 
   3.5109645325454273`*^9}, {3.5109646318084016`*^9, 3.510964636956411*^9}, {
   3.5109652306946535`*^9, 3.510965232036256*^9}, {3.5109653621872845`*^9, 
   3.510965374776507*^9}, {3.510965421685789*^9, 3.510965427161399*^9}, {
   3.5109750765583467`*^9, 3.5109750893035693`*^9}, {3.5109828951875024`*^9, 
   3.510982897106306*^9}, {3.511002574321229*^9, 3.511002578689237*^9}, {
   3.511147126083946*^9, 3.511147126583147*^9}, {3.51133135800272*^9, 
   3.5113313625891275`*^9}, 3.5114184005613103`*^9, {3.511431802278987*^9, 
   3.511431817223813*^9}, {3.5114319322428155`*^9, 3.511431934083619*^9}, {
   3.511494423146207*^9, 3.511494426297412*^9}, {3.5114944629106765`*^9, 
   3.511494463940278*^9}, {3.511494528649192*^9, 3.511494529819194*^9}, {
   3.511494611407337*^9, 3.5114946157285447`*^9}, {3.5114947070511055`*^9, 
   3.51149470978111*^9}, {3.511495153274289*^9, 3.511495157252296*^9}, {
   3.511495906471814*^9, 3.5114959082502174`*^9}, 3.511495988091158*^9, {
   3.5114960625188885`*^9, 3.5114960693985004`*^9}, {3.5114976579860983`*^9, 
   3.5114976911673565`*^9}, {3.511497813627572*^9, 3.511497817184378*^9}, {
   3.5123560718342876`*^9, 3.512356077871499*^9}, {3.5123561129091606`*^9, 
   3.512356116699967*^9}, {3.5123595749764414`*^9, 3.51235961417931*^9}, 
   3.512359690713044*^9, {3.512423733837125*^9, 3.5124237421987395`*^9}, {
   3.512728016650796*^9, 3.5127280238736086`*^9}, {3.514170374388322*^9, 
   3.5141703868683434`*^9}, {3.5142423784843864`*^9, 
   3.5142423866744003`*^9}, {3.5145128785369434`*^9, 3.5145128975221767`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer function from actuator to disp.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510969554959849*^9, 3.510969560841059*^9}, {
   3.5109751070876007`*^9, 3.5109751100048056`*^9}, {3.5114184059745197`*^9, 
   3.511418444678188*^9}, 3.5127279886643467`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ca1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"+", "0.25"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ca2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"+", "0.25"}], ",", 
     RowBox[{"-", "0.25"}], ",", 
     RowBox[{"-", "0.25"}], ",", 
     RowBox[{"+", "0.25"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"aTMlist", "=", 
   RowBox[{"{", 
    RowBox[{"aTM1", ",", "aTM2", ",", "aTM3", ",", "aTM4"}], "}"}]}], 
  ";"}]}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.512727879666955*^9, 3.5127279886643467`*^9}}],

Cell[BoxData[
 RowBox[{"tfplota", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ca1", ".", "aTMlist"}], ",", 
     RowBox[{"ca2", ".", "aTMlist"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"zTM", ",", "pitchTM"}], "}"}], ",", "freq"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.510974630101163*^9, 3.510974667307228*^9}, {
   3.5109751707513123`*^9, 3.510975230827018*^9}, {3.510975278219901*^9, 
   3.510975296534333*^9}, 3.510975617333297*^9, 3.5109762079503345`*^9, {
   3.510976711909239*^9, 3.5109767681005373`*^9}, {3.510981275918256*^9, 
   3.510981277462659*^9}, {3.5109815367911143`*^9, 3.510981543436726*^9}, {
   3.5110039773252935`*^9, 3.5110039774500937`*^9}, {3.5111476837225256`*^9, 
   3.511147683909726*^9}, {3.511149615115118*^9, 3.5111496153023186`*^9}, {
   3.5111518249681997`*^9, 3.5111518251085997`*^9}, {3.511155202125937*^9, 
   3.511155202281937*^9}, {3.511155261842842*^9, 3.511155266881651*^9}, {
   3.51133147809173*^9, 3.511331483863741*^9}, {3.5113317639466324`*^9, 
   3.511331775989854*^9}, {3.5113321818401666`*^9, 3.5113321940861883`*^9}, {
   3.511332324533617*^9, 3.511332347590458*^9}, {3.511332426900997*^9, 
   3.511332473513879*^9}, {3.511332686797454*^9, 3.51133270737389*^9}, {
   3.511332765078391*^9, 3.511332767293595*^9}, {3.511391414234585*^9, 
   3.511391414983386*^9}, {3.511418452665402*^9, 3.511418453414203*^9}, {
   3.51141849147827*^9, 3.5114185140983095`*^9}, {3.511418638882929*^9, 
   3.51141863970973*^9}, {3.5114187268670835`*^9, 3.511418727069884*^9}, {
   3.511418809126028*^9, 3.5114188156312394`*^9}, {3.5114318640550957`*^9, 
   3.5114318802947245`*^9}, {3.5127278701353383`*^9, 3.512727873208544*^9}, {
   3.5127279545158863`*^9, 3.5127279886643467`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["State-Space Model", "Section",
 CellChangeTimes->{{3.511335807091339*^9, 3.5113358106481447`*^9}, 
   3.511337659532192*^9, {3.512773070004176*^9, 3.5127730729993815`*^9}}],

Cell[CellGroupData[{

Cell["State-Space Matrices", "Subsection",
 CellChangeTimes->{{3.511338449601981*^9, 3.511338476356028*^9}}],

Cell[CellGroupData[{

Cell["Set Input", "Subsubsection",
 CellChangeTimes->{{3.511345101119687*^9, 3.5113451151285114`*^9}, 
   3.5113452765575953`*^9, {3.5113491519476023`*^9, 3.511349152649603*^9}}],

Cell[CellGroupData[{

Cell["Create parameter input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393300724698*^9}, 
   3.511393991963113*^9, {3.511394540569276*^9, 3.5113945443288827`*^9}, 
   3.512728164258255*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputp", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputvecp", "=", 
   RowBox[{"makeinputvecp", "[", "inputp", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, 3.5113933213323345`*^9, 3.511393991963113*^9, {
   3.5127281565986414`*^9, 3.5127281605922484`*^9}, {3.5127308942850523`*^9, 
   3.51273090969788*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create force input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393313891122*^9}, 
   3.5113939948803177`*^9, {3.5113945468248873`*^9, 3.5113945475892887`*^9}, 
   3.5127281856926928`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputf", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputvecf", "=", 
   RowBox[{"makeinputvecf", "[", "inputf", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, {3.5113933227831373`*^9, 3.511393333874757*^9}, 
   3.5113939948803177`*^9, {3.511419195257906*^9, 3.5114191953359065`*^9}, 
   3.51143273690463*^9, {3.5127281700770655`*^9, 3.5127281744762726`*^9}, {
   3.5127309033018684`*^9, 3.512730912833485*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create actuator input vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, 
   3.5113919865527897`*^9, {3.5113932945782876`*^9, 3.511393346042778*^9}, {
   3.511394549476892*^9, 3.5113945509276943`*^9}, {3.5127281815742855`*^9, 
   3.5127281824634867`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputa", "=", 
   RowBox[{"{", 
    RowBox[{"aF01", ",", "aF02", ",", "aF03"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputveca", "=", 
   RowBox[{"makeinputveca", "[", "inputa", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, 3.511347728554302*^9, {
   3.51135156339744*^9, 3.5113515638186407`*^9}, 3.5113919865527897`*^9, {
   3.5113923432630167`*^9, 3.511392343497017*^9}, {3.511393282316666*^9, 
   3.5113932878546762`*^9}, {3.5113933227831373`*^9, 3.511393333874757*^9}, {
   3.5113934356805353`*^9, 3.511393441889346*^9}, {3.5113939599674563`*^9, 
   3.5113939625102606`*^9}, {3.5114327391510344`*^9, 
   3.5114327467638474`*^9}, {3.512728188204297*^9, 3.512728199093116*^9}, {
   3.5127309146586885`*^9, 3.51273092685791*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set Output", "Subsubsection",
 CellChangeTimes->{{3.5113471295288496`*^9, 3.511347130230851*^9}, {
  3.511349154038006*^9, 3.511349154693207*^9}}],

Cell[CellGroupData[{

Cell["Create output vector", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345666090279*^9, 3.5113456727358913`*^9}, 
   3.511346162498751*^9, {3.511346966477363*^9, 3.5113469772257824`*^9}, {
   3.511347126221644*^9, 3.5113471378280644`*^9}, {3.511394532363662*^9, 
   3.5113945368876696`*^9}, {3.512728214271943*^9, 3.5127282158943453`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"outputv", "=", 
   RowBox[{"{", 
    RowBox[{"zF0", ",", "xF0", ",", "yawF0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outputvecv", "=", 
   RowBox[{"makeoutputvecv", "[", "outputv", "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511345708522354*^9, 3.5113457533100324`*^9}, 
   3.5113458022629185`*^9, 3.511346162498751*^9, {3.5113470309210763`*^9, 
   3.511347050530311*^9}, 3.511347126221644*^9, {3.5113926520031586`*^9, 
   3.51139265832117*^9}, {3.5113944608687363`*^9, 3.511394475579562*^9}, 
   3.5114190053119726`*^9, {3.512728211682338*^9, 3.5127282259251633`*^9}, {
   3.5127309369199276`*^9, 3.512730975311595*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["State-Space Matrices", "Subsubsection",
 CellChangeTimes->{{3.5113428440609226`*^9, 3.5113428707837696`*^9}, {
  3.5114035961001205`*^9, 3.511403604336935*^9}, {3.511404827987484*^9, 
  3.511404832542692*^9}}],

Cell[CellGroupData[{

Cell["\<\
Damping frequency (for use in converting structure damping to viscous damping)\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511404853665129*^9, 3.5114048575495358`*^9}, {
  3.5114049021188145`*^9, 3.5114049368912754`*^9}, {3.5114050434862623`*^9, 
  3.5114050447498646`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fdamp", "=", 
    RowBox[{"0.03", "hertz"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511404881448778*^9, 3.5114049021188145`*^9}, {
  3.5114059906771326`*^9, 3.511405991878335*^9}, {3.511406097755721*^9, 
  3.5114061003297253`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create the \"A\" matrix. Structure damping is considered to be zero.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.511349227935335*^9, 3.5113492291365376`*^9}, {3.5114048144466605`*^9, 
  3.51140481996907*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssAr", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"IdentityMatrix", "[", 
          RowBox[{"Length", "[", "allvars", "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKvv"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matGvv"}]}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5113426757990274`*^9, 3.5113426772342296`*^9}, {
   3.5113427437527466`*^9, 3.5113427464047513`*^9}, {3.511342836120509*^9, 
   3.511342836338909*^9}, {3.5113428792545843`*^9, 3.511342914588647*^9}, {
   3.5113433061181345`*^9, 3.5113433157745514`*^9}, {3.511343413555523*^9, 
   3.51134342885915*^9}, {3.511343479060038*^9, 3.5113435935642395`*^9}, {
   3.511343633001108*^9, 3.5113436752147827`*^9}, {3.5113438056778116`*^9, 
   3.5113438390618706`*^9}, 3.5113438807139435`*^9, 3.51134391846601*^9, {
   3.511347221849812*^9, 3.511347406320136*^9}, {3.511347441045797*^9, 
   3.5113474641026373`*^9}, 3.511347506503512*^9, 3.511349063230246*^9, 
   3.5113491808076525`*^9, {3.511352291731519*^9, 3.5113522926051207`*^9}, {
   3.5113527927143993`*^9, 3.5113528109664316`*^9}, {3.5113905926279416`*^9, 
   3.5113905982283516`*^9}, {3.5114050655291014`*^9, 3.511405068290306*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create the \"A\" matrix. Structure damping is approximated by viscous damping \
such that the amount of phase lag is the same at damping frequency.\
\>", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.511349227935335*^9, 3.5113492291365376`*^9}, {3.51140477454179*^9, 
  3.5114048023878393`*^9}, {3.5114048635711465`*^9, 3.5114048754583673`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssAa", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"IdentityMatrix", "[", 
          RowBox[{"Length", "[", "allvars", "]"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKvv"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matGvv"}]}], "-", 
          RowBox[{
           RowBox[{
            RowBox[{"Inverse", "[", "matMvv", "]"}], ".", 
            RowBox[{"Im", "[", "matKvvc", "]"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], "fdamp"}], ")"}]}]}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.5113426757990274`*^9, 3.5113426772342296`*^9}, {
   3.5113427437527466`*^9, 3.5113427464047513`*^9}, {3.511342836120509*^9, 
   3.511342836338909*^9}, {3.5113428792545843`*^9, 3.511342914588647*^9}, {
   3.5113433061181345`*^9, 3.5113433157745514`*^9}, {3.511343413555523*^9, 
   3.51134342885915*^9}, {3.511343479060038*^9, 3.5113435935642395`*^9}, {
   3.511343633001108*^9, 3.5113436752147827`*^9}, {3.5113438056778116`*^9, 
   3.5113438390618706`*^9}, 3.5113438807139435`*^9, 3.51134391846601*^9, {
   3.511347221849812*^9, 3.511347406320136*^9}, {3.511347441045797*^9, 
   3.5113474641026373`*^9}, 3.511347506503512*^9, 3.511349063230246*^9, 
   3.5113491808076525`*^9, {3.511352291731519*^9, 3.5113522926051207`*^9}, {
   3.5113527927143993`*^9, 3.5113528109664316`*^9}, {3.5113905926279416`*^9, 
   3.5113905982283516`*^9}, 3.5114048023878393`*^9, {3.511405008043*^9, 
   3.5114051058707724`*^9}, {3.5114054963638587`*^9, 3.511405506831477*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"B\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113492256733313`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssB", "=", 
    RowBox[{"ArrayFlatten", "[", "\[IndentingNewLine]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputp", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputf", "]"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "allvars", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Length", "[", "inputa", "]"}], "}"}]}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "matKpv", ".", 
           "inputvecp"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "inputvecf"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Inverse", "[", "matMvv", "]"}], ".", "inputveca"}]}], 
        "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "}"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.511343921024414*^9, 3.5113439340036373`*^9}, {
   3.5113475427891755`*^9, 3.5113477094598684`*^9}, {3.5113478660841436`*^9, 
   3.5113479747539344`*^9}, {3.511348254119225*^9, 3.5113482681436496`*^9}, {
   3.5113485186332893`*^9, 3.51134851882049*^9}, 3.511349064587448*^9, 
   3.511349196797681*^9, {3.5113528177836437`*^9, 3.5113528253184566`*^9}, {
   3.5113529173430185`*^9, 3.5113529199950233`*^9}, {3.511392437830383*^9, 
   3.511392440373187*^9}, {3.5113925180769234`*^9, 3.511392522725732*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"C\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113492162977147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssC", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{"outputvecv", ",", "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "allvars", "]"}], "}"}]}], "]"}], ",", "2"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.},
 CellChangeTimes->{{3.511348273494459*^9, 3.5113482899836884`*^9}, {
   3.5113483981230783`*^9, 3.5113484770436163`*^9}, {3.5113485408165283`*^9, 
   3.511348569692179*^9}, 3.5113486013602347`*^9, {3.511348992686922*^9, 
   3.5113490063369465`*^9}, {3.511349044089012*^9, 3.5113490659446507`*^9}, 
   3.5113492071716986`*^9, {3.5113529435354643`*^9, 3.511352946218669*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create the \"D\" matrix.", "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511349164942425*^9, 3.5113491808076525`*^9}, {
  3.5113492109469056`*^9, 3.5113492202133217`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ssD", "=", 
    RowBox[{"Join", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputp", "]"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputf", "]"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Table", "[", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "outputv", "]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Length", "[", "inputa", "]"}], "}"}]}], "]"}], ",", "2"}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.511349068035054*^9, 3.511349108813526*^9}, {
  3.5113492202133217`*^9, 3.511349221913725*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Subsection",
 CellChangeTimes->{{3.5113492434105625`*^9, 3.5113492506957755`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"matlabexport", "[", 
    RowBox[{"\"\<matlab/ss110410.m\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssA\>\"", ",", "ssAa"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssB\>\"", ",", "ssB"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssC\>\"", ",", "ssC"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<ssD\>\"", ",", "ssD"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.511349255204183*^9, 3.511349323360703*^9}, 
   3.5114051453544416`*^9, {3.5114052158381658`*^9, 3.5114052352194*^9}, 
   3.5114055594347696`*^9, 3.511418896018181*^9, 3.511431975798092*^9, {
   3.5114323267943096`*^9, 3.5114323285415125`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Seismic Noise", "Section",
 CellChangeTimes->{{3.512731095621007*^9, 3.512731107040227*^9}}],

Cell[CellGroupData[{

Cell["About This Section", "Subsection",
 CellChangeTimes->{{3.518762140341918*^9, 3.5187621449907265`*^9}}],

Cell["\<\
The data of the seismic vibration level in Kamioka are imported from the \
\"../seism_kamioka\" folder. The vibration of the TM caused by the seismic \
motion is estimated, and the spectrum densities, RMS displacement, and RMS \
velocities are plotted.
\
\>", "Text",
 CellChangeTimes->{{3.518762219699258*^9, 3.5187622745021534`*^9}, {
  3.518762314204624*^9, 3.5187624772319107`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frequency List", "Subsection",
 CellChangeTimes->{{3.505457309098371*^9, 3.5054573134988823`*^9}, {
  3.505457392369238*^9, 3.505457393435096*^9}, {3.507903438769166*^9, 
  3.507903442019352*^9}, {3.5079450761978855`*^9, 3.5079450876015053`*^9}, {
  3.507945118302359*^9, 3.507945140813199*^9}, {3.5109227629829597`*^9, 
  3.510922763595995*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fmin", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "2"}]], " ", "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"minimum", " ", "frequency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fmax", "=", 
    RowBox[{"1", " ", 
     SuperscriptBox["10", "2"], "hertz"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"maximum", " ", "freqnency"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ngrid", "=", "1001"}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"number", " ", "of", " ", "grids"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727491881474*^9}, {
   3.512735563374856*^9, 3.51273556568366*^9}, {3.512735595916513*^9, 
   3.5127355960881133`*^9}, 3.5145130471732397`*^9, {3.514513091196517*^9, 
   3.5145131069525447`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"freq", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"imin", ",", "imax", ",", "dgrid"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"imin", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmin"}], "]"}]}], ";", 
       RowBox[{"imax", "=", 
        RowBox[{"Log", "[", 
         RowBox[{"10", ",", "fmax"}], "]"}]}], ";", 
       RowBox[{"dgrid", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"imax", "-", "imin"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"ngrid", "-", "1"}], ")"}]}]}], ";", "\n", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"10", "^", "i"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "imin", ",", "imax", ",", "dgrid"}], "}"}]}], 
        "]"}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"Frequency", " ", "list"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5079437907558236`*^9, 3.5079439830729613`*^9}, {
   3.5079440622431*^9, 3.5079440624147005`*^9}, {3.5079440956739593`*^9, 
   3.507944096875161*^9}, 3.5079441778237033`*^9, {3.5079445464225545`*^9, 
   3.5079445466097546`*^9}, {3.50794501640298*^9, 3.5079450202405868`*^9}, 
   3.5079450559646497`*^9, 3.507945701790184*^9, {3.507945743301857*^9, 
   3.5079457477166643`*^9}, {3.508056511433575*^9, 3.508056511776776*^9}, {
   3.5080566504610195`*^9, 3.50805665075742*^9}, {3.508117933375839*^9, 
   3.5081179356066427`*^9}, {3.5082143648046265`*^9, 3.508214371684239*^9}, {
   3.510405201938513*^9, 3.510405203850622*^9}, {3.5104081570565357`*^9, 
   3.510408158312608*^9}, {3.5104088030074825`*^9, 3.510408811078944*^9}, {
   3.5104129367289176`*^9, 3.5104129458664403`*^9}, {3.5104455061152945`*^9, 
   3.5104455111697035`*^9}, {3.5105372720362353`*^9, 
   3.5105372721766357`*^9}, {3.5105373756672173`*^9, 3.510537375854418*^9}, 
   3.5106333737914104`*^9, {3.5106358171925025`*^9, 3.510635817473303*^9}, {
   3.5109228206962614`*^9, 3.5109228592864685`*^9}, 3.5109676607265215`*^9, {
   3.5110038763463163`*^9, 3.5110038811043243`*^9}, {3.5113312825453873`*^9, 
   3.511331283746589*^9}, {3.5114943820713344`*^9, 3.5114943893565474`*^9}, {
   3.5114955948018646`*^9, 3.5114955949422646`*^9}, {3.511497703881379*^9, 
   3.5114977039749794`*^9}, {3.512727423163353*^9, 3.512727540428759*^9}, {
   3.5145130471732397`*^9, 3.514513057001257*^9}, {3.514513513738859*^9, 
   3.514513515642063*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise Level in Kamioka", "Subsection",
 CellChangeTimes->{{3.512731113826239*^9, 3.512731119130248*^9}, {
  3.512731225506835*^9, 3.5127312319340467`*^9}}],

Cell[CellGroupData[{

Cell["Import Data", "Subsubsection",
 CellChangeTimes->{{3.51273123979646*^9, 3.5127312417152634`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaQD", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<../seism_kamioka/kamiokaQ.txt\>\"", ",", "\"\<Table\>\""}], 
     "]"}]}], ";"}], 
  RowBox[{"(*", "normal", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"kamiokaND", "=", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<../seism_kamioka/kamiokaN.txt\>\"", ",", "\"\<Table\>\""}], 
     "]"}]}], ";"}], 
  RowBox[{"(*", "noisy", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512731124044257*^9, 3.512731183324361*^9}, {
  3.5127313785115056`*^9, 3.5127313796035075`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolation", "Subsubsection",
 CellChangeTimes->{{3.5127312456152706`*^9, 3.5127312474092736`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kamiokaQI", "=", 
   RowBox[{"Interpolation", "[", "kamiokaQD", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaNI", "=", 
   RowBox[{"Interpolation", "[", "kamiokaND", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaQ", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"kamiokaQI", "[", 
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kamiokaN", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"kamiokaNI", "[", 
      RowBox[{"freq", "[", 
       RowBox[{"[", "n", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.512731309964985*^9, 3.5127314691788645`*^9}, {
  3.5127328485644875`*^9, 3.5127328496252894`*^9}, {3.514513145609413*^9, 
  3.5145131464986143`*^9}, {3.5145135210240717`*^9, 3.5145135217260733`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer Function", "Subsection",
 CellChangeTimes->{{3.512731535759782*^9, 3.5127315489106045`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMh", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"tfcalc", "[", 
      RowBox[{"zg", ",", "zTM", ",", "freq"}], "]"}], "]"}]}], ";"}], 
  RowBox[{"(*", "horizontal", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMv", "=", 
    RowBox[{"Abs", "[", 
     RowBox[{"tfcalc", "[", 
      RowBox[{"yg", ",", "yTM", ",", "freq"}], "]"}], "]"}]}], ";"}], 
  RowBox[{"(*", "vertical", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tfgr2TMm", "=", 
    RowBox[{"tfgr2TMh", "+", 
     RowBox[{"tfgr2TMv", "*", "0.01"}]}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{"H", "+", 
    RowBox[{"V", "*", "0.01"}]}], "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5127315591754227`*^9, 3.5127317173909006`*^9}, {
  3.514513348316169*^9, 3.51451334900257*^9}, {3.5145135065940466`*^9, 
  3.5145135072648478`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["TM Displacement", "Subsection",
 CellChangeTimes->{{3.512737312371275*^9, 3.5127373256310334`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"seismTM", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"kamiokaN", "[", 
        RowBox[{"[", "n", "]"}], "]"}], 
       RowBox[{"tfgr2TMm", "[", 
        RowBox[{"[", "n", "]"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127368633335915`*^9, 3.512736871853079*^9}, 
   3.512737338522771*^9, {3.518819017678076*^9, 3.518819018551677*^9}, {
   3.5188274779830537`*^9, 3.5188274784822545`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Amplitude", "Subsection",
 CellChangeTimes->{{3.512737343119034*^9, 3.5127373479093075`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsG", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"kamiokaN", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 3.5127368011750364`*^9}, 
   3.512736888779047*^9, {3.512737005731736*^9, 3.512737006619787*^9}, {
   3.5188190414993176`*^9, 3.518819042248119*^9}, {3.5188274813526597`*^9, 
   3.5188274817738605`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsTM", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"seismTM", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
  3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
  3.5127365074132338`*^9}, {3.5127365389750395`*^9, 3.5127366695405073`*^9}, {
  3.5127367255437107`*^9, 3.5127368011750364`*^9}, {3.512736888779047*^9, 
  3.5127369084451714`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Velocity", "Subsection",
 CellChangeTimes->{{3.5127373596419787`*^9, 3.512737362145122*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsGv", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], 
             RowBox[{"freq", "[", 
              RowBox[{"[", 
               RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"kamiokaN", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             "\[IndentingNewLine]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 3.5127368011750364`*^9}, 
   3.512736888779047*^9, {3.512737005731736*^9, 3.512737006619787*^9}, {
   3.5127371563913536`*^9, 3.5127372121745443`*^9}, {3.5188190506409335`*^9, 
   3.5188190511245346`*^9}, {3.518827486687869*^9, 3.5188274871246696`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rmsTMv", "=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sqval", ",", "rms"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rms", "=", 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "ngrid"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"sqval", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"sqval", "=", 
           RowBox[{"sqval", "+", 
            RowBox[{"2", 
             RowBox[{"N", "[", "Pi", "]"}], 
             RowBox[{"freq", "[", 
              RowBox[{"[", 
               RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], 
             SuperscriptBox[
              RowBox[{"seismTM", "[", 
               RowBox[{"[", 
                RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "2"], 
             "\[IndentingNewLine]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "-", 
               RowBox[{"freq", "[", 
                RowBox[{"[", 
                 RowBox[{"ngrid", "-", "n"}], "]"}], "]"}]}], ")"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"rms", "[", 
            RowBox[{"[", 
             RowBox[{"ngrid", "-", "n", "+", "1"}], "]"}], "]"}], "=", 
           RowBox[{"Sqrt", "[", "sqval", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"n", ",", 
           RowBox[{"ngrid", "-", "1"}]}], "}"}]}], "]"}], ";", 
       RowBox[{
        RowBox[{"rms", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "=", 
        RowBox[{"rms", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "rms"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5127362415340266`*^9, 3.512736351893339*^9}, {
   3.512736382978117*^9, 3.5127364635097227`*^9}, {3.512736506970209*^9, 
   3.5127365074132338`*^9}, {3.5127365389750395`*^9, 
   3.5127366695405073`*^9}, {3.5127367255437107`*^9, 
   3.5127368011750364`*^9}, {3.512736888779047*^9, 3.5127369084451714`*^9}, 
   3.5127371603895817`*^9, {3.5127372199189873`*^9, 3.5127372226241417`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot", "Subsection",
 CellChangeTimes->{{3.5127324150709257`*^9, 3.5127324159289274`*^9}}],

Cell[CellGroupData[{

Cell["Transfer Function", "Subsubsection",
 CellChangeTimes->{{3.5127324243373423`*^9, 3.5127324316693554`*^9}, {
  3.512735786767248*^9, 3.512735789684453*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tfgr2TMh", ",", "tfgr2TMv", ",", "tfgr2TMm"}], "}"}], ",", 
   "freq", ",", "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Horizontal\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Vertical\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<H+V*0.01\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512732433853359*^9, 3.5127324824474444`*^9}, {
  3.512732521244713*^9, 3.512732581726019*^9}, {3.512735625416165*^9, 
  3.5127356343861804`*^9}, {3.5127356820130644`*^9, 3.5127357681720157`*^9}, {
  3.5145134860332108`*^9, 3.5145134932872233`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Seismic Noise in Kamioka", "Subsubsection",
 CellChangeTimes->{{3.512735800011671*^9, 3.51273580487888*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kamiokaQ", ",", "kamiokaN"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Normal\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Noisy\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.512735814020496*^9, 3.5127358381849384`*^9}, {
  3.5145134802924004`*^9, 3.5145134952216268`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Displacement of TM", "Subsubsection",
 CellChangeTimes->{{3.512735870445795*^9, 3.5127358735502005`*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"kamiokaN", ",", "seismTM"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "24"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127359108810663`*^9, 3.512735932487104*^9}, {
  3.5127360578145185`*^9, 3.5127360749604993`*^9}, {3.512736876635352*^9, 
  3.512736877886424*^9}, {3.5127374336122093`*^9, 3.5127374629808893`*^9}, {
  3.5145134832252054`*^9, 3.514513497483631*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Amplitude", "Subsubsection",
 CellChangeTimes->{{3.512736221085857*^9, 3.512736229689349*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rmsG", ",", "rmsTM"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], ",", 
        RowBox[{"5", " ", 
         SuperscriptBox["10", "0"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127369493235097`*^9, 3.5127369555868683`*^9}, {
  3.5127370239277773`*^9, 3.512737123213456*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RMS Velocity", "Subsubsection",
 CellChangeTimes->{{3.512736221085857*^9, 3.512736229689349*^9}, {
  3.5127371487029133`*^9, 3.5127371538812103`*^9}}],

Cell[BoxData[
 RowBox[{"freqplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"rmsGv", ",", "rmsTMv"}], "}"}], ",", "freq", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotLegend", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Ground\>\"", ",", "14"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Test Mass\>\"", ",", "14"}], "]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LegendPosition", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.35", ",", "0.3"}], "}"}]}], ",", 
   RowBox[{"LegendSpacing", "\[Rule]", "0"}], ",", 
   RowBox[{"LegendTextSpace", "\[Rule]", "2.5"}], ",", 
   RowBox[{"LegendShadow", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LegendSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.18"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "2"}]], ",", 
        RowBox[{"5", " ", 
         SuperscriptBox["10", "0"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]], ",", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5127369493235097`*^9, 3.5127369555868683`*^9}, {
  3.5127370239277773`*^9, 3.512737123213456*^9}, {3.512737228658487*^9, 
  3.512737266235636*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export", "Subsection",
 CellChangeTimes->{{3.512737737191573*^9, 3.512737738408643*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "file", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"file", "=", 
       RowBox[{
       "OpenWrite", "[", "\"\<data/typeA_seism_110704.txt\>\"", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"WriteString", "[", "\[IndentingNewLine]", 
       RowBox[{"file", ",", "\[IndentingNewLine]", 
        RowBox[{"ExportString", "[", 
         RowBox[{
          RowBox[{"comb", "[", 
           RowBox[{"freq", ",", "seismTM"}], "]"}], ",", "\"\<Table\>\""}], 
         "]"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Close", "[", "file", "]"}]}]}], "\[IndentingNewLine]", "]"}], 
   ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5120931380276957`*^9, 3.5120932074634175`*^9}, {
   3.5120944398499823`*^9, 3.512094444951191*^9}, {3.512094493982077*^9, 
   3.5120944961036806`*^9}, {3.512729825246375*^9, 3.5127298255739756`*^9}, 
   3.5127302268534803`*^9, {3.512737834559142*^9, 3.512737910425482*^9}, {
   3.512737965140611*^9, 3.5127379740961237`*^9}, {3.51273804413513*^9, 
   3.512738045349199*^9}, {3.5188279957323627`*^9, 3.5188279983999677`*^9}}]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1005, 615},
WindowMargins->{{Automatic, -3}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (2008\:5e7412\:670810\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3518867795-7951492"->{
  Cell[171557, 4637, 353, 6, 155, "Print",
   CellTags->"Info3518867795-7951492"]},
 "Info3518867795-8101306"->{
  Cell[182708, 4926, 599, 9, 243, "Print",
   CellTags->"Info3518867795-8101306"]},
 "Info3518867796-2584648"->{
  Cell[190308, 5113, 575, 9, 199, "Print",
   CellTags->"Info3518867796-2584648"]},
 "Info3518867796-7320688"->{
  Cell[196411, 5262, 374, 6, 111, "Print",
   CellTags->"Info3518867796-7320688"]},
 "Info3512763231-3783408"->{
  Cell[446962, 9967, 282, 5, 44, "Print",
   CellTags->"Info3512763231-3783408"]},
 "Info3512763232-9783139"->{
  Cell[447473, 9980, 289, 5, 44, "Print",
   CellTags->"Info3512763232-9783139"]},
 "Info3512763232-5043775"->{
  Cell[447989, 9993, 315, 5, 67, "Print",
   CellTags->"Info3512763232-5043775"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3518867795-7951492", 555227, 12303},
 {"Info3518867795-8101306", 555340, 12306},
 {"Info3518867796-2584648", 555453, 12309},
 {"Info3518867796-7320688", 555566, 12312},
 {"Info3512763231-3783408", 555679, 12315},
 {"Info3512763232-9783139", 555791, 12318},
 {"Info3512763232-5043775", 555903, 12321}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 540, 10, 105, "Subtitle"],
Cell[CellGroupData[{
Cell[1132, 36, 172, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[1329, 42, 157, 2, 36, "Subsection"],
Cell[1489, 46, 1369, 22, 119, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2895, 73, 105, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[3025, 78, 163, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3191, 82, 182, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[3388, 87, 411, 5, 26, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3836, 97, 160, 2, 36, "Subsection"],
Cell[3999, 101, 552, 11, 83, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4600, 118, 204, 3, 71, "Section"],
Cell[CellGroupData[{
Cell[4829, 125, 204, 3, 36, "Subsection"],
Cell[5036, 130, 337, 4, 29, "Text"],
Cell[5376, 136, 446, 8, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5859, 149, 203, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[6087, 156, 265, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[6355, 164, 465, 10, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[6857, 179, 219, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7079, 184, 306, 7, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7434, 197, 110, 1, 36, "Subsection"],
Cell[7547, 200, 518, 9, 47, "Text"],
Cell[8068, 211, 279, 7, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8384, 223, 205, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[8614, 230, 297, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8914, 236, 302, 6, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[9253, 247, 242, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[9498, 254, 447, 7, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9994, 267, 203, 3, 36, "Subsection"],
Cell[10200, 272, 417, 7, 29, "Text"],
Cell[10620, 281, 2734, 79, 155, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13403, 366, 300, 4, 41, "Section"],
Cell[CellGroupData[{
Cell[13728, 374, 99, 1, 36, "Subsection"],
Cell[13830, 377, 339, 7, 65, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14206, 389, 107, 1, 36, "Subsection"],
Cell[14316, 392, 603, 14, 54, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14956, 411, 109, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[15090, 416, 210, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15303, 421, 785, 22, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[16125, 448, 184, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[16312, 453, 1448, 32, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[17797, 490, 177, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[17977, 495, 1658, 35, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[19672, 535, 203, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[19878, 540, 1507, 32, 74, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21434, 578, 151, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[21610, 584, 136, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[21771, 590, 236, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[22010, 595, 981, 25, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[23028, 625, 241, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[23272, 631, 3638, 71, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[26947, 707, 168, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[27118, 712, 781, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27948, 735, 143, 2, 27, "Subsubsection"],
Cell[28094, 739, 1482, 37, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29613, 781, 103, 1, 27, "Subsubsection"],
Cell[29719, 784, 1312, 34, 132, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31080, 824, 95, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[31200, 829, 177, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[31402, 835, 236, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[31641, 840, 1885, 52, 232, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[33563, 897, 145, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[33711, 901, 6805, 156, 552, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40565, 1063, 229, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[40819, 1070, 222, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41044, 1075, 748, 14, 83, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41795, 1091, 244, 6, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[42076, 1102, 193, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[42272, 1107, 3054, 79, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[45363, 1191, 306, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[45672, 1197, 1256, 29, 98, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[46965, 1231, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[47137, 1236, 1576, 38, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[48750, 1279, 223, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[48976, 1284, 1087, 28, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50112, 1318, 138, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[50275, 1324, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[50449, 1329, 412, 9, 65, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[50898, 1343, 258, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[51159, 1348, 322, 9, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[51496, 1360, 245, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[51744, 1365, 156, 4, 31, "Input"],
Cell[51903, 1371, 11134, 297, 652, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[CellGroupData[{
Cell[63062, 1672, 170, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[63235, 1676, 11554, 311, 652, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74850, 1994, 260, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[75135, 2001, 174, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[75334, 2007, 143, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[75480, 2011, 1579, 45, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[77096, 2061, 283, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[77382, 2067, 2093, 57, 76, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79524, 2130, 151, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[79700, 2136, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[79874, 2141, 443, 11, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[80354, 2157, 180, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[80537, 2162, 1927, 57, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82525, 2226, 153, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[82703, 2232, 205, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[82933, 2239, 225, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[83161, 2244, 839, 20, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[84037, 2269, 178, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[84218, 2274, 2948, 89, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[87203, 2368, 181, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[87387, 2373, 1336, 41, 76, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88772, 2420, 111, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[88908, 2425, 209, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[89120, 2430, 633, 15, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[89790, 2450, 175, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[89968, 2455, 781, 23, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90798, 2484, 169, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[90992, 2490, 193, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[91188, 2494, 2602, 58, 172, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[93827, 2557, 220, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[94050, 2562, 2004, 35, 172, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96103, 2603, 183, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[96311, 2609, 356, 7, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[96670, 2618, 9430, 219, 916, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[106115, 2840, 7076, 163, 916, "Input"],
Cell[CellGroupData[{
Cell[113216, 3007, 185, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[113404, 3012, 1339, 29, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114804, 3048, 164, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[114993, 3054, 153, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[115171, 3060, 196, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[115370, 3065, 681, 15, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[116054, 3082, 788, 19, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[116879, 3106, 187, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[117069, 3111, 400, 10, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117530, 3128, 99, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[117654, 3133, 102, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[117781, 3138, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[117953, 3143, 1357, 44, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[119313, 3189, 727, 20, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[120077, 3214, 204, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[120284, 3219, 2334, 69, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[122621, 3290, 2269, 66, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124939, 3362, 163, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[125127, 3368, 221, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[125351, 3373, 758, 17, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[126112, 3392, 2048, 59, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128221, 3458, 100, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[128346, 3463, 106, 1, 27, "Subsubsection"],
Cell[128455, 3466, 549, 11, 83, "Text"],
Cell[129007, 3479, 407, 8, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[129451, 3492, 213, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[129689, 3499, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[129865, 3504, 1096, 25, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[130998, 3534, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[131174, 3539, 847, 20, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[132058, 3564, 171, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[132232, 3569, 1589, 50, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[133858, 3624, 173, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[134034, 3629, 853, 23, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[134924, 3657, 178, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[135105, 3662, 1151, 32, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[136293, 3699, 180, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}],
Cell[136476, 3704, 1146, 31, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10004.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[137659, 3740, 186, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10005.}],
Cell[137848, 3745, 1063, 31, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10005.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[138948, 3781, 198, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}],
Cell[139149, 3786, 843, 22, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[140029, 3813, 172, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10007.}],
Cell[140204, 3818, 977, 24, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10007.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[141218, 3847, 251, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}],
Cell[141472, 3853, 752, 16, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10006.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[142261, 3874, 196, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10008.}],
Cell[142460, 3879, 868, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10008.}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143401, 3906, 224, 3, 41, "Section"],
Cell[CellGroupData[{
Cell[143650, 3913, 203, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[143878, 3920, 125, 1, 27, "Subsubsection"],
Cell[144006, 3923, 4827, 152, 352, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148870, 4080, 174, 2, 27, "Subsubsection"],
Cell[149047, 4084, 2329, 42, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151413, 4131, 105, 1, 27, "Subsubsection"],
Cell[151521, 4134, 803, 19, 92, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152373, 4159, 204, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[152602, 4166, 186, 2, 27, "Subsubsection"],
Cell[152791, 4170, 270, 8, 31, "Input"],
Cell[153064, 4180, 5628, 162, 352, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158729, 4347, 272, 5, 27, "Subsubsection"],
Cell[159004, 4354, 1488, 30, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160529, 4389, 103, 1, 27, "Subsubsection"],
Cell[160635, 4392, 863, 21, 92, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[161547, 4419, 234, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[161806, 4426, 110, 1, 27, "Subsubsection"],
Cell[161919, 4429, 3259, 53, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165215, 4487, 103, 1, 27, "Subsubsection"],
Cell[165321, 4490, 764, 17, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166122, 4512, 100, 1, 27, "Subsubsection"],
Cell[166225, 4515, 4599, 93, 192, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[170885, 4615, 160, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[171070, 4621, 207, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[171302, 4628, 106, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[171433, 4633, 121, 2, 31, "Input"],
Cell[171557, 4637, 353, 6, 155, "Print",
 CellTags->"Info3518867795-7951492"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[171959, 4649, 108, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[172092, 4654, 176, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[172271, 4659, 467, 11, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[172775, 4675, 250, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[173028, 4681, 2915, 61, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175992, 4748, 101, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[176118, 4753, 220, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[176341, 4758, 2045, 47, 192, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[178423, 4810, 169, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[178595, 4815, 1302, 31, 152, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[179934, 4851, 223, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[180160, 4856, 2054, 48, 192, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182275, 4911, 157, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[182457, 4917, 104, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[182586, 4922, 119, 2, 31, "Input"],
Cell[182708, 4926, 599, 9, 243, "Print",
 CellTags->"Info3518867795-8101306"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[183356, 4941, 107, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[183488, 4946, 278, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[183769, 4952, 756, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[184562, 4975, 381, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[184946, 4982, 4757, 108, 347, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189764, 5097, 259, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[190048, 5104, 109, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[190182, 5109, 123, 2, 31, "Input"],
Cell[190308, 5113, 575, 9, 199, "Print",
 CellTags->"Info3518867796-2584648"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190932, 5128, 107, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[191064, 5133, 305, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[191372, 5139, 611, 15, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[192020, 5159, 182, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[192205, 5164, 3756, 77, 252, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196022, 5248, 104, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[196151, 5253, 109, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[196285, 5258, 123, 2, 31, "Input"],
Cell[196411, 5262, 374, 6, 111, "Print",
 CellTags->"Info3518867796-7320688"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[196834, 5274, 112, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[196971, 5279, 232, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[197206, 5284, 925, 21, 192, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198192, 5312, 264, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[198481, 5319, 167, 2, 27, "Subsubsection"],
Cell[198651, 5323, 1848, 32, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[200536, 5360, 115, 1, 27, "Subsubsection"],
Cell[200654, 5363, 795, 18, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[201486, 5386, 109, 1, 27, "Subsubsection"],
Cell[201598, 5389, 2007, 34, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[203642, 5428, 108, 1, 27, "Subsubsection"],
Cell[203753, 5431, 436, 9, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204226, 5445, 166, 2, 27, "Subsubsection"],
Cell[204395, 5449, 1387, 37, 112, "Input"],
Cell[205785, 5488, 1482, 38, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[207304, 5531, 96, 1, 27, "Subsubsection"],
Cell[207403, 5534, 864, 17, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208316, 5557, 113, 1, 36, "Subsection"],
Cell[208432, 5560, 574, 11, 52, "Input"],
Cell[CellGroupData[{
Cell[209031, 5575, 118, 1, 27, "Subsubsection"],
Cell[209152, 5578, 951, 27, 132, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210152, 5611, 118, 1, 36, "Subsection"],
Cell[210273, 5614, 281, 7, 52, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[210603, 5627, 139, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[210767, 5633, 235, 3, 36, "Subsection"],
Cell[211005, 5638, 1414, 22, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212456, 5665, 138, 2, 36, "Subsection"],
Cell[212597, 5669, 269, 3, 29, "Text"],
Cell[CellGroupData[{
Cell[212891, 5676, 1917, 33, 132, "Input"],
Cell[214811, 5711, 9993, 189, 70, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[224865, 5907, 132, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[225022, 5913, 99, 1, 36, "Subsection"],
Cell[225124, 5916, 1611, 34, 72, "Input"],
Cell[226738, 5952, 1594, 34, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228369, 5991, 155, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[228549, 5997, 197, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[228749, 6002, 1874, 38, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[230626, 6042, 1648, 35, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[232277, 6079, 4305, 99, 292, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[236619, 6183, 204, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[236826, 6188, 1662, 35, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[238491, 6225, 1546, 34, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[240040, 6261, 4251, 98, 292, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[244340, 6365, 153, 2, 36, "Subsection"],
Cell[244496, 6369, 1711, 36, 72, "Input"],
Cell[246210, 6407, 1694, 35, 92, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[247953, 6448, 94, 1, 41, "Section"],
Cell[CellGroupData[{
Cell[248072, 6453, 168, 2, 36, "Subsection"],
Cell[248243, 6457, 1095, 29, 92, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[249375, 6491, 160, 2, 28, "Subsection"],
Cell[CellGroupData[{
Cell[249560, 6497, 553, 8, 31, "Input"],
Cell[250116, 6507, 36381, 626, 1346, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[286546, 7139, 161, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[286732, 7145, 214, 3, 27, "Subsubsection"],
Cell[286949, 7150, 1631, 41, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[288617, 7196, 115, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[288757, 7201, 2798, 39, 31, "Input"],
Cell[291558, 7242, 144427, 2465, 848, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[436058, 9715, 160, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[436243, 9721, 352, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[436620, 9730, 2228, 43, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[438851, 9775, 2457, 50, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[441357, 9831, 160, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[441542, 9837, 113, 1, 27, "Subsubsection"],
Cell[441658, 9840, 516, 11, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[442211, 9856, 113, 1, 27, "Subsubsection"],
Cell[442327, 9859, 3967, 86, 472, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[446343, 9951, 260, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[446628, 9958, 104, 1, 27, "Subsubsection"],
Cell[446735, 9961, 224, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[446962, 9967, 282, 5, 44, "Print",
 CellTags->"Info3512763231-3783408"],
Cell[447247, 9974, 223, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[447473, 9980, 289, 5, 44, "Print",
 CellTags->"Info3512763232-9783139"],
Cell[447765, 9987, 221, 4, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[447989, 9993, 315, 5, 67, "Print",
 CellTags->"Info3512763232-5043775"]
}, Open  ]],
Cell[CellGroupData[{
Cell[448341, 10003, 98, 1, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[448464, 10008, 172, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[448639, 10012, 1863, 28, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[450505, 10042, 52909, 943, 390, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[503451, 10990, 229, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[503683, 10995, 1980, 29, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[505700, 11029, 305, 4, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[506008, 11035, 750, 23, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[506761, 11060, 1789, 29, 31, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[508623, 11097, 178, 2, 41, "Section"],
Cell[CellGroupData[{
Cell[508826, 11103, 108, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[508959, 11108, 178, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[509162, 11114, 416, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[509581, 11122, 764, 15, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[510382, 11142, 418, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[510803, 11150, 864, 16, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[511704, 11171, 421, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[512128, 11179, 970, 19, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[513147, 11204, 152, 2, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[513324, 11210, 383, 5, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[513710, 11217, 768, 16, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[514527, 11239, 215, 3, 27, "Subsubsection"],
Cell[CellGroupData[{
Cell[514767, 11246, 329, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[515099, 11254, 358, 8, 52, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[515494, 11267, 314, 6, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[515811, 11275, 2122, 42, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[517970, 11322, 443, 7, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[518416, 11331, 2494, 51, 272, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[520947, 11387, 161, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[521111, 11391, 2297, 50, 312, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[523445, 11446, 161, 2, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}],
Cell[523609, 11450, 910, 18, 112, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10002.}]
}, Open  ]],
Cell[CellGroupData[{
Cell[524556, 11473, 214, 3, 29, "Text",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[524773, 11478, 1136, 29, 132, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[525970, 11514, 98, 1, 36, "Subsection"],
Cell[526071, 11517, 729, 17, 52, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[526849, 11540, 98, 1, 41, "Section"],
Cell[CellGroupData[{
Cell[526972, 11545, 108, 1, 36, "Subsection"],
Cell[527083, 11548, 396, 8, 65, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[527516, 11561, 352, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[527893, 11570, 2296, 44, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[530192, 11616, 2559, 52, 92, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[532800, 11674, 169, 2, 36, "Subsection"],
Cell[CellGroupData[{
Cell[532994, 11680, 103, 1, 27, "Subsubsection"],
Cell[533100, 11683, 622, 16, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[533759, 11704, 108, 1, 27, "Subsubsection"],
Cell[533870, 11707, 1092, 31, 112, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[535011, 11744, 107, 1, 36, "Subsection"],
Cell[535121, 11747, 910, 25, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[536068, 11777, 105, 1, 36, "Subsection"],
Cell[536176, 11780, 586, 16, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[536799, 11801, 103, 1, 36, "Subsection"],
Cell[536905, 11804, 2160, 54, 119, "Input"],
Cell[539068, 11860, 2030, 52, 119, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[541135, 11917, 102, 1, 36, "Subsection"],
Cell[541240, 11920, 2430, 59, 140, "Input"],
Cell[543673, 11981, 2332, 58, 140, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[546042, 12044, 96, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[546163, 12049, 161, 2, 27, "Subsubsection"],
Cell[546327, 12053, 1243, 28, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[547607, 12086, 114, 1, 27, "Subsubsection"],
Cell[547724, 12089, 979, 24, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[548740, 12118, 111, 1, 27, "Subsubsection"],
Cell[548854, 12121, 1401, 35, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[550292, 12161, 104, 1, 27, "Subsubsection"],
Cell[550399, 12164, 1415, 39, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[551851, 12208, 156, 2, 27, "Subsubsection"],
Cell[552010, 12212, 1465, 40, 96, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[553524, 12258, 94, 1, 36, "Subsection"],
Cell[553621, 12261, 1225, 25, 192, "Input"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
