% LCGT-SAS model
% Vertical
% Heatlink is anchored to PF
g=9.8;

%Seismic raw data
n=160;
fp=fopen('kamioka1.txt','r');
[Data,count]=fscanf(fp,'%f',[2,n]);
fclose(fp);
for I=1:n
    x(I)=10^(I/40-4+log10(20));
    y(I)=Data(2,I);
end
%Interpolation of data
N=10000;
for I=1:N
    freq(I)=I/N*20;
end
    seismic=interp1(x,y,freq);

% Filter1
w1=2*pi*0.2;
m1=120; %120
Q1=100;
k1=m1*w1^2;

% Filter2
w2=2*pi*0.2;
m2=m1;
Q2=100;
k2=m2*w2^2;

% PF
w3=2*pi*0.2;
m3=m1;
Q3=100;
k3=m3*w3^2;

% MB
w4=2*pi*1;
m4=60;
Q4=1000;
k4=m4*w4^2;

% IM
w5=2*pi*2;
m5=60;
Q5=1000;
k5=m5*w5^2;

C=530; % 530

% TM
E=4.7e11;
r=0.9e-3;
k6=(pi*r^2) /0.4 *E *4;
m6=30;
w6=sqrt(k6/m6);
Q6=1000;

% RM
w7=2*pi*4;
m7=30;
Q7=6; %6
k7=m7*w7^2;

% Heat Link
w8=2*pi*0.03; %0.03 (<1e-7 no effective)
m8=m3;
Q8=420; %420
k8=m8*w8^2;

%Equation of motion
for I=1:N
    w=2*pi*freq(I);
    M=[
    -m1*w^2 + K(m1,k1,w,Q1) + K(m2,k2,w,Q2), -K(m2,k2,w,Q2), 0, 0, 0, 0, 0
    -K(m2,k2,w,Q2), -m2*w^2 + K(m2,k2,w,Q2) + K(m3,k3,w,Q3), -K(m3,k3,w,Q3), 0, 0, 0, 0
    0, -K(m3,k3,w,Q3), -m3*w^2 + K(m3,k3,w,Q3) + K(m4,k4,w,Q4) + K(m5,k5,w,Q5) + K(m8,k8,w,Q8), -K(m4,k4,w,Q4), -K(m5,k5,w,Q5), 0, 0
    0, 0, -K(m4,k4,w,Q4), -m4*w^2 + K(m4,k4,w,Q4) + C*1i*w, -C*1i*w, 0, 0
    0, 0, -K(m5,k5,w,Q5), -C*1i*w, -m5*w^2 + K(m5,k5,w,Q5) + K(m6,k6,w,Q6) + K(m7,k7,w,Q7) + C*1i*w, -K(m6,k6,w,Q6), -K(m7,k7,w,Q7)
    0, 0, 0, 0, -K(m6,k6,w,Q6), -m6*w^2 + K(m6,k6,w,Q6), 0
    0, 0, 0, 0, -K(m7,k7,w,Q7), 0, -m7*w^2 + K(m7,k7,w,Q7)
    ];
    Xg=[K(m1,k1,w,Q1);0;K(m8,k8,w,Q8);0;0;0;0];
    X=M \ Xg;
    X6(I)=X(7);
    Gnd(I)=seismic(I)*0.00005/w;
    Disp(I)=seismic(I)*0.00005/w*abs(X(7));
end

figure(1);
subplot(3,1,[1 2]), loglog(freq,abs(X6)), xlabel('Frequency [Hz]'), ylabel('Amplitude'), grid on, grid minor,
 axis([0.01, 20, 1e-8, 10]), set(gca,'ytick',[1e-8 1e-7 1e-6 1e-5 1e-4 1e-3 1e-2 1e-1 1 10]);
 legend('X6/Xg');
subplot(3,1,3), semilogx(freq,angle(X6)*180/pi),
 xlabel('Frequency [Hz]'), ylabel('Phase [deg]'), grid on, grid minor, axis([0.01, 20, -180, 180]),
 set(gca,'ytick',[-180 -120 -60 0 60 120 180]);
figure(2);
 loglog(freq,Gnd,freq,Disp,'r'), xlabel('Frequency [Hz]'), ylabel('Displacement [m/rtHz]'),
 grid on, grid minor, axis([0.01, 20, 1e-22, 0.0001]), set(gca,'ytick',[1e-22 1e-20 1e-18 1e-16 1e-14 1e-12 1e-10 1e-8 1e-6 1e-4]);
 legend('Ground','Testmass');

fp=fopen('disp.txt','w');
fprintf(fp,'%e\n',Disp);
fclose(fp);
