#Import modules
import gtrace.beam as beam
import gtrace.optcomp as opt
from gtrace.draw import drawAllBeams, drawAllOptics
import sdxf
from unit import *
import numpy as np
pi = np.pi


#Prepare a DXF object
d = sdxf.Drawing()
d.layers.append(sdxf.Layer("main_beam", color=1))
d.layers.append(sdxf.Layer("main_beam_width", color=2))
d.layers.append(sdxf.Layer("aux_beam", color=3))
d.layers.append(sdxf.Layer("aux_beam_width", color=4))

#Define a mirror
M = opt.Mirror(HRcenter=[0,0], normAngleHR=0.0,
                 diameter=10*cm, thickness=6*cm,
                 wedgeAngle=deg2rad(3.25), inv_ROC_HR=1./(337.1*mm),
                 inv_ROC_AR=-1/(200*mm),
                 Refl_HR=0.9, Trans_HR=1-0.9,
                 Refl_AR=500*ppm, Trans_AR=1-500*ppm,
                 n=1.45, name='Mirror')

M.rotate(deg2rad(15))

#Define a source beam
b = beam.GaussianBeam(q0=1j*beam.w02zr(1*mm), pos=[2,-0.02], dirAngle=deg2rad(180.2))

#Hit the mirror with the beam
beams=M.hitFromHR(b, order=1)

#Draw the results
M.draw(d)
beams['input'].draw(d)
beams['s1'].draw(d)
beams['r1'].draw(d, drawROC=True, fontSize=0.01)
beams['t1'].length=2.0
beams['t1'].draw(d)
beams['s2'].draw(d)
beams['s3'].draw(d)
beams['r2'].length=2.0
beams['r2'].draw(d)
beams['t2'].length=2.0
beams['t2'].draw(d)

d.saveas('/home/aso/test.dxf')


