#{{{ Imports

import gtrace.beam as beam
import gtrace.optcomp as opt
import sdxf

#}}}

#{{{ Draw all beams

def drawAllBeams(d, beamList, drawWidth=True, drawPower=False,
                 drawROC=False, drawGouy=False, drawOptDist=False,
                    fontSize=0.01):
    
    for ii in range(len(beamList)):
        beamList[ii].draw(d, drawWidth=drawWidth, drawPower=drawPower,
                    drawROC=drawROC, drawGouy=drawGouy, drawOptDist=drawOptDist,
                    fontSize=fontSize)

#}}}

#{{{ Draw all optics
def drawAllOptics(d, opticsList, drawName=True):
    for ii in range(len(opticsList)):
        opticsList[ii].draw(d, drawName=drawName)

#}}}

#{{{ Translate all

def transAll(objList, transVect):
    for ii in range(len(objList)):
        objList[ii].translate(transVect)
#}}}

#{{{ Rotata all

def rotateAll(objList, angle, center):
    for ii in range(len(objList)):
        objList[ii].rotate(angle, center)
#}}}
