"""
gaussian - Gaussian Optics Module
"""

#{{{ Import modules
import numpy as np
pi = np.pi
sqrt = np.lib.scimath.sqrt

import enthought.etsconfig.api
enthought.etsconfig.api.ETSConfig.toolkit = 'wx'
from enthought.traits.api import HasTraits, Instance, Int, Float, Enum, Bool,\
     Trait, Callable, Button, Array, CInt, CFloat, List, Str
from enthought.traits.ui.api import View, Group, HGroup, VGroup, Item, Readonly, spring,\
     Label, Handler
from enthought.traits.ui.menu import Action, MenuBar, Menu, CloseAction
import enthought.traits.ui.file_dialog as file_dialog
from enthought.enable.api import ColorTrait
from enthought.enable.component_editor import ComponentEditor
from enthought.chaco.api import marker_trait, Plot, ArrayPlotData, Legend
from enthought.chaco.tools.api import LegendTool, PanTool, ZoomTool, RectZoomTool
from enthought.kiva.fonttools.font import Font

#}}}

#{{{ modeSpacing

def modeSpacing(g1, g2):
    return np.arccos(np.sqrt(g1*g2))/pi

#}}}

#{{{ Conversion functions

def qToRadius(q, wl=1064e-9):
    k = 2*pi/wl
    return sqrt(-2.0/(k*np.imag(1.0/q)))

def qToROC(q):
    return 1.0/np.real(1.0/q)

def ROCandWtoQ(ROC=1.0, w=1.0, wl=1064e-9):
    k = 2.0*pi/wl
    S = w**2 * k/2

    return 1.0/(1.0/ROC + 1.0/(1j*S))

#}}}
